# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from msrest import Serializer

from .._vendor import _format_url_section

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, IO, List, Optional, TypeVar, Union
    T = TypeVar('T')
    JSONType = Any
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_get_client_access_token_request(
    hub,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    user_id = kwargs.pop('user_id', None)  # type: Optional[str]
    roles = kwargs.pop('roles', None)  # type: Optional[List[str]]
    minutes_to_expire = kwargs.pop('minutes_to_expire', 60)  # type: Optional[int]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/:generateToken')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if user_id is not None:
        query_parameters['userId'] = _SERIALIZER.query("user_id", user_id, 'str')
    if roles is not None:
        query_parameters['role'] = [_SERIALIZER.query("roles", q, 'str') if q is not None else '' for q in roles]
    if minutes_to_expire is not None:
        query_parameters['minutesToExpire'] = _SERIALIZER.query("minutes_to_expire", minutes_to_expire, 'int')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_close_all_connections_request(
    hub,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]
    reason = kwargs.pop('reason', None)  # type: Optional[str]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/:closeConnections')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if excluded is not None:
        query_parameters['excluded'] = [_SERIALIZER.query("excluded", q, 'str') if q is not None else '' for q in excluded]
    if reason is not None:
        query_parameters['reason'] = _SERIALIZER.query("reason", reason, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_send_to_all_request(
    hub,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/:send')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if excluded is not None:
        query_parameters['excluded'] = [_SERIALIZER.query("excluded", q, 'str') if q is not None else '' for q in excluded]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_connection_exists_request(
    hub,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/connections/{connectionId}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "connectionId": _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="HEAD",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_close_connection_request(
    hub,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    reason = kwargs.pop('reason', None)  # type: Optional[str]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/connections/{connectionId}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "connectionId": _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if reason is not None:
        query_parameters['reason'] = _SERIALIZER.query("reason", reason, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_send_to_connection_request(
    hub,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/connections/{connectionId}/:send')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "connectionId": _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_group_exists_request(
    hub,  # type: str
    group,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/groups/{group}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "group": _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="HEAD",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_close_group_connections_request(
    hub,  # type: str
    group,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]
    reason = kwargs.pop('reason', None)  # type: Optional[str]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/groups/{group}/:closeConnections')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "group": _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if excluded is not None:
        query_parameters['excluded'] = [_SERIALIZER.query("excluded", q, 'str') if q is not None else '' for q in excluded]
    if reason is not None:
        query_parameters['reason'] = _SERIALIZER.query("reason", reason, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_send_to_group_request(
    hub,  # type: str
    group,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]
    excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/groups/{group}/:send')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "group": _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if excluded is not None:
        query_parameters['excluded'] = [_SERIALIZER.query("excluded", q, 'str') if q is not None else '' for q in excluded]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_add_connection_to_group_request(
    hub,  # type: str
    group,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/groups/{group}/connections/{connectionId}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "group": _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
        "connectionId": _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_remove_connection_from_group_request(
    hub,  # type: str
    group,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/groups/{group}/connections/{connectionId}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "group": _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
        "connectionId": _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_user_exists_request(
    hub,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "userId": _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="HEAD",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_close_user_connections_request(
    hub,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]
    reason = kwargs.pop('reason', None)  # type: Optional[str]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}/:closeConnections')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "userId": _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if excluded is not None:
        query_parameters['excluded'] = [_SERIALIZER.query("excluded", q, 'str') if q is not None else '' for q in excluded]
    if reason is not None:
        query_parameters['reason'] = _SERIALIZER.query("reason", reason, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_send_to_user_request(
    hub,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}/:send')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "userId": _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_add_user_to_group_request(
    hub,  # type: str
    group,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}/groups/{group}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "group": _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
        "userId": _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_remove_user_from_group_request(
    hub,  # type: str
    group,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}/groups/{group}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "group": _SERIALIZER.url("group", group, 'str', max_length=1024, min_length=1),
        "userId": _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_remove_user_from_all_groups_request(
    hub,  # type: str
    user_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/users/{userId}/groups')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "userId": _SERIALIZER.url("user_id", user_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_grant_permission_request(
    hub,  # type: str
    permission,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    target_name = kwargs.pop('target_name', None)  # type: Optional[str]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "permission": _SERIALIZER.url("permission", permission, 'str'),
        "connectionId": _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if target_name is not None:
        query_parameters['targetName'] = _SERIALIZER.query("target_name", target_name, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="PUT",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_revoke_permission_request(
    hub,  # type: str
    permission,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    target_name = kwargs.pop('target_name', None)  # type: Optional[str]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "permission": _SERIALIZER.url("permission", permission, 'str'),
        "connectionId": _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if target_name is not None:
        query_parameters['targetName'] = _SERIALIZER.query("target_name", target_name, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="DELETE",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )


def build_has_permission_request(
    hub,  # type: str
    permission,  # type: str
    connection_id,  # type: str
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
    target_name = kwargs.pop('target_name', None)  # type: Optional[str]

    accept = "application/json, text/json"
    # Construct URL
    url = kwargs.pop("template_url", '/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}')
    path_format_arguments = {
        "hub": _SERIALIZER.url("hub", hub, 'str', pattern=r'^[A-Za-z][A-Za-z0-9_`,.[\]]{0,127}$'),
        "permission": _SERIALIZER.url("permission", permission, 'str'),
        "connectionId": _SERIALIZER.url("connection_id", connection_id, 'str', min_length=1),
    }

    url = _format_url_section(url, **path_format_arguments)

    # Construct parameters
    query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    if target_name is not None:
        query_parameters['targetName'] = _SERIALIZER.query("target_name", target_name, 'str')
    query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="HEAD",
        url=url,
        params=query_parameters,
        headers=header_parameters,
        **kwargs
    )

# fmt: on
class WebPubSubServiceClientOperationsMixin(object):

    @distributed_trace
    def get_client_access_token(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> JSONType
        """Generate token for the client to connect Azure Web PubSub service.

        Generate token for the client to connect Azure Web PubSub service.

        :keyword user_id: User Id.
        :paramtype user_id: str
        :keyword roles: Roles that the connection with the generated token will have.
        :paramtype roles: list[str]
        :keyword minutes_to_expire: The expire time of the generated token.
        :paramtype minutes_to_expire: int
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: JSON object
        :rtype: JSONType
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "token": "str"  # Optional. The token value for the WebSocket client to connect to the service.
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[JSONType]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        user_id = kwargs.pop('user_id', None)  # type: Optional[str]
        roles = kwargs.pop('roles', None)  # type: Optional[List[str]]
        minutes_to_expire = kwargs.pop('minutes_to_expire', 60)  # type: Optional[int]


        request = build_get_client_access_token_request(
            hub=self._config.hub,
            api_version=api_version,
            user_id=user_id,
            roles=roles,
            minutes_to_expire=minutes_to_expire,
            template_url=self.get_client_access_token.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_client_access_token.metadata = {'url': '/api/hubs/{hub}/:generateToken'}  # type: ignore


    @distributed_trace
    def close_all_connections(
        self,
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Close the connections in the hub.

        Close the connections in the hub.

        :keyword excluded: Exclude these connectionIds when closing the connections in the hub.
        :paramtype excluded: list[str]
        :keyword reason: The reason closing the client connection.
        :paramtype reason: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]
        reason = kwargs.pop('reason', None)  # type: Optional[str]


        request = build_close_all_connections_request(
            hub=self._config.hub,
            api_version=api_version,
            excluded=excluded,
            reason=reason,
            template_url=self.close_all_connections.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    close_all_connections.metadata = {'url': '/api/hubs/{hub}/:closeConnections'}  # type: ignore


    @distributed_trace
    def send_to_all(
        self,
        message,  # type: Union[IO, str, JSONType]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Broadcast content inside request body to all the connected client connections.

        Broadcast content inside request body to all the connected client connections.

        :param message: The payload body.
        :type message: IO or str or JSONType
        :keyword excluded: Excluded connection Ids.
        :paramtype excluded: list[str]
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword str content_type: Media type of the body sent to the API. Default value is
         "application/json". Allowed values are: "application/json", "application/octet-stream",
         "text/plain."
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]

        json = None
        content = None
        if content_type.split(";")[0] in ['application/json']:
            json = message
        elif content_type.split(";")[0] in ['application/octet-stream', 'text/plain']:
            content = message
        else:
            raise ValueError(
                "The content_type '{}' is not one of the allowed values: "
                "['application/json', 'application/octet-stream', 'text/plain']".format(content_type)
            )

        request = build_send_to_all_request(
            hub=self._config.hub,
            api_version=api_version,
            content_type=content_type,
            json=json,
            content=content,
            excluded=excluded,
            template_url=self.send_to_all.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    send_to_all.metadata = {'url': '/api/hubs/{hub}/:send'}  # type: ignore


    @distributed_trace
    def connection_exists(
        self,
        connection_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> bool
        """Check if the connection with the given connectionId exists.

        Check if the connection with the given connectionId exists.

        :param connection_id: The connection Id.
        :type connection_id: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: bool
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str


        request = build_connection_exists_request(
            hub=self._config.hub,
            connection_id=connection_id,
            api_version=api_version,
            template_url=self.connection_exists.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    connection_exists.metadata = {'url': '/api/hubs/{hub}/connections/{connectionId}'}  # type: ignore


    @distributed_trace
    def close_connection(
        self,
        connection_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Close the client connection.

        Close the client connection.

        :param connection_id: Target connection Id.
        :type connection_id: str
        :keyword reason: The reason closing the client connection.
        :paramtype reason: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        reason = kwargs.pop('reason', None)  # type: Optional[str]


        request = build_close_connection_request(
            hub=self._config.hub,
            connection_id=connection_id,
            api_version=api_version,
            reason=reason,
            template_url=self.close_connection.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    close_connection.metadata = {'url': '/api/hubs/{hub}/connections/{connectionId}'}  # type: ignore


    @distributed_trace
    def send_to_connection(
        self,
        connection_id,  # type: str
        message,  # type: Union[IO, str, JSONType]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Send content inside request body to the specific connection.

        Send content inside request body to the specific connection.

        :param connection_id: The connection Id.
        :type connection_id: str
        :param message: The payload body.
        :type message: IO or str or JSONType
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword str content_type: Media type of the body sent to the API. Default value is
         "application/json". Allowed values are: "application/json", "application/octet-stream",
         "text/plain."
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = None
        content = None
        if content_type.split(";")[0] in ['application/json']:
            json = message
        elif content_type.split(";")[0] in ['application/octet-stream', 'text/plain']:
            content = message
        else:
            raise ValueError(
                "The content_type '{}' is not one of the allowed values: "
                "['application/json', 'application/octet-stream', 'text/plain']".format(content_type)
            )

        request = build_send_to_connection_request(
            hub=self._config.hub,
            connection_id=connection_id,
            api_version=api_version,
            content_type=content_type,
            json=json,
            content=content,
            template_url=self.send_to_connection.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    send_to_connection.metadata = {'url': '/api/hubs/{hub}/connections/{connectionId}/:send'}  # type: ignore


    @distributed_trace
    def group_exists(
        self,
        group,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> bool
        """Check if there are any client connections inside the given group.

        Check if there are any client connections inside the given group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
        :type group: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: bool
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str


        request = build_group_exists_request(
            hub=self._config.hub,
            group=group,
            api_version=api_version,
            template_url=self.group_exists.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    group_exists.metadata = {'url': '/api/hubs/{hub}/groups/{group}'}  # type: ignore


    @distributed_trace
    def close_group_connections(
        self,
        group,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Close connections in the specific group.

        Close connections in the specific group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
        :type group: str
        :keyword excluded: Exclude these connectionIds when closing the connections in the group.
        :paramtype excluded: list[str]
        :keyword reason: The reason closing the client connection.
        :paramtype reason: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]
        reason = kwargs.pop('reason', None)  # type: Optional[str]


        request = build_close_group_connections_request(
            hub=self._config.hub,
            group=group,
            api_version=api_version,
            excluded=excluded,
            reason=reason,
            template_url=self.close_group_connections.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    close_group_connections.metadata = {'url': '/api/hubs/{hub}/groups/{group}/:closeConnections'}  # type: ignore


    @distributed_trace
    def send_to_group(
        self,
        group,  # type: str
        message,  # type: Union[IO, str, JSONType]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Send content inside request body to a group of connections.

        Send content inside request body to a group of connections.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
        :type group: str
        :param message: The payload body.
        :type message: IO or str or JSONType
        :keyword excluded: Excluded connection Ids.
        :paramtype excluded: list[str]
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword str content_type: Media type of the body sent to the API. Default value is
         "application/json". Allowed values are: "application/json", "application/octet-stream",
         "text/plain."
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]
        excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]

        json = None
        content = None
        if content_type.split(";")[0] in ['application/json']:
            json = message
        elif content_type.split(";")[0] in ['application/octet-stream', 'text/plain']:
            content = message
        else:
            raise ValueError(
                "The content_type '{}' is not one of the allowed values: "
                "['application/json', 'application/octet-stream', 'text/plain']".format(content_type)
            )

        request = build_send_to_group_request(
            hub=self._config.hub,
            group=group,
            api_version=api_version,
            content_type=content_type,
            json=json,
            content=content,
            excluded=excluded,
            template_url=self.send_to_group.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    send_to_group.metadata = {'url': '/api/hubs/{hub}/groups/{group}/:send'}  # type: ignore


    @distributed_trace
    def add_connection_to_group(
        self,
        group,  # type: str
        connection_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Add a connection to the target group.

        Add a connection to the target group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
        :type group: str
        :param connection_id: Target connection Id.
        :type connection_id: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str


        request = build_add_connection_to_group_request(
            hub=self._config.hub,
            group=group,
            connection_id=connection_id,
            api_version=api_version,
            template_url=self.add_connection_to_group.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    add_connection_to_group.metadata = {'url': '/api/hubs/{hub}/groups/{group}/connections/{connectionId}'}  # type: ignore


    @distributed_trace
    def remove_connection_from_group(
        self,
        group,  # type: str
        connection_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Remove a connection from the target group.

        Remove a connection from the target group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
        :type group: str
        :param connection_id: Target connection Id.
        :type connection_id: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str


        request = build_remove_connection_from_group_request(
            hub=self._config.hub,
            group=group,
            connection_id=connection_id,
            api_version=api_version,
            template_url=self.remove_connection_from_group.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    remove_connection_from_group.metadata = {'url': '/api/hubs/{hub}/groups/{group}/connections/{connectionId}'}  # type: ignore


    @distributed_trace
    def user_exists(
        self,
        user_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> bool
        """Check if there are any client connections connected for the given user.

        Check if there are any client connections connected for the given user.

        :param user_id: Target user Id.
        :type user_id: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: bool
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str


        request = build_user_exists_request(
            hub=self._config.hub,
            user_id=user_id,
            api_version=api_version,
            template_url=self.user_exists.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    user_exists.metadata = {'url': '/api/hubs/{hub}/users/{userId}'}  # type: ignore


    @distributed_trace
    def close_user_connections(
        self,
        user_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Close connections for the specific user.

        Close connections for the specific user.

        :param user_id: The user Id.
        :type user_id: str
        :keyword excluded: Exclude these connectionIds when closing the connections for the user.
        :paramtype excluded: list[str]
        :keyword reason: The reason closing the client connection.
        :paramtype reason: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        excluded = kwargs.pop('excluded', None)  # type: Optional[List[str]]
        reason = kwargs.pop('reason', None)  # type: Optional[str]


        request = build_close_user_connections_request(
            hub=self._config.hub,
            user_id=user_id,
            api_version=api_version,
            excluded=excluded,
            reason=reason,
            template_url=self.close_user_connections.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    close_user_connections.metadata = {'url': '/api/hubs/{hub}/users/{userId}/:closeConnections'}  # type: ignore


    @distributed_trace
    def send_to_user(
        self,
        user_id,  # type: str
        message,  # type: Union[IO, str, JSONType]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Send content inside request body to the specific user.

        Send content inside request body to the specific user.

        :param user_id: The user Id.
        :type user_id: str
        :param message: The payload body.
        :type message: IO or str or JSONType
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :keyword str content_type: Media type of the body sent to the API. Default value is
         "application/json". Allowed values are: "application/json", "application/octet-stream",
         "text/plain."
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = None
        content = None
        if content_type.split(";")[0] in ['application/json']:
            json = message
        elif content_type.split(";")[0] in ['application/octet-stream', 'text/plain']:
            content = message
        else:
            raise ValueError(
                "The content_type '{}' is not one of the allowed values: "
                "['application/json', 'application/octet-stream', 'text/plain']".format(content_type)
            )

        request = build_send_to_user_request(
            hub=self._config.hub,
            user_id=user_id,
            api_version=api_version,
            content_type=content_type,
            json=json,
            content=content,
            template_url=self.send_to_user.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    send_to_user.metadata = {'url': '/api/hubs/{hub}/users/{userId}/:send'}  # type: ignore


    @distributed_trace
    def add_user_to_group(
        self,
        group,  # type: str
        user_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Add a user to the target group.

        Add a user to the target group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
        :type group: str
        :param user_id: Target user Id.
        :type user_id: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str


        request = build_add_user_to_group_request(
            hub=self._config.hub,
            group=group,
            user_id=user_id,
            api_version=api_version,
            template_url=self.add_user_to_group.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    add_user_to_group.metadata = {'url': '/api/hubs/{hub}/users/{userId}/groups/{group}'}  # type: ignore


    @distributed_trace
    def remove_user_from_group(
        self,
        group,  # type: str
        user_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Remove a user from the target group.

        Remove a user from the target group.

        :param group: Target group name, which length should be greater than 0 and less than 1025.
        :type group: str
        :param user_id: Target user Id.
        :type user_id: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str


        request = build_remove_user_from_group_request(
            hub=self._config.hub,
            group=group,
            user_id=user_id,
            api_version=api_version,
            template_url=self.remove_user_from_group.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    remove_user_from_group.metadata = {'url': '/api/hubs/{hub}/users/{userId}/groups/{group}'}  # type: ignore


    @distributed_trace
    def remove_user_from_all_groups(
        self,
        user_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Remove a user from all groups.

        Remove a user from all groups.

        :param user_id: Target user Id.
        :type user_id: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str


        request = build_remove_user_from_all_groups_request(
            hub=self._config.hub,
            user_id=user_id,
            api_version=api_version,
            template_url=self.remove_user_from_all_groups.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    remove_user_from_all_groups.metadata = {'url': '/api/hubs/{hub}/users/{userId}/groups'}  # type: ignore


    @distributed_trace
    def grant_permission(
        self,
        permission,  # type: str
        connection_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Grant permission to the connection.

        Grant permission to the connection.

        :param permission: The permission: current supported actions are joinLeaveGroup and
         sendToGroup. Possible values are: "sendToGroup" or "joinLeaveGroup".
        :type permission: str
        :param connection_id: Target connection Id.
        :type connection_id: str
        :keyword target_name: The meaning of the target depends on the specific permission. For
         joinLeaveGroup and sendToGroup, targetName is a required parameter standing for the group name.
        :paramtype target_name: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        target_name = kwargs.pop('target_name', None)  # type: Optional[str]


        request = build_grant_permission_request(
            hub=self._config.hub,
            permission=permission,
            connection_id=connection_id,
            api_version=api_version,
            target_name=target_name,
            template_url=self.grant_permission.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    grant_permission.metadata = {'url': '/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}'}  # type: ignore


    @distributed_trace
    def revoke_permission(
        self,
        permission,  # type: str
        connection_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Revoke permission for the connection.

        Revoke permission for the connection.

        :param permission: The permission: current supported actions are joinLeaveGroup and
         sendToGroup. Possible values are: "sendToGroup" or "joinLeaveGroup".
        :type permission: str
        :param connection_id: Target connection Id.
        :type connection_id: str
        :keyword target_name: The meaning of the target depends on the specific permission. For
         joinLeaveGroup and sendToGroup, targetName is a required parameter standing for the group name.
        :paramtype target_name: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        target_name = kwargs.pop('target_name', None)  # type: Optional[str]


        request = build_revoke_permission_request(
            hub=self._config.hub,
            permission=permission,
            connection_id=connection_id,
            api_version=api_version,
            target_name=target_name,
            template_url=self.revoke_permission.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    revoke_permission.metadata = {'url': '/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}'}  # type: ignore


    @distributed_trace
    def has_permission(
        self,
        permission,  # type: str
        connection_id,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> bool
        """Check if a connection has permission to the specified action.

        Check if a connection has permission to the specified action.

        :param permission: The permission: current supported actions are joinLeaveGroup and
         sendToGroup. Possible values are: "sendToGroup" or "joinLeaveGroup".
        :type permission: str
        :param connection_id: Target connection Id.
        :type connection_id: str
        :keyword target_name: The meaning of the target depends on the specific permission. For
         joinLeaveGroup and sendToGroup, targetName is a required parameter standing for the group name.
        :paramtype target_name: str
        :keyword api_version: Api Version. The default value is "2021-10-01". Note that overriding this
         default value may result in unsupported behavior.
        :paramtype api_version: str
        :return: bool
        :rtype: bool
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2021-10-01")  # type: str
        target_name = kwargs.pop('target_name', None)  # type: Optional[str]


        request = build_has_permission_request(
            hub=self._config.hub,
            permission=permission,
            connection_id=connection_id,
            api_version=api_version,
            target_name=target_name,
            template_url=self.has_permission.metadata['url'],
        )
        path_format_arguments = {
            "Endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 404]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})
        return 200 <= response.status_code <= 299

    has_permission.metadata = {'url': '/api/hubs/{hub}/permissions/{permission}/connections/{connectionId}'}  # type: ignore

