/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.servletunit;

import com.meterware.httpunit.HttpUnitUtils;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;

class RequestContext {
    private Hashtable _parameters = new Hashtable();
    private Hashtable _visibleParameters;
    private HttpServletRequest _parentRequest;
    private URL _url;
    private static final int STATE_INITIAL = 0;
    private static final int STATE_HAVE_NAME = 1;
    private static final int STATE_HAVE_EQUALS = 2;
    private static final int STATE_HAVE_VALUE = 3;

    RequestContext(URL url) {
        this._url = url;
        String file = this._url.getFile();
        if (file.indexOf(63) >= 0) {
            this.loadParameters(file.substring(file.indexOf(63) + 1));
        }
    }

    void setParentRequest(HttpServletRequest parentRequest) {
        this._parentRequest = parentRequest;
        this._visibleParameters = null;
    }

    String getRequestURI() {
        return this._url.getPath();
    }

    String getParameter(String name) {
        String[] parameters = (String[])this.getParameters().get(name);
        return parameters == null ? null : parameters[0];
    }

    Enumeration getParameterNames() {
        return this.getParameters().keys();
    }

    Map getParameterMap() {
        return (Map)this.getParameters().clone();
    }

    String[] getParameterValues(String name) {
        return (String[])this.getParameters().get(name);
    }

    void loadParameters(String queryString) {
        if (queryString.length() == 0) {
            return;
        }
        StringTokenizer st = new StringTokenizer(queryString, "&=", true);
        int state = 0;
        String name = null;
        String value = null;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.equals("&")) {
                state = 0;
                if (name != null && value != null) {
                    this.addParameter(name, value);
                }
                value = null;
                name = null;
                continue;
            }
            if (token.equals("=")) {
                if (state == 1) {
                    state = 2;
                    continue;
                }
                if (state != 3) continue;
                state = 0;
                continue;
            }
            if (state == 0) {
                name = HttpUnitUtils.decode(token);
                value = "";
                state = 1;
                continue;
            }
            value = HttpUnitUtils.decode(token);
            state = 3;
        }
        if (name != null && value != null) {
            this.addParameter(name, value);
        }
    }

    private void addParameter(String name, String encodedValue) {
        String[] values = (String[])this._parameters.get(name);
        this._visibleParameters = null;
        if (values == null) {
            this._parameters.put(name, new String[]{encodedValue});
        } else {
            this._parameters.put(name, RequestContext.extendedArray(values, encodedValue));
        }
    }

    private static String[] extendedArray(String[] baseArray, String newValue) {
        String[] result = new String[baseArray.length + 1];
        System.arraycopy(baseArray, 0, result, 0, baseArray.length);
        result[baseArray.length] = newValue;
        return result;
    }

    private Hashtable getParameters() {
        if (this._visibleParameters == null) {
            if (this._parentRequest == null) {
                this._visibleParameters = this._parameters;
            } else {
                this._visibleParameters = new Hashtable();
                Map parameterMap = this._parentRequest.getParameterMap();
                Iterator i = parameterMap.keySet().iterator();
                while (i.hasNext()) {
                    Object key = i.next();
                    this._visibleParameters.put(key, parameterMap.get(key));
                }
                Enumeration e = this._parameters.keys();
                while (e.hasMoreElements()) {
                    Object key = e.nextElement();
                    this._visibleParameters.put(key, this._parameters.get(key));
                }
            }
        }
        return this._visibleParameters;
    }

    static {
        STATE_INITIAL = 0;
        STATE_HAVE_NAME = 1;
        STATE_HAVE_EQUALS = 2;
        STATE_HAVE_VALUE = 3;
    }
}

