An underscore `_` character has been used as the identifier for a lifetime.

Erroneous example:
```compile_fail,E0106,E0637
fn longest<'_>(str1: &'_ str, str2: &'_ str) -> &'_ str {
         //^^ `'_` is a reserved lifetime name
    if str1.len() > str2.len() {
        str1
    } else {
        str2
    }
}
```
`'_`, cannot be used as a lifetime identifier because it is a reserved for the
anonymous lifetime. To fix this, use a lowercase letter such as 'a, or a series
of lowercase letters such as `'foo`.  For more information, see [the
book][bk-no].  For more information on using the anonymous lifetime in rust
nightly, see [the nightly book][bk-al].

Corrected example:
```
fn longest<'a>(str1: &'a str, str2: &'a str) -> &'a str {
    if str1.len() > str2.len() {
        str1
    } else {
        str2
    }
}
```

[bk-no]: https://doc.rust-lang.org/book/appendix-02-operators.html#non-operator-symbols
[bk-al]: https://doc.rust-lang.org/nightly/edition-guide/rust-2018/ownership-and-lifetimes/the-anonymous-lifetime.html
