// Copyright 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License"). You may not
// use this file except in compliance with the License. A copy of the
// License is located at
//
// http://aws.amazon.com/apache2.0/
//
// or in the "license" file accompanying this file. This file is distributed
// on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
// either express or implied. See the License for the specific language governing
// permissions and limitations under the License.

package identity

import (
	"github.com/stretchr/testify/mock"
)

// iAgentIdentitySelectorMock is an autogenerated mock type for the IAgentIdentitySelector type - to test
type iAgentIdentitySelectorMock struct {
	mock.Mock
}

// selectAgentIdentity provides a mock function with given fields: _a0, _a1
func (_m *iAgentIdentitySelectorMock) selectAgentIdentity(_a0 []IAgentIdentityInner, _a1 string) IAgentIdentityInner {
	ret := _m.Called(_a0, _a1)

	var r0 IAgentIdentityInner
	if rf, ok := ret.Get(0).(func([]IAgentIdentityInner, string) IAgentIdentityInner); ok {
		r0 = rf(_a0, _a1)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(IAgentIdentityInner)
		}
	}

	return r0
}
