// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>Provides information about the role credentials that are assigned to the user.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct RoleCredentials {
    /// <p>The identifier used for the temporary security credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub access_key_id: ::std::option::Option<::std::string::String>,
    /// <p>The key that is used to sign the request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub secret_access_key: ::std::option::Option<::std::string::String>,
    /// <p>The token used for temporary credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub session_token: ::std::option::Option<::std::string::String>,
    /// <p>The date on which temporary security credentials expire.</p>
    pub expiration: i64,
}
impl RoleCredentials {
    /// <p>The identifier used for the temporary security credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn access_key_id(&self) -> ::std::option::Option<&str> {
        self.access_key_id.as_deref()
    }
    /// <p>The key that is used to sign the request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn secret_access_key(&self) -> ::std::option::Option<&str> {
        self.secret_access_key.as_deref()
    }
    /// <p>The token used for temporary credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn session_token(&self) -> ::std::option::Option<&str> {
        self.session_token.as_deref()
    }
    /// <p>The date on which temporary security credentials expire.</p>
    pub fn expiration(&self) -> i64 {
        self.expiration
    }
}
impl ::std::fmt::Debug for RoleCredentials {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("RoleCredentials");
        formatter.field("access_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("secret_access_key", &"*** Sensitive Data Redacted ***");
        formatter.field("session_token", &"*** Sensitive Data Redacted ***");
        formatter.field("expiration", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
impl RoleCredentials {
    /// Creates a new builder-style object to manufacture [`RoleCredentials`](crate::types::RoleCredentials).
    pub fn builder() -> crate::types::builders::RoleCredentialsBuilder {
        crate::types::builders::RoleCredentialsBuilder::default()
    }
}

/// A builder for [`RoleCredentials`](crate::types::RoleCredentials).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
pub struct RoleCredentialsBuilder {
    pub(crate) access_key_id: ::std::option::Option<::std::string::String>,
    pub(crate) secret_access_key: ::std::option::Option<::std::string::String>,
    pub(crate) session_token: ::std::option::Option<::std::string::String>,
    pub(crate) expiration: ::std::option::Option<i64>,
}
impl RoleCredentialsBuilder {
    /// <p>The identifier used for the temporary security credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn access_key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.access_key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The identifier used for the temporary security credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn set_access_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.access_key_id = input;
        self
    }
    /// <p>The identifier used for the temporary security credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn get_access_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.access_key_id
    }
    /// <p>The key that is used to sign the request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn secret_access_key(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.secret_access_key = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The key that is used to sign the request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn set_secret_access_key(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.secret_access_key = input;
        self
    }
    /// <p>The key that is used to sign the request. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn get_secret_access_key(&self) -> &::std::option::Option<::std::string::String> {
        &self.secret_access_key
    }
    /// <p>The token used for temporary credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn session_token(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.session_token = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The token used for temporary credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn set_session_token(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.session_token = input;
        self
    }
    /// <p>The token used for temporary credentials. For more information, see <a href="https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_use-resources.html">Using Temporary Security Credentials to Request Access to AWS Resources</a> in the <i>AWS IAM User Guide</i>.</p>
    pub fn get_session_token(&self) -> &::std::option::Option<::std::string::String> {
        &self.session_token
    }
    /// <p>The date on which temporary security credentials expire.</p>
    pub fn expiration(mut self, input: i64) -> Self {
        self.expiration = ::std::option::Option::Some(input);
        self
    }
    /// <p>The date on which temporary security credentials expire.</p>
    pub fn set_expiration(mut self, input: ::std::option::Option<i64>) -> Self {
        self.expiration = input;
        self
    }
    /// <p>The date on which temporary security credentials expire.</p>
    pub fn get_expiration(&self) -> &::std::option::Option<i64> {
        &self.expiration
    }
    /// Consumes the builder and constructs a [`RoleCredentials`](crate::types::RoleCredentials).
    pub fn build(self) -> crate::types::RoleCredentials {
        crate::types::RoleCredentials {
            access_key_id: self.access_key_id,
            secret_access_key: self.secret_access_key,
            session_token: self.session_token,
            expiration: self.expiration.unwrap_or_default(),
        }
    }
}
impl ::std::fmt::Debug for RoleCredentialsBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("RoleCredentialsBuilder");
        formatter.field("access_key_id", &"*** Sensitive Data Redacted ***");
        formatter.field("secret_access_key", &"*** Sensitive Data Redacted ***");
        formatter.field("session_token", &"*** Sensitive Data Redacted ***");
        formatter.field("expiration", &"*** Sensitive Data Redacted ***");
        formatter.finish()
    }
}
