// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct UpdatePrimaryRegionInput {
    /// <p>Identifies the current primary key. When the operation completes, this KMS key will be a replica key.</p>
    /// <p>Specify the key ID or key ARN of a multi-Region primary key.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// <li>
    /// <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    pub key_id: ::std::option::Option<::std::string::String>,
    /// <p>The Amazon Web Services Region of the new primary key. Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. There must be an existing replica key in this Region.</p>
    /// <p>When the operation completes, the multi-Region key in this Region will be the primary key.</p>
    pub primary_region: ::std::option::Option<::std::string::String>,
}
impl UpdatePrimaryRegionInput {
    /// <p>Identifies the current primary key. When the operation completes, this KMS key will be a replica key.</p>
    /// <p>Specify the key ID or key ARN of a multi-Region primary key.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// <li>
    /// <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    pub fn key_id(&self) -> ::std::option::Option<&str> {
        self.key_id.as_deref()
    }
    /// <p>The Amazon Web Services Region of the new primary key. Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. There must be an existing replica key in this Region.</p>
    /// <p>When the operation completes, the multi-Region key in this Region will be the primary key.</p>
    pub fn primary_region(&self) -> ::std::option::Option<&str> {
        self.primary_region.as_deref()
    }
}
impl UpdatePrimaryRegionInput {
    /// Creates a new builder-style object to manufacture [`UpdatePrimaryRegionInput`](crate::operation::update_primary_region::UpdatePrimaryRegionInput).
    pub fn builder() -> crate::operation::update_primary_region::builders::UpdatePrimaryRegionInputBuilder {
        crate::operation::update_primary_region::builders::UpdatePrimaryRegionInputBuilder::default()
    }
}

/// A builder for [`UpdatePrimaryRegionInput`](crate::operation::update_primary_region::UpdatePrimaryRegionInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
pub struct UpdatePrimaryRegionInputBuilder {
    pub(crate) key_id: ::std::option::Option<::std::string::String>,
    pub(crate) primary_region: ::std::option::Option<::std::string::String>,
}
impl UpdatePrimaryRegionInputBuilder {
    /// <p>Identifies the current primary key. When the operation completes, this KMS key will be a replica key.</p>
    /// <p>Specify the key ID or key ARN of a multi-Region primary key.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// <li>
    /// <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    /// This field is required.
    pub fn key_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Identifies the current primary key. When the operation completes, this KMS key will be a replica key.</p>
    /// <p>Specify the key ID or key ARN of a multi-Region primary key.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// <li>
    /// <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    pub fn set_key_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key_id = input;
        self
    }
    /// <p>Identifies the current primary key. When the operation completes, this KMS key will be a replica key.</p>
    /// <p>Specify the key ID or key ARN of a multi-Region primary key.</p>
    /// <p>For example:</p>
    /// <ul>
    /// <li>
    /// <p>Key ID: <code>mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// <li>
    /// <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab</code></p></li>
    /// </ul>
    /// <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>.</p>
    pub fn get_key_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.key_id
    }
    /// <p>The Amazon Web Services Region of the new primary key. Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. There must be an existing replica key in this Region.</p>
    /// <p>When the operation completes, the multi-Region key in this Region will be the primary key.</p>
    /// This field is required.
    pub fn primary_region(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.primary_region = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The Amazon Web Services Region of the new primary key. Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. There must be an existing replica key in this Region.</p>
    /// <p>When the operation completes, the multi-Region key in this Region will be the primary key.</p>
    pub fn set_primary_region(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.primary_region = input;
        self
    }
    /// <p>The Amazon Web Services Region of the new primary key. Enter the Region ID, such as <code>us-east-1</code> or <code>ap-southeast-2</code>. There must be an existing replica key in this Region.</p>
    /// <p>When the operation completes, the multi-Region key in this Region will be the primary key.</p>
    pub fn get_primary_region(&self) -> &::std::option::Option<::std::string::String> {
        &self.primary_region
    }
    /// Consumes the builder and constructs a [`UpdatePrimaryRegionInput`](crate::operation::update_primary_region::UpdatePrimaryRegionInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::update_primary_region::UpdatePrimaryRegionInput, ::aws_smithy_types::error::operation::BuildError>
    {
        ::std::result::Result::Ok(crate::operation::update_primary_region::UpdatePrimaryRegionInput {
            key_id: self.key_id,
            primary_region: self.primary_region,
        })
    }
}
