// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq)]
pub struct UpdateCustomKeyStoreInput {
    /// <p>Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    pub custom_key_store_id: ::std::option::Option<::std::string::String>,
    /// <p>Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.</p><important>
    /// <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p>
    /// </important>
    /// <p>To change this value, an CloudHSM key store must be disconnected. An external key store can be connected or disconnected.</p>
    pub new_custom_key_store_name: ::std::option::Option<::std::string::String>,
    /// <p>Enter the current password of the <code>kmsuser</code> crypto user (CU) in the CloudHSM cluster that is associated with the custom key store. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>This parameter tells KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub key_store_password: ::std::option::Option<::std::string::String>,
    /// <p>Associates the custom key store with a related CloudHSM cluster. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub cloud_hsm_cluster_id: ::std::option::Option<::std::string::String>,
    /// <p>Changes the URI endpoint that KMS uses to connect to your external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>PUBLIC_ENDPOINT</code>, the protocol must be HTTPS.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>VPC_ENDPOINT_SERVICE</code>, specify <code>https://</code> followed by the private DNS name associated with the VPC endpoint service. Each external key store must use a different private DNS name.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub xks_proxy_uri_endpoint: ::std::option::Option<::std::string::String>,
    /// <p>Changes the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key manager and external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>The value must start with <code>/</code> and must end with <code>/kms/xks/v1</code>, where <code>v1</code> represents the version of the KMS external key store proxy API. You can include an optional prefix between the required elements such as <code>/<i>example</i>/kms/xks/v1</code>.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub xks_proxy_uri_path: ::std::option::Option<::std::string::String>,
    /// <p>Changes the name that KMS uses to identify the Amazon VPC endpoint service for your external key store proxy (XKS proxy). This parameter is valid when the <code>CustomKeyStoreType</code> is <code>EXTERNAL_KEY_STORE</code> and the <code>XksProxyConnectivity</code> is <code>VPC_ENDPOINT_SERVICE</code>.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub xks_proxy_vpc_endpoint_service_name: ::std::option::Option<::std::string::String>,
    /// <p>Changes the credentials that KMS uses to sign requests to the external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>You must specify both the <code>AccessKeyId</code> and <code>SecretAccessKey</code> value in the authentication credential, even if you are only updating one value.</p>
    /// <p>This parameter doesn't establish or change your authentication credentials on the proxy. It just tells KMS the credential that you established with your external key store proxy. For example, if you rotate the credential on your external key store proxy, you can use this parameter to update the credential in KMS.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub xks_proxy_authentication_credential: ::std::option::Option<crate::types::XksProxyAuthenticationCredentialType>,
    /// <p>Changes the connectivity setting for the external key store. To indicate that the external key store proxy uses a Amazon VPC endpoint service to communicate with KMS, specify <code>VPC_ENDPOINT_SERVICE</code>. Otherwise, specify <code>PUBLIC_ENDPOINT</code>.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>VPC_ENDPOINT_SERVICE</code>, you must also change the <code>XksProxyUriEndpoint</code> and add an <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>PUBLIC_ENDPOINT</code>, you must also change the <code>XksProxyUriEndpoint</code> and specify a null or empty string for the <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub xks_proxy_connectivity: ::std::option::Option<crate::types::XksProxyConnectivityType>,
}
impl UpdateCustomKeyStoreInput {
    /// <p>Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    pub fn custom_key_store_id(&self) -> ::std::option::Option<&str> {
        self.custom_key_store_id.as_deref()
    }
    /// <p>Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.</p><important>
    /// <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p>
    /// </important>
    /// <p>To change this value, an CloudHSM key store must be disconnected. An external key store can be connected or disconnected.</p>
    pub fn new_custom_key_store_name(&self) -> ::std::option::Option<&str> {
        self.new_custom_key_store_name.as_deref()
    }
    /// <p>Enter the current password of the <code>kmsuser</code> crypto user (CU) in the CloudHSM cluster that is associated with the custom key store. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>This parameter tells KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub fn key_store_password(&self) -> ::std::option::Option<&str> {
        self.key_store_password.as_deref()
    }
    /// <p>Associates the custom key store with a related CloudHSM cluster. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub fn cloud_hsm_cluster_id(&self) -> ::std::option::Option<&str> {
        self.cloud_hsm_cluster_id.as_deref()
    }
    /// <p>Changes the URI endpoint that KMS uses to connect to your external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>PUBLIC_ENDPOINT</code>, the protocol must be HTTPS.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>VPC_ENDPOINT_SERVICE</code>, specify <code>https://</code> followed by the private DNS name associated with the VPC endpoint service. Each external key store must use a different private DNS name.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn xks_proxy_uri_endpoint(&self) -> ::std::option::Option<&str> {
        self.xks_proxy_uri_endpoint.as_deref()
    }
    /// <p>Changes the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key manager and external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>The value must start with <code>/</code> and must end with <code>/kms/xks/v1</code>, where <code>v1</code> represents the version of the KMS external key store proxy API. You can include an optional prefix between the required elements such as <code>/<i>example</i>/kms/xks/v1</code>.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub fn xks_proxy_uri_path(&self) -> ::std::option::Option<&str> {
        self.xks_proxy_uri_path.as_deref()
    }
    /// <p>Changes the name that KMS uses to identify the Amazon VPC endpoint service for your external key store proxy (XKS proxy). This parameter is valid when the <code>CustomKeyStoreType</code> is <code>EXTERNAL_KEY_STORE</code> and the <code>XksProxyConnectivity</code> is <code>VPC_ENDPOINT_SERVICE</code>.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn xks_proxy_vpc_endpoint_service_name(&self) -> ::std::option::Option<&str> {
        self.xks_proxy_vpc_endpoint_service_name.as_deref()
    }
    /// <p>Changes the credentials that KMS uses to sign requests to the external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>You must specify both the <code>AccessKeyId</code> and <code>SecretAccessKey</code> value in the authentication credential, even if you are only updating one value.</p>
    /// <p>This parameter doesn't establish or change your authentication credentials on the proxy. It just tells KMS the credential that you established with your external key store proxy. For example, if you rotate the credential on your external key store proxy, you can use this parameter to update the credential in KMS.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub fn xks_proxy_authentication_credential(&self) -> ::std::option::Option<&crate::types::XksProxyAuthenticationCredentialType> {
        self.xks_proxy_authentication_credential.as_ref()
    }
    /// <p>Changes the connectivity setting for the external key store. To indicate that the external key store proxy uses a Amazon VPC endpoint service to communicate with KMS, specify <code>VPC_ENDPOINT_SERVICE</code>. Otherwise, specify <code>PUBLIC_ENDPOINT</code>.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>VPC_ENDPOINT_SERVICE</code>, you must also change the <code>XksProxyUriEndpoint</code> and add an <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>PUBLIC_ENDPOINT</code>, you must also change the <code>XksProxyUriEndpoint</code> and specify a null or empty string for the <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn xks_proxy_connectivity(&self) -> ::std::option::Option<&crate::types::XksProxyConnectivityType> {
        self.xks_proxy_connectivity.as_ref()
    }
}
impl ::std::fmt::Debug for UpdateCustomKeyStoreInput {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomKeyStoreInput");
        formatter.field("custom_key_store_id", &self.custom_key_store_id);
        formatter.field("new_custom_key_store_name", &self.new_custom_key_store_name);
        formatter.field("key_store_password", &"*** Sensitive Data Redacted ***");
        formatter.field("cloud_hsm_cluster_id", &self.cloud_hsm_cluster_id);
        formatter.field("xks_proxy_uri_endpoint", &self.xks_proxy_uri_endpoint);
        formatter.field("xks_proxy_uri_path", &self.xks_proxy_uri_path);
        formatter.field("xks_proxy_vpc_endpoint_service_name", &self.xks_proxy_vpc_endpoint_service_name);
        formatter.field("xks_proxy_authentication_credential", &self.xks_proxy_authentication_credential);
        formatter.field("xks_proxy_connectivity", &self.xks_proxy_connectivity);
        formatter.finish()
    }
}
impl UpdateCustomKeyStoreInput {
    /// Creates a new builder-style object to manufacture [`UpdateCustomKeyStoreInput`](crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput).
    pub fn builder() -> crate::operation::update_custom_key_store::builders::UpdateCustomKeyStoreInputBuilder {
        crate::operation::update_custom_key_store::builders::UpdateCustomKeyStoreInputBuilder::default()
    }
}

/// A builder for [`UpdateCustomKeyStoreInput`](crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput).
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default)]
pub struct UpdateCustomKeyStoreInputBuilder {
    pub(crate) custom_key_store_id: ::std::option::Option<::std::string::String>,
    pub(crate) new_custom_key_store_name: ::std::option::Option<::std::string::String>,
    pub(crate) key_store_password: ::std::option::Option<::std::string::String>,
    pub(crate) cloud_hsm_cluster_id: ::std::option::Option<::std::string::String>,
    pub(crate) xks_proxy_uri_endpoint: ::std::option::Option<::std::string::String>,
    pub(crate) xks_proxy_uri_path: ::std::option::Option<::std::string::String>,
    pub(crate) xks_proxy_vpc_endpoint_service_name: ::std::option::Option<::std::string::String>,
    pub(crate) xks_proxy_authentication_credential: ::std::option::Option<crate::types::XksProxyAuthenticationCredentialType>,
    pub(crate) xks_proxy_connectivity: ::std::option::Option<crate::types::XksProxyConnectivityType>,
}
impl UpdateCustomKeyStoreInputBuilder {
    /// <p>Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    /// This field is required.
    pub fn custom_key_store_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.custom_key_store_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    pub fn set_custom_key_store_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.custom_key_store_id = input;
        self
    }
    /// <p>Identifies the custom key store that you want to update. Enter the ID of the custom key store. To find the ID of a custom key store, use the <code>DescribeCustomKeyStores</code> operation.</p>
    pub fn get_custom_key_store_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.custom_key_store_id
    }
    /// <p>Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.</p><important>
    /// <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p>
    /// </important>
    /// <p>To change this value, an CloudHSM key store must be disconnected. An external key store can be connected or disconnected.</p>
    pub fn new_custom_key_store_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.new_custom_key_store_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.</p><important>
    /// <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p>
    /// </important>
    /// <p>To change this value, an CloudHSM key store must be disconnected. An external key store can be connected or disconnected.</p>
    pub fn set_new_custom_key_store_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.new_custom_key_store_name = input;
        self
    }
    /// <p>Changes the friendly name of the custom key store to the value that you specify. The custom key store name must be unique in the Amazon Web Services account.</p><important>
    /// <p>Do not include confidential or sensitive information in this field. This field may be displayed in plaintext in CloudTrail logs and other output.</p>
    /// </important>
    /// <p>To change this value, an CloudHSM key store must be disconnected. An external key store can be connected or disconnected.</p>
    pub fn get_new_custom_key_store_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.new_custom_key_store_name
    }
    /// <p>Enter the current password of the <code>kmsuser</code> crypto user (CU) in the CloudHSM cluster that is associated with the custom key store. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>This parameter tells KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub fn key_store_password(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.key_store_password = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Enter the current password of the <code>kmsuser</code> crypto user (CU) in the CloudHSM cluster that is associated with the custom key store. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>This parameter tells KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub fn set_key_store_password(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.key_store_password = input;
        self
    }
    /// <p>Enter the current password of the <code>kmsuser</code> crypto user (CU) in the CloudHSM cluster that is associated with the custom key store. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>This parameter tells KMS the current password of the <code>kmsuser</code> crypto user (CU). It does not set or change the password of any users in the CloudHSM cluster.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub fn get_key_store_password(&self) -> &::std::option::Option<::std::string::String> {
        &self.key_store_password
    }
    /// <p>Associates the custom key store with a related CloudHSM cluster. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub fn cloud_hsm_cluster_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.cloud_hsm_cluster_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Associates the custom key store with a related CloudHSM cluster. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub fn set_cloud_hsm_cluster_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.cloud_hsm_cluster_id = input;
        self
    }
    /// <p>Associates the custom key store with a related CloudHSM cluster. This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>AWS_CLOUDHSM</code>.</p>
    /// <p>Enter the cluster ID of the cluster that you used to create the custom key store or a cluster that shares a backup history and has the same cluster certificate as the original cluster. You cannot use this parameter to associate a custom key store with an unrelated cluster. In addition, the replacement cluster must <a href="https://docs.aws.amazon.com/kms/latest/developerguide/create-keystore.html#before-keystore">fulfill the requirements</a> for a cluster associated with a custom key store. To view the cluster certificate of a cluster, use the <a href="https://docs.aws.amazon.com/cloudhsm/latest/APIReference/API_DescribeClusters.html">DescribeClusters</a> operation.</p>
    /// <p>To change this value, the CloudHSM key store must be disconnected.</p>
    pub fn get_cloud_hsm_cluster_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.cloud_hsm_cluster_id
    }
    /// <p>Changes the URI endpoint that KMS uses to connect to your external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>PUBLIC_ENDPOINT</code>, the protocol must be HTTPS.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>VPC_ENDPOINT_SERVICE</code>, specify <code>https://</code> followed by the private DNS name associated with the VPC endpoint service. Each external key store must use a different private DNS name.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn xks_proxy_uri_endpoint(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.xks_proxy_uri_endpoint = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Changes the URI endpoint that KMS uses to connect to your external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>PUBLIC_ENDPOINT</code>, the protocol must be HTTPS.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>VPC_ENDPOINT_SERVICE</code>, specify <code>https://</code> followed by the private DNS name associated with the VPC endpoint service. Each external key store must use a different private DNS name.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn set_xks_proxy_uri_endpoint(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.xks_proxy_uri_endpoint = input;
        self
    }
    /// <p>Changes the URI endpoint that KMS uses to connect to your external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>PUBLIC_ENDPOINT</code>, the protocol must be HTTPS.</p>
    /// <p>For external key stores with an <code>XksProxyConnectivity</code> value of <code>VPC_ENDPOINT_SERVICE</code>, specify <code>https://</code> followed by the private DNS name associated with the VPC endpoint service. Each external key store must use a different private DNS name.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn get_xks_proxy_uri_endpoint(&self) -> &::std::option::Option<::std::string::String> {
        &self.xks_proxy_uri_endpoint
    }
    /// <p>Changes the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key manager and external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>The value must start with <code>/</code> and must end with <code>/kms/xks/v1</code>, where <code>v1</code> represents the version of the KMS external key store proxy API. You can include an optional prefix between the required elements such as <code>/<i>example</i>/kms/xks/v1</code>.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub fn xks_proxy_uri_path(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.xks_proxy_uri_path = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Changes the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key manager and external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>The value must start with <code>/</code> and must end with <code>/kms/xks/v1</code>, where <code>v1</code> represents the version of the KMS external key store proxy API. You can include an optional prefix between the required elements such as <code>/<i>example</i>/kms/xks/v1</code>.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub fn set_xks_proxy_uri_path(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.xks_proxy_uri_path = input;
        self
    }
    /// <p>Changes the base path to the proxy APIs for this external key store. To find this value, see the documentation for your external key manager and external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>The value must start with <code>/</code> and must end with <code>/kms/xks/v1</code>, where <code>v1</code> represents the version of the KMS external key store proxy API. You can include an optional prefix between the required elements such as <code>/<i>example</i>/kms/xks/v1</code>.</p>
    /// <p>The combined <code>XksProxyUriEndpoint</code> and <code>XksProxyUriPath</code> values must be unique in the Amazon Web Services account and Region.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub fn get_xks_proxy_uri_path(&self) -> &::std::option::Option<::std::string::String> {
        &self.xks_proxy_uri_path
    }
    /// <p>Changes the name that KMS uses to identify the Amazon VPC endpoint service for your external key store proxy (XKS proxy). This parameter is valid when the <code>CustomKeyStoreType</code> is <code>EXTERNAL_KEY_STORE</code> and the <code>XksProxyConnectivity</code> is <code>VPC_ENDPOINT_SERVICE</code>.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn xks_proxy_vpc_endpoint_service_name(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.xks_proxy_vpc_endpoint_service_name = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Changes the name that KMS uses to identify the Amazon VPC endpoint service for your external key store proxy (XKS proxy). This parameter is valid when the <code>CustomKeyStoreType</code> is <code>EXTERNAL_KEY_STORE</code> and the <code>XksProxyConnectivity</code> is <code>VPC_ENDPOINT_SERVICE</code>.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn set_xks_proxy_vpc_endpoint_service_name(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.xks_proxy_vpc_endpoint_service_name = input;
        self
    }
    /// <p>Changes the name that KMS uses to identify the Amazon VPC endpoint service for your external key store proxy (XKS proxy). This parameter is valid when the <code>CustomKeyStoreType</code> is <code>EXTERNAL_KEY_STORE</code> and the <code>XksProxyConnectivity</code> is <code>VPC_ENDPOINT_SERVICE</code>.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn get_xks_proxy_vpc_endpoint_service_name(&self) -> &::std::option::Option<::std::string::String> {
        &self.xks_proxy_vpc_endpoint_service_name
    }
    /// <p>Changes the credentials that KMS uses to sign requests to the external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>You must specify both the <code>AccessKeyId</code> and <code>SecretAccessKey</code> value in the authentication credential, even if you are only updating one value.</p>
    /// <p>This parameter doesn't establish or change your authentication credentials on the proxy. It just tells KMS the credential that you established with your external key store proxy. For example, if you rotate the credential on your external key store proxy, you can use this parameter to update the credential in KMS.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub fn xks_proxy_authentication_credential(mut self, input: crate::types::XksProxyAuthenticationCredentialType) -> Self {
        self.xks_proxy_authentication_credential = ::std::option::Option::Some(input);
        self
    }
    /// <p>Changes the credentials that KMS uses to sign requests to the external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>You must specify both the <code>AccessKeyId</code> and <code>SecretAccessKey</code> value in the authentication credential, even if you are only updating one value.</p>
    /// <p>This parameter doesn't establish or change your authentication credentials on the proxy. It just tells KMS the credential that you established with your external key store proxy. For example, if you rotate the credential on your external key store proxy, you can use this parameter to update the credential in KMS.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub fn set_xks_proxy_authentication_credential(
        mut self,
        input: ::std::option::Option<crate::types::XksProxyAuthenticationCredentialType>,
    ) -> Self {
        self.xks_proxy_authentication_credential = input;
        self
    }
    /// <p>Changes the credentials that KMS uses to sign requests to the external key store proxy (XKS proxy). This parameter is valid only for custom key stores with a <code>CustomKeyStoreType</code> of <code>EXTERNAL_KEY_STORE</code>.</p>
    /// <p>You must specify both the <code>AccessKeyId</code> and <code>SecretAccessKey</code> value in the authentication credential, even if you are only updating one value.</p>
    /// <p>This parameter doesn't establish or change your authentication credentials on the proxy. It just tells KMS the credential that you established with your external key store proxy. For example, if you rotate the credential on your external key store proxy, you can use this parameter to update the credential in KMS.</p>
    /// <p>You can change this value when the external key store is connected or disconnected.</p>
    pub fn get_xks_proxy_authentication_credential(&self) -> &::std::option::Option<crate::types::XksProxyAuthenticationCredentialType> {
        &self.xks_proxy_authentication_credential
    }
    /// <p>Changes the connectivity setting for the external key store. To indicate that the external key store proxy uses a Amazon VPC endpoint service to communicate with KMS, specify <code>VPC_ENDPOINT_SERVICE</code>. Otherwise, specify <code>PUBLIC_ENDPOINT</code>.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>VPC_ENDPOINT_SERVICE</code>, you must also change the <code>XksProxyUriEndpoint</code> and add an <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>PUBLIC_ENDPOINT</code>, you must also change the <code>XksProxyUriEndpoint</code> and specify a null or empty string for the <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn xks_proxy_connectivity(mut self, input: crate::types::XksProxyConnectivityType) -> Self {
        self.xks_proxy_connectivity = ::std::option::Option::Some(input);
        self
    }
    /// <p>Changes the connectivity setting for the external key store. To indicate that the external key store proxy uses a Amazon VPC endpoint service to communicate with KMS, specify <code>VPC_ENDPOINT_SERVICE</code>. Otherwise, specify <code>PUBLIC_ENDPOINT</code>.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>VPC_ENDPOINT_SERVICE</code>, you must also change the <code>XksProxyUriEndpoint</code> and add an <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>PUBLIC_ENDPOINT</code>, you must also change the <code>XksProxyUriEndpoint</code> and specify a null or empty string for the <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn set_xks_proxy_connectivity(mut self, input: ::std::option::Option<crate::types::XksProxyConnectivityType>) -> Self {
        self.xks_proxy_connectivity = input;
        self
    }
    /// <p>Changes the connectivity setting for the external key store. To indicate that the external key store proxy uses a Amazon VPC endpoint service to communicate with KMS, specify <code>VPC_ENDPOINT_SERVICE</code>. Otherwise, specify <code>PUBLIC_ENDPOINT</code>.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>VPC_ENDPOINT_SERVICE</code>, you must also change the <code>XksProxyUriEndpoint</code> and add an <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>If you change the <code>XksProxyConnectivity</code> to <code>PUBLIC_ENDPOINT</code>, you must also change the <code>XksProxyUriEndpoint</code> and specify a null or empty string for the <code>XksProxyVpcEndpointServiceName</code> value.</p>
    /// <p>To change this value, the external key store must be disconnected.</p>
    pub fn get_xks_proxy_connectivity(&self) -> &::std::option::Option<crate::types::XksProxyConnectivityType> {
        &self.xks_proxy_connectivity
    }
    /// Consumes the builder and constructs a [`UpdateCustomKeyStoreInput`](crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput, ::aws_smithy_types::error::operation::BuildError>
    {
        ::std::result::Result::Ok(crate::operation::update_custom_key_store::UpdateCustomKeyStoreInput {
            custom_key_store_id: self.custom_key_store_id,
            new_custom_key_store_name: self.new_custom_key_store_name,
            key_store_password: self.key_store_password,
            cloud_hsm_cluster_id: self.cloud_hsm_cluster_id,
            xks_proxy_uri_endpoint: self.xks_proxy_uri_endpoint,
            xks_proxy_uri_path: self.xks_proxy_uri_path,
            xks_proxy_vpc_endpoint_service_name: self.xks_proxy_vpc_endpoint_service_name,
            xks_proxy_authentication_credential: self.xks_proxy_authentication_credential,
            xks_proxy_connectivity: self.xks_proxy_connectivity,
        })
    }
}
impl ::std::fmt::Debug for UpdateCustomKeyStoreInputBuilder {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        let mut formatter = f.debug_struct("UpdateCustomKeyStoreInputBuilder");
        formatter.field("custom_key_store_id", &self.custom_key_store_id);
        formatter.field("new_custom_key_store_name", &self.new_custom_key_store_name);
        formatter.field("key_store_password", &"*** Sensitive Data Redacted ***");
        formatter.field("cloud_hsm_cluster_id", &self.cloud_hsm_cluster_id);
        formatter.field("xks_proxy_uri_endpoint", &self.xks_proxy_uri_endpoint);
        formatter.field("xks_proxy_uri_path", &self.xks_proxy_uri_path);
        formatter.field("xks_proxy_vpc_endpoint_service_name", &self.xks_proxy_vpc_endpoint_service_name);
        formatter.field("xks_proxy_authentication_credential", &self.xks_proxy_authentication_credential);
        formatter.field("xks_proxy_connectivity", &self.xks_proxy_connectivity);
        formatter.finish()
    }
}
