# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._iot_hub_client_enums import *


class CertificateBodyDescription(msrest.serialization.Model):
    """The JSON-serialized X509 Certificate.

    :ivar certificate: base-64 representation of the X509 leaf certificate .cer file or just .pem
     file content.
    :vartype certificate: str
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword certificate: base-64 representation of the X509 leaf certificate .cer file or just
         .pem file content.
        :paramtype certificate: str
        """
        super(CertificateBodyDescription, self).__init__(**kwargs)
        self.certificate = certificate


class CertificateDescription(msrest.serialization.Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: The description of an X509 CA Certificate.
    :vartype properties: ~azure.mgmt.iothub.v2019_03_22.models.CertificateProperties
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CertificateProperties'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        properties: Optional["CertificateProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: The description of an X509 CA Certificate.
        :paramtype properties: ~azure.mgmt.iothub.v2019_03_22.models.CertificateProperties
        """
        super(CertificateDescription, self).__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.etag = None
        self.type = None


class CertificateListDescription(msrest.serialization.Model):
    """The JSON-serialized array of Certificate objects.

    :ivar value: The array of Certificate objects.
    :vartype value: list[~azure.mgmt.iothub.v2019_03_22.models.CertificateDescription]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CertificateDescription]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["CertificateDescription"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of Certificate objects.
        :paramtype value: list[~azure.mgmt.iothub.v2019_03_22.models.CertificateDescription]
        """
        super(CertificateListDescription, self).__init__(**kwargs)
        self.value = value


class CertificateProperties(msrest.serialization.Model):
    """The description of an X509 CA Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar created: The certificate's create date and time.
    :vartype created: ~datetime.datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: ~datetime.datetime
    :ivar certificate: The certificate content.
    :vartype certificate: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiry': {'readonly': True},
        'thumbprint': {'readonly': True},
        'is_verified': {'readonly': True},
        'created': {'readonly': True},
        'updated': {'readonly': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'rfc-1123'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'rfc-1123'},
        'updated': {'key': 'updated', 'type': 'rfc-1123'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword certificate: The certificate content.
        :paramtype certificate: str
        """
        super(CertificateProperties, self).__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = None
        self.created = None
        self.updated = None
        self.certificate = certificate


class CertificatePropertiesWithNonce(msrest.serialization.Model):
    """The description of an X509 CA Certificate including the challenge nonce issued for the Proof-Of-Possession flow.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar subject: The certificate's subject name.
    :vartype subject: str
    :ivar expiry: The certificate's expiration date and time.
    :vartype expiry: ~datetime.datetime
    :ivar thumbprint: The certificate's thumbprint.
    :vartype thumbprint: str
    :ivar is_verified: Determines whether certificate has been verified.
    :vartype is_verified: bool
    :ivar created: The certificate's create date and time.
    :vartype created: ~datetime.datetime
    :ivar updated: The certificate's last update date and time.
    :vartype updated: ~datetime.datetime
    :ivar verification_code: The certificate's verification code that will be used for proof of
     possession.
    :vartype verification_code: str
    :ivar certificate: The certificate content.
    :vartype certificate: str
    """

    _validation = {
        'subject': {'readonly': True},
        'expiry': {'readonly': True},
        'thumbprint': {'readonly': True},
        'is_verified': {'readonly': True},
        'created': {'readonly': True},
        'updated': {'readonly': True},
        'verification_code': {'readonly': True},
        'certificate': {'readonly': True},
    }

    _attribute_map = {
        'subject': {'key': 'subject', 'type': 'str'},
        'expiry': {'key': 'expiry', 'type': 'rfc-1123'},
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'is_verified': {'key': 'isVerified', 'type': 'bool'},
        'created': {'key': 'created', 'type': 'rfc-1123'},
        'updated': {'key': 'updated', 'type': 'rfc-1123'},
        'verification_code': {'key': 'verificationCode', 'type': 'str'},
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(CertificatePropertiesWithNonce, self).__init__(**kwargs)
        self.subject = None
        self.expiry = None
        self.thumbprint = None
        self.is_verified = None
        self.created = None
        self.updated = None
        self.verification_code = None
        self.certificate = None


class CertificateVerificationDescription(msrest.serialization.Model):
    """The JSON-serialized leaf certificate.

    :ivar certificate: base-64 representation of X509 certificate .cer file or just .pem file
     content.
    :vartype certificate: str
    """

    _attribute_map = {
        'certificate': {'key': 'certificate', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword certificate: base-64 representation of X509 certificate .cer file or just .pem file
         content.
        :paramtype certificate: str
        """
        super(CertificateVerificationDescription, self).__init__(**kwargs)
        self.certificate = certificate


class CertificateWithNonceDescription(msrest.serialization.Model):
    """The X509 Certificate.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: The description of an X509 CA Certificate including the challenge nonce
     issued for the Proof-Of-Possession flow.
    :vartype properties: ~azure.mgmt.iothub.v2019_03_22.models.CertificatePropertiesWithNonce
    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The name of the certificate.
    :vartype name: str
    :ivar etag: The entity tag.
    :vartype etag: str
    :ivar type: The resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'etag': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'CertificatePropertiesWithNonce'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        properties: Optional["CertificatePropertiesWithNonce"] = None,
        **kwargs
    ):
        """
        :keyword properties: The description of an X509 CA Certificate including the challenge nonce
         issued for the Proof-Of-Possession flow.
        :paramtype properties: ~azure.mgmt.iothub.v2019_03_22.models.CertificatePropertiesWithNonce
        """
        super(CertificateWithNonceDescription, self).__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.etag = None
        self.type = None


class CloudToDeviceProperties(msrest.serialization.Model):
    """The IoT hub cloud-to-device messaging properties.

    :ivar max_delivery_count: The max delivery count for cloud-to-device messages in the device
     queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype max_delivery_count: int
    :ivar default_ttl_as_iso8601: The default time to live for cloud-to-device messages in the
     device queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype default_ttl_as_iso8601: ~datetime.timedelta
    :ivar feedback: The properties of the feedback queue for cloud-to-device messages.
    :vartype feedback: ~azure.mgmt.iothub.v2019_03_22.models.FeedbackProperties
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
        'default_ttl_as_iso8601': {'key': 'defaultTtlAsIso8601', 'type': 'duration'},
        'feedback': {'key': 'feedback', 'type': 'FeedbackProperties'},
    }

    def __init__(
        self,
        *,
        max_delivery_count: Optional[int] = None,
        default_ttl_as_iso8601: Optional[datetime.timedelta] = None,
        feedback: Optional["FeedbackProperties"] = None,
        **kwargs
    ):
        """
        :keyword max_delivery_count: The max delivery count for cloud-to-device messages in the device
         queue. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype max_delivery_count: int
        :keyword default_ttl_as_iso8601: The default time to live for cloud-to-device messages in the
         device queue. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype default_ttl_as_iso8601: ~datetime.timedelta
        :keyword feedback: The properties of the feedback queue for cloud-to-device messages.
        :paramtype feedback: ~azure.mgmt.iothub.v2019_03_22.models.FeedbackProperties
        """
        super(CloudToDeviceProperties, self).__init__(**kwargs)
        self.max_delivery_count = max_delivery_count
        self.default_ttl_as_iso8601 = default_ttl_as_iso8601
        self.feedback = feedback


class EndpointHealthData(msrest.serialization.Model):
    """The health data for an endpoint.

    :ivar endpoint_id: Id of the endpoint.
    :vartype endpoint_id: str
    :ivar health_status: Health statuses have following meanings. The 'healthy' status shows that
     the endpoint is accepting messages as expected. The 'unhealthy' status shows that the endpoint
     is not accepting messages as expected and IoT Hub is retrying to send data to this endpoint.
     The status of an unhealthy endpoint will be updated to healthy when IoT Hub has established an
     eventually consistent state of health. The 'dead' status shows that the endpoint is not
     accepting messages, after IoT Hub retried sending messages for the retrial period. See IoT Hub
     metrics to identify errors and monitor issues with endpoints. The 'unknown' status shows that
     the IoT Hub has not established a connection with the endpoint. No messages have been delivered
     to or rejected from this endpoint. Possible values include: "unknown", "healthy", "unhealthy",
     "dead".
    :vartype health_status: str or ~azure.mgmt.iothub.v2019_03_22.models.EndpointHealthStatus
    """

    _attribute_map = {
        'endpoint_id': {'key': 'endpointId', 'type': 'str'},
        'health_status': {'key': 'healthStatus', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        endpoint_id: Optional[str] = None,
        health_status: Optional[Union[str, "EndpointHealthStatus"]] = None,
        **kwargs
    ):
        """
        :keyword endpoint_id: Id of the endpoint.
        :paramtype endpoint_id: str
        :keyword health_status: Health statuses have following meanings. The 'healthy' status shows
         that the endpoint is accepting messages as expected. The 'unhealthy' status shows that the
         endpoint is not accepting messages as expected and IoT Hub is retrying to send data to this
         endpoint. The status of an unhealthy endpoint will be updated to healthy when IoT Hub has
         established an eventually consistent state of health. The 'dead' status shows that the endpoint
         is not accepting messages, after IoT Hub retried sending messages for the retrial period. See
         IoT Hub metrics to identify errors and monitor issues with endpoints. The 'unknown' status
         shows that the IoT Hub has not established a connection with the endpoint. No messages have
         been delivered to or rejected from this endpoint. Possible values include: "unknown",
         "healthy", "unhealthy", "dead".
        :paramtype health_status: str or ~azure.mgmt.iothub.v2019_03_22.models.EndpointHealthStatus
        """
        super(EndpointHealthData, self).__init__(**kwargs)
        self.endpoint_id = endpoint_id
        self.health_status = health_status


class EndpointHealthDataListResult(msrest.serialization.Model):
    """The JSON-serialized array of EndpointHealthData objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: JSON-serialized array of Endpoint health data.
    :vartype value: list[~azure.mgmt.iothub.v2019_03_22.models.EndpointHealthData]
    :ivar next_link: Link to more results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EndpointHealthData]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EndpointHealthData"]] = None,
        **kwargs
    ):
        """
        :keyword value: JSON-serialized array of Endpoint health data.
        :paramtype value: list[~azure.mgmt.iothub.v2019_03_22.models.EndpointHealthData]
        """
        super(EndpointHealthDataListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ErrorDetails(msrest.serialization.Model):
    """Error details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar http_status_code: The HTTP status code.
    :vartype http_status_code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar details: The error details.
    :vartype details: str
    """

    _validation = {
        'code': {'readonly': True},
        'http_status_code': {'readonly': True},
        'message': {'readonly': True},
        'details': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'http_status_code': {'key': 'httpStatusCode', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetails, self).__init__(**kwargs)
        self.code = None
        self.http_status_code = None
        self.message = None
        self.details = None


class EventHubConsumerGroupInfo(msrest.serialization.Model):
    """The properties of the EventHubConsumerGroupInfo object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: The tags.
    :vartype properties: dict[str, str]
    :ivar id: The Event Hub-compatible consumer group identifier.
    :vartype id: str
    :ivar name: The Event Hub-compatible consumer group name.
    :vartype name: str
    :ivar type: the resource type.
    :vartype type: str
    :ivar etag: The etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': '{str}'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword properties: The tags.
        :paramtype properties: dict[str, str]
        """
        super(EventHubConsumerGroupInfo, self).__init__(**kwargs)
        self.properties = properties
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class EventHubConsumerGroupsListResult(msrest.serialization.Model):
    """The JSON-serialized array of Event Hub-compatible consumer group names with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of consumer groups objects.
    :vartype value: list[~azure.mgmt.iothub.v2019_03_22.models.EventHubConsumerGroupInfo]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[EventHubConsumerGroupInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["EventHubConsumerGroupInfo"]] = None,
        **kwargs
    ):
        """
        :keyword value: List of consumer groups objects.
        :paramtype value: list[~azure.mgmt.iothub.v2019_03_22.models.EventHubConsumerGroupInfo]
        """
        super(EventHubConsumerGroupsListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class EventHubProperties(msrest.serialization.Model):
    """The properties of the provisioned Event Hub-compatible endpoint used by the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar retention_time_in_days: The retention time for device-to-cloud messages in days. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
    :vartype retention_time_in_days: long
    :ivar partition_count: The number of partitions for receiving device-to-cloud messages in the
     Event Hub-compatible endpoint. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
    :vartype partition_count: int
    :ivar partition_ids: The partition ids in the Event Hub-compatible endpoint.
    :vartype partition_ids: list[str]
    :ivar path: The Event Hub-compatible name.
    :vartype path: str
    :ivar endpoint: The Event Hub-compatible endpoint.
    :vartype endpoint: str
    """

    _validation = {
        'partition_ids': {'readonly': True},
        'path': {'readonly': True},
        'endpoint': {'readonly': True},
    }

    _attribute_map = {
        'retention_time_in_days': {'key': 'retentionTimeInDays', 'type': 'long'},
        'partition_count': {'key': 'partitionCount', 'type': 'int'},
        'partition_ids': {'key': 'partitionIds', 'type': '[str]'},
        'path': {'key': 'path', 'type': 'str'},
        'endpoint': {'key': 'endpoint', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        retention_time_in_days: Optional[int] = None,
        partition_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword retention_time_in_days: The retention time for device-to-cloud messages in days. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        :paramtype retention_time_in_days: long
        :keyword partition_count: The number of partitions for receiving device-to-cloud messages in
         the Event Hub-compatible endpoint. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#device-to-cloud-messages.
        :paramtype partition_count: int
        """
        super(EventHubProperties, self).__init__(**kwargs)
        self.retention_time_in_days = retention_time_in_days
        self.partition_count = partition_count
        self.partition_ids = None
        self.path = None
        self.endpoint = None


class ExportDevicesRequest(msrest.serialization.Model):
    """Use to provide parameters when requesting an export of all devices in the IoT hub.

    All required parameters must be populated in order to send to Azure.

    :ivar export_blob_container_uri: Required. The export blob container URI.
    :vartype export_blob_container_uri: str
    :ivar exclude_keys: Required. The value indicating whether keys should be excluded during
     export.
    :vartype exclude_keys: bool
    """

    _validation = {
        'export_blob_container_uri': {'required': True},
        'exclude_keys': {'required': True},
    }

    _attribute_map = {
        'export_blob_container_uri': {'key': 'exportBlobContainerUri', 'type': 'str'},
        'exclude_keys': {'key': 'excludeKeys', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        export_blob_container_uri: str,
        exclude_keys: bool,
        **kwargs
    ):
        """
        :keyword export_blob_container_uri: Required. The export blob container URI.
        :paramtype export_blob_container_uri: str
        :keyword exclude_keys: Required. The value indicating whether keys should be excluded during
         export.
        :paramtype exclude_keys: bool
        """
        super(ExportDevicesRequest, self).__init__(**kwargs)
        self.export_blob_container_uri = export_blob_container_uri
        self.exclude_keys = exclude_keys


class FailoverInput(msrest.serialization.Model):
    """Use to provide failover region when requesting manual Failover for a hub.

    All required parameters must be populated in order to send to Azure.

    :ivar failover_region: Required. Region the hub will be failed over to.
    :vartype failover_region: str
    """

    _validation = {
        'failover_region': {'required': True},
    }

    _attribute_map = {
        'failover_region': {'key': 'failoverRegion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        failover_region: str,
        **kwargs
    ):
        """
        :keyword failover_region: Required. Region the hub will be failed over to.
        :paramtype failover_region: str
        """
        super(FailoverInput, self).__init__(**kwargs)
        self.failover_region = failover_region


class FallbackRouteProperties(msrest.serialization.Model):
    """The properties of the fallback route. IoT Hub uses these properties when it routes messages to the fallback endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the route. The name can only include alphanumeric characters, periods,
     underscores, hyphens, has a maximum length of 64 characters, and must be unique.
    :vartype name: str
    :ivar source: Required. The source to which the routing rule is to be applied to. For example,
     DeviceMessages. Possible values include: "Invalid", "DeviceMessages", "TwinChangeEvents",
     "DeviceLifecycleEvents", "DeviceJobLifecycleEvents".
    :vartype source: str or ~azure.mgmt.iothub.v2019_03_22.models.RoutingSource
    :ivar condition: The condition which is evaluated in order to apply the fallback route. If the
     condition is not provided it will evaluate to true by default. For grammar, See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language.
    :vartype condition: str
    :ivar endpoint_names: Required. The list of endpoints to which the messages that satisfy the
     condition are routed to. Currently only 1 endpoint is allowed.
    :vartype endpoint_names: list[str]
    :ivar is_enabled: Required. Used to specify whether the fallback route is enabled.
    :vartype is_enabled: bool
    """

    _validation = {
        'source': {'required': True},
        'endpoint_names': {'required': True, 'max_items': 1, 'min_items': 1},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'condition': {'key': 'condition', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        source: Union[str, "RoutingSource"],
        endpoint_names: List[str],
        is_enabled: bool,
        name: Optional[str] = None,
        condition: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: The name of the route. The name can only include alphanumeric characters,
         periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
        :paramtype name: str
        :keyword source: Required. The source to which the routing rule is to be applied to. For
         example, DeviceMessages. Possible values include: "Invalid", "DeviceMessages",
         "TwinChangeEvents", "DeviceLifecycleEvents", "DeviceJobLifecycleEvents".
        :paramtype source: str or ~azure.mgmt.iothub.v2019_03_22.models.RoutingSource
        :keyword condition: The condition which is evaluated in order to apply the fallback route. If
         the condition is not provided it will evaluate to true by default. For grammar, See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language.
        :paramtype condition: str
        :keyword endpoint_names: Required. The list of endpoints to which the messages that satisfy the
         condition are routed to. Currently only 1 endpoint is allowed.
        :paramtype endpoint_names: list[str]
        :keyword is_enabled: Required. Used to specify whether the fallback route is enabled.
        :paramtype is_enabled: bool
        """
        super(FallbackRouteProperties, self).__init__(**kwargs)
        self.name = name
        self.source = source
        self.condition = condition
        self.endpoint_names = endpoint_names
        self.is_enabled = is_enabled


class FeedbackProperties(msrest.serialization.Model):
    """The properties of the feedback queue for cloud-to-device messages.

    :ivar lock_duration_as_iso8601: The lock duration for the feedback queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype lock_duration_as_iso8601: ~datetime.timedelta
    :ivar ttl_as_iso8601: The period of time for which a message is available to consume before it
     is expired by the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype ttl_as_iso8601: ~datetime.timedelta
    :ivar max_delivery_count: The number of times the IoT hub attempts to deliver a message on the
     feedback queue. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
    :vartype max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lock_duration_as_iso8601: Optional[datetime.timedelta] = None,
        ttl_as_iso8601: Optional[datetime.timedelta] = None,
        max_delivery_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword lock_duration_as_iso8601: The lock duration for the feedback queue. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype lock_duration_as_iso8601: ~datetime.timedelta
        :keyword ttl_as_iso8601: The period of time for which a message is available to consume before
         it is expired by the IoT hub. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype ttl_as_iso8601: ~datetime.timedelta
        :keyword max_delivery_count: The number of times the IoT hub attempts to deliver a message on
         the feedback queue. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging#cloud-to-device-messages.
        :paramtype max_delivery_count: int
        """
        super(FeedbackProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = lock_duration_as_iso8601
        self.ttl_as_iso8601 = ttl_as_iso8601
        self.max_delivery_count = max_delivery_count


class ImportDevicesRequest(msrest.serialization.Model):
    """Use to provide parameters when requesting an import of all devices in the hub.

    All required parameters must be populated in order to send to Azure.

    :ivar input_blob_container_uri: Required. The input blob container URI.
    :vartype input_blob_container_uri: str
    :ivar output_blob_container_uri: Required. The output blob container URI.
    :vartype output_blob_container_uri: str
    """

    _validation = {
        'input_blob_container_uri': {'required': True},
        'output_blob_container_uri': {'required': True},
    }

    _attribute_map = {
        'input_blob_container_uri': {'key': 'inputBlobContainerUri', 'type': 'str'},
        'output_blob_container_uri': {'key': 'outputBlobContainerUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        input_blob_container_uri: str,
        output_blob_container_uri: str,
        **kwargs
    ):
        """
        :keyword input_blob_container_uri: Required. The input blob container URI.
        :paramtype input_blob_container_uri: str
        :keyword output_blob_container_uri: Required. The output blob container URI.
        :paramtype output_blob_container_uri: str
        """
        super(ImportDevicesRequest, self).__init__(**kwargs)
        self.input_blob_container_uri = input_blob_container_uri
        self.output_blob_container_uri = output_blob_container_uri


class IotHubCapacity(msrest.serialization.Model):
    """IoT Hub capacity information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum number of units.
    :vartype minimum: long
    :ivar maximum: The maximum number of units.
    :vartype maximum: long
    :ivar default: The default number of units.
    :vartype default: long
    :ivar scale_type: The type of the scaling enabled. Possible values include: "Automatic",
     "Manual", "None".
    :vartype scale_type: str or ~azure.mgmt.iothub.v2019_03_22.models.IotHubScaleType
    """

    _validation = {
        'minimum': {'readonly': True, 'maximum': 1, 'minimum': 1},
        'maximum': {'readonly': True},
        'default': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default': {'key': 'default', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IotHubCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default = None
        self.scale_type = None


class Resource(msrest.serialization.Model):
    """The common properties of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: Required. The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class IotHubDescription(Resource):
    """The description of the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: The resource identifier.
    :vartype id: str
    :ivar name: The resource name.
    :vartype name: str
    :ivar type: The resource type.
    :vartype type: str
    :ivar location: Required. The resource location.
    :vartype location: str
    :ivar tags: A set of tags. The resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: The Etag field is *not* required. If it is provided in the response body, it must
     also be provided as a header per the normal ETag convention.
    :vartype etag: str
    :ivar properties: IotHub properties.
    :vartype properties: ~azure.mgmt.iothub.v2019_03_22.models.IotHubProperties
    :ivar sku: Required. IotHub SKU info.
    :vartype sku: ~azure.mgmt.iothub.v2019_03_22.models.IotHubSkuInfo
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True, 'pattern': r'^(?![0-9]+$)(?!-)[a-zA-Z0-9-]{2,49}[a-zA-Z0-9]$'},
        'type': {'readonly': True},
        'location': {'required': True},
        'sku': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'etag': {'key': 'etag', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'IotHubProperties'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "IotHubSkuInfo",
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        properties: Optional["IotHubProperties"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. The resource location.
        :paramtype location: str
        :keyword tags: A set of tags. The resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: The Etag field is *not* required. If it is provided in the response body, it
         must also be provided as a header per the normal ETag convention.
        :paramtype etag: str
        :keyword properties: IotHub properties.
        :paramtype properties: ~azure.mgmt.iothub.v2019_03_22.models.IotHubProperties
        :keyword sku: Required. IotHub SKU info.
        :paramtype sku: ~azure.mgmt.iothub.v2019_03_22.models.IotHubSkuInfo
        """
        super(IotHubDescription, self).__init__(location=location, tags=tags, **kwargs)
        self.etag = etag
        self.properties = properties
        self.sku = sku


class IotHubDescriptionListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubDescription objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array of IotHubDescription objects.
    :vartype value: list[~azure.mgmt.iothub.v2019_03_22.models.IotHubDescription]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IotHubDescription"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of IotHubDescription objects.
        :paramtype value: list[~azure.mgmt.iothub.v2019_03_22.models.IotHubDescription]
        """
        super(IotHubDescriptionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IotHubLocationDescription(msrest.serialization.Model):
    """Public representation of one of the locations where a resource is provisioned.

    :ivar location: The name of the Azure region.
    :vartype location: str
    :ivar role: The role of the region, can be either primary or secondary. The primary region is
     where the IoT hub is currently provisioned. The secondary region is the Azure disaster recovery
     (DR) paired region and also the region where the IoT hub can failover to. Possible values
     include: "primary", "secondary".
    :vartype role: str or ~azure.mgmt.iothub.v2019_03_22.models.IotHubReplicaRoleType
    """

    _attribute_map = {
        'location': {'key': 'location', 'type': 'str'},
        'role': {'key': 'role', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: Optional[str] = None,
        role: Optional[Union[str, "IotHubReplicaRoleType"]] = None,
        **kwargs
    ):
        """
        :keyword location: The name of the Azure region.
        :paramtype location: str
        :keyword role: The role of the region, can be either primary or secondary. The primary region
         is where the IoT hub is currently provisioned. The secondary region is the Azure disaster
         recovery (DR) paired region and also the region where the IoT hub can failover to. Possible
         values include: "primary", "secondary".
        :paramtype role: str or ~azure.mgmt.iothub.v2019_03_22.models.IotHubReplicaRoleType
        """
        super(IotHubLocationDescription, self).__init__(**kwargs)
        self.location = location
        self.role = role


class IotHubNameAvailabilityInfo(msrest.serialization.Model):
    """The properties indicating whether a given IoT hub name is available.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: The value which indicates whether the provided name is available.
    :vartype name_available: bool
    :ivar reason: The reason for unavailability. Possible values include: "Invalid",
     "AlreadyExists".
    :vartype reason: str or ~azure.mgmt.iothub.v2019_03_22.models.IotHubNameUnavailabilityReason
    :ivar message: The detailed reason message.
    :vartype message: str
    """

    _validation = {
        'name_available': {'readonly': True},
        'reason': {'readonly': True},
    }

    _attribute_map = {
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword message: The detailed reason message.
        :paramtype message: str
        """
        super(IotHubNameAvailabilityInfo, self).__init__(**kwargs)
        self.name_available = None
        self.reason = None
        self.message = message


class IotHubProperties(msrest.serialization.Model):
    """The properties of an IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar authorization_policies: The shared access policies you can use to secure a connection to
     the IoT hub.
    :vartype authorization_policies:
     list[~azure.mgmt.iothub.v2019_03_22.models.SharedAccessSignatureAuthorizationRule]
    :ivar ip_filter_rules: The IP filter rules.
    :vartype ip_filter_rules: list[~azure.mgmt.iothub.v2019_03_22.models.IpFilterRule]
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    :ivar state: The hub state.
    :vartype state: str
    :ivar host_name: The name of the host.
    :vartype host_name: str
    :ivar event_hub_endpoints: The Event Hub-compatible endpoint properties. The only possible keys
     to this dictionary is events. This key has to be present in the dictionary while making create
     or update calls for the IoT hub.
    :vartype event_hub_endpoints: dict[str,
     ~azure.mgmt.iothub.v2019_03_22.models.EventHubProperties]
    :ivar routing: The routing related properties of the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging.
    :vartype routing: ~azure.mgmt.iothub.v2019_03_22.models.RoutingProperties
    :ivar storage_endpoints: The list of Azure Storage endpoints where you can upload files.
     Currently you can configure only one Azure Storage account and that MUST have its key as
     $default. Specifying more than one storage account causes an error to be thrown. Not specifying
     a value for this property when the enableFileUploadNotifications property is set to True,
     causes an error to be thrown.
    :vartype storage_endpoints: dict[str,
     ~azure.mgmt.iothub.v2019_03_22.models.StorageEndpointProperties]
    :ivar messaging_endpoints: The messaging endpoint properties for the file upload notification
     queue.
    :vartype messaging_endpoints: dict[str,
     ~azure.mgmt.iothub.v2019_03_22.models.MessagingEndpointProperties]
    :ivar enable_file_upload_notifications: If True, file upload notifications are enabled.
    :vartype enable_file_upload_notifications: bool
    :ivar cloud_to_device: The IoT hub cloud-to-device messaging properties.
    :vartype cloud_to_device: ~azure.mgmt.iothub.v2019_03_22.models.CloudToDeviceProperties
    :ivar comments: IoT hub comments.
    :vartype comments: str
    :ivar features: The capabilities and features enabled for the IoT hub. Possible values include:
     "None", "DeviceManagement".
    :vartype features: str or ~azure.mgmt.iothub.v2019_03_22.models.Capabilities
    :ivar locations: Primary and secondary location for iot hub.
    :vartype locations: list[~azure.mgmt.iothub.v2019_03_22.models.IotHubLocationDescription]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'state': {'readonly': True},
        'host_name': {'readonly': True},
        'locations': {'readonly': True},
    }

    _attribute_map = {
        'authorization_policies': {'key': 'authorizationPolicies', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'ip_filter_rules': {'key': 'ipFilterRules', 'type': '[IpFilterRule]'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'host_name': {'key': 'hostName', 'type': 'str'},
        'event_hub_endpoints': {'key': 'eventHubEndpoints', 'type': '{EventHubProperties}'},
        'routing': {'key': 'routing', 'type': 'RoutingProperties'},
        'storage_endpoints': {'key': 'storageEndpoints', 'type': '{StorageEndpointProperties}'},
        'messaging_endpoints': {'key': 'messagingEndpoints', 'type': '{MessagingEndpointProperties}'},
        'enable_file_upload_notifications': {'key': 'enableFileUploadNotifications', 'type': 'bool'},
        'cloud_to_device': {'key': 'cloudToDevice', 'type': 'CloudToDeviceProperties'},
        'comments': {'key': 'comments', 'type': 'str'},
        'features': {'key': 'features', 'type': 'str'},
        'locations': {'key': 'locations', 'type': '[IotHubLocationDescription]'},
    }

    def __init__(
        self,
        *,
        authorization_policies: Optional[List["SharedAccessSignatureAuthorizationRule"]] = None,
        ip_filter_rules: Optional[List["IpFilterRule"]] = None,
        event_hub_endpoints: Optional[Dict[str, "EventHubProperties"]] = None,
        routing: Optional["RoutingProperties"] = None,
        storage_endpoints: Optional[Dict[str, "StorageEndpointProperties"]] = None,
        messaging_endpoints: Optional[Dict[str, "MessagingEndpointProperties"]] = None,
        enable_file_upload_notifications: Optional[bool] = None,
        cloud_to_device: Optional["CloudToDeviceProperties"] = None,
        comments: Optional[str] = None,
        features: Optional[Union[str, "Capabilities"]] = None,
        **kwargs
    ):
        """
        :keyword authorization_policies: The shared access policies you can use to secure a connection
         to the IoT hub.
        :paramtype authorization_policies:
         list[~azure.mgmt.iothub.v2019_03_22.models.SharedAccessSignatureAuthorizationRule]
        :keyword ip_filter_rules: The IP filter rules.
        :paramtype ip_filter_rules: list[~azure.mgmt.iothub.v2019_03_22.models.IpFilterRule]
        :keyword event_hub_endpoints: The Event Hub-compatible endpoint properties. The only possible
         keys to this dictionary is events. This key has to be present in the dictionary while making
         create or update calls for the IoT hub.
        :paramtype event_hub_endpoints: dict[str,
         ~azure.mgmt.iothub.v2019_03_22.models.EventHubProperties]
        :keyword routing: The routing related properties of the IoT hub. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging.
        :paramtype routing: ~azure.mgmt.iothub.v2019_03_22.models.RoutingProperties
        :keyword storage_endpoints: The list of Azure Storage endpoints where you can upload files.
         Currently you can configure only one Azure Storage account and that MUST have its key as
         $default. Specifying more than one storage account causes an error to be thrown. Not specifying
         a value for this property when the enableFileUploadNotifications property is set to True,
         causes an error to be thrown.
        :paramtype storage_endpoints: dict[str,
         ~azure.mgmt.iothub.v2019_03_22.models.StorageEndpointProperties]
        :keyword messaging_endpoints: The messaging endpoint properties for the file upload
         notification queue.
        :paramtype messaging_endpoints: dict[str,
         ~azure.mgmt.iothub.v2019_03_22.models.MessagingEndpointProperties]
        :keyword enable_file_upload_notifications: If True, file upload notifications are enabled.
        :paramtype enable_file_upload_notifications: bool
        :keyword cloud_to_device: The IoT hub cloud-to-device messaging properties.
        :paramtype cloud_to_device: ~azure.mgmt.iothub.v2019_03_22.models.CloudToDeviceProperties
        :keyword comments: IoT hub comments.
        :paramtype comments: str
        :keyword features: The capabilities and features enabled for the IoT hub. Possible values
         include: "None", "DeviceManagement".
        :paramtype features: str or ~azure.mgmt.iothub.v2019_03_22.models.Capabilities
        """
        super(IotHubProperties, self).__init__(**kwargs)
        self.authorization_policies = authorization_policies
        self.ip_filter_rules = ip_filter_rules
        self.provisioning_state = None
        self.state = None
        self.host_name = None
        self.event_hub_endpoints = event_hub_endpoints
        self.routing = routing
        self.storage_endpoints = storage_endpoints
        self.messaging_endpoints = messaging_endpoints
        self.enable_file_upload_notifications = enable_file_upload_notifications
        self.cloud_to_device = cloud_to_device
        self.comments = comments
        self.features = features
        self.locations = None


class IotHubQuotaMetricInfo(msrest.serialization.Model):
    """Quota metrics properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the quota metric.
    :vartype name: str
    :ivar current_value: The current value for the quota metric.
    :vartype current_value: long
    :ivar max_value: The maximum value of the quota metric.
    :vartype max_value: long
    """

    _validation = {
        'name': {'readonly': True},
        'current_value': {'readonly': True},
        'max_value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'long'},
        'max_value': {'key': 'maxValue', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(IotHubQuotaMetricInfo, self).__init__(**kwargs)
        self.name = None
        self.current_value = None
        self.max_value = None


class IotHubQuotaMetricInfoListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubQuotaMetricInfo objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array of quota metrics objects.
    :vartype value: list[~azure.mgmt.iothub.v2019_03_22.models.IotHubQuotaMetricInfo]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubQuotaMetricInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IotHubQuotaMetricInfo"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of quota metrics objects.
        :paramtype value: list[~azure.mgmt.iothub.v2019_03_22.models.IotHubQuotaMetricInfo]
        """
        super(IotHubQuotaMetricInfoListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IotHubSkuDescription(msrest.serialization.Model):
    """SKU properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar resource_type: The type of the resource.
    :vartype resource_type: str
    :ivar sku: Required. The type of the resource.
    :vartype sku: ~azure.mgmt.iothub.v2019_03_22.models.IotHubSkuInfo
    :ivar capacity: Required. IotHub capacity.
    :vartype capacity: ~azure.mgmt.iothub.v2019_03_22.models.IotHubCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'required': True},
        'capacity': {'required': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'IotHubSkuInfo'},
        'capacity': {'key': 'capacity', 'type': 'IotHubCapacity'},
    }

    def __init__(
        self,
        *,
        sku: "IotHubSkuInfo",
        capacity: "IotHubCapacity",
        **kwargs
    ):
        """
        :keyword sku: Required. The type of the resource.
        :paramtype sku: ~azure.mgmt.iothub.v2019_03_22.models.IotHubSkuInfo
        :keyword capacity: Required. IotHub capacity.
        :paramtype capacity: ~azure.mgmt.iothub.v2019_03_22.models.IotHubCapacity
        """
        super(IotHubSkuDescription, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = sku
        self.capacity = capacity


class IotHubSkuDescriptionListResult(msrest.serialization.Model):
    """The JSON-serialized array of IotHubSkuDescription objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array of IotHubSkuDescription.
    :vartype value: list[~azure.mgmt.iothub.v2019_03_22.models.IotHubSkuDescription]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[IotHubSkuDescription]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["IotHubSkuDescription"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of IotHubSkuDescription.
        :paramtype value: list[~azure.mgmt.iothub.v2019_03_22.models.IotHubSkuDescription]
        """
        super(IotHubSkuDescriptionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class IotHubSkuInfo(msrest.serialization.Model):
    """Information about the SKU of the IoT hub.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the SKU. Possible values include: "F1", "S1", "S2", "S3",
     "B1", "B2", "B3".
    :vartype name: str or ~azure.mgmt.iothub.v2019_03_22.models.IotHubSku
    :ivar tier: The billing tier for the IoT hub. Possible values include: "Free", "Standard",
     "Basic".
    :vartype tier: str or ~azure.mgmt.iothub.v2019_03_22.models.IotHubSkuTier
    :ivar capacity: The number of provisioned IoT Hub units. See:
     https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
    :vartype capacity: long
    """

    _validation = {
        'name': {'required': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        name: Union[str, "IotHubSku"],
        capacity: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the SKU. Possible values include: "F1", "S1", "S2", "S3",
         "B1", "B2", "B3".
        :paramtype name: str or ~azure.mgmt.iothub.v2019_03_22.models.IotHubSku
        :keyword capacity: The number of provisioned IoT Hub units. See:
         https://docs.microsoft.com/azure/azure-subscription-service-limits#iot-hub-limits.
        :paramtype capacity: long
        """
        super(IotHubSkuInfo, self).__init__(**kwargs)
        self.name = name
        self.tier = None
        self.capacity = capacity


class IpFilterRule(msrest.serialization.Model):
    """The IP filter rules for the IoT hub.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_name: Required. The name of the IP filter rule.
    :vartype filter_name: str
    :ivar action: Required. The desired action for requests captured by this rule. Possible values
     include: "Accept", "Reject".
    :vartype action: str or ~azure.mgmt.iothub.v2019_03_22.models.IpFilterActionType
    :ivar ip_mask: Required. A string that contains the IP address range in CIDR notation for the
     rule.
    :vartype ip_mask: str
    """

    _validation = {
        'filter_name': {'required': True},
        'action': {'required': True},
        'ip_mask': {'required': True},
    }

    _attribute_map = {
        'filter_name': {'key': 'filterName', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        filter_name: str,
        action: Union[str, "IpFilterActionType"],
        ip_mask: str,
        **kwargs
    ):
        """
        :keyword filter_name: Required. The name of the IP filter rule.
        :paramtype filter_name: str
        :keyword action: Required. The desired action for requests captured by this rule. Possible
         values include: "Accept", "Reject".
        :paramtype action: str or ~azure.mgmt.iothub.v2019_03_22.models.IpFilterActionType
        :keyword ip_mask: Required. A string that contains the IP address range in CIDR notation for
         the rule.
        :paramtype ip_mask: str
        """
        super(IpFilterRule, self).__init__(**kwargs)
        self.filter_name = filter_name
        self.action = action
        self.ip_mask = ip_mask


class JobResponse(msrest.serialization.Model):
    """The properties of the Job Response object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_id: The job identifier.
    :vartype job_id: str
    :ivar start_time_utc: The start time of the job.
    :vartype start_time_utc: ~datetime.datetime
    :ivar end_time_utc: The time the job stopped processing.
    :vartype end_time_utc: ~datetime.datetime
    :ivar type: The type of the job. Possible values include: "unknown", "export", "import",
     "backup", "readDeviceProperties", "writeDeviceProperties", "updateDeviceConfiguration",
     "rebootDevice", "factoryResetDevice", "firmwareUpdate".
    :vartype type: str or ~azure.mgmt.iothub.v2019_03_22.models.JobType
    :ivar status: The status of the job. Possible values include: "unknown", "enqueued", "running",
     "completed", "failed", "cancelled".
    :vartype status: str or ~azure.mgmt.iothub.v2019_03_22.models.JobStatus
    :ivar failure_reason: If status == failed, this string containing the reason for the failure.
    :vartype failure_reason: str
    :ivar status_message: The status message for the job.
    :vartype status_message: str
    :ivar parent_job_id: The job identifier of the parent job, if any.
    :vartype parent_job_id: str
    """

    _validation = {
        'job_id': {'readonly': True},
        'start_time_utc': {'readonly': True},
        'end_time_utc': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'failure_reason': {'readonly': True},
        'status_message': {'readonly': True},
        'parent_job_id': {'readonly': True},
    }

    _attribute_map = {
        'job_id': {'key': 'jobId', 'type': 'str'},
        'start_time_utc': {'key': 'startTimeUtc', 'type': 'rfc-1123'},
        'end_time_utc': {'key': 'endTimeUtc', 'type': 'rfc-1123'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'failure_reason': {'key': 'failureReason', 'type': 'str'},
        'status_message': {'key': 'statusMessage', 'type': 'str'},
        'parent_job_id': {'key': 'parentJobId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(JobResponse, self).__init__(**kwargs)
        self.job_id = None
        self.start_time_utc = None
        self.end_time_utc = None
        self.type = None
        self.status = None
        self.failure_reason = None
        self.status_message = None
        self.parent_job_id = None


class JobResponseListResult(msrest.serialization.Model):
    """The JSON-serialized array of JobResponse objects with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The array of JobResponse objects.
    :vartype value: list[~azure.mgmt.iothub.v2019_03_22.models.JobResponse]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[JobResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["JobResponse"]] = None,
        **kwargs
    ):
        """
        :keyword value: The array of JobResponse objects.
        :paramtype value: list[~azure.mgmt.iothub.v2019_03_22.models.JobResponse]
        """
        super(JobResponseListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class MatchedRoute(msrest.serialization.Model):
    """Routes that matched.

    :ivar properties: Properties of routes that matched.
    :vartype properties: ~azure.mgmt.iothub.v2019_03_22.models.RouteProperties
    """

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'RouteProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["RouteProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of routes that matched.
        :paramtype properties: ~azure.mgmt.iothub.v2019_03_22.models.RouteProperties
        """
        super(MatchedRoute, self).__init__(**kwargs)
        self.properties = properties


class MessagingEndpointProperties(msrest.serialization.Model):
    """The properties of the messaging endpoints used by this IoT hub.

    :ivar lock_duration_as_iso8601: The lock duration. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :vartype lock_duration_as_iso8601: ~datetime.timedelta
    :ivar ttl_as_iso8601: The period of time for which a message is available to consume before it
     is expired by the IoT hub. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :vartype ttl_as_iso8601: ~datetime.timedelta
    :ivar max_delivery_count: The number of times the IoT hub attempts to deliver a message. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
    :vartype max_delivery_count: int
    """

    _validation = {
        'max_delivery_count': {'maximum': 100, 'minimum': 1},
    }

    _attribute_map = {
        'lock_duration_as_iso8601': {'key': 'lockDurationAsIso8601', 'type': 'duration'},
        'ttl_as_iso8601': {'key': 'ttlAsIso8601', 'type': 'duration'},
        'max_delivery_count': {'key': 'maxDeliveryCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lock_duration_as_iso8601: Optional[datetime.timedelta] = None,
        ttl_as_iso8601: Optional[datetime.timedelta] = None,
        max_delivery_count: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword lock_duration_as_iso8601: The lock duration. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        :paramtype lock_duration_as_iso8601: ~datetime.timedelta
        :keyword ttl_as_iso8601: The period of time for which a message is available to consume before
         it is expired by the IoT hub. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        :paramtype ttl_as_iso8601: ~datetime.timedelta
        :keyword max_delivery_count: The number of times the IoT hub attempts to deliver a message.
         See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload.
        :paramtype max_delivery_count: int
        """
        super(MessagingEndpointProperties, self).__init__(**kwargs)
        self.lock_duration_as_iso8601 = lock_duration_as_iso8601
        self.ttl_as_iso8601 = ttl_as_iso8601
        self.max_delivery_count = max_delivery_count


class Name(msrest.serialization.Model):
    """Name of Iot Hub type.

    :ivar value: IotHub type.
    :vartype value: str
    :ivar localized_value: Localized value of name.
    :vartype localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: IotHub type.
        :paramtype value: str
        :keyword localized_value: Localized value of name.
        :paramtype localized_value: str
        """
        super(Name, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class Operation(msrest.serialization.Model):
    """IoT Hub REST API operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Operation name: {provider}/{resource}/{read | write | action | delete}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.iothub.v2019_03_22.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(
        self,
        *,
        display: Optional["OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword display: The object that represents the operation.
        :paramtype display: ~azure.mgmt.iothub.v2019_03_22.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = display


class OperationDisplay(msrest.serialization.Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: Service provider: Microsoft Devices.
    :vartype provider: str
    :ivar resource: Resource Type: IotHubs.
    :vartype resource: str
    :ivar operation: Name of the operation.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationInputs(msrest.serialization.Model):
    """Input values.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the IoT hub to check.
    :vartype name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the IoT hub to check.
        :paramtype name: str
        """
        super(OperationInputs, self).__init__(**kwargs)
        self.name = name


class OperationListResult(msrest.serialization.Model):
    """Result of the request to list IoT Hub operations. It contains a list of operations and a URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of IoT Hub operations supported by the Microsoft.Devices resource provider.
    :vartype value: list[~azure.mgmt.iothub.v2019_03_22.models.Operation]
    :ivar next_link: URL to get the next set of operation list results if there are any.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class RegistryStatistics(msrest.serialization.Model):
    """Identity registry statistics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total_device_count: The total count of devices in the identity registry.
    :vartype total_device_count: long
    :ivar enabled_device_count: The count of enabled devices in the identity registry.
    :vartype enabled_device_count: long
    :ivar disabled_device_count: The count of disabled devices in the identity registry.
    :vartype disabled_device_count: long
    """

    _validation = {
        'total_device_count': {'readonly': True},
        'enabled_device_count': {'readonly': True},
        'disabled_device_count': {'readonly': True},
    }

    _attribute_map = {
        'total_device_count': {'key': 'totalDeviceCount', 'type': 'long'},
        'enabled_device_count': {'key': 'enabledDeviceCount', 'type': 'long'},
        'disabled_device_count': {'key': 'disabledDeviceCount', 'type': 'long'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(RegistryStatistics, self).__init__(**kwargs)
        self.total_device_count = None
        self.enabled_device_count = None
        self.disabled_device_count = None


class RouteCompilationError(msrest.serialization.Model):
    """Compilation error when evaluating route.

    :ivar message: Route error message.
    :vartype message: str
    :ivar severity: Severity of the route error. Possible values include: "error", "warning".
    :vartype severity: str or ~azure.mgmt.iothub.v2019_03_22.models.RouteErrorSeverity
    :ivar location: Location where the route error happened.
    :vartype location: ~azure.mgmt.iothub.v2019_03_22.models.RouteErrorRange
    """

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'location': {'key': 'location', 'type': 'RouteErrorRange'},
    }

    def __init__(
        self,
        *,
        message: Optional[str] = None,
        severity: Optional[Union[str, "RouteErrorSeverity"]] = None,
        location: Optional["RouteErrorRange"] = None,
        **kwargs
    ):
        """
        :keyword message: Route error message.
        :paramtype message: str
        :keyword severity: Severity of the route error. Possible values include: "error", "warning".
        :paramtype severity: str or ~azure.mgmt.iothub.v2019_03_22.models.RouteErrorSeverity
        :keyword location: Location where the route error happened.
        :paramtype location: ~azure.mgmt.iothub.v2019_03_22.models.RouteErrorRange
        """
        super(RouteCompilationError, self).__init__(**kwargs)
        self.message = message
        self.severity = severity
        self.location = location


class RouteErrorPosition(msrest.serialization.Model):
    """Position where the route error happened.

    :ivar line: Line where the route error happened.
    :vartype line: int
    :ivar column: Column where the route error happened.
    :vartype column: int
    """

    _attribute_map = {
        'line': {'key': 'line', 'type': 'int'},
        'column': {'key': 'column', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        line: Optional[int] = None,
        column: Optional[int] = None,
        **kwargs
    ):
        """
        :keyword line: Line where the route error happened.
        :paramtype line: int
        :keyword column: Column where the route error happened.
        :paramtype column: int
        """
        super(RouteErrorPosition, self).__init__(**kwargs)
        self.line = line
        self.column = column


class RouteErrorRange(msrest.serialization.Model):
    """Range of route errors.

    :ivar start: Start where the route error happened.
    :vartype start: ~azure.mgmt.iothub.v2019_03_22.models.RouteErrorPosition
    :ivar end: End where the route error happened.
    :vartype end: ~azure.mgmt.iothub.v2019_03_22.models.RouteErrorPosition
    """

    _attribute_map = {
        'start': {'key': 'start', 'type': 'RouteErrorPosition'},
        'end': {'key': 'end', 'type': 'RouteErrorPosition'},
    }

    def __init__(
        self,
        *,
        start: Optional["RouteErrorPosition"] = None,
        end: Optional["RouteErrorPosition"] = None,
        **kwargs
    ):
        """
        :keyword start: Start where the route error happened.
        :paramtype start: ~azure.mgmt.iothub.v2019_03_22.models.RouteErrorPosition
        :keyword end: End where the route error happened.
        :paramtype end: ~azure.mgmt.iothub.v2019_03_22.models.RouteErrorPosition
        """
        super(RouteErrorRange, self).__init__(**kwargs)
        self.start = start
        self.end = end


class RouteProperties(msrest.serialization.Model):
    """The properties of a routing rule that your IoT hub uses to route messages to endpoints.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. The name of the route. The name can only include alphanumeric characters,
     periods, underscores, hyphens, has a maximum length of 64 characters, and must be unique.
    :vartype name: str
    :ivar source: Required. The source that the routing rule is to be applied to, such as
     DeviceMessages. Possible values include: "Invalid", "DeviceMessages", "TwinChangeEvents",
     "DeviceLifecycleEvents", "DeviceJobLifecycleEvents".
    :vartype source: str or ~azure.mgmt.iothub.v2019_03_22.models.RoutingSource
    :ivar condition: The condition that is evaluated to apply the routing rule. If no condition is
     provided, it evaluates to true by default. For grammar, see:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language.
    :vartype condition: str
    :ivar endpoint_names: Required. The list of endpoints to which messages that satisfy the
     condition are routed. Currently only one endpoint is allowed.
    :vartype endpoint_names: list[str]
    :ivar is_enabled: Required. Used to specify whether a route is enabled.
    :vartype is_enabled: bool
    """

    _validation = {
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
        'source': {'required': True},
        'endpoint_names': {'required': True, 'max_items': 1, 'min_items': 1},
        'is_enabled': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'source': {'key': 'source', 'type': 'str'},
        'condition': {'key': 'condition', 'type': 'str'},
        'endpoint_names': {'key': 'endpointNames', 'type': '[str]'},
        'is_enabled': {'key': 'isEnabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        source: Union[str, "RoutingSource"],
        endpoint_names: List[str],
        is_enabled: bool,
        condition: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword name: Required. The name of the route. The name can only include alphanumeric
         characters, periods, underscores, hyphens, has a maximum length of 64 characters, and must be
         unique.
        :paramtype name: str
        :keyword source: Required. The source that the routing rule is to be applied to, such as
         DeviceMessages. Possible values include: "Invalid", "DeviceMessages", "TwinChangeEvents",
         "DeviceLifecycleEvents", "DeviceJobLifecycleEvents".
        :paramtype source: str or ~azure.mgmt.iothub.v2019_03_22.models.RoutingSource
        :keyword condition: The condition that is evaluated to apply the routing rule. If no condition
         is provided, it evaluates to true by default. For grammar, see:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-query-language.
        :paramtype condition: str
        :keyword endpoint_names: Required. The list of endpoints to which messages that satisfy the
         condition are routed. Currently only one endpoint is allowed.
        :paramtype endpoint_names: list[str]
        :keyword is_enabled: Required. Used to specify whether a route is enabled.
        :paramtype is_enabled: bool
        """
        super(RouteProperties, self).__init__(**kwargs)
        self.name = name
        self.source = source
        self.condition = condition
        self.endpoint_names = endpoint_names
        self.is_enabled = is_enabled


class RoutingEndpoints(msrest.serialization.Model):
    """The properties related to the custom endpoints to which your IoT hub routes messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types for free hubs.

    :ivar service_bus_queues: The list of Service Bus queue endpoints that IoT hub routes the
     messages to, based on the routing rules.
    :vartype service_bus_queues:
     list[~azure.mgmt.iothub.v2019_03_22.models.RoutingServiceBusQueueEndpointProperties]
    :ivar service_bus_topics: The list of Service Bus topic endpoints that the IoT hub routes the
     messages to, based on the routing rules.
    :vartype service_bus_topics:
     list[~azure.mgmt.iothub.v2019_03_22.models.RoutingServiceBusTopicEndpointProperties]
    :ivar event_hubs: The list of Event Hubs endpoints that IoT hub routes messages to, based on
     the routing rules. This list does not include the built-in Event Hubs endpoint.
    :vartype event_hubs: list[~azure.mgmt.iothub.v2019_03_22.models.RoutingEventHubProperties]
    :ivar storage_containers: The list of storage container endpoints that IoT hub routes messages
     to, based on the routing rules.
    :vartype storage_containers:
     list[~azure.mgmt.iothub.v2019_03_22.models.RoutingStorageContainerProperties]
    """

    _attribute_map = {
        'service_bus_queues': {'key': 'serviceBusQueues', 'type': '[RoutingServiceBusQueueEndpointProperties]'},
        'service_bus_topics': {'key': 'serviceBusTopics', 'type': '[RoutingServiceBusTopicEndpointProperties]'},
        'event_hubs': {'key': 'eventHubs', 'type': '[RoutingEventHubProperties]'},
        'storage_containers': {'key': 'storageContainers', 'type': '[RoutingStorageContainerProperties]'},
    }

    def __init__(
        self,
        *,
        service_bus_queues: Optional[List["RoutingServiceBusQueueEndpointProperties"]] = None,
        service_bus_topics: Optional[List["RoutingServiceBusTopicEndpointProperties"]] = None,
        event_hubs: Optional[List["RoutingEventHubProperties"]] = None,
        storage_containers: Optional[List["RoutingStorageContainerProperties"]] = None,
        **kwargs
    ):
        """
        :keyword service_bus_queues: The list of Service Bus queue endpoints that IoT hub routes the
         messages to, based on the routing rules.
        :paramtype service_bus_queues:
         list[~azure.mgmt.iothub.v2019_03_22.models.RoutingServiceBusQueueEndpointProperties]
        :keyword service_bus_topics: The list of Service Bus topic endpoints that the IoT hub routes
         the messages to, based on the routing rules.
        :paramtype service_bus_topics:
         list[~azure.mgmt.iothub.v2019_03_22.models.RoutingServiceBusTopicEndpointProperties]
        :keyword event_hubs: The list of Event Hubs endpoints that IoT hub routes messages to, based on
         the routing rules. This list does not include the built-in Event Hubs endpoint.
        :paramtype event_hubs: list[~azure.mgmt.iothub.v2019_03_22.models.RoutingEventHubProperties]
        :keyword storage_containers: The list of storage container endpoints that IoT hub routes
         messages to, based on the routing rules.
        :paramtype storage_containers:
         list[~azure.mgmt.iothub.v2019_03_22.models.RoutingStorageContainerProperties]
        """
        super(RoutingEndpoints, self).__init__(**kwargs)
        self.service_bus_queues = service_bus_queues
        self.service_bus_topics = service_bus_topics
        self.event_hubs = event_hubs
        self.storage_containers = storage_containers


class RoutingEventHubProperties(msrest.serialization.Model):
    """The properties related to an event hub endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: Required. The connection string of the event hub endpoint.
    :vartype connection_string: str
    :ivar name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
     names must be unique across endpoint types.
    :vartype name: str
    :ivar subscription_id: The subscription identifier of the event hub endpoint.
    :vartype subscription_id: str
    :ivar resource_group: The name of the resource group of the event hub endpoint.
    :vartype resource_group: str
    """

    _validation = {
        'connection_string': {'required': True},
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: str,
        name: str,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword connection_string: Required. The connection string of the event hub endpoint.
        :paramtype connection_string: str
        :keyword name: Required. The name that identifies this endpoint. The name can only include
         alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
         characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
         names must be unique across endpoint types.
        :paramtype name: str
        :keyword subscription_id: The subscription identifier of the event hub endpoint.
        :paramtype subscription_id: str
        :keyword resource_group: The name of the resource group of the event hub endpoint.
        :paramtype resource_group: str
        """
        super(RoutingEventHubProperties, self).__init__(**kwargs)
        self.connection_string = connection_string
        self.name = name
        self.subscription_id = subscription_id
        self.resource_group = resource_group


class RoutingMessage(msrest.serialization.Model):
    """Routing message.

    :ivar body: Body of routing message.
    :vartype body: str
    :ivar app_properties: App properties.
    :vartype app_properties: dict[str, str]
    :ivar system_properties: System properties.
    :vartype system_properties: dict[str, str]
    """

    _attribute_map = {
        'body': {'key': 'body', 'type': 'str'},
        'app_properties': {'key': 'appProperties', 'type': '{str}'},
        'system_properties': {'key': 'systemProperties', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        body: Optional[str] = None,
        app_properties: Optional[Dict[str, str]] = None,
        system_properties: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword body: Body of routing message.
        :paramtype body: str
        :keyword app_properties: App properties.
        :paramtype app_properties: dict[str, str]
        :keyword system_properties: System properties.
        :paramtype system_properties: dict[str, str]
        """
        super(RoutingMessage, self).__init__(**kwargs)
        self.body = body
        self.app_properties = app_properties
        self.system_properties = system_properties


class RoutingProperties(msrest.serialization.Model):
    """The routing related properties of the IoT hub. See: https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging.

    :ivar endpoints: The properties related to the custom endpoints to which your IoT hub routes
     messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all
     endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types
     for free hubs.
    :vartype endpoints: ~azure.mgmt.iothub.v2019_03_22.models.RoutingEndpoints
    :ivar routes: The list of user-provided routing rules that the IoT hub uses to route messages
     to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid hubs and
     a maximum of 5 routing rules are allowed for free hubs.
    :vartype routes: list[~azure.mgmt.iothub.v2019_03_22.models.RouteProperties]
    :ivar fallback_route: The properties of the route that is used as a fall-back route when none
     of the conditions specified in the 'routes' section are met. This is an optional parameter.
     When this property is not set, the messages which do not meet any of the conditions specified
     in the 'routes' section get routed to the built-in eventhub endpoint.
    :vartype fallback_route: ~azure.mgmt.iothub.v2019_03_22.models.FallbackRouteProperties
    """

    _attribute_map = {
        'endpoints': {'key': 'endpoints', 'type': 'RoutingEndpoints'},
        'routes': {'key': 'routes', 'type': '[RouteProperties]'},
        'fallback_route': {'key': 'fallbackRoute', 'type': 'FallbackRouteProperties'},
    }

    def __init__(
        self,
        *,
        endpoints: Optional["RoutingEndpoints"] = None,
        routes: Optional[List["RouteProperties"]] = None,
        fallback_route: Optional["FallbackRouteProperties"] = None,
        **kwargs
    ):
        """
        :keyword endpoints: The properties related to the custom endpoints to which your IoT hub routes
         messages based on the routing rules. A maximum of 10 custom endpoints are allowed across all
         endpoint types for paid hubs and only 1 custom endpoint is allowed across all endpoint types
         for free hubs.
        :paramtype endpoints: ~azure.mgmt.iothub.v2019_03_22.models.RoutingEndpoints
        :keyword routes: The list of user-provided routing rules that the IoT hub uses to route
         messages to built-in and custom endpoints. A maximum of 100 routing rules are allowed for paid
         hubs and a maximum of 5 routing rules are allowed for free hubs.
        :paramtype routes: list[~azure.mgmt.iothub.v2019_03_22.models.RouteProperties]
        :keyword fallback_route: The properties of the route that is used as a fall-back route when
         none of the conditions specified in the 'routes' section are met. This is an optional
         parameter. When this property is not set, the messages which do not meet any of the conditions
         specified in the 'routes' section get routed to the built-in eventhub endpoint.
        :paramtype fallback_route: ~azure.mgmt.iothub.v2019_03_22.models.FallbackRouteProperties
        """
        super(RoutingProperties, self).__init__(**kwargs)
        self.endpoints = endpoints
        self.routes = routes
        self.fallback_route = fallback_route


class RoutingServiceBusQueueEndpointProperties(msrest.serialization.Model):
    """The properties related to service bus queue endpoint types.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: Required. The connection string of the service bus queue endpoint.
    :vartype connection_string: str
    :ivar name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
     names must be unique across endpoint types. The name need not be the same as the actual queue
     name.
    :vartype name: str
    :ivar subscription_id: The subscription identifier of the service bus queue endpoint.
    :vartype subscription_id: str
    :ivar resource_group: The name of the resource group of the service bus queue endpoint.
    :vartype resource_group: str
    """

    _validation = {
        'connection_string': {'required': True},
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: str,
        name: str,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword connection_string: Required. The connection string of the service bus queue endpoint.
        :paramtype connection_string: str
        :keyword name: Required. The name that identifies this endpoint. The name can only include
         alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
         characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
         names must be unique across endpoint types. The name need not be the same as the actual queue
         name.
        :paramtype name: str
        :keyword subscription_id: The subscription identifier of the service bus queue endpoint.
        :paramtype subscription_id: str
        :keyword resource_group: The name of the resource group of the service bus queue endpoint.
        :paramtype resource_group: str
        """
        super(RoutingServiceBusQueueEndpointProperties, self).__init__(**kwargs)
        self.connection_string = connection_string
        self.name = name
        self.subscription_id = subscription_id
        self.resource_group = resource_group


class RoutingServiceBusTopicEndpointProperties(msrest.serialization.Model):
    """The properties related to service bus topic endpoint types.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: Required. The connection string of the service bus topic endpoint.
    :vartype connection_string: str
    :ivar name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
     names must be unique across endpoint types.  The name need not be the same as the actual topic
     name.
    :vartype name: str
    :ivar subscription_id: The subscription identifier of the service bus topic endpoint.
    :vartype subscription_id: str
    :ivar resource_group: The name of the resource group of the service bus topic endpoint.
    :vartype resource_group: str
    """

    _validation = {
        'connection_string': {'required': True},
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: str,
        name: str,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword connection_string: Required. The connection string of the service bus topic endpoint.
        :paramtype connection_string: str
        :keyword name: Required. The name that identifies this endpoint. The name can only include
         alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
         characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
         names must be unique across endpoint types.  The name need not be the same as the actual topic
         name.
        :paramtype name: str
        :keyword subscription_id: The subscription identifier of the service bus topic endpoint.
        :paramtype subscription_id: str
        :keyword resource_group: The name of the resource group of the service bus topic endpoint.
        :paramtype resource_group: str
        """
        super(RoutingServiceBusTopicEndpointProperties, self).__init__(**kwargs)
        self.connection_string = connection_string
        self.name = name
        self.subscription_id = subscription_id
        self.resource_group = resource_group


class RoutingStorageContainerProperties(msrest.serialization.Model):
    """The properties related to a storage container endpoint.

    All required parameters must be populated in order to send to Azure.

    :ivar connection_string: Required. The connection string of the storage account.
    :vartype connection_string: str
    :ivar name: Required. The name that identifies this endpoint. The name can only include
     alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
     characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
     names must be unique across endpoint types.
    :vartype name: str
    :ivar subscription_id: The subscription identifier of the storage account.
    :vartype subscription_id: str
    :ivar resource_group: The name of the resource group of the storage account.
    :vartype resource_group: str
    :ivar container_name: Required. The name of storage container in the storage account.
    :vartype container_name: str
    :ivar file_name_format: File name format for the blob. Default format is
     {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be
     reordered.
    :vartype file_name_format: str
    :ivar batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value
     should be between 60 and 720 seconds. Default value is 300 seconds.
    :vartype batch_frequency_in_seconds: int
    :ivar max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage. Value
     should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
    :vartype max_chunk_size_in_bytes: int
    :ivar encoding: Encoding that is used to serialize messages to blobs. Supported values are
     'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'. Possible values include: "Avro",
     "AvroDeflate", "JSON".
    :vartype encoding: str or
     ~azure.mgmt.iothub.v2019_03_22.models.RoutingStorageContainerPropertiesEncoding
    """

    _validation = {
        'connection_string': {'required': True},
        'name': {'required': True, 'pattern': r'^[A-Za-z0-9-._]{1,64}$'},
        'container_name': {'required': True},
        'batch_frequency_in_seconds': {'maximum': 720, 'minimum': 60},
        'max_chunk_size_in_bytes': {'maximum': 524288000, 'minimum': 10485760},
    }

    _attribute_map = {
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'resource_group': {'key': 'resourceGroup', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
        'file_name_format': {'key': 'fileNameFormat', 'type': 'str'},
        'batch_frequency_in_seconds': {'key': 'batchFrequencyInSeconds', 'type': 'int'},
        'max_chunk_size_in_bytes': {'key': 'maxChunkSizeInBytes', 'type': 'int'},
        'encoding': {'key': 'encoding', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: str,
        name: str,
        container_name: str,
        subscription_id: Optional[str] = None,
        resource_group: Optional[str] = None,
        file_name_format: Optional[str] = None,
        batch_frequency_in_seconds: Optional[int] = None,
        max_chunk_size_in_bytes: Optional[int] = None,
        encoding: Optional[Union[str, "RoutingStorageContainerPropertiesEncoding"]] = None,
        **kwargs
    ):
        """
        :keyword connection_string: Required. The connection string of the storage account.
        :paramtype connection_string: str
        :keyword name: Required. The name that identifies this endpoint. The name can only include
         alphanumeric characters, periods, underscores, hyphens and has a maximum length of 64
         characters. The following names are reserved:  events, fileNotifications, $default. Endpoint
         names must be unique across endpoint types.
        :paramtype name: str
        :keyword subscription_id: The subscription identifier of the storage account.
        :paramtype subscription_id: str
        :keyword resource_group: The name of the resource group of the storage account.
        :paramtype resource_group: str
        :keyword container_name: Required. The name of storage container in the storage account.
        :paramtype container_name: str
        :keyword file_name_format: File name format for the blob. Default format is
         {iothub}/{partition}/{YYYY}/{MM}/{DD}/{HH}/{mm}. All parameters are mandatory but can be
         reordered.
        :paramtype file_name_format: str
        :keyword batch_frequency_in_seconds: Time interval at which blobs are written to storage. Value
         should be between 60 and 720 seconds. Default value is 300 seconds.
        :paramtype batch_frequency_in_seconds: int
        :keyword max_chunk_size_in_bytes: Maximum number of bytes for each blob written to storage.
         Value should be between 10485760(10MB) and 524288000(500MB). Default value is 314572800(300MB).
        :paramtype max_chunk_size_in_bytes: int
        :keyword encoding: Encoding that is used to serialize messages to blobs. Supported values are
         'avro', 'avrodeflate', and 'JSON'. Default value is 'avro'. Possible values include: "Avro",
         "AvroDeflate", "JSON".
        :paramtype encoding: str or
         ~azure.mgmt.iothub.v2019_03_22.models.RoutingStorageContainerPropertiesEncoding
        """
        super(RoutingStorageContainerProperties, self).__init__(**kwargs)
        self.connection_string = connection_string
        self.name = name
        self.subscription_id = subscription_id
        self.resource_group = resource_group
        self.container_name = container_name
        self.file_name_format = file_name_format
        self.batch_frequency_in_seconds = batch_frequency_in_seconds
        self.max_chunk_size_in_bytes = max_chunk_size_in_bytes
        self.encoding = encoding


class RoutingTwin(msrest.serialization.Model):
    """Twin reference input parameter. This is an optional parameter.

    :ivar tags: A set of tags. Twin Tags.
    :vartype tags: any
    :ivar properties:
    :vartype properties: ~azure.mgmt.iothub.v2019_03_22.models.RoutingTwinProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': 'object'},
        'properties': {'key': 'properties', 'type': 'RoutingTwinProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Any] = None,
        properties: Optional["RoutingTwinProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Twin Tags.
        :paramtype tags: any
        :keyword properties:
        :paramtype properties: ~azure.mgmt.iothub.v2019_03_22.models.RoutingTwinProperties
        """
        super(RoutingTwin, self).__init__(**kwargs)
        self.tags = tags
        self.properties = properties


class RoutingTwinProperties(msrest.serialization.Model):
    """RoutingTwinProperties.

    :ivar desired: Twin desired properties.
    :vartype desired: any
    :ivar reported: Twin desired properties.
    :vartype reported: any
    """

    _attribute_map = {
        'desired': {'key': 'desired', 'type': 'object'},
        'reported': {'key': 'reported', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        desired: Optional[Any] = None,
        reported: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword desired: Twin desired properties.
        :paramtype desired: any
        :keyword reported: Twin desired properties.
        :paramtype reported: any
        """
        super(RoutingTwinProperties, self).__init__(**kwargs)
        self.desired = desired
        self.reported = reported


class SharedAccessSignatureAuthorizationRule(msrest.serialization.Model):
    """The properties of an IoT hub shared access policy.

    All required parameters must be populated in order to send to Azure.

    :ivar key_name: Required. The name of the shared access policy.
    :vartype key_name: str
    :ivar primary_key: The primary key.
    :vartype primary_key: str
    :ivar secondary_key: The secondary key.
    :vartype secondary_key: str
    :ivar rights: Required. The permissions assigned to the shared access policy. Possible values
     include: "RegistryRead", "RegistryWrite", "ServiceConnect", "DeviceConnect", "RegistryRead,
     RegistryWrite", "RegistryRead, ServiceConnect", "RegistryRead, DeviceConnect", "RegistryWrite,
     ServiceConnect", "RegistryWrite, DeviceConnect", "ServiceConnect, DeviceConnect",
     "RegistryRead, RegistryWrite, ServiceConnect", "RegistryRead, RegistryWrite, DeviceConnect",
     "RegistryRead, ServiceConnect, DeviceConnect", "RegistryWrite, ServiceConnect, DeviceConnect",
     "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect".
    :vartype rights: str or ~azure.mgmt.iothub.v2019_03_22.models.AccessRights
    """

    _validation = {
        'key_name': {'required': True},
        'rights': {'required': True},
    }

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'rights': {'key': 'rights', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_name: str,
        rights: Union[str, "AccessRights"],
        primary_key: Optional[str] = None,
        secondary_key: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword key_name: Required. The name of the shared access policy.
        :paramtype key_name: str
        :keyword primary_key: The primary key.
        :paramtype primary_key: str
        :keyword secondary_key: The secondary key.
        :paramtype secondary_key: str
        :keyword rights: Required. The permissions assigned to the shared access policy. Possible
         values include: "RegistryRead", "RegistryWrite", "ServiceConnect", "DeviceConnect",
         "RegistryRead, RegistryWrite", "RegistryRead, ServiceConnect", "RegistryRead, DeviceConnect",
         "RegistryWrite, ServiceConnect", "RegistryWrite, DeviceConnect", "ServiceConnect,
         DeviceConnect", "RegistryRead, RegistryWrite, ServiceConnect", "RegistryRead, RegistryWrite,
         DeviceConnect", "RegistryRead, ServiceConnect, DeviceConnect", "RegistryWrite, ServiceConnect,
         DeviceConnect", "RegistryRead, RegistryWrite, ServiceConnect, DeviceConnect".
        :paramtype rights: str or ~azure.mgmt.iothub.v2019_03_22.models.AccessRights
        """
        super(SharedAccessSignatureAuthorizationRule, self).__init__(**kwargs)
        self.key_name = key_name
        self.primary_key = primary_key
        self.secondary_key = secondary_key
        self.rights = rights


class SharedAccessSignatureAuthorizationRuleListResult(msrest.serialization.Model):
    """The list of shared access policies with a next link.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of shared access policies.
    :vartype value:
     list[~azure.mgmt.iothub.v2019_03_22.models.SharedAccessSignatureAuthorizationRule]
    :ivar next_link: The next link.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SharedAccessSignatureAuthorizationRule]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["SharedAccessSignatureAuthorizationRule"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of shared access policies.
        :paramtype value:
         list[~azure.mgmt.iothub.v2019_03_22.models.SharedAccessSignatureAuthorizationRule]
        """
        super(SharedAccessSignatureAuthorizationRuleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class StorageEndpointProperties(msrest.serialization.Model):
    """The properties of the Azure Storage endpoint for file upload.

    All required parameters must be populated in order to send to Azure.

    :ivar sas_ttl_as_iso8601: The period of time for which the SAS URI generated by IoT Hub for
     file upload is valid. See:
     https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
    :vartype sas_ttl_as_iso8601: ~datetime.timedelta
    :ivar connection_string: Required. The connection string for the Azure Storage account to which
     files are uploaded.
    :vartype connection_string: str
    :ivar container_name: Required. The name of the root container where you upload files. The
     container need not exist but should be creatable using the connectionString specified.
    :vartype container_name: str
    """

    _validation = {
        'connection_string': {'required': True},
        'container_name': {'required': True},
    }

    _attribute_map = {
        'sas_ttl_as_iso8601': {'key': 'sasTtlAsIso8601', 'type': 'duration'},
        'connection_string': {'key': 'connectionString', 'type': 'str'},
        'container_name': {'key': 'containerName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        connection_string: str,
        container_name: str,
        sas_ttl_as_iso8601: Optional[datetime.timedelta] = None,
        **kwargs
    ):
        """
        :keyword sas_ttl_as_iso8601: The period of time for which the SAS URI generated by IoT Hub for
         file upload is valid. See:
         https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-file-upload#file-upload-notification-configuration-options.
        :paramtype sas_ttl_as_iso8601: ~datetime.timedelta
        :keyword connection_string: Required. The connection string for the Azure Storage account to
         which files are uploaded.
        :paramtype connection_string: str
        :keyword container_name: Required. The name of the root container where you upload files. The
         container need not exist but should be creatable using the connectionString specified.
        :paramtype container_name: str
        """
        super(StorageEndpointProperties, self).__init__(**kwargs)
        self.sas_ttl_as_iso8601 = sas_ttl_as_iso8601
        self.connection_string = connection_string
        self.container_name = container_name


class TagsResource(msrest.serialization.Model):
    """A container holding only the Tags for a resource, allowing the user to update the tags on an IoT Hub instance.

    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(TagsResource, self).__init__(**kwargs)
        self.tags = tags


class TestAllRoutesInput(msrest.serialization.Model):
    """Input for testing all routes.

    :ivar routing_source: Routing source. Possible values include: "Invalid", "DeviceMessages",
     "TwinChangeEvents", "DeviceLifecycleEvents", "DeviceJobLifecycleEvents".
    :vartype routing_source: str or ~azure.mgmt.iothub.v2019_03_22.models.RoutingSource
    :ivar message: Routing message.
    :vartype message: ~azure.mgmt.iothub.v2019_03_22.models.RoutingMessage
    :ivar twin: Routing Twin Reference.
    :vartype twin: ~azure.mgmt.iothub.v2019_03_22.models.RoutingTwin
    """

    _attribute_map = {
        'routing_source': {'key': 'routingSource', 'type': 'str'},
        'message': {'key': 'message', 'type': 'RoutingMessage'},
        'twin': {'key': 'twin', 'type': 'RoutingTwin'},
    }

    def __init__(
        self,
        *,
        routing_source: Optional[Union[str, "RoutingSource"]] = None,
        message: Optional["RoutingMessage"] = None,
        twin: Optional["RoutingTwin"] = None,
        **kwargs
    ):
        """
        :keyword routing_source: Routing source. Possible values include: "Invalid", "DeviceMessages",
         "TwinChangeEvents", "DeviceLifecycleEvents", "DeviceJobLifecycleEvents".
        :paramtype routing_source: str or ~azure.mgmt.iothub.v2019_03_22.models.RoutingSource
        :keyword message: Routing message.
        :paramtype message: ~azure.mgmt.iothub.v2019_03_22.models.RoutingMessage
        :keyword twin: Routing Twin Reference.
        :paramtype twin: ~azure.mgmt.iothub.v2019_03_22.models.RoutingTwin
        """
        super(TestAllRoutesInput, self).__init__(**kwargs)
        self.routing_source = routing_source
        self.message = message
        self.twin = twin


class TestAllRoutesResult(msrest.serialization.Model):
    """Result of testing all routes.

    :ivar routes: JSON-serialized array of matched routes.
    :vartype routes: list[~azure.mgmt.iothub.v2019_03_22.models.MatchedRoute]
    """

    _attribute_map = {
        'routes': {'key': 'routes', 'type': '[MatchedRoute]'},
    }

    def __init__(
        self,
        *,
        routes: Optional[List["MatchedRoute"]] = None,
        **kwargs
    ):
        """
        :keyword routes: JSON-serialized array of matched routes.
        :paramtype routes: list[~azure.mgmt.iothub.v2019_03_22.models.MatchedRoute]
        """
        super(TestAllRoutesResult, self).__init__(**kwargs)
        self.routes = routes


class TestRouteInput(msrest.serialization.Model):
    """Input for testing route.

    All required parameters must be populated in order to send to Azure.

    :ivar message: Routing message.
    :vartype message: ~azure.mgmt.iothub.v2019_03_22.models.RoutingMessage
    :ivar route: Required. Route properties.
    :vartype route: ~azure.mgmt.iothub.v2019_03_22.models.RouteProperties
    :ivar twin: Routing Twin Reference.
    :vartype twin: ~azure.mgmt.iothub.v2019_03_22.models.RoutingTwin
    """

    _validation = {
        'route': {'required': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'RoutingMessage'},
        'route': {'key': 'route', 'type': 'RouteProperties'},
        'twin': {'key': 'twin', 'type': 'RoutingTwin'},
    }

    def __init__(
        self,
        *,
        route: "RouteProperties",
        message: Optional["RoutingMessage"] = None,
        twin: Optional["RoutingTwin"] = None,
        **kwargs
    ):
        """
        :keyword message: Routing message.
        :paramtype message: ~azure.mgmt.iothub.v2019_03_22.models.RoutingMessage
        :keyword route: Required. Route properties.
        :paramtype route: ~azure.mgmt.iothub.v2019_03_22.models.RouteProperties
        :keyword twin: Routing Twin Reference.
        :paramtype twin: ~azure.mgmt.iothub.v2019_03_22.models.RoutingTwin
        """
        super(TestRouteInput, self).__init__(**kwargs)
        self.message = message
        self.route = route
        self.twin = twin


class TestRouteResult(msrest.serialization.Model):
    """Result of testing one route.

    :ivar result: Result of testing route. Possible values include: "undefined", "false", "true".
    :vartype result: str or ~azure.mgmt.iothub.v2019_03_22.models.TestResultStatus
    :ivar details: Detailed result of testing route.
    :vartype details: ~azure.mgmt.iothub.v2019_03_22.models.TestRouteResultDetails
    """

    _attribute_map = {
        'result': {'key': 'result', 'type': 'str'},
        'details': {'key': 'details', 'type': 'TestRouteResultDetails'},
    }

    def __init__(
        self,
        *,
        result: Optional[Union[str, "TestResultStatus"]] = None,
        details: Optional["TestRouteResultDetails"] = None,
        **kwargs
    ):
        """
        :keyword result: Result of testing route. Possible values include: "undefined", "false",
         "true".
        :paramtype result: str or ~azure.mgmt.iothub.v2019_03_22.models.TestResultStatus
        :keyword details: Detailed result of testing route.
        :paramtype details: ~azure.mgmt.iothub.v2019_03_22.models.TestRouteResultDetails
        """
        super(TestRouteResult, self).__init__(**kwargs)
        self.result = result
        self.details = details


class TestRouteResultDetails(msrest.serialization.Model):
    """Detailed result of testing a route.

    :ivar compilation_errors: JSON-serialized list of route compilation errors.
    :vartype compilation_errors: list[~azure.mgmt.iothub.v2019_03_22.models.RouteCompilationError]
    """

    _attribute_map = {
        'compilation_errors': {'key': 'compilationErrors', 'type': '[RouteCompilationError]'},
    }

    def __init__(
        self,
        *,
        compilation_errors: Optional[List["RouteCompilationError"]] = None,
        **kwargs
    ):
        """
        :keyword compilation_errors: JSON-serialized list of route compilation errors.
        :paramtype compilation_errors:
         list[~azure.mgmt.iothub.v2019_03_22.models.RouteCompilationError]
        """
        super(TestRouteResultDetails, self).__init__(**kwargs)
        self.compilation_errors = compilation_errors


class UserSubscriptionQuota(msrest.serialization.Model):
    """User subscription quota response.

    :ivar id: IotHub type id.
    :vartype id: str
    :ivar type: Response type.
    :vartype type: str
    :ivar unit: Unit of IotHub type.
    :vartype unit: str
    :ivar current_value: Current number of IotHub type.
    :vartype current_value: int
    :ivar limit: Numerical limit on IotHub type.
    :vartype limit: int
    :ivar name: IotHub type.
    :vartype name: ~azure.mgmt.iothub.v2019_03_22.models.Name
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'int'},
        'name': {'key': 'name', 'type': 'Name'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        type: Optional[str] = None,
        unit: Optional[str] = None,
        current_value: Optional[int] = None,
        limit: Optional[int] = None,
        name: Optional["Name"] = None,
        **kwargs
    ):
        """
        :keyword id: IotHub type id.
        :paramtype id: str
        :keyword type: Response type.
        :paramtype type: str
        :keyword unit: Unit of IotHub type.
        :paramtype unit: str
        :keyword current_value: Current number of IotHub type.
        :paramtype current_value: int
        :keyword limit: Numerical limit on IotHub type.
        :paramtype limit: int
        :keyword name: IotHub type.
        :paramtype name: ~azure.mgmt.iothub.v2019_03_22.models.Name
        """
        super(UserSubscriptionQuota, self).__init__(**kwargs)
        self.id = id
        self.type = type
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UserSubscriptionQuotaListResult(msrest.serialization.Model):
    """Json-serialized array of User subscription quota response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.iothub.v2019_03_22.models.UserSubscriptionQuota]
    :ivar next_link:
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UserSubscriptionQuota]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["UserSubscriptionQuota"]] = None,
        **kwargs
    ):
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.iothub.v2019_03_22.models.UserSubscriptionQuota]
        """
        super(UserSubscriptionQuotaListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None
