# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class BillingFrequency(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The billing frequency.
    """

    MONTH = "Month"
    QUARTER = "Quarter"
    YEAR = "Year"

class BudgetOperatorType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The operator to use for comparison.
    """

    IN_ENUM = "In"

class CategoryType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The category of the budget, whether the budget tracks cost or usage.
    """

    COST = "Cost"

class ChargeSummaryKind(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the kind of charge summary.
    """

    LEGACY = "legacy"
    MODERN = "modern"

class CultureCode(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Language in which the recipient will receive the notification
    """

    EN_US = "en-us"
    JA_JP = "ja-jp"
    ZH_CN = "zh-cn"
    DE_DE = "de-de"
    ES_ES = "es-es"
    FR_FR = "fr-fr"
    IT_IT = "it-it"
    KO_KR = "ko-kr"
    PT_BR = "pt-br"
    RU_RU = "ru-ru"
    ZH_TW = "zh-tw"
    CS_CZ = "cs-cz"
    PL_PL = "pl-pl"
    TR_TR = "tr-tr"
    DA_DK = "da-dk"
    EN_GB = "en-gb"
    HU_HU = "hu-hu"
    NB_NO = "nb-no"
    NL_NL = "nl-nl"
    PT_PT = "pt-pt"
    SV_SE = "sv-se"

class Datagrain(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    #: Daily grain of data.
    DAILY_GRAIN = "daily"
    #: Monthly grain of data.
    MONTHLY_GRAIN = "monthly"

class EventType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Identifies the type of the event.
    """

    SETTLED_CHARGES = "SettledCharges"
    PENDING_CHARGES = "PendingCharges"
    PENDING_ADJUSTMENTS = "PendingAdjustments"
    PENDING_NEW_CREDIT = "PendingNewCredit"
    PENDING_EXPIRED_CREDIT = "PendingExpiredCredit"
    UN_KNOWN = "UnKnown"
    NEW_CREDIT = "NewCredit"

class LookBackPeriod(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    #: Use 7 days of data for recommendations.
    LAST07_DAYS = "Last7Days"
    #: Use 30 days of data for recommendations.
    LAST30_DAYS = "Last30Days"
    #: Use 60 days of data for recommendations.
    LAST60_DAYS = "Last60Days"

class LotSource(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The source of the lot.
    """

    PURCHASED_CREDIT = "PurchasedCredit"
    PROMOTIONAL_CREDIT = "PromotionalCredit"
    CONSUMPTION_COMMITMENT = "ConsumptionCommitment"

class Metrictype(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    #: Actual cost data.
    ACTUAL_COST_METRIC_TYPE = "actualcost"
    #: Amortized cost data.
    AMORTIZED_COST_METRIC_TYPE = "amortizedcost"
    #: Usage data.
    USAGE_METRIC_TYPE = "usage"

class OperatorType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The comparison operator.
    """

    EQUAL_TO = "EqualTo"
    GREATER_THAN = "GreaterThan"
    GREATER_THAN_OR_EQUAL_TO = "GreaterThanOrEqualTo"

class PricingModelType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Identifier that indicates how the meter is priced.
    """

    ON_DEMAND = "On Demand"
    RESERVATION = "Reservation"
    SPOT = "Spot"

class ReservationRecommendationKind(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the kind of reservation recommendation.
    """

    LEGACY = "legacy"
    MODERN = "modern"

class Scope(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    SINGLE = "Single"
    SHARED = "Shared"

class Status(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The status of the lot.
    """

    NONE = "None"
    ACTIVE = "Active"
    INACTIVE = "Inactive"
    EXPIRED = "Expired"
    COMPLETE = "Complete"
    CANCELED = "Canceled"

class Term(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    #: 1 year reservation term.
    P1_Y = "P1Y"
    #: 3 year reservation term.
    P3_Y = "P3Y"

class ThresholdType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of threshold
    """

    ACTUAL = "Actual"
    FORECASTED = "Forecasted"

class TimeGrainType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The time covered by a budget. Tracking of the amount will be reset based on the time grain.
    BillingMonth, BillingQuarter, and BillingAnnual are only supported by WD customers
    """

    MONTHLY = "Monthly"
    QUARTERLY = "Quarterly"
    ANNUALLY = "Annually"
    BILLING_MONTH = "BillingMonth"
    BILLING_QUARTER = "BillingQuarter"
    BILLING_ANNUAL = "BillingAnnual"

class UsageDetailsKind(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Specifies the kind of usage details.
    """

    LEGACY = "legacy"
    MODERN = "modern"
