/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.HTMLElementBase;
import com.meterware.httpunit.HTMLElementPredicate;
import com.meterware.httpunit.HTMLElementScriptable;
import com.meterware.httpunit.HttpUnitUtils;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.TableCell;
import com.meterware.httpunit.WebResponse;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WebTable
extends HTMLElementBase {
    public static final HTMLElementPredicate MATCH_FIRST_NONBLANK_CELL = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            WebTable table = (WebTable)htmlElement;
            table.purgeEmptyCells();
            return table.getRowCount() > 0 && HttpUnitUtils.matches(table.getCellAsText(0, 0).trim(), (String)criteria);
        }
    };
    public static final HTMLElementPredicate MATCH_FIRST_NONBLANK_CELL_PREFIX = new HTMLElementPredicate(){

        public boolean matchesCriteria(Object htmlElement, Object criteria) {
            WebTable table = (WebTable)htmlElement;
            table.purgeEmptyCells();
            return table.getRowCount() > 0 && HttpUnitUtils.hasPrefix(table.getCellAsText(0, 0).toUpperCase().trim(), (String)criteria);
        }
    };
    public static final HTMLElementPredicate MATCH_SUMMARY;
    public static final HTMLElementPredicate MATCH_ID;
    private Element _dom;
    private URL _url;
    private String _frameName;
    private String _baseTarget;
    private String _characterSet;
    private WebResponse _response;
    private TableCell[][] _cells;
    private ArrayList _rows = new ArrayList();

    public int getRowCount() {
        return this.getCells().length;
    }

    private TableCell[][] getCells() {
        if (this._cells == null) {
            this.readTable();
        }
        return this._cells;
    }

    public int getColumnCount() {
        if (this.getCells().length == 0) {
            return 0;
        }
        return this.getCells()[0].length;
    }

    public String getCellAsText(int row, int column) {
        TableCell cell = this.getTableCell(row, column);
        return cell == null ? "" : cell.asText();
    }

    public TableCell getTableCell(int row, int column) {
        return this.getCells()[row][column];
    }

    public TableCell getTableCellWithID(String id) {
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                TableCell tableCell = this.getCells()[i][j];
                if (tableCell != null && tableCell.getID().equals(id)) {
                    return tableCell;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public void purgeEmptyCells() {
        int numRowsWithText = 0;
        int numColumnsWithText = 0;
        boolean[] rowHasText = new boolean[this.getRowCount()];
        boolean[] columnHasText = new boolean[this.getColumnCount()];
        Hashtable<TableCell, int[]> spanningCells = new Hashtable<TableCell, int[]>();
        int i = 0;
        while (i < rowHasText.length) {
            int j = 0;
            while (j < columnHasText.length) {
                if (this.getCellAsText(i, j).trim().length() != 0) {
                    if (this.getTableCell(i, j).getColSpan() == 1 && this.getTableCell(i, j).getRowSpan() == 1) {
                        if (!rowHasText[i]) {
                            ++numRowsWithText;
                        }
                        if (!columnHasText[j]) {
                            ++numColumnsWithText;
                        }
                        columnHasText[j] = true;
                        rowHasText[i] = true;
                    } else if (!spanningCells.containsKey(this.getTableCell(i, j))) {
                        spanningCells.put(this.getTableCell(i, j), new int[]{i, j});
                    }
                }
                ++j;
            }
            ++i;
        }
        Enumeration e = spanningCells.keys();
        while (e.hasMoreElements()) {
            TableCell cell = (TableCell)e.nextElement();
            int[] coords = (int[])spanningCells.get(cell);
            boolean neededInRow = true;
            boolean neededInCol = true;
            int i2 = coords[0];
            while (neededInRow && i2 < coords[0] + cell.getRowSpan()) {
                neededInRow = !rowHasText[i2];
                ++i2;
            }
            int j = coords[1];
            while (neededInCol && j < coords[1] + cell.getColSpan()) {
                neededInCol = !columnHasText[j];
                ++j;
            }
            if (neededInRow) {
                rowHasText[coords[0]] = true;
                ++numRowsWithText;
            }
            if (!neededInCol) continue;
            columnHasText[coords[1]] = true;
            ++numColumnsWithText;
        }
        TableCell[][] remainingCells = new TableCell[numRowsWithText][numColumnsWithText];
        int targetRow = 0;
        int i3 = 0;
        while (i3 < rowHasText.length) {
            if (rowHasText[i3]) {
                int targetColumn = 0;
                int j = 0;
                while (j < columnHasText.length) {
                    if (columnHasText[j]) {
                        remainingCells[targetRow][targetColumn++] = this._cells[i3][j];
                    }
                    ++j;
                }
                ++targetRow;
            }
            ++i3;
        }
        this._cells = remainingCells;
    }

    public String[][] asText() {
        String[][] result = new String[this.getRowCount()][this.getColumnCount()];
        int i = 0;
        while (i < result.length) {
            int j = 0;
            while (j < result[0].length) {
                result[i][j] = this.getCellAsText(i, j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    public String getSummary() {
        return NodeUtils.getNodeAttribute(this._dom, "summary");
    }

    public String toString() {
        String eol = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer(2048).append("WebTable:").append(eol);
        int i = 0;
        while (i < this.getCells().length) {
            sb.append("[").append(i).append("]: ");
            int j = 0;
            while (j < this.getCells()[i].length) {
                sb.append("  [").append(j).append("]=");
                if (this.getCells()[i][j] == null) {
                    sb.append("null");
                } else {
                    sb.append(this.getCells()[i][j].asText());
                }
                ++j;
            }
            sb.append(eol);
            ++i;
        }
        return sb.toString();
    }

    protected ScriptableDelegate newScriptable() {
        return new HTMLElementScriptable(this);
    }

    protected ScriptableDelegate getParentDelegate() {
        return this._response.getScriptableObject().getDocument();
    }

    WebTable(WebResponse response, String frameName, Node domTreeRoot, URL sourceURL, String baseTarget, String characterSet) {
        super(domTreeRoot);
        this._response = response;
        this._frameName = frameName;
        this._dom = (Element)domTreeRoot;
        this._url = sourceURL;
        this._baseTarget = baseTarget;
        this._characterSet = characterSet;
    }

    private void readTable() {
        TableRow[] rows = this.getRows();
        int[] columnsRequired = new int[rows.length];
        int i = 0;
        while (i < rows.length) {
            TableCell[] cells = rows[i].getCells();
            int j = 0;
            while (j < cells.length) {
                int spannedRows = Math.min(columnsRequired.length - i, cells[j].getRowSpan());
                int k = 0;
                while (k < spannedRows) {
                    int n = i + k;
                    columnsRequired[n] = columnsRequired[n] + cells[j].getColSpan();
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        int numColumns = 0;
        int i2 = 0;
        while (i2 < columnsRequired.length) {
            numColumns = Math.max(numColumns, columnsRequired[i2]);
            ++i2;
        }
        this._cells = new TableCell[columnsRequired.length][numColumns];
        int i3 = 0;
        while (i3 < rows.length) {
            TableCell[] cells = rows[i3].getCells();
            int j = 0;
            while (j < cells.length) {
                int spannedRows = Math.min(columnsRequired.length - i3, cells[j].getRowSpan());
                int k = 0;
                while (k < spannedRows) {
                    int l = 0;
                    while (l < cells[j].getColSpan()) {
                        this.placeCell(i3 + k, j + l, cells[j]);
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
    }

    private void placeCell(int row, int column, TableCell cell) {
        while (this._cells[row][column] != null) {
            ++column;
        }
        this._cells[row][column] = cell;
    }

    void addRow(TableRow tableRow) {
        this._cells = null;
        this._rows.add(tableRow);
    }

    TableRow newTableRow(Element element) {
        return new TableRow(element);
    }

    private TableRow[] getRows() {
        return this._rows.toArray(new TableRow[this._rows.size()]);
    }

    static {
        MATCH_ID = new HTMLElementPredicate(){

            public boolean matchesCriteria(Object htmlElement, Object criteria) {
                return HttpUnitUtils.matches(((WebTable)htmlElement).getID(), (String)criteria);
            }
        };
        MATCH_SUMMARY = new HTMLElementPredicate(){

            public boolean matchesCriteria(Object htmlElement, Object criteria) {
                return HttpUnitUtils.matches(((WebTable)htmlElement).getSummary(), (String)criteria);
            }
        };
    }

    class TableRow
    extends HTMLElementBase {
        private ArrayList _cells = new ArrayList();

        TableRow(Element rowNode) {
            super(rowNode);
        }

        TableCell[] getCells() {
            return this._cells.toArray(new TableCell[this._cells.size()]);
        }

        TableCell newTableCell(Element element) {
            return new TableCell(WebTable.this._response, WebTable.this._frameName, element, WebTable.this._url, WebTable.this._baseTarget, WebTable.this._characterSet);
        }

        void addTableCell(TableCell cell) {
            this._cells.add(cell);
        }

        protected ScriptableDelegate newScriptable() {
            return new HTMLElementScriptable(this);
        }

        protected ScriptableDelegate getParentDelegate() {
            return WebTable.this._response.getScriptableObject().getDocument();
        }
    }
}

