/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.core.session;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import org.islandoftex.arara.api.AraraException;
import org.islandoftex.arara.api.session.Command;
import org.islandoftex.arara.core.localization.LanguageController;
import org.islandoftex.arara.core.session.Environment;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.listener.ShutdownHookProcessDestroyer;
import org.zeroturnaround.exec.stream.TeeOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0010H\u0007J=\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00100\u00152\u0006\u0010\u0011\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\u00062\b\b\u0002\u0010\u0018\u001a\u00020\u0019H\u0007\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u0010H\u0007J\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0007J\u0010\u0010 \u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b\u0019\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006!"}, d2={"Lorg/islandoftex/arara/core/session/Environment;", "", "()V", "errorExitStatus", "", "inCygwinEnvironment", "", "getInCygwinEnvironment", "()Z", "inCygwinEnvironment$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "appendExtensions", "", "", "command", "checkOS", "value", "executeSystemCommand", "Lkotlin/Pair;", "Lorg/islandoftex/arara/api/session/Command;", "silenceSystemOut", "timeout", "Lkotlin/time/Duration;", "executeSystemCommand-SxA4cEA", "(Lorg/islandoftex/arara/api/session/Command;ZD)Lkotlin/Pair;", "getSystemProperty", "key", "fallback", "getSystemPropertyOrNull", "isOnPath", "core"})
public final class Environment {
    private static final Logger logger;
    private static final Lazy inCygwinEnvironment$delegate;
    public static final int errorExitStatus = -99;
    @NotNull
    public static final Environment INSTANCE;

    @JvmStatic
    @NotNull
    public static final String getSystemProperty(@NotNull String key, @NotNull String fallback) {
        Object object;
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(fallback, "fallback");
        Object object2 = System.getProperties();
        boolean bl = false;
        try {
            object = Result.Companion;
            Properties $this$runCatching = object2;
            boolean bl2 = false;
            String string = $this$runCatching.getOrDefault((Object)key, fallback).toString();
            boolean bl3 = false;
            boolean bl4 = false;
            String it = string;
            boolean bl5 = false;
            String string2 = Intrinsics.areEqual(it, "") ^ true ? string : null;
            boolean bl6 = false;
            object = Result.constructor-impl(string2);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl7 = false;
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        bl = false;
        String string = (String)(Result.isFailure-impl(object2) ? null : object2);
        if (string == null) {
            string = fallback;
        }
        return string;
    }

    @JvmStatic
    @Nullable
    public static final String getSystemPropertyOrNull(@NotNull String key) {
        Object object;
        Intrinsics.checkNotNullParameter(key, "key");
        Object object2 = System.getProperties();
        boolean bl = false;
        try {
            object = Result.Companion;
            Properties $this$runCatching = object2;
            boolean bl2 = false;
            String string = MapsKt.getValue($this$runCatching, key).toString();
            boolean bl3 = false;
            object = Result.constructor-impl(string);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        object2 = object;
        bl = false;
        return (String)(Result.isFailure-impl(object2) ? null : object2);
    }

    private final boolean getInCygwinEnvironment() {
        Lazy lazy = inCygwinEnvironment$delegate;
        Environment environment = this;
        Object var3_3 = null;
        boolean bl = false;
        return (Boolean)lazy.getValue();
    }

    @JvmStatic
    public static final boolean checkOS(@NotNull String value) throws AraraException {
        Intrinsics.checkNotNullParameter(value, "value");
        checkOS.1 $fun$checkOSProperty$1 = checkOS.1.INSTANCE;
        boolean bl = false;
        Map values2 = new LinkedHashMap();
        values2.put("windows", $fun$checkOSProperty$1.invoke("Windows"));
        values2.put("linux", $fun$checkOSProperty$1.invoke("Linux"));
        values2.put("mac", $fun$checkOSProperty$1.invoke("Mac OS X"));
        values2.put("unix", $fun$checkOSProperty$1.invoke("Mac OS X") || $fun$checkOSProperty$1.invoke("Linux"));
        values2.put("cygwin", INSTANCE.getInCygwinEnvironment());
        String string = value;
        boolean bl2 = false;
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).toLowerCase()");
        if (!values2.containsKey(string2)) {
            string = LanguageController.getMessages().getERROR_CHECKOS_INVALID_OPERATING_SYSTEM();
            Object[] objectArray = new Object[]{value};
            boolean bl3 = false;
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue(string3, "java.lang.String.format(this, *args)");
            throw (Throwable)new AraraException(string3);
        }
        string = value;
        bl2 = false;
        String string4 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).toLowerCase()");
        return (Boolean)MapsKt.getValue(values2, string4);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> appendExtensions(String command) {
        void $this$mapTo$iv$iv;
        List<String> extensions = Environment.checkOS("windows") ? CollectionsKt.listOf(".com", ".exe", ".bat", ".cmd") : CollectionsKt.listOf("");
        Iterable $this$map$iv = extensions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string2 = command + (String)it;
            collection.add(string2);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final boolean isOnPath(@NotNull String command) {
        Object object;
        Intrinsics.checkNotNullParameter(command, "command");
        List<String> filenames = INSTANCE.appendExtensions(command);
        boolean bl = false;
        try {
            Boolean bl2;
            Object v6;
            File[] fileArray;
            block8: {
                void $this$firstOrNull$iv;
                object = Result.Companion;
                boolean bl3 = false;
                String string = System.getenv("PATH");
                if (string == null) {
                    string = System.getenv("Path");
                }
                Intrinsics.checkNotNullExpressionValue(string, "(System.getenv(\"PATH\") ?: System.getenv(\"Path\"))");
                CharSequence charSequence = string;
                String[] stringArray = new String[1];
                String string2 = File.pathSeparator;
                Intrinsics.checkNotNullExpressionValue(string2, "File.pathSeparator");
                stringArray[0] = string2;
                fileArray = SequencesKt.mapNotNull(CollectionsKt.asSequence(StringsKt.split$default(charSequence, stringArray, false, 0, 6, null)), isOnPath.1.1.INSTANCE);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    boolean bl4;
                    block7: {
                        File[] it = (File[])element$iv;
                        boolean bl5 = false;
                        File[] $this$any$iv = it;
                        boolean $i$f$any = false;
                        File[] fileArray2 = $this$any$iv;
                        int n = fileArray2.length;
                        for (int i = 0; i < n; ++i) {
                            File element$iv2;
                            File file2 = element$iv2 = fileArray2[i];
                            boolean bl6 = false;
                            File file3 = file2;
                            Intrinsics.checkNotNullExpressionValue(file3, "file");
                            if (!(filenames.contains(file3.getName()) && !file2.isDirectory())) continue;
                            bl4 = true;
                            break block7;
                        }
                        bl4 = false;
                    }
                    if (!bl4) continue;
                    v6 = element$iv;
                    break block8;
                }
                v6 = null;
            }
            File[] fileArray3 = v6;
            if (fileArray3 != null) {
                fileArray = fileArray3;
                boolean bl7 = false;
                boolean bl8 = false;
                File[] it = fileArray;
                boolean bl9 = false;
                bl2 = true;
            } else {
                bl2 = null;
            }
            Boolean bl10 = bl2;
            boolean bl11 = false;
            object = Result.constructor-impl(bl10);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl12 = false;
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        Object object2 = object;
        boolean bl13 = false;
        Boolean bl14 = (Boolean)(Result.isFailure-impl(object2) ? null : object2);
        return bl14 != null ? bl14 : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @NotNull
    public static final Pair<Integer, String> executeSystemCommand-SxA4cEA(@NotNull Command command, boolean silenceSystemOut, double timeout) {
        Pair pair2;
        Intrinsics.checkNotNullParameter(command, "command");
        Closeable closeable = new ByteArrayOutputStream();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            Pair<Integer, String> pair3;
            Object object;
            ByteArrayOutputStream buffer = (ByteArrayOutputStream)closeable;
            boolean bl3 = false;
            Pair<Integer, String> pair4 = new ProcessExecutor(command.getElements());
            boolean bl4 = false;
            try {
                OutputStream outputStream2;
                object = Result.Companion;
                Object $this$runCatching = pair4;
                boolean bl5 = false;
                ((ProcessExecutor)$this$runCatching).addDestroyer(new ShutdownHookProcessDestroyer());
                Path path2 = command.getWorkingDirectory();
                if (path2 == null) {
                    path2 = Paths.get("", new String[0]);
                }
                Path workingDirectory = path2;
                File file2 = workingDirectory.toFile();
                Intrinsics.checkNotNullExpressionValue(file2, "workingDirectory.toFile()");
                ((ProcessExecutor)$this$runCatching).directory(file2.getAbsoluteFile());
                if (silenceSystemOut) {
                    outputStream2 = buffer;
                } else {
                    ((ProcessExecutor)$this$runCatching).redirectInput(System.in);
                    outputStream2 = new TeeOutputStream(System.out, buffer);
                }
                OutputStream tee = outputStream2;
                ((ProcessExecutor)$this$runCatching).redirectOutput(tee).redirectError(tee);
                if (Duration.equals-impl0(timeout, Duration.Companion.getZERO-UwyO8pc()) ^ true) {
                    ((ProcessExecutor)$this$runCatching).timeout(Duration.toLongNanoseconds-impl(timeout), TimeUnit.NANOSECONDS);
                }
                ProcessResult processResult = ((ProcessExecutor)$this$runCatching).execute();
                Intrinsics.checkNotNullExpressionValue(processResult, "execute()");
                $this$runCatching = TuplesKt.to(processResult.getExitValue(), buffer.toString());
                bl5 = false;
                object = Result.constructor-impl($this$runCatching);
            }
            catch (Throwable $this$runCatching) {
                Result.Companion bl5 = Result.Companion;
                boolean bl6 = false;
                object = Result.constructor-impl(ResultKt.createFailure($this$runCatching));
            }
            pair4 = object;
            bl4 = false;
            boolean bl7 = false;
            Throwable throwable2 = Result.exceptionOrNull-impl(pair4);
            if (throwable2 == null) {
                pair3 = pair4;
            } else {
                Throwable it = throwable2;
                boolean bl8 = false;
                logger.debug("Caught an exception when executing " + command + " returning -99");
                pair3 = TuplesKt.to(-99, it.getClass().getName() + ": " + it.getMessage());
            }
            pair2 = pair3;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
        return pair2;
    }

    public static /* synthetic */ Pair executeSystemCommand-SxA4cEA$default(Command command, boolean bl, double d, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            d = Duration.Companion.getZERO-UwyO8pc();
        }
        return Environment.executeSystemCommand-SxA4cEA(command, bl, d);
    }

    private Environment() {
    }

    static {
        Environment environment;
        INSTANCE = environment = new Environment();
        logger = LoggerFactory.getLogger(Environment.class);
        inCygwinEnvironment$delegate = LazyKt.lazy(inCygwinEnvironment.2.INSTANCE);
    }
}

