/*
Copyright The KubeVirt Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta1

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
	scheme "kubevirt.io/client-go/containerizeddataimporter/scheme"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// DataVolumesGetter has a method to return a DataVolumeInterface.
// A group's client should implement this interface.
type DataVolumesGetter interface {
	DataVolumes(namespace string) DataVolumeInterface
}

// DataVolumeInterface has methods to work with DataVolume resources.
type DataVolumeInterface interface {
	Create(ctx context.Context, dataVolume *v1beta1.DataVolume, opts v1.CreateOptions) (*v1beta1.DataVolume, error)
	Update(ctx context.Context, dataVolume *v1beta1.DataVolume, opts v1.UpdateOptions) (*v1beta1.DataVolume, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, dataVolume *v1beta1.DataVolume, opts v1.UpdateOptions) (*v1beta1.DataVolume, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta1.DataVolume, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta1.DataVolumeList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.DataVolume, err error)
	DataVolumeExpansion
}

// dataVolumes implements DataVolumeInterface
type dataVolumes struct {
	*gentype.ClientWithList[*v1beta1.DataVolume, *v1beta1.DataVolumeList]
}

// newDataVolumes returns a DataVolumes
func newDataVolumes(c *CdiV1beta1Client, namespace string) *dataVolumes {
	return &dataVolumes{
		gentype.NewClientWithList[*v1beta1.DataVolume, *v1beta1.DataVolumeList](
			"datavolumes",
			c.RESTClient(),
			scheme.ParameterCodec,
			namespace,
			func() *v1beta1.DataVolume { return &v1beta1.DataVolume{} },
			func() *v1beta1.DataVolumeList { return &v1beta1.DataVolumeList{} }),
	}
}
