/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* This file was automatically generated by getCTKnownLogs.py. */

#ifndef CTKnownLogs_h
#define CTKnownLogs_h

#include "CTLog.h"

#include <stddef.h>

struct CTLogInfo {
  // See bug 1338873 about making these fields const.
  const char* name;
  // Index within kCTLogOperatorList.
  mozilla::ct::CTLogStatus status;
  // 0 for qualified logs, disqualification time for disqualified logs
  // (in milliseconds, measured since the epoch, ignoring leap seconds).
  uint64_t disqualificationTime;
  size_t operatorIndex;
  const char* key;
  size_t keyLength;
};

struct CTLogOperatorInfo {
  // See bug 1338873 about making these fields const.
  const char* name;
  mozilla::ct::CTLogOperatorId id;
};

const CTLogInfo kCTLogList[] = {
    {"Google 'Argon2023' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xd0\x90\x8f\x64\x52\x4e\x42\xac\x84"
     "\xb6\x2e\x4c\xf2\x3d\x77\x00\xb3\x77\x08\x05\x47\xaa\x45\x4c\xe3\x2c\x8e"
     "\x70\xa5\x82\xbb\x6c\xb2\x7b\x9c\x98\x7a\xa0\xe9\x11\x76\x28\x00\xb2\x20"
     "\xb4\xcd\xd3\x98\x7b\x4d\x96\x27\xe6\xb7\xee\x22\x6a\xd1\xb0\x2e\x91\x77"
     "\x78",
     91},
    {"Google 'Argon2024' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x1d\xb9\x6c\xa9\xcb\x69\x94\xc5\x5c"
     "\xe6\xb6\xa6\x03\xbb\xd2\xb8\xdc\x54\x43\x17\x28\x99\x0c\x06\x01\x50\x1d"
     "\x9d\x64\xc0\x59\x46\x2b\xdc\xc8\x03\x1d\x05\xb4\x2d\xa8\x09\xf7\x99\x41"
     "\xed\x04\xfb\xe5\x57\xba\x26\x04\xf6\x11\x52\xce\x14\x65\x3b\x2f\x76\x2b"
     "\xc0",
     91},
    {"Google 'Xenon2023' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x72\x16\x3e\x0b\xef\xef\xce\x3e\x60"
     "\xdd\x95\xcb\x63\x7a\xb9\xa9\x8d\x4a\x6f\x6c\xdc\x61\x80\xa6\x45\x5e\x2f"
     "\x83\xac\x94\xf3\x85\x88\xd0\xa5\x74\xd0\x7b\x8e\xff\xc5\xee\x42\xa2\xf0"
     "\x2d\x93\xe3\xc2\xd0\xb2\x99\xe2\xe1\x42\xe9\xd2\xc6\x00\x27\x69\x74\xae"
     "\xce",
     91},
    {"Google 'Xenon2024' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xb9\x60\xe0\x34\x1e\x35\xe4\x65\x00"
     "\x93\x4f\x90\x09\xbd\x5a\xec\x44\xdd\x8c\x0f\xce\xed\x11\x3e\x2a\x59\x46"
     "\x9a\x31\xb6\xc7\x99\xf7\xdc\xef\x3d\xcd\x8f\x86\xc2\x35\xa5\x3e\xdc\x29"
     "\xba\xbb\xf2\x54\xe2\xa8\x0c\x83\x08\x51\x06\xde\x21\x6d\x36\x50\x8e\x38"
     "\x4d",
     91},
    {"Google 'Icarus' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x4e\xd2\xbc\xbf\xb3\x08\x0a\xf7\xb9"
     "\xea\xa4\xc7\x1c\x38\x61\x04\xeb\x95\xe0\x89\x54\x68\x44\xb1\x66\xbc\x82"
     "\x7e\x4f\x50\x6c\x6f\x5c\xa3\xf0\xaa\x3e\xf4\xec\x80\xf0\xdb\x0a\x9a\x7a"
     "\xa0\x5b\x72\x00\x7c\x25\x0e\x19\xef\xaf\xb2\x62\x8d\x74\x43\xf4\x26\xf6"
     "\x14",
     91},
    {"Google 'Pilot' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x7d\xa8\x4b\x12\x29\x80\xa3\x3d\xad"
     "\xd3\x5a\x77\xb8\xcc\xe2\x88\xb3\xa5\xfd\xf1\xd3\x0c\xcd\x18\x0c\xe8\x41"
     "\x46\xe8\x81\x01\x1b\x15\xe1\x4b\xf1\x1b\x62\xdd\x36\x0a\x08\x18\xba\xed"
     "\x0b\x35\x84\xd0\x9e\x40\x3c\x2d\x9e\x9b\x82\x65\xbd\x1f\x04\x10\x41\x4c"
     "\xa0",
     91},
    {"Google 'Rocketeer' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x20\x5b\x18\xc8\x3c\xc1\x8b\xb3\x31"
     "\x08\x00\xbf\xa0\x90\x57\x2b\xb7\x47\x8c\x6f\xb5\x68\xb0\x8e\x90\x78\xe9"
     "\xa0\x73\xea\x4f\x28\x21\x2e\x9c\xc0\xf4\x16\x1b\xaa\xf9\xd5\xd7\xa9\x80"
     "\xc3\x4e\x2f\x52\x3c\x98\x01\x25\x46\x24\x25\x28\x23\x77\x2d\x05\xc2\x40"
     "\x7a",
     91},
    {"Google 'Skydiver' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     0,  // operated by Google
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x12\x6c\x86\x0e\xf6\x17\xb1\x12\x6c"
     "\x37\x25\xd2\xad\x87\x3d\x0e\x31\xec\x21\xad\xb1\xcd\xbe\x14\x47\xb6\x71"
     "\x56\x85\x7a\x9a\xb7\x3d\x89\x90\x7b\xc6\x32\x3a\xf8\xda\xce\x8b\x01\xfe"
     "\x3f\xfc\x71\x91\x19\x8e\x14\x6e\x89\x7a\x5d\xb4\xab\x7e\xe1\x4e\x1e\x7c"
     "\xac",
     91},
    {"Cloudflare 'Nimbus2023' Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     1,  // operated by Cloudflare
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x8b\xff\x2d\x92\x18\xcb\x46\x9d\x12"
     "\x5e\xb9\x59\x75\x3c\xcd\x91\x37\x7a\x1e\xa9\x9c\x99\x78\x83\x27\x3d\xdf"
     "\x01\xd5\x8b\x80\xe8\x63\x9a\xfe\x26\xa2\x1b\xd1\x87\x05\xee\x97\xd6\xe0"
     "\x5b\x43\x83\x81\x1c\x02\xf5\x41\x80\x80\x7f\xef\xa4\x61\xcf\xbc\x84\xb5"
     "\xa8",
     91},
    {"Cloudflare 'Nimbus2024' Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     1,  // operated by Cloudflare
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x77\xb1\x9b\x7b\x8f\xe6\x8b\x35\xfe"
     "\x3a\x92\x29\x2d\xac\x8a\x8d\x51\x8a\x25\xfc\x93\xb6\xd7\xa0\x8b\x29\x37"
     "\x71\x1d\x33\xca\xcc\x33\xea\x28\xb9\x1f\xe2\xac\xc3\xa9\x5d\xdd\x97\xbe"
     "\xf6\x9e\x94\x25\xdd\x36\x81\xd1\xeb\x5d\x29\xc3\x2b\x44\xf1\x5b\xca\x15"
     "\x48",
     91},
    {"DigiCert Yeti2023 Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     2,  // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x7d\x0d\x03\xb1\xd5\x98\x8a\xdc\xf0"
     "\x15\x3b\xc6\xdc\x5e\x0d\x6e\x3f\x0d\xbf\x95\xc8\x55\x8c\xd0\xa6\x4c\x96"
     "\xb1\x4e\x27\xb9\x26\x25\x99\xcc\x2b\x02\x9e\xa6\xd3\xdd\x9f\xb1\xd5\xc4"
     "\xc3\xac\x35\x04\x07\x87\x97\x36\xaa\xad\x28\x0d\x7f\x2b\xd9\x68\x9f\x72"
     "\xd1",
     91},
    {"DigiCert Yeti2024 Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     2,  // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x57\xb8\xc1\x6f\x30\xa4\x7f\x2e\xe4"
     "\xf0\xd0\xd9\x60\x62\x13\x95\xe3\x7a\xe3\x4e\x53\xc3\xb3\xb8\x73\x85\xc1"
     "\x18\x0d\x23\x0e\x58\x84\xd2\x78\xef\x9b\xb3\x1e\x2c\x1a\xde\xc1\x8f\x81"
     "\x1b\x19\x44\x58\xb7\x00\x77\x60\x20\x1a\x72\xd8\x82\xde\xae\x9e\xb1\xc6"
     "\x4b",
     91},
    {"DigiCert Yeti2025 Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     2,  // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xdf\x95\x00\x5e\x10\xc1\x01\xf7\x37"
     "\xe3\x10\x74\xd1\xff\xb2\xca\x90\xed\x32\x99\x5f\x0c\x39\xfe\xa1\xd1\x13"
     "\x11\xac\xd1\xb3\x73\x93\x20\xc2\x13\x3c\x4c\xb5\x7a\x52\x86\x86\x3d\xe3"
     "\x95\x24\x7c\xd8\x91\x98\x48\x3b\xf0\xf0\xdf\x21\xf1\xb0\x81\x5a\x59\x25"
     "\x43",
     91},
    {"DigiCert Nessie2023 Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     2,  // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x11\x7b\xbc\x89\x0c\x12\x09\x14\x9f"
     "\xd8\x26\xc8\x4c\x6a\x54\xa4\x1b\x45\x56\xdf\x3e\x23\x42\x14\xd1\xdd\x42"
     "\xdf\xa2\xdf\x7b\x5f\x9f\x6f\x07\x5a\x23\x46\x79\x16\x4b\x5f\x33\x67\xc1"
     "\xa0\x8d\x5b\x5c\x17\x75\xf2\x4d\xa0\x80\xa1\x98\x1a\x07\x59\x06\x02\xca"
     "\x4e",
     91},
    {"DigiCert Nessie2024 Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     2,  // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x2d\xfc\xa2\x7b\x36\xbf\x56\x91\xe9"
     "\xfe\x3f\xe8\x3d\xfc\xc3\xa7\xe0\x61\x52\xea\x2c\xe9\x05\xa3\x9f\x27\x17"
     "\x81\x05\x70\x6b\x81\x61\x44\x8a\xf8\x3b\x10\x80\x42\xed\x03\x2f\x00\x50"
     "\x21\xfc\x41\x54\x84\xa3\x54\xd5\x2e\xb2\x7a\x16\x4b\x2a\x1f\x2b\x66\x04"
     "\x2b",
     91},
    {"DigiCert Nessie2025 Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     2,  // operated by DigiCert
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xf2\xf0\xf0\xa7\x8b\x81\x2e\x09\x39"
     "\x3b\x9f\x42\xda\x38\x44\x5f\xb4\xcc\xed\x36\xbb\xd8\x43\x7f\x16\x49\x57"
     "\x87\x04\x7f\xa5\x01\x34\xf7\xe8\x68\x3f\xb7\x78\x1f\x60\x66\x2d\x67\x9a"
     "\x75\x80\xb7\x53\xa7\x85\xd5\xbc\xab\x47\x06\x55\xdb\xb5\xdf\x88\xa1\x6f"
     "\x38",
     91},
    {"Sectigo 'Sabre' CT log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     3,  // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xf2\x6f\xd2\x89\x0f\x3f\xc5\xf8\x87"
     "\x1e\xab\x65\xb3\xd9\xbb\x17\x23\x8c\x06\x0e\x09\x55\x96\x3d\x0a\x08\xa2"
     "\xc5\x71\xb3\xd1\xa9\x2f\x28\x3e\x83\x10\xbf\x12\xd0\x44\x66\x15\xef\x54"
     "\xe1\x98\x80\xd0\xce\x24\x6d\x3e\x67\x9a\xe9\x37\x23\xce\x52\x93\x86\xda"
     "\x80",
     91},
    {"Sectigo 'Mammoth' CT log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     3,  // operated by Sectigo
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xef\xe4\x7d\x74\x2e\x15\x15\xb6\xe9"
     "\xbb\x23\x8b\xfb\x2c\xb5\xe1\xc7\x80\x98\x47\xfb\x40\x69\x68\xfc\x49\xad"
     "\x61\x4e\x83\x47\x3c\x1a\xb7\x8d\xdf\xff\x7b\x30\xb4\xba\xff\x2f\xcb\xa0"
     "\x14\xe3\xad\xd5\x85\x3f\x44\x59\x8c\x8c\x60\x8b\xd7\xb8\xb1\xbf\xae\x8c"
     "\x67",
     91},
    {"Let's Encrypt 'Oak2023' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     4,  // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xb3\x3d\x0e\x78\xbe\xe3\xad\x5c\x44"
     "\x5c\x9b\xbe\xa3\x84\x16\x41\x82\xca\xca\x89\x17\x1e\x23\xce\x38\xa5\x54"
     "\x2f\x7f\xd3\x34\x51\x6a\xb9\x5c\xc3\x49\xea\xfb\x91\x9d\xe0\x8a\x3c\x73"
     "\x06\x9f\x7c\x65\x38\x11\x80\xc4\x9a\x5a\x00\xa6\x67\xc3\x83\xef\x89\x85"
     "\x51",
     91},
    {"Let's Encrypt 'Oak2024H1' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     4,  // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x56\x43\xd7\x7e\x7b\xd4\x72\xb7\xba"
     "\xa9\x51\xbd\x36\x93\xb7\xe9\xb5\x92\x0f\xea\x5e\xb7\x45\xa3\x92\xfd\xc9"
     "\xa5\x3c\x80\xac\x1a\x20\xef\x25\x2f\xb8\xe1\x20\xf7\xa8\x3a\x2e\x07\x8d"
     "\xe6\xeb\xa4\xe2\x7d\x24\x63\x9f\x46\xbf\x94\x73\x52\x8d\x96\xae\xa9\x26"
     "\xfd",
     91},
    {"Let's Encrypt 'Oak2024H2' log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     4,  // operated by Let's Encrypt
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xd7\x73\xd6\x53\x47\xe9\xf3\xc9\xd5"
     "\x7c\x16\xc2\xd6\x8f\x70\x65\xfa\xf2\x51\x36\xa9\x13\x80\x2f\xed\xf9\x94"
     "\xd3\x5a\x8b\xe8\x4f\x33\xcf\xc3\xd3\x89\xd4\x5f\x5a\x66\x89\xba\x20\x1f"
     "\x71\xcb\xca\xbb\x9f\x9f\xf3\x5c\x2d\x1e\xa3\x81\x59\xaf\x92\xb3\x6d\x30"
     "\x68",
     91},
    {"Trust Asia Log2023", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     5,  // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xa4\x11\x52\xdb\x17\x41\x4e\x90\xd4"
     "\x56\x51\x12\x30\x52\xf8\x9b\x03\xcf\x4c\x9f\xf8\x2e\x38\xb5\xf1\x5a\xba"
     "\xfa\x38\xb9\xd2\x8f\x1a\x81\xda\x95\xcc\x33\xec\x21\x28\x66\xc6\x56\x3e"
     "\x60\x36\x21\x20\xd9\xd4\xac\x5d\xfa\x5c\x19\xa1\x05\x7d\xfe\x20\x23\xfc"
     "\xf5",
     91},
    {"Trust Asia Log2024-2", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     5,  // operated by TrustAsia
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\xa7\x64\xe2\x79\x81\x3f\x61\xd7\xec"
     "\xc6\xf8\x65\x28\x1d\xa0\xb4\x66\x33\xc3\x25\xd5\x0a\x95\x78\x9c\x8f\xfe"
     "\xa4\x2a\xd8\x8f\x7e\x72\xe0\xfe\xa8\x7f\xf8\xb1\x2d\x85\xc0\x8e\x12\x74"
     "\x0d\x2f\x8c\xab\xd7\x7f\x7a\x1e\xd9\x84\x33\x39\xe8\xfd\x89\x5f\x96\x48"
     "\x08",
     91},
#ifdef DEBUG
    {"Mozilla Test RSA Log 1", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     6,  // operated by Mozilla Test Org 1
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xba\x88\x51"
     "\xa8\x44\x8e\x16\xd6\x41\xfd\x6e\xb6\x88\x06\x36\x10\x3d\x3c\x13\xd9\xea"
     "\xe4\x35\x4a\xb4\xec\xf5\x68\x57\x6c\x24\x7b\xc1\xc7\x25\xa8\xe0\xd8\x1f"
     "\xbd\xb1\x9c\x06\x9b\x6e\x1a\x86\xf2\x6b\xe2\xaf\x5a\x75\x6b\x6a\x64\x71"
     "\x08\x7a\xa5\x5a\xa7\x45\x87\xf7\x1c\xd5\x24\x9c\x02\x7e\xcd\x43\xfc\x1e"
     "\x69\xd0\x38\x20\x29\x93\xab\x20\xc3\x49\xe4\xdb\xb9\x4c\xc2\x6b\x6c\x0e"
     "\xed\x15\x82\x0f\xf1\x7e\xad\x69\x1a\xb1\xd3\x02\x3a\x8b\x2a\x41\xee\xa7"
     "\x70\xe0\x0f\x0d\x8d\xfd\x66\x0b\x2b\xb0\x24\x92\xa4\x7d\xb9\x88\x61\x79"
     "\x90\xb1\x57\x90\x3d\xd2\x3b\xc5\xe0\xb8\x48\x1f\xa8\x37\xd3\x88\x43\xef"
     "\x27\x16\xd8\x55\xb7\x66\x5a\xaa\x7e\x02\x90\x2f\x3a\x7b\x10\x80\x06\x24"
     "\xcc\x1c\x6c\x97\xad\x96\x61\x5b\xb7\xe2\x96\x12\xc0\x75\x31\xa3\x0c\x91"
     "\xdd\xb4\xca\xf7\xfc\xad\x1d\x25\xd3\x09\xef\xb9\x17\x0e\xa7\x68\xe1\xb3"
     "\x7b\x2f\x22\x6f\x69\xe3\xb4\x8a\x95\x61\x1d\xee\x26\xd6\x25\x9d\xab\x91"
     "\x08\x4e\x36\xcb\x1c\x24\x04\x2c\xbf\x16\x8b\x2f\xe5\xf1\x8f\x99\x17\x31"
     "\xb8\xb3\xfe\x49\x23\xfa\x72\x51\xc4\x31\xd5\x03\xac\xda\x18\x0a\x35\xed"
     "\x8d\x02\x03\x01\x00\x01",
     294},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test EC Log", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     6,  // operated by Mozilla Test Org 1
     "\x30\x59\x30\x13\x06\x07\x2a\x86\x48\xce\x3d\x02\x01\x06\x08\x2a\x86\x48"
     "\xce\x3d\x03\x01\x07\x03\x42\x00\x04\x4f\xbf\xbb\xbb\x61\xe0\xf8\xf9\xb1"
     "\xa6\x0a\x59\xac\x87\x04\xe2\xec\x05\x0b\x42\x3e\x3c\xf7\x2e\x92\x3f\x2c"
     "\x4f\x79\x4b\x45\x5c\x2a\x69\xd2\x33\x45\x6c\x36\xc4\x11\x9d\x07\x06\xe0"
     "\x0e\xed\xc8\xd1\x93\x90\xd7\x99\x1b\x7b\x2d\x07\xa3\x04\xea\xa0\x4a\xa6"
     "\xc0",
     91},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test RSA Log 2", mozilla::ct::CTLogStatus::Included,
     0,  // no disqualification time
     7,  // operated by Mozilla Test Org 2
     "\x30\x82\x01\x22\x30\x0d\x06\x09\x2a\x86\x48\x86\xf7\x0d\x01\x01\x01\x05"
     "\x00\x03\x82\x01\x0f\x00\x30\x82\x01\x0a\x02\x82\x01\x01\x00\xc1\x75\xc6"
     "\x52\x66\x09\x9f\x77\x08\x2a\x67\x91\xf1\xb8\x76\xc3\x7f\x5c\xe5\x38\xb0"
     "\x6c\x4a\xcd\x22\xb1\xcb\xd4\x6f\xa6\x5a\xda\x2a\xdd\x41\xc8\xc2\x49\x8a"
     "\xc4\xa3\xb3\xc1\xf6\x14\x87\xf4\x1b\x69\x89\x41\xbd\x80\xa5\x1c\x3c\x12"
     "\x02\x44\xc5\x84\xa4\xc4\x48\x33\x05\xe5\x13\x8c\x01\x06\xcf\x08\xbe\x9a"
     "\x86\x27\x60\xba\xe6\xa2\xe8\xf3\x6f\x23\xc5\xd9\x83\x13\xb9\xdf\xaf\x37"
     "\x83\x45\xda\xce\x51\xd4\xd6\xdc\xd2\xa6\xcb\x3c\xc7\x06\xeb\xcd\x30\x70"
     "\xec\x98\xcc\xe4\x0a\xa5\x91\xd7\x29\x5a\x7f\x71\xc5\xbe\x66\x69\x1d\x2b"
     "\x2d\xfe\xc8\x49\x44\x59\x0b\xc5\xa3\xea\x49\xfd\x93\xb1\xd7\x53\x40\x5f"
     "\x17\x73\x76\x99\x95\x86\x66\x25\x47\x97\xed\x42\x69\x08\x88\x08\x11\x42"
     "\x20\x69\x98\x8a\x43\xfe\xe4\x8c\xe6\x87\x81\xdd\x22\xb6\xa6\x9c\xd2\x83"
     "\x75\x13\x1f\x93\x2b\x12\x8c\xe2\x86\xfa\x7d\x25\x1c\x06\x2a\xd2\x7e\xf0"
     "\x16\xf1\x87\xcd\xd5\x4e\x83\x2b\x35\xb8\x93\x0f\x74\xba\x90\xaa\x8b\xc7"
     "\x61\x67\x24\x2a\xb1\xfd\x6d\x62\x14\x0d\x18\xc4\xc0\xb8\xc6\x8f\xc3\x74"
     "\x84\x57\x32\x4a\xd7\xde\x86\xe6\x55\x2f\x1d\x1e\x19\x1d\x71\x21\x68\xd3"
     "\xbb\x02\x03\x01\x00\x01",
     294},
#endif  // DEBUG
};

const CTLogOperatorInfo kCTLogOperatorList[] = {
    {"Google", 0},
    {"Cloudflare", 1},
    {"DigiCert", 2},
    {"Sectigo", 3},
    {"Let's Encrypt", 4},
    {"TrustAsia", 5},
#ifdef DEBUG
    {"Mozilla Test Org 1", 6},
#endif  // DEBUG
#ifdef DEBUG
    {"Mozilla Test Org 2", 7},
#endif  // DEBUG
};

#endif  // CTKnownLogs_h
