# RUN: llvm-mc -triple mips-unknown-linux < %s -show-encoding -target-abi=o32 \
# RUN:     | FileCheck -check-prefix=ASM %s
# RUN: llvm-mc -triple mips64-unknown-linux < %s -show-encoding -target-abi=n32 \
# RUN:     | FileCheck -check-prefix=ASM %s
# RUN: llvm-mc -triple mips64-unknown-linux < %s -show-encoding -target-abi=n64 \
# RUN:     | FileCheck -check-prefix=ASM %s
# RUN: llvm-mc -triple mips-unknown-linux < %s -show-encoding -target-abi=o32 \
# RUN:     -filetype=obj | llvm-readobj --sections --section-data -r - | \
# RUN:     FileCheck -check-prefix=OBJ-O32 %s
# RUN: llvm-mc -triple mips64-unknown-linux < %s -show-encoding -target-abi=n32 \
# RUN:     -filetype=obj | llvm-readobj --sections --section-data -r - | \
# RUN:     FileCheck -check-prefix=OBJ-N32 %s
# RUN: llvm-mc -triple mips64-unknown-linux < %s -show-encoding -target-abi=n64 \
# RUN:     -filetype=obj | llvm-readobj --sections --section-data -r - | \
# RUN:     FileCheck -check-prefix=OBJ-N64 %s
	.text
foo:
	.reloc 4, R_MIPS_NONE, foo   # ASM: .reloc 4, R_MIPS_NONE, foo
	.reloc 0, R_MIPS_NONE, foo+4 # ASM: .reloc 0, R_MIPS_NONE, foo+4
	.reloc 8, R_MIPS_32, foo+8   # ASM: .reloc 8, R_MIPS_32, foo+8
	nop
	nop
	nop
	.reloc 12, R_MIPS_NONE       # ASM: .reloc 12, R_MIPS_NONE{{$}}
        nop
  .reloc 16, R_MIPS_CALL_HI16, 4        # ASM: .reloc 16, R_MIPS_CALL_HI16, 4
  nop
  .reloc 20, R_MIPS_CALL_LO16, 4        # ASM: .reloc 20, R_MIPS_CALL_LO16, 4
  nop
  .reloc 24, R_MIPS_CALL16, 4           # ASM: .reloc 24, R_MIPS_CALL16, 4
  nop
  .reloc 28, R_MIPS_GOT16, 4            # ASM: .reloc 28, R_MIPS_GOT16, 4
  nop
  .reloc 32, R_MIPS_GOT_PAGE, 4         # ASM: .reloc 32, R_MIPS_GOT_PAGE, 4
  nop
  .reloc 36, R_MIPS_GOT_OFST, 4         # ASM: .reloc 36, R_MIPS_GOT_OFST, 4
  nop
  .reloc 40, R_MIPS_GOT_DISP, 4         # ASM: .reloc 40, R_MIPS_GOT_DISP, 4
  nop
  .reloc 44, R_MIPS_GOT_HI16, 4         # ASM: .reloc 44, R_MIPS_GOT_HI16, 4
  nop
  .reloc 48, R_MIPS_GOT_LO16, 4         # ASM: .reloc 48, R_MIPS_GOT_LO16, 4
  nop
  .reloc 52, R_MIPS_TLS_GOTTPREL, 4     # ASM: .reloc 52, R_MIPS_TLS_GOTTPREL, 4
  nop
  .reloc 56, R_MIPS_TLS_DTPREL_HI16, 4  # ASM: .reloc 56, R_MIPS_TLS_DTPREL_HI16, 4
  nop
  .reloc 60, R_MIPS_TLS_DTPREL_LO16, 4  # ASM: .reloc 60, R_MIPS_TLS_DTPREL_LO16, 4
  nop
  .reloc 64, R_MIPS_TLS_GD, 4           # ASM: .reloc 64, R_MIPS_TLS_GD, 4
  nop
  .reloc 68, R_MIPS_TLS_LDM, 4          # ASM: .reloc 68, R_MIPS_TLS_LDM, 4
  nop
  .reloc 72, R_MIPS_TLS_TPREL_HI16, 4   # ASM: .reloc 72, R_MIPS_TLS_TPREL_HI16, 4
  nop
  .reloc 76, R_MIPS_TLS_TPREL_LO16, 4   # ASM: .reloc 76, R_MIPS_TLS_TPREL_LO16, 4
  nop
  .reloc 80, R_MICROMIPS_CALL16, 4      # ASM: .reloc 80, R_MICROMIPS_CALL16, 4
  nop
  .reloc 84, R_MICROMIPS_GOT_DISP, 4    # ASM: .reloc 84, R_MICROMIPS_GOT_DISP, 4
  nop
  .reloc 88, R_MICROMIPS_GOT_PAGE, 4    # ASM: .reloc 88, R_MICROMIPS_GOT_PAGE, 4
  nop
  .reloc 92, R_MICROMIPS_GOT_OFST, 4    # ASM: .reloc 92, R_MICROMIPS_GOT_OFST, 4
  nop
  .reloc 96, R_MICROMIPS_GOT16, 4       # ASM: .reloc 96, R_MICROMIPS_GOT16, 4
  nop
  .reloc 100, R_MICROMIPS_TLS_GOTTPREL, 4       # ASM: .reloc 100, R_MICROMIPS_TLS_GOTTPREL, 4
  nop
  .reloc 104, R_MICROMIPS_TLS_DTPREL_HI16, 4    # ASM: .reloc 104, R_MICROMIPS_TLS_DTPREL_HI16, 4
  nop
  .reloc 108, R_MICROMIPS_TLS_DTPREL_LO16, 4    # ASM: .reloc 108, R_MICROMIPS_TLS_DTPREL_LO16, 4
  nop
  .reloc 112, R_MICROMIPS_TLS_GD, 4             # ASM: .reloc 112, R_MICROMIPS_TLS_GD, 4
  nop
  .reloc 116, R_MICROMIPS_TLS_LDM, 4            # ASM: .reloc 116, R_MICROMIPS_TLS_LDM, 4
  nop
  .reloc 120, R_MICROMIPS_TLS_TPREL_HI16, 4     # ASM: .reloc 120, R_MICROMIPS_TLS_TPREL_HI16, 4
  nop
  .reloc 124, R_MICROMIPS_TLS_TPREL_LO16, 4     # ASM: .reloc 124, R_MICROMIPS_TLS_TPREL_LO16, 4
  nop
  .reloc 128, R_MIPS_JALR, 4            # ASM: .reloc 128, R_MIPS_JALR, 4
  nop
  .reloc 132, R_MICROMIPS_JALR, 4       # ASM: .reloc 132, R_MICROMIPS_JALR, 4
  nop
  .reloc 136, BFD_RELOC_NONE, 9         # ASM: .reloc 136, BFD_RELOC_NONE, 9
  .reloc 137, BFD_RELOC_16, 9           # ASM: .reloc 137, BFD_RELOC_16, 9
  .reloc 138, BFD_RELOC_32, 9           # ASM: .reloc 138, BFD_RELOC_32, 9
  .reloc 139, BFD_RELOC_64, 9           # ASM: .reloc 139, BFD_RELOC_64, 9
  nop

# OBJ-O32-LABEL: Name: .text
# OBJ-O32:       0000: 00000000 00000000 00000008 00000000
# OBJ-O32-NEXT:  0010: 00000000 00000004 00000000 00000000
# OBJ-O32-NEXT:  0020: 00000004 00000004 00000004 00000000
# OBJ-O32-NEXT:  0030: 00000004 00000000 00000000 00000000
# OBJ-O32-NEXT:  0040: 00000000 00000000 00000000 00000000
# OBJ-O32-NEXT:  0050: 00000000 00000004 00000004 00000004
# OBJ-O32-NEXT:  0060: 00000000 00000000 00000000 00000000
# OBJ-O32-NEXT:  0070: 00000000 00000000 00000000 00000000
# OBJ-O32-NEXT:  0080: 00000000 00000000
# OBJ-O32-LABEL: }
# OBJ-O32-LABEL: Relocations [
# OBJ-O32:       0x0 R_MIPS_NONE .text
# OBJ-O32-NEXT:  0x4 R_MIPS_NONE .text
# OBJ-O32-NEXT:  0x8 R_MIPS_32 .text
# OBJ-O32-NEXT:  0xC R_MIPS_NONE -
# OBJ-O32-NEXT:  0x10 R_MIPS_CALL_HI16 -
# OBJ-O32-NEXT:  0x14 R_MIPS_CALL_LO16 -
# OBJ-O32-NEXT:  0x18 R_MIPS_CALL16 -
# OBJ-O32-NEXT:  0x20 R_MIPS_GOT_PAGE -
# OBJ-O32-NEXT:  0x24 R_MIPS_GOT_OFST -
# OBJ-O32-NEXT:  0x28 R_MIPS_GOT_DISP -
# OBJ-O32-NEXT:  0x2C R_MIPS_GOT_HI16 -
# OBJ-O32-NEXT:  0x30 R_MIPS_GOT_LO16 -
# OBJ-O32-NEXT:  0x34 R_MIPS_TLS_GOTTPREL -
# OBJ-O32-NEXT:  0x38 R_MIPS_TLS_DTPREL_HI16 -
# OBJ-O32-NEXT:  0x3C R_MIPS_TLS_DTPREL_LO16 -
# OBJ-O32-NEXT:  0x40 R_MIPS_TLS_GD -
# OBJ-O32-NEXT:  0x44 R_MIPS_TLS_LDM -
# OBJ-O32-NEXT:  0x48 R_MIPS_TLS_TPREL_HI16 -
# OBJ-O32-NEXT:  0x4C R_MIPS_TLS_TPREL_LO16 -
# OBJ-O32-NEXT:  0x50 R_MICROMIPS_CALL16 -
# OBJ-O32-NEXT:  0x54 R_MICROMIPS_GOT_DISP -
# OBJ-O32-NEXT:  0x58 R_MICROMIPS_GOT_PAGE -
# OBJ-O32-NEXT:  0x5C R_MICROMIPS_GOT_OFST -
# OBJ-O32-NEXT:  0x64 R_MICROMIPS_TLS_GOTTPREL -
# OBJ-O32-NEXT:  0x68 R_MICROMIPS_TLS_DTPREL_HI16 -
# OBJ-O32-NEXT:  0x6C R_MICROMIPS_TLS_DTPREL_LO16 -
# OBJ-O32-NEXT:  0x70 R_MICROMIPS_TLS_GD -
# OBJ-O32-NEXT:  0x74 R_MICROMIPS_TLS_LDM -
# OBJ-O32-NEXT:  0x78 R_MICROMIPS_TLS_TPREL_HI16 -
# OBJ-O32-NEXT:  0x7C R_MICROMIPS_TLS_TPREL_LO16 -
# OBJ-O32-NEXT:  0x80 R_MIPS_JALR -
# OBJ-O32-NEXT:  0x84 R_MICROMIPS_JALR -
# OBJ-O32-NEXT:  0x88 R_MIPS_NONE -
# OBJ-O32-NEXT:  0x89 R_MIPS_16 -
# OBJ-O32-NEXT:  0x8A R_MIPS_32 -
# OBJ-O32-NEXT:  0x8B R_MIPS_64 -
# OBJ-O32-NEXT:  0x1C R_MIPS_GOT16 -
# OBJ-O32-NEXT:  0x60 R_MICROMIPS_GOT16 -

# OBJ-N32-LABEL: Name: .text
# OBJ-N32:       0000: 00000000 00000000 00000000 00000000
# OBJ-N32-NEXT:  0010: 00000000 00000000 00000000 00000000
# OBJ-N32-NEXT:  0020: 00000000 00000000 00000000 00000000
# OBJ-N32-NEXT:  0030: 00000000 00000000 00000000 00000000
# OBJ-N32-NEXT:  0040: 00000000 00000000 00000000 00000000
# OBJ-N32-NEXT:  0050: 00000000 00000000 00000000 00000000
# OBJ-N32-NEXT:  0060: 00000000 00000000 00000000 00000000
# OBJ-N32-NEXT:  0070: 00000000 00000000 00000000 00000000
# OBJ-N32-NEXT:  0080: 00000000 00000000
# OBJ-N32-LABEL: }
# OBJ-N32-LABEL: Relocations [

# OBJ-N32:       0x4 R_MIPS_NONE .text 0x0
# OBJ-N32-NEXT:  0x0 R_MIPS_NONE .text 0x4
# OBJ-N32-NEXT:  0x8 R_MIPS_32   .text 0x8
# OBJ-N32-NEXT:  0xC R_MIPS_NONE -     0x0
# OBJ-N32-NEXT:  0x10 R_MIPS_CALL_HI16 - 0x4
# OBJ-N32-NEXT:  0x14 R_MIPS_CALL_LO16 - 0x4
# OBJ-N32-NEXT:  0x18 R_MIPS_CALL16 - 0x4
# OBJ-N32-NEXT:  0x1C R_MIPS_GOT16 - 0x4
# OBJ-N32-NEXT:  0x20 R_MIPS_GOT_PAGE - 0x4
# OBJ-N32-NEXT:  0x24 R_MIPS_GOT_OFST - 0x4
# OBJ-N32-NEXT:  0x28 R_MIPS_GOT_DISP - 0x4
# OBJ-N32-NEXT:  0x2C R_MIPS_GOT_HI16 - 0x4
# OBJ-N32-NEXT:  0x30 R_MIPS_GOT_LO16 - 0x4
# OBJ-N32-NEXT:  0x34 R_MIPS_TLS_GOTTPREL - 0x4
# OBJ-N32-NEXT:  0x38 R_MIPS_TLS_DTPREL_HI16 - 0x4
# OBJ-N32-NEXT:  0x3C R_MIPS_TLS_DTPREL_LO16 - 0x4
# OBJ-N32-NEXT:  0x40 R_MIPS_TLS_GD - 0x4
# OBJ-N32-NEXT:  0x44 R_MIPS_TLS_LDM - 0x4
# OBJ-N32-NEXT:  0x48 R_MIPS_TLS_TPREL_HI16 - 0x4
# OBJ-N32-NEXT:  0x4C R_MIPS_TLS_TPREL_LO16 - 0x4
# OBJ-N32-NEXT:  0x50 R_MICROMIPS_CALL16 - 0x4
# OBJ-N32-NEXT:  0x54 R_MICROMIPS_GOT_DISP - 0x4
# OBJ-N32-NEXT:  0x58 R_MICROMIPS_GOT_PAGE - 0x4
# OBJ-N32-NEXT:  0x5C R_MICROMIPS_GOT_OFST - 0x4
# OBJ-N32-NEXT:  0x60 R_MICROMIPS_GOT16 - 0x4
# OBJ-N32-NEXT:  0x64 R_MICROMIPS_TLS_GOTTPREL - 0x4
# OBJ-N32-NEXT:  0x68 R_MICROMIPS_TLS_DTPREL_HI16 - 0x4
# OBJ-N32-NEXT:  0x6C R_MICROMIPS_TLS_DTPREL_LO16 - 0x4
# OBJ-N32-NEXT:  0x70 R_MICROMIPS_TLS_GD - 0x4
# OBJ-N32-NEXT:  0x74 R_MICROMIPS_TLS_LDM - 0x4
# OBJ-N32-NEXT:  0x78 R_MICROMIPS_TLS_TPREL_HI16 - 0x4
# OBJ-N32-NEXT:  0x7C R_MICROMIPS_TLS_TPREL_LO16 - 0x4
# OBJ-N32-NEXT:  0x80 R_MIPS_JALR - 0x4
# OBJ-N32-NEXT:  0x84 R_MICROMIPS_JALR - 0x4
# OBJ-N32-NEXT:  0x88 R_MIPS_NONE - 0x9
# OBJ-N32-NEXT:  0x89 R_MIPS_16 - 0x9
# OBJ-N32-NEXT:  0x8A R_MIPS_32 - 0x9
# OBJ-N32-NEXT:  0x8B R_MIPS_64 - 0x9

# OBJ-N64-LABEL: Name: .text
# OBJ-N64:       0000: 00000000 00000000 00000000 00000000
# OBJ-N64-NEXT:  0010: 00000000 00000000 00000000 00000000
# OBJ-N64-NEXT:  0020: 00000000 00000000 00000000 00000000
# OBJ-N64-NEXT:  0030: 00000000 00000000 00000000 00000000
# OBJ-N64-NEXT:  0040: 00000000 00000000 00000000 00000000
# OBJ-N64-NEXT:  0050: 00000000 00000000 00000000 00000000
# OBJ-N64-NEXT:  0060: 00000000 00000000 00000000 00000000
# OBJ-N64-NEXT:  0070: 00000000 00000000 00000000 00000000
# OBJ-N64-NEXT:  0080: 00000000 00000000
# OBJ-N64-LABEL: }
# OBJ-N64-LABEL: Relocations [
# OBJ-N64:       0x4 R_MIPS_NONE/R_MIPS_NONE/R_MIPS_NONE .text 0x0
# OBJ-N64-NEXT:  0x0 R_MIPS_NONE/R_MIPS_NONE/R_MIPS_NONE .text 0x4
# OBJ-N64-NEXT:  0x8 R_MIPS_32/R_MIPS_NONE/R_MIPS_NONE .text 0x8
# OBJ-N64-NEXT:  0xC R_MIPS_NONE/R_MIPS_NONE/R_MIPS_NONE -   0x0
# OBJ-N64-NEXT:  0x10 R_MIPS_CALL_HI16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x14 R_MIPS_CALL_LO16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x18 R_MIPS_CALL16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x1C R_MIPS_GOT16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x20 R_MIPS_GOT_PAGE/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x24 R_MIPS_GOT_OFST/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x28 R_MIPS_GOT_DISP/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x2C R_MIPS_GOT_HI16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x30 R_MIPS_GOT_LO16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x34 R_MIPS_TLS_GOTTPREL/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x38 R_MIPS_TLS_DTPREL_HI16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x3C R_MIPS_TLS_DTPREL_LO16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x40 R_MIPS_TLS_GD/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x44 R_MIPS_TLS_LDM/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x48 R_MIPS_TLS_TPREL_HI16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x4C R_MIPS_TLS_TPREL_LO16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x50 R_MICROMIPS_CALL16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x54 R_MICROMIPS_GOT_DISP/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x58 R_MICROMIPS_GOT_PAGE/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x5C R_MICROMIPS_GOT_OFST/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x60 R_MICROMIPS_GOT16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x64 R_MICROMIPS_TLS_GOTTPREL/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x68 R_MICROMIPS_TLS_DTPREL_HI16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x6C R_MICROMIPS_TLS_DTPREL_LO16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x70 R_MICROMIPS_TLS_GD/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x74 R_MICROMIPS_TLS_LDM/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x78 R_MICROMIPS_TLS_TPREL_HI16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x7C R_MICROMIPS_TLS_TPREL_LO16/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x80 R_MIPS_JALR/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x84 R_MICROMIPS_JALR/R_MIPS_NONE/R_MIPS_NONE - 0x4
# OBJ-N64-NEXT:  0x88 R_MIPS_NONE/R_MIPS_NONE/R_MIPS_NONE - 0x9
# OBJ-N64-NEXT:  0x89 R_MIPS_16/R_MIPS_NONE/R_MIPS_NONE - 0x9
# OBJ-N64-NEXT:  0x8A R_MIPS_32/R_MIPS_NONE/R_MIPS_NONE - 0x9
# OBJ-N64-NEXT:  0x8B R_MIPS_64/R_MIPS_NONE/R_MIPS_NONE - 0x9
