; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
;RUN: llc < %s -march=amdgcn -mcpu=verde -verify-machineinstrs | FileCheck -check-prefixes=VERDE %s
;RUN: llc < %s -march=amdgcn -mcpu=tonga -verify-machineinstrs | FileCheck -check-prefixes=PREGFX10 %s
;RUN: llc < %s -march=amdgcn -mcpu=gfx1010 -verify-machineinstrs | FileCheck -check-prefixes=GFX10 %s
;RUN: llc < %s -march=amdgcn -mcpu=gfx1100 -verify-machineinstrs | FileCheck -check-prefixes=GFX11 %s

define amdgpu_ps void @tbuffer_store(<4 x i32> inreg, <4 x float>, <4 x float>, <4 x float>) {
; VERDE-LABEL: tbuffer_store:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v12, 0
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v12, s[0:3], 0 format:[BUF_DATA_FORMAT_16_16_16_16,BUF_NUM_FORMAT_USCALED] idxen
; VERDE-NEXT:    tbuffer_store_format_xyzw v[4:7], v12, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32,BUF_NUM_FORMAT_SSCALED] idxen glc
; VERDE-NEXT:    tbuffer_store_format_xyzw v[8:11], v12, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32_32,BUF_NUM_FORMAT_UINT] idxen slc
; VERDE-NEXT:    tbuffer_store_format_xyzw v[8:11], v12, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32_32,BUF_NUM_FORMAT_UINT] idxen glc
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: tbuffer_store:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_mov_b32_e32 v12, 0
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v12, s[0:3], 0 format:[BUF_DATA_FORMAT_16_16_16_16,BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[4:7], v12, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32,BUF_NUM_FORMAT_SSCALED] idxen glc
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[8:11], v12, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32_32,BUF_NUM_FORMAT_UINT] idxen slc
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[8:11], v12, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32_32,BUF_NUM_FORMAT_UINT] idxen glc
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: tbuffer_store:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v12, 0
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v12, s[0:3], 0 format:[BUF_FMT_10_10_10_2_UNORM] idxen
; GFX10-NEXT:    tbuffer_store_format_xyzw v[4:7], v12, s[0:3], 0 format:[BUF_FMT_8_8_8_8_SINT] idxen glc
; GFX10-NEXT:    tbuffer_store_format_xyzw v[8:11], v12, s[0:3], 0 format:78 idxen slc
; GFX10-NEXT:    tbuffer_store_format_xyzw v[8:11], v12, s[0:3], 0 format:78 idxen glc dlc
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: tbuffer_store:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v12, 0
; GFX11-NEXT:    s_clause 0x3
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v12, s[0:3], 0 format:[BUF_FMT_8_8_8_8_USCALED] idxen
; GFX11-NEXT:    tbuffer_store_format_xyzw v[4:7], v12, s[0:3], 0 format:[BUF_FMT_32_32_32_32_UINT] idxen glc
; GFX11-NEXT:    tbuffer_store_format_xyzw v[8:11], v12, s[0:3], 0 format:78 idxen slc
; GFX11-NEXT:    tbuffer_store_format_xyzw v[8:11], v12, s[0:3], 0 format:78 idxen glc dlc
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  %in1 = bitcast <4 x float> %1 to <4 x i32>
  %in2 = bitcast <4 x float> %2 to <4 x i32>
  %in3 = bitcast <4 x float> %3 to <4 x i32>
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %in1, <4 x i32> %0, i32 0, i32 0, i32 0, i32 44, i32 0)
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %in2, <4 x i32> %0, i32 0, i32 0, i32 0, i32 61, i32 1)
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %in3, <4 x i32> %0, i32 0, i32 0, i32 0, i32 78, i32 2)
  call void @llvm.amdgcn.struct.tbuffer.store.v4f32(<4 x float> %3, <4 x i32> %0, i32 0, i32 0, i32 0, i32 78, i32 5)
  ret void
}

define amdgpu_ps void @tbuffer_store_immoffs(<4 x i32> inreg, <4 x float>) {
; VERDE-LABEL: tbuffer_store_immoffs:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v4, 0
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_DATA_FORMAT_16_16,BUF_NUM_FORMAT_FLOAT] idxen offset:42
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: tbuffer_store_immoffs:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_mov_b32_e32 v4, 0
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_DATA_FORMAT_16_16,BUF_NUM_FORMAT_FLOAT] idxen offset:42
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: tbuffer_store_immoffs:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:117 idxen offset:42
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: tbuffer_store_immoffs:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:117 idxen offset:42
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  %in1 = bitcast <4 x float> %1 to <4 x i32>
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %in1, <4 x i32> %0, i32 0, i32 42, i32 0, i32 117, i32 0)
  ret void
}

define amdgpu_ps void @tbuffer_store_scalar_and_imm_offs(<4 x i32> inreg, <4 x float> %vdata, i32 inreg %soffset) {
; VERDE-LABEL: tbuffer_store_scalar_and_imm_offs:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v4, 0
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], s4 format:[BUF_DATA_FORMAT_16_16,BUF_NUM_FORMAT_FLOAT] idxen offset:42
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: tbuffer_store_scalar_and_imm_offs:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_mov_b32_e32 v4, 0
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], s4 format:[BUF_DATA_FORMAT_16_16,BUF_NUM_FORMAT_FLOAT] idxen offset:42
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: tbuffer_store_scalar_and_imm_offs:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], s4 format:117 idxen offset:42
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: tbuffer_store_scalar_and_imm_offs:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], s4 format:117 idxen offset:42
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  %in1 = bitcast <4 x float> %vdata to <4 x i32>
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %in1, <4 x i32> %0, i32 0, i32 42, i32 %soffset, i32 117, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_idx(<4 x i32> inreg, <4 x float> %vdata, i32 %vindex) {
; VERDE-LABEL: buffer_store_idx:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_USCALED] idxen
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_idx:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_idx:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_FMT_10_10_10_2_SSCALED] idxen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_idx:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_FMT_8_8_8_8_SINT] idxen
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  %in1 = bitcast <4 x float> %vdata to <4 x i32>
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %in1, <4 x i32> %0, i32 %vindex, i32 0, i32 0, i32 47, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_ofs(<4 x i32> inreg, <4 x float> %vdata, i32 %voffset) {
; VERDE-LABEL: buffer_store_ofs:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    s_mov_b32 s4, 0
; VERDE-NEXT:    v_mov_b32_e32 v5, v4
; VERDE-NEXT:    v_mov_b32_e32 v4, s4
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_8_8,BUF_NUM_FORMAT_FLOAT] idxen offen
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_ofs:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    s_mov_b32 s4, 0
; PREGFX10-NEXT:    v_mov_b32_e32 v5, v4
; PREGFX10-NEXT:    v_mov_b32_e32 v4, s4
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_8_8,BUF_NUM_FORMAT_FLOAT] idxen offen
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_ofs:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, v4
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:115 idxen offen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_ofs:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v5, v4 :: v_dual_mov_b32 v4, s4
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:115 idxen offen
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  %in1 = bitcast <4 x float> %vdata to <4 x i32>
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %in1, <4 x i32> %0, i32 0, i32 %voffset, i32 0, i32 115, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_both(<4 x i32> inreg, <4 x float> %vdata, i32 %vindex, i32 %voffset) {
; VERDE-LABEL: buffer_store_both:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_10_11_11,BUF_NUM_FORMAT_UINT] idxen offen
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_both:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_10_11_11,BUF_NUM_FORMAT_UINT] idxen offen
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_both:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_FMT_16_16_16_16_SINT] idxen offen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_both:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:70 idxen offen
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  %in1 = bitcast <4 x float> %vdata to <4 x i32>
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %in1, <4 x i32> %0, i32 %vindex, i32 %voffset, i32 0, i32 70, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_wait(<4 x i32> inreg, <4 x float> %vdata, i32 %vindex.1, i32 %vindex.2, i32 %vindex.3) {
; VERDE-LABEL: buffer_store_wait:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen
; VERDE-NEXT:    s_waitcnt expcnt(0)
; VERDE-NEXT:    buffer_load_format_xyzw v[0:3], v5, s[0:3], 0 idxen
; VERDE-NEXT:    s_waitcnt vmcnt(0)
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v6, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32_32,BUF_NUM_FORMAT_USCALED] idxen
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_wait:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen
; PREGFX10-NEXT:    buffer_load_format_xyzw v[0:3], v5, s[0:3], 0 idxen
; PREGFX10-NEXT:    s_waitcnt vmcnt(0)
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v6, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32_32,BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_wait:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_FMT_32_32_SINT] idxen
; GFX10-NEXT:    buffer_load_format_xyzw v[0:3], v5, s[0:3], 0 idxen
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v6, s[0:3], 0 format:[BUF_FMT_10_10_10_2_USCALED] idxen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_wait:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_FMT_32_32_32_32_FLOAT] idxen
; GFX11-NEXT:    buffer_load_format_xyzw v[0:3], v5, s[0:3], 0 idxen
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v6, s[0:3], 0 format:[BUF_FMT_8_8_8_8_UINT] idxen
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  %in1 = bitcast <4 x float> %vdata to <4 x i32>
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %in1, <4 x i32> %0, i32 %vindex.1, i32 0, i32 0, i32 63, i32 0)
  %data = call <4 x float> @llvm.amdgcn.buffer.load.format.v4f32(<4 x i32> %0, i32 %vindex.2, i32 0, i1 0, i1 0)
  %data.i = bitcast <4 x float> %data to <4 x i32>
  call void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32> %data.i, <4 x i32> %0, i32 %vindex.3, i32 0, i32 0, i32 46, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_x1(<4 x i32> inreg %rsrc, float %data, i32 %vindex) {
; VERDE-LABEL: buffer_store_x1:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    tbuffer_store_format_x v0, v1, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32,BUF_NUM_FORMAT_FLOAT] idxen
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_x1:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    tbuffer_store_format_x v0, v1, s[0:3], 0 format:[BUF_DATA_FORMAT_32_32_32,BUF_NUM_FORMAT_FLOAT] idxen
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_x1:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    tbuffer_store_format_x v0, v1, s[0:3], 0 format:125 idxen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_x1:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    tbuffer_store_format_x v0, v1, s[0:3], 0 format:125 idxen
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  %data.i = bitcast float %data to i32
  call void @llvm.amdgcn.struct.tbuffer.store.i32(i32 %data.i, <4 x i32> %rsrc, i32 %vindex, i32 0, i32 0, i32 125, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_x2(<4 x i32> inreg %rsrc, <2 x float> %data, i32 %vindex) {
; VERDE-LABEL: buffer_store_x2:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    tbuffer_store_format_xy v[0:1], v2, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_x2:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    tbuffer_store_format_xy v[0:1], v2, s[0:3], 0 format:[BUF_NUM_FORMAT_USCALED] idxen
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_x2:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    tbuffer_store_format_xy v[0:1], v2, s[0:3], 0 format:[BUF_FMT_10_11_11_SSCALED] idxen
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_x2:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    tbuffer_store_format_xy v[0:1], v2, s[0:3], 0 format:[BUF_FMT_10_10_10_2_SNORM] idxen
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  %data.i = bitcast <2 x float> %data to <2 x i32>
  call void @llvm.amdgcn.struct.tbuffer.store.v2i32(<2 x i32> %data.i, <4 x i32> %rsrc, i32 %vindex, i32 0, i32 0, i32 33, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_voffset_large_12bit(<4 x i32> inreg %rsrc, <4 x float> %data) {
; VERDE-LABEL: buffer_store_voffset_large_12bit:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    v_mov_b32_e32 v4, 0
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offset:4092
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_voffset_large_12bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    v_mov_b32_e32 v4, 0
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offset:4092
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_voffset_large_12bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    v_mov_b32_e32 v4, 0
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_FMT_32_32_SINT] idxen offset:4092
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_voffset_large_12bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    v_mov_b32_e32 v4, 0
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v4, s[0:3], 0 format:[BUF_FMT_32_32_32_32_FLOAT] idxen offset:4092
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.tbuffer.store.v4f32(<4 x float> %data, <4 x i32> %rsrc, i32 0, i32 4092, i32 0, i32 63, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_voffset_large_13bit(<4 x i32> inreg %rsrc, <4 x float> %data) {
; VERDE-LABEL: buffer_store_voffset_large_13bit:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    s_mov_b32 s4, 0
; VERDE-NEXT:    v_mov_b32_e32 v5, 0x1000
; VERDE-NEXT:    v_mov_b32_e32 v4, s4
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offen offset:4092
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_voffset_large_13bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    s_mov_b32 s4, 0
; PREGFX10-NEXT:    v_mov_b32_e32 v5, 0x1000
; PREGFX10-NEXT:    v_mov_b32_e32 v4, s4
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offen offset:4092
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_voffset_large_13bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0x1000
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_FMT_32_32_SINT] idxen offen offset:4092
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_voffset_large_13bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v5, 0x1000 :: v_dual_mov_b32 v4, s4
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_FMT_32_32_32_32_FLOAT] idxen offen offset:4092
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.tbuffer.store.v4f32(<4 x float> %data, <4 x i32> %rsrc, i32 0, i32 8188, i32 0, i32 63, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_voffset_large_16bit(<4 x i32> inreg %rsrc, <4 x float> %data) {
; VERDE-LABEL: buffer_store_voffset_large_16bit:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    s_mov_b32 s4, 0
; VERDE-NEXT:    v_mov_b32_e32 v5, 0xf000
; VERDE-NEXT:    v_mov_b32_e32 v4, s4
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offen offset:4092
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_voffset_large_16bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    s_mov_b32 s4, 0
; PREGFX10-NEXT:    v_mov_b32_e32 v5, 0xf000
; PREGFX10-NEXT:    v_mov_b32_e32 v4, s4
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offen offset:4092
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_voffset_large_16bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0xf000
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_FMT_32_32_SINT] idxen offen offset:4092
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_voffset_large_16bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v5, 0xf000 :: v_dual_mov_b32 v4, s4
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_FMT_32_32_32_32_FLOAT] idxen offen offset:4092
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.tbuffer.store.v4f32(<4 x float> %data, <4 x i32> %rsrc, i32 0, i32 65532, i32 0, i32 63, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_voffset_large_23bit(<4 x i32> inreg %rsrc, <4 x float> %data) {
; VERDE-LABEL: buffer_store_voffset_large_23bit:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    s_mov_b32 s4, 0
; VERDE-NEXT:    v_mov_b32_e32 v5, 0x7ff000
; VERDE-NEXT:    v_mov_b32_e32 v4, s4
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offen offset:4092
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_voffset_large_23bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    s_mov_b32 s4, 0
; PREGFX10-NEXT:    v_mov_b32_e32 v5, 0x7ff000
; PREGFX10-NEXT:    v_mov_b32_e32 v4, s4
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offen offset:4092
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_voffset_large_23bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0x7ff000
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_FMT_32_32_SINT] idxen offen offset:4092
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_voffset_large_23bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v5, 0x7ff000 :: v_dual_mov_b32 v4, s4
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_FMT_32_32_32_32_FLOAT] idxen offen offset:4092
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.tbuffer.store.v4f32(<4 x float> %data, <4 x i32> %rsrc, i32 0, i32 8388604, i32 0, i32 63, i32 0)
  ret void
}

define amdgpu_ps void @buffer_store_voffset_large_24bit(<4 x i32> inreg %rsrc, <4 x float> %data) {
; VERDE-LABEL: buffer_store_voffset_large_24bit:
; VERDE:       ; %bb.0: ; %main_body
; VERDE-NEXT:    s_mov_b32 s4, 0
; VERDE-NEXT:    v_mov_b32_e32 v5, 0xfff000
; VERDE-NEXT:    v_mov_b32_e32 v4, s4
; VERDE-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offen offset:4092
; VERDE-NEXT:    s_endpgm
;
; PREGFX10-LABEL: buffer_store_voffset_large_24bit:
; PREGFX10:       ; %bb.0: ; %main_body
; PREGFX10-NEXT:    s_mov_b32 s4, 0
; PREGFX10-NEXT:    v_mov_b32_e32 v5, 0xfff000
; PREGFX10-NEXT:    v_mov_b32_e32 v4, s4
; PREGFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_DATA_FORMAT_RESERVED_15,BUF_NUM_FORMAT_SSCALED] idxen offen offset:4092
; PREGFX10-NEXT:    s_endpgm
;
; GFX10-LABEL: buffer_store_voffset_large_24bit:
; GFX10:       ; %bb.0: ; %main_body
; GFX10-NEXT:    s_mov_b32 s4, 0
; GFX10-NEXT:    v_mov_b32_e32 v5, 0xfff000
; GFX10-NEXT:    v_mov_b32_e32 v4, s4
; GFX10-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_FMT_32_32_SINT] idxen offen offset:4092
; GFX10-NEXT:    s_endpgm
;
; GFX11-LABEL: buffer_store_voffset_large_24bit:
; GFX11:       ; %bb.0: ; %main_body
; GFX11-NEXT:    s_mov_b32 s4, 0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_dual_mov_b32 v5, 0xfff000 :: v_dual_mov_b32 v4, s4
; GFX11-NEXT:    tbuffer_store_format_xyzw v[0:3], v[4:5], s[0:3], 0 format:[BUF_FMT_32_32_32_32_FLOAT] idxen offen offset:4092
; GFX11-NEXT:    s_nop 0
; GFX11-NEXT:    s_sendmsg sendmsg(MSG_DEALLOC_VGPRS)
; GFX11-NEXT:    s_endpgm
main_body:
  call void @llvm.amdgcn.struct.tbuffer.store.v4f32(<4 x float> %data, <4 x i32> %rsrc, i32 0, i32 16777212, i32 0, i32 63, i32 0)
  ret void
}

declare void @llvm.amdgcn.struct.tbuffer.store.i32(i32, <4 x i32>, i32, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.tbuffer.store.v2i32(<2 x i32>, <4 x i32>, i32, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.tbuffer.store.v4i32(<4 x i32>, <4 x i32>, i32, i32, i32, i32, i32) #0
declare void @llvm.amdgcn.struct.tbuffer.store.v4f32(<4 x float>, <4 x i32>, i32, i32, i32, i32, i32) #0
declare <4 x float> @llvm.amdgcn.buffer.load.format.v4f32(<4 x i32>, i32, i32, i1, i1) #1

attributes #0 = { nounwind }
attributes #1 = { nounwind readonly }


