// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`Decrypt`](crate::operation::decrypt::builders::DecryptFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`ciphertext_blob(Blob)`](crate::operation::decrypt::builders::DecryptFluentBuilder::ciphertext_blob) / [`set_ciphertext_blob(Option<Blob>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::set_ciphertext_blob):<br>required: **true**<br><p>Ciphertext to be decrypted. The blob includes metadata.</p><br>
    ///   - [`encryption_context(impl Into<String>, impl Into<String>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::encryption_context) / [`set_encryption_context(Option<HashMap::<String, String>>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::set_encryption_context):<br>required: **false**<br><p>Specifies the encryption context to use when decrypting the data. An encryption context is valid only for <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations">cryptographic operations</a> with a symmetric encryption KMS key. The standard asymmetric encryption algorithms and HMAC algorithms that KMS uses do not support an encryption context.</p> <p>An <i>encryption context</i> is a collection of non-secret key-value pairs that represent additional authenticated data. When you use an encryption context to encrypt data, you must specify the same (an exact case-sensitive match) encryption context to decrypt the data. An encryption context is supported only on operations with symmetric encryption KMS keys. On operations with symmetric encryption KMS keys, an encryption context is optional, but it is strongly recommended.</p> <p>For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#encrypt_context">Encryption context</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`grant_tokens(impl Into<String>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::grant_tokens) / [`set_grant_tokens(Option<Vec::<String>>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::set_grant_tokens):<br>required: **false**<br><p>A list of grant tokens.</p> <p>Use a grant token when your permission to call this operation comes from a new grant that has not yet achieved <i>eventual consistency</i>. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grants.html#grant_token">Grant token</a> and <a href="https://docs.aws.amazon.com/kms/latest/developerguide/grant-manage.html#using-grant-token">Using a grant token</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`key_id(impl Into<String>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::key_id) / [`set_key_id(Option<String>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::set_key_id):<br>required: **false**<br><p>Specifies the KMS key that KMS uses to decrypt the ciphertext.</p> <p>Enter a key ID of the KMS key that was used to encrypt the ciphertext. If you identify a different KMS key, the <code>Decrypt</code> operation throws an <code>IncorrectKeyException</code>.</p> <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. If you used a symmetric encryption KMS key, KMS can get the KMS key from metadata that it adds to the symmetric ciphertext blob. However, it is always recommended as a best practice. This practice ensures that you use the KMS key that you intend.</p> <p>To specify a KMS key, use its key ID, key ARN, alias name, or alias ARN. When using an alias name, prefix it with <code>"alias/"</code>. To specify a KMS key in a different Amazon Web Services account, you must use the key ARN or alias ARN.</p> <p>For example:</p> <ul>  <li>   <p>Key ID: <code>1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Key ARN: <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code></p></li>  <li>   <p>Alias name: <code>alias/ExampleAlias</code></p></li>  <li>   <p>Alias ARN: <code>arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias</code></p></li> </ul> <p>To get the key ID and key ARN for a KMS key, use <code>ListKeys</code> or <code>DescribeKey</code>. To get the alias name and alias ARN, use <code>ListAliases</code>.</p><br>
    ///   - [`encryption_algorithm(EncryptionAlgorithmSpec)`](crate::operation::decrypt::builders::DecryptFluentBuilder::encryption_algorithm) / [`set_encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::set_encryption_algorithm):<br>required: **false**<br><p>Specifies the encryption algorithm that will be used to decrypt the ciphertext. Specify the same algorithm that was used to encrypt the data. If you specify a different algorithm, the <code>Decrypt</code> operation fails.</p> <p>This parameter is required only when the ciphertext was encrypted under an asymmetric KMS key. The default value, <code>SYMMETRIC_DEFAULT</code>, represents the only supported algorithm that is valid for symmetric encryption KMS keys.</p><br>
    ///   - [`recipient(RecipientInfo)`](crate::operation::decrypt::builders::DecryptFluentBuilder::recipient) / [`set_recipient(Option<RecipientInfo>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::set_recipient):<br>required: **false**<br><p>A signed <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave-concepts.html#term-attestdoc">attestation document</a> from an Amazon Web Services Nitro enclave and the encryption algorithm to use with the enclave's public key. The only valid encryption algorithm is <code>RSAES_OAEP_SHA_256</code>.</p> <p>This parameter only supports attestation documents for Amazon Web Services Nitro Enclaves. To include this parameter, use the <a href="https://docs.aws.amazon.com/enclaves/latest/user/developing-applications.html#sdk">Amazon Web Services Nitro Enclaves SDK</a> or any Amazon Web Services SDK.</p> <p>When you use this parameter, instead of returning the plaintext data, KMS encrypts the plaintext data with the public key in the attestation document, and returns the resulting ciphertext in the <code>CiphertextForRecipient</code> field in the response. This ciphertext can be decrypted only with the private key in the enclave. The <code>Plaintext</code> field in the response is null or empty.</p> <p>For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html">How Amazon Web Services Nitro Enclaves uses KMS</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    ///   - [`dry_run(bool)`](crate::operation::decrypt::builders::DecryptFluentBuilder::dry_run) / [`set_dry_run(Option<bool>)`](crate::operation::decrypt::builders::DecryptFluentBuilder::set_dry_run):<br>required: **false**<br><p>Checks if your request will succeed. <code>DryRun</code> is an optional parameter.</p> <p>To learn more about how to use this parameter, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/programming-dryrun.html">Testing your KMS API calls</a> in the <i>Key Management Service Developer Guide</i>.</p><br>
    /// - On success, responds with [`DecryptOutput`](crate::operation::decrypt::DecryptOutput) with field(s):
    ///   - [`key_id(Option<String>)`](crate::operation::decrypt::DecryptOutput::key_id): <p>The Amazon Resource Name (<a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id-key-ARN">key ARN</a>) of the KMS key that was used to decrypt the ciphertext.</p>
    ///   - [`plaintext(Option<Blob>)`](crate::operation::decrypt::DecryptOutput::plaintext): <p>Decrypted plaintext data. When you use the HTTP API or the Amazon Web Services CLI, the value is Base64-encoded. Otherwise, it is not Base64-encoded.</p> <p>If the response includes the <code>CiphertextForRecipient</code> field, the <code>Plaintext</code> field is null or empty.</p>
    ///   - [`encryption_algorithm(Option<EncryptionAlgorithmSpec>)`](crate::operation::decrypt::DecryptOutput::encryption_algorithm): <p>The encryption algorithm that was used to decrypt the ciphertext.</p>
    ///   - [`ciphertext_for_recipient(Option<Blob>)`](crate::operation::decrypt::DecryptOutput::ciphertext_for_recipient): <p>The plaintext data encrypted with the public key in the attestation document.</p> <p>This field is included in the response only when the <code>Recipient</code> parameter in the request includes a valid attestation document from an Amazon Web Services Nitro enclave. For information about the interaction between KMS and Amazon Web Services Nitro Enclaves, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/services-nitro-enclaves.html">How Amazon Web Services Nitro Enclaves uses KMS</a> in the <i>Key Management Service Developer Guide</i>.</p>
    /// - On failure, responds with [`SdkError<DecryptError>`](crate::operation::decrypt::DecryptError)
    pub fn decrypt(&self) -> crate::operation::decrypt::builders::DecryptFluentBuilder {
        crate::operation::decrypt::builders::DecryptFluentBuilder::new(self.handle.clone())
    }
}
