/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import com.clarkware.junitperf.TestFactory;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMethodFactory
extends TestFactory {
    private final String testMethodName;
    static /* synthetic */ Class class$java$lang$String;

    public TestMethodFactory(Class testClass, String testMethodName) {
        super(testClass);
        this.testMethodName = testMethodName;
    }

    protected TestSuite makeTestSuite() {
        TestSuite suite = new TestSuite();
        Constructor constructor = null;
        try {
            constructor = this.getConstructor(this.testClass);
        }
        catch (NoSuchMethodException e) {
            suite.addTest(this.warning("Class " + this.testClass.getName() + " has no public constructor TestCase(String name)"));
            return suite;
        }
        if (!Modifier.isPublic(this.testClass.getModifiers())) {
            suite.addTest(this.warning("Class " + this.testClass.getName() + " is not public"));
            return suite;
        }
        this.addTestMethod(suite, constructor, this.testMethodName);
        if (suite.testCount() == 0) {
            suite.addTest(this.warning("No tests found in " + this.testClass.getName()));
        }
        return suite;
    }

    private void addTestMethod(TestSuite suite, Constructor constructor, String methodName) {
        Object[] args = new Object[]{methodName};
        try {
            suite.addTest((Test)constructor.newInstance(args));
        }
        catch (InstantiationException ie) {
            suite.addTest(this.warning("Cannot instantiate test case: " + methodName + " (" + this.toString(ie) + ")"));
        }
        catch (InvocationTargetException ite) {
            suite.addTest(this.warning("Exception in constructor: " + methodName + " (" + this.toString(ite.getTargetException()) + ")"));
        }
        catch (IllegalAccessException iae) {
            suite.addTest(this.warning("Cannot access test case: " + methodName + " (" + this.toString(iae) + ")"));
        }
    }

    private Constructor getConstructor(Class theClass) throws NoSuchMethodException {
        Class[] args = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TestMethodFactory.class$("java.lang.String")) : class$java$lang$String};
        return theClass.getConstructor(args);
    }

    private Test warning(final String message) {
        return new TestCase("warning"){

            protected void runTest() {
                1.fail((String)message);
            }
        };
    }

    private String toString(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

