# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, TYPE_CHECKING

from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.mgmt.core import AsyncARMPipelineClient

from .. import models as _models
from .._serialization import Deserializer, Serializer
from ._configuration import CdnManagementClientConfiguration
from .operations import (
    AFDCustomDomainsOperations,
    AFDEndpointsOperations,
    AFDOriginGroupsOperations,
    AFDOriginsOperations,
    AFDProfilesOperations,
    CdnManagementClientOperationsMixin,
    CustomDomainsOperations,
    EdgeNodesOperations,
    EndpointsOperations,
    LogAnalyticsOperations,
    ManagedRuleSetsOperations,
    Operations,
    OriginGroupsOperations,
    OriginsOperations,
    PoliciesOperations,
    ProfilesOperations,
    ResourceUsageOperations,
    RoutesOperations,
    RuleSetsOperations,
    RulesOperations,
    SecretsOperations,
    SecurityPoliciesOperations,
)

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials_async import AsyncTokenCredential


class CdnManagementClient(
    CdnManagementClientOperationsMixin
):  # pylint: disable=client-accepts-api-version-keyword,too-many-instance-attributes
    """Cdn Management Client.

    :ivar afd_profiles: AFDProfilesOperations operations
    :vartype afd_profiles: azure.mgmt.cdn.aio.operations.AFDProfilesOperations
    :ivar afd_custom_domains: AFDCustomDomainsOperations operations
    :vartype afd_custom_domains: azure.mgmt.cdn.aio.operations.AFDCustomDomainsOperations
    :ivar afd_endpoints: AFDEndpointsOperations operations
    :vartype afd_endpoints: azure.mgmt.cdn.aio.operations.AFDEndpointsOperations
    :ivar afd_origin_groups: AFDOriginGroupsOperations operations
    :vartype afd_origin_groups: azure.mgmt.cdn.aio.operations.AFDOriginGroupsOperations
    :ivar afd_origins: AFDOriginsOperations operations
    :vartype afd_origins: azure.mgmt.cdn.aio.operations.AFDOriginsOperations
    :ivar routes: RoutesOperations operations
    :vartype routes: azure.mgmt.cdn.aio.operations.RoutesOperations
    :ivar rule_sets: RuleSetsOperations operations
    :vartype rule_sets: azure.mgmt.cdn.aio.operations.RuleSetsOperations
    :ivar rules: RulesOperations operations
    :vartype rules: azure.mgmt.cdn.aio.operations.RulesOperations
    :ivar security_policies: SecurityPoliciesOperations operations
    :vartype security_policies: azure.mgmt.cdn.aio.operations.SecurityPoliciesOperations
    :ivar secrets: SecretsOperations operations
    :vartype secrets: azure.mgmt.cdn.aio.operations.SecretsOperations
    :ivar log_analytics: LogAnalyticsOperations operations
    :vartype log_analytics: azure.mgmt.cdn.aio.operations.LogAnalyticsOperations
    :ivar profiles: ProfilesOperations operations
    :vartype profiles: azure.mgmt.cdn.aio.operations.ProfilesOperations
    :ivar endpoints: EndpointsOperations operations
    :vartype endpoints: azure.mgmt.cdn.aio.operations.EndpointsOperations
    :ivar origins: OriginsOperations operations
    :vartype origins: azure.mgmt.cdn.aio.operations.OriginsOperations
    :ivar origin_groups: OriginGroupsOperations operations
    :vartype origin_groups: azure.mgmt.cdn.aio.operations.OriginGroupsOperations
    :ivar custom_domains: CustomDomainsOperations operations
    :vartype custom_domains: azure.mgmt.cdn.aio.operations.CustomDomainsOperations
    :ivar resource_usage: ResourceUsageOperations operations
    :vartype resource_usage: azure.mgmt.cdn.aio.operations.ResourceUsageOperations
    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.cdn.aio.operations.Operations
    :ivar edge_nodes: EdgeNodesOperations operations
    :vartype edge_nodes: azure.mgmt.cdn.aio.operations.EdgeNodesOperations
    :ivar policies: PoliciesOperations operations
    :vartype policies: azure.mgmt.cdn.aio.operations.PoliciesOperations
    :ivar managed_rule_sets: ManagedRuleSetsOperations operations
    :vartype managed_rule_sets: azure.mgmt.cdn.aio.operations.ManagedRuleSetsOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: Azure Subscription ID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is "https://management.azure.com".
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2023-05-01". Note that overriding this
     default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = CdnManagementClientConfiguration(
            credential=credential, subscription_id=subscription_id, **kwargs
        )
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.afd_profiles = AFDProfilesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.afd_custom_domains = AFDCustomDomainsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.afd_endpoints = AFDEndpointsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.afd_origin_groups = AFDOriginGroupsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.afd_origins = AFDOriginsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.routes = RoutesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.rule_sets = RuleSetsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.rules = RulesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.security_policies = SecurityPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.secrets = SecretsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.log_analytics = LogAnalyticsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.profiles = ProfilesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.endpoints = EndpointsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.origins = OriginsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.origin_groups = OriginGroupsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.custom_domains = CustomDomainsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.resource_usage = ResourceUsageOperations(self._client, self._config, self._serialize, self._deserialize)
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.edge_nodes = EdgeNodesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.policies = PoliciesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.managed_rule_sets = ManagedRuleSetsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def _send_request(self, request: HttpRequest, **kwargs: Any) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> "CdnManagementClient":
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
