/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import com.fourthpass.runtime.a;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.Principal;
import java.security.Security;
import java.util.Date;
import javax.security.cert.Certificate;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;

public abstract class X509Certificate
extends Certificate {
    static /* synthetic */ Class class$java$io$InputStream;
    private static String X509Provider = null;

    public abstract int getVersion();

    public abstract Principal getSubjectDN();

    public abstract byte[] getSigAlgParams();

    public abstract String getSigAlgOID();

    public abstract String getSigAlgName();

    public abstract BigInteger getSerialNumber();

    public abstract Date getNotBefore();

    public abstract Date getNotAfter();

    public abstract Principal getIssuerDN();

    public static final X509Certificate getInstance(byte[] byArray) throws CertificateException {
        return X509Certificate.getInst(byArray);
    }

    public static final X509Certificate getInstance(InputStream inputStream) throws CertificateException {
        return X509Certificate.getInst(inputStream);
    }

    private static final X509Certificate getInst(Object object) throws CertificateException {
        String string = X509Provider;
        if (string == null) {
            string = "com.ibm.security.cert.a";
        }
        try {
            Class[] classArray = null;
            if (object instanceof InputStream) {
                classArray = new Class[]{class$java$io$InputStream != null ? class$java$io$InputStream : (class$java$io$InputStream = X509Certificate.class$("java.io.InputStream"))};
            } else if (object instanceof byte[]) {
                classArray = new Class[]{object.getClass()};
            } else {
                throw new CertificateException("Unsupported argument type");
            }
            Class clazz = a.a(string);
            Constructor constructor = clazz.getConstructor(classArray);
            Object t2 = constructor.newInstance(object);
            return (X509Certificate)t2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new CertificateException("Could not find class: " + classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CertificateException("Could not access class: " + illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new CertificateException("Problems instantiating: " + instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new CertificateException("InvocationTargetException: " + invocationTargetException.getTargetException());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new CertificateException("Could not find class method: " + noSuchMethodException.getMessage());
        }
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public abstract void checkValidity(Date var1) throws CertificateNotYetValidException, CertificateExpiredException;

    public abstract void checkValidity() throws CertificateNotYetValidException, CertificateExpiredException;

    static {
        try {
            X509Provider = Security.getProperty("cert.provider.x509v1");
        }
        catch (SecurityException securityException) {}
    }
}

