/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Vector;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileListParser;

public final class DefaultFTPFileListParser
implements FTPFileListParser {
    private int __charArrayToInt(char[] arr, int start, int end) {
        int value = 0;
        int decimal = 1;
        while (end-- > start) {
            value += decimal * (arr[end] - 48);
            decimal *= 10;
        }
        return value;
    }

    private long __charArrayToLong(char[] arr, int start, int end) {
        long value = 0L;
        long decimal = 1L;
        while (end-- > start) {
            value += decimal * (long)(arr[end] - 48);
            decimal *= 10L;
        }
        return value;
    }

    private int __skipWhitespace(char[] cToken, int start) {
        while (start < cToken.length && Character.isWhitespace(cToken[start])) {
            ++start;
        }
        return start;
    }

    private int __skipDigits(char[] cToken, int start) {
        while (start < cToken.length && Character.isDigit(cToken[start])) {
            ++start;
        }
        return start;
    }

    private int __skipNonWhitespace(char[] cToken, int start) {
        while (start < cToken.length && !Character.isWhitespace(cToken[start])) {
            ++start;
        }
        return start;
    }

    private int __skipNonWhitespaceToLower(char[] cToken, int start) {
        while (start < cToken.length && !Character.isWhitespace(cToken[start])) {
            cToken[start] = Character.toLowerCase(cToken[start]);
            ++start;
        }
        return start;
    }

    public FTPFile parseFTPEntry(String entry) {
        FTPFile file;
        try {
            int month;
            int type;
            char[] cToken = entry.toCharArray();
            file = new FTPFile();
            file.setRawListing(entry);
            boolean isDevice = cToken[0] == 'b' || cToken[0] == 'c';
            switch (cToken[0]) {
                case 'd': {
                    type = 1;
                    break;
                }
                case 'l': {
                    type = 2;
                    break;
                }
                default: {
                    type = 0;
                }
            }
            file.setType(type);
            int access = 0;
            int start = 1;
            while (access < 3) {
                file.setPermission(access, 0, cToken[start++] != '-');
                file.setPermission(access, 1, cToken[start++] != '-');
                file.setPermission(access, 2, cToken[start++] != '-');
                ++access;
            }
            start = this.__skipWhitespace(cToken, start);
            int end = this.__skipDigits(cToken, start);
            file.setHardLinkCount(this.__charArrayToInt(cToken, start, end));
            start = this.__skipWhitespace(cToken, end);
            end = this.__skipNonWhitespace(cToken, start);
            file.setUser(new String(cToken, start, end - start));
            start = this.__skipWhitespace(cToken, end);
            end = this.__skipNonWhitespace(cToken, start);
            file.setGroup(new String(cToken, start, end - start));
            if (isDevice) {
                start = this.__skipWhitespace(cToken, end);
                end = this.__skipNonWhitespace(cToken, start);
                start = this.__skipWhitespace(cToken, end);
                end = this.__skipNonWhitespace(cToken, start);
            } else {
                start = this.__skipWhitespace(cToken, end);
                end = this.__skipDigits(cToken, start);
                file.setSize(this.__charArrayToLong(cToken, start, end));
            }
            start = this.__skipWhitespace(cToken, end);
            end = this.__skipNonWhitespaceToLower(cToken, start);
            switch (cToken[start]) {
                case 'a': {
                    if (cToken[end - 1] == 'r') {
                        month = 3;
                        break;
                    }
                    month = 7;
                    break;
                }
                case 'd': {
                    month = 11;
                    break;
                }
                case 'f': {
                    month = 1;
                    break;
                }
                case 'j': {
                    if (cToken[end - 1] == 'l') {
                        month = 6;
                        break;
                    }
                    if (cToken[start + 1] == 'a') {
                        month = 0;
                        break;
                    }
                    month = 5;
                    break;
                }
                case 'm': {
                    if (cToken[end - 1] == 'y') {
                        month = 4;
                        break;
                    }
                    month = 2;
                    break;
                }
                case 'n': {
                    month = 10;
                    break;
                }
                case 'o': {
                    month = 9;
                    break;
                }
                case 's': {
                    month = 8;
                    break;
                }
                default: {
                    month = 0;
                }
            }
            start = this.__skipWhitespace(cToken, end);
            end = this.__skipDigits(cToken, start);
            access = this.__charArrayToInt(cToken, start, end);
            start = this.__skipWhitespace(cToken, end);
            end = this.__skipDigits(cToken, start);
            Calendar date = Calendar.getInstance();
            try {
                int minutes;
                int hour;
                int year;
                if (cToken[end] == ':') {
                    year = date.get(1);
                    hour = date.get(2);
                    if (hour < month) {
                        --year;
                    }
                    hour = this.__charArrayToInt(cToken, start, end);
                    start = end + 1;
                    end = this.__skipDigits(cToken, start);
                    minutes = this.__charArrayToInt(cToken, start, end);
                } else {
                    minutes = -1;
                    hour = -1;
                    year = this.__charArrayToInt(cToken, start, end);
                }
                date.clear();
                date.set(1, year);
                date.set(2, month);
                date.set(5, access);
                if (hour != -1) {
                    date.set(10, hour);
                    date.set(12, minutes);
                }
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            file.setTimestamp(date);
            start = end + 1;
            end = this.__skipNonWhitespace(cToken, start);
            if (end >= cToken.length) {
                file.setName(new String(cToken, start, end - start));
                return file;
            }
            String sToken = new String(cToken, start, cToken.length - start);
            if (type == 2) {
                end = sToken.indexOf(" -> ");
                if (end == -1) {
                    file.setName(sToken);
                    return file;
                }
                file.setName(sToken.substring(0, end));
                file.setLink(sToken.substring(end + 4));
                return file;
            }
            file.setName(sToken);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        catch (StringIndexOutOfBoundsException e) {
            return null;
        }
        return file;
    }

    public FTPFile[] parseFileList(InputStream listStream) throws IOException {
        Vector<FTPFile> results;
        BufferedReader reader = new BufferedReader(new InputStreamReader(listStream));
        String line = reader.readLine();
        if (line == null) {
            results = null;
        } else {
            FTPFile entry;
            results = new Vector<FTPFile>();
            if (line.toLowerCase().startsWith("total")) {
                line = reader.readLine();
            } else {
                entry = this.parseFTPEntry(line);
                if (entry != null) {
                    results.addElement(entry);
                }
                line = reader.readLine();
            }
            while (line != null) {
                if (line.length() == 0 || (entry = this.parseFTPEntry(line)) == null) {
                    results = null;
                    break;
                }
                results.addElement(entry);
                line = reader.readLine();
            }
        }
        if (line != null) {
            while ((line = reader.readLine()) != null) {
            }
        }
        reader.close();
        if (results != null) {
            Object[] result = new FTPFile[results.size()];
            if (result.length > 0) {
                results.copyInto(result);
            }
            return result;
        }
        return null;
    }
}

