/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.psd;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiEncoderBase;
import com.sun.jimi.core.encoder.psd.EncodeImageIfc;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.Packbits;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

class PSDFileHeader
implements EncodeImageIfc {
    static final int PSD_SIGNATURE = 943870035;
    static final short BITMAP = 0;
    static final short GRAYSCALE = 1;
    static final short INDEXED = 2;
    static final short RGB = 3;
    AdaptiveRasterImage ji_;
    DataOutputStream out_;
    short channels_;
    int rows_;
    int cols_;
    short depth_;
    short colorMode_;
    JimiEncoderBase encoder_;
    short[] SLLTable_;
    int sllOffset_;

    PSDFileHeader(JimiEncoderBase jimiEncoderBase, AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream) throws JimiException {
        this.ji_ = adaptiveRasterImage;
        this.out_ = dataOutputStream;
        this.encoder_ = jimiEncoderBase;
        this.colorMode_ = (short)-1;
        ColorModel colorModel = this.ji_.getColorModel();
        this.cols_ = this.ji_.getWidth();
        this.rows_ = this.ji_.getHeight();
        if (colorModel instanceof IndexColorModel) {
            this.channels_ = 1;
            this.colorMode_ = (short)2;
            this.depth_ = (short)8;
        } else if (colorModel instanceof DirectColorModel) {
            DirectColorModel directColorModel = (DirectColorModel)colorModel;
            int n = directColorModel.getRedMask();
            int n2 = directColorModel.getGreenMask();
            int n3 = directColorModel.getBlueMask();
            int n4 = directColorModel.getPixelSize();
            if (n == (1 << n4) - 1 && n == n2 && n2 == n3) {
                this.channels_ = 1;
                if (n4 == 1) {
                    this.depth_ = 1;
                    this.colorMode_ = 0;
                } else {
                    this.depth_ = (short)8;
                    this.colorMode_ = 1;
                }
            }
        }
        if (this.colorMode_ == -1) {
            this.channels_ = (short)3;
            this.colorMode_ = (short)3;
            this.depth_ = (short)8;
            this.ji_.setRGBDefault(true);
        }
    }

    EncodeImageIfc createEncodeImage() {
        return this;
    }

    public void encodeImage(AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream, int n) throws JimiException {
        try {
            dataOutputStream.writeShort(n);
            switch (this.colorMode_) {
                case 0: {
                    if (n == 0) {
                        this.outputGrayChannel(3, adaptiveRasterImage, dataOutputStream, 0);
                    } else {
                        this.outputRLE(adaptiveRasterImage, dataOutputStream);
                    }
                    break;
                }
                case 1: {
                    if (n == 0) {
                        this.outputGrayChannel(3, adaptiveRasterImage, dataOutputStream, 0);
                    } else {
                        this.outputRLE(adaptiveRasterImage, dataOutputStream);
                    }
                    break;
                }
                case 2: {
                    if (n == 0) {
                        this.outputRawChannel(3, adaptiveRasterImage, dataOutputStream);
                    } else {
                        this.outputRLE(adaptiveRasterImage, dataOutputStream);
                    }
                    break;
                }
                case 3: {
                    if (n == 0) {
                        this.outputRawRGB(adaptiveRasterImage, dataOutputStream);
                    } else {
                        this.outputRLERGB(adaptiveRasterImage, dataOutputStream);
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.getMessage());
        }
    }

    void getRLELens(int n, AdaptiveRasterImage adaptiveRasterImage, short[] sArray, int n2) throws JimiException, IOException {
        byte[] byArray = new byte[this.cols_];
        byte[] byArray2 = new byte[this.cols_ + this.cols_ / 128 + 1];
        int n3 = 0;
        while (n3 < this.rows_) {
            adaptiveRasterImage.getChannel(n, n3, byArray, 0);
            sArray[n2] = (short)Packbits.packbits(byArray, byArray2);
            ++n2;
            this.encoder_.setProgress(n3 * 100 / this.rows_);
            ++n3;
        }
    }

    void outputGrayChannel(int n, AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream, int n2) throws JimiException, IOException {
        byte[] byArray = new byte[this.cols_];
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        if (n2 != 0) {
            byArray2 = new byte[this.cols_ + this.cols_ / 128 + 1];
        }
        int n3 = adaptiveRasterImage.getColorModel().getPixelSize();
        boolean bl = false;
        ColorModel colorModel = adaptiveRasterImage.getColorModel();
        int n4 = 0;
        while (n4 < this.rows_) {
            int n5;
            int n6;
            this.encoder_.setProgress(n4 * 100 / this.rows_);
            adaptiveRasterImage.getChannel(n, n4, byArray, 0);
            if (n3 == 1) {
                if (byArray3 == null) {
                    byArray3 = new byte[byArray.length / 8 + (byArray.length % 8 != 0 ? 1 : 0)];
                }
                JimiUtil.packPixels(1, byArray, byArray3);
                if (!bl) {
                    n6 = byArray3.length;
                    while (--n6 >= 0) {
                        byArray3[n6] = ~byArray3[n6];
                    }
                }
                if (n2 == 0) {
                    dataOutputStream.write(byArray3);
                } else {
                    n5 = Packbits.packbits(byArray3, byArray2);
                    if (this.SLLTable_ != null) {
                        this.SLLTable_[this.sllOffset_++] = (short)n5;
                    } else {
                        dataOutputStream.write(byArray2, 0, n5);
                    }
                }
            } else {
                if (n3 < 8) {
                    JimiUtil.pixelDepthChange(n3, byArray, 8);
                }
                if (bl) {
                    n6 = byArray.length;
                    while (--n6 >= 0) {
                        byArray[n6] = ~byArray[n6];
                    }
                }
                if (n2 == 0) {
                    dataOutputStream.write(byArray);
                } else {
                    n5 = Packbits.packbits(byArray, byArray2);
                    if (this.SLLTable_ != null) {
                        this.SLLTable_[this.sllOffset_++] = (short)n5;
                    } else {
                        dataOutputStream.write(byArray2, 0, n5);
                    }
                }
            }
            ++n4;
        }
    }

    void outputRLE(AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream) throws JimiException, IOException {
        short[] sArray = new short[this.rows_ * this.channels_];
        if (this.colorMode_ == 2) {
            this.getRLELens(0, adaptiveRasterImage, sArray, 0);
        } else {
            this.SLLTable_ = sArray;
            this.sllOffset_ = 0;
            this.outputGrayChannel(0, adaptiveRasterImage, dataOutputStream, 1);
            this.SLLTable_ = null;
        }
        int n = 0;
        while (n < sArray.length) {
            dataOutputStream.write((sArray[n] & 0xFF00) >> 8);
            dataOutputStream.write(sArray[n] & 0xFF);
            ++n;
        }
        if (this.colorMode_ == 2) {
            this.outputRLEChannel(0, adaptiveRasterImage, dataOutputStream);
        } else {
            this.outputGrayChannel(0, adaptiveRasterImage, dataOutputStream, 1);
        }
    }

    void outputRLEChannel(int n, AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream) throws JimiException, IOException {
        byte[] byArray = new byte[this.cols_];
        byte[] byArray2 = new byte[this.cols_ + this.cols_ / 128 + 1];
        int n2 = 0;
        while (n2 < this.rows_) {
            adaptiveRasterImage.getChannel(n, n2, byArray, 0);
            int n3 = Packbits.packbits(byArray, byArray2);
            dataOutputStream.write(byArray2, 0, n3);
            this.encoder_.setProgress(n2 * 100 / this.rows_);
            ++n2;
        }
    }

    void outputRLERGB(AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream) throws JimiException, IOException {
        byte[] byArray = new byte[this.cols_];
        short[] sArray = new short[this.rows_ * this.channels_];
        int n = 0;
        this.getRLELens(16, adaptiveRasterImage, sArray, n);
        this.getRLELens(8, adaptiveRasterImage, sArray, n += this.rows_);
        this.getRLELens(0, adaptiveRasterImage, sArray, n += this.rows_);
        int n2 = 0;
        while (n2 < sArray.length) {
            dataOutputStream.write((sArray[n2] & 0xFF00) >> 8);
            dataOutputStream.write(sArray[n2] & 0xFF);
            ++n2;
        }
        this.outputRLEChannel(16, adaptiveRasterImage, dataOutputStream);
        this.outputRLEChannel(8, adaptiveRasterImage, dataOutputStream);
        this.outputRLEChannel(0, adaptiveRasterImage, dataOutputStream);
    }

    void outputRawChannel(int n, AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream) throws JimiException, IOException {
        byte[] byArray = new byte[this.cols_];
        int n2 = 0;
        while (n2 < this.rows_) {
            adaptiveRasterImage.getChannel(n, n2, byArray, 0);
            dataOutputStream.write(byArray);
            this.encoder_.setProgress(n2 * 100 / this.rows_);
            ++n2;
        }
    }

    void outputRawRGB(AdaptiveRasterImage adaptiveRasterImage, DataOutputStream dataOutputStream) throws JimiException, IOException {
        this.outputRawChannel(16, adaptiveRasterImage, dataOutputStream);
        this.outputRawChannel(8, adaptiveRasterImage, dataOutputStream);
        this.outputRawChannel(0, adaptiveRasterImage, dataOutputStream);
    }

    void write() throws IOException {
        this.out_.writeInt(943870035);
        this.out_.writeShort(1);
        int n = 6;
        while (--n >= 0) {
            this.out_.writeByte(0);
        }
        this.out_.writeShort(this.channels_);
        this.out_.writeInt(this.rows_);
        this.out_.writeInt(this.cols_);
        this.out_.writeShort(this.depth_);
        this.out_.writeShort(this.colorMode_);
    }
}

