<!--
This file is generated by `cargo collect-metadata`.
Please use that command to update the file and do not edit it by hand.
-->

## Lint Configuration Options
| <div style="width:290px">Option</div> | Default Value |
|--|--|
| [arithmetic-side-effects-allowed](#arithmetic-side-effects-allowed) | `{}` |
| [arithmetic-side-effects-allowed-binary](#arithmetic-side-effects-allowed-binary) | `[]` |
| [arithmetic-side-effects-allowed-unary](#arithmetic-side-effects-allowed-unary) | `{}` |
| [avoid-breaking-exported-api](#avoid-breaking-exported-api) | `true` |
| [msrv](#msrv) | `None` |
| [cognitive-complexity-threshold](#cognitive-complexity-threshold) | `25` |
| [disallowed-names](#disallowed-names) | `["foo", "baz", "quux"]` |
| [doc-valid-idents](#doc-valid-idents) | `["KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "DirectX", "ECMAScript", "GPLv2", "GPLv3", "GitHub", "GitLab", "IPv4", "IPv6", "ClojureScript", "CoffeeScript", "JavaScript", "PureScript", "TypeScript", "NaN", "NaNs", "OAuth", "GraphQL", "OCaml", "OpenGL", "OpenMP", "OpenSSH", "OpenSSL", "OpenStreetMap", "OpenDNS", "WebGL", "TensorFlow", "TrueType", "iOS", "macOS", "FreeBSD", "TeX", "LaTeX", "BibTeX", "BibLaTeX", "MinGW", "CamelCase"]` |
| [too-many-arguments-threshold](#too-many-arguments-threshold) | `7` |
| [type-complexity-threshold](#type-complexity-threshold) | `250` |
| [single-char-binding-names-threshold](#single-char-binding-names-threshold) | `4` |
| [too-large-for-stack](#too-large-for-stack) | `200` |
| [enum-variant-name-threshold](#enum-variant-name-threshold) | `3` |
| [enum-variant-size-threshold](#enum-variant-size-threshold) | `200` |
| [verbose-bit-mask-threshold](#verbose-bit-mask-threshold) | `1` |
| [literal-representation-threshold](#literal-representation-threshold) | `16384` |
| [trivial-copy-size-limit](#trivial-copy-size-limit) | `None` |
| [pass-by-value-size-limit](#pass-by-value-size-limit) | `256` |
| [too-many-lines-threshold](#too-many-lines-threshold) | `100` |
| [array-size-threshold](#array-size-threshold) | `512000` |
| [vec-box-size-threshold](#vec-box-size-threshold) | `4096` |
| [max-trait-bounds](#max-trait-bounds) | `3` |
| [max-struct-bools](#max-struct-bools) | `3` |
| [max-fn-params-bools](#max-fn-params-bools) | `3` |
| [warn-on-all-wildcard-imports](#warn-on-all-wildcard-imports) | `false` |
| [disallowed-macros](#disallowed-macros) | `[]` |
| [disallowed-methods](#disallowed-methods) | `[]` |
| [disallowed-types](#disallowed-types) | `[]` |
| [unreadable-literal-lint-fractions](#unreadable-literal-lint-fractions) | `true` |
| [upper-case-acronyms-aggressive](#upper-case-acronyms-aggressive) | `false` |
| [matches-for-let-else](#matches-for-let-else) | `WellKnownTypes` |
| [cargo-ignore-publish](#cargo-ignore-publish) | `false` |
| [standard-macro-braces](#standard-macro-braces) | `[]` |
| [enforced-import-renames](#enforced-import-renames) | `[]` |
| [allowed-scripts](#allowed-scripts) | `["Latin"]` |
| [enable-raw-pointer-heuristic-for-send](#enable-raw-pointer-heuristic-for-send) | `true` |
| [max-suggested-slice-pattern-length](#max-suggested-slice-pattern-length) | `3` |
| [await-holding-invalid-types](#await-holding-invalid-types) | `[]` |
| [max-include-file-size](#max-include-file-size) | `1000000` |
| [allow-expect-in-tests](#allow-expect-in-tests) | `false` |
| [allow-unwrap-in-tests](#allow-unwrap-in-tests) | `false` |
| [allow-dbg-in-tests](#allow-dbg-in-tests) | `false` |
| [allow-print-in-tests](#allow-print-in-tests) | `false` |
| [large-error-threshold](#large-error-threshold) | `128` |
| [ignore-interior-mutability](#ignore-interior-mutability) | `["bytes::Bytes"]` |
| [allow-mixed-uninlined-format-args](#allow-mixed-uninlined-format-args) | `true` |
| [suppress-restriction-lint-in-const](#suppress-restriction-lint-in-const) | `false` |
| [missing-docs-in-crate-items](#missing-docs-in-crate-items) | `false` |

### arithmetic-side-effects-allowed
Suppress checking of the passed type names in all types of operations.

If a specific operation is desired, consider using `arithmetic_side_effects_allowed_binary` or `arithmetic_side_effects_allowed_unary` instead.

#### Example

```toml
arithmetic-side-effects-allowed = ["SomeType", "AnotherType"]
```

#### Noteworthy

A type, say `SomeType`, listed in this configuration has the same behavior of
`["SomeType" , "*"], ["*", "SomeType"]` in `arithmetic_side_effects_allowed_binary`.

**Default Value:** `{}` (`rustc_data_structures::fx::FxHashSet<String>`)

* [arithmetic_side_effects](https://rust-lang.github.io/rust-clippy/master/index.html#arithmetic_side_effects)


### arithmetic-side-effects-allowed-binary
Suppress checking of the passed type pair names in binary operations like addition or
multiplication.

Supports the "*" wildcard to indicate that a certain type won't trigger the lint regardless
of the involved counterpart. For example, `["SomeType", "*"]` or `["*", "AnotherType"]`.

Pairs are asymmetric, which means that `["SomeType", "AnotherType"]` is not the same as
`["AnotherType", "SomeType"]`.

#### Example

```toml
arithmetic-side-effects-allowed-binary = [["SomeType" , "f32"], ["AnotherType", "*"]]
```

**Default Value:** `[]` (`Vec<[String; 2]>`)

* [arithmetic_side_effects](https://rust-lang.github.io/rust-clippy/master/index.html#arithmetic_side_effects)


### arithmetic-side-effects-allowed-unary
Suppress checking of the passed type names in unary operations like "negation" (`-`).

#### Example

```toml
arithmetic-side-effects-allowed-unary = ["SomeType", "AnotherType"]
```

**Default Value:** `{}` (`rustc_data_structures::fx::FxHashSet<String>`)

* [arithmetic_side_effects](https://rust-lang.github.io/rust-clippy/master/index.html#arithmetic_side_effects)


### avoid-breaking-exported-api
Suppress lints whenever the suggested change would cause breakage for other crates.

**Default Value:** `true` (`bool`)

* [enum_variant_names](https://rust-lang.github.io/rust-clippy/master/index.html#enum_variant_names)
* [large_types_passed_by_value](https://rust-lang.github.io/rust-clippy/master/index.html#large_types_passed_by_value)
* [trivially_copy_pass_by_ref](https://rust-lang.github.io/rust-clippy/master/index.html#trivially_copy_pass_by_ref)
* [unnecessary_wraps](https://rust-lang.github.io/rust-clippy/master/index.html#unnecessary_wraps)
* [unused_self](https://rust-lang.github.io/rust-clippy/master/index.html#unused_self)
* [upper_case_acronyms](https://rust-lang.github.io/rust-clippy/master/index.html#upper_case_acronyms)
* [wrong_self_convention](https://rust-lang.github.io/rust-clippy/master/index.html#wrong_self_convention)
* [box_collection](https://rust-lang.github.io/rust-clippy/master/index.html#box_collection)
* [redundant_allocation](https://rust-lang.github.io/rust-clippy/master/index.html#redundant_allocation)
* [rc_buffer](https://rust-lang.github.io/rust-clippy/master/index.html#rc_buffer)
* [vec_box](https://rust-lang.github.io/rust-clippy/master/index.html#vec_box)
* [option_option](https://rust-lang.github.io/rust-clippy/master/index.html#option_option)
* [linkedlist](https://rust-lang.github.io/rust-clippy/master/index.html#linkedlist)
* [rc_mutex](https://rust-lang.github.io/rust-clippy/master/index.html#rc_mutex)


### msrv
The minimum rust version that the project supports

**Default Value:** `None` (`Option<String>`)

* [manual_split_once](https://rust-lang.github.io/rust-clippy/master/index.html#manual_split_once)
* [manual_str_repeat](https://rust-lang.github.io/rust-clippy/master/index.html#manual_str_repeat)
* [cloned_instead_of_copied](https://rust-lang.github.io/rust-clippy/master/index.html#cloned_instead_of_copied)
* [redundant_field_names](https://rust-lang.github.io/rust-clippy/master/index.html#redundant_field_names)
* [redundant_static_lifetimes](https://rust-lang.github.io/rust-clippy/master/index.html#redundant_static_lifetimes)
* [filter_map_next](https://rust-lang.github.io/rust-clippy/master/index.html#filter_map_next)
* [checked_conversions](https://rust-lang.github.io/rust-clippy/master/index.html#checked_conversions)
* [manual_range_contains](https://rust-lang.github.io/rust-clippy/master/index.html#manual_range_contains)
* [use_self](https://rust-lang.github.io/rust-clippy/master/index.html#use_self)
* [mem_replace_with_default](https://rust-lang.github.io/rust-clippy/master/index.html#mem_replace_with_default)
* [manual_non_exhaustive](https://rust-lang.github.io/rust-clippy/master/index.html#manual_non_exhaustive)
* [option_as_ref_deref](https://rust-lang.github.io/rust-clippy/master/index.html#option_as_ref_deref)
* [map_unwrap_or](https://rust-lang.github.io/rust-clippy/master/index.html#map_unwrap_or)
* [match_like_matches_macro](https://rust-lang.github.io/rust-clippy/master/index.html#match_like_matches_macro)
* [manual_strip](https://rust-lang.github.io/rust-clippy/master/index.html#manual_strip)
* [missing_const_for_fn](https://rust-lang.github.io/rust-clippy/master/index.html#missing_const_for_fn)
* [unnested_or_patterns](https://rust-lang.github.io/rust-clippy/master/index.html#unnested_or_patterns)
* [from_over_into](https://rust-lang.github.io/rust-clippy/master/index.html#from_over_into)
* [ptr_as_ptr](https://rust-lang.github.io/rust-clippy/master/index.html#ptr_as_ptr)
* [if_then_some_else_none](https://rust-lang.github.io/rust-clippy/master/index.html#if_then_some_else_none)
* [approx_constant](https://rust-lang.github.io/rust-clippy/master/index.html#approx_constant)
* [deprecated_cfg_attr](https://rust-lang.github.io/rust-clippy/master/index.html#deprecated_cfg_attr)
* [index_refutable_slice](https://rust-lang.github.io/rust-clippy/master/index.html#index_refutable_slice)
* [map_clone](https://rust-lang.github.io/rust-clippy/master/index.html#map_clone)
* [borrow_as_ptr](https://rust-lang.github.io/rust-clippy/master/index.html#borrow_as_ptr)
* [manual_bits](https://rust-lang.github.io/rust-clippy/master/index.html#manual_bits)
* [err_expect](https://rust-lang.github.io/rust-clippy/master/index.html#err_expect)
* [cast_abs_to_unsigned](https://rust-lang.github.io/rust-clippy/master/index.html#cast_abs_to_unsigned)
* [uninlined_format_args](https://rust-lang.github.io/rust-clippy/master/index.html#uninlined_format_args)
* [manual_clamp](https://rust-lang.github.io/rust-clippy/master/index.html#manual_clamp)
* [manual_let_else](https://rust-lang.github.io/rust-clippy/master/index.html#manual_let_else)
* [unchecked_duration_subtraction](https://rust-lang.github.io/rust-clippy/master/index.html#unchecked_duration_subtraction)
* [collapsible_str_replace](https://rust-lang.github.io/rust-clippy/master/index.html#collapsible_str_replace)
* [seek_from_current](https://rust-lang.github.io/rust-clippy/master/index.html#seek_from_current)
* [seek_rewind](https://rust-lang.github.io/rust-clippy/master/index.html#seek_rewind)
* [unnecessary_lazy_evaluations](https://rust-lang.github.io/rust-clippy/master/index.html#unnecessary_lazy_evaluations)
* [transmute_ptr_to_ref](https://rust-lang.github.io/rust-clippy/master/index.html#transmute_ptr_to_ref)
* [almost_complete_range](https://rust-lang.github.io/rust-clippy/master/index.html#almost_complete_range)
* [needless_borrow](https://rust-lang.github.io/rust-clippy/master/index.html#needless_borrow)
* [derivable_impls](https://rust-lang.github.io/rust-clippy/master/index.html#derivable_impls)
* [manual_is_ascii_check](https://rust-lang.github.io/rust-clippy/master/index.html#manual_is_ascii_check)
* [manual_rem_euclid](https://rust-lang.github.io/rust-clippy/master/index.html#manual_rem_euclid)
* [manual_retain](https://rust-lang.github.io/rust-clippy/master/index.html#manual_retain)


### cognitive-complexity-threshold
The maximum cognitive complexity a function can have

**Default Value:** `25` (`u64`)

* [cognitive_complexity](https://rust-lang.github.io/rust-clippy/master/index.html#cognitive_complexity)


### disallowed-names
The list of disallowed names to lint about. NB: `bar` is not here since it has legitimate uses. The value
`".."` can be used as part of the list to indicate, that the configured values should be appended to the
default configuration of Clippy. By default any configuration will replace the default value.

**Default Value:** `["foo", "baz", "quux"]` (`Vec<String>`)

* [disallowed_names](https://rust-lang.github.io/rust-clippy/master/index.html#disallowed_names)


### doc-valid-idents
The list of words this lint should not consider as identifiers needing ticks. The value
`".."` can be used as part of the list to indicate, that the configured values should be appended to the
default configuration of Clippy. By default any configuraction will replace the default value. For example:
* `doc-valid-idents = ["ClipPy"]` would replace the default list with `["ClipPy"]`.
* `doc-valid-idents = ["ClipPy", ".."]` would append `ClipPy` to the default list.

Default list:

**Default Value:** `["KiB", "MiB", "GiB", "TiB", "PiB", "EiB", "DirectX", "ECMAScript", "GPLv2", "GPLv3", "GitHub", "GitLab", "IPv4", "IPv6", "ClojureScript", "CoffeeScript", "JavaScript", "PureScript", "TypeScript", "NaN", "NaNs", "OAuth", "GraphQL", "OCaml", "OpenGL", "OpenMP", "OpenSSH", "OpenSSL", "OpenStreetMap", "OpenDNS", "WebGL", "TensorFlow", "TrueType", "iOS", "macOS", "FreeBSD", "TeX", "LaTeX", "BibTeX", "BibLaTeX", "MinGW", "CamelCase"]` (`Vec<String>`)

* [doc_markdown](https://rust-lang.github.io/rust-clippy/master/index.html#doc_markdown)


### too-many-arguments-threshold
The maximum number of argument a function or method can have

**Default Value:** `7` (`u64`)

* [too_many_arguments](https://rust-lang.github.io/rust-clippy/master/index.html#too_many_arguments)


### type-complexity-threshold
The maximum complexity a type can have

**Default Value:** `250` (`u64`)

* [type_complexity](https://rust-lang.github.io/rust-clippy/master/index.html#type_complexity)


### single-char-binding-names-threshold
The maximum number of single char bindings a scope may have

**Default Value:** `4` (`u64`)

* [many_single_char_names](https://rust-lang.github.io/rust-clippy/master/index.html#many_single_char_names)


### too-large-for-stack
The maximum size of objects (in bytes) that will be linted. Larger objects are ok on the heap

**Default Value:** `200` (`u64`)

* [boxed_local](https://rust-lang.github.io/rust-clippy/master/index.html#boxed_local)
* [useless_vec](https://rust-lang.github.io/rust-clippy/master/index.html#useless_vec)


### enum-variant-name-threshold
The minimum number of enum variants for the lints about variant names to trigger

**Default Value:** `3` (`u64`)

* [enum_variant_names](https://rust-lang.github.io/rust-clippy/master/index.html#enum_variant_names)


### enum-variant-size-threshold
The maximum size of an enum's variant to avoid box suggestion

**Default Value:** `200` (`u64`)

* [large_enum_variant](https://rust-lang.github.io/rust-clippy/master/index.html#large_enum_variant)


### verbose-bit-mask-threshold
The maximum allowed size of a bit mask before suggesting to use 'trailing_zeros'

**Default Value:** `1` (`u64`)

* [verbose_bit_mask](https://rust-lang.github.io/rust-clippy/master/index.html#verbose_bit_mask)


### literal-representation-threshold
The lower bound for linting decimal literals

**Default Value:** `16384` (`u64`)

* [decimal_literal_representation](https://rust-lang.github.io/rust-clippy/master/index.html#decimal_literal_representation)


### trivial-copy-size-limit
The maximum size (in bytes) to consider a `Copy` type for passing by value instead of by reference.

**Default Value:** `None` (`Option<u64>`)

* [trivially_copy_pass_by_ref](https://rust-lang.github.io/rust-clippy/master/index.html#trivially_copy_pass_by_ref)


### pass-by-value-size-limit
The minimum size (in bytes) to consider a type for passing by reference instead of by value.

**Default Value:** `256` (`u64`)

* [large_types_passed_by_value](https://rust-lang.github.io/rust-clippy/master/index.html#large_types_passed_by_value)


### too-many-lines-threshold
The maximum number of lines a function or method can have

**Default Value:** `100` (`u64`)

* [too_many_lines](https://rust-lang.github.io/rust-clippy/master/index.html#too_many_lines)


### array-size-threshold
The maximum allowed size for arrays on the stack

**Default Value:** `512000` (`u64`)

* [large_stack_arrays](https://rust-lang.github.io/rust-clippy/master/index.html#large_stack_arrays)
* [large_const_arrays](https://rust-lang.github.io/rust-clippy/master/index.html#large_const_arrays)


### vec-box-size-threshold
The size of the boxed type in bytes, where boxing in a `Vec` is allowed

**Default Value:** `4096` (`u64`)

* [vec_box](https://rust-lang.github.io/rust-clippy/master/index.html#vec_box)


### max-trait-bounds
The maximum number of bounds a trait can have to be linted

**Default Value:** `3` (`u64`)

* [type_repetition_in_bounds](https://rust-lang.github.io/rust-clippy/master/index.html#type_repetition_in_bounds)


### max-struct-bools
The maximum number of bool fields a struct can have

**Default Value:** `3` (`u64`)

* [struct_excessive_bools](https://rust-lang.github.io/rust-clippy/master/index.html#struct_excessive_bools)


### max-fn-params-bools
The maximum number of bool parameters a function can have

**Default Value:** `3` (`u64`)

* [fn_params_excessive_bools](https://rust-lang.github.io/rust-clippy/master/index.html#fn_params_excessive_bools)


### warn-on-all-wildcard-imports
Whether to allow certain wildcard imports (prelude, super in tests).

**Default Value:** `false` (`bool`)

* [wildcard_imports](https://rust-lang.github.io/rust-clippy/master/index.html#wildcard_imports)


### disallowed-macros
The list of disallowed macros, written as fully qualified paths.

**Default Value:** `[]` (`Vec<crate::utils::conf::DisallowedPath>`)

* [disallowed_macros](https://rust-lang.github.io/rust-clippy/master/index.html#disallowed_macros)


### disallowed-methods
The list of disallowed methods, written as fully qualified paths.

**Default Value:** `[]` (`Vec<crate::utils::conf::DisallowedPath>`)

* [disallowed_methods](https://rust-lang.github.io/rust-clippy/master/index.html#disallowed_methods)


### disallowed-types
The list of disallowed types, written as fully qualified paths.

**Default Value:** `[]` (`Vec<crate::utils::conf::DisallowedPath>`)

* [disallowed_types](https://rust-lang.github.io/rust-clippy/master/index.html#disallowed_types)


### unreadable-literal-lint-fractions
Should the fraction of a decimal be linted to include separators.

**Default Value:** `true` (`bool`)

* [unreadable_literal](https://rust-lang.github.io/rust-clippy/master/index.html#unreadable_literal)


### upper-case-acronyms-aggressive
Enables verbose mode. Triggers if there is more than one uppercase char next to each other

**Default Value:** `false` (`bool`)

* [upper_case_acronyms](https://rust-lang.github.io/rust-clippy/master/index.html#upper_case_acronyms)


### matches-for-let-else
Whether the matches should be considered by the lint, and whether there should
be filtering for common types.

**Default Value:** `WellKnownTypes` (`crate::manual_let_else::MatchLintBehaviour`)

* [manual_let_else](https://rust-lang.github.io/rust-clippy/master/index.html#manual_let_else)


### cargo-ignore-publish
For internal testing only, ignores the current `publish` settings in the Cargo manifest.

**Default Value:** `false` (`bool`)

* [_cargo_common_metadata](https://rust-lang.github.io/rust-clippy/master/index.html#_cargo_common_metadata)


### standard-macro-braces
Enforce the named macros always use the braces specified.

A `MacroMatcher` can be added like so `{ name = "macro_name", brace = "(" }`. If the macro
is could be used with a full path two `MacroMatcher`s have to be added one with the full path
`crate_name::macro_name` and one with just the macro name.

**Default Value:** `[]` (`Vec<crate::nonstandard_macro_braces::MacroMatcher>`)

* [nonstandard_macro_braces](https://rust-lang.github.io/rust-clippy/master/index.html#nonstandard_macro_braces)


### enforced-import-renames
The list of imports to always rename, a fully qualified path followed by the rename.

**Default Value:** `[]` (`Vec<crate::utils::conf::Rename>`)

* [missing_enforced_import_renames](https://rust-lang.github.io/rust-clippy/master/index.html#missing_enforced_import_renames)


### allowed-scripts
The list of unicode scripts allowed to be used in the scope.

**Default Value:** `["Latin"]` (`Vec<String>`)

* [disallowed_script_idents](https://rust-lang.github.io/rust-clippy/master/index.html#disallowed_script_idents)


### enable-raw-pointer-heuristic-for-send
Whether to apply the raw pointer heuristic to determine if a type is `Send`.

**Default Value:** `true` (`bool`)

* [non_send_fields_in_send_ty](https://rust-lang.github.io/rust-clippy/master/index.html#non_send_fields_in_send_ty)


### max-suggested-slice-pattern-length
When Clippy suggests using a slice pattern, this is the maximum number of elements allowed in
the slice pattern that is suggested. If more elements would be necessary, the lint is suppressed.
For example, `[_, _, _, e, ..]` is a slice pattern with 4 elements.

**Default Value:** `3` (`u64`)

* [index_refutable_slice](https://rust-lang.github.io/rust-clippy/master/index.html#index_refutable_slice)


### await-holding-invalid-types


**Default Value:** `[]` (`Vec<crate::utils::conf::DisallowedPath>`)

* [await_holding_invalid_type](https://rust-lang.github.io/rust-clippy/master/index.html#await_holding_invalid_type)


### max-include-file-size
The maximum size of a file included via `include_bytes!()` or `include_str!()`, in bytes

**Default Value:** `1000000` (`u64`)

* [large_include_file](https://rust-lang.github.io/rust-clippy/master/index.html#large_include_file)


### allow-expect-in-tests
Whether `expect` should be allowed in test functions or `#[cfg(test)]`

**Default Value:** `false` (`bool`)

* [expect_used](https://rust-lang.github.io/rust-clippy/master/index.html#expect_used)


### allow-unwrap-in-tests
Whether `unwrap` should be allowed in test functions or `#[cfg(test)]`

**Default Value:** `false` (`bool`)

* [unwrap_used](https://rust-lang.github.io/rust-clippy/master/index.html#unwrap_used)


### allow-dbg-in-tests
Whether `dbg!` should be allowed in test functions or `#[cfg(test)]`

**Default Value:** `false` (`bool`)

* [dbg_macro](https://rust-lang.github.io/rust-clippy/master/index.html#dbg_macro)


### allow-print-in-tests
Whether print macros (ex. `println!`) should be allowed in test functions or `#[cfg(test)]`

**Default Value:** `false` (`bool`)

* [print_stdout](https://rust-lang.github.io/rust-clippy/master/index.html#print_stdout)
* [print_stderr](https://rust-lang.github.io/rust-clippy/master/index.html#print_stderr)


### large-error-threshold
The maximum size of the `Err`-variant in a `Result` returned from a function

**Default Value:** `128` (`u64`)

* [result_large_err](https://rust-lang.github.io/rust-clippy/master/index.html#result_large_err)


### ignore-interior-mutability
A list of paths to types that should be treated like `Arc`, i.e. ignored but
for the generic parameters for determining interior mutability

**Default Value:** `["bytes::Bytes"]` (`Vec<String>`)

* [mutable_key_type](https://rust-lang.github.io/rust-clippy/master/index.html#mutable_key_type)


### allow-mixed-uninlined-format-args
Whether to allow mixed uninlined format args, e.g. `format!("{} {}", a, foo.bar)`

**Default Value:** `true` (`bool`)

* [uninlined_format_args](https://rust-lang.github.io/rust-clippy/master/index.html#uninlined_format_args)


### suppress-restriction-lint-in-const
Whether to suppress a restriction lint in constant code. In same
cases the restructured operation might not be unavoidable, as the
suggested counterparts are unavailable in constant code. This
configuration will cause restriction lints to trigger even
if no suggestion can be made.

**Default Value:** `false` (`bool`)

* [indexing_slicing](https://rust-lang.github.io/rust-clippy/master/index.html#indexing_slicing)


### missing-docs-in-crate-items
Whether to **only** check for missing documentation in items visible within the current
crate. For example, `pub(crate)` items.

**Default Value:** `false` (`bool`)

* [missing_docs_in_private_items](https://rust-lang.github.io/rust-clippy/master/index.html#missing_docs_in_private_items)



