/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.selector;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Hierarchy;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.IntializationUtil;
import org.apache.log4j.helpers.JNDIUtil;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.RepositorySelector;
import org.apache.log4j.spi.RootLogger;

public class ContextJNDISelector
implements RepositorySelector {
    static String JNDI_CONFIGURATION_RESOURCE = "java:comp/env/log4j/configuration-resource";
    static String JNDI_CONFIGURATOR_CLASS = "java:comp/env/log4j/configurator-class";
    private final Map hierMap = Collections.synchronizedMap(new HashMap());

    public LoggerRepository getLoggerRepository() {
        String loggingContextName = null;
        Context ctx = null;
        try {
            ctx = JNDIUtil.getInitialContext();
            loggingContextName = JNDIUtil.lookup(ctx, "java:comp/env/log4j/context-name");
        }
        catch (NamingException ne) {
            // empty catch block
        }
        if (loggingContextName == null || "default".equals(loggingContextName)) {
            return LogManager.defaultLoggerRepository;
        }
        Hierarchy hierarchy = (Hierarchy)this.hierMap.get(loggingContextName);
        if (hierarchy == null) {
            hierarchy = new Hierarchy(new RootLogger(Level.DEBUG));
            hierarchy.setName(loggingContextName);
            this.hierMap.put(loggingContextName, hierarchy);
            IntializationUtil.log4jInternalConfiguration(hierarchy);
            String configResourceStr = JNDIUtil.lookup(ctx, JNDI_CONFIGURATION_RESOURCE);
            if (configResourceStr != null) {
                String configuratorClassName = JNDIUtil.lookup(ctx, JNDI_CONFIGURATOR_CLASS);
                IntializationUtil.initialConfiguration(hierarchy, configResourceStr, configuratorClassName);
            }
        }
        return hierarchy;
    }

    public LoggerRepository getLoggerRepository(String name) {
        if ("default".equals(name)) {
            return LogManager.defaultLoggerRepository;
        }
        return (LoggerRepository)this.hierMap.get(name);
    }

    public LoggerRepository detachRepository(String contextName) {
        return (LoggerRepository)this.hierMap.remove(contextName);
    }
}

