; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-linux-gnu -mcpu=core2 | FileCheck %s -check-prefix=LINUX
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=core2 | FileCheck %s -check-prefix=DARWIN

declare void @llvm.memcpy.p0i8.p0i8.i64(i8* nocapture, i8* nocapture, i64, i1) nounwind
declare void @llvm.memcpy.p256i8.p256i8.i64(i8 addrspace(256)* nocapture, i8 addrspace(256)* nocapture, i64, i1) nounwind


; Variable memcpy's should lower to calls.
define i8* @test1(i8* %a, i8* %b, i64 %n) nounwind {
; LINUX-LABEL: test1:
; LINUX:       # %bb.0: # %entry
; LINUX-NEXT:    jmp memcpy # TAILCALL
;
; DARWIN-LABEL: test1:
; DARWIN:       ## %bb.0: ## %entry
; DARWIN-NEXT:    jmp _memcpy ## TAILCALL
entry:
	tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* %a, i8* %b, i64 %n, i1 0 )
	ret i8* %a
}

; Variable memcpy's should lower to calls.
define i8* @test2(i64* %a, i64* %b, i64 %n) nounwind {
; LINUX-LABEL: test2:
; LINUX:       # %bb.0: # %entry
; LINUX-NEXT:    jmp memcpy # TAILCALL
;
; DARWIN-LABEL: test2:
; DARWIN:       ## %bb.0: ## %entry
; DARWIN-NEXT:    jmp _memcpy ## TAILCALL
entry:
	%tmp14 = bitcast i64* %a to i8*
	%tmp25 = bitcast i64* %b to i8*
	tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* align 8 %tmp14, i8* align 8 %tmp25, i64 %n, i1 0 )
	ret i8* %tmp14
}

; Large constant memcpy's should lower to a call when optimizing for size.
; PR6623

; On the other hand, Darwin's definition of -Os is optimizing for size without
; hurting performance so it should just ignore optsize when expanding memcpy.
; rdar://8821501
define void @test3(i8* nocapture %A, i8* nocapture %B) nounwind optsize noredzone {
; LINUX-LABEL: test3:
; LINUX:       # %bb.0: # %entry
; LINUX-NEXT:    movl $64, %edx
; LINUX-NEXT:    jmp memcpy # TAILCALL
;
; DARWIN-LABEL: test3:
; DARWIN:       ## %bb.0: ## %entry
; DARWIN-NEXT:    movq 56(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 56(%rdi)
; DARWIN-NEXT:    movq 48(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 48(%rdi)
; DARWIN-NEXT:    movq 40(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 40(%rdi)
; DARWIN-NEXT:    movq 32(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 32(%rdi)
; DARWIN-NEXT:    movq 24(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 24(%rdi)
; DARWIN-NEXT:    movq 16(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 16(%rdi)
; DARWIN-NEXT:    movq (%rsi), %rax
; DARWIN-NEXT:    movq 8(%rsi), %rcx
; DARWIN-NEXT:    movq %rcx, 8(%rdi)
; DARWIN-NEXT:    movq %rax, (%rdi)
; DARWIN-NEXT:    retq
entry:
  tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* %A, i8* %B, i64 64, i1 false)
  ret void
}

define void @test3_minsize(i8* nocapture %A, i8* nocapture %B) nounwind minsize noredzone {
; LINUX-LABEL: test3_minsize:
; LINUX:       # %bb.0:
; LINUX-NEXT:    pushq $64
; LINUX-NEXT:    popq %rdx
; LINUX-NEXT:    jmp memcpy # TAILCALL
;
; DARWIN-LABEL: test3_minsize:
; DARWIN:       ## %bb.0:
; DARWIN-NEXT:    pushq $64
; DARWIN-NEXT:    popq %rdx
; DARWIN-NEXT:    jmp _memcpy ## TAILCALL
  tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* %A, i8* %B, i64 64, i1 false)
  ret void
}

define void @test3_minsize_optsize(i8* nocapture %A, i8* nocapture %B) nounwind optsize minsize noredzone {
; LINUX-LABEL: test3_minsize_optsize:
; LINUX:       # %bb.0:
; LINUX-NEXT:    pushq $64
; LINUX-NEXT:    popq %rdx
; LINUX-NEXT:    jmp memcpy # TAILCALL
;
; DARWIN-LABEL: test3_minsize_optsize:
; DARWIN:       ## %bb.0:
; DARWIN-NEXT:    pushq $64
; DARWIN-NEXT:    popq %rdx
; DARWIN-NEXT:    jmp _memcpy ## TAILCALL
  tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* %A, i8* %B, i64 64, i1 false)
  ret void
}

; Large constant memcpy's should be inlined when not optimizing for size.
define void @test4(i8* nocapture %A, i8* nocapture %B) nounwind noredzone {
; LINUX-LABEL: test4:
; LINUX:       # %bb.0: # %entry
; LINUX-NEXT:    movq 56(%rsi), %rax
; LINUX-NEXT:    movq %rax, 56(%rdi)
; LINUX-NEXT:    movq 48(%rsi), %rax
; LINUX-NEXT:    movq %rax, 48(%rdi)
; LINUX-NEXT:    movq 40(%rsi), %rax
; LINUX-NEXT:    movq %rax, 40(%rdi)
; LINUX-NEXT:    movq 32(%rsi), %rax
; LINUX-NEXT:    movq %rax, 32(%rdi)
; LINUX-NEXT:    movq 24(%rsi), %rax
; LINUX-NEXT:    movq %rax, 24(%rdi)
; LINUX-NEXT:    movq 16(%rsi), %rax
; LINUX-NEXT:    movq %rax, 16(%rdi)
; LINUX-NEXT:    movq (%rsi), %rax
; LINUX-NEXT:    movq 8(%rsi), %rcx
; LINUX-NEXT:    movq %rcx, 8(%rdi)
; LINUX-NEXT:    movq %rax, (%rdi)
; LINUX-NEXT:    retq
;
; DARWIN-LABEL: test4:
; DARWIN:       ## %bb.0: ## %entry
; DARWIN-NEXT:    movq 56(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 56(%rdi)
; DARWIN-NEXT:    movq 48(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 48(%rdi)
; DARWIN-NEXT:    movq 40(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 40(%rdi)
; DARWIN-NEXT:    movq 32(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 32(%rdi)
; DARWIN-NEXT:    movq 24(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 24(%rdi)
; DARWIN-NEXT:    movq 16(%rsi), %rax
; DARWIN-NEXT:    movq %rax, 16(%rdi)
; DARWIN-NEXT:    movq (%rsi), %rax
; DARWIN-NEXT:    movq 8(%rsi), %rcx
; DARWIN-NEXT:    movq %rcx, 8(%rdi)
; DARWIN-NEXT:    movq %rax, (%rdi)
; DARWIN-NEXT:    retq
entry:
  tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* %A, i8* %B, i64 64, i1 false)
  ret void
}


@.str = private unnamed_addr constant [30 x i8] c"\00aaaaaaaaaaaaaaaaaaaaaaaaaaaa\00", align 1

define void @test5(i8* nocapture %C) nounwind uwtable ssp {
; LINUX-LABEL: test5:
; LINUX:       # %bb.0: # %entry
; LINUX-NEXT:    movabsq $7016996765293437281, %rax # imm = 0x6161616161616161
; LINUX-NEXT:    movq %rax, 8(%rdi)
; LINUX-NEXT:    movabsq $7016996765293437184, %rax # imm = 0x6161616161616100
; LINUX-NEXT:    movq %rax, (%rdi)
; LINUX-NEXT:    retq
;
; DARWIN-LABEL: test5:
; DARWIN:       ## %bb.0: ## %entry
; DARWIN-NEXT:    movabsq $7016996765293437281, %rax ## imm = 0x6161616161616161
; DARWIN-NEXT:    movq %rax, 8(%rdi)
; DARWIN-NEXT:    movabsq $7016996765293437184, %rax ## imm = 0x6161616161616100
; DARWIN-NEXT:    movq %rax, (%rdi)
; DARWIN-NEXT:    retq
entry:
  tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* %C, i8* getelementptr inbounds ([30 x i8], [30 x i8]* @.str, i64 0, i64 0), i64 16, i1 false)
  ret void
}


; PR14896
@.str2 = private unnamed_addr constant [2 x i8] c"x\00", align 1

define void @test6() nounwind uwtable {
; LINUX-LABEL: test6:
; LINUX:       # %bb.0: # %entry
; LINUX-NEXT:    movw $0, 8
; LINUX-NEXT:    movq $120, 0
; LINUX-NEXT:    retq
;
; DARWIN-LABEL: test6:
; DARWIN:       ## %bb.0: ## %entry
; DARWIN-NEXT:    movw $0, 8
; DARWIN-NEXT:    movq $120, 0
; DARWIN-NEXT:    retq
entry:
  tail call void @llvm.memcpy.p0i8.p0i8.i64(i8* null, i8* getelementptr inbounds ([2 x i8], [2 x i8]* @.str2, i64 0, i64 0), i64 10, i1 false)
  ret void
}

define void @PR15348(i8* %a, i8* %b) {
; Ensure that alignment of '0' in an @llvm.memcpy intrinsic results in
; unaligned loads and stores.
; LINUX-LABEL: PR15348:
; LINUX:       # %bb.0:
; LINUX-NEXT:    movb 16(%rsi), %al
; LINUX-NEXT:    movb %al, 16(%rdi)
; LINUX-NEXT:    movq (%rsi), %rax
; LINUX-NEXT:    movq 8(%rsi), %rcx
; LINUX-NEXT:    movq %rcx, 8(%rdi)
; LINUX-NEXT:    movq %rax, (%rdi)
; LINUX-NEXT:    retq
;
; DARWIN-LABEL: PR15348:
; DARWIN:       ## %bb.0:
; DARWIN-NEXT:    movb 16(%rsi), %al
; DARWIN-NEXT:    movb %al, 16(%rdi)
; DARWIN-NEXT:    movq (%rsi), %rax
; DARWIN-NEXT:    movq 8(%rsi), %rcx
; DARWIN-NEXT:    movq %rcx, 8(%rdi)
; DARWIN-NEXT:    movq %rax, (%rdi)
; DARWIN-NEXT:    retq
  call void @llvm.memcpy.p0i8.p0i8.i64(i8* %a, i8* %b, i64 17, i1 false)
  ret void
}

; Memcpys from / to address space 256 should be lowered to appropriate loads /
; stores if small enough.
define void @addrspace256(i8 addrspace(256)* %a, i8 addrspace(256)* %b) nounwind {
; LINUX-LABEL: addrspace256:
; LINUX:       # %bb.0:
; LINUX-NEXT:    movq %gs:(%rsi), %rax
; LINUX-NEXT:    movq %gs:8(%rsi), %rcx
; LINUX-NEXT:    movq %rcx, %gs:8(%rdi)
; LINUX-NEXT:    movq %rax, %gs:(%rdi)
; LINUX-NEXT:    retq
;
; DARWIN-LABEL: addrspace256:
; DARWIN:       ## %bb.0:
; DARWIN-NEXT:    movq %gs:(%rsi), %rax
; DARWIN-NEXT:    movq %gs:8(%rsi), %rcx
; DARWIN-NEXT:    movq %rcx, %gs:8(%rdi)
; DARWIN-NEXT:    movq %rax, %gs:(%rdi)
; DARWIN-NEXT:    retq
  tail call void @llvm.memcpy.p256i8.p256i8.i64(i8 addrspace(256)* align 8 %a, i8 addrspace(256)* align 8 %b, i64 16, i1 false)
  ret void
}
