; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s --mattr=+sve2 -o - | FileCheck %s

target triple = "aarch64-arm-none-eabi"

; Expected to not transform as the type's minimum size is less than 128 bits.
define <vscale x 4 x i16> @complex_add_v4i16(<vscale x 4 x i16> %a, <vscale x 4 x i16> %b) {
; CHECK-LABEL: complex_add_v4i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    uunpkhi z2.d, z0.s
; CHECK-NEXT:    uunpklo z0.d, z0.s
; CHECK-NEXT:    uunpkhi z3.d, z1.s
; CHECK-NEXT:    uunpklo z1.d, z1.s
; CHECK-NEXT:    uzp1 z4.d, z0.d, z2.d
; CHECK-NEXT:    uzp2 z0.d, z0.d, z2.d
; CHECK-NEXT:    uzp2 z2.d, z1.d, z3.d
; CHECK-NEXT:    uzp1 z1.d, z1.d, z3.d
; CHECK-NEXT:    sub z0.d, z1.d, z0.d
; CHECK-NEXT:    add z1.d, z2.d, z4.d
; CHECK-NEXT:    zip2 z2.d, z0.d, z1.d
; CHECK-NEXT:    zip1 z0.d, z0.d, z1.d
; CHECK-NEXT:    uzp1 z0.s, z0.s, z2.s
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 2 x i16>, <vscale x 2 x i16> } @llvm.experimental.vector.deinterleave2.nxv4i16(<vscale x 4 x i16> %a)
  %a.real = extractvalue { <vscale x 2 x i16>, <vscale x 2 x i16> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 2 x i16>, <vscale x 2 x i16> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 2 x i16>, <vscale x 2 x i16> } @llvm.experimental.vector.deinterleave2.nxv4i16(<vscale x 4 x i16> %b)
  %b.real = extractvalue { <vscale x 2 x i16>, <vscale x 2 x i16> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 2 x i16>, <vscale x 2 x i16> } %b.deinterleaved, 1
  %0 = sub <vscale x 2 x i16> %b.real, %a.imag
  %1 = add <vscale x 2 x i16> %b.imag, %a.real
  %interleaved.vec = tail call <vscale x 4 x i16> @llvm.experimental.vector.interleave2.nxv4i16(<vscale x 2 x i16> %0, <vscale x 2 x i16> %1)
  ret <vscale x 4 x i16> %interleaved.vec
}

; Expected to transform
define <vscale x 8 x i16> @complex_add_v8i16(<vscale x 8 x i16> %a, <vscale x 8 x i16> %b) {
; CHECK-LABEL: complex_add_v8i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cadd z1.h, z1.h, z0.h, #90
; CHECK-NEXT:    mov z0.d, z1.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 4 x i16>, <vscale x 4 x i16> } @llvm.experimental.vector.deinterleave2.nxv8i16(<vscale x 8 x i16> %a)
  %a.real = extractvalue { <vscale x 4 x i16>, <vscale x 4 x i16> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 4 x i16>, <vscale x 4 x i16> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 4 x i16>, <vscale x 4 x i16> } @llvm.experimental.vector.deinterleave2.nxv8i16(<vscale x 8 x i16> %b)
  %b.real = extractvalue { <vscale x 4 x i16>, <vscale x 4 x i16> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 4 x i16>, <vscale x 4 x i16> } %b.deinterleaved, 1
  %0 = sub <vscale x 4 x i16> %b.real, %a.imag
  %1 = add <vscale x 4 x i16> %b.imag, %a.real
  %interleaved.vec = tail call <vscale x 8 x i16> @llvm.experimental.vector.interleave2.nxv8i16(<vscale x 4 x i16> %0, <vscale x 4 x i16> %1)
  ret <vscale x 8 x i16> %interleaved.vec
}

; Expected to transform
define <vscale x 16 x i16> @complex_add_v16i16(<vscale x 16 x i16> %a, <vscale x 16 x i16> %b) {
; CHECK-LABEL: complex_add_v16i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cadd z2.h, z2.h, z0.h, #90
; CHECK-NEXT:    cadd z3.h, z3.h, z1.h, #90
; CHECK-NEXT:    mov z0.d, z2.d
; CHECK-NEXT:    mov z1.d, z3.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.experimental.vector.deinterleave2.nxv16i16(<vscale x 16 x i16> %a)
  %a.real = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.experimental.vector.deinterleave2.nxv16i16(<vscale x 16 x i16> %b)
  %b.real = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 8 x i16>, <vscale x 8 x i16> } %b.deinterleaved, 1
  %0 = sub <vscale x 8 x i16> %b.real, %a.imag
  %1 = add <vscale x 8 x i16> %b.imag, %a.real
  %interleaved.vec = tail call <vscale x 16 x i16> @llvm.experimental.vector.interleave2.nxv16i16(<vscale x 8 x i16> %0, <vscale x 8 x i16> %1)
  ret <vscale x 16 x i16> %interleaved.vec
}

; Expected to transform
define <vscale x 32 x i16> @complex_add_v32i16(<vscale x 32 x i16> %a, <vscale x 32 x i16> %b) {
; CHECK-LABEL: complex_add_v32i16:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cadd z6.h, z6.h, z2.h, #90
; CHECK-NEXT:    cadd z4.h, z4.h, z0.h, #90
; CHECK-NEXT:    cadd z5.h, z5.h, z1.h, #90
; CHECK-NEXT:    cadd z7.h, z7.h, z3.h, #90
; CHECK-NEXT:    mov z0.d, z4.d
; CHECK-NEXT:    mov z1.d, z5.d
; CHECK-NEXT:    mov z2.d, z6.d
; CHECK-NEXT:    mov z3.d, z7.d
; CHECK-NEXT:    ret
entry:
  %a.deinterleaved = tail call { <vscale x 16 x i16>, <vscale x 16 x i16> } @llvm.experimental.vector.deinterleave2.nxv32i16(<vscale x 32 x i16> %a)
  %a.real = extractvalue { <vscale x 16 x i16>, <vscale x 16 x i16> } %a.deinterleaved, 0
  %a.imag = extractvalue { <vscale x 16 x i16>, <vscale x 16 x i16> } %a.deinterleaved, 1
  %b.deinterleaved = tail call { <vscale x 16 x i16>, <vscale x 16 x i16> } @llvm.experimental.vector.deinterleave2.nxv32i16(<vscale x 32 x i16> %b)
  %b.real = extractvalue { <vscale x 16 x i16>, <vscale x 16 x i16> } %b.deinterleaved, 0
  %b.imag = extractvalue { <vscale x 16 x i16>, <vscale x 16 x i16> } %b.deinterleaved, 1
  %0 = sub <vscale x 16 x i16> %b.real, %a.imag
  %1 = add <vscale x 16 x i16> %b.imag, %a.real
  %interleaved.vec = tail call <vscale x 32 x i16> @llvm.experimental.vector.interleave2.nxv32i16(<vscale x 16 x i16> %0, <vscale x 16 x i16> %1)
  ret <vscale x 32 x i16> %interleaved.vec
}

declare { <vscale x 2 x i16>, <vscale x 2 x i16> } @llvm.experimental.vector.deinterleave2.nxv4i16(<vscale x 4 x i16>)
declare <vscale x 4 x i16> @llvm.experimental.vector.interleave2.nxv4i16(<vscale x 2 x i16>, <vscale x 2 x i16>)

declare { <vscale x 4 x i16>, <vscale x 4 x i16> } @llvm.experimental.vector.deinterleave2.nxv8i16(<vscale x 8 x i16>)
declare <vscale x 8 x i16> @llvm.experimental.vector.interleave2.nxv8i16(<vscale x 4 x i16>, <vscale x 4 x i16>)

declare { <vscale x 8 x i16>, <vscale x 8 x i16> } @llvm.experimental.vector.deinterleave2.nxv16i16(<vscale x 16 x i16>)
declare <vscale x 16 x i16> @llvm.experimental.vector.interleave2.nxv16i16(<vscale x 8 x i16>, <vscale x 8 x i16>)

declare { <vscale x 16 x i16>, <vscale x 16 x i16> } @llvm.experimental.vector.deinterleave2.nxv32i16(<vscale x 32 x i16>)
declare <vscale x 32 x i16> @llvm.experimental.vector.interleave2.nxv32i16(<vscale x 16 x i16>, <vscale x 16 x i16>)
