/*
 * Decompiled with CFR 0.152.
 */
package com.clarkware.junitperf;

import junit.framework.TestCase;

public class MockTest
extends TestCase {
    public MockTest(String name) {
        super(name);
    }

    public void testSuccess() {
    }

    public void testFailure() {
        MockTest.fail();
    }

    public void testError() {
        throw new RuntimeException();
    }

    public void testOneSecondExecutionTime() throws Exception {
        Thread.sleep(1000L);
    }

    public void testOneSecondExecutionTimeWithFailure() throws Exception {
        Thread.sleep(1000L);
        MockTest.fail();
    }

    public void testInfiniteExecutionTime() {
        while (true) {
            // Infinite loop
        }
    }

    public void testLongExecutionTime() {
        try {
            Thread.sleep(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void testAtomic2SecondResponseWithWorkerThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void testNonAtomic2SecondResponseWithWorkerThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        t.start();
        try {
            Thread.sleep(1000L);
            t.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void testRogueThread() {
        Thread t = new Thread(new Runnable(){

            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(100L);
                        }
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        });
        t.start();
        MockTest.assertTrue((boolean)true);
    }
}

