# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    import __init__ as _models


class BestPractice(msrest.serialization.Model):
    """Definition of the Automanage best practice.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The fully qualified ID for the best practice.  For example,
     /providers/Microsoft.Automanage/bestPractices/azureBestPracticesProduction.
    :vartype id: str
    :ivar type: The type of the resource.  For example, Microsoft.Automanage/bestPractices.
    :vartype type: str
    :ivar name: The name of the best practice. For example, azureBestPracticesProduction.
    :vartype name: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.automanage.models.SystemData
    :ivar configuration: configuration dictionary of the configuration profile.
    :vartype configuration: any
    """

    _validation = {
        'id': {'readonly': True},
        'type': {'readonly': True},
        'name': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'configuration': {'key': 'properties.configuration', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        configuration: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword configuration: configuration dictionary of the configuration profile.
        :paramtype configuration: any
        """
        super(BestPractice, self).__init__(**kwargs)
        self.id = None
        self.type = None
        self.name = None
        self.system_data = None
        self.configuration = configuration


class BestPracticeList(msrest.serialization.Model):
    """The response of the list best practice operation.

    :ivar value: Result of the list best practice operation.
    :vartype value: list[~azure.mgmt.automanage.models.BestPractice]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[BestPractice]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.BestPractice"]] = None,
        **kwargs
    ):
        """
        :keyword value: Result of the list best practice operation.
        :paramtype value: list[~azure.mgmt.automanage.models.BestPractice]
        """
        super(BestPracticeList, self).__init__(**kwargs)
        self.value = value


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        """
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class ConfigurationProfile(TrackedResource):
    """Definition of the configuration profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: Required. The geo-location where the resource lives.
    :vartype location: str
    :ivar properties: Properties of the configuration profile.
    :vartype properties: ~azure.mgmt.automanage.models.ConfigurationProfileProperties
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.automanage.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ConfigurationProfileProperties'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ConfigurationProfileProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: Required. The geo-location where the resource lives.
        :paramtype location: str
        :keyword properties: Properties of the configuration profile.
        :paramtype properties: ~azure.mgmt.automanage.models.ConfigurationProfileProperties
        """
        super(ConfigurationProfile, self).__init__(tags=tags, location=location, **kwargs)
        self.properties = properties
        self.system_data = None


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ProxyResource, self).__init__(**kwargs)


class ConfigurationProfileAssignment(ProxyResource):
    """Configuration profile assignment is an association between a VM and automanage profile configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar properties: Properties of the configuration profile assignment.
    :vartype properties: ~azure.mgmt.automanage.models.ConfigurationProfileAssignmentProperties
    :ivar managed_by: Azure resource id. Indicates if this resource is managed by another Azure
     resource.
    :vartype managed_by: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.automanage.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'managed_by': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'ConfigurationProfileAssignmentProperties'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(
        self,
        *,
        properties: Optional["_models.ConfigurationProfileAssignmentProperties"] = None,
        **kwargs
    ):
        """
        :keyword properties: Properties of the configuration profile assignment.
        :paramtype properties: ~azure.mgmt.automanage.models.ConfigurationProfileAssignmentProperties
        """
        super(ConfigurationProfileAssignment, self).__init__(**kwargs)
        self.properties = properties
        self.managed_by = None
        self.system_data = None


class ConfigurationProfileAssignmentList(msrest.serialization.Model):
    """The response of the list configuration profile assignment operation.

    :ivar value: Result of the list configuration profile assignment operation.
    :vartype value: list[~azure.mgmt.automanage.models.ConfigurationProfileAssignment]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConfigurationProfileAssignment]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConfigurationProfileAssignment"]] = None,
        **kwargs
    ):
        """
        :keyword value: Result of the list configuration profile assignment operation.
        :paramtype value: list[~azure.mgmt.automanage.models.ConfigurationProfileAssignment]
        """
        super(ConfigurationProfileAssignmentList, self).__init__(**kwargs)
        self.value = value


class ConfigurationProfileAssignmentProperties(msrest.serialization.Model):
    """Automanage configuration profile assignment properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar configuration_profile: The Automanage configurationProfile ARM Resource URI.
    :vartype configuration_profile: str
    :ivar target_id: The target VM resource URI.
    :vartype target_id: str
    :ivar status: The status of onboarding, which only appears in the response.
    :vartype status: str
    """

    _validation = {
        'target_id': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'configuration_profile': {'key': 'configurationProfile', 'type': 'str'},
        'target_id': {'key': 'targetId', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        configuration_profile: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword configuration_profile: The Automanage configurationProfile ARM Resource URI.
        :paramtype configuration_profile: str
        """
        super(ConfigurationProfileAssignmentProperties, self).__init__(**kwargs)
        self.configuration_profile = configuration_profile
        self.target_id = None
        self.status = None


class ConfigurationProfileList(msrest.serialization.Model):
    """The response of the list configuration profile operation.

    :ivar value: Result of the list ConfigurationProfile operation.
    :vartype value: list[~azure.mgmt.automanage.models.ConfigurationProfile]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ConfigurationProfile]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConfigurationProfile"]] = None,
        **kwargs
    ):
        """
        :keyword value: Result of the list ConfigurationProfile operation.
        :paramtype value: list[~azure.mgmt.automanage.models.ConfigurationProfile]
        """
        super(ConfigurationProfileList, self).__init__(**kwargs)
        self.value = value


class ConfigurationProfileProperties(msrest.serialization.Model):
    """Automanage configuration profile properties.

    :ivar configuration: configuration dictionary of the configuration profile.
    :vartype configuration: any
    """

    _attribute_map = {
        'configuration': {'key': 'configuration', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        configuration: Optional[Any] = None,
        **kwargs
    ):
        """
        :keyword configuration: configuration dictionary of the configuration profile.
        :paramtype configuration: any
        """
        super(ConfigurationProfileProperties, self).__init__(**kwargs)
        self.configuration = configuration


class UpdateResource(msrest.serialization.Model):
    """Represents an update resource.

    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The tags of the resource.
        :paramtype tags: dict[str, str]
        """
        super(UpdateResource, self).__init__(**kwargs)
        self.tags = tags


class ConfigurationProfileUpdate(UpdateResource):
    """Definition of the configuration profile.

    :ivar tags: A set of tags. The tags of the resource.
    :vartype tags: dict[str, str]
    :ivar properties: Properties of the configuration profile.
    :vartype properties: ~azure.mgmt.automanage.models.ConfigurationProfileProperties
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'ConfigurationProfileProperties'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.ConfigurationProfileProperties"] = None,
        **kwargs
    ):
        """
        :keyword tags: A set of tags. The tags of the resource.
        :paramtype tags: dict[str, str]
        :keyword properties: Properties of the configuration profile.
        :paramtype properties: ~azure.mgmt.automanage.models.ConfigurationProfileProperties
        """
        super(ConfigurationProfileUpdate, self).__init__(tags=tags, **kwargs)
        self.properties = properties


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.automanage.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.automanage.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.automanage.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs
    ):
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.automanage.models.ErrorDetail
        """
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class Operation(msrest.serialization.Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for ARM/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.automanage.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     "user,system".
    :vartype origin: str or ~azure.mgmt.automanage.models.Origin
    :ivar action_type: Enum. Indicates the action type. "Internal" refers to actions that are for
     internal only APIs. Known values are: "Internal".
    :vartype action_type: str or ~azure.mgmt.automanage.models.ActionType
    """

    _validation = {
        'name': {'readonly': True},
        'is_data_action': {'readonly': True},
        'origin': {'readonly': True},
        'action_type': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
        'origin': {'key': 'origin', 'type': 'str'},
        'action_type': {'key': 'actionType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
        **kwargs
    ):
        """
        :keyword display: Localized display information for this particular operation.
        :paramtype display: ~azure.mgmt.automanage.models.OperationDisplay
        """
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.is_data_action = None
        self.display = display
        self.origin = None
        self.action_type = None


class OperationDisplay(msrest.serialization.Model):
    """Localized display information for this particular operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
        'description': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None
        self.description = None


class OperationListResult(msrest.serialization.Model):
    """A list of REST API operations supported by an Azure Resource Provider. It contains an URL link to get the next set of results.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations supported by the resource provider.
    :vartype value: list[~azure.mgmt.automanage.models.Operation]
    :ivar next_link: URL to get the next set of operation list results (if there are any).
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(OperationListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class Report(ProxyResource):
    """Definition of the report.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.automanage.models.SystemData
    :ivar start_time: Start time of the configuration profile assignment processing.
    :vartype start_time: str
    :ivar end_time: End time of the configuration profile assignment processing.
    :vartype end_time: str
    :ivar last_modified_time: Last modified time of the configuration profile assignment
     processing.
    :vartype last_modified_time: str
    :ivar duration: Duration of the configuration profile assignment processing.
    :vartype duration: str
    :ivar type_properties_type: Type of the configuration profile assignment processing
     (Initial/Consistency).
    :vartype type_properties_type: str
    :ivar status: The status of the configuration profile assignment.
    :vartype status: str
    :ivar configuration_profile: The configurationProfile linked to the assignment.
    :vartype configuration_profile: str
    :ivar resources: List of resources processed by the configuration profile assignment.
    :vartype resources: list[~azure.mgmt.automanage.models.ReportResource]
    :ivar error: Error message, if any, returned by the configuration profile assignment
     processing.
    :vartype error: ~azure.mgmt.automanage.models.ErrorDetail
    :ivar report_format_version: Version of the report format.
    :vartype report_format_version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'last_modified_time': {'readonly': True},
        'duration': {'readonly': True},
        'type_properties_type': {'readonly': True},
        'status': {'readonly': True},
        'configuration_profile': {'readonly': True},
        'resources': {'readonly': True},
        'error': {'readonly': True},
        'report_format_version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'start_time': {'key': 'properties.startTime', 'type': 'str'},
        'end_time': {'key': 'properties.endTime', 'type': 'str'},
        'last_modified_time': {'key': 'properties.lastModifiedTime', 'type': 'str'},
        'duration': {'key': 'properties.duration', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'configuration_profile': {'key': 'properties.configurationProfile', 'type': 'str'},
        'resources': {'key': 'properties.resources', 'type': '[ReportResource]'},
        'error': {'key': 'properties.error', 'type': 'ErrorDetail'},
        'report_format_version': {'key': 'properties.reportFormatVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_time: Optional[str] = None,
        end_time: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword start_time: Start time of the configuration profile assignment processing.
        :paramtype start_time: str
        :keyword end_time: End time of the configuration profile assignment processing.
        :paramtype end_time: str
        """
        super(Report, self).__init__(**kwargs)
        self.system_data = None
        self.start_time = start_time
        self.end_time = end_time
        self.last_modified_time = None
        self.duration = None
        self.type_properties_type = None
        self.status = None
        self.configuration_profile = None
        self.resources = None
        self.error = None
        self.report_format_version = None


class ReportList(msrest.serialization.Model):
    """The response of the list report operation.

    :ivar value: Result of the list report operation.
    :vartype value: list[~azure.mgmt.automanage.models.Report]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Report]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.Report"]] = None,
        **kwargs
    ):
        """
        :keyword value: Result of the list report operation.
        :paramtype value: list[~azure.mgmt.automanage.models.Report]
        """
        super(ReportList, self).__init__(**kwargs)
        self.value = value


class ReportResource(msrest.serialization.Model):
    """Details about the resource processed by the configuration profile assignment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the resource.
    :vartype name: str
    :ivar id: ARM id of the resource.
    :vartype id: str
    :ivar type: Type of the resource.
    :vartype type: str
    :ivar status: Status of the resource.
    :vartype status: str
    :ivar error: Error message, if any, returned when deploying the resource.
    :vartype error: ~azure.mgmt.automanage.models.ErrorDetail
    """

    _validation = {
        'name': {'readonly': True},
        'id': {'readonly': True},
        'type': {'readonly': True},
        'status': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ReportResource, self).__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.status = None
        self.error = None


class ServicePrincipal(ProxyResource):
    """The Service Principal Id for the subscription.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.automanage.models.SystemData
    :ivar service_principal_id: The Service Principal Id for the subscription.
    :vartype service_principal_id: str
    :ivar authorization_set: Returns the contributor RBAC Role exist or not for the Service
     Principal Id.
    :vartype authorization_set: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'service_principal_id': {'readonly': True},
        'authorization_set': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'service_principal_id': {'key': 'properties.servicePrincipalId', 'type': 'str'},
        'authorization_set': {'key': 'properties.authorizationSet', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        """
        """
        super(ServicePrincipal, self).__init__(**kwargs)
        self.system_data = None
        self.service_principal_id = None
        self.authorization_set = None


class ServicePrincipalListResult(msrest.serialization.Model):
    """The list of ServicePrincipals.

    :ivar value: The list of servicePrincipals.
    :vartype value: list[~azure.mgmt.automanage.models.ServicePrincipal]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ServicePrincipal]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ServicePrincipal"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of servicePrincipals.
        :paramtype value: list[~azure.mgmt.automanage.models.ServicePrincipal]
        """
        super(ServicePrincipalListResult, self).__init__(**kwargs)
        self.value = value


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", "Key".
    :vartype created_by_type: str or ~azure.mgmt.automanage.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.automanage.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", "Key".
        :paramtype created_by_type: str or ~azure.mgmt.automanage.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.automanage.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
