# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import datetime
from io import IOBase
import sys
from typing import Any, AsyncIterable, Callable, Dict, IO, Optional, TypeVar, Union, cast, overload
import urllib.parse

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    ResourceNotModifiedError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async
from azure.core.utils import case_insensitive_dict

from ...operations._operations import (
    build_job_router_accept_job_action_request,
    build_job_router_administration_delete_classification_policy_request,
    build_job_router_administration_delete_distribution_policy_request,
    build_job_router_administration_delete_exception_policy_request,
    build_job_router_administration_delete_queue_request,
    build_job_router_administration_get_classification_policy_request,
    build_job_router_administration_get_distribution_policy_request,
    build_job_router_administration_get_exception_policy_request,
    build_job_router_administration_get_queue_request,
    build_job_router_administration_list_classification_policies_request,
    build_job_router_administration_list_distribution_policies_request,
    build_job_router_administration_list_exception_policies_request,
    build_job_router_administration_list_queues_request,
    build_job_router_administration_upsert_classification_policy_request,
    build_job_router_administration_upsert_distribution_policy_request,
    build_job_router_administration_upsert_exception_policy_request,
    build_job_router_administration_upsert_queue_request,
    build_job_router_cancel_job_action_request,
    build_job_router_close_job_action_request,
    build_job_router_complete_job_action_request,
    build_job_router_decline_job_action_request,
    build_job_router_delete_job_request,
    build_job_router_delete_worker_request,
    build_job_router_get_in_queue_position_request,
    build_job_router_get_job_request,
    build_job_router_get_queue_statistics_request,
    build_job_router_get_worker_request,
    build_job_router_list_jobs_request,
    build_job_router_list_workers_request,
    build_job_router_reclassify_job_action_request,
    build_job_router_unassign_job_action_request,
    build_job_router_upsert_job_request,
    build_job_router_upsert_worker_request,
)

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]


class JobRouterAdministrationOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.communication.jobrouter.aio.AzureCommunicationJobRouterService`'s
        :attr:`job_router_administration` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def upsert_classification_policy(
        self, id: str, patch: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param id: Id of the classification policy. Required.
        :type id: str
        :param patch: Model of classification policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "fallbackQueueId": "str",  # Optional. The fallback queue to select if the
                      queue selector doesn't find a match.
                    "id": "str",  # Optional. Unique identifier of this policy.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectors": [
                        queue_selector_attachment
                    ],
                    "workerSelectors": [
                        worker_selector_attachment
                    ]
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 200, 201
                response == {
                    "fallbackQueueId": "str",  # Optional. The fallback queue to select if the
                      queue selector doesn't find a match.
                    "id": "str",  # Optional. Unique identifier of this policy.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectors": [
                        queue_selector_attachment
                    ],
                    "workerSelectors": [
                        worker_selector_attachment
                    ]
                }
        """

    @overload
    async def upsert_classification_policy(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param id: Id of the classification policy. Required.
        :type id: str
        :param patch: Model of classification policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 200, 201
                response == {
                    "fallbackQueueId": "str",  # Optional. The fallback queue to select if the
                      queue selector doesn't find a match.
                    "id": "str",  # Optional. Unique identifier of this policy.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectors": [
                        queue_selector_attachment
                    ],
                    "workerSelectors": [
                        worker_selector_attachment
                    ]
                }
        """

    @distributed_trace_async
    async def upsert_classification_policy(self, id: str, patch: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a classification policy.

        Creates or updates a classification policy.

        :param id: Id of the classification policy. Required.
        :type id: str
        :param patch: Model of classification policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a JSON type or a IO type. Required.
        :type patch: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "fallbackQueueId": "str",  # Optional. The fallback queue to select if the
                      queue selector doesn't find a match.
                    "id": "str",  # Optional. Unique identifier of this policy.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectors": [
                        queue_selector_attachment
                    ],
                    "workerSelectors": [
                        worker_selector_attachment
                    ]
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 200, 201
                response == {
                    "fallbackQueueId": "str",  # Optional. The fallback queue to select if the
                      queue selector doesn't find a match.
                    "id": "str",  # Optional. Unique identifier of this policy.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectors": [
                        queue_selector_attachment
                    ],
                    "workerSelectors": [
                        worker_selector_attachment
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = patch

        request = build_job_router_administration_upsert_classification_policy_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_classification_policy(self, id: str, **kwargs: Any) -> JSON:
        """Retrieves an existing classification policy by Id.

        Retrieves an existing classification policy by Id.

        :param id: Id of the classification policy. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 200
                response == {
                    "fallbackQueueId": "str",  # Optional. The fallback queue to select if the
                      queue selector doesn't find a match.
                    "id": "str",  # Optional. Unique identifier of this policy.
                    "name": "str",  # Optional. Friendly name of this policy.
                    "prioritizationRule": router_rule,
                    "queueSelectors": [
                        queue_selector_attachment
                    ],
                    "workerSelectors": [
                        worker_selector_attachment
                    ]
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_job_router_administration_get_classification_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete_classification_policy(  # pylint: disable=inconsistent-return-statements
        self, id: str, **kwargs: Any
    ) -> None:
        """Delete a classification policy by Id.

        Delete a classification policy by Id.

        :param id: Id of the classification policy. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_administration_delete_classification_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_classification_policies(self, **kwargs: Any) -> AsyncIterable[JSON]:
        """Retrieves existing classification policies.

        Retrieves existing classification policies.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template for discriminator value "webhook-rule":
                router_rule = {
                    "kind": "webhook-rule",
                    "authorizationServerUri": "str",  # Optional. Uri for Authorization Server.
                    "clientCredential": {
                        "clientId": "str",  # Optional. ClientId for Contoso Authorization
                          server.
                        "clientSecret": "str"  # Optional. Client secret for Contoso
                          Authorization server.
                    },
                    "webhookUri": "str"  # Optional. Uri for Contoso's Web Server.
                }

                # response body for status code(s): 200
                response == {
                    "classificationPolicy": {
                        "fallbackQueueId": "str",  # Optional. The fallback queue to select
                          if the queue selector doesn't find a match.
                        "id": "str",  # Optional. Unique identifier of this policy.
                        "name": "str",  # Optional. Friendly name of this policy.
                        "prioritizationRule": router_rule,
                        "queueSelectors": [
                            queue_selector_attachment
                        ],
                        "workerSelectors": [
                            worker_selector_attachment
                        ]
                    },
                    "etag": "str"  # Optional. (Optional) The Concurrency Token.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_administration_list_classification_policies_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def upsert_distribution_policy(
        self, id: str, patch: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :param patch: Model of distribution policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "id": "str",  # Optional. The unique identifier of the policy.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. The human readable name of the policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. The number of seconds after
                      which any offers created under this policy will be expired.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # response body for status code(s): 200, 201
                response == {
                    "id": "str",  # Optional. The unique identifier of the policy.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. The human readable name of the policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. The number of seconds after
                      which any offers created under this policy will be expired.
                }
        """

    @overload
    async def upsert_distribution_policy(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :param patch: Model of distribution policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # response body for status code(s): 200, 201
                response == {
                    "id": "str",  # Optional. The unique identifier of the policy.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. The human readable name of the policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. The number of seconds after
                      which any offers created under this policy will be expired.
                }
        """

    @distributed_trace_async
    async def upsert_distribution_policy(self, id: str, patch: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a distribution policy.

        Creates or updates a distribution policy.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :param patch: Model of distribution policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a JSON type or a IO type. Required.
        :type patch: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # The input is polymorphic. The following are possible polymorphic inputs based off
                  discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "id": "str",  # Optional. The unique identifier of the policy.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. The human readable name of the policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. The number of seconds after
                      which any offers created under this policy will be expired.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # response body for status code(s): 200, 201
                response == {
                    "id": "str",  # Optional. The unique identifier of the policy.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. The human readable name of the policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. The number of seconds after
                      which any offers created under this policy will be expired.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = patch

        request = build_job_router_administration_upsert_distribution_policy_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_distribution_policy(self, id: str, **kwargs: Any) -> JSON:
        """Retrieves an existing distribution policy by Id.

        Retrieves an existing distribution policy by Id.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # response body for status code(s): 200
                response == {
                    "id": "str",  # Optional. The unique identifier of the policy.
                    "mode": distribution_mode,
                    "name": "str",  # Optional. The human readable name of the policy.
                    "offerExpiresAfterSeconds": 0.0  # Optional. The number of seconds after
                      which any offers created under this policy will be expired.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_job_router_administration_get_distribution_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete_distribution_policy(  # pylint: disable=inconsistent-return-statements
        self, id: str, **kwargs: Any
    ) -> None:
        """Delete a distribution policy by Id.

        Delete a distribution policy by Id.

        :param id: Id of the distribution policy. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_administration_delete_distribution_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_distribution_policies(self, **kwargs: Any) -> AsyncIterable[JSON]:
        """Retrieves existing distribution policies.

        Retrieves existing distribution policies.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python
                # The response is polymorphic. The following are possible polymorphic responses based
                  off discriminator "kind":

                # JSON input template for discriminator value "best-worker":
                distribution_mode = {
                    "kind": "best-worker",
                    "bypassSelectors": bool,  # Optional. (Optional)"nIf set to true, then router
                      will match workers to jobs even if they don't match label selectors."nWarning:
                      You may get workers that are not qualified for the job they are matched with if
                      you set this"nvariable to true. This flag is intended more for temporary
                      usage."nBy default, set to false.
                    "maxConcurrentOffers": 0,  # Optional. Governs the maximum number of active
                      concurrent offers a job can have.
                    "minConcurrentOffers": 0,  # Optional. Governs the minimum desired number of
                      active concurrent offers a job can have.
                    "scoringRule": router_rule,
                    "scoringRuleOptions": {
                        "allowScoringBatchOfWorkers": bool,  # Optional. (Optional)"nIf set
                          to true, will score workers in batches, and the parameter name of the worker
                          labels will be sent as ``workers``."nBy default, set to false and the
                          parameter name for the worker labels will be sent as ``worker``."nNote: If
                          enabled, use BatchSize to set batch size.
                        "batchSize": 0,  # Optional. (Optional) Set batch size when
                          AllowScoringBatchOfWorkers is set to true. Defaults to 20 if not configured.
                        "descendingOrder": bool,  # Optional. (Optional)"nIf false, will sort
                          scores by ascending order. By default, set to true.
                        "scoringParameters": [
                            "str"  # Optional. (Optional) List of extra parameters from
                              the job that will be sent as part of the payload to scoring rule."nIf not
                              set, the job's labels (sent in the payload as ``job``"" ) and the job's
                              worker selectors (sent in the payload as ``selectors``"" )"nare added to
                              the payload of the scoring rule by default."nNote: Worker labels are
                              always sent with scoring payload.
                        ]
                    }
                }

                # JSON input template for discriminator value "azure-function-rule":
                router_rule = {
                    "functionUri": "str",  # URL for Azure Function. Required.
                    "kind": "azure-function-rule",
                    "credential": {
                        "appKey": "str",  # Optional. (Optional) Access key scoped to a Azure
                          Function app."nThis key grants access to all functions under the app.
                        "clientId": "str",  # Optional. (Optional) Client id, when AppKey is
                          provided"nIn context of Azure function, this is usually the name of the key.
                        "functionKey": "str"  # Optional. (Optional) Access key scoped to a
                          particular function.
                    }
                }

                # JSON input template for discriminator value "direct-map-rule":
                router_rule = {
                    "kind": "direct-map-rule"
                }

                # JSON input template for discriminator value "expression-rule":
                router_rule = {
                    "expression": "str",  # The string containing the expression to evaluate.
                      Should contain return statement with calculated values. Required.
                    "kind": "expression-rule",
                    "language": "str"  # Optional. The expression language to compile to and
                      execute. "powerFx"
                }

                # JSON input template for discriminator value "static-rule":
                router_rule = {
                    "kind": "static-rule",
                    "value": {}  # Optional. The static value this rule always returns.
                }

                # response body for status code(s): 200
                response == {
                    "distributionPolicy": {
                        "id": "str",  # Optional. The unique identifier of the policy.
                        "mode": distribution_mode,
                        "name": "str",  # Optional. The human readable name of the policy.
                        "offerExpiresAfterSeconds": 0.0  # Optional. The number of seconds
                          after which any offers created under this policy will be expired.
                    },
                    "etag": "str"  # Optional. (Optional) The Concurrency Token.
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_administration_list_distribution_policies_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def upsert_exception_policy(
        self, id: str, patch: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param id: Id of the exception policy. Required.
        :type id: str
        :param patch: Model of exception policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "exceptionRules": {
                        "str": {
                            "actions": {
                                "str": exception_action
                            },
                            "trigger": exception_trigger
                        }
                    },
                    "id": "str",  # Optional. The Id of the exception policy.
                    "name": "str"  # Optional. (Optional) The name of the exception policy.
                }

                # response body for status code(s): 200, 201
                response == {
                    "exceptionRules": {
                        "str": {
                            "actions": {
                                "str": exception_action
                            },
                            "trigger": exception_trigger
                        }
                    },
                    "id": "str",  # Optional. The Id of the exception policy.
                    "name": "str"  # Optional. (Optional) The name of the exception policy.
                }
        """

    @overload
    async def upsert_exception_policy(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param id: Id of the exception policy. Required.
        :type id: str
        :param patch: Model of exception policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "exceptionRules": {
                        "str": {
                            "actions": {
                                "str": exception_action
                            },
                            "trigger": exception_trigger
                        }
                    },
                    "id": "str",  # Optional. The Id of the exception policy.
                    "name": "str"  # Optional. (Optional) The name of the exception policy.
                }
        """

    @distributed_trace_async
    async def upsert_exception_policy(self, id: str, patch: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a exception policy.

        Creates or updates a exception policy.

        :param id: Id of the exception policy. Required.
        :type id: str
        :param patch: Model of exception policy properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a JSON type or a IO type. Required.
        :type patch: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "exceptionRules": {
                        "str": {
                            "actions": {
                                "str": exception_action
                            },
                            "trigger": exception_trigger
                        }
                    },
                    "id": "str",  # Optional. The Id of the exception policy.
                    "name": "str"  # Optional. (Optional) The name of the exception policy.
                }

                # response body for status code(s): 200, 201
                response == {
                    "exceptionRules": {
                        "str": {
                            "actions": {
                                "str": exception_action
                            },
                            "trigger": exception_trigger
                        }
                    },
                    "id": "str",  # Optional. The Id of the exception policy.
                    "name": "str"  # Optional. (Optional) The name of the exception policy.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = patch

        request = build_job_router_administration_upsert_exception_policy_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_exception_policy(self, id: str, **kwargs: Any) -> JSON:
        """Retrieves an existing exception policy by Id.

        Retrieves an existing exception policy by Id.

        :param id: Id of the exception policy to retrieve. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "exceptionRules": {
                        "str": {
                            "actions": {
                                "str": exception_action
                            },
                            "trigger": exception_trigger
                        }
                    },
                    "id": "str",  # Optional. The Id of the exception policy.
                    "name": "str"  # Optional. (Optional) The name of the exception policy.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_job_router_administration_get_exception_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete_exception_policy(  # pylint: disable=inconsistent-return-statements
        self, id: str, **kwargs: Any
    ) -> None:
        """Deletes a exception policy by Id.

        Deletes a exception policy by Id.

        :param id: Id of the exception policy to delete. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_administration_delete_exception_policy_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_exception_policies(self, **kwargs: Any) -> AsyncIterable[JSON]:
        """Retrieves existing exception policies.

        Retrieves existing exception policies.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # Optional. (Optional) The Concurrency Token.
                    "exceptionPolicy": {
                        "exceptionRules": {
                            "str": {
                                "actions": {
                                    "str": exception_action
                                },
                                "trigger": exception_trigger
                            }
                        },
                        "id": "str",  # Optional. The Id of the exception policy.
                        "name": "str"  # Optional. (Optional) The name of the exception
                          policy.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_administration_list_exception_policies_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @overload
    async def upsert_queue(
        self, id: str, patch: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a queue.

        Creates or updates a queue.

        :param id: Id of the queue. Required.
        :type id: str
        :param patch: Model of queue properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "distributionPolicyId": "str",  # Optional. The ID of the distribution policy
                      that will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. (Optional) The ID of the exception
                      policy that determines various job escalation rules.
                    "id": "str",  # Optional. The Id of this queue.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "name": "str"  # Optional. The name of this queue.
                }

                # response body for status code(s): 200, 201
                response == {
                    "distributionPolicyId": "str",  # Optional. The ID of the distribution policy
                      that will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. (Optional) The ID of the exception
                      policy that determines various job escalation rules.
                    "id": "str",  # Optional. The Id of this queue.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "name": "str"  # Optional. The name of this queue.
                }
        """

    @overload
    async def upsert_queue(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a queue.

        Creates or updates a queue.

        :param id: Id of the queue. Required.
        :type id: str
        :param patch: Model of queue properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "distributionPolicyId": "str",  # Optional. The ID of the distribution policy
                      that will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. (Optional) The ID of the exception
                      policy that determines various job escalation rules.
                    "id": "str",  # Optional. The Id of this queue.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "name": "str"  # Optional. The name of this queue.
                }
        """

    @distributed_trace_async
    async def upsert_queue(self, id: str, patch: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a queue.

        Creates or updates a queue.

        :param id: Id of the queue. Required.
        :type id: str
        :param patch: Model of queue properties to be patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a JSON type or a IO type. Required.
        :type patch: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "distributionPolicyId": "str",  # Optional. The ID of the distribution policy
                      that will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. (Optional) The ID of the exception
                      policy that determines various job escalation rules.
                    "id": "str",  # Optional. The Id of this queue.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "name": "str"  # Optional. The name of this queue.
                }

                # response body for status code(s): 200, 201
                response == {
                    "distributionPolicyId": "str",  # Optional. The ID of the distribution policy
                      that will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. (Optional) The ID of the exception
                      policy that determines various job escalation rules.
                    "id": "str",  # Optional. The Id of this queue.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "name": "str"  # Optional. The name of this queue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = patch

        request = build_job_router_administration_upsert_queue_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_queue(self, id: str, **kwargs: Any) -> JSON:
        """Retrieves an existing queue by Id.

        Retrieves an existing queue by Id.

        :param id: Id of the queue to retrieve. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "distributionPolicyId": "str",  # Optional. The ID of the distribution policy
                      that will determine how a job is distributed to workers.
                    "exceptionPolicyId": "str",  # Optional. (Optional) The ID of the exception
                      policy that determines various job escalation rules.
                    "id": "str",  # Optional. The Id of this queue.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "name": "str"  # Optional. The name of this queue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_job_router_administration_get_queue_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete_queue(self, id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a queue by Id.

        Deletes a queue by Id.

        :param id: Id of the queue to delete. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_administration_delete_queue_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_queues(self, **kwargs: Any) -> AsyncIterable[JSON]:
        """Retrieves existing queues.

        Retrieves existing queues.

        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # Optional. (Optional) The Concurrency Token.
                    "queue": {
                        "distributionPolicyId": "str",  # Optional. The ID of the
                          distribution policy that will determine how a job is distributed to workers.
                        "exceptionPolicyId": "str",  # Optional. (Optional) The ID of the
                          exception policy that determines various job escalation rules.
                        "id": "str",  # Optional. The Id of this queue.
                        "labels": {
                            "str": {}  # Optional. A set of key/value pairs that are
                              identifying attributes used by the rules engines to make decisions.
                        },
                        "name": "str"  # Optional. The name of this queue.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_administration_list_queues_request(
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)


class JobRouterOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.communication.jobrouter.aio.AzureCommunicationJobRouterService`'s
        :attr:`job_router` attribute.
    """

    def __init__(self, *args, **kwargs) -> None:
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = input_args.pop(0) if input_args else kwargs.pop("deserializer")

    @overload
    async def upsert_job(
        self, id: str, patch: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a router job.

        Creates or updates a router job.

        :param id: Id of the job. Required.
        :type id: str
        :param patch: Model of job properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the job assignment.
                              Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. The time the
                              job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. The time
                              the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. The Id of the Worker assigned
                              to the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. The Id of the Classification
                      policy used for classifying a job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. The time a job was queued
                      in UTC.
                    "id": "str",  # Optional. The id of the job.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "matchingMode": {
                        "modeType": "str",  # Optional. Known values are:
                          "queueAndMatchMode", "scheduleAndSuspendMode", and "suspendMode".
                        "queueAndMatchMode": {},  # Optional. Any object.
                        "scheduleAndSuspendMode": {
                            "scheduleAt": "2020-02-20 00:00:00"  # Optional.
                        },
                        "suspendMode": {}  # Optional. Any object.
                    },
                    "notes": {
                        "str": "str"  # Optional. Notes attached to a job, sorted by
                          timestamp.
                    },
                    "priority": 0,  # Optional. The priority of this job.
                    "queueId": "str",  # Optional. The Id of the Queue that this job is queued
                      to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the Job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the job assignment.
                              Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. The time the
                              job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. The time
                              the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. The Id of the Worker assigned
                              to the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. The Id of the Classification
                      policy used for classifying a job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. The time a job was queued
                      in UTC.
                    "id": "str",  # Optional. The id of the job.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "matchingMode": {
                        "modeType": "str",  # Optional. Known values are:
                          "queueAndMatchMode", "scheduleAndSuspendMode", and "suspendMode".
                        "queueAndMatchMode": {},  # Optional. Any object.
                        "scheduleAndSuspendMode": {
                            "scheduleAt": "2020-02-20 00:00:00"  # Optional.
                        },
                        "suspendMode": {}  # Optional. Any object.
                    },
                    "notes": {
                        "str": "str"  # Optional. Notes attached to a job, sorted by
                          timestamp.
                    },
                    "priority": 0,  # Optional. The priority of this job.
                    "queueId": "str",  # Optional. The Id of the Queue that this job is queued
                      to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the Job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job.
                    }
                }
        """

    @overload
    async def upsert_job(
        self, id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a router job.

        Creates or updates a router job.

        :param id: Id of the job. Required.
        :type id: str
        :param patch: Model of job properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the job assignment.
                              Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. The time the
                              job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. The time
                              the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. The Id of the Worker assigned
                              to the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. The Id of the Classification
                      policy used for classifying a job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. The time a job was queued
                      in UTC.
                    "id": "str",  # Optional. The id of the job.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "matchingMode": {
                        "modeType": "str",  # Optional. Known values are:
                          "queueAndMatchMode", "scheduleAndSuspendMode", and "suspendMode".
                        "queueAndMatchMode": {},  # Optional. Any object.
                        "scheduleAndSuspendMode": {
                            "scheduleAt": "2020-02-20 00:00:00"  # Optional.
                        },
                        "suspendMode": {}  # Optional. Any object.
                    },
                    "notes": {
                        "str": "str"  # Optional. Notes attached to a job, sorted by
                          timestamp.
                    },
                    "priority": 0,  # Optional. The priority of this job.
                    "queueId": "str",  # Optional. The Id of the Queue that this job is queued
                      to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the Job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job.
                    }
                }
        """

    @distributed_trace_async
    async def upsert_job(self, id: str, patch: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a router job.

        Creates or updates a router job.

        :param id: Id of the job. Required.
        :type id: str
        :param patch: Model of job properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a JSON type or a IO type. Required.
        :type patch: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the job assignment.
                              Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. The time the
                              job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. The time
                              the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. The Id of the Worker assigned
                              to the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. The Id of the Classification
                      policy used for classifying a job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. The time a job was queued
                      in UTC.
                    "id": "str",  # Optional. The id of the job.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "matchingMode": {
                        "modeType": "str",  # Optional. Known values are:
                          "queueAndMatchMode", "scheduleAndSuspendMode", and "suspendMode".
                        "queueAndMatchMode": {},  # Optional. Any object.
                        "scheduleAndSuspendMode": {
                            "scheduleAt": "2020-02-20 00:00:00"  # Optional.
                        },
                        "suspendMode": {}  # Optional. Any object.
                    },
                    "notes": {
                        "str": "str"  # Optional. Notes attached to a job, sorted by
                          timestamp.
                    },
                    "priority": 0,  # Optional. The priority of this job.
                    "queueId": "str",  # Optional. The Id of the Queue that this job is queued
                      to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the Job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job.
                    }
                }

                # response body for status code(s): 200, 201
                response == {
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the job assignment.
                              Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. The time the
                              job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. The time
                              the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. The Id of the Worker assigned
                              to the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. The Id of the Classification
                      policy used for classifying a job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. The time a job was queued
                      in UTC.
                    "id": "str",  # Optional. The id of the job.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "matchingMode": {
                        "modeType": "str",  # Optional. Known values are:
                          "queueAndMatchMode", "scheduleAndSuspendMode", and "suspendMode".
                        "queueAndMatchMode": {},  # Optional. Any object.
                        "scheduleAndSuspendMode": {
                            "scheduleAt": "2020-02-20 00:00:00"  # Optional.
                        },
                        "suspendMode": {}  # Optional. Any object.
                    },
                    "notes": {
                        "str": "str"  # Optional. Notes attached to a job, sorted by
                          timestamp.
                    },
                    "priority": 0,  # Optional. The priority of this job.
                    "queueId": "str",  # Optional. The Id of the Queue that this job is queued
                      to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the Job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = patch

        request = build_job_router_upsert_job_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_job(self, id: str, **kwargs: Any) -> JSON:
        """Retrieves an existing job by Id.

        Retrieves an existing job by Id.

        :param id: Id of the job to retrieve. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignments": {
                        "str": {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the job assignment.
                              Required.
                            "closedAt": "2020-02-20 00:00:00",  # Optional. The time the
                              job was marked as closed after being completed in UTC.
                            "completedAt": "2020-02-20 00:00:00",  # Optional. The time
                              the job was marked as completed after being assigned in UTC.
                            "workerId": "str"  # Optional. The Id of the Worker assigned
                              to the job.
                        }
                    },
                    "attachedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "channelId": "str",  # Optional. The channel identifier. eg. voice, chat,
                      etc.
                    "channelReference": "str",  # Optional. Reference to an external parent
                      context, eg. call ID.
                    "classificationPolicyId": "str",  # Optional. The Id of the Classification
                      policy used for classifying a job.
                    "dispositionCode": "str",  # Optional. Reason code for cancelled or closed
                      jobs.
                    "enqueuedAt": "2020-02-20 00:00:00",  # Optional. The time a job was queued
                      in UTC.
                    "id": "str",  # Optional. The id of the job.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "matchingMode": {
                        "modeType": "str",  # Optional. Known values are:
                          "queueAndMatchMode", "scheduleAndSuspendMode", and "suspendMode".
                        "queueAndMatchMode": {},  # Optional. Any object.
                        "scheduleAndSuspendMode": {
                            "scheduleAt": "2020-02-20 00:00:00"  # Optional.
                        },
                        "suspendMode": {}  # Optional. Any object.
                    },
                    "notes": {
                        "str": "str"  # Optional. Notes attached to a job, sorted by
                          timestamp.
                    },
                    "priority": 0,  # Optional. The priority of this job.
                    "queueId": "str",  # Optional. The Id of the Queue that this job is queued
                      to.
                    "requestedWorkerSelectors": [
                        {
                            "key": "str",  # The label key to query against. Required.
                            "labelOperator": "str",  # Describes how the value of the
                              label is compared to the value defined on the label selector. Required.
                              Known values are: "equal", "notEqual", "lessThan", "lessThanEqual",
                              "greaterThan", and "greaterThanEqual".
                            "expedite": bool,  # Optional. Pushes the job to the front of
                              the queue as long as this selector is active.
                            "expiresAfterSeconds": 0.0,  # Optional. Describes how long
                              this label selector is valid in seconds.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time at
                              which this worker selector expires in UTC.
                            "status": "str",  # Optional. The status of the worker
                              selector. Known values are: "active" and "expired".
                            "value": {}  # Optional. The value to compare against the
                              actual label value with the given operator.
                        }
                    ],
                    "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will be
                      scheduled to be enqueued at a given time.
                    "status": "str",  # Optional. The status of the Job. Known values are:
                      "pendingClassification", "queued", "assigned", "completed", "closed",
                      "cancelled", "classificationFailed", "created", "pendingSchedule", "scheduled",
                      "scheduleFailed", and "waitingForActivation".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this job.
                    }
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_job_router_get_job_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete_job(self, id: str, **kwargs: Any) -> None:  # pylint: disable=inconsistent-return-statements
        """Deletes a job and all of its traces.

        Deletes a job and all of its traces.

        :param id: Id of the job. Required.
        :type id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_delete_job_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace_async
    async def reclassify_job_action(
        self, id: str, reclassify_job_request: Optional[JSON] = None, **kwargs: Any
    ) -> JSON:
        """Reclassify a job.

        Reclassify a job.

        :param id: Id of the job. Required.
        :type id: str
        :param reclassify_job_request: Request object for reclassifying a job. Default value is None.
        :type reclassify_job_request: JSON
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: str = kwargs.pop("content_type", _headers.pop("Content-Type", "application/json"))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        if reclassify_job_request is not None:
            _json = reclassify_job_request
        else:
            _json = None

        request = build_job_router_reclassify_job_action_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def cancel_job_action(
        self,
        id: str,
        cancel_job_request: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        :param id: Id of the job. Required.
        :type id: str
        :param cancel_job_request: Request model for cancelling job. Default value is None.
        :type cancel_job_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                cancel_job_request = {
                    "dispositionCode": "str",  # Optional. Indicates the outcome of the job,
                      populate this field with your own custom values."nIf not provided, default value
                      of "Cancelled" is set.
                    "note": "str"  # Optional. (Optional) A note that will be appended to the
                      jobs' Notes collection with the current timestamp.
                }
        """

    @overload
    async def cancel_job_action(
        self, id: str, cancel_job_request: Optional[IO] = None, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        :param id: Id of the job. Required.
        :type id: str
        :param cancel_job_request: Request model for cancelling job. Default value is None.
        :type cancel_job_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def cancel_job_action(
        self, id: str, cancel_job_request: Optional[Union[JSON, IO]] = None, **kwargs: Any
    ) -> JSON:
        """Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        Submits request to cancel an existing job by Id while supplying free-form cancellation reason.

        :param id: Id of the job. Required.
        :type id: str
        :param cancel_job_request: Request model for cancelling job. Is either a JSON type or a IO
         type. Default value is None.
        :type cancel_job_request: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                cancel_job_request = {
                    "dispositionCode": "str",  # Optional. Indicates the outcome of the job,
                      populate this field with your own custom values."nIf not provided, default value
                      of "Cancelled" is set.
                    "note": "str"  # Optional. (Optional) A note that will be appended to the
                      jobs' Notes collection with the current timestamp.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(cancel_job_request, (IOBase, bytes)):
            _content = cancel_job_request
        else:
            if cancel_job_request is not None:
                _json = cancel_job_request
            else:
                _json = None

        request = build_job_router_cancel_job_action_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def complete_job_action(
        self, id: str, complete_job_request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Completes an assigned job.

        Completes an assigned job.

        :param id: Id of the job. Required.
        :type id: str
        :param complete_job_request: Request model for completing job. Required.
        :type complete_job_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                complete_job_request = {
                    "assignmentId": "str",  # The assignment within the job to complete.
                      Required.
                    "note": "str"  # Optional. (Optional) A note that will be appended to the
                      jobs' Notes collection with the current timestamp.
                }
        """

    @overload
    async def complete_job_action(
        self, id: str, complete_job_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Completes an assigned job.

        Completes an assigned job.

        :param id: Id of the job. Required.
        :type id: str
        :param complete_job_request: Request model for completing job. Required.
        :type complete_job_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def complete_job_action(self, id: str, complete_job_request: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Completes an assigned job.

        Completes an assigned job.

        :param id: Id of the job. Required.
        :type id: str
        :param complete_job_request: Request model for completing job. Is either a JSON type or a IO
         type. Required.
        :type complete_job_request: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                complete_job_request = {
                    "assignmentId": "str",  # The assignment within the job to complete.
                      Required.
                    "note": "str"  # Optional. (Optional) A note that will be appended to the
                      jobs' Notes collection with the current timestamp.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(complete_job_request, (IOBase, bytes)):
            _content = complete_job_request
        else:
            _json = complete_job_request

        request = build_job_router_complete_job_action_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def close_job_action(
        self, id: str, close_job_request: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Closes a completed job.

        Closes a completed job.

        :param id: Id of the job. Required.
        :type id: str
        :param close_job_request: Request model for closing job. Required.
        :type close_job_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                close_job_request = {
                    "assignmentId": "str",  # The assignment within which the job is to be
                      closed. Required.
                    "closeAt": "2020-02-20 00:00:00",  # Optional. If not provided, worker
                      capacity is released immediately along with a JobClosedEvent notification."nIf
                      provided, worker capacity is released along with a JobClosedEvent notification at
                      a future time in UTC.
                    "dispositionCode": "str",  # Optional. Indicates the outcome of the job,
                      populate this field with your own custom values.
                    "note": "str"  # Optional. (Optional) A note that will be appended to the
                      jobs' Notes collection with the current timestamp.
                }
        """

    @overload
    async def close_job_action(
        self, id: str, close_job_request: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Closes a completed job.

        Closes a completed job.

        :param id: Id of the job. Required.
        :type id: str
        :param close_job_request: Request model for closing job. Required.
        :type close_job_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def close_job_action(self, id: str, close_job_request: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Closes a completed job.

        Closes a completed job.

        :param id: Id of the job. Required.
        :type id: str
        :param close_job_request: Request model for closing job. Is either a JSON type or a IO type.
         Required.
        :type close_job_request: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                close_job_request = {
                    "assignmentId": "str",  # The assignment within which the job is to be
                      closed. Required.
                    "closeAt": "2020-02-20 00:00:00",  # Optional. If not provided, worker
                      capacity is released immediately along with a JobClosedEvent notification."nIf
                      provided, worker capacity is released along with a JobClosedEvent notification at
                      a future time in UTC.
                    "dispositionCode": "str",  # Optional. Indicates the outcome of the job,
                      populate this field with your own custom values.
                    "note": "str"  # Optional. (Optional) A note that will be appended to the
                      jobs' Notes collection with the current timestamp.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(close_job_request, (IOBase, bytes)):
            _content = close_job_request
        else:
            _json = close_job_request

        request = build_job_router_close_job_action_request(
            id=id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 202]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 202:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace
    def list_jobs(
        self,
        *,
        status: str = "all",
        queue_id: Optional[str] = None,
        channel_id: Optional[str] = None,
        classification_policy_id: Optional[str] = None,
        scheduled_before: Optional[datetime.datetime] = None,
        scheduled_after: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Retrieves list of jobs based on filter parameters.

        Retrieves list of jobs based on filter parameters.

        :keyword status: If specified, filter jobs by status. Known values are: "all",
         "pendingClassification", "queued", "assigned", "completed", "closed", "cancelled",
         "classificationFailed", "created", "pendingSchedule", "scheduled", "scheduleFailed",
         "waitingForActivation", and "active". Default value is "all".
        :paramtype status: str
        :keyword queue_id: If specified, filter jobs by queue. Default value is None.
        :paramtype queue_id: str
        :keyword channel_id: If specified, filter jobs by channel. Default value is None.
        :paramtype channel_id: str
        :keyword classification_policy_id: If specified, filter jobs by classificationPolicy. Default
         value is None.
        :paramtype classification_policy_id: str
        :keyword scheduled_before: If specified, filter on jobs that was scheduled before or at given
         timestamp. Range: (-Inf, scheduledBefore]. Default value is None.
        :paramtype scheduled_before: ~datetime.datetime
        :keyword scheduled_after: If specified, filter on jobs that was scheduled at or after given
         value. Range: [scheduledAfter, +Inf). Default value is None.
        :paramtype scheduled_after: ~datetime.datetime
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # Optional. (Optional) The Concurrency Token.
                    "job": {
                        "assignments": {
                            "str": {
                                "assignedAt": "2020-02-20 00:00:00",  # The
                                  assignment time of the job in UTC. Required.
                                "assignmentId": "str",  # The Id of the job
                                  assignment. Required.
                                "closedAt": "2020-02-20 00:00:00",  # Optional. The
                                  time the job was marked as closed after being completed in UTC.
                                "completedAt": "2020-02-20 00:00:00",  # Optional.
                                  The time the job was marked as completed after being assigned in UTC.
                                "workerId": "str"  # Optional. The Id of the Worker
                                  assigned to the job.
                            }
                        },
                        "attachedWorkerSelectors": [
                            {
                                "key": "str",  # The label key to query against.
                                  Required.
                                "labelOperator": "str",  # Describes how the value of
                                  the label is compared to the value defined on the label selector.
                                  Required. Known values are: "equal", "notEqual", "lessThan",
                                  "lessThanEqual", "greaterThan", and "greaterThanEqual".
                                "expedite": bool,  # Optional. Pushes the job to the
                                  front of the queue as long as this selector is active.
                                "expiresAfterSeconds": 0.0,  # Optional. Describes
                                  how long this label selector is valid in seconds.
                                "expiresAt": "2020-02-20 00:00:00",  # Optional. The
                                  time at which this worker selector expires in UTC.
                                "status": "str",  # Optional. The status of the
                                  worker selector. Known values are: "active" and "expired".
                                "value": {}  # Optional. The value to compare against
                                  the actual label value with the given operator.
                            }
                        ],
                        "channelId": "str",  # Optional. The channel identifier. eg. voice,
                          chat, etc.
                        "channelReference": "str",  # Optional. Reference to an external
                          parent context, eg. call ID.
                        "classificationPolicyId": "str",  # Optional. The Id of the
                          Classification policy used for classifying a job.
                        "dispositionCode": "str",  # Optional. Reason code for cancelled or
                          closed jobs.
                        "enqueuedAt": "2020-02-20 00:00:00",  # Optional. The time a job was
                          queued in UTC.
                        "id": "str",  # Optional. The id of the job.
                        "labels": {
                            "str": {}  # Optional. A set of key/value pairs that are
                              identifying attributes used by the rules engines to make decisions.
                        },
                        "matchingMode": {
                            "modeType": "str",  # Optional. Known values are:
                              "queueAndMatchMode", "scheduleAndSuspendMode", and "suspendMode".
                            "queueAndMatchMode": {},  # Optional. Any object.
                            "scheduleAndSuspendMode": {
                                "scheduleAt": "2020-02-20 00:00:00"  # Optional. A
                                  unit of work to be routed.
                            },
                            "suspendMode": {}  # Optional. Any object.
                        },
                        "notes": {
                            "str": "str"  # Optional. Notes attached to a job, sorted by
                              timestamp.
                        },
                        "priority": 0,  # Optional. The priority of this job.
                        "queueId": "str",  # Optional. The Id of the Queue that this job is
                          queued to.
                        "requestedWorkerSelectors": [
                            {
                                "key": "str",  # The label key to query against.
                                  Required.
                                "labelOperator": "str",  # Describes how the value of
                                  the label is compared to the value defined on the label selector.
                                  Required. Known values are: "equal", "notEqual", "lessThan",
                                  "lessThanEqual", "greaterThan", and "greaterThanEqual".
                                "expedite": bool,  # Optional. Pushes the job to the
                                  front of the queue as long as this selector is active.
                                "expiresAfterSeconds": 0.0,  # Optional. Describes
                                  how long this label selector is valid in seconds.
                                "expiresAt": "2020-02-20 00:00:00",  # Optional. The
                                  time at which this worker selector expires in UTC.
                                "status": "str",  # Optional. The status of the
                                  worker selector. Known values are: "active" and "expired".
                                "value": {}  # Optional. The value to compare against
                                  the actual label value with the given operator.
                            }
                        ],
                        "scheduledAt": "2020-02-20 00:00:00",  # Optional. If set, job will
                          be scheduled to be enqueued at a given time.
                        "status": "str",  # Optional. The status of the Job. Known values
                          are: "pendingClassification", "queued", "assigned", "completed", "closed",
                          "cancelled", "classificationFailed", "created", "pendingSchedule",
                          "scheduled", "scheduleFailed", and "waitingForActivation".
                        "tags": {
                            "str": {}  # Optional. A set of non-identifying attributes
                              attached to this job.
                        }
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_list_jobs_request(
                    status=status,
                    queue_id=queue_id,
                    channel_id=channel_id,
                    classification_policy_id=classification_policy_id,
                    scheduled_before=scheduled_before,
                    scheduled_after=scheduled_after,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)

    @distributed_trace_async
    async def get_in_queue_position(self, id: str, **kwargs: Any) -> JSON:
        """Gets a job's position details.

        Gets a job's position details.

        :param id: Id of the job. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "estimatedWaitTimeMinutes": 0.0,  # Estimated wait time of the job rounded up
                      to the nearest minute. Required.
                    "jobId": "str",  # Id of the job these details are about. Required.
                    "position": 0,  # Position of the job in question within that queue.
                      Required.
                    "queueId": "str",  # Id of the queue this job is enqueued in. Required.
                    "queueLength": 0  # Length of the queue: total number of enqueued jobs.
                      Required.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_job_router_get_in_queue_position_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def unassign_job_action(
        self,
        id: str,
        assignment_id: str,
        unassign_job_request: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Un-assign a job.

        Un-assign a job.

        :param id: Id of the job to un-assign. Required.
        :type id: str
        :param assignment_id: Id of the assignment to un-assign. Required.
        :type assignment_id: str
        :param unassign_job_request: Request body for unassign route. Default value is None.
        :type unassign_job_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                unassign_job_request = {
                    "suspendMatching": bool  # Optional. If WaitForActivation is true, then the
                      job is not queued for re-matching with a worker.
                }

                # response body for status code(s): 200
                response == {
                    "jobId": "str",  # The Id of the job unassigned. Required.
                    "unassignmentCount": 0  # The number of times a job is unassigned. At a
                      maximum 3. Required.
                }
        """

    @overload
    async def unassign_job_action(
        self,
        id: str,
        assignment_id: str,
        unassign_job_request: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Un-assign a job.

        Un-assign a job.

        :param id: Id of the job to un-assign. Required.
        :type id: str
        :param assignment_id: Id of the assignment to un-assign. Required.
        :type assignment_id: str
        :param unassign_job_request: Request body for unassign route. Default value is None.
        :type unassign_job_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "jobId": "str",  # The Id of the job unassigned. Required.
                    "unassignmentCount": 0  # The number of times a job is unassigned. At a
                      maximum 3. Required.
                }
        """

    @distributed_trace_async
    async def unassign_job_action(
        self, id: str, assignment_id: str, unassign_job_request: Optional[Union[JSON, IO]] = None, **kwargs: Any
    ) -> JSON:
        """Un-assign a job.

        Un-assign a job.

        :param id: Id of the job to un-assign. Required.
        :type id: str
        :param assignment_id: Id of the assignment to un-assign. Required.
        :type assignment_id: str
        :param unassign_job_request: Request body for unassign route. Is either a JSON type or a IO
         type. Default value is None.
        :type unassign_job_request: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                unassign_job_request = {
                    "suspendMatching": bool  # Optional. If WaitForActivation is true, then the
                      job is not queued for re-matching with a worker.
                }

                # response body for status code(s): 200
                response == {
                    "jobId": "str",  # The Id of the job unassigned. Required.
                    "unassignmentCount": 0  # The number of times a job is unassigned. At a
                      maximum 3. Required.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(unassign_job_request, (IOBase, bytes)):
            _content = unassign_job_request
        else:
            if unassign_job_request is not None:
                _json = unassign_job_request
            else:
                _json = None

        request = build_job_router_unassign_job_action_request(
            id=id,
            assignment_id=assignment_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def accept_job_action(self, worker_id: str, offer_id: str, **kwargs: Any) -> JSON:
        """Accepts an offer to work on a job and returns a 409/Conflict if another agent accepted the job
        already.

        Accepts an offer to work on a job and returns a 409/Conflict if another agent accepted the job
        already.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param offer_id: Id of the offer. Required.
        :type offer_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignmentId": "str",  # The assignment Id that assigns a worker that has
                      accepted an offer to a job. Required.
                    "jobId": "str",  # The Id of the job assigned. Required.
                    "workerId": "str"  # The Id of the worker that has been assigned this job.
                      Required.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_job_router_accept_job_action_request(
            worker_id=worker_id,
            offer_id=offer_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def decline_job_action(
        self,
        worker_id: str,
        offer_id: str,
        decline_job_offer_request: Optional[JSON] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Declines an offer to work on a job.

        Declines an offer to work on a job.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param offer_id: Id of the offer. Required.
        :type offer_id: str
        :param decline_job_offer_request: Request model for declining offer. Default value is None.
        :type decline_job_offer_request: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                decline_job_offer_request = {
                    "retryOfferAt": "2020-02-20 00:00:00"  # Optional. If the RetryOfferAt is not
                      provided, then this job will not be offered again to the worker who declined this
                      job unless"nthe worker is de-registered and re-registered.  If a RetryOfferAt
                      time is provided, then the job will be re-matched to"neligible workers at the
                      retry time in UTC.  The worker that declined the job will also be eligible for
                      the job at that time.
                }
        """

    @overload
    async def decline_job_action(
        self,
        worker_id: str,
        offer_id: str,
        decline_job_offer_request: Optional[IO] = None,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Declines an offer to work on a job.

        Declines an offer to work on a job.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param offer_id: Id of the offer. Required.
        :type offer_id: str
        :param decline_job_offer_request: Request model for declining offer. Default value is None.
        :type decline_job_offer_request: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:
        """

    @distributed_trace_async
    async def decline_job_action(
        self, worker_id: str, offer_id: str, decline_job_offer_request: Optional[Union[JSON, IO]] = None, **kwargs: Any
    ) -> JSON:
        """Declines an offer to work on a job.

        Declines an offer to work on a job.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param offer_id: Id of the offer. Required.
        :type offer_id: str
        :param decline_job_offer_request: Request model for declining offer. Is either a JSON type or a
         IO type. Default value is None.
        :type decline_job_offer_request: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                decline_job_offer_request = {
                    "retryOfferAt": "2020-02-20 00:00:00"  # Optional. If the RetryOfferAt is not
                      provided, then this job will not be offered again to the worker who declined this
                      job unless"nthe worker is de-registered and re-registered.  If a RetryOfferAt
                      time is provided, then the job will be re-matched to"neligible workers at the
                      retry time in UTC.  The worker that declined the job will also be eligible for
                      the job at that time.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(decline_job_offer_request, (IOBase, bytes)):
            _content = decline_job_offer_request
        else:
            if decline_job_offer_request is not None:
                _json = decline_job_offer_request
            else:
                _json = None

        request = build_job_router_decline_job_action_request(
            worker_id=worker_id,
            offer_id=offer_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def get_queue_statistics(self, id: str, **kwargs: Any) -> JSON:
        """Retrieves a queue's statistics.

        Retrieves a queue's statistics.

        :param id: Id of the queue to retrieve statistics. Required.
        :type id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "length": 0,  # Length of the queue: total number of enqueued jobs. Required.
                    "queueId": "str",  # Id of the queue these details are about. Required.
                    "estimatedWaitTimeMinutes": {
                        "str": 0.0  # Optional. The estimated wait time of this queue rounded
                          up to the nearest minute, grouped by job priority.
                    },
                    "longestJobWaitTimeMinutes": 0.0  # Optional. The wait time of the job that
                      has been enqueued in this queue for the longest.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_job_router_get_queue_statistics_request(
            id=id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @overload
    async def upsert_worker(
        self, worker_id: str, patch: JSON, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param patch: Model of worker properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # The Id of the Job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "channelConfigurations": {
                        "str": {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    },
                    "id": "str",  # Optional.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # The Id of the job. Required.
                            "offerId": "str",  # The Id of the offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time
                              that the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. The time the
                              offer was created in UTC.
                        }
                    ],
                    "queueAssignments": {
                        "str": {}  # Optional. The queue(s) that this worker can receive work
                          from.
                    },
                    "state": "str",  # Optional. The current state of the worker. Known values
                      are: "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker.
                    },
                    "totalCapacity": 0  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                }

                # response body for status code(s): 200, 201
                response == {
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # The Id of the Job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "channelConfigurations": {
                        "str": {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    },
                    "id": "str",  # Optional.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # The Id of the job. Required.
                            "offerId": "str",  # The Id of the offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time
                              that the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. The time the
                              offer was created in UTC.
                        }
                    ],
                    "queueAssignments": {
                        "str": {}  # Optional. The queue(s) that this worker can receive work
                          from.
                    },
                    "state": "str",  # Optional. The current state of the worker. Known values
                      are: "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker.
                    },
                    "totalCapacity": 0  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                }
        """

    @overload
    async def upsert_worker(
        self, worker_id: str, patch: IO, *, content_type: str = "application/merge-patch+json", **kwargs: Any
    ) -> JSON:
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param patch: Model of worker properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Required.
        :type patch: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/merge-patch+json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200, 201
                response == {
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # The Id of the Job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "channelConfigurations": {
                        "str": {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    },
                    "id": "str",  # Optional.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # The Id of the job. Required.
                            "offerId": "str",  # The Id of the offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time
                              that the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. The time the
                              offer was created in UTC.
                        }
                    ],
                    "queueAssignments": {
                        "str": {}  # Optional. The queue(s) that this worker can receive work
                          from.
                    },
                    "state": "str",  # Optional. The current state of the worker. Known values
                      are: "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker.
                    },
                    "totalCapacity": 0  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                }
        """

    @distributed_trace_async
    async def upsert_worker(self, worker_id: str, patch: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Creates or updates a worker.

        Creates or updates a worker.

        :param worker_id: Id of the worker. Required.
        :type worker_id: str
        :param patch: Model of worker properties to be created or patched. See also:
         https://datatracker.ietf.org/doc/html/rfc7386. Is either a JSON type or a IO type. Required.
        :type patch: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are:
         'application/merge-patch+json'. Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                patch = {
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # The Id of the Job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "channelConfigurations": {
                        "str": {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    },
                    "id": "str",  # Optional.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # The Id of the job. Required.
                            "offerId": "str",  # The Id of the offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time
                              that the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. The time the
                              offer was created in UTC.
                        }
                    ],
                    "queueAssignments": {
                        "str": {}  # Optional. The queue(s) that this worker can receive work
                          from.
                    },
                    "state": "str",  # Optional. The current state of the worker. Known values
                      are: "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker.
                    },
                    "totalCapacity": 0  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                }

                # response body for status code(s): 200, 201
                response == {
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # The Id of the Job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "channelConfigurations": {
                        "str": {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    },
                    "id": "str",  # Optional.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # The Id of the job. Required.
                            "offerId": "str",  # The Id of the offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time
                              that the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. The time the
                              offer was created in UTC.
                        }
                    ],
                    "queueAssignments": {
                        "str": {}  # Optional. The queue(s) that this worker can receive work
                          from.
                    },
                    "state": "str",  # Optional. The current state of the worker. Known values
                      are: "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker.
                    },
                    "totalCapacity": 0  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type: Optional[str] = kwargs.pop("content_type", _headers.pop("Content-Type", None))
        cls: ClsType[JSON] = kwargs.pop("cls", None)

        content_type = content_type or "application/merge-patch+json"
        _json = None
        _content = None
        if isinstance(patch, (IOBase, bytes)):
            _content = patch
        else:
            _json = patch

        request = build_job_router_upsert_worker_request(
            worker_id=worker_id,
            content_type=content_type,
            api_version=self._config.api_version,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 201]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.status_code == 200:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 201:
            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})  # type: ignore

        return cast(JSON, deserialized)  # type: ignore

    @distributed_trace_async
    async def get_worker(self, worker_id: str, **kwargs: Any) -> JSON:
        """Retrieves an existing worker by Id.

        Retrieves an existing worker by Id.

        :param worker_id: Id of the worker to retrieve. Required.
        :type worker_id: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "assignedJobs": [
                        {
                            "assignedAt": "2020-02-20 00:00:00",  # The assignment time
                              of the job in UTC. Required.
                            "assignmentId": "str",  # The Id of the assignment. Required.
                            "capacityCost": 0,  # The amount of capacity this assignment
                              has consumed on the worker. Required.
                            "jobId": "str"  # The Id of the Job assigned. Required.
                        }
                    ],
                    "availableForOffers": bool,  # Optional. A flag indicating this worker is
                      open to receive offers or not.
                    "channelConfigurations": {
                        "str": {
                            "capacityCostPerJob": 0,  # The amount of capacity that an
                              instance of a job of this channel will consume of the total worker
                              capacity. Required.
                            "maxNumberOfJobs": 0  # Optional. The maximum number of jobs
                              that can be supported concurrently for this channel.
                        }
                    },
                    "id": "str",  # Optional.
                    "labels": {
                        "str": {}  # Optional. A set of key/value pairs that are identifying
                          attributes used by the rules engines to make decisions.
                    },
                    "loadRatio": 0.0,  # Optional. A value indicating the workers capacity. A
                      value of '1' means all capacity is consumed. A value of '0' means no capacity is
                      currently consumed.
                    "offers": [
                        {
                            "capacityCost": 0,  # The capacity cost consumed by the job
                              offer. Required.
                            "jobId": "str",  # The Id of the job. Required.
                            "offerId": "str",  # The Id of the offer. Required.
                            "expiresAt": "2020-02-20 00:00:00",  # Optional. The time
                              that the offer will expire in UTC.
                            "offeredAt": "2020-02-20 00:00:00"  # Optional. The time the
                              offer was created in UTC.
                        }
                    ],
                    "queueAssignments": {
                        "str": {}  # Optional. The queue(s) that this worker can receive work
                          from.
                    },
                    "state": "str",  # Optional. The current state of the worker. Known values
                      are: "active", "draining", and "inactive".
                    "tags": {
                        "str": {}  # Optional. A set of non-identifying attributes attached
                          to this worker.
                    },
                    "totalCapacity": 0  # Optional. The total capacity score this worker has to
                      manage multiple concurrent jobs.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        request = build_job_router_get_worker_request(
            worker_id=worker_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), {})

        return cast(JSON, deserialized)

    @distributed_trace_async
    async def delete_worker(  # pylint: disable=inconsistent-return-statements
        self, worker_id: str, **kwargs: Any
    ) -> None:
        """Deletes a worker and all of its traces.

        Deletes a worker and all of its traces.

        :param worker_id: Id of the worker to delete. Required.
        :type worker_id: str
        :return: None
        :rtype: None
        :raises ~azure.core.exceptions.HttpResponseError:
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[None] = kwargs.pop("cls", None)

        request = build_job_router_delete_worker_request(
            worker_id=worker_id,
            api_version=self._config.api_version,
            headers=_headers,
            params=_params,
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, "str", skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        _stream = False
        pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
            request, stream=_stream, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    @distributed_trace
    def list_workers(
        self,
        *,
        state: str = "all",
        channel_id: Optional[str] = None,
        queue_id: Optional[str] = None,
        has_capacity: Optional[bool] = None,
        **kwargs: Any
    ) -> AsyncIterable[JSON]:
        """Retrieves existing workers.

        Retrieves existing workers.

        :keyword state: If specified, select workers by worker state. Known values are: "active",
         "draining", "inactive", and "all". Default value is "all".
        :paramtype state: str
        :keyword channel_id: If specified, select workers who have a channel configuration with this
         channel. Default value is None.
        :paramtype channel_id: str
        :keyword queue_id: If specified, select workers who are assigned to this queue. Default value
         is None.
        :paramtype queue_id: str
        :keyword has_capacity: If set to true, select only workers who have capacity for the channel
         specified by ``channelId`` or for any channel
                     if ``channelId`` not specified. If set to false, then will return all workers
         including workers without any capacity for jobs. Defaults to false. Default value is None.
        :paramtype has_capacity: bool
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[JSON]
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "etag": "str",  # Optional. (Optional) The Concurrency Token.
                    "worker": {
                        "assignedJobs": [
                            {
                                "assignedAt": "2020-02-20 00:00:00",  # The
                                  assignment time of the job in UTC. Required.
                                "assignmentId": "str",  # The Id of the assignment.
                                  Required.
                                "capacityCost": 0,  # The amount of capacity this
                                  assignment has consumed on the worker. Required.
                                "jobId": "str"  # The Id of the Job assigned.
                                  Required.
                            }
                        ],
                        "availableForOffers": bool,  # Optional. A flag indicating this
                          worker is open to receive offers or not.
                        "channelConfigurations": {
                            "str": {
                                "capacityCostPerJob": 0,  # The amount of capacity
                                  that an instance of a job of this channel will consume of the total
                                  worker capacity. Required.
                                "maxNumberOfJobs": 0  # Optional. The maximum number
                                  of jobs that can be supported concurrently for this channel.
                            }
                        },
                        "id": "str",  # Optional. An entity for jobs to be routed to.
                        "labels": {
                            "str": {}  # Optional. A set of key/value pairs that are
                              identifying attributes used by the rules engines to make decisions.
                        },
                        "loadRatio": 0.0,  # Optional. A value indicating the workers
                          capacity. A value of '1' means all capacity is consumed. A value of '0' means
                          no capacity is currently consumed.
                        "offers": [
                            {
                                "capacityCost": 0,  # The capacity cost consumed by
                                  the job offer. Required.
                                "jobId": "str",  # The Id of the job. Required.
                                "offerId": "str",  # The Id of the offer. Required.
                                "expiresAt": "2020-02-20 00:00:00",  # Optional. The
                                  time that the offer will expire in UTC.
                                "offeredAt": "2020-02-20 00:00:00"  # Optional. The
                                  time the offer was created in UTC.
                            }
                        ],
                        "queueAssignments": {
                            "str": {}  # Optional. The queue(s) that this worker can
                              receive work from.
                        },
                        "state": "str",  # Optional. The current state of the worker. Known
                          values are: "active", "draining", and "inactive".
                        "tags": {
                            "str": {}  # Optional. A set of non-identifying attributes
                              attached to this worker.
                        },
                        "totalCapacity": 0  # Optional. The total capacity score this worker
                          has to manage multiple concurrent jobs.
                    }
                }
        """
        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls: ClsType[JSON] = kwargs.pop("cls", None)

        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
            304: ResourceNotModifiedError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        def prepare_request(next_link=None):
            if not next_link:

                request = build_job_router_list_workers_request(
                    state=state,
                    channel_id=channel_id,
                    queue_id=queue_id,
                    has_capacity=has_capacity,
                    api_version=self._config.api_version,
                    headers=_headers,
                    params=_params,
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                # make call to next link with the client's api-version
                _parsed_next_link = urllib.parse.urlparse(next_link)
                _next_request_params = case_insensitive_dict(
                    {
                        key: [urllib.parse.quote(v) for v in value]
                        for key, value in urllib.parse.parse_qs(_parsed_next_link.query).items()
                    }
                )
                _next_request_params["api-version"] = self._config.api_version
                request = HttpRequest(
                    "GET", urllib.parse.urljoin(next_link, _parsed_next_link.path), params=_next_request_params
                )
                path_format_arguments = {
                    "endpoint": self._serialize.url(
                        "self._config.endpoint", self._config.endpoint, "str", skip_quote=True
                    ),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            return request

        async def extract_data(pipeline_response):
            deserialized = pipeline_response.http_response.json()
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)  # type: ignore
            return deserialized.get("nextLink") or None, AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            _stream = False
            pipeline_response: PipelineResponse = await self._client._pipeline.run(  # pylint: disable=protected-access
                request, stream=_stream, **kwargs
            )
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response

        return AsyncItemPaged(get_next, extract_data)
