; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -reassociate -instcombine -S | FileCheck %s

; Test that we can turn things like X*-(Y*Z) -> X*-1*Y*Z.

define i32 @test1(i32 %a, i32 %b, i32 %z) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    [[E:%.*]] = mul i32 [[A:%.*]], 12345
; CHECK-NEXT:    [[F:%.*]] = mul i32 [[E]], [[B:%.*]]
; CHECK-NEXT:    [[G:%.*]] = mul i32 [[F]], [[Z:%.*]]
; CHECK-NEXT:    ret i32 [[G]]
;
  %c = sub i32 0, %z
  %d = mul i32 %a, %b
  %e = mul i32 %c, %d
  %f = mul i32 %e, 12345
  %g = sub i32 0, %f
  ret i32 %g
}

define i32 @test2(i32 %a, i32 %b, i32 %z) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    [[E:%.*]] = mul i32 [[A:%.*]], 40
; CHECK-NEXT:    [[F:%.*]] = mul i32 [[E]], [[Z:%.*]]
; CHECK-NEXT:    ret i32 [[F]]
;
  %d = mul i32 %z, 40
  %c = sub i32 0, %d
  %e = mul i32 %a, %c
  %f = sub i32 0, %e
  ret i32 %f
}

define <2 x i32> @negate_vec_undefs(<2 x i32> %a, <2 x i32> %b, <2 x i32> %z) {
; CHECK-LABEL: @negate_vec_undefs(
; CHECK-NEXT:    [[E:%.*]] = mul <2 x i32> [[A:%.*]], <i32 40, i32 40>
; CHECK-NEXT:    [[F:%.*]] = mul <2 x i32> [[E]], [[Z:%.*]]
; CHECK-NEXT:    ret <2 x i32> [[F]]
;
  %d = mul <2 x i32> %z, <i32 40, i32 40>
  %c = sub <2 x i32> <i32 0, i32 undef>, %d
  %e = mul <2 x i32> %a, %c
  %f = sub <2 x i32> <i32 0, i32 undef>, %e
  ret <2 x i32> %f
}

