/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core;

import com.sun.jimi.core.InvalidOptionException;
import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.JimiControl;
import com.sun.jimi.core.JimiEncoder;
import com.sun.jimi.core.JimiEncoderFactory;
import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.JimiImage;
import com.sun.jimi.core.JimiImageEnumeration;
import com.sun.jimi.core.MutableJimiImage;
import com.sun.jimi.core.options.BasicFormatOptionSet;
import com.sun.jimi.core.options.FormatOption;
import com.sun.jimi.core.options.FormatOptionSet;
import com.sun.jimi.core.options.OptionException;
import com.sun.jimi.core.util.FreeFormat;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.ProgressListener;
import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;

public class JimiWriter {
    protected JimiEncoder encoder;
    protected JimiImage sourceImage;
    protected JimiImageEnumeration sourceImageEnumeration;
    protected FormatOptionSet options = new BasicFormatOptionSet();
    protected FormatOptionSet overrideOptions;
    protected ProgressListener listener;

    protected JimiWriter() {
    }

    protected JimiWriter(OutputStream outputStream, String string) throws JimiException {
        JimiEncoderFactory jimiEncoderFactory = JimiControl.getEncoderByType(string);
        if (jimiEncoderFactory == null) {
            throw new JimiException("Cannot find encoder for type: " + string);
        }
        this.initJimiWriter(jimiEncoderFactory);
    }

    protected JimiWriter(String string) throws JimiException {
        JimiEncoderFactory jimiEncoderFactory = JimiControl.getEncoderByFileExtension(string);
        if (jimiEncoderFactory == null) {
            throw new JimiException("Cannot find encoder for " + string);
        }
        this.initJimiWriter(jimiEncoderFactory);
    }

    protected JimiWriter(String string, String string2) throws JimiException {
        JimiEncoderFactory jimiEncoderFactory = JimiControl.getEncoderByType(string2);
        if (jimiEncoderFactory == null) {
            throw new JimiException("Cannot find encoder for type: " + string2);
        }
        this.initJimiWriter(jimiEncoderFactory);
    }

    public void clearProperties() {
        this.options = new BasicFormatOptionSet();
    }

    public Object getPossibleValuesForProperty(String string) throws InvalidOptionException {
        try {
            return this.options.getOption(string).getPossibleValues();
        }
        catch (OptionException optionException) {
            throw new InvalidOptionException(optionException.getMessage());
        }
    }

    public Object getProperty(String string) {
        try {
            return this.options.getOption(string).getValue();
        }
        catch (OptionException optionException) {
            return null;
        }
    }

    public String getPropertyDescription(String string) throws InvalidOptionException {
        try {
            return this.options.getOption(string).getDescription();
        }
        catch (OptionException optionException) {
            throw new InvalidOptionException(optionException.getMessage());
        }
    }

    public Enumeration getPropertyNames() {
        final FormatOption[] formatOptionArray = this.options.getOptions();
        return new Enumeration(){
            int index = 0;

            public boolean hasMoreElements() {
                return this.index < formatOptionArray.length;
            }

            public Object nextElement() {
                return formatOptionArray[this.index++];
            }
        };
    }

    protected void initJimiWriter(JimiEncoderFactory jimiEncoderFactory) throws JimiException {
        if (Jimi.crippled) {
            throw new JimiException("Keyless operations does not permit saving.");
        }
        if (Jimi.limited && !(jimiEncoderFactory instanceof FreeFormat)) {
            throw new JimiException("This format requires a JIMI Pro license.");
        }
        this.encoder = jimiEncoderFactory.createEncoder();
        if (this.listener != null) {
            this.encoder.setProgressListener(this.listener);
        }
    }

    public void putImage(OutputStream outputStream) throws JimiException {
        if (this.sourceImage != null) {
            this.sourceImage.setOptions(this.options);
            this.encoder.encodeImages(new JimiImageEnumeration(this.sourceImage), outputStream);
        } else if (this.sourceImageEnumeration != null) {
            this.sourceImageEnumeration.setOptions(this.options);
            this.encoder.encodeImages(this.sourceImageEnumeration, outputStream);
        } else {
            throw new JimiException("No source image set.");
        }
    }

    public void putImage(String string) throws JimiException {
        try {
            OutputStream outputStream = new FileOutputStream(string);
            outputStream = new BufferedOutputStream(outputStream);
            this.putImage(outputStream);
            outputStream.close();
        }
        catch (IOException iOException) {
            throw new JimiException();
        }
    }

    protected void setMimeType(String string) throws JimiException {
        JimiEncoderFactory jimiEncoderFactory = JimiControl.getEncoderByType(string);
        if (jimiEncoderFactory == null) {
            throw new JimiException("Cannot find encoder for type: " + string);
        }
        this.initJimiWriter(jimiEncoderFactory);
    }

    public void setOptions(FormatOptionSet formatOptionSet) {
        this.options = formatOptionSet;
        this.overrideOptions = formatOptionSet;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.listener = progressListener;
        if (this.encoder != null) {
            this.encoder.setProgressListener(progressListener);
        }
    }

    public void setProperty(String string, Object object) throws InvalidOptionException {
        try {
            this.options.getOption(string).setValue(object);
        }
        catch (OptionException optionException) {
            throw new InvalidOptionException(optionException.getMessage());
        }
    }

    public void setSource(JimiImage jimiImage) throws JimiException {
        this.sourceImage = JimiUtil.asJimiRasterImage(jimiImage);
        if (this.overrideOptions != null) {
            ((MutableJimiImage)this.sourceImage).setOptions(this.overrideOptions);
        }
    }

    public void setSource(Image image) throws JimiException {
        this.setSource(image.getSource());
    }

    public void setSource(ImageProducer imageProducer) throws JimiException {
        try {
            this.sourceImage = Jimi.createRasterImage(imageProducer);
        }
        catch (JimiException jimiException) {}
    }

    public void setSource(JimiImage[] jimiImageArray) throws JimiException {
        this.sourceImageEnumeration = new JimiImageEnumeration(jimiImageArray);
    }

    public void setSource(Image[] imageArray) throws JimiException {
        this.sourceImageEnumeration = new JimiImageEnumeration(imageArray);
    }

    public void setSource(ImageProducer[] imageProducerArray) throws JimiException {
        this.sourceImageEnumeration = new JimiImageEnumeration(imageProducerArray);
    }

    public void setSource(Object[] objectArray) throws JimiException {
        if (objectArray instanceof JimiImage[]) {
            this.setSource((JimiImage[])objectArray);
        } else if (objectArray instanceof ImageProducer[]) {
            this.setSource((ImageProducer[])objectArray);
        } else if (objectArray instanceof Image[]) {
            this.setSource((Image[])objectArray);
        } else {
            throw new JimiException("Invalid source.");
        }
    }
}

