/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.spi;

import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.event.InPlayListener;
import ch.qos.logback.core.joran.event.SaxEvent;
import ch.qos.logback.core.joran.spi.Interpreter;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.util.OptionHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpretationContext
extends ContextAwareBase {
    Stack<Object> objectStack;
    Map<String, Object> objectMap;
    Map<String, String> substitutionMap;
    Interpreter joranInterpreter;
    final List<InPlayListener> listenerList = new ArrayList<InPlayListener>();

    public InterpretationContext(Context context, Interpreter joranInterpreter) {
        this.joranInterpreter = joranInterpreter;
        this.objectStack = new Stack();
        this.objectMap = new HashMap<String, Object>(5);
        this.substitutionMap = new HashMap<String, String>();
    }

    String updateLocationInfo(String msg) {
        Locator locator = this.joranInterpreter.getLocator();
        if (locator != null) {
            return String.valueOf(msg) + locator.getLineNumber() + ":" + locator.getColumnNumber();
        }
        return msg;
    }

    public Locator getLocator() {
        return this.joranInterpreter.getLocator();
    }

    public Interpreter getJoranInterpreter() {
        return this.joranInterpreter;
    }

    public Stack<Object> getObjectStack() {
        return this.objectStack;
    }

    public boolean isEmpty() {
        return this.objectStack.isEmpty();
    }

    public Object peekObject() {
        return this.objectStack.peek();
    }

    public void pushObject(Object o) {
        this.objectStack.push(o);
    }

    public Object popObject() {
        return this.objectStack.pop();
    }

    public Object getObject(int i) {
        return this.objectStack.get(i);
    }

    public Map<String, Object> getObjectMap() {
        return this.objectMap;
    }

    public void addSubstitutionProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        value = value.trim();
        this.substitutionMap.put(key, value);
    }

    public void addSubstitutionProperties(Properties props) {
        if (props == null) {
            return;
        }
        for (String string : props.keySet()) {
            this.addSubstitutionProperty(string, props.getProperty(string));
        }
    }

    public void addSubstitutionProperties(Map<String, String> propertyMap) {
        if (propertyMap == null) {
            return;
        }
        for (String key : propertyMap.keySet()) {
            this.addSubstitutionProperty(key, propertyMap.get(key));
        }
    }

    public String getSubstitutionProperty(String key) {
        return this.substitutionMap.get(key);
    }

    public String subst(String value) {
        if (value == null) {
            return null;
        }
        return OptionHelper.substVars(value, this.substitutionMap, this.context.getPropertyMap());
    }

    public void addInPlayListener(InPlayListener ipl) {
        if (this.listenerList.contains(ipl)) {
            this.addWarn("InPlayListener " + ipl + " has been already registered");
        } else {
            this.listenerList.add(ipl);
        }
    }

    public boolean removeInPlayListener(InPlayListener ipl) {
        return this.listenerList.remove(ipl);
    }

    void fireInPlay(SaxEvent event) {
        for (InPlayListener ipl : this.listenerList) {
            ipl.inPlay(event);
        }
    }
}

