# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ApiKey(_serialization.Model):
    """An API key used for authenticating with a configuration store endpoint.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The key ID.
    :vartype id: str
    :ivar name: A name for the key describing its usage.
    :vartype name: str
    :ivar value: The value of the key that is used for authentication purposes.
    :vartype value: str
    :ivar connection_string: A connection string that can be used by supporting clients for
     authentication.
    :vartype connection_string: str
    :ivar last_modified: The last time any of the key's properties were modified.
    :vartype last_modified: ~datetime.datetime
    :ivar read_only: Whether this key can only be used for read operations.
    :vartype read_only: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "value": {"readonly": True},
        "connection_string": {"readonly": True},
        "last_modified": {"readonly": True},
        "read_only": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "str"},
        "connection_string": {"key": "connectionString", "type": "str"},
        "last_modified": {"key": "lastModified", "type": "iso-8601"},
        "read_only": {"key": "readOnly", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.value = None
        self.connection_string = None
        self.last_modified = None
        self.read_only = None


class ApiKeyListResult(_serialization.Model):
    """The result of a request to list API keys.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.ApiKey]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApiKey]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.ApiKey"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.ApiKey]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CheckNameAvailabilityParameters(_serialization.Model):
    """Parameters used for checking whether a resource name is available.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name to check for availability. Required.
    :vartype name: str
    :ivar type: The resource type to check for name availability. Required.
     "Microsoft.AppConfiguration/configurationStores"
    :vartype type: str or ~azure.mgmt.appconfiguration.v2022_05_01.models.ConfigurationResourceType
    """

    _validation = {
        "name": {"required": True},
        "type": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, name: str, type: Union[str, "_models.ConfigurationResourceType"], **kwargs: Any) -> None:
        """
        :keyword name: The name to check for availability. Required.
        :paramtype name: str
        :keyword type: The resource type to check for name availability. Required.
         "Microsoft.AppConfiguration/configurationStores"
        :paramtype type: str or
         ~azure.mgmt.appconfiguration.v2022_05_01.models.ConfigurationResourceType
        """
        super().__init__(**kwargs)
        self.name = name
        self.type = type


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class ConfigurationStore(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """The configuration store along with all resource properties. The Configuration Store will have
    all information to begin utilizing it.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The managed identity information, if configured.
    :vartype identity: ~azure.mgmt.appconfiguration.v2022_05_01.models.ResourceIdentity
    :ivar sku: The sku of the configuration store. Required.
    :vartype sku: ~azure.mgmt.appconfiguration.v2022_05_01.models.Sku
    :ivar system_data: Resource system metadata.
    :vartype system_data: ~azure.mgmt.appconfiguration.v2022_05_01.models.SystemData
    :ivar provisioning_state: The provisioning state of the configuration store. Known values are:
     "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.appconfiguration.v2022_05_01.models.ProvisioningState
    :ivar creation_date: The creation date of configuration store.
    :vartype creation_date: ~datetime.datetime
    :ivar endpoint: The DNS endpoint where the configuration store API will be available.
    :vartype endpoint: str
    :ivar encryption: The encryption settings of the configuration store.
    :vartype encryption: ~azure.mgmt.appconfiguration.v2022_05_01.models.EncryptionProperties
    :ivar private_endpoint_connections: The list of private endpoint connections that are set up
     for this resource.
    :vartype private_endpoint_connections:
     list[~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateEndpointConnectionReference]
    :ivar public_network_access: Control permission for data plane traffic coming from public
     networks while private endpoint is enabled. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.appconfiguration.v2022_05_01.models.PublicNetworkAccess
    :ivar disable_local_auth: Disables all authentication methods other than AAD authentication.
    :vartype disable_local_auth: bool
    :ivar soft_delete_retention_in_days: The amount of time in days that the configuration store
     will be retained when it is soft deleted.
    :vartype soft_delete_retention_in_days: int
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this configuration store.
    :vartype enable_purge_protection: bool
    :ivar create_mode: Indicates whether the configuration store need to be recovered. Known values
     are: "Recover" and "Default".
    :vartype create_mode: str or ~azure.mgmt.appconfiguration.v2022_05_01.models.CreateMode
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
        "sku": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "creation_date": {"readonly": True},
        "endpoint": {"readonly": True},
        "private_endpoint_connections": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "sku": {"key": "sku", "type": "Sku"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "creation_date": {"key": "properties.creationDate", "type": "iso-8601"},
        "endpoint": {"key": "properties.endpoint", "type": "str"},
        "encryption": {"key": "properties.encryption", "type": "EncryptionProperties"},
        "private_endpoint_connections": {
            "key": "properties.privateEndpointConnections",
            "type": "[PrivateEndpointConnectionReference]",
        },
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "soft_delete_retention_in_days": {"key": "properties.softDeleteRetentionInDays", "type": "int"},
        "enable_purge_protection": {"key": "properties.enablePurgeProtection", "type": "bool"},
        "create_mode": {"key": "properties.createMode", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        encryption: Optional["_models.EncryptionProperties"] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        disable_local_auth: bool = False,
        soft_delete_retention_in_days: int = 7,
        enable_purge_protection: bool = False,
        create_mode: Optional[Union[str, "_models.CreateMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The managed identity information, if configured.
        :paramtype identity: ~azure.mgmt.appconfiguration.v2022_05_01.models.ResourceIdentity
        :keyword sku: The sku of the configuration store. Required.
        :paramtype sku: ~azure.mgmt.appconfiguration.v2022_05_01.models.Sku
        :keyword encryption: The encryption settings of the configuration store.
        :paramtype encryption: ~azure.mgmt.appconfiguration.v2022_05_01.models.EncryptionProperties
        :keyword public_network_access: Control permission for data plane traffic coming from public
         networks while private endpoint is enabled. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.appconfiguration.v2022_05_01.models.PublicNetworkAccess
        :keyword disable_local_auth: Disables all authentication methods other than AAD authentication.
        :paramtype disable_local_auth: bool
        :keyword soft_delete_retention_in_days: The amount of time in days that the configuration store
         will be retained when it is soft deleted.
        :paramtype soft_delete_retention_in_days: int
        :keyword enable_purge_protection: Property specifying whether protection against purge is
         enabled for this configuration store.
        :paramtype enable_purge_protection: bool
        :keyword create_mode: Indicates whether the configuration store need to be recovered. Known
         values are: "Recover" and "Default".
        :paramtype create_mode: str or ~azure.mgmt.appconfiguration.v2022_05_01.models.CreateMode
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.sku = sku
        self.system_data = None
        self.provisioning_state = None
        self.creation_date = None
        self.endpoint = None
        self.encryption = encryption
        self.private_endpoint_connections = None
        self.public_network_access = public_network_access
        self.disable_local_auth = disable_local_auth
        self.soft_delete_retention_in_days = soft_delete_retention_in_days
        self.enable_purge_protection = enable_purge_protection
        self.create_mode = create_mode


class ConfigurationStoreListResult(_serialization.Model):
    """The result of a request to list configuration stores.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.ConfigurationStore]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConfigurationStore]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConfigurationStore"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.ConfigurationStore]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConfigurationStoreUpdateParameters(_serialization.Model):
    """The parameters for updating a configuration store.

    :ivar identity: The managed identity information for the configuration store.
    :vartype identity: ~azure.mgmt.appconfiguration.v2022_05_01.models.ResourceIdentity
    :ivar sku: The SKU of the configuration store.
    :vartype sku: ~azure.mgmt.appconfiguration.v2022_05_01.models.Sku
    :ivar tags: The ARM resource tags.
    :vartype tags: dict[str, str]
    :ivar encryption: The encryption settings of the configuration store.
    :vartype encryption: ~azure.mgmt.appconfiguration.v2022_05_01.models.EncryptionProperties
    :ivar disable_local_auth: Disables all authentication methods other than AAD authentication.
    :vartype disable_local_auth: bool
    :ivar public_network_access: Control permission for data plane traffic coming from public
     networks while private endpoint is enabled. Known values are: "Enabled" and "Disabled".
    :vartype public_network_access: str or
     ~azure.mgmt.appconfiguration.v2022_05_01.models.PublicNetworkAccess
    :ivar enable_purge_protection: Property specifying whether protection against purge is enabled
     for this configuration store.
    :vartype enable_purge_protection: bool
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "sku": {"key": "sku", "type": "Sku"},
        "tags": {"key": "tags", "type": "{str}"},
        "encryption": {"key": "properties.encryption", "type": "EncryptionProperties"},
        "disable_local_auth": {"key": "properties.disableLocalAuth", "type": "bool"},
        "public_network_access": {"key": "properties.publicNetworkAccess", "type": "str"},
        "enable_purge_protection": {"key": "properties.enablePurgeProtection", "type": "bool"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ResourceIdentity"] = None,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
        encryption: Optional["_models.EncryptionProperties"] = None,
        disable_local_auth: Optional[bool] = None,
        public_network_access: Optional[Union[str, "_models.PublicNetworkAccess"]] = None,
        enable_purge_protection: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The managed identity information for the configuration store.
        :paramtype identity: ~azure.mgmt.appconfiguration.v2022_05_01.models.ResourceIdentity
        :keyword sku: The SKU of the configuration store.
        :paramtype sku: ~azure.mgmt.appconfiguration.v2022_05_01.models.Sku
        :keyword tags: The ARM resource tags.
        :paramtype tags: dict[str, str]
        :keyword encryption: The encryption settings of the configuration store.
        :paramtype encryption: ~azure.mgmt.appconfiguration.v2022_05_01.models.EncryptionProperties
        :keyword disable_local_auth: Disables all authentication methods other than AAD authentication.
        :paramtype disable_local_auth: bool
        :keyword public_network_access: Control permission for data plane traffic coming from public
         networks while private endpoint is enabled. Known values are: "Enabled" and "Disabled".
        :paramtype public_network_access: str or
         ~azure.mgmt.appconfiguration.v2022_05_01.models.PublicNetworkAccess
        :keyword enable_purge_protection: Property specifying whether protection against purge is
         enabled for this configuration store.
        :paramtype enable_purge_protection: bool
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.sku = sku
        self.tags = tags
        self.encryption = encryption
        self.disable_local_auth = disable_local_auth
        self.public_network_access = public_network_access
        self.enable_purge_protection = enable_purge_protection


class DeletedConfigurationStore(_serialization.Model):
    """Deleted configuration store information with extended details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID for the deleted configuration store.
    :vartype id: str
    :ivar name: The name of the configuration store.
    :vartype name: str
    :ivar type: The resource type of the configuration store.
    :vartype type: str
    :ivar configuration_store_id: The resource id of the original configuration store.
    :vartype configuration_store_id: str
    :ivar location: The location of the original configuration store.
    :vartype location: str
    :ivar deletion_date: The deleted date.
    :vartype deletion_date: ~datetime.datetime
    :ivar scheduled_purge_date: The scheduled purged date.
    :vartype scheduled_purge_date: ~datetime.datetime
    :ivar tags: Tags of the original configuration store.
    :vartype tags: dict[str, str]
    :ivar purge_protection_enabled: Purge protection status of the original configuration store.
    :vartype purge_protection_enabled: bool
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "configuration_store_id": {"readonly": True},
        "location": {"readonly": True},
        "deletion_date": {"readonly": True},
        "scheduled_purge_date": {"readonly": True},
        "tags": {"readonly": True},
        "purge_protection_enabled": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "configuration_store_id": {"key": "properties.configurationStoreId", "type": "str"},
        "location": {"key": "properties.location", "type": "str"},
        "deletion_date": {"key": "properties.deletionDate", "type": "iso-8601"},
        "scheduled_purge_date": {"key": "properties.scheduledPurgeDate", "type": "iso-8601"},
        "tags": {"key": "properties.tags", "type": "{str}"},
        "purge_protection_enabled": {"key": "properties.purgeProtectionEnabled", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.configuration_store_id = None
        self.location = None
        self.deletion_date = None
        self.scheduled_purge_date = None
        self.tags = None
        self.purge_protection_enabled = None


class DeletedConfigurationStoreListResult(_serialization.Model):
    """List of deleted configuration stores.

    :ivar value: The list of deleted configuration store.
    :vartype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.DeletedConfigurationStore]
    :ivar next_link: The URL to get the next set of deleted configuration stores.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[DeletedConfigurationStore]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.DeletedConfigurationStore"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of deleted configuration store.
        :paramtype value:
         list[~azure.mgmt.appconfiguration.v2022_05_01.models.DeletedConfigurationStore]
        :keyword next_link: The URL to get the next set of deleted configuration stores.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class EncryptionProperties(_serialization.Model):
    """The encryption settings for a configuration store.

    :ivar key_vault_properties: Key vault properties.
    :vartype key_vault_properties:
     ~azure.mgmt.appconfiguration.v2022_05_01.models.KeyVaultProperties
    """

    _attribute_map = {
        "key_vault_properties": {"key": "keyVaultProperties", "type": "KeyVaultProperties"},
    }

    def __init__(self, *, key_vault_properties: Optional["_models.KeyVaultProperties"] = None, **kwargs: Any) -> None:
        """
        :keyword key_vault_properties: Key vault properties.
        :paramtype key_vault_properties:
         ~azure.mgmt.appconfiguration.v2022_05_01.models.KeyVaultProperties
        """
        super().__init__(**kwargs)
        self.key_vault_properties = key_vault_properties


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetails(_serialization.Model):
    """The details of the error.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Error code.
    :vartype code: str
    :ivar message: Error message indicating why the operation failed.
    :vartype message: str
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.appconfiguration.v2022_05_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Error response indicates that the service is not able to process the incoming request. The
    reason is provided in the error message.

    :ivar error: The details of the error.
    :vartype error: ~azure.mgmt.appconfiguration.v2022_05_01.models.ErrorDetails
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetails"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The details of the error.
        :paramtype error: ~azure.mgmt.appconfiguration.v2022_05_01.models.ErrorDetails
        """
        super().__init__(**kwargs)
        self.error = error


class KeyValue(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """The key-value resource along with all resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar key: The primary identifier of a key-value.
     The key is used in unison with the label to uniquely identify a key-value.
    :vartype key: str
    :ivar label: A value used to group key-values.
     The label is used in unison with the key to uniquely identify a key-value.
    :vartype label: str
    :ivar value: The value of the key-value.
    :vartype value: str
    :ivar content_type: The content type of the key-value's value.
     Providing a proper content-type can enable transformations of values when they are retrieved
     by applications.
    :vartype content_type: str
    :ivar e_tag: An ETag indicating the state of a key-value within a configuration store.
    :vartype e_tag: str
    :ivar last_modified: The last time a modifying operation was performed on the given key-value.
    :vartype last_modified: ~datetime.datetime
    :ivar locked: A value indicating whether the key-value is locked.
     A locked key-value may not be modified until it is unlocked.
    :vartype locked: bool
    :ivar tags: A dictionary of tags that can help identify what a key-value may be applicable for.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "key": {"readonly": True},
        "label": {"readonly": True},
        "e_tag": {"readonly": True},
        "last_modified": {"readonly": True},
        "locked": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "key": {"key": "properties.key", "type": "str"},
        "label": {"key": "properties.label", "type": "str"},
        "value": {"key": "properties.value", "type": "str"},
        "content_type": {"key": "properties.contentType", "type": "str"},
        "e_tag": {"key": "properties.eTag", "type": "str"},
        "last_modified": {"key": "properties.lastModified", "type": "iso-8601"},
        "locked": {"key": "properties.locked", "type": "bool"},
        "tags": {"key": "properties.tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        content_type: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The value of the key-value.
        :paramtype value: str
        :keyword content_type: The content type of the key-value's value.
         Providing a proper content-type can enable transformations of values when they are retrieved
         by applications.
        :paramtype content_type: str
        :keyword tags: A dictionary of tags that can help identify what a key-value may be applicable
         for.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.key = None
        self.label = None
        self.value = value
        self.content_type = content_type
        self.e_tag = None
        self.last_modified = None
        self.locked = None
        self.tags = tags


class KeyValueListResult(_serialization.Model):
    """The result of a request to list key-values.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.KeyValue]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[KeyValue]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.KeyValue"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.KeyValue]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class KeyVaultProperties(_serialization.Model):
    """Settings concerning key vault encryption for a configuration store.

    :ivar key_identifier: The URI of the key vault key used to encrypt data.
    :vartype key_identifier: str
    :ivar identity_client_id: The client id of the identity which will be used to access key vault.
    :vartype identity_client_id: str
    """

    _attribute_map = {
        "key_identifier": {"key": "keyIdentifier", "type": "str"},
        "identity_client_id": {"key": "identityClientId", "type": "str"},
    }

    def __init__(
        self, *, key_identifier: Optional[str] = None, identity_client_id: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword key_identifier: The URI of the key vault key used to encrypt data.
        :paramtype key_identifier: str
        :keyword identity_client_id: The client id of the identity which will be used to access key
         vault.
        :paramtype identity_client_id: str
        """
        super().__init__(**kwargs)
        self.key_identifier = key_identifier
        self.identity_client_id = identity_client_id


class LogSpecification(_serialization.Model):
    """Specifications of the Log for Azure Monitoring.

    :ivar name: Name of the log.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the log.
    :vartype display_name: str
    :ivar blob_duration: Blob duration of the log.
    :vartype blob_duration: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "blob_duration": {"key": "blobDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        blob_duration: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the log.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the log.
        :paramtype display_name: str
        :keyword blob_duration: Blob duration of the log.
        :paramtype blob_duration: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.blob_duration = blob_duration


class MetricDimension(_serialization.Model):
    """Specifications of the Dimension of metrics.

    :ivar name: Name of the dimension.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the dimension.
    :vartype display_name: str
    :ivar internal_name: Internal name of the dimension.
    :vartype internal_name: str
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "internal_name": {"key": "internalName", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        internal_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the dimension.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the dimension.
        :paramtype display_name: str
        :keyword internal_name: Internal name of the dimension.
        :paramtype internal_name: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.internal_name = internal_name


class MetricSpecification(_serialization.Model):
    """Specifications of the Metrics for Azure Monitoring.

    :ivar name: Name of the metric.
    :vartype name: str
    :ivar display_name: Localized friendly display name of the metric.
    :vartype display_name: str
    :ivar display_description: Localized friendly description of the metric.
    :vartype display_description: str
    :ivar unit: Unit that makes sense for the metric.
    :vartype unit: str
    :ivar aggregation_type: Only provide one value for this field. Valid values: Average, Minimum,
     Maximum, Total, Count.
    :vartype aggregation_type: str
    :ivar internal_metric_name: Internal metric name.
    :vartype internal_metric_name: str
    :ivar dimensions: Dimensions of the metric.
    :vartype dimensions: list[~azure.mgmt.appconfiguration.v2022_05_01.models.MetricDimension]
    :ivar fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
     duration where no metric is emitted/published.
    :vartype fill_gap_with_zero: bool
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "display_description": {"key": "displayDescription", "type": "str"},
        "unit": {"key": "unit", "type": "str"},
        "aggregation_type": {"key": "aggregationType", "type": "str"},
        "internal_metric_name": {"key": "internalMetricName", "type": "str"},
        "dimensions": {"key": "dimensions", "type": "[MetricDimension]"},
        "fill_gap_with_zero": {"key": "fillGapWithZero", "type": "bool"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        display_name: Optional[str] = None,
        display_description: Optional[str] = None,
        unit: Optional[str] = None,
        aggregation_type: Optional[str] = None,
        internal_metric_name: Optional[str] = None,
        dimensions: Optional[List["_models.MetricDimension"]] = None,
        fill_gap_with_zero: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of the metric.
        :paramtype name: str
        :keyword display_name: Localized friendly display name of the metric.
        :paramtype display_name: str
        :keyword display_description: Localized friendly description of the metric.
        :paramtype display_description: str
        :keyword unit: Unit that makes sense for the metric.
        :paramtype unit: str
        :keyword aggregation_type: Only provide one value for this field. Valid values: Average,
         Minimum, Maximum, Total, Count.
        :paramtype aggregation_type: str
        :keyword internal_metric_name: Internal metric name.
        :paramtype internal_metric_name: str
        :keyword dimensions: Dimensions of the metric.
        :paramtype dimensions: list[~azure.mgmt.appconfiguration.v2022_05_01.models.MetricDimension]
        :keyword fill_gap_with_zero: Optional. If set to true, then zero will be returned for time
         duration where no metric is emitted/published.
        :paramtype fill_gap_with_zero: bool
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.display_description = display_description
        self.unit = unit
        self.aggregation_type = aggregation_type
        self.internal_metric_name = internal_metric_name
        self.dimensions = dimensions
        self.fill_gap_with_zero = fill_gap_with_zero


class NameAvailabilityStatus(_serialization.Model):
    """The result of a request to check the availability of a resource name.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name_available: The value indicating whether the resource name is available.
    :vartype name_available: bool
    :ivar message: If any, the error message that provides more detail for the reason that the name
     is not available.
    :vartype message: str
    :ivar reason: If any, the reason that the name is not available.
    :vartype reason: str
    """

    _validation = {
        "name_available": {"readonly": True},
        "message": {"readonly": True},
        "reason": {"readonly": True},
    }

    _attribute_map = {
        "name_available": {"key": "nameAvailable", "type": "bool"},
        "message": {"key": "message", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name_available = None
        self.message = None
        self.reason = None


class OperationDefinition(_serialization.Model):
    """The definition of a configuration store operation.

    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    :ivar display: The display information for the configuration store operation.
    :vartype display: ~azure.mgmt.appconfiguration.v2022_05_01.models.OperationDefinitionDisplay
    :ivar origin: Origin of the operation.
    :vartype origin: str
    :ivar properties: Properties of the operation.
    :vartype properties: ~azure.mgmt.appconfiguration.v2022_05_01.models.OperationProperties
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "display": {"key": "display", "type": "OperationDefinitionDisplay"},
        "origin": {"key": "origin", "type": "str"},
        "properties": {"key": "properties", "type": "OperationProperties"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        is_data_action: Optional[bool] = None,
        display: Optional["_models.OperationDefinitionDisplay"] = None,
        origin: Optional[str] = None,
        properties: Optional["_models.OperationProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Operation name: {provider}/{resource}/{operation}.
        :paramtype name: str
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        :keyword display: The display information for the configuration store operation.
        :paramtype display: ~azure.mgmt.appconfiguration.v2022_05_01.models.OperationDefinitionDisplay
        :keyword origin: Origin of the operation.
        :paramtype origin: str
        :keyword properties: Properties of the operation.
        :paramtype properties: ~azure.mgmt.appconfiguration.v2022_05_01.models.OperationProperties
        """
        super().__init__(**kwargs)
        self.name = name
        self.is_data_action = is_data_action
        self.display = display
        self.origin = origin
        self.properties = properties


class OperationDefinitionDisplay(_serialization.Model):
    """The display information for a configuration store operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar provider: The resource provider name: Microsoft App Configuration.".
    :vartype provider: str
    :ivar resource: The resource on which the operation is performed.
    :vartype resource: str
    :ivar operation: The operation that users can perform.
    :vartype operation: str
    :ivar description: The description for the operation.
    :vartype description: str
    """

    _validation = {
        "provider": {"readonly": True},
    }

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource: The resource on which the operation is performed.
        :paramtype resource: str
        :keyword operation: The operation that users can perform.
        :paramtype operation: str
        :keyword description: The description for the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = None
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationDefinitionListResult(_serialization.Model):
    """The result of a request to list configuration store operations.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.OperationDefinition]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationDefinition]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.OperationDefinition"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.OperationDefinition]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OperationProperties(_serialization.Model):
    """Extra Operation properties.

    :ivar service_specification: Service specifications of the operation.
    :vartype service_specification:
     ~azure.mgmt.appconfiguration.v2022_05_01.models.ServiceSpecification
    """

    _attribute_map = {
        "service_specification": {"key": "serviceSpecification", "type": "ServiceSpecification"},
    }

    def __init__(
        self, *, service_specification: Optional["_models.ServiceSpecification"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword service_specification: Service specifications of the operation.
        :paramtype service_specification:
         ~azure.mgmt.appconfiguration.v2022_05_01.models.ServiceSpecification
        """
        super().__init__(**kwargs)
        self.service_specification = service_specification


class PrivateEndpoint(_serialization.Model):
    """Private endpoint which a connection belongs to.

    :ivar id: The resource Id for private endpoint.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The resource Id for private endpoint.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PrivateEndpointConnection(_serialization.Model):
    """A private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar provisioning_state: The provisioning status of the private endpoint connection. Known
     values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.appconfiguration.v2022_05_01.models.ProvisioningState
    :ivar private_endpoint: The resource of private endpoint.
    :vartype private_endpoint: ~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private endpoint.
        :paramtype private_endpoint: ~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateEndpointConnectionListResult(_serialization.Model):
    """A list of private endpoint connections.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateEndpointConnection]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateEndpointConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateEndpointConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value:
         list[~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateEndpointConnection]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateEndpointConnectionReference(_serialization.Model):
    """A reference to a related private endpoint connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar provisioning_state: The provisioning status of the private endpoint connection. Known
     values are: "Creating", "Updating", "Deleting", "Succeeded", "Failed", and "Canceled".
    :vartype provisioning_state: str or
     ~azure.mgmt.appconfiguration.v2022_05_01.models.ProvisioningState
    :ivar private_endpoint: The resource of private endpoint.
    :vartype private_endpoint: ~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateEndpoint
    :ivar private_link_service_connection_state: A collection of information about the state of the
     connection between service consumer and provider.
    :vartype private_link_service_connection_state:
     ~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateLinkServiceConnectionState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_endpoint": {"key": "properties.privateEndpoint", "type": "PrivateEndpoint"},
        "private_link_service_connection_state": {
            "key": "properties.privateLinkServiceConnectionState",
            "type": "PrivateLinkServiceConnectionState",
        },
    }

    def __init__(
        self,
        *,
        private_endpoint: Optional["_models.PrivateEndpoint"] = None,
        private_link_service_connection_state: Optional["_models.PrivateLinkServiceConnectionState"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword private_endpoint: The resource of private endpoint.
        :paramtype private_endpoint: ~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateEndpoint
        :keyword private_link_service_connection_state: A collection of information about the state of
         the connection between service consumer and provider.
        :paramtype private_link_service_connection_state:
         ~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateLinkServiceConnectionState
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.provisioning_state = None
        self.private_endpoint = private_endpoint
        self.private_link_service_connection_state = private_link_service_connection_state


class PrivateLinkResource(_serialization.Model):
    """A resource that supports private link capabilities.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The resource ID.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource.
    :vartype type: str
    :ivar group_id: The private link resource group id.
    :vartype group_id: str
    :ivar required_members: The private link resource required member names.
    :vartype required_members: list[str]
    :ivar required_zone_names: The list of required DNS zone names of the private link resource.
    :vartype required_zone_names: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "group_id": {"readonly": True},
        "required_members": {"readonly": True},
        "required_zone_names": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "group_id": {"key": "properties.groupId", "type": "str"},
        "required_members": {"key": "properties.requiredMembers", "type": "[str]"},
        "required_zone_names": {"key": "properties.requiredZoneNames", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.group_id = None
        self.required_members = None
        self.required_zone_names = None


class PrivateLinkResourceListResult(_serialization.Model):
    """A list of private link resources.

    :ivar value: The collection value.
    :vartype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateLinkResource]
    :ivar next_link: The URI that can be used to request the next set of paged results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PrivateLinkResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PrivateLinkResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The collection value.
        :paramtype value: list[~azure.mgmt.appconfiguration.v2022_05_01.models.PrivateLinkResource]
        :keyword next_link: The URI that can be used to request the next set of paged results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PrivateLinkServiceConnectionState(_serialization.Model):
    """The state of a private link service connection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The private link service connection status. Known values are: "Pending",
     "Approved", "Rejected", and "Disconnected".
    :vartype status: str or ~azure.mgmt.appconfiguration.v2022_05_01.models.ConnectionStatus
    :ivar description: The private link service connection description.
    :vartype description: str
    :ivar actions_required: Any action that is required beyond basic workflow (approve/ reject/
     disconnect). Known values are: "None" and "Recreate".
    :vartype actions_required: str or
     ~azure.mgmt.appconfiguration.v2022_05_01.models.ActionsRequired
    """

    _validation = {
        "actions_required": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "actions_required": {"key": "actionsRequired", "type": "str"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.ConnectionStatus"]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: The private link service connection status. Known values are: "Pending",
         "Approved", "Rejected", and "Disconnected".
        :paramtype status: str or ~azure.mgmt.appconfiguration.v2022_05_01.models.ConnectionStatus
        :keyword description: The private link service connection description.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.status = status
        self.description = description
        self.actions_required = None


class RegenerateKeyParameters(_serialization.Model):
    """The parameters used to regenerate an API key.

    :ivar id: The id of the key to regenerate.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The id of the key to regenerate.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ResourceIdentity(_serialization.Model):
    """An identity that can be associated with a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The type of managed identity used. The type 'SystemAssigned, UserAssigned' includes
     both an implicitly created identity and a set of user-assigned identities. The type 'None' will
     remove any identities. Known values are: "None", "SystemAssigned", "UserAssigned", and
     "SystemAssigned, UserAssigned".
    :vartype type: str or ~azure.mgmt.appconfiguration.v2022_05_01.models.IdentityType
    :ivar user_assigned_identities: The list of user-assigned identities associated with the
     resource. The user-assigned identity dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.appconfiguration.v2022_05_01.models.UserIdentity]
    :ivar principal_id: The principal id of the identity. This property will only be provided for a
     system-assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the resource's identity. This property will only
     be provided for a system-assigned identity.
    :vartype tenant_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserIdentity}"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "_models.IdentityType"]] = None,
        user_assigned_identities: Optional[Dict[str, "_models.UserIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The type of managed identity used. The type 'SystemAssigned, UserAssigned'
         includes both an implicitly created identity and a set of user-assigned identities. The type
         'None' will remove any identities. Known values are: "None", "SystemAssigned", "UserAssigned",
         and "SystemAssigned, UserAssigned".
        :paramtype type: str or ~azure.mgmt.appconfiguration.v2022_05_01.models.IdentityType
        :keyword user_assigned_identities: The list of user-assigned identities associated with the
         resource. The user-assigned identity dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.appconfiguration.v2022_05_01.models.UserIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities
        self.principal_id = None
        self.tenant_id = None


class ServiceSpecification(_serialization.Model):
    """Service specification payload.

    :ivar log_specifications: Specifications of the Log for Azure Monitoring.
    :vartype log_specifications:
     list[~azure.mgmt.appconfiguration.v2022_05_01.models.LogSpecification]
    :ivar metric_specifications: Specifications of the Metrics for Azure Monitoring.
    :vartype metric_specifications:
     list[~azure.mgmt.appconfiguration.v2022_05_01.models.MetricSpecification]
    """

    _attribute_map = {
        "log_specifications": {"key": "logSpecifications", "type": "[LogSpecification]"},
        "metric_specifications": {"key": "metricSpecifications", "type": "[MetricSpecification]"},
    }

    def __init__(
        self,
        *,
        log_specifications: Optional[List["_models.LogSpecification"]] = None,
        metric_specifications: Optional[List["_models.MetricSpecification"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword log_specifications: Specifications of the Log for Azure Monitoring.
        :paramtype log_specifications:
         list[~azure.mgmt.appconfiguration.v2022_05_01.models.LogSpecification]
        :keyword metric_specifications: Specifications of the Metrics for Azure Monitoring.
        :paramtype metric_specifications:
         list[~azure.mgmt.appconfiguration.v2022_05_01.models.MetricSpecification]
        """
        super().__init__(**kwargs)
        self.log_specifications = log_specifications
        self.metric_specifications = metric_specifications


class Sku(_serialization.Model):
    """Describes a configuration store SKU.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The SKU name of the configuration store. Required.
    :vartype name: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
    }

    def __init__(self, *, name: str, **kwargs: Any) -> None:
        """
        :keyword name: The SKU name of the configuration store. Required.
        :paramtype name: str
        """
        super().__init__(**kwargs)
        self.name = name


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.appconfiguration.v2022_05_01.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.appconfiguration.v2022_05_01.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or
         ~azure.mgmt.appconfiguration.v2022_05_01.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.appconfiguration.v2022_05_01.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class UserIdentity(_serialization.Model):
    """A resource identity that is managed by the user of the service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the user-assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the user-assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
