/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.xml;

import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.namespace.Namespace;
import fr.jayasoft.ivy.util.Message;
import fr.jayasoft.ivy.util.XMLHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlModuleDescriptorUpdater {
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void update(URL srcURL, File destFile, Map resolvedRevisions, String status, String revision, Date pubdate) throws IOException, SAXException {
        XmlModuleDescriptorUpdater.update(null, srcURL, destFile, resolvedRevisions, status, revision, pubdate, null, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void update(final Ivy ivy, URL srcURL, File destFile, final Map resolvedRevisions, final String status, final String revision, final Date pubdate, final Namespace ns, final boolean replaceInclude) throws IOException, SAXException {
        if (destFile.getParentFile() != null) {
            destFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = null;
        try {
            try {
                fos = new FileOutputStream(destFile);
                final PrintWriter out = new PrintWriter(fos);
                XmlModuleDescriptorUpdater.copyHeader(srcURL, out);
                XMLHelper.parse(srcURL, null, new DefaultHandler(){
                    private String _organisation = null;
                    private String _defaultConfMapping = null;
                    private String _justOpen = null;
                    private Stack _context = new Stack();

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        if (this._justOpen != null) {
                            out.print(">");
                        }
                        this._context.push(qName);
                        if ("info".equals(qName)) {
                            this._organisation = this.substitute(ivy, attributes.getValue("organisation"));
                            out.print("<info organisation=\"" + this._organisation + "\" module=\"" + this.substitute(ivy, attributes.getValue("module")) + "\"");
                            if (revision != null) {
                                out.print(" revision=\"" + revision + "\"");
                            } else if (attributes.getValue("revision") != null) {
                                out.print(" revision=\"" + this.substitute(ivy, attributes.getValue("revision")) + "\"");
                            }
                            if (status != null) {
                                out.print(" status=\"" + status + "\"");
                            } else {
                                out.print(" status=\"" + this.substitute(ivy, attributes.getValue("status")) + "\"");
                            }
                            if (pubdate != null) {
                                out.print(" publication=\"" + Ivy.DATE_FORMAT.format(pubdate) + "\"");
                            } else if (attributes.getValue("publication") != null) {
                                out.print(" publication=\"" + this.substitute(ivy, attributes.getValue("publication")) + "\"");
                            }
                            if (attributes.getValue("namespace") != null) {
                                out.print(" namespace=\"" + this.substitute(ivy, attributes.getValue("namespace")) + "\"");
                            }
                        } else {
                            if (replaceInclude && "include".equals(qName) && this._context.contains("configurations")) {
                                try {
                                    URL url;
                                    String fileName = this.substitute(ivy, attributes.getValue("file"));
                                    if (fileName == null) {
                                        String urlStr = this.substitute(ivy, attributes.getValue("url"));
                                        url = new URL(urlStr);
                                    } else {
                                        url = new File(fileName).toURL();
                                    }
                                    XMLHelper.parse(url, null, new DefaultHandler(this){
                                        boolean _first;
                                        private final /* synthetic */ 1 this$0;
                                        {
                                            this.this$0 = this$0;
                                            this._first = true;
                                        }

                                        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                                            if ("configurations".equals(qName)) {
                                                String defaultconf = 1.access$100(this.this$0, 1.access$000(this.this$0), attributes.getValue("defaultconfmapping"));
                                                if (defaultconf != null) {
                                                    1.access$202(this.this$0, defaultconf);
                                                }
                                            } else if ("conf".equals(qName)) {
                                                if (!this._first) {
                                                    1.access$300(this.this$0).print("/>\n\t\t");
                                                } else {
                                                    this._first = false;
                                                }
                                                1.access$300(this.this$0).print("<" + qName);
                                                for (int i = 0; i < attributes.getLength(); ++i) {
                                                    1.access$300(this.this$0).print(" " + attributes.getQName(i) + "=\"" + 1.access$100(this.this$0, 1.access$000(this.this$0), attributes.getValue(i)) + "\"");
                                                }
                                            }
                                        }
                                    });
                                }
                                catch (Exception e) {
                                    Message.warn("exception occured while importing configurations: " + e.getMessage());
                                    throw new SAXException(e);
                                }
                            }
                            if ("dependency".equals(qName)) {
                                out.print("<dependency");
                                String org = this.substitute(ivy, attributes.getValue("org"));
                                org = org == null ? this._organisation : org;
                                String module = this.substitute(ivy, attributes.getValue("name"));
                                String revision2 = this.substitute(ivy, attributes.getValue("rev"));
                                ModuleRevisionId localMid = ModuleRevisionId.newInstance(org, module, revision2);
                                ModuleRevisionId systemMid = ns == null ? localMid : ns.getToSystemTransformer().transform(localMid);
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    String attName = attributes.getQName(i);
                                    if ("rev".equals(attName)) {
                                        String rev = (String)resolvedRevisions.get(systemMid.getModuleId());
                                        if (rev != null) {
                                            out.print(" rev=\"" + rev + "\"");
                                            continue;
                                        }
                                        out.print(" rev=\"" + systemMid.getRevision() + "\"");
                                        continue;
                                    }
                                    if ("org".equals(attName)) {
                                        out.print(" org=\"" + systemMid.getOrganisation() + "\"");
                                        continue;
                                    }
                                    if ("name".equals(attName)) {
                                        out.print(" name=\"" + systemMid.getName() + "\"");
                                        continue;
                                    }
                                    out.print(" " + attName + "=\"" + this.substitute(ivy, attributes.getValue(attName)) + "\"");
                                }
                            } else if ("dependencies".equals(qName)) {
                                out.print("<" + qName);
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    out.print(" " + attributes.getQName(i) + "=\"" + this.substitute(ivy, attributes.getValue(i)) + "\"");
                                }
                                if (this._defaultConfMapping != null && attributes.getValue("defaultconfmapping") == null) {
                                    out.print(" defaultconfmapping=\"" + this._defaultConfMapping + "\"");
                                }
                            } else {
                                out.print("<" + qName);
                                for (int i = 0; i < attributes.getLength(); ++i) {
                                    out.print(" " + attributes.getQName(i) + "=\"" + this.substitute(ivy, attributes.getValue(i)) + "\"");
                                }
                            }
                        }
                        this._justOpen = qName;
                    }

                    private String substitute(Ivy ivy2, String value) {
                        return ivy2 == null ? value : ivy2.substitute(value);
                    }

                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this._justOpen != null) {
                            out.print(">");
                            this._justOpen = null;
                        }
                        for (int i = start; i < start + length; ++i) {
                            out.print(ch[i]);
                        }
                    }

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (qName.equals(this._justOpen)) {
                            out.print("/>");
                        } else {
                            out.print("</" + qName + ">");
                        }
                        this._justOpen = null;
                        this._context.pop();
                    }

                    public void endDocument() throws SAXException {
                        out.flush();
                        out.close();
                    }

                    public void warning(SAXParseException e) throws SAXException {
                        throw e;
                    }

                    public void error(SAXParseException e) throws SAXException {
                        throw e;
                    }

                    public void fatalError(SAXParseException e) throws SAXException {
                        throw e;
                    }

                    static /* synthetic */ Ivy access$000(1 x0) {
                        return x0.ivy;
                    }

                    static /* synthetic */ String access$100(1 x0, Ivy x1, String x2) {
                        return x0.substitute(x1, x2);
                    }

                    static /* synthetic */ String access$202(1 x0, String x1) {
                        x0._defaultConfMapping = x1;
                        return x0._defaultConfMapping;
                    }

                    static /* synthetic */ PrintWriter access$300(1 x0) {
                        return x0.out;
                    }
                });
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (ParserConfigurationException e) {
                IllegalStateException ise = new IllegalStateException("impossible to update " + srcURL + ": parser problem");
                ise.initCause(e);
                throw ise;
            }
            Object var13_13 = null;
            if (fos == null) return;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (fos == null) throw throwable;
            try {
                fos.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        fos.close();
        return;
    }

    private static void copyHeader(URL srcURL, PrintWriter out) throws IOException {
        StringBuffer buf = new StringBuffer();
        BufferedReader r = new BufferedReader(new InputStreamReader(srcURL.openStream()));
        String line = r.readLine();
        while (line != null) {
            int index = line.indexOf("<ivy-module");
            if (index != -1) {
                buf.append(line.substring(0, index));
                out.print(buf.toString());
                break;
            }
            buf.append(line).append(LINE_SEPARATOR);
            line = r.readLine();
        }
        r.close();
    }
}

