/*
 *	sysfs utilities
 *
 *	Copyright (C) 2009-2010 Olaf Kirch <okir@suse.de>
 *	Copyright (C) 2011 SUSE LINUX Products GmbH, Nuernberg, Germany.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *	MA  02110-1301  USA
 *
 *	Authors: Olaf Kirch <okir@suse.de>
 *	         Marius Tomaschewski <mt@suse.de>
 *
 *	libnetcontrol contains source code which is based on wicked.
 *	Wicked is licensed under the GPL-2.0+, but permission has been
 *	granted by the authors of wicked to use the code derived from
 *	wicked under the LGPL-2.1+ in libnetcontrol.
 *	You can find the wicked project at http://gitorious.org/wicked/.
 *
 */
#ifndef __NETCONTROL_SYSFS_H
#define __NETCONTROL_SYSFS_H
#if defined(HAVE_CONFIG_H)
#include <config.h>
#endif

#include <sutils.h>
#include <ntypes.h>

#define NC_SYSFS_CLASS_NET_PATH		"/sys/class/net"

/* #include <linux/if_bridge.h> */
#ifndef SYSFS_BRIDGE_ATTR
#define SYSFS_BRIDGE_ATTR               "bridge"
#endif
#ifndef SYSFS_BRIDGE_PORT_SUBDIR
#define SYSFS_BRIDGE_PORT_SUBDIR        "brif"
#endif
#ifndef SYSFS_BRIDGE_PORT_ATTR
#define SYSFS_BRIDGE_PORT_ATTR          "brport"
#endif
#ifndef SYSFS_BRIDGE_PORT_LINK
#define SYSFS_BRIDGE_PORT_LINK          "bridge"
#endif


int /* bool */	nc_sysfs_netif_exists(const char *, const char *);
int		nc_sysfs_netif_get_string(const char *, const char *, char **);
int		nc_sysfs_netif_get_int(const char *, const char *, int *);
int		nc_sysfs_netif_get_uint(const char *, const char *, unsigned int *);
int		nc_sysfs_netif_get_long(const char *, const char *, long *);
int		nc_sysfs_netif_get_ulong(const char *, const char *, unsigned long *);
int		nc_sysfs_netif_get_bus_id(const char *, char **);
int		nc_sysfs_netif_get_linkpath(const char *, const char *, char **);
int		nc_sysfs_netif_get_linkbase(const char *, const char *, char **);

#endif /* __NETCONTROL_SYSFS_H */
