/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.HasBeenInstrumented;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.countermaps.AtomicCounterMap;
import net.sourceforge.cobertura.coveragedata.countermaps.CounterMap;

public class TouchCollector
implements HasBeenInstrumented {
    private static final CounterMap<LineTouchData> touchedLines = new AtomicCounterMap<LineTouchData>();
    private static final CounterMap<SwitchTouchData> switchTouchData = new AtomicCounterMap<SwitchTouchData>();
    private static final CounterMap<JumpTouchData> jumpTouchData = new AtomicCounterMap<JumpTouchData>();
    private static AtomicInteger lastClassId = new AtomicInteger(1);
    private static final Map<String, Integer> class2classId = new ConcurrentHashMap<String, Integer>();
    private static final Map<Integer, String> classId2class = new ConcurrentHashMap<Integer, String>();

    private static final int registerClassData(String name) {
        Integer res = class2classId.get(name);
        if (res == null) {
            int new_id = lastClassId.incrementAndGet();
            class2classId.put(name, new_id);
            classId2class.put(new_id, name);
            return new_id;
        }
        return res;
    }

    public static final void touchSwitch(String classId, int lineNumber, int switchNumber, int branch) {
        switchTouchData.incrementValue(new SwitchTouchData(TouchCollector.registerClassData(classId), lineNumber, switchNumber, branch));
    }

    public static final void touch(String classId, int lineNumber) {
        touchedLines.incrementValue(new LineTouchData(TouchCollector.registerClassData(classId), lineNumber));
    }

    public static final void touchJump(String classId, int lineNumber, int branchNumber, boolean branch) {
        jumpTouchData.incrementValue(new JumpTouchData(TouchCollector.registerClassData(classId), lineNumber, branchNumber, branch));
    }

    public static synchronized void applyTouchesOnProjectData(ProjectData projectData) {
        System.out.println("Flushing results...");
        Map<LineTouchData, Integer> touches = touchedLines.getFinalStateAndCleanIt();
        for (Map.Entry<LineTouchData, Integer> touch : touches.entrySet()) {
            if (touch.getValue() <= 0) continue;
            TouchCollector.getClassFor(touch.getKey(), projectData).touch(touch.getKey().lineNumber, touch.getValue());
        }
        Map<SwitchTouchData, Integer> switchTouches = switchTouchData.getFinalStateAndCleanIt();
        for (Map.Entry<SwitchTouchData, Integer> touch : switchTouches.entrySet()) {
            if (touch.getValue() <= 0) continue;
            TouchCollector.getClassFor(touch.getKey(), projectData).touchSwitch(touch.getKey().lineNumber, touch.getKey().switchNumber, touch.getKey().branch, touch.getValue());
        }
        Map<JumpTouchData, Integer> jumpTouches = jumpTouchData.getFinalStateAndCleanIt();
        for (Map.Entry<JumpTouchData, Integer> touch : jumpTouches.entrySet()) {
            if (touch.getValue() <= 0) continue;
            TouchCollector.getClassFor(touch.getKey(), projectData).touchJump(touch.getKey().lineNumber, touch.getKey().branchNumber, touch.getKey().branch, touch.getValue());
        }
        System.out.println("Flushing results done");
    }

    private static ClassData getClassFor(LineTouchData key, ProjectData projectData) {
        return projectData.getOrCreateClassData(classId2class.get(key.classId));
    }

    static {
        ProjectData.initialize();
    }

    private static class JumpTouchData
    extends LineTouchData
    implements HasBeenInstrumented {
        int branchNumber;
        boolean branch;

        public JumpTouchData(int classId, int lineNumber, int branchNumber, boolean branch) {
            super(classId, lineNumber);
            this.branchNumber = branchNumber;
            this.branch = branch;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + (this.branch ? 1231 : 1237);
            result = 31 * result + this.branchNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JumpTouchData other = (JumpTouchData)obj;
            if (this.branch != other.branch) {
                return false;
            }
            return this.branchNumber == other.branchNumber;
        }
    }

    private static class SwitchTouchData
    extends LineTouchData
    implements HasBeenInstrumented {
        int switchNumber;
        int branch;

        public SwitchTouchData(int classId, int lineNumber, int switchNumber, int branch) {
            super(classId, lineNumber);
            this.switchNumber = switchNumber;
            this.branch = branch;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + this.branch;
            result = 31 * result + this.switchNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SwitchTouchData other = (SwitchTouchData)obj;
            if (this.branch != other.branch) {
                return false;
            }
            return this.switchNumber == other.switchNumber;
        }
    }

    private static class LineTouchData
    implements HasBeenInstrumented {
        int classId;
        int lineNumber;

        public LineTouchData(int classId, int lineNumber) {
            this.classId = classId;
            this.lineNumber = lineNumber;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.classId;
            result = 31 * result + this.lineNumber;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LineTouchData other = (LineTouchData)obj;
            if (this.classId != other.classId) {
                return false;
            }
            return this.lineNumber == other.lineNumber;
        }
    }
}

