//
//Copyright 2022 Google LLC
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//https://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.23.4
// source: sharedprotos/system/system.proto

package system

import (
	status "github.com/GoogleCloudPlatform/workloadagentplatform/sharedprotos/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Different types of resources attached to the SAP system.
type SapDiscovery_Resource_ResourceType int32

const (
	// Undefined resource type.
	SapDiscovery_Resource_RESOURCE_TYPE_UNSPECIFIED SapDiscovery_Resource_ResourceType = 0
	// This is a compute resource.
	SapDiscovery_Resource_RESOURCE_TYPE_COMPUTE SapDiscovery_Resource_ResourceType = 1
	// This a storage resource.
	SapDiscovery_Resource_RESOURCE_TYPE_STORAGE SapDiscovery_Resource_ResourceType = 2
	// This is a network resource.
	SapDiscovery_Resource_RESOURCE_TYPE_NETWORK SapDiscovery_Resource_ResourceType = 3
)

// Enum value maps for SapDiscovery_Resource_ResourceType.
var (
	SapDiscovery_Resource_ResourceType_name = map[int32]string{
		0: "RESOURCE_TYPE_UNSPECIFIED",
		1: "RESOURCE_TYPE_COMPUTE",
		2: "RESOURCE_TYPE_STORAGE",
		3: "RESOURCE_TYPE_NETWORK",
	}
	SapDiscovery_Resource_ResourceType_value = map[string]int32{
		"RESOURCE_TYPE_UNSPECIFIED": 0,
		"RESOURCE_TYPE_COMPUTE":     1,
		"RESOURCE_TYPE_STORAGE":     2,
		"RESOURCE_TYPE_NETWORK":     3,
	}
)

func (x SapDiscovery_Resource_ResourceType) Enum() *SapDiscovery_Resource_ResourceType {
	p := new(SapDiscovery_Resource_ResourceType)
	*p = x
	return p
}

func (x SapDiscovery_Resource_ResourceType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SapDiscovery_Resource_ResourceType) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_system_system_proto_enumTypes[0].Descriptor()
}

func (SapDiscovery_Resource_ResourceType) Type() protoreflect.EnumType {
	return &file_sharedprotos_system_system_proto_enumTypes[0]
}

func (x SapDiscovery_Resource_ResourceType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SapDiscovery_Resource_ResourceType.Descriptor instead.
func (SapDiscovery_Resource_ResourceType) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 1, 0}
}

// Different kinds of resources in the SAP System.
type SapDiscovery_Resource_ResourceKind int32

const (
	// Unspecified resource kind.
	SapDiscovery_Resource_RESOURCE_KIND_UNSPECIFIED SapDiscovery_Resource_ResourceKind = 0
	// This is a compute instance.
	SapDiscovery_Resource_RESOURCE_KIND_INSTANCE SapDiscovery_Resource_ResourceKind = 1
	// This is a compute disk.
	SapDiscovery_Resource_RESOURCE_KIND_DISK SapDiscovery_Resource_ResourceKind = 2
	// This is a compute address.
	SapDiscovery_Resource_RESOURCE_KIND_ADDRESS SapDiscovery_Resource_ResourceKind = 3
	// This is a filestore instance.
	SapDiscovery_Resource_RESOURCE_KIND_FILESTORE SapDiscovery_Resource_ResourceKind = 4
	// This is a compute health check.
	SapDiscovery_Resource_RESOURCE_KIND_HEALTH_CHECK SapDiscovery_Resource_ResourceKind = 5
	// This is a compute forwarding rule.
	SapDiscovery_Resource_RESOURCE_KIND_FORWARDING_RULE SapDiscovery_Resource_ResourceKind = 6
	// This is a compute backend service.
	SapDiscovery_Resource_RESOURCE_KIND_BACKEND_SERVICE SapDiscovery_Resource_ResourceKind = 7
	// This is a compute subnetwork.
	SapDiscovery_Resource_RESOURCE_KIND_SUBNETWORK SapDiscovery_Resource_ResourceKind = 8
	// This is a compute network.
	SapDiscovery_Resource_RESOURCE_KIND_NETWORK SapDiscovery_Resource_ResourceKind = 9
	// This is a public accessible IP Address.
	SapDiscovery_Resource_RESOURCE_KIND_PUBLIC_ADDRESS SapDiscovery_Resource_ResourceKind = 10
	// This is a compute instance group.
	SapDiscovery_Resource_RESOURCE_KIND_INSTANCE_GROUP SapDiscovery_Resource_ResourceKind = 11
)

// Enum value maps for SapDiscovery_Resource_ResourceKind.
var (
	SapDiscovery_Resource_ResourceKind_name = map[int32]string{
		0:  "RESOURCE_KIND_UNSPECIFIED",
		1:  "RESOURCE_KIND_INSTANCE",
		2:  "RESOURCE_KIND_DISK",
		3:  "RESOURCE_KIND_ADDRESS",
		4:  "RESOURCE_KIND_FILESTORE",
		5:  "RESOURCE_KIND_HEALTH_CHECK",
		6:  "RESOURCE_KIND_FORWARDING_RULE",
		7:  "RESOURCE_KIND_BACKEND_SERVICE",
		8:  "RESOURCE_KIND_SUBNETWORK",
		9:  "RESOURCE_KIND_NETWORK",
		10: "RESOURCE_KIND_PUBLIC_ADDRESS",
		11: "RESOURCE_KIND_INSTANCE_GROUP",
	}
	SapDiscovery_Resource_ResourceKind_value = map[string]int32{
		"RESOURCE_KIND_UNSPECIFIED":     0,
		"RESOURCE_KIND_INSTANCE":        1,
		"RESOURCE_KIND_DISK":            2,
		"RESOURCE_KIND_ADDRESS":         3,
		"RESOURCE_KIND_FILESTORE":       4,
		"RESOURCE_KIND_HEALTH_CHECK":    5,
		"RESOURCE_KIND_FORWARDING_RULE": 6,
		"RESOURCE_KIND_BACKEND_SERVICE": 7,
		"RESOURCE_KIND_SUBNETWORK":      8,
		"RESOURCE_KIND_NETWORK":         9,
		"RESOURCE_KIND_PUBLIC_ADDRESS":  10,
		"RESOURCE_KIND_INSTANCE_GROUP":  11,
	}
)

func (x SapDiscovery_Resource_ResourceKind) Enum() *SapDiscovery_Resource_ResourceKind {
	p := new(SapDiscovery_Resource_ResourceKind)
	*p = x
	return p
}

func (x SapDiscovery_Resource_ResourceKind) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SapDiscovery_Resource_ResourceKind) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_system_system_proto_enumTypes[1].Descriptor()
}

func (SapDiscovery_Resource_ResourceKind) Type() protoreflect.EnumType {
	return &file_sharedprotos_system_system_proto_enumTypes[1]
}

func (x SapDiscovery_Resource_ResourceKind) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SapDiscovery_Resource_ResourceKind.Descriptor instead.
func (SapDiscovery_Resource_ResourceKind) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 1, 1}
}

// Bitmask of instance roles.
type SapDiscovery_Resource_InstanceProperties_InstanceRole int32

const (
	// Unspecified instance role.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_UNSPECIFIED SapDiscovery_Resource_InstanceProperties_InstanceRole = 0
	// Application central services.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ASCS SapDiscovery_Resource_InstanceProperties_InstanceRole = 1
	// Enqueue replication server.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ERS SapDiscovery_Resource_InstanceProperties_InstanceRole = 2
	// Application server.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_APP_SERVER SapDiscovery_Resource_InstanceProperties_InstanceRole = 4
	// Database node.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_DATABASE SapDiscovery_Resource_InstanceProperties_InstanceRole = 8
	// Combinations of roles.
	// Application central services and enqueue replication server.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ASCS_ERS SapDiscovery_Resource_InstanceProperties_InstanceRole = 3
	// Application central services and application server.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ASCS_APP_SERVER SapDiscovery_Resource_InstanceProperties_InstanceRole = 5
	// Application central services and database.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ASCS_DATABASE SapDiscovery_Resource_InstanceProperties_InstanceRole = 9
	// Enqueue replication server and application server.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ERS_APP_SERVER SapDiscovery_Resource_InstanceProperties_InstanceRole = 6
	// Enqueue replication server and database.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ERS_DATABASE SapDiscovery_Resource_InstanceProperties_InstanceRole = 10
	// Application server and database.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_APP_SERVER_DATABASE SapDiscovery_Resource_InstanceProperties_InstanceRole = 12
	// Application central services, enqueue replication server and
	// application server.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ASCS_ERS_APP_SERVER SapDiscovery_Resource_InstanceProperties_InstanceRole = 7
	// Application central services, enqueue replication server and
	// database.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ASCS_ERS_DATABASE SapDiscovery_Resource_InstanceProperties_InstanceRole = 11
	// Application central services, application server and database.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ASCS_APP_SERVER_DATABASE SapDiscovery_Resource_InstanceProperties_InstanceRole = 13
	// Enqueue replication server, application server and database.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ERS_APP_SERVER_DATABASE SapDiscovery_Resource_InstanceProperties_InstanceRole = 14
	// Application central services, enqueue replication server,
	// application server and database.
	SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_ASCS_ERS_APP_SERVER_DATABASE SapDiscovery_Resource_InstanceProperties_InstanceRole = 15
)

// Enum value maps for SapDiscovery_Resource_InstanceProperties_InstanceRole.
var (
	SapDiscovery_Resource_InstanceProperties_InstanceRole_name = map[int32]string{
		0:  "INSTANCE_ROLE_UNSPECIFIED",
		1:  "INSTANCE_ROLE_ASCS",
		2:  "INSTANCE_ROLE_ERS",
		4:  "INSTANCE_ROLE_APP_SERVER",
		8:  "INSTANCE_ROLE_DATABASE",
		3:  "INSTANCE_ROLE_ASCS_ERS",
		5:  "INSTANCE_ROLE_ASCS_APP_SERVER",
		9:  "INSTANCE_ROLE_ASCS_DATABASE",
		6:  "INSTANCE_ROLE_ERS_APP_SERVER",
		10: "INSTANCE_ROLE_ERS_DATABASE",
		12: "INSTANCE_ROLE_APP_SERVER_DATABASE",
		7:  "INSTANCE_ROLE_ASCS_ERS_APP_SERVER",
		11: "INSTANCE_ROLE_ASCS_ERS_DATABASE",
		13: "INSTANCE_ROLE_ASCS_APP_SERVER_DATABASE",
		14: "INSTANCE_ROLE_ERS_APP_SERVER_DATABASE",
		15: "INSTANCE_ROLE_ASCS_ERS_APP_SERVER_DATABASE",
	}
	SapDiscovery_Resource_InstanceProperties_InstanceRole_value = map[string]int32{
		"INSTANCE_ROLE_UNSPECIFIED":                  0,
		"INSTANCE_ROLE_ASCS":                         1,
		"INSTANCE_ROLE_ERS":                          2,
		"INSTANCE_ROLE_APP_SERVER":                   4,
		"INSTANCE_ROLE_DATABASE":                     8,
		"INSTANCE_ROLE_ASCS_ERS":                     3,
		"INSTANCE_ROLE_ASCS_APP_SERVER":              5,
		"INSTANCE_ROLE_ASCS_DATABASE":                9,
		"INSTANCE_ROLE_ERS_APP_SERVER":               6,
		"INSTANCE_ROLE_ERS_DATABASE":                 10,
		"INSTANCE_ROLE_APP_SERVER_DATABASE":          12,
		"INSTANCE_ROLE_ASCS_ERS_APP_SERVER":          7,
		"INSTANCE_ROLE_ASCS_ERS_DATABASE":            11,
		"INSTANCE_ROLE_ASCS_APP_SERVER_DATABASE":     13,
		"INSTANCE_ROLE_ERS_APP_SERVER_DATABASE":      14,
		"INSTANCE_ROLE_ASCS_ERS_APP_SERVER_DATABASE": 15,
	}
)

func (x SapDiscovery_Resource_InstanceProperties_InstanceRole) Enum() *SapDiscovery_Resource_InstanceProperties_InstanceRole {
	p := new(SapDiscovery_Resource_InstanceProperties_InstanceRole)
	*p = x
	return p
}

func (x SapDiscovery_Resource_InstanceProperties_InstanceRole) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SapDiscovery_Resource_InstanceProperties_InstanceRole) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_system_system_proto_enumTypes[2].Descriptor()
}

func (SapDiscovery_Resource_InstanceProperties_InstanceRole) Type() protoreflect.EnumType {
	return &file_sharedprotos_system_system_proto_enumTypes[2]
}

func (x SapDiscovery_Resource_InstanceProperties_InstanceRole) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SapDiscovery_Resource_InstanceProperties_InstanceRole.Descriptor instead.
func (SapDiscovery_Resource_InstanceProperties_InstanceRole) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

// Different types of system topology.
type SapDiscovery_Component_TopologyType int32

const (
	// Unspecified topology.
	SapDiscovery_Component_TOPOLOGY_TYPE_UNSPECIFIED SapDiscovery_Component_TopologyType = 0
	// A scale-up single node system.
	SapDiscovery_Component_TOPOLOGY_SCALE_UP SapDiscovery_Component_TopologyType = 1
	// A scale-out multi-node system.
	SapDiscovery_Component_TOPOLOGY_SCALE_OUT SapDiscovery_Component_TopologyType = 2
)

// Enum value maps for SapDiscovery_Component_TopologyType.
var (
	SapDiscovery_Component_TopologyType_name = map[int32]string{
		0: "TOPOLOGY_TYPE_UNSPECIFIED",
		1: "TOPOLOGY_SCALE_UP",
		2: "TOPOLOGY_SCALE_OUT",
	}
	SapDiscovery_Component_TopologyType_value = map[string]int32{
		"TOPOLOGY_TYPE_UNSPECIFIED": 0,
		"TOPOLOGY_SCALE_UP":         1,
		"TOPOLOGY_SCALE_OUT":        2,
	}
)

func (x SapDiscovery_Component_TopologyType) Enum() *SapDiscovery_Component_TopologyType {
	p := new(SapDiscovery_Component_TopologyType)
	*p = x
	return p
}

func (x SapDiscovery_Component_TopologyType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SapDiscovery_Component_TopologyType) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_system_system_proto_enumTypes[3].Descriptor()
}

func (SapDiscovery_Component_TopologyType) Type() protoreflect.EnumType {
	return &file_sharedprotos_system_system_proto_enumTypes[3]
}

func (x SapDiscovery_Component_TopologyType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SapDiscovery_Component_TopologyType.Descriptor instead.
func (SapDiscovery_Component_TopologyType) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 2, 0}
}

// The type of application running in the system.
type SapDiscovery_Component_ApplicationProperties_ApplicationType int32

const (
	// Unspecified application type
	SapDiscovery_Component_ApplicationProperties_APPLICATION_TYPE_UNSPECIFIED SapDiscovery_Component_ApplicationProperties_ApplicationType = 0
	// SAP Netweaver
	SapDiscovery_Component_ApplicationProperties_NETWEAVER SapDiscovery_Component_ApplicationProperties_ApplicationType = 1
	// SAP Netweaver ABAP
	SapDiscovery_Component_ApplicationProperties_NETWEAVER_ABAP SapDiscovery_Component_ApplicationProperties_ApplicationType = 2
	// SAP Netweaver Java
	SapDiscovery_Component_ApplicationProperties_NETWEAVER_JAVA SapDiscovery_Component_ApplicationProperties_ApplicationType = 3
)

// Enum value maps for SapDiscovery_Component_ApplicationProperties_ApplicationType.
var (
	SapDiscovery_Component_ApplicationProperties_ApplicationType_name = map[int32]string{
		0: "APPLICATION_TYPE_UNSPECIFIED",
		1: "NETWEAVER",
		2: "NETWEAVER_ABAP",
		3: "NETWEAVER_JAVA",
	}
	SapDiscovery_Component_ApplicationProperties_ApplicationType_value = map[string]int32{
		"APPLICATION_TYPE_UNSPECIFIED": 0,
		"NETWEAVER":                    1,
		"NETWEAVER_ABAP":               2,
		"NETWEAVER_JAVA":               3,
	}
)

func (x SapDiscovery_Component_ApplicationProperties_ApplicationType) Enum() *SapDiscovery_Component_ApplicationProperties_ApplicationType {
	p := new(SapDiscovery_Component_ApplicationProperties_ApplicationType)
	*p = x
	return p
}

func (x SapDiscovery_Component_ApplicationProperties_ApplicationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SapDiscovery_Component_ApplicationProperties_ApplicationType) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_system_system_proto_enumTypes[4].Descriptor()
}

func (SapDiscovery_Component_ApplicationProperties_ApplicationType) Type() protoreflect.EnumType {
	return &file_sharedprotos_system_system_proto_enumTypes[4]
}

func (x SapDiscovery_Component_ApplicationProperties_ApplicationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SapDiscovery_Component_ApplicationProperties_ApplicationType.Descriptor instead.
func (SapDiscovery_Component_ApplicationProperties_ApplicationType) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 2, 0, 0}
}

// The type of Database running in the system.
type SapDiscovery_Component_DatabaseProperties_DatabaseType int32

const (
	// Unspecified database type.
	SapDiscovery_Component_DatabaseProperties_DATABASE_TYPE_UNSPECIFIED SapDiscovery_Component_DatabaseProperties_DatabaseType = 0
	// SAP HANA
	SapDiscovery_Component_DatabaseProperties_HANA SapDiscovery_Component_DatabaseProperties_DatabaseType = 1
	// SAP MaxDB
	SapDiscovery_Component_DatabaseProperties_MAXDB SapDiscovery_Component_DatabaseProperties_DatabaseType = 2
	// IBM DB2
	SapDiscovery_Component_DatabaseProperties_DB2 SapDiscovery_Component_DatabaseProperties_DatabaseType = 3
	// Oracle Database
	SapDiscovery_Component_DatabaseProperties_ORACLE SapDiscovery_Component_DatabaseProperties_DatabaseType = 4
	// Microsoft SQL Server
	SapDiscovery_Component_DatabaseProperties_SQLSERVER SapDiscovery_Component_DatabaseProperties_DatabaseType = 5
	// SAP Sybase ASE
	SapDiscovery_Component_DatabaseProperties_ASE SapDiscovery_Component_DatabaseProperties_DatabaseType = 6
)

// Enum value maps for SapDiscovery_Component_DatabaseProperties_DatabaseType.
var (
	SapDiscovery_Component_DatabaseProperties_DatabaseType_name = map[int32]string{
		0: "DATABASE_TYPE_UNSPECIFIED",
		1: "HANA",
		2: "MAXDB",
		3: "DB2",
		4: "ORACLE",
		5: "SQLSERVER",
		6: "ASE",
	}
	SapDiscovery_Component_DatabaseProperties_DatabaseType_value = map[string]int32{
		"DATABASE_TYPE_UNSPECIFIED": 0,
		"HANA":                      1,
		"MAXDB":                     2,
		"DB2":                       3,
		"ORACLE":                    4,
		"SQLSERVER":                 5,
		"ASE":                       6,
	}
)

func (x SapDiscovery_Component_DatabaseProperties_DatabaseType) Enum() *SapDiscovery_Component_DatabaseProperties_DatabaseType {
	p := new(SapDiscovery_Component_DatabaseProperties_DatabaseType)
	*p = x
	return p
}

func (x SapDiscovery_Component_DatabaseProperties_DatabaseType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SapDiscovery_Component_DatabaseProperties_DatabaseType) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_system_system_proto_enumTypes[5].Descriptor()
}

func (SapDiscovery_Component_DatabaseProperties_DatabaseType) Type() protoreflect.EnumType {
	return &file_sharedprotos_system_system_proto_enumTypes[5]
}

func (x SapDiscovery_Component_DatabaseProperties_DatabaseType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SapDiscovery_Component_DatabaseProperties_DatabaseType.Descriptor instead.
func (SapDiscovery_Component_DatabaseProperties_DatabaseType) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 2, 1, 0}
}

// The schema of SAP system discovery data.
type SapDiscovery struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The metadata for SAP system discovery data.
	Metadata *SapDiscovery_Metadata `protobuf:"bytes,1,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// An SAP System must have a database.
	DatabaseLayer *SapDiscovery_Component `protobuf:"bytes,2,opt,name=database_layer,json=databaseLayer,proto3" json:"database_layer,omitempty"`
	// An SAP system may run without an application layer.
	ApplicationLayer *SapDiscovery_Component `protobuf:"bytes,3,opt,name=application_layer,json=applicationLayer,proto3" json:"application_layer,omitempty"`
	// A combination of database SID, database instance URI and tenant DB name
	// to make a unique identifier per-system.
	SystemId string `protobuf:"bytes,4,opt,name=system_id,json=systemId,proto3" json:"system_id,omitempty"`
	// Unix timestamp this system has been updated last.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// The GCP project number that this SapSystem belongs to.
	ProjectNumber string `protobuf:"bytes,6,opt,name=project_number,json=projectNumber,proto3" json:"project_number,omitempty"`
	// The properties of the workload.
	WorkloadProperties *SapDiscovery_WorkloadProperties `protobuf:"bytes,7,opt,name=workload_properties,json=workloadProperties,proto3" json:"workload_properties,omitempty"`
	// Whether to use DR reconciliation or not.
	UseDrReconciliation bool `protobuf:"varint,8,opt,name=use_dr_reconciliation,json=useDrReconciliation,proto3" json:"use_dr_reconciliation,omitempty"`
}

func (x *SapDiscovery) Reset() {
	*x = SapDiscovery{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery) ProtoMessage() {}

func (x *SapDiscovery) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery.ProtoReflect.Descriptor instead.
func (*SapDiscovery) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0}
}

func (x *SapDiscovery) GetMetadata() *SapDiscovery_Metadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *SapDiscovery) GetDatabaseLayer() *SapDiscovery_Component {
	if x != nil {
		return x.DatabaseLayer
	}
	return nil
}

func (x *SapDiscovery) GetApplicationLayer() *SapDiscovery_Component {
	if x != nil {
		return x.ApplicationLayer
	}
	return nil
}

func (x *SapDiscovery) GetSystemId() string {
	if x != nil {
		return x.SystemId
	}
	return ""
}

func (x *SapDiscovery) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *SapDiscovery) GetProjectNumber() string {
	if x != nil {
		return x.ProjectNumber
	}
	return ""
}

func (x *SapDiscovery) GetWorkloadProperties() *SapDiscovery_WorkloadProperties {
	if x != nil {
		return x.WorkloadProperties
	}
	return nil
}

func (x *SapDiscovery) GetUseDrReconciliation() bool {
	if x != nil {
		return x.UseDrReconciliation
	}
	return false
}

// Message describing SAP discovery system metadata
type SapDiscovery_Metadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Customer defined, something like "E-commerce pre prod"
	DefinedSystem string `protobuf:"bytes,1,opt,name=defined_system,json=definedSystem,proto3" json:"defined_system,omitempty"`
	// This sap product name
	SapProduct string `protobuf:"bytes,2,opt,name=sap_product,json=sapProduct,proto3" json:"sap_product,omitempty"`
	// Should be "prod", "QA", "dev", "staging", etc.
	EnvironmentType string `protobuf:"bytes,3,opt,name=environment_type,json=environmentType,proto3" json:"environment_type,omitempty"`
	// Customer region string for customer's use. Does not represent GCP region.
	CustomerRegion string `protobuf:"bytes,4,opt,name=customer_region,json=customerRegion,proto3" json:"customer_region,omitempty"`
}

func (x *SapDiscovery_Metadata) Reset() {
	*x = SapDiscovery_Metadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Metadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Metadata) ProtoMessage() {}

func (x *SapDiscovery_Metadata) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Metadata.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Metadata) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 0}
}

func (x *SapDiscovery_Metadata) GetDefinedSystem() string {
	if x != nil {
		return x.DefinedSystem
	}
	return ""
}

func (x *SapDiscovery_Metadata) GetSapProduct() string {
	if x != nil {
		return x.SapProduct
	}
	return ""
}

func (x *SapDiscovery_Metadata) GetEnvironmentType() string {
	if x != nil {
		return x.EnvironmentType
	}
	return ""
}

func (x *SapDiscovery_Metadata) GetCustomerRegion() string {
	if x != nil {
		return x.CustomerRegion
	}
	return ""
}

// Message describing a resource.
type SapDiscovery_Resource struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The type of this resource.
	ResourceType SapDiscovery_Resource_ResourceType `protobuf:"varint,1,opt,name=resource_type,json=resourceType,proto3,enum=workloadagentplatform.sharedprotos.system.SapDiscovery_Resource_ResourceType" json:"resource_type,omitempty"`
	// ComputeInstance, ComputeDisk, VPC, Bare Metal server, etc.
	ResourceKind SapDiscovery_Resource_ResourceKind `protobuf:"varint,2,opt,name=resource_kind,json=resourceKind,proto3,enum=workloadagentplatform.sharedprotos.system.SapDiscovery_Resource_ResourceKind" json:"resource_kind,omitempty"`
	// URI of the resource, includes project, location, and name.
	ResourceUri string `protobuf:"bytes,3,opt,name=resource_uri,json=resourceUri,proto3" json:"resource_uri,omitempty"`
	// A list of resource URIs related to this resource.
	RelatedResources []string `protobuf:"bytes,4,rep,name=related_resources,json=relatedResources,proto3" json:"related_resources,omitempty"`
	// Unix timestamp of when this resource last had its discovery data updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// A set of properties only applying to instance type resources.
	InstanceProperties *SapDiscovery_Resource_InstanceProperties `protobuf:"bytes,6,opt,name=instance_properties,json=instanceProperties,proto3" json:"instance_properties,omitempty"`
}

func (x *SapDiscovery_Resource) Reset() {
	*x = SapDiscovery_Resource{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Resource) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Resource) ProtoMessage() {}

func (x *SapDiscovery_Resource) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Resource.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Resource) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 1}
}

func (x *SapDiscovery_Resource) GetResourceType() SapDiscovery_Resource_ResourceType {
	if x != nil {
		return x.ResourceType
	}
	return SapDiscovery_Resource_RESOURCE_TYPE_UNSPECIFIED
}

func (x *SapDiscovery_Resource) GetResourceKind() SapDiscovery_Resource_ResourceKind {
	if x != nil {
		return x.ResourceKind
	}
	return SapDiscovery_Resource_RESOURCE_KIND_UNSPECIFIED
}

func (x *SapDiscovery_Resource) GetResourceUri() string {
	if x != nil {
		return x.ResourceUri
	}
	return ""
}

func (x *SapDiscovery_Resource) GetRelatedResources() []string {
	if x != nil {
		return x.RelatedResources
	}
	return nil
}

func (x *SapDiscovery_Resource) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *SapDiscovery_Resource) GetInstanceProperties() *SapDiscovery_Resource_InstanceProperties {
	if x != nil {
		return x.InstanceProperties
	}
	return nil
}

// Message describing the system component.
type SapDiscovery_Component struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The resources in a component.
	Resources []*SapDiscovery_Resource `protobuf:"bytes,1,rep,name=resources,proto3" json:"resources,omitempty"`
	// Types that are assignable to Properties:
	//
	//	*SapDiscovery_Component_ApplicationProperties_
	//	*SapDiscovery_Component_DatabaseProperties_
	Properties isSapDiscovery_Component_Properties `protobuf_oneof:"properties"`
	// Pantheon Project in which the resources reside.
	HostProject string `protobuf:"bytes,4,opt,name=host_project,json=hostProject,proto3" json:"host_project,omitempty"`
	// The sap identifier,
	// used by the SAP software and helps differentiate systems for customers.
	Sid string `protobuf:"bytes,5,opt,name=sid,proto3" json:"sid,omitempty"`
	// The detected topology of the component.
	TopologyType SapDiscovery_Component_TopologyType `protobuf:"varint,6,opt,name=topology_type,json=topologyType,proto3,enum=workloadagentplatform.sharedprotos.system.SapDiscovery_Component_TopologyType" json:"topology_type,omitempty"`
	// A list of host URIs that are part of the HA configuration if present.
	// An empty list indicates the component is not configured for HA.
	HaHosts []string `protobuf:"bytes,7,rep,name=ha_hosts,json=haHosts,proto3" json:"ha_hosts,omitempty"`
	// A list of replication sites used in Disaster Recovery (DR)
	// configurations.
	ReplicationSites []*SapDiscovery_Component_ReplicationSite `protobuf:"bytes,8,rep,name=replication_sites,json=replicationSites,proto3" json:"replication_sites,omitempty"`
	// The region this component's resources are primarily located in.
	Region string `protobuf:"bytes,9,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *SapDiscovery_Component) Reset() {
	*x = SapDiscovery_Component{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Component) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Component) ProtoMessage() {}

func (x *SapDiscovery_Component) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Component.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Component) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 2}
}

func (x *SapDiscovery_Component) GetResources() []*SapDiscovery_Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

func (m *SapDiscovery_Component) GetProperties() isSapDiscovery_Component_Properties {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (x *SapDiscovery_Component) GetApplicationProperties() *SapDiscovery_Component_ApplicationProperties {
	if x, ok := x.GetProperties().(*SapDiscovery_Component_ApplicationProperties_); ok {
		return x.ApplicationProperties
	}
	return nil
}

func (x *SapDiscovery_Component) GetDatabaseProperties() *SapDiscovery_Component_DatabaseProperties {
	if x, ok := x.GetProperties().(*SapDiscovery_Component_DatabaseProperties_); ok {
		return x.DatabaseProperties
	}
	return nil
}

func (x *SapDiscovery_Component) GetHostProject() string {
	if x != nil {
		return x.HostProject
	}
	return ""
}

func (x *SapDiscovery_Component) GetSid() string {
	if x != nil {
		return x.Sid
	}
	return ""
}

func (x *SapDiscovery_Component) GetTopologyType() SapDiscovery_Component_TopologyType {
	if x != nil {
		return x.TopologyType
	}
	return SapDiscovery_Component_TOPOLOGY_TYPE_UNSPECIFIED
}

func (x *SapDiscovery_Component) GetHaHosts() []string {
	if x != nil {
		return x.HaHosts
	}
	return nil
}

func (x *SapDiscovery_Component) GetReplicationSites() []*SapDiscovery_Component_ReplicationSite {
	if x != nil {
		return x.ReplicationSites
	}
	return nil
}

func (x *SapDiscovery_Component) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

type isSapDiscovery_Component_Properties interface {
	isSapDiscovery_Component_Properties()
}

type SapDiscovery_Component_ApplicationProperties_ struct {
	// The component is a SAP application.
	ApplicationProperties *SapDiscovery_Component_ApplicationProperties `protobuf:"bytes,2,opt,name=application_properties,json=applicationProperties,proto3,oneof"`
}

type SapDiscovery_Component_DatabaseProperties_ struct {
	// The component is a SAP database.
	DatabaseProperties *SapDiscovery_Component_DatabaseProperties `protobuf:"bytes,3,opt,name=database_properties,json=databaseProperties,proto3,oneof"`
}

func (*SapDiscovery_Component_ApplicationProperties_) isSapDiscovery_Component_Properties() {}

func (*SapDiscovery_Component_DatabaseProperties_) isSapDiscovery_Component_Properties() {}

// A set of properties describing an SAP workload.
type SapDiscovery_WorkloadProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of SAP Products and their versions running on the system.
	ProductVersions []*SapDiscovery_WorkloadProperties_ProductVersion `protobuf:"bytes,1,rep,name=product_versions,json=productVersions,proto3" json:"product_versions,omitempty"`
	// A list of SAP software components and their versions running on the
	// system.
	SoftwareComponentVersions []*SapDiscovery_WorkloadProperties_SoftwareComponentProperties `protobuf:"bytes,2,rep,name=software_component_versions,json=softwareComponentVersions,proto3" json:"software_component_versions,omitempty"`
}

func (x *SapDiscovery_WorkloadProperties) Reset() {
	*x = SapDiscovery_WorkloadProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_WorkloadProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_WorkloadProperties) ProtoMessage() {}

func (x *SapDiscovery_WorkloadProperties) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_WorkloadProperties.ProtoReflect.Descriptor instead.
func (*SapDiscovery_WorkloadProperties) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 3}
}

func (x *SapDiscovery_WorkloadProperties) GetProductVersions() []*SapDiscovery_WorkloadProperties_ProductVersion {
	if x != nil {
		return x.ProductVersions
	}
	return nil
}

func (x *SapDiscovery_WorkloadProperties) GetSoftwareComponentVersions() []*SapDiscovery_WorkloadProperties_SoftwareComponentProperties {
	if x != nil {
		return x.SoftwareComponentVersions
	}
	return nil
}

// A set of properties only present for an instance type resource
type SapDiscovery_Resource_InstanceProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A virtual hostname of the instance if it has one.
	VirtualHostname string `protobuf:"bytes,1,opt,name=virtual_hostname,json=virtualHostname,proto3" json:"virtual_hostname,omitempty"`
	// A list of instance URIs that are part of a cluster with this one.
	ClusterInstances []string `protobuf:"bytes,2,rep,name=cluster_instances,json=clusterInstances,proto3" json:"cluster_instances,omitempty"`
	// The VM's instance number.
	InstanceNumber uint64 `protobuf:"varint,3,opt,name=instance_number,json=instanceNumber,proto3" json:"instance_number,omitempty"`
	// Bitmask of instance role, a resource may have multiple roles at once.
	InstanceRole SapDiscovery_Resource_InstanceProperties_InstanceRole `protobuf:"varint,4,opt,name=instance_role,json=instanceRole,proto3,enum=workloadagentplatform.sharedprotos.system.SapDiscovery_Resource_InstanceProperties_InstanceRole" json:"instance_role,omitempty"`
	// App server instances on the host
	AppInstances []*SapDiscovery_Resource_InstanceProperties_AppInstance `protobuf:"bytes,5,rep,name=app_instances,json=appInstances,proto3" json:"app_instances,omitempty"`
	// Instance is part of a DR site.
	IsDrSite bool `protobuf:"varint,6,opt,name=is_dr_site,json=isDrSite,proto3" json:"is_dr_site,omitempty"`
	// Disk mounts on the instance.
	DiskMounts []*SapDiscovery_Resource_InstanceProperties_DiskMount `protobuf:"bytes,7,rep,name=disk_mounts,json=diskMounts,proto3" json:"disk_mounts,omitempty"`
	// Disk device names on the instance.
	// This field is only used in local discovery, and should be removed
	// before sending to DW.
	DiskDeviceNames []*SapDiscovery_Resource_InstanceProperties_DiskDeviceName `protobuf:"bytes,8,rep,name=disk_device_names,json=diskDeviceNames,proto3" json:"disk_device_names,omitempty"`
	// The kernel version of the instance.
	OsKernelVersion *status.KernelVersion `protobuf:"bytes,9,opt,name=os_kernel_version,json=osKernelVersion,proto3" json:"os_kernel_version,omitempty"`
}

func (x *SapDiscovery_Resource_InstanceProperties) Reset() {
	*x = SapDiscovery_Resource_InstanceProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Resource_InstanceProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Resource_InstanceProperties) ProtoMessage() {}

func (x *SapDiscovery_Resource_InstanceProperties) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Resource_InstanceProperties.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Resource_InstanceProperties) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 1, 0}
}

func (x *SapDiscovery_Resource_InstanceProperties) GetVirtualHostname() string {
	if x != nil {
		return x.VirtualHostname
	}
	return ""
}

func (x *SapDiscovery_Resource_InstanceProperties) GetClusterInstances() []string {
	if x != nil {
		return x.ClusterInstances
	}
	return nil
}

func (x *SapDiscovery_Resource_InstanceProperties) GetInstanceNumber() uint64 {
	if x != nil {
		return x.InstanceNumber
	}
	return 0
}

func (x *SapDiscovery_Resource_InstanceProperties) GetInstanceRole() SapDiscovery_Resource_InstanceProperties_InstanceRole {
	if x != nil {
		return x.InstanceRole
	}
	return SapDiscovery_Resource_InstanceProperties_INSTANCE_ROLE_UNSPECIFIED
}

func (x *SapDiscovery_Resource_InstanceProperties) GetAppInstances() []*SapDiscovery_Resource_InstanceProperties_AppInstance {
	if x != nil {
		return x.AppInstances
	}
	return nil
}

func (x *SapDiscovery_Resource_InstanceProperties) GetIsDrSite() bool {
	if x != nil {
		return x.IsDrSite
	}
	return false
}

func (x *SapDiscovery_Resource_InstanceProperties) GetDiskMounts() []*SapDiscovery_Resource_InstanceProperties_DiskMount {
	if x != nil {
		return x.DiskMounts
	}
	return nil
}

func (x *SapDiscovery_Resource_InstanceProperties) GetDiskDeviceNames() []*SapDiscovery_Resource_InstanceProperties_DiskDeviceName {
	if x != nil {
		return x.DiskDeviceNames
	}
	return nil
}

func (x *SapDiscovery_Resource_InstanceProperties) GetOsKernelVersion() *status.KernelVersion {
	if x != nil {
		return x.OsKernelVersion
	}
	return nil
}

// Fields to describe an SAP application server instance.
type SapDiscovery_Resource_InstanceProperties_AppInstance struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Instance name of the SAP application instance.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Instance number of the SAP application instance.
	Number string `protobuf:"bytes,2,opt,name=number,proto3" json:"number,omitempty"`
}

func (x *SapDiscovery_Resource_InstanceProperties_AppInstance) Reset() {
	*x = SapDiscovery_Resource_InstanceProperties_AppInstance{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Resource_InstanceProperties_AppInstance) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Resource_InstanceProperties_AppInstance) ProtoMessage() {}

func (x *SapDiscovery_Resource_InstanceProperties_AppInstance) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Resource_InstanceProperties_AppInstance.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Resource_InstanceProperties_AppInstance) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 1, 0, 0}
}

func (x *SapDiscovery_Resource_InstanceProperties_AppInstance) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SapDiscovery_Resource_InstanceProperties_AppInstance) GetNumber() string {
	if x != nil {
		return x.Number
	}
	return ""
}

// Disk mount on the instance.
type SapDiscovery_Resource_InstanceProperties_DiskMount struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the disk.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Filesystem mount point.
	MountPoint string `protobuf:"bytes,2,opt,name=mount_point,json=mountPoint,proto3" json:"mount_point,omitempty"`
	// Names of the disks providing this mount point.
	DiskNames []string `protobuf:"bytes,3,rep,name=disk_names,json=diskNames,proto3" json:"disk_names,omitempty"`
}

func (x *SapDiscovery_Resource_InstanceProperties_DiskMount) Reset() {
	*x = SapDiscovery_Resource_InstanceProperties_DiskMount{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Resource_InstanceProperties_DiskMount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Resource_InstanceProperties_DiskMount) ProtoMessage() {}

func (x *SapDiscovery_Resource_InstanceProperties_DiskMount) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Resource_InstanceProperties_DiskMount.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Resource_InstanceProperties_DiskMount) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 1, 0, 1}
}

func (x *SapDiscovery_Resource_InstanceProperties_DiskMount) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SapDiscovery_Resource_InstanceProperties_DiskMount) GetMountPoint() string {
	if x != nil {
		return x.MountPoint
	}
	return ""
}

func (x *SapDiscovery_Resource_InstanceProperties_DiskMount) GetDiskNames() []string {
	if x != nil {
		return x.DiskNames
	}
	return nil
}

// Disk device name on the instance.
// This message is only used in local discovery.
type SapDiscovery_Resource_InstanceProperties_DiskDeviceName struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Source of the disk.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// Device name of the disk.
	DeviceName string `protobuf:"bytes,2,opt,name=device_name,json=deviceName,proto3" json:"device_name,omitempty"`
}

func (x *SapDiscovery_Resource_InstanceProperties_DiskDeviceName) Reset() {
	*x = SapDiscovery_Resource_InstanceProperties_DiskDeviceName{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Resource_InstanceProperties_DiskDeviceName) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Resource_InstanceProperties_DiskDeviceName) ProtoMessage() {}

func (x *SapDiscovery_Resource_InstanceProperties_DiskDeviceName) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Resource_InstanceProperties_DiskDeviceName.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Resource_InstanceProperties_DiskDeviceName) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 1, 0, 2}
}

func (x *SapDiscovery_Resource_InstanceProperties_DiskDeviceName) GetSource() string {
	if x != nil {
		return x.Source
	}
	return ""
}

func (x *SapDiscovery_Resource_InstanceProperties_DiskDeviceName) GetDeviceName() string {
	if x != nil {
		return x.DeviceName
	}
	return ""
}

// A set of properties describing an SAP Application layer.
type SapDiscovery_Component_ApplicationProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the application. Netweaver, etc.
	ApplicationType SapDiscovery_Component_ApplicationProperties_ApplicationType `protobuf:"varint,1,opt,name=application_type,json=applicationType,proto3,enum=workloadagentplatform.sharedprotos.system.SapDiscovery_Component_ApplicationProperties_ApplicationType" json:"application_type,omitempty"`
	// Resource URI of the recognized ASCS host of the application.
	AscsUri string `protobuf:"bytes,2,opt,name=ascs_uri,json=ascsUri,proto3" json:"ascs_uri,omitempty"`
	// Resource URI of the recognized shared NFS of the application.
	// May be empty if the application server has only a single node.
	NfsUri string `protobuf:"bytes,3,opt,name=nfs_uri,json=nfsUri,proto3" json:"nfs_uri,omitempty"`
	// Kernel version for Netweaver running in the system.
	KernelVersion string `protobuf:"bytes,4,opt,name=kernel_version,json=kernelVersion,proto3" json:"kernel_version,omitempty"`
	// Deprecated: ApplicationType now tells you whether this is ABAP or Java.
	//
	// Deprecated: Marked as deprecated in sharedprotos/system/system.proto.
	Abap bool `protobuf:"varint,5,opt,name=abap,proto3" json:"abap,omitempty"`
	// Instance number of the SAP application instance.
	//
	// Deprecated: Marked as deprecated in sharedprotos/system/system.proto.
	InstanceNumber string `protobuf:"bytes,6,opt,name=instance_number,json=instanceNumber,proto3" json:"instance_number,omitempty"`
	// Instance number of the ASCS instance.
	AscsInstanceNumber string `protobuf:"bytes,7,opt,name=ascs_instance_number,json=ascsInstanceNumber,proto3" json:"ascs_instance_number,omitempty"`
	// Instance number of the ERS instance.
	ErsInstanceNumber string `protobuf:"bytes,8,opt,name=ers_instance_number,json=ersInstanceNumber,proto3" json:"ers_instance_number,omitempty"`
}

func (x *SapDiscovery_Component_ApplicationProperties) Reset() {
	*x = SapDiscovery_Component_ApplicationProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Component_ApplicationProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Component_ApplicationProperties) ProtoMessage() {}

func (x *SapDiscovery_Component_ApplicationProperties) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Component_ApplicationProperties.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Component_ApplicationProperties) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 2, 0}
}

func (x *SapDiscovery_Component_ApplicationProperties) GetApplicationType() SapDiscovery_Component_ApplicationProperties_ApplicationType {
	if x != nil {
		return x.ApplicationType
	}
	return SapDiscovery_Component_ApplicationProperties_APPLICATION_TYPE_UNSPECIFIED
}

func (x *SapDiscovery_Component_ApplicationProperties) GetAscsUri() string {
	if x != nil {
		return x.AscsUri
	}
	return ""
}

func (x *SapDiscovery_Component_ApplicationProperties) GetNfsUri() string {
	if x != nil {
		return x.NfsUri
	}
	return ""
}

func (x *SapDiscovery_Component_ApplicationProperties) GetKernelVersion() string {
	if x != nil {
		return x.KernelVersion
	}
	return ""
}

// Deprecated: Marked as deprecated in sharedprotos/system/system.proto.
func (x *SapDiscovery_Component_ApplicationProperties) GetAbap() bool {
	if x != nil {
		return x.Abap
	}
	return false
}

// Deprecated: Marked as deprecated in sharedprotos/system/system.proto.
func (x *SapDiscovery_Component_ApplicationProperties) GetInstanceNumber() string {
	if x != nil {
		return x.InstanceNumber
	}
	return ""
}

func (x *SapDiscovery_Component_ApplicationProperties) GetAscsInstanceNumber() string {
	if x != nil {
		return x.AscsInstanceNumber
	}
	return ""
}

func (x *SapDiscovery_Component_ApplicationProperties) GetErsInstanceNumber() string {
	if x != nil {
		return x.ErsInstanceNumber
	}
	return ""
}

// A set of properties describing an SAP Database layer.
type SapDiscovery_Component_DatabaseProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Type of the database. HANA, DB2, etc.
	DatabaseType SapDiscovery_Component_DatabaseProperties_DatabaseType `protobuf:"varint,1,opt,name=database_type,json=databaseType,proto3,enum=workloadagentplatform.sharedprotos.system.SapDiscovery_Component_DatabaseProperties_DatabaseType" json:"database_type,omitempty"`
	// URI of the recognized primary instance of the database.
	PrimaryInstanceUri string `protobuf:"bytes,2,opt,name=primary_instance_uri,json=primaryInstanceUri,proto3" json:"primary_instance_uri,omitempty"`
	// URI of the recognized shared NFS of the database.
	// May be empty if the database has only a single node.
	SharedNfsUri string `protobuf:"bytes,3,opt,name=shared_nfs_uri,json=sharedNfsUri,proto3" json:"shared_nfs_uri,omitempty"`
	// The version of the database software running in the system.
	DatabaseVersion string `protobuf:"bytes,4,opt,name=database_version,json=databaseVersion,proto3" json:"database_version,omitempty"`
	// Instance number of the SAP instance.
	InstanceNumber string `protobuf:"bytes,5,opt,name=instance_number,json=instanceNumber,proto3" json:"instance_number,omitempty"`
	// SID of the system database.
	DatabaseSid string `protobuf:"bytes,6,opt,name=database_sid,json=databaseSid,proto3" json:"database_sid,omitempty"`
	// Landscape ID from the HANA nameserver.
	LandscapeId string `protobuf:"bytes,7,opt,name=landscape_id,json=landscapeId,proto3" json:"landscape_id,omitempty"`
}

func (x *SapDiscovery_Component_DatabaseProperties) Reset() {
	*x = SapDiscovery_Component_DatabaseProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Component_DatabaseProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Component_DatabaseProperties) ProtoMessage() {}

func (x *SapDiscovery_Component_DatabaseProperties) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Component_DatabaseProperties.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Component_DatabaseProperties) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 2, 1}
}

func (x *SapDiscovery_Component_DatabaseProperties) GetDatabaseType() SapDiscovery_Component_DatabaseProperties_DatabaseType {
	if x != nil {
		return x.DatabaseType
	}
	return SapDiscovery_Component_DatabaseProperties_DATABASE_TYPE_UNSPECIFIED
}

func (x *SapDiscovery_Component_DatabaseProperties) GetPrimaryInstanceUri() string {
	if x != nil {
		return x.PrimaryInstanceUri
	}
	return ""
}

func (x *SapDiscovery_Component_DatabaseProperties) GetSharedNfsUri() string {
	if x != nil {
		return x.SharedNfsUri
	}
	return ""
}

func (x *SapDiscovery_Component_DatabaseProperties) GetDatabaseVersion() string {
	if x != nil {
		return x.DatabaseVersion
	}
	return ""
}

func (x *SapDiscovery_Component_DatabaseProperties) GetInstanceNumber() string {
	if x != nil {
		return x.InstanceNumber
	}
	return ""
}

func (x *SapDiscovery_Component_DatabaseProperties) GetDatabaseSid() string {
	if x != nil {
		return x.DatabaseSid
	}
	return ""
}

func (x *SapDiscovery_Component_DatabaseProperties) GetLandscapeId() string {
	if x != nil {
		return x.LandscapeId
	}
	return ""
}

// A replication site used in Disaster Recovery (DR) configurations.
type SapDiscovery_Component_ReplicationSite struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the source site from which this one replicates.
	SourceSite string `protobuf:"bytes,1,opt,name=source_site,json=sourceSite,proto3" json:"source_site,omitempty"`
	// The system component for the site.
	Component *SapDiscovery_Component `protobuf:"bytes,2,opt,name=component,proto3" json:"component,omitempty"`
}

func (x *SapDiscovery_Component_ReplicationSite) Reset() {
	*x = SapDiscovery_Component_ReplicationSite{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_Component_ReplicationSite) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_Component_ReplicationSite) ProtoMessage() {}

func (x *SapDiscovery_Component_ReplicationSite) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_Component_ReplicationSite.ProtoReflect.Descriptor instead.
func (*SapDiscovery_Component_ReplicationSite) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 2, 2}
}

func (x *SapDiscovery_Component_ReplicationSite) GetSourceSite() string {
	if x != nil {
		return x.SourceSite
	}
	return ""
}

func (x *SapDiscovery_Component_ReplicationSite) GetComponent() *SapDiscovery_Component {
	if x != nil {
		return x.Component
	}
	return nil
}

// A product name and version.
type SapDiscovery_WorkloadProperties_ProductVersion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Name    string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
}

func (x *SapDiscovery_WorkloadProperties_ProductVersion) Reset() {
	*x = SapDiscovery_WorkloadProperties_ProductVersion{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_WorkloadProperties_ProductVersion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_WorkloadProperties_ProductVersion) ProtoMessage() {}

func (x *SapDiscovery_WorkloadProperties_ProductVersion) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_WorkloadProperties_ProductVersion.ProtoReflect.Descriptor instead.
func (*SapDiscovery_WorkloadProperties_ProductVersion) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 3, 0}
}

func (x *SapDiscovery_WorkloadProperties_ProductVersion) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SapDiscovery_WorkloadProperties_ProductVersion) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

// A SAP software component name, version, and type.
type SapDiscovery_WorkloadProperties_SoftwareComponentProperties struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Name of the component.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The component's major version.
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// The component's minor version.
	ExtVersion string `protobuf:"bytes,3,opt,name=ext_version,json=extVersion,proto3" json:"ext_version,omitempty"`
	// The component's type.
	Type string `protobuf:"bytes,4,opt,name=type,proto3" json:"type,omitempty"`
}

func (x *SapDiscovery_WorkloadProperties_SoftwareComponentProperties) Reset() {
	*x = SapDiscovery_WorkloadProperties_SoftwareComponentProperties{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_system_system_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapDiscovery_WorkloadProperties_SoftwareComponentProperties) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapDiscovery_WorkloadProperties_SoftwareComponentProperties) ProtoMessage() {}

func (x *SapDiscovery_WorkloadProperties_SoftwareComponentProperties) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_system_system_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapDiscovery_WorkloadProperties_SoftwareComponentProperties.ProtoReflect.Descriptor instead.
func (*SapDiscovery_WorkloadProperties_SoftwareComponentProperties) Descriptor() ([]byte, []int) {
	return file_sharedprotos_system_system_proto_rawDescGZIP(), []int{0, 3, 1}
}

func (x *SapDiscovery_WorkloadProperties_SoftwareComponentProperties) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SapDiscovery_WorkloadProperties_SoftwareComponentProperties) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *SapDiscovery_WorkloadProperties_SoftwareComponentProperties) GetExtVersion() string {
	if x != nil {
		return x.ExtVersion
	}
	return ""
}

func (x *SapDiscovery_WorkloadProperties_SoftwareComponentProperties) GetType() string {
	if x != nil {
		return x.Type
	}
	return ""
}

var File_sharedprotos_system_system_proto protoreflect.FileDescriptor

var file_sharedprotos_system_system_proto_rawDesc = []byte{
	0x0a, 0x20, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x73,
	0x79, 0x73, 0x74, 0x65, 0x6d, 0x2f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x29, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x1a, 0x1f, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x73, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x22, 0x95, 0x2f, 0x0a, 0x0c, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x12, 0x5c, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e,
	0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x68, 0x0a, 0x0e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x6c, 0x61, 0x79, 0x65,
	0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52, 0x0d, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x12, 0x6e, 0x0a, 0x11, 0x61, 0x70, 0x70,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x61, 0x79, 0x65, 0x72, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x6e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x7b, 0x0a, 0x13, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65,
	0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x4a, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x52, 0x12, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f,
	0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x32, 0x0a, 0x15, 0x75, 0x73, 0x65, 0x5f, 0x64,
	0x72, 0x5f, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x08, 0x52, 0x13, 0x75, 0x73, 0x65, 0x44, 0x72, 0x52, 0x65, 0x63,
	0x6f, 0x6e, 0x63, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0xa6, 0x01, 0x0a, 0x08,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x65, 0x66, 0x69,
	0x6e, 0x65, 0x64, 0x5f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x12,
	0x1f, 0x0a, 0x0b, 0x73, 0x61, 0x70, 0x5f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x61, 0x70, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x12, 0x29, 0x0a, 0x10, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x65, 0x6e, 0x76, 0x69,
	0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x63,
	0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x52, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x1a, 0xdd, 0x14, 0x0a, 0x08, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x12, 0x72, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75,
	0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x72, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x5f, 0x6b, 0x69, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4d, 0x2e, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x52, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0b, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x2b, 0x0a, 0x11,
	0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64,
	0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x84, 0x01, 0x0a, 0x13, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x53, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65,
	0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x12, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0xd5, 0x0c,
	0x0a, 0x12, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72,
	0x74, 0x69, 0x65, 0x73, 0x12, 0x29, 0x0a, 0x10, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x48, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12,
	0x2b, 0x0a, 0x11, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x10, 0x63, 0x6c, 0x75, 0x73,
	0x74, 0x65, 0x72, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x04, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x85, 0x01, 0x0a, 0x0d, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x5f, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x60, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
	0x65, 0x73, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x52,
	0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c, 0x65, 0x12, 0x84, 0x01,
	0x0a, 0x0d, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x18,
	0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5f, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x49, 0x6e,
	0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x0c, 0x61, 0x70, 0x70, 0x49, 0x6e, 0x73, 0x74, 0x61,
	0x6e, 0x63, 0x65, 0x73, 0x12, 0x1c, 0x0a, 0x0a, 0x69, 0x73, 0x5f, 0x64, 0x72, 0x5f, 0x73, 0x69,
	0x74, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x69, 0x73, 0x44, 0x72, 0x53, 0x69,
	0x74, 0x65, 0x12, 0x7e, 0x0a, 0x0b, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
	0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73,
	0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e,
	0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x44, 0x69, 0x73,
	0x6b, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x4d, 0x6f, 0x75, 0x6e,
	0x74, 0x73, 0x12, 0x8e, 0x01, 0x0a, 0x11, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x62,
	0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
	0x69, 0x65, 0x73, 0x2e, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x52, 0x0f, 0x64, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61,
	0x6d, 0x65, 0x73, 0x12, 0x64, 0x0a, 0x11, 0x6f, 0x73, 0x5f, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c,
	0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x4b, 0x65, 0x72, 0x6e, 0x65,
	0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x6f, 0x73, 0x4b, 0x65, 0x72, 0x6e,
	0x65, 0x6c, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x39, 0x0a, 0x0b, 0x41, 0x70, 0x70,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x1a, 0x5f, 0x0a, 0x09, 0x44, 0x69, 0x73, 0x6b, 0x4d, 0x6f, 0x75, 0x6e,
	0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x6d, 0x6f, 0x75, 0x6e,
	0x74, 0x50, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x69, 0x73, 0x6b, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x64, 0x69, 0x73, 0x6b,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x1a, 0x49, 0x0a, 0x0e, 0x44, 0x69, 0x73, 0x6b, 0x44, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12,
	0x1f, 0x0a, 0x0b, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0xb2, 0x04, 0x0a, 0x0c, 0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x6f, 0x6c,
	0x65, 0x12, 0x1d, 0x0a, 0x19, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f,
	0x4c, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00,
	0x12, 0x16, 0x0a, 0x12, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c,
	0x45, 0x5f, 0x41, 0x53, 0x43, 0x53, 0x10, 0x01, 0x12, 0x15, 0x0a, 0x11, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x45, 0x52, 0x53, 0x10, 0x02, 0x12,
	0x1c, 0x0a, 0x18, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45,
	0x5f, 0x41, 0x50, 0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x04, 0x12, 0x1a, 0x0a,
	0x16, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x44,
	0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x08, 0x12, 0x1a, 0x0a, 0x16, 0x49, 0x4e, 0x53,
	0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x53, 0x5f,
	0x45, 0x52, 0x53, 0x10, 0x03, 0x12, 0x21, 0x0a, 0x1d, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x41, 0x50, 0x50, 0x5f,
	0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x05, 0x12, 0x1f, 0x0a, 0x1b, 0x49, 0x4e, 0x53, 0x54,
	0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x44,
	0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x09, 0x12, 0x20, 0x0a, 0x1c, 0x49, 0x4e, 0x53,
	0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x45, 0x52, 0x53, 0x5f, 0x41,
	0x50, 0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x06, 0x12, 0x1e, 0x0a, 0x1a, 0x49,
	0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x45, 0x52, 0x53,
	0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x0a, 0x12, 0x25, 0x0a, 0x21, 0x49,
	0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x41, 0x50, 0x50,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45,
	0x10, 0x0c, 0x12, 0x25, 0x0a, 0x21, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52,
	0x4f, 0x4c, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x45, 0x52, 0x53, 0x5f, 0x41, 0x50, 0x50,
	0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x10, 0x07, 0x12, 0x23, 0x0a, 0x1f, 0x49, 0x4e, 0x53,
	0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x53, 0x5f,
	0x45, 0x52, 0x53, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x0b, 0x12, 0x2a,
	0x0a, 0x26, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f,
	0x41, 0x53, 0x43, 0x53, 0x5f, 0x41, 0x50, 0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f,
	0x44, 0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x10, 0x0d, 0x12, 0x29, 0x0a, 0x25, 0x49, 0x4e,
	0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x45, 0x52, 0x53, 0x5f,
	0x41, 0x50, 0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42,
	0x41, 0x53, 0x45, 0x10, 0x0e, 0x12, 0x2e, 0x0a, 0x2a, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43,
	0x45, 0x5f, 0x52, 0x4f, 0x4c, 0x45, 0x5f, 0x41, 0x53, 0x43, 0x53, 0x5f, 0x45, 0x52, 0x53, 0x5f,
	0x41, 0x50, 0x50, 0x5f, 0x53, 0x45, 0x52, 0x56, 0x45, 0x52, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x42,
	0x41, 0x53, 0x45, 0x10, 0x0f, 0x22, 0x7e, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x55, 0x54, 0x45, 0x10, 0x01, 0x12,
	0x19, 0x0a, 0x15, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x53, 0x54, 0x4f, 0x52, 0x41, 0x47, 0x45, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45,
	0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x4e, 0x45, 0x54, 0x57,
	0x4f, 0x52, 0x4b, 0x10, 0x03, 0x22, 0xfc, 0x02, 0x0a, 0x0c, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x4b, 0x69, 0x6e, 0x64, 0x12, 0x1d, 0x0a, 0x19, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52,
	0x43, 0x45, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1a, 0x0a, 0x16, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x10,
	0x01, 0x12, 0x16, 0x0a, 0x12, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4b, 0x49,
	0x4e, 0x44, 0x5f, 0x44, 0x49, 0x53, 0x4b, 0x10, 0x02, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x53,
	0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45,
	0x53, 0x53, 0x10, 0x03, 0x12, 0x1b, 0x0a, 0x17, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x46, 0x49, 0x4c, 0x45, 0x53, 0x54, 0x4f, 0x52, 0x45, 0x10,
	0x04, 0x12, 0x1e, 0x0a, 0x1a, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4b, 0x49,
	0x4e, 0x44, 0x5f, 0x48, 0x45, 0x41, 0x4c, 0x54, 0x48, 0x5f, 0x43, 0x48, 0x45, 0x43, 0x4b, 0x10,
	0x05, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4b, 0x49,
	0x4e, 0x44, 0x5f, 0x46, 0x4f, 0x52, 0x57, 0x41, 0x52, 0x44, 0x49, 0x4e, 0x47, 0x5f, 0x52, 0x55,
	0x4c, 0x45, 0x10, 0x06, 0x12, 0x21, 0x0a, 0x1d, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45,
	0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x42, 0x41, 0x43, 0x4b, 0x45, 0x4e, 0x44, 0x5f, 0x53, 0x45,
	0x52, 0x56, 0x49, 0x43, 0x45, 0x10, 0x07, 0x12, 0x1c, 0x0a, 0x18, 0x52, 0x45, 0x53, 0x4f, 0x55,
	0x52, 0x43, 0x45, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x53, 0x55, 0x42, 0x4e, 0x45, 0x54, 0x57,
	0x4f, 0x52, 0x4b, 0x10, 0x08, 0x12, 0x19, 0x0a, 0x15, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43,
	0x45, 0x5f, 0x4b, 0x49, 0x4e, 0x44, 0x5f, 0x4e, 0x45, 0x54, 0x57, 0x4f, 0x52, 0x4b, 0x10, 0x09,
	0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4b, 0x49, 0x4e,
	0x44, 0x5f, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x5f, 0x41, 0x44, 0x44, 0x52, 0x45, 0x53, 0x53,
	0x10, 0x0a, 0x12, 0x20, 0x0a, 0x1c, 0x52, 0x45, 0x53, 0x4f, 0x55, 0x52, 0x43, 0x45, 0x5f, 0x4b,
	0x49, 0x4e, 0x44, 0x5f, 0x49, 0x4e, 0x53, 0x54, 0x41, 0x4e, 0x43, 0x45, 0x5f, 0x47, 0x52, 0x4f,
	0x55, 0x50, 0x10, 0x0b, 0x1a, 0x87, 0x10, 0x0a, 0x09, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x52,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63,
	0x65, 0x73, 0x12, 0x90, 0x01, 0x0a, 0x16, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x57, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e,
	0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x15,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x87, 0x01, 0x0a, 0x13, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x5f, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e,
	0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6d,
	0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50,
	0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x48, 0x00, 0x52, 0x12, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12,
	0x21, 0x0a, 0x0c, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x73, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x03, 0x73, 0x69, 0x64, 0x12, 0x73, 0x0a, 0x0d, 0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79,
	0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e, 0x77, 0x6f,
	0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x2e, 0x54,
	0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x74, 0x6f, 0x70,
	0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x68, 0x61, 0x5f,
	0x68, 0x6f, 0x73, 0x74, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x68, 0x61, 0x48,
	0x6f, 0x73, 0x74, 0x73, 0x12, 0x7e, 0x0a, 0x11, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x51, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x2e, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69,
	0x74, 0x65, 0x52, 0x10, 0x72, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x69, 0x74, 0x65, 0x73, 0x12, 0x16, 0x0a, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x18, 0x09,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x1a, 0x9a, 0x04, 0x0a,
	0x15, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x6f, 0x70,
	0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x92, 0x01, 0x0a, 0x10, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x67, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61,
	0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f,
	0x6e, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x08, 0x61,
	0x73, 0x63, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x61,
	0x73, 0x63, 0x73, 0x55, 0x72, 0x69, 0x12, 0x17, 0x0a, 0x07, 0x6e, 0x66, 0x73, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x66, 0x73, 0x55, 0x72, 0x69, 0x12,
	0x25, 0x0a, 0x0e, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6b, 0x65, 0x72, 0x6e, 0x65, 0x6c, 0x56,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x16, 0x0a, 0x04, 0x61, 0x62, 0x61, 0x70, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x04, 0x61, 0x62, 0x61, 0x70, 0x12, 0x2b,
	0x0a, 0x0f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x02, 0x18, 0x01, 0x52, 0x0e, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x30, 0x0a, 0x14, 0x61,
	0x73, 0x63, 0x73, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d,
	0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x61, 0x73, 0x63, 0x73, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x2e, 0x0a,
	0x13, 0x65, 0x72, 0x73, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x11, 0x65, 0x72, 0x73, 0x49,
	0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0x6a, 0x0a,
	0x0f, 0x41, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x20, 0x0a, 0x1c, 0x41, 0x50, 0x50, 0x4c, 0x49, 0x43, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x45, 0x54, 0x57, 0x45, 0x41, 0x56, 0x45, 0x52, 0x10,
	0x01, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x45, 0x54, 0x57, 0x45, 0x41, 0x56, 0x45, 0x52, 0x5f, 0x41,
	0x42, 0x41, 0x50, 0x10, 0x02, 0x12, 0x12, 0x0a, 0x0e, 0x4e, 0x45, 0x54, 0x57, 0x45, 0x41, 0x56,
	0x45, 0x52, 0x5f, 0x4a, 0x41, 0x56, 0x41, 0x10, 0x03, 0x1a, 0x80, 0x04, 0x0a, 0x12, 0x44, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73,
	0x12, 0x86, 0x01, 0x0a, 0x0d, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x61, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x2e, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x30, 0x0a, 0x14, 0x70, 0x72, 0x69,
	0x6d, 0x61, 0x72, 0x79, 0x5f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x75, 0x72,
	0x69, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x12, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
	0x49, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x55, 0x72, 0x69, 0x12, 0x24, 0x0a, 0x0e, 0x73,
	0x68, 0x61, 0x72, 0x65, 0x64, 0x5f, 0x6e, 0x66, 0x73, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0c, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x4e, 0x66, 0x73, 0x55, 0x72,
	0x69, 0x12, 0x29, 0x0a, 0x10, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x27, 0x0a, 0x0f,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0e, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e,
	0x75, 0x6d, 0x62, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x0c, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x5f, 0x73, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x53, 0x69, 0x64, 0x12, 0x21, 0x0a, 0x0c, 0x6c, 0x61, 0x6e, 0x64,
	0x73, 0x63, 0x61, 0x70, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b,
	0x6c, 0x61, 0x6e, 0x64, 0x73, 0x63, 0x61, 0x70, 0x65, 0x49, 0x64, 0x22, 0x6f, 0x0a, 0x0c, 0x44,
	0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x44,
	0x41, 0x54, 0x41, 0x42, 0x41, 0x53, 0x45, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x41,
	0x4e, 0x41, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x41, 0x58, 0x44, 0x42, 0x10, 0x02, 0x12,
	0x07, 0x0a, 0x03, 0x44, 0x42, 0x32, 0x10, 0x03, 0x12, 0x0a, 0x0a, 0x06, 0x4f, 0x52, 0x41, 0x43,
	0x4c, 0x45, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x51, 0x4c, 0x53, 0x45, 0x52, 0x56, 0x45,
	0x52, 0x10, 0x05, 0x12, 0x07, 0x0a, 0x03, 0x41, 0x53, 0x45, 0x10, 0x06, 0x1a, 0x93, 0x01, 0x0a,
	0x0f, 0x52, 0x65, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x69, 0x74, 0x65,
	0x12, 0x1f, 0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x73, 0x69, 0x74, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x53, 0x69, 0x74,
	0x65, 0x12, 0x5f, 0x0a, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d,
	0x2e, 0x53, 0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x43, 0x6f,
	0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x52, 0x09, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65,
	0x6e, 0x74, 0x22, 0x5c, 0x0a, 0x0c, 0x54, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x54, 0x4f, 0x50, 0x4f, 0x4c, 0x4f, 0x47, 0x59, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x15, 0x0a, 0x11, 0x54, 0x4f, 0x50, 0x4f, 0x4c, 0x4f, 0x47, 0x59, 0x5f, 0x53, 0x43,
	0x41, 0x4c, 0x45, 0x5f, 0x55, 0x50, 0x10, 0x01, 0x12, 0x16, 0x0a, 0x12, 0x54, 0x4f, 0x50, 0x4f,
	0x4c, 0x4f, 0x47, 0x59, 0x5f, 0x53, 0x43, 0x41, 0x4c, 0x45, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x02,
	0x42, 0x0c, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x1a, 0x87,
	0x04, 0x0a, 0x12, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x84, 0x01, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
	0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x59, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70,
	0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x50, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x70, 0x72, 0x6f,
	0x64, 0x75, 0x63, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0xa6, 0x01, 0x0a,
	0x1b, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e,
	0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x66, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65,
	0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53,
	0x61, 0x70, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x2e, 0x57, 0x6f, 0x72, 0x6b,
	0x6c, 0x6f, 0x61, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x53,
	0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74,
	0x50, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x52, 0x19, 0x73, 0x6f, 0x66, 0x74,
	0x77, 0x61, 0x72, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x3e, 0x0a, 0x0e, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
	0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x1a, 0x80, 0x01, 0x0a, 0x1b, 0x53, 0x6f, 0x66, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x70, 0x65,
	0x72, 0x74, 0x69, 0x65, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x65, 0x78, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x42, 0x4a, 0x5a, 0x48, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x73, 0x79,
	0x73, 0x74, 0x65, 0x6d, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_sharedprotos_system_system_proto_rawDescOnce sync.Once
	file_sharedprotos_system_system_proto_rawDescData = file_sharedprotos_system_system_proto_rawDesc
)

func file_sharedprotos_system_system_proto_rawDescGZIP() []byte {
	file_sharedprotos_system_system_proto_rawDescOnce.Do(func() {
		file_sharedprotos_system_system_proto_rawDescData = protoimpl.X.CompressGZIP(file_sharedprotos_system_system_proto_rawDescData)
	})
	return file_sharedprotos_system_system_proto_rawDescData
}

var file_sharedprotos_system_system_proto_enumTypes = make([]protoimpl.EnumInfo, 6)
var file_sharedprotos_system_system_proto_msgTypes = make([]protoimpl.MessageInfo, 14)
var file_sharedprotos_system_system_proto_goTypes = []interface{}{
	(SapDiscovery_Resource_ResourceType)(0),                             // 0: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.ResourceType
	(SapDiscovery_Resource_ResourceKind)(0),                             // 1: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.ResourceKind
	(SapDiscovery_Resource_InstanceProperties_InstanceRole)(0),          // 2: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.InstanceRole
	(SapDiscovery_Component_TopologyType)(0),                            // 3: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.TopologyType
	(SapDiscovery_Component_ApplicationProperties_ApplicationType)(0),   // 4: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.ApplicationProperties.ApplicationType
	(SapDiscovery_Component_DatabaseProperties_DatabaseType)(0),         // 5: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.DatabaseProperties.DatabaseType
	(*SapDiscovery)(nil),                                                // 6: workloadagentplatform.sharedprotos.system.SapDiscovery
	(*SapDiscovery_Metadata)(nil),                                       // 7: workloadagentplatform.sharedprotos.system.SapDiscovery.Metadata
	(*SapDiscovery_Resource)(nil),                                       // 8: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource
	(*SapDiscovery_Component)(nil),                                      // 9: workloadagentplatform.sharedprotos.system.SapDiscovery.Component
	(*SapDiscovery_WorkloadProperties)(nil),                             // 10: workloadagentplatform.sharedprotos.system.SapDiscovery.WorkloadProperties
	(*SapDiscovery_Resource_InstanceProperties)(nil),                    // 11: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties
	(*SapDiscovery_Resource_InstanceProperties_AppInstance)(nil),        // 12: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.AppInstance
	(*SapDiscovery_Resource_InstanceProperties_DiskMount)(nil),          // 13: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.DiskMount
	(*SapDiscovery_Resource_InstanceProperties_DiskDeviceName)(nil),     // 14: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.DiskDeviceName
	(*SapDiscovery_Component_ApplicationProperties)(nil),                // 15: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.ApplicationProperties
	(*SapDiscovery_Component_DatabaseProperties)(nil),                   // 16: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.DatabaseProperties
	(*SapDiscovery_Component_ReplicationSite)(nil),                      // 17: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.ReplicationSite
	(*SapDiscovery_WorkloadProperties_ProductVersion)(nil),              // 18: workloadagentplatform.sharedprotos.system.SapDiscovery.WorkloadProperties.ProductVersion
	(*SapDiscovery_WorkloadProperties_SoftwareComponentProperties)(nil), // 19: workloadagentplatform.sharedprotos.system.SapDiscovery.WorkloadProperties.SoftwareComponentProperties
	(*timestamppb.Timestamp)(nil),                                       // 20: google.protobuf.Timestamp
	(*status.KernelVersion)(nil),                                        // 21: workloadagentplatform.sharedprotos.status.KernelVersion
}
var file_sharedprotos_system_system_proto_depIdxs = []int32{
	7,  // 0: workloadagentplatform.sharedprotos.system.SapDiscovery.metadata:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Metadata
	9,  // 1: workloadagentplatform.sharedprotos.system.SapDiscovery.database_layer:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Component
	9,  // 2: workloadagentplatform.sharedprotos.system.SapDiscovery.application_layer:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Component
	20, // 3: workloadagentplatform.sharedprotos.system.SapDiscovery.update_time:type_name -> google.protobuf.Timestamp
	10, // 4: workloadagentplatform.sharedprotos.system.SapDiscovery.workload_properties:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.WorkloadProperties
	0,  // 5: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.resource_type:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.ResourceType
	1,  // 6: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.resource_kind:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.ResourceKind
	20, // 7: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.update_time:type_name -> google.protobuf.Timestamp
	11, // 8: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.instance_properties:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties
	8,  // 9: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.resources:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Resource
	15, // 10: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.application_properties:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Component.ApplicationProperties
	16, // 11: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.database_properties:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Component.DatabaseProperties
	3,  // 12: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.topology_type:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Component.TopologyType
	17, // 13: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.replication_sites:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Component.ReplicationSite
	18, // 14: workloadagentplatform.sharedprotos.system.SapDiscovery.WorkloadProperties.product_versions:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.WorkloadProperties.ProductVersion
	19, // 15: workloadagentplatform.sharedprotos.system.SapDiscovery.WorkloadProperties.software_component_versions:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.WorkloadProperties.SoftwareComponentProperties
	2,  // 16: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.instance_role:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.InstanceRole
	12, // 17: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.app_instances:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.AppInstance
	13, // 18: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.disk_mounts:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.DiskMount
	14, // 19: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.disk_device_names:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.DiskDeviceName
	21, // 20: workloadagentplatform.sharedprotos.system.SapDiscovery.Resource.InstanceProperties.os_kernel_version:type_name -> workloadagentplatform.sharedprotos.status.KernelVersion
	4,  // 21: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.ApplicationProperties.application_type:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Component.ApplicationProperties.ApplicationType
	5,  // 22: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.DatabaseProperties.database_type:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Component.DatabaseProperties.DatabaseType
	9,  // 23: workloadagentplatform.sharedprotos.system.SapDiscovery.Component.ReplicationSite.component:type_name -> workloadagentplatform.sharedprotos.system.SapDiscovery.Component
	24, // [24:24] is the sub-list for method output_type
	24, // [24:24] is the sub-list for method input_type
	24, // [24:24] is the sub-list for extension type_name
	24, // [24:24] is the sub-list for extension extendee
	0,  // [0:24] is the sub-list for field type_name
}

func init() { file_sharedprotos_system_system_proto_init() }
func file_sharedprotos_system_system_proto_init() {
	if File_sharedprotos_system_system_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_sharedprotos_system_system_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Metadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Resource); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Component); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_WorkloadProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Resource_InstanceProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Resource_InstanceProperties_AppInstance); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Resource_InstanceProperties_DiskMount); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Resource_InstanceProperties_DiskDeviceName); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Component_ApplicationProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Component_DatabaseProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_Component_ReplicationSite); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_WorkloadProperties_ProductVersion); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_system_system_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapDiscovery_WorkloadProperties_SoftwareComponentProperties); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_sharedprotos_system_system_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*SapDiscovery_Component_ApplicationProperties_)(nil),
		(*SapDiscovery_Component_DatabaseProperties_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sharedprotos_system_system_proto_rawDesc,
			NumEnums:      6,
			NumMessages:   14,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sharedprotos_system_system_proto_goTypes,
		DependencyIndexes: file_sharedprotos_system_system_proto_depIdxs,
		EnumInfos:         file_sharedprotos_system_system_proto_enumTypes,
		MessageInfos:      file_sharedprotos_system_system_proto_msgTypes,
	}.Build()
	File_sharedprotos_system_system_proto = out.File
	file_sharedprotos_system_system_proto_rawDesc = nil
	file_sharedprotos_system_system_proto_goTypes = nil
	file_sharedprotos_system_system_proto_depIdxs = nil
}
