# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class SubResource(_serialization.Model):
    """Reference to another subresource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AgentPool(SubResource):  # pylint: disable=too-many-instance-attributes
    """Agent Pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
     system pools. The default value is 1.
    :vartype count: int
    :ivar vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :vartype vnet_subnet_id: str
    :ivar max_pods: Maximum number of pods that can run on a node.
    :vartype max_pods: int
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :ivar max_count: Maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: Minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler.
    :vartype enable_auto_scaling: bool
    :ivar type_properties_type: AgentPoolType represents types of an agent pool. Known values are:
     "VirtualMachineScaleSets" and "AvailabilitySet".
    :vartype type_properties_type: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolType
    :ivar mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
     "User".
    :vartype mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolMode
    :ivar orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :vartype orchestrator_version: str
    :ivar node_image_version: Version of node image.
    :vartype node_image_version: str
    :ivar upgrade_settings: Settings for upgrading the agentpool.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :vartype availability_zones: list[str]
    :ivar enable_node_public_ip: Enable public IP for nodes.
    :vartype enable_node_public_ip: bool
    :ivar scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Known values are: "Spot" and "Regular".
    :vartype scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetPriority
    :ivar scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
     "Deallocate".
    :vartype scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetEvictionPolicy
    :ivar spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :vartype spot_max_price: float
    :ivar tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
    :vartype tags: dict[str, str]
    :ivar node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :vartype node_taints: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "os_disk_size_gb": {"maximum": 1023, "minimum": 0},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "count": {"key": "properties.count", "type": "int"},
        "vm_size": {"key": "properties.vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "properties.osDiskSizeGB", "type": "int"},
        "vnet_subnet_id": {"key": "properties.vnetSubnetID", "type": "str"},
        "max_pods": {"key": "properties.maxPods", "type": "int"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "max_count": {"key": "properties.maxCount", "type": "int"},
        "min_count": {"key": "properties.minCount", "type": "int"},
        "enable_auto_scaling": {"key": "properties.enableAutoScaling", "type": "bool"},
        "type_properties_type": {"key": "properties.type", "type": "str"},
        "mode": {"key": "properties.mode", "type": "str"},
        "orchestrator_version": {"key": "properties.orchestratorVersion", "type": "str"},
        "node_image_version": {"key": "properties.nodeImageVersion", "type": "str"},
        "upgrade_settings": {"key": "properties.upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "availability_zones": {"key": "properties.availabilityZones", "type": "[str]"},
        "enable_node_public_ip": {"key": "properties.enableNodePublicIP", "type": "bool"},
        "scale_set_priority": {"key": "properties.scaleSetPriority", "type": "str"},
        "scale_set_eviction_policy": {"key": "properties.scaleSetEvictionPolicy", "type": "str"},
        "spot_max_price": {"key": "properties.spotMaxPrice", "type": "float"},
        "tags": {"key": "properties.tags", "type": "{str}"},
        "node_labels": {"key": "properties.nodeLabels", "type": "{str}"},
        "node_taints": {"key": "properties.nodeTaints", "type": "[str]"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[Union[str, "_models.ContainerServiceVMSizeTypes"]] = None,
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Union[str, "_models.OSType"] = "Linux",
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        type_properties_type: Optional[Union[str, "_models.AgentPoolType"]] = None,
        mode: Optional[Union[str, "_models.AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        node_image_version: Optional[str] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        scale_set_priority: Union[str, "_models.ScaleSetPriority"] = "Regular",
        scale_set_eviction_policy: Union[str, "_models.ScaleSetEvictionPolicy"] = "Delete",
        spot_max_price: float = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
         system pools. The default value is 1.
        :paramtype count: int
        :keyword vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
         "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
         "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
         "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
         "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
         "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
         "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
        :paramtype vnet_subnet_id: str
        :keyword max_pods: Maximum number of pods that can run on a node.
        :paramtype max_pods: int
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
        :keyword max_count: Maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: Minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler.
        :paramtype enable_auto_scaling: bool
        :keyword type_properties_type: AgentPoolType represents types of an agent pool. Known values
         are: "VirtualMachineScaleSets" and "AvailabilitySet".
        :paramtype type_properties_type: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolType
        :keyword mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
         "User".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolMode
        :keyword orchestrator_version: Version of orchestrator specified when creating the managed
         cluster.
        :paramtype orchestrator_version: str
        :keyword node_image_version: Version of node image.
        :paramtype node_image_version: str
        :keyword upgrade_settings: Settings for upgrading the agentpool.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeSettings
        :keyword availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
         AgentPoolType.
        :paramtype availability_zones: list[str]
        :keyword enable_node_public_ip: Enable public IP for nodes.
        :paramtype enable_node_public_ip: bool
        :keyword scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
         priority. Default to regular. Known values are: "Spot" and "Regular".
        :paramtype scale_set_priority: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetPriority
        :keyword scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction
         policy for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
         "Deallocate".
        :paramtype scale_set_eviction_policy: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetEvictionPolicy
        :keyword spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing
         to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
         indicates default price to be up-to on-demand.
        :paramtype spot_max_price: float
        :keyword tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
        :paramtype tags: dict[str, str]
        :keyword node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: Taints added to new nodes during node pool create and scale. For example,
         key=value:NoSchedule.
        :paramtype node_taints: list[str]
        """
        super().__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.type_properties_type = type_properties_type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.node_image_version = node_image_version
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints


class AgentPoolAvailableVersions(_serialization.Model):
    """The list of available versions for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Id of the agent pool available versions.
    :vartype id: str
    :ivar name: Name of the agent pool available versions.
    :vartype name: str
    :ivar type: Type of the agent pool  available versions.
    :vartype type: str
    :ivar agent_pool_versions: List of versions available for agent pool.
    :vartype agent_pool_versions:
     list[~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "agent_pool_versions": {
            "key": "properties.agentPoolVersions",
            "type": "[AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]",
        },
    }

    def __init__(
        self,
        *,
        agent_pool_versions: Optional[List["_models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword agent_pool_versions: List of versions available for agent pool.
        :paramtype agent_pool_versions:
         list[~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.agent_pool_versions = agent_pool_versions


class AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem(_serialization.Model):  # pylint: disable=name-too-long
    """AgentPoolAvailableVersionsPropertiesAgentPoolVersionsItem.

    :ivar default: Whether this version is the default agent pool version.
    :vartype default: bool
    :ivar kubernetes_version: Kubernetes version (major, minor, patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "default": {"key": "default", "type": "bool"},
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self,
        *,
        default: Optional[bool] = None,
        kubernetes_version: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword default: Whether this version is the default agent pool version.
        :paramtype default: bool
        :keyword kubernetes_version: Kubernetes version (major, minor, patch).
        :paramtype kubernetes_version: str
        :keyword is_preview: Whether Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.default = default
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolListResult(_serialization.Model):
    """The response from the List Agent Pools operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of agent pools.
    :vartype value: list[~azure.mgmt.containerservice.v2020_04_01.models.AgentPool]
    :ivar next_link: The URL to get the next set of agent pool results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AgentPool]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AgentPool"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of agent pools.
        :paramtype value: list[~azure.mgmt.containerservice.v2020_04_01.models.AgentPool]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AgentPoolUpgradeProfile(_serialization.Model):
    """The list of available upgrades for an agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Id of the agent pool upgrade profile.
    :vartype id: str
    :ivar name: Name of the agent pool upgrade profile.
    :vartype name: str
    :ivar type: Type of the agent pool upgrade profile.
    :vartype type: str
    :ivar kubernetes_version: Kubernetes version (major, minor, patch). Required.
    :vartype kubernetes_version: str
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :ivar upgrades: List of orchestrator types and versions available for upgrade.
    :vartype upgrades:
     list[~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
    :ivar latest_node_image_version: LatestNodeImageVersion is the latest AKS supported node image
     version.
    :vartype latest_node_image_version: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "kubernetes_version": {"required": True},
        "os_type": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "os_type": {"key": "properties.osType", "type": "str"},
        "upgrades": {"key": "properties.upgrades", "type": "[AgentPoolUpgradeProfilePropertiesUpgradesItem]"},
        "latest_node_image_version": {"key": "properties.latestNodeImageVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "_models.OSType"] = "Linux",
        upgrades: Optional[List["_models.AgentPoolUpgradeProfilePropertiesUpgradesItem"]] = None,
        latest_node_image_version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: Kubernetes version (major, minor, patch). Required.
        :paramtype kubernetes_version: str
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
        :keyword upgrades: List of orchestrator types and versions available for upgrade.
        :paramtype upgrades:
         list[~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeProfilePropertiesUpgradesItem]
        :keyword latest_node_image_version: LatestNodeImageVersion is the latest AKS supported node
         image version.
        :paramtype latest_node_image_version: str
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.kubernetes_version = kubernetes_version
        self.os_type = os_type
        self.upgrades = upgrades
        self.latest_node_image_version = latest_node_image_version


class AgentPoolUpgradeProfilePropertiesUpgradesItem(_serialization.Model):  # pylint: disable=name-too-long
    """AgentPoolUpgradeProfilePropertiesUpgradesItem.

    :ivar kubernetes_version: Kubernetes version (major, minor, patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self, *, kubernetes_version: Optional[str] = None, is_preview: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: Kubernetes version (major, minor, patch).
        :paramtype kubernetes_version: str
        :keyword is_preview: Whether Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class AgentPoolUpgradeSettings(_serialization.Model):
    """Settings for upgrading an agentpool.

    :ivar max_surge: Count or percentage of additional nodes to be added during upgrade. If empty
     uses AKS default.
    :vartype max_surge: str
    """

    _attribute_map = {
        "max_surge": {"key": "maxSurge", "type": "str"},
    }

    def __init__(self, *, max_surge: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword max_surge: Count or percentage of additional nodes to be added during upgrade. If
         empty uses AKS default.
        :paramtype max_surge: str
        """
        super().__init__(**kwargs)
        self.max_surge = max_surge


class BaseManagedCluster(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """BaseManagedCluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar identity: The identity of the managed cluster, if configured.
    :vartype identity: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :ivar kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
    :vartype kubernetes_version: str
    :ivar dns_prefix: DNS prefix specified when creating the managed cluster.
    :vartype dns_prefix: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: FQDN of private cluster.
    :vartype private_fqdn: str
    :ivar agent_pool_profiles: Properties of the agent pool.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAgentPoolProfile]
    :ivar linux_profile: Profile for Linux VMs in the container service cluster.
    :vartype linux_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceLinuxProfile
    :ivar windows_profile: Profile for Windows VMs in the container service cluster.
    :vartype windows_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterWindowsProfile
    :ivar service_principal_profile: Information about a service principal identity for the cluster
     to use for manipulating Azure APIs.
    :vartype service_principal_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterServicePrincipalProfile
    :ivar addon_profiles: Profile of managed cluster add-on.
    :vartype addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAddonProfile]
    :ivar node_resource_group: Name of the resource group containing agent pool nodes.
    :vartype node_resource_group: str
    :ivar enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :vartype enable_rbac: bool
    :ivar enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
     policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
     aka.ms/aks/azpodpolicy.
    :vartype enable_pod_security_policy: bool
    :ivar network_profile: Profile of network configuration.
    :vartype network_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceNetworkProfile
    :ivar aad_profile: Profile of Azure Active Directory configuration.
    :vartype aad_profile: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAADProfile
    :ivar auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :vartype auto_scaler_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesAutoScalerProfile
    :ivar api_server_access_profile: Access profile for managed cluster API server.
    :vartype api_server_access_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAPIServerAccessProfile
    :ivar disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :vartype disk_encryption_set_id: str
    :ivar identity_profile: Identities associated with the cluster.
    :vartype identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesIdentityProfileValue]
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "max_agent_pools": {"readonly": True},
        "fqdn": {"readonly": True},
        "private_fqdn": {"readonly": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedClusterIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "max_agent_pools": {"key": "properties.maxAgentPools", "type": "int"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "dns_prefix": {"key": "properties.dnsPrefix", "type": "str"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "private_fqdn": {"key": "properties.privateFQDN", "type": "str"},
        "agent_pool_profiles": {"key": "properties.agentPoolProfiles", "type": "[ManagedClusterAgentPoolProfile]"},
        "linux_profile": {"key": "properties.linuxProfile", "type": "ContainerServiceLinuxProfile"},
        "windows_profile": {"key": "properties.windowsProfile", "type": "ManagedClusterWindowsProfile"},
        "service_principal_profile": {
            "key": "properties.servicePrincipalProfile",
            "type": "ManagedClusterServicePrincipalProfile",
        },
        "addon_profiles": {"key": "properties.addonProfiles", "type": "{ManagedClusterAddonProfile}"},
        "node_resource_group": {"key": "properties.nodeResourceGroup", "type": "str"},
        "enable_rbac": {"key": "properties.enableRBAC", "type": "bool"},
        "enable_pod_security_policy": {"key": "properties.enablePodSecurityPolicy", "type": "bool"},
        "network_profile": {"key": "properties.networkProfile", "type": "ContainerServiceNetworkProfile"},
        "aad_profile": {"key": "properties.aadProfile", "type": "ManagedClusterAADProfile"},
        "auto_scaler_profile": {
            "key": "properties.autoScalerProfile",
            "type": "ManagedClusterPropertiesAutoScalerProfile",
        },
        "api_server_access_profile": {
            "key": "properties.apiServerAccessProfile",
            "type": "ManagedClusterAPIServerAccessProfile",
        },
        "disk_encryption_set_id": {"key": "properties.diskEncryptionSetID", "type": "str"},
        "identity_profile": {
            "key": "properties.identityProfile",
            "type": "{ManagedClusterPropertiesIdentityProfileValue}",
        },
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedClusterIdentity"] = None,
        kubernetes_version: Optional[str] = None,
        dns_prefix: Optional[str] = None,
        agent_pool_profiles: Optional[List["_models.ManagedClusterAgentPoolProfile"]] = None,
        linux_profile: Optional["_models.ContainerServiceLinuxProfile"] = None,
        windows_profile: Optional["_models.ManagedClusterWindowsProfile"] = None,
        service_principal_profile: Optional["_models.ManagedClusterServicePrincipalProfile"] = None,
        addon_profiles: Optional[Dict[str, "_models.ManagedClusterAddonProfile"]] = None,
        node_resource_group: Optional[str] = None,
        enable_rbac: Optional[bool] = None,
        enable_pod_security_policy: Optional[bool] = None,
        network_profile: Optional["_models.ContainerServiceNetworkProfile"] = None,
        aad_profile: Optional["_models.ManagedClusterAADProfile"] = None,
        auto_scaler_profile: Optional["_models.ManagedClusterPropertiesAutoScalerProfile"] = None,
        api_server_access_profile: Optional["_models.ManagedClusterAPIServerAccessProfile"] = None,
        disk_encryption_set_id: Optional[str] = None,
        identity_profile: Optional[Dict[str, "_models.ManagedClusterPropertiesIdentityProfileValue"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the managed cluster, if configured.
        :paramtype identity: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterIdentity
        :keyword kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
        :paramtype kubernetes_version: str
        :keyword dns_prefix: DNS prefix specified when creating the managed cluster.
        :paramtype dns_prefix: str
        :keyword agent_pool_profiles: Properties of the agent pool.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAgentPoolProfile]
        :keyword linux_profile: Profile for Linux VMs in the container service cluster.
        :paramtype linux_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceLinuxProfile
        :keyword windows_profile: Profile for Windows VMs in the container service cluster.
        :paramtype windows_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterWindowsProfile
        :keyword service_principal_profile: Information about a service principal identity for the
         cluster to use for manipulating Azure APIs.
        :paramtype service_principal_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterServicePrincipalProfile
        :keyword addon_profiles: Profile of managed cluster add-on.
        :paramtype addon_profiles: dict[str,
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAddonProfile]
        :keyword node_resource_group: Name of the resource group containing agent pool nodes.
        :paramtype node_resource_group: str
        :keyword enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
        :paramtype enable_rbac: bool
        :keyword enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
         policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
         aka.ms/aks/azpodpolicy.
        :paramtype enable_pod_security_policy: bool
        :keyword network_profile: Profile of network configuration.
        :paramtype network_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceNetworkProfile
        :keyword aad_profile: Profile of Azure Active Directory configuration.
        :paramtype aad_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAADProfile
        :keyword auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
        :paramtype auto_scaler_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesAutoScalerProfile
        :keyword api_server_access_profile: Access profile for managed cluster API server.
        :paramtype api_server_access_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAPIServerAccessProfile
        :keyword disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
         encryption at rest.
        :paramtype disk_encryption_set_id: str
        :keyword identity_profile: Identities associated with the cluster.
        :paramtype identity_profile: dict[str,
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesIdentityProfileValue]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kubernetes_version
        self.dns_prefix = dns_prefix
        self.fqdn = None
        self.private_fqdn = None
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.windows_profile = windows_profile
        self.service_principal_profile = service_principal_profile
        self.addon_profiles = addon_profiles
        self.node_resource_group = node_resource_group
        self.enable_rbac = enable_rbac
        self.enable_pod_security_policy = enable_pod_security_policy
        self.network_profile = network_profile
        self.aad_profile = aad_profile
        self.auto_scaler_profile = auto_scaler_profile
        self.api_server_access_profile = api_server_access_profile
        self.disk_encryption_set_id = disk_encryption_set_id
        self.identity_profile = identity_profile


class CloudErrorBody(_serialization.Model):
    """An error response from the Container service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.containerservice.v2020_04_01.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.containerservice.v2020_04_01.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ContainerServiceDiagnosticsProfile(_serialization.Model):
    """Profile for diagnostics on the container service cluster.

    All required parameters must be populated in order to send to server.

    :ivar vm_diagnostics: Profile for diagnostics on the container service VMs. Required.
    :vartype vm_diagnostics:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMDiagnostics
    """

    _validation = {
        "vm_diagnostics": {"required": True},
    }

    _attribute_map = {
        "vm_diagnostics": {"key": "vmDiagnostics", "type": "ContainerServiceVMDiagnostics"},
    }

    def __init__(self, *, vm_diagnostics: "_models.ContainerServiceVMDiagnostics", **kwargs: Any) -> None:
        """
        :keyword vm_diagnostics: Profile for diagnostics on the container service VMs. Required.
        :paramtype vm_diagnostics:
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMDiagnostics
        """
        super().__init__(**kwargs)
        self.vm_diagnostics = vm_diagnostics


class ContainerServiceLinuxProfile(_serialization.Model):
    """Profile for Linux VMs in the container service cluster.

    All required parameters must be populated in order to send to server.

    :ivar admin_username: The administrator username to use for Linux VMs. Required.
    :vartype admin_username: str
    :ivar ssh: SSH configuration for Linux-based VMs running on Azure. Required.
    :vartype ssh: ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceSshConfiguration
    """

    _validation = {
        "admin_username": {"required": True, "pattern": r"^[A-Za-z][-A-Za-z0-9_]*$"},
        "ssh": {"required": True},
    }

    _attribute_map = {
        "admin_username": {"key": "adminUsername", "type": "str"},
        "ssh": {"key": "ssh", "type": "ContainerServiceSshConfiguration"},
    }

    def __init__(self, *, admin_username: str, ssh: "_models.ContainerServiceSshConfiguration", **kwargs: Any) -> None:
        """
        :keyword admin_username: The administrator username to use for Linux VMs. Required.
        :paramtype admin_username: str
        :keyword ssh: SSH configuration for Linux-based VMs running on Azure. Required.
        :paramtype ssh:
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceSshConfiguration
        """
        super().__init__(**kwargs)
        self.admin_username = admin_username
        self.ssh = ssh


class ContainerServiceMasterProfile(_serialization.Model):
    """Profile for the container service master.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar count: Number of masters (VMs) in the container service cluster. Allowed values are 1, 3,
     and 5. The default value is 1. Known values are: 1, 3, and 5.
    :vartype count: int or ~azure.mgmt.containerservice.v2020_04_01.models.Count
    :ivar dns_prefix: DNS prefix to be used to create the FQDN for the master pool. Required.
    :vartype dns_prefix: str
    :ivar vm_size: Size of agent VMs. Required. Known values are: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :vartype vnet_subnet_id: str
    :ivar first_consecutive_static_ip: FirstConsecutiveStaticIP used to specify the first static ip
     of masters.
    :vartype first_consecutive_static_ip: str
    :ivar storage_profile: Storage profile specifies what kind of storage used. Choose from
     StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
     orchestrator choice. Known values are: "StorageAccount" and "ManagedDisks".
    :vartype storage_profile: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceStorageProfileTypes
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    """

    _validation = {
        "dns_prefix": {"required": True},
        "vm_size": {"required": True},
        "os_disk_size_gb": {"maximum": 1023, "minimum": 0},
        "fqdn": {"readonly": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "dns_prefix": {"key": "dnsPrefix", "type": "str"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "osDiskSizeGB", "type": "int"},
        "vnet_subnet_id": {"key": "vnetSubnetID", "type": "str"},
        "first_consecutive_static_ip": {"key": "firstConsecutiveStaticIP", "type": "str"},
        "storage_profile": {"key": "storageProfile", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
    }

    def __init__(
        self,
        *,
        dns_prefix: str,
        vm_size: Union[str, "_models.ContainerServiceVMSizeTypes"],
        count: Union[int, "_models.Count"] = 1,
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        first_consecutive_static_ip: str = "10.240.255.5",
        storage_profile: Optional[Union[str, "_models.ContainerServiceStorageProfileTypes"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of masters (VMs) in the container service cluster. Allowed values are 1,
         3, and 5. The default value is 1. Known values are: 1, 3, and 5.
        :paramtype count: int or ~azure.mgmt.containerservice.v2020_04_01.models.Count
        :keyword dns_prefix: DNS prefix to be used to create the FQDN for the master pool. Required.
        :paramtype dns_prefix: str
        :keyword vm_size: Size of agent VMs. Required. Known values are: "Standard_A1", "Standard_A10",
         "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
         "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
         "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
         "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
         "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
         "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
        :paramtype vnet_subnet_id: str
        :keyword first_consecutive_static_ip: FirstConsecutiveStaticIP used to specify the first static
         ip of masters.
        :paramtype first_consecutive_static_ip: str
        :keyword storage_profile: Storage profile specifies what kind of storage used. Choose from
         StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
         orchestrator choice. Known values are: "StorageAccount" and "ManagedDisks".
        :paramtype storage_profile: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceStorageProfileTypes
        """
        super().__init__(**kwargs)
        self.count = count
        self.dns_prefix = dns_prefix
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.first_consecutive_static_ip = first_consecutive_static_ip
        self.storage_profile = storage_profile
        self.fqdn = None


class ContainerServiceNetworkProfile(_serialization.Model):
    """Profile of network configuration.

    :ivar network_plugin: Network plugin used for building Kubernetes network. Known values are:
     "azure" and "kubenet".
    :vartype network_plugin: str or ~azure.mgmt.containerservice.v2020_04_01.models.NetworkPlugin
    :ivar network_policy: Network policy used for building Kubernetes network. Known values are:
     "calico" and "azure".
    :vartype network_policy: str or ~azure.mgmt.containerservice.v2020_04_01.models.NetworkPolicy
    :ivar network_mode: Network mode used for building Kubernetes network. Known values are:
     "transparent" and "bridge".
    :vartype network_mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.NetworkMode
    :ivar pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
    :vartype pod_cidr: str
    :ivar service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It must
     not overlap with any Subnet IP ranges.
    :vartype service_cidr: str
    :ivar dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be within
     the Kubernetes service address range specified in serviceCidr.
    :vartype dns_service_ip: str
    :ivar docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
     must not overlap with any Subnet IP ranges or the Kubernetes service address range.
    :vartype docker_bridge_cidr: str
    :ivar outbound_type: The outbound (egress) routing method. Known values are: "loadBalancer" and
     "userDefinedRouting".
    :vartype outbound_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OutboundType
    :ivar load_balancer_sku: The load balancer sku for the managed cluster. Known values are:
     "standard" and "basic".
    :vartype load_balancer_sku: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.LoadBalancerSku
    :ivar load_balancer_profile: Profile of the cluster load balancer.
    :vartype load_balancer_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfile
    """

    _validation = {
        "pod_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
        "service_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
        "dns_service_ip": {
            "pattern": r"^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$"
        },
        "docker_bridge_cidr": {"pattern": r"^([0-9]{1,3}\.){3}[0-9]{1,3}(\/([0-9]|[1-2][0-9]|3[0-2]))?$"},
    }

    _attribute_map = {
        "network_plugin": {"key": "networkPlugin", "type": "str"},
        "network_policy": {"key": "networkPolicy", "type": "str"},
        "network_mode": {"key": "networkMode", "type": "str"},
        "pod_cidr": {"key": "podCidr", "type": "str"},
        "service_cidr": {"key": "serviceCidr", "type": "str"},
        "dns_service_ip": {"key": "dnsServiceIP", "type": "str"},
        "docker_bridge_cidr": {"key": "dockerBridgeCidr", "type": "str"},
        "outbound_type": {"key": "outboundType", "type": "str"},
        "load_balancer_sku": {"key": "loadBalancerSku", "type": "str"},
        "load_balancer_profile": {"key": "loadBalancerProfile", "type": "ManagedClusterLoadBalancerProfile"},
    }

    def __init__(
        self,
        *,
        network_plugin: Union[str, "_models.NetworkPlugin"] = "kubenet",
        network_policy: Optional[Union[str, "_models.NetworkPolicy"]] = None,
        network_mode: Optional[Union[str, "_models.NetworkMode"]] = None,
        pod_cidr: str = "10.244.0.0/16",
        service_cidr: str = "10.0.0.0/16",
        dns_service_ip: str = "10.0.0.10",
        docker_bridge_cidr: str = "172.17.0.1/16",
        outbound_type: Union[str, "_models.OutboundType"] = "loadBalancer",
        load_balancer_sku: Optional[Union[str, "_models.LoadBalancerSku"]] = None,
        load_balancer_profile: Optional["_models.ManagedClusterLoadBalancerProfile"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_plugin: Network plugin used for building Kubernetes network. Known values are:
         "azure" and "kubenet".
        :paramtype network_plugin: str or ~azure.mgmt.containerservice.v2020_04_01.models.NetworkPlugin
        :keyword network_policy: Network policy used for building Kubernetes network. Known values are:
         "calico" and "azure".
        :paramtype network_policy: str or ~azure.mgmt.containerservice.v2020_04_01.models.NetworkPolicy
        :keyword network_mode: Network mode used for building Kubernetes network. Known values are:
         "transparent" and "bridge".
        :paramtype network_mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.NetworkMode
        :keyword pod_cidr: A CIDR notation IP range from which to assign pod IPs when kubenet is used.
        :paramtype pod_cidr: str
        :keyword service_cidr: A CIDR notation IP range from which to assign service cluster IPs. It
         must not overlap with any Subnet IP ranges.
        :paramtype service_cidr: str
        :keyword dns_service_ip: An IP address assigned to the Kubernetes DNS service. It must be
         within the Kubernetes service address range specified in serviceCidr.
        :paramtype dns_service_ip: str
        :keyword docker_bridge_cidr: A CIDR notation IP range assigned to the Docker bridge network. It
         must not overlap with any Subnet IP ranges or the Kubernetes service address range.
        :paramtype docker_bridge_cidr: str
        :keyword outbound_type: The outbound (egress) routing method. Known values are: "loadBalancer"
         and "userDefinedRouting".
        :paramtype outbound_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OutboundType
        :keyword load_balancer_sku: The load balancer sku for the managed cluster. Known values are:
         "standard" and "basic".
        :paramtype load_balancer_sku: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.LoadBalancerSku
        :keyword load_balancer_profile: Profile of the cluster load balancer.
        :paramtype load_balancer_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfile
        """
        super().__init__(**kwargs)
        self.network_plugin = network_plugin
        self.network_policy = network_policy
        self.network_mode = network_mode
        self.pod_cidr = pod_cidr
        self.service_cidr = service_cidr
        self.dns_service_ip = dns_service_ip
        self.docker_bridge_cidr = docker_bridge_cidr
        self.outbound_type = outbound_type
        self.load_balancer_sku = load_balancer_sku
        self.load_balancer_profile = load_balancer_profile


class ContainerServiceSshConfiguration(_serialization.Model):
    """SSH configuration for Linux-based VMs running on Azure.

    All required parameters must be populated in order to send to server.

    :ivar public_keys: The list of SSH public keys used to authenticate with Linux-based VMs. Only
     expect one key specified. Required.
    :vartype public_keys:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceSshPublicKey]
    """

    _validation = {
        "public_keys": {"required": True},
    }

    _attribute_map = {
        "public_keys": {"key": "publicKeys", "type": "[ContainerServiceSshPublicKey]"},
    }

    def __init__(self, *, public_keys: List["_models.ContainerServiceSshPublicKey"], **kwargs: Any) -> None:
        """
        :keyword public_keys: The list of SSH public keys used to authenticate with Linux-based VMs.
         Only expect one key specified. Required.
        :paramtype public_keys:
         list[~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceSshPublicKey]
        """
        super().__init__(**kwargs)
        self.public_keys = public_keys


class ContainerServiceSshPublicKey(_serialization.Model):
    """Contains information about SSH certificate public key data.

    All required parameters must be populated in order to send to server.

    :ivar key_data: Certificate public key used to authenticate with VMs through SSH. The
     certificate must be in PEM format with or without headers. Required.
    :vartype key_data: str
    """

    _validation = {
        "key_data": {"required": True},
    }

    _attribute_map = {
        "key_data": {"key": "keyData", "type": "str"},
    }

    def __init__(self, *, key_data: str, **kwargs: Any) -> None:
        """
        :keyword key_data: Certificate public key used to authenticate with VMs through SSH. The
         certificate must be in PEM format with or without headers. Required.
        :paramtype key_data: str
        """
        super().__init__(**kwargs)
        self.key_data = key_data


class ContainerServiceVMDiagnostics(_serialization.Model):
    """Profile for diagnostics on the container service VMs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether the VM diagnostic agent is provisioned on the VM. Required.
    :vartype enabled: bool
    :ivar storage_uri: The URI of the storage account where diagnostics are stored.
    :vartype storage_uri: str
    """

    _validation = {
        "enabled": {"required": True},
        "storage_uri": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "storage_uri": {"key": "storageUri", "type": "str"},
    }

    def __init__(self, *, enabled: bool, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether the VM diagnostic agent is provisioned on the VM. Required.
        :paramtype enabled: bool
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = None


class CredentialResult(_serialization.Model):
    """The credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The name of the credential.
    :vartype name: str
    :ivar value: Base64-encoded Kubernetes configuration file.
    :vartype value: bytes
    """

    _validation = {
        "name": {"readonly": True},
        "value": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "value": {"key": "value", "type": "bytearray"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.value = None


class CredentialResults(_serialization.Model):
    """The list of credential result response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar kubeconfigs: Base64-encoded Kubernetes configuration file.
    :vartype kubeconfigs: list[~azure.mgmt.containerservice.v2020_04_01.models.CredentialResult]
    """

    _validation = {
        "kubeconfigs": {"readonly": True},
    }

    _attribute_map = {
        "kubeconfigs": {"key": "kubeconfigs", "type": "[CredentialResult]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.kubeconfigs = None


class Resource(_serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ManagedCluster(Resource, BaseManagedCluster):  # pylint: disable=too-many-instance-attributes
    """Managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar identity: The identity of the managed cluster, if configured.
    :vartype identity: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterIdentity
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar max_agent_pools: The max number of agent pools for the managed cluster.
    :vartype max_agent_pools: int
    :ivar kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
    :vartype kubernetes_version: str
    :ivar dns_prefix: DNS prefix specified when creating the managed cluster.
    :vartype dns_prefix: str
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    :ivar private_fqdn: FQDN of private cluster.
    :vartype private_fqdn: str
    :ivar agent_pool_profiles: Properties of the agent pool.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAgentPoolProfile]
    :ivar linux_profile: Profile for Linux VMs in the container service cluster.
    :vartype linux_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceLinuxProfile
    :ivar windows_profile: Profile for Windows VMs in the container service cluster.
    :vartype windows_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterWindowsProfile
    :ivar service_principal_profile: Information about a service principal identity for the cluster
     to use for manipulating Azure APIs.
    :vartype service_principal_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterServicePrincipalProfile
    :ivar addon_profiles: Profile of managed cluster add-on.
    :vartype addon_profiles: dict[str,
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAddonProfile]
    :ivar node_resource_group: Name of the resource group containing agent pool nodes.
    :vartype node_resource_group: str
    :ivar enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
    :vartype enable_rbac: bool
    :ivar enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
     policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
     aka.ms/aks/azpodpolicy.
    :vartype enable_pod_security_policy: bool
    :ivar network_profile: Profile of network configuration.
    :vartype network_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceNetworkProfile
    :ivar aad_profile: Profile of Azure Active Directory configuration.
    :vartype aad_profile: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAADProfile
    :ivar auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
    :vartype auto_scaler_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesAutoScalerProfile
    :ivar api_server_access_profile: Access profile for managed cluster API server.
    :vartype api_server_access_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAPIServerAccessProfile
    :ivar disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
     encryption at rest.
    :vartype disk_encryption_set_id: str
    :ivar identity_profile: Identities associated with the cluster.
    :vartype identity_profile: dict[str,
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesIdentityProfileValue]
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The managed cluster SKU.
    :vartype sku: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterSKU
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "max_agent_pools": {"readonly": True},
        "fqdn": {"readonly": True},
        "private_fqdn": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedClusterIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "max_agent_pools": {"key": "properties.maxAgentPools", "type": "int"},
        "kubernetes_version": {"key": "properties.kubernetesVersion", "type": "str"},
        "dns_prefix": {"key": "properties.dnsPrefix", "type": "str"},
        "fqdn": {"key": "properties.fqdn", "type": "str"},
        "private_fqdn": {"key": "properties.privateFQDN", "type": "str"},
        "agent_pool_profiles": {"key": "properties.agentPoolProfiles", "type": "[ManagedClusterAgentPoolProfile]"},
        "linux_profile": {"key": "properties.linuxProfile", "type": "ContainerServiceLinuxProfile"},
        "windows_profile": {"key": "properties.windowsProfile", "type": "ManagedClusterWindowsProfile"},
        "service_principal_profile": {
            "key": "properties.servicePrincipalProfile",
            "type": "ManagedClusterServicePrincipalProfile",
        },
        "addon_profiles": {"key": "properties.addonProfiles", "type": "{ManagedClusterAddonProfile}"},
        "node_resource_group": {"key": "properties.nodeResourceGroup", "type": "str"},
        "enable_rbac": {"key": "properties.enableRBAC", "type": "bool"},
        "enable_pod_security_policy": {"key": "properties.enablePodSecurityPolicy", "type": "bool"},
        "network_profile": {"key": "properties.networkProfile", "type": "ContainerServiceNetworkProfile"},
        "aad_profile": {"key": "properties.aadProfile", "type": "ManagedClusterAADProfile"},
        "auto_scaler_profile": {
            "key": "properties.autoScalerProfile",
            "type": "ManagedClusterPropertiesAutoScalerProfile",
        },
        "api_server_access_profile": {
            "key": "properties.apiServerAccessProfile",
            "type": "ManagedClusterAPIServerAccessProfile",
        },
        "disk_encryption_set_id": {"key": "properties.diskEncryptionSetID", "type": "str"},
        "identity_profile": {
            "key": "properties.identityProfile",
            "type": "{ManagedClusterPropertiesIdentityProfileValue}",
        },
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ManagedClusterSKU"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        identity: Optional["_models.ManagedClusterIdentity"] = None,
        kubernetes_version: Optional[str] = None,
        dns_prefix: Optional[str] = None,
        agent_pool_profiles: Optional[List["_models.ManagedClusterAgentPoolProfile"]] = None,
        linux_profile: Optional["_models.ContainerServiceLinuxProfile"] = None,
        windows_profile: Optional["_models.ManagedClusterWindowsProfile"] = None,
        service_principal_profile: Optional["_models.ManagedClusterServicePrincipalProfile"] = None,
        addon_profiles: Optional[Dict[str, "_models.ManagedClusterAddonProfile"]] = None,
        node_resource_group: Optional[str] = None,
        enable_rbac: Optional[bool] = None,
        enable_pod_security_policy: Optional[bool] = None,
        network_profile: Optional["_models.ContainerServiceNetworkProfile"] = None,
        aad_profile: Optional["_models.ManagedClusterAADProfile"] = None,
        auto_scaler_profile: Optional["_models.ManagedClusterPropertiesAutoScalerProfile"] = None,
        api_server_access_profile: Optional["_models.ManagedClusterAPIServerAccessProfile"] = None,
        disk_encryption_set_id: Optional[str] = None,
        identity_profile: Optional[Dict[str, "_models.ManagedClusterPropertiesIdentityProfileValue"]] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ManagedClusterSKU"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The identity of the managed cluster, if configured.
        :paramtype identity: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterIdentity
        :keyword kubernetes_version: Version of Kubernetes specified when creating the managed cluster.
        :paramtype kubernetes_version: str
        :keyword dns_prefix: DNS prefix specified when creating the managed cluster.
        :paramtype dns_prefix: str
        :keyword agent_pool_profiles: Properties of the agent pool.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAgentPoolProfile]
        :keyword linux_profile: Profile for Linux VMs in the container service cluster.
        :paramtype linux_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceLinuxProfile
        :keyword windows_profile: Profile for Windows VMs in the container service cluster.
        :paramtype windows_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterWindowsProfile
        :keyword service_principal_profile: Information about a service principal identity for the
         cluster to use for manipulating Azure APIs.
        :paramtype service_principal_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterServicePrincipalProfile
        :keyword addon_profiles: Profile of managed cluster add-on.
        :paramtype addon_profiles: dict[str,
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAddonProfile]
        :keyword node_resource_group: Name of the resource group containing agent pool nodes.
        :paramtype node_resource_group: str
        :keyword enable_rbac: Whether to enable Kubernetes Role-Based Access Control.
        :paramtype enable_rbac: bool
        :keyword enable_pod_security_policy: (DEPRECATING) Whether to enable Kubernetes pod security
         policy (preview). This feature is set for removal on October 15th, 2020. Learn more at
         aka.ms/aks/azpodpolicy.
        :paramtype enable_pod_security_policy: bool
        :keyword network_profile: Profile of network configuration.
        :paramtype network_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceNetworkProfile
        :keyword aad_profile: Profile of Azure Active Directory configuration.
        :paramtype aad_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAADProfile
        :keyword auto_scaler_profile: Parameters to be applied to the cluster-autoscaler when enabled.
        :paramtype auto_scaler_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesAutoScalerProfile
        :keyword api_server_access_profile: Access profile for managed cluster API server.
        :paramtype api_server_access_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAPIServerAccessProfile
        :keyword disk_encryption_set_id: ResourceId of the disk encryption set to use for enabling
         encryption at rest.
        :paramtype disk_encryption_set_id: str
        :keyword identity_profile: Identities associated with the cluster.
        :paramtype identity_profile: dict[str,
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPropertiesIdentityProfileValue]
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The managed cluster SKU.
        :paramtype sku: ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterSKU
        """
        super().__init__(
            location=location,
            tags=tags,
            identity=identity,
            kubernetes_version=kubernetes_version,
            dns_prefix=dns_prefix,
            agent_pool_profiles=agent_pool_profiles,
            linux_profile=linux_profile,
            windows_profile=windows_profile,
            service_principal_profile=service_principal_profile,
            addon_profiles=addon_profiles,
            node_resource_group=node_resource_group,
            enable_rbac=enable_rbac,
            enable_pod_security_policy=enable_pod_security_policy,
            network_profile=network_profile,
            aad_profile=aad_profile,
            auto_scaler_profile=auto_scaler_profile,
            api_server_access_profile=api_server_access_profile,
            disk_encryption_set_id=disk_encryption_set_id,
            identity_profile=identity_profile,
            **kwargs
        )
        self.identity = identity
        self.provisioning_state = None
        self.max_agent_pools = None
        self.kubernetes_version = kubernetes_version
        self.dns_prefix = dns_prefix
        self.fqdn = None
        self.private_fqdn = None
        self.agent_pool_profiles = agent_pool_profiles
        self.linux_profile = linux_profile
        self.windows_profile = windows_profile
        self.service_principal_profile = service_principal_profile
        self.addon_profiles = addon_profiles
        self.node_resource_group = node_resource_group
        self.enable_rbac = enable_rbac
        self.enable_pod_security_policy = enable_pod_security_policy
        self.network_profile = network_profile
        self.aad_profile = aad_profile
        self.auto_scaler_profile = auto_scaler_profile
        self.api_server_access_profile = api_server_access_profile
        self.disk_encryption_set_id = disk_encryption_set_id
        self.identity_profile = identity_profile
        self.sku = sku
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ManagedClusterAADProfile(_serialization.Model):
    """AADProfile specifies attributes for Azure Active Directory integration.

    :ivar managed: Whether to enable managed AAD.
    :vartype managed: bool
    :ivar admin_group_object_i_ds: AAD group object IDs that will have admin role of the cluster.
    :vartype admin_group_object_i_ds: list[str]
    :ivar client_app_id: The client AAD application ID.
    :vartype client_app_id: str
    :ivar server_app_id: The server AAD application ID.
    :vartype server_app_id: str
    :ivar server_app_secret: The server AAD application secret.
    :vartype server_app_secret: str
    :ivar tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
     tenant of the deployment subscription.
    :vartype tenant_id: str
    """

    _attribute_map = {
        "managed": {"key": "managed", "type": "bool"},
        "admin_group_object_i_ds": {"key": "adminGroupObjectIDs", "type": "[str]"},
        "client_app_id": {"key": "clientAppID", "type": "str"},
        "server_app_id": {"key": "serverAppID", "type": "str"},
        "server_app_secret": {"key": "serverAppSecret", "type": "str"},
        "tenant_id": {"key": "tenantID", "type": "str"},
    }

    def __init__(
        self,
        *,
        managed: Optional[bool] = None,
        admin_group_object_i_ds: Optional[List[str]] = None,
        client_app_id: Optional[str] = None,
        server_app_id: Optional[str] = None,
        server_app_secret: Optional[str] = None,
        tenant_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed: Whether to enable managed AAD.
        :paramtype managed: bool
        :keyword admin_group_object_i_ds: AAD group object IDs that will have admin role of the
         cluster.
        :paramtype admin_group_object_i_ds: list[str]
        :keyword client_app_id: The client AAD application ID.
        :paramtype client_app_id: str
        :keyword server_app_id: The server AAD application ID.
        :paramtype server_app_id: str
        :keyword server_app_secret: The server AAD application secret.
        :paramtype server_app_secret: str
        :keyword tenant_id: The AAD tenant ID to use for authentication. If not specified, will use the
         tenant of the deployment subscription.
        :paramtype tenant_id: str
        """
        super().__init__(**kwargs)
        self.managed = managed
        self.admin_group_object_i_ds = admin_group_object_i_ds
        self.client_app_id = client_app_id
        self.server_app_id = server_app_id
        self.server_app_secret = server_app_secret
        self.tenant_id = tenant_id


class ManagedClusterAccessProfile(Resource):
    """Managed cluster Access Profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location. Required.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar kube_config: Base64-encoded Kubernetes configuration file.
    :vartype kube_config: bytes
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "kube_config": {"key": "properties.kubeConfig", "type": "bytearray"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        kube_config: Optional[bytes] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: Resource location. Required.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword kube_config: Base64-encoded Kubernetes configuration file.
        :paramtype kube_config: bytes
        """
        super().__init__(location=location, tags=tags, **kwargs)
        self.kube_config = kube_config


class ManagedClusterAddonProfile(_serialization.Model):
    """A Kubernetes add-on profile for a managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar enabled: Whether the add-on is enabled or not. Required.
    :vartype enabled: bool
    :ivar config: Key-value pairs for configuring an add-on.
    :vartype config: dict[str, str]
    :ivar identity: Information of user assigned identity used by this add-on.
    :vartype identity:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterAddonProfileIdentity
    """

    _validation = {
        "enabled": {"required": True},
        "identity": {"readonly": True},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "bool"},
        "config": {"key": "config", "type": "{str}"},
        "identity": {"key": "identity", "type": "ManagedClusterAddonProfileIdentity"},
    }

    def __init__(self, *, enabled: bool, config: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword enabled: Whether the add-on is enabled or not. Required.
        :paramtype enabled: bool
        :keyword config: Key-value pairs for configuring an add-on.
        :paramtype config: dict[str, str]
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.config = config
        self.identity = None


class UserAssignedIdentity(_serialization.Model):
    """UserAssignedIdentity.

    :ivar resource_id: The resource id of the user assigned identity.
    :vartype resource_id: str
    :ivar client_id: The client id of the user assigned identity.
    :vartype client_id: str
    :ivar object_id: The object id of the user assigned identity.
    :vartype object_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
        "object_id": {"key": "objectId", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_id: Optional[str] = None,
        client_id: Optional[str] = None,
        object_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_id: The resource id of the user assigned identity.
        :paramtype resource_id: str
        :keyword client_id: The client id of the user assigned identity.
        :paramtype client_id: str
        :keyword object_id: The object id of the user assigned identity.
        :paramtype object_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.client_id = client_id
        self.object_id = object_id


class ManagedClusterAddonProfileIdentity(UserAssignedIdentity):
    """Information of user assigned identity used by this add-on.

    :ivar resource_id: The resource id of the user assigned identity.
    :vartype resource_id: str
    :ivar client_id: The client id of the user assigned identity.
    :vartype client_id: str
    :ivar object_id: The object id of the user assigned identity.
    :vartype object_id: str
    """


class ManagedClusterAgentPoolProfileProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Properties for the container service agent pool profile.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
     system pools. The default value is 1.
    :vartype count: int
    :ivar vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :vartype vnet_subnet_id: str
    :ivar max_pods: Maximum number of pods that can run on a node.
    :vartype max_pods: int
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :ivar max_count: Maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: Minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler.
    :vartype enable_auto_scaling: bool
    :ivar type: AgentPoolType represents types of an agent pool. Known values are:
     "VirtualMachineScaleSets" and "AvailabilitySet".
    :vartype type: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolType
    :ivar mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
     "User".
    :vartype mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolMode
    :ivar orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :vartype orchestrator_version: str
    :ivar node_image_version: Version of node image.
    :vartype node_image_version: str
    :ivar upgrade_settings: Settings for upgrading the agentpool.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :vartype availability_zones: list[str]
    :ivar enable_node_public_ip: Enable public IP for nodes.
    :vartype enable_node_public_ip: bool
    :ivar scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Known values are: "Spot" and "Regular".
    :vartype scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetPriority
    :ivar scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
     "Deallocate".
    :vartype scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetEvictionPolicy
    :ivar spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :vartype spot_max_price: float
    :ivar tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
    :vartype tags: dict[str, str]
    :ivar node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :vartype node_taints: list[str]
    """

    _validation = {
        "os_disk_size_gb": {"maximum": 1023, "minimum": 0},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "osDiskSizeGB", "type": "int"},
        "vnet_subnet_id": {"key": "vnetSubnetID", "type": "str"},
        "max_pods": {"key": "maxPods", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "max_count": {"key": "maxCount", "type": "int"},
        "min_count": {"key": "minCount", "type": "int"},
        "enable_auto_scaling": {"key": "enableAutoScaling", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "orchestrator_version": {"key": "orchestratorVersion", "type": "str"},
        "node_image_version": {"key": "nodeImageVersion", "type": "str"},
        "upgrade_settings": {"key": "upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "enable_node_public_ip": {"key": "enableNodePublicIP", "type": "bool"},
        "scale_set_priority": {"key": "scaleSetPriority", "type": "str"},
        "scale_set_eviction_policy": {"key": "scaleSetEvictionPolicy", "type": "str"},
        "spot_max_price": {"key": "spotMaxPrice", "type": "float"},
        "tags": {"key": "tags", "type": "{str}"},
        "node_labels": {"key": "nodeLabels", "type": "{str}"},
        "node_taints": {"key": "nodeTaints", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        count: Optional[int] = None,
        vm_size: Optional[Union[str, "_models.ContainerServiceVMSizeTypes"]] = None,
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Union[str, "_models.OSType"] = "Linux",
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        type: Optional[Union[str, "_models.AgentPoolType"]] = None,
        mode: Optional[Union[str, "_models.AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        node_image_version: Optional[str] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        scale_set_priority: Union[str, "_models.ScaleSetPriority"] = "Regular",
        scale_set_eviction_policy: Union[str, "_models.ScaleSetEvictionPolicy"] = "Delete",
        spot_max_price: float = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
         system pools. The default value is 1.
        :paramtype count: int
        :keyword vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
         "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
         "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
         "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
         "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
         "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
         "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
        :paramtype vnet_subnet_id: str
        :keyword max_pods: Maximum number of pods that can run on a node.
        :paramtype max_pods: int
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
        :keyword max_count: Maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: Minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler.
        :paramtype enable_auto_scaling: bool
        :keyword type: AgentPoolType represents types of an agent pool. Known values are:
         "VirtualMachineScaleSets" and "AvailabilitySet".
        :paramtype type: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolType
        :keyword mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
         "User".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolMode
        :keyword orchestrator_version: Version of orchestrator specified when creating the managed
         cluster.
        :paramtype orchestrator_version: str
        :keyword node_image_version: Version of node image.
        :paramtype node_image_version: str
        :keyword upgrade_settings: Settings for upgrading the agentpool.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeSettings
        :keyword availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
         AgentPoolType.
        :paramtype availability_zones: list[str]
        :keyword enable_node_public_ip: Enable public IP for nodes.
        :paramtype enable_node_public_ip: bool
        :keyword scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
         priority. Default to regular. Known values are: "Spot" and "Regular".
        :paramtype scale_set_priority: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetPriority
        :keyword scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction
         policy for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
         "Deallocate".
        :paramtype scale_set_eviction_policy: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetEvictionPolicy
        :keyword spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing
         to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
         indicates default price to be up-to on-demand.
        :paramtype spot_max_price: float
        :keyword tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
        :paramtype tags: dict[str, str]
        :keyword node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: Taints added to new nodes during node pool create and scale. For example,
         key=value:NoSchedule.
        :paramtype node_taints: list[str]
        """
        super().__init__(**kwargs)
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.max_pods = max_pods
        self.os_type = os_type
        self.max_count = max_count
        self.min_count = min_count
        self.enable_auto_scaling = enable_auto_scaling
        self.type = type
        self.mode = mode
        self.orchestrator_version = orchestrator_version
        self.node_image_version = node_image_version
        self.upgrade_settings = upgrade_settings
        self.provisioning_state = None
        self.availability_zones = availability_zones
        self.enable_node_public_ip = enable_node_public_ip
        self.scale_set_priority = scale_set_priority
        self.scale_set_eviction_policy = scale_set_eviction_policy
        self.spot_max_price = spot_max_price
        self.tags = tags
        self.node_labels = node_labels
        self.node_taints = node_taints


class ManagedClusterAgentPoolProfile(
    ManagedClusterAgentPoolProfileProperties
):  # pylint: disable=too-many-instance-attributes
    """Profile for the container service agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
     system pools. The default value is 1.
    :vartype count: int
    :ivar vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
     "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
     "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
     "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
     "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
     "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
     "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :vartype vnet_subnet_id: str
    :ivar max_pods: Maximum number of pods that can run on a node.
    :vartype max_pods: int
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :ivar max_count: Maximum number of nodes for auto-scaling.
    :vartype max_count: int
    :ivar min_count: Minimum number of nodes for auto-scaling.
    :vartype min_count: int
    :ivar enable_auto_scaling: Whether to enable auto-scaler.
    :vartype enable_auto_scaling: bool
    :ivar type: AgentPoolType represents types of an agent pool. Known values are:
     "VirtualMachineScaleSets" and "AvailabilitySet".
    :vartype type: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolType
    :ivar mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
     "User".
    :vartype mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolMode
    :ivar orchestrator_version: Version of orchestrator specified when creating the managed
     cluster.
    :vartype orchestrator_version: str
    :ivar node_image_version: Version of node image.
    :vartype node_image_version: str
    :ivar upgrade_settings: Settings for upgrading the agentpool.
    :vartype upgrade_settings:
     ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeSettings
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
     AgentPoolType.
    :vartype availability_zones: list[str]
    :ivar enable_node_public_ip: Enable public IP for nodes.
    :vartype enable_node_public_ip: bool
    :ivar scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
     priority. Default to regular. Known values are: "Spot" and "Regular".
    :vartype scale_set_priority: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetPriority
    :ivar scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction policy
     for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
     "Deallocate".
    :vartype scale_set_eviction_policy: str or
     ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetEvictionPolicy
    :ivar spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing to
     pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
     indicates default price to be up-to on-demand.
    :vartype spot_max_price: float
    :ivar tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
    :vartype tags: dict[str, str]
    :ivar node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
    :vartype node_labels: dict[str, str]
    :ivar node_taints: Taints added to new nodes during node pool create and scale. For example,
     key=value:NoSchedule.
    :vartype node_taints: list[str]
    :ivar name: Unique name of the agent pool profile in the context of the subscription and
     resource group. Required.
    :vartype name: str
    """

    _validation = {
        "os_disk_size_gb": {"maximum": 1023, "minimum": 0},
        "provisioning_state": {"readonly": True},
        "name": {"required": True, "pattern": r"^[a-z][a-z0-9]{0,11}$"},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
        "vm_size": {"key": "vmSize", "type": "str"},
        "os_disk_size_gb": {"key": "osDiskSizeGB", "type": "int"},
        "vnet_subnet_id": {"key": "vnetSubnetID", "type": "str"},
        "max_pods": {"key": "maxPods", "type": "int"},
        "os_type": {"key": "osType", "type": "str"},
        "max_count": {"key": "maxCount", "type": "int"},
        "min_count": {"key": "minCount", "type": "int"},
        "enable_auto_scaling": {"key": "enableAutoScaling", "type": "bool"},
        "type": {"key": "type", "type": "str"},
        "mode": {"key": "mode", "type": "str"},
        "orchestrator_version": {"key": "orchestratorVersion", "type": "str"},
        "node_image_version": {"key": "nodeImageVersion", "type": "str"},
        "upgrade_settings": {"key": "upgradeSettings", "type": "AgentPoolUpgradeSettings"},
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "availability_zones": {"key": "availabilityZones", "type": "[str]"},
        "enable_node_public_ip": {"key": "enableNodePublicIP", "type": "bool"},
        "scale_set_priority": {"key": "scaleSetPriority", "type": "str"},
        "scale_set_eviction_policy": {"key": "scaleSetEvictionPolicy", "type": "str"},
        "spot_max_price": {"key": "spotMaxPrice", "type": "float"},
        "tags": {"key": "tags", "type": "{str}"},
        "node_labels": {"key": "nodeLabels", "type": "{str}"},
        "node_taints": {"key": "nodeTaints", "type": "[str]"},
        "name": {"key": "name", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        name: str,
        count: Optional[int] = None,
        vm_size: Optional[Union[str, "_models.ContainerServiceVMSizeTypes"]] = None,
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        max_pods: Optional[int] = None,
        os_type: Union[str, "_models.OSType"] = "Linux",
        max_count: Optional[int] = None,
        min_count: Optional[int] = None,
        enable_auto_scaling: Optional[bool] = None,
        type: Optional[Union[str, "_models.AgentPoolType"]] = None,
        mode: Optional[Union[str, "_models.AgentPoolMode"]] = None,
        orchestrator_version: Optional[str] = None,
        node_image_version: Optional[str] = None,
        upgrade_settings: Optional["_models.AgentPoolUpgradeSettings"] = None,
        availability_zones: Optional[List[str]] = None,
        enable_node_public_ip: Optional[bool] = None,
        scale_set_priority: Union[str, "_models.ScaleSetPriority"] = "Regular",
        scale_set_eviction_policy: Union[str, "_models.ScaleSetEvictionPolicy"] = "Delete",
        spot_max_price: float = -1,
        tags: Optional[Dict[str, str]] = None,
        node_labels: Optional[Dict[str, str]] = None,
        node_taints: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 0 to 100 (inclusive) for user pools and in the range of 1 to 100 (inclusive) for
         system pools. The default value is 1.
        :paramtype count: int
        :keyword vm_size: Size of agent VMs. Known values are: "Standard_A1", "Standard_A10",
         "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2", "Standard_A2m_v2",
         "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2", "Standard_A5",
         "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2", "Standard_A8m_v2",
         "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms", "Standard_B8ms",
         "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo", "Standard_D12",
         "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", and "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
        :paramtype vnet_subnet_id: str
        :keyword max_pods: Maximum number of pods that can run on a node.
        :paramtype max_pods: int
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
        :keyword max_count: Maximum number of nodes for auto-scaling.
        :paramtype max_count: int
        :keyword min_count: Minimum number of nodes for auto-scaling.
        :paramtype min_count: int
        :keyword enable_auto_scaling: Whether to enable auto-scaler.
        :paramtype enable_auto_scaling: bool
        :keyword type: AgentPoolType represents types of an agent pool. Known values are:
         "VirtualMachineScaleSets" and "AvailabilitySet".
        :paramtype type: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolType
        :keyword mode: AgentPoolMode represents mode of an agent pool. Known values are: "System" and
         "User".
        :paramtype mode: str or ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolMode
        :keyword orchestrator_version: Version of orchestrator specified when creating the managed
         cluster.
        :paramtype orchestrator_version: str
        :keyword node_image_version: Version of node image.
        :paramtype node_image_version: str
        :keyword upgrade_settings: Settings for upgrading the agentpool.
        :paramtype upgrade_settings:
         ~azure.mgmt.containerservice.v2020_04_01.models.AgentPoolUpgradeSettings
        :keyword availability_zones: Availability zones for nodes. Must use VirtualMachineScaleSets
         AgentPoolType.
        :paramtype availability_zones: list[str]
        :keyword enable_node_public_ip: Enable public IP for nodes.
        :paramtype enable_node_public_ip: bool
        :keyword scale_set_priority: ScaleSetPriority to be used to specify virtual machine scale set
         priority. Default to regular. Known values are: "Spot" and "Regular".
        :paramtype scale_set_priority: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetPriority
        :keyword scale_set_eviction_policy: ScaleSetEvictionPolicy to be used to specify eviction
         policy for Spot virtual machine scale set. Default to Delete. Known values are: "Delete" and
         "Deallocate".
        :paramtype scale_set_eviction_policy: str or
         ~azure.mgmt.containerservice.v2020_04_01.models.ScaleSetEvictionPolicy
        :keyword spot_max_price: SpotMaxPrice to be used to specify the maximum price you are willing
         to pay in US Dollars. Possible values are any decimal value greater than zero or -1 which
         indicates default price to be up-to on-demand.
        :paramtype spot_max_price: float
        :keyword tags: Agent pool tags to be persisted on the agent pool virtual machine scale set.
        :paramtype tags: dict[str, str]
        :keyword node_labels: Agent pool node labels to be persisted across all nodes in agent pool.
        :paramtype node_labels: dict[str, str]
        :keyword node_taints: Taints added to new nodes during node pool create and scale. For example,
         key=value:NoSchedule.
        :paramtype node_taints: list[str]
        :keyword name: Unique name of the agent pool profile in the context of the subscription and
         resource group. Required.
        :paramtype name: str
        """
        super().__init__(
            count=count,
            vm_size=vm_size,
            os_disk_size_gb=os_disk_size_gb,
            vnet_subnet_id=vnet_subnet_id,
            max_pods=max_pods,
            os_type=os_type,
            max_count=max_count,
            min_count=min_count,
            enable_auto_scaling=enable_auto_scaling,
            type=type,
            mode=mode,
            orchestrator_version=orchestrator_version,
            node_image_version=node_image_version,
            upgrade_settings=upgrade_settings,
            availability_zones=availability_zones,
            enable_node_public_ip=enable_node_public_ip,
            scale_set_priority=scale_set_priority,
            scale_set_eviction_policy=scale_set_eviction_policy,
            spot_max_price=spot_max_price,
            tags=tags,
            node_labels=node_labels,
            node_taints=node_taints,
            **kwargs
        )
        self.name = name


class ManagedClusterAPIServerAccessProfile(_serialization.Model):
    """Access profile for managed cluster API server.

    :ivar authorized_ip_ranges: Authorized IP Ranges to kubernetes API server.
    :vartype authorized_ip_ranges: list[str]
    :ivar enable_private_cluster: Whether to create the cluster as a private cluster or not.
    :vartype enable_private_cluster: bool
    """

    _attribute_map = {
        "authorized_ip_ranges": {"key": "authorizedIPRanges", "type": "[str]"},
        "enable_private_cluster": {"key": "enablePrivateCluster", "type": "bool"},
    }

    def __init__(
        self,
        *,
        authorized_ip_ranges: Optional[List[str]] = None,
        enable_private_cluster: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authorized_ip_ranges: Authorized IP Ranges to kubernetes API server.
        :paramtype authorized_ip_ranges: list[str]
        :keyword enable_private_cluster: Whether to create the cluster as a private cluster or not.
        :paramtype enable_private_cluster: bool
        """
        super().__init__(**kwargs)
        self.authorized_ip_ranges = authorized_ip_ranges
        self.enable_private_cluster = enable_private_cluster


class ManagedClusterIdentity(_serialization.Model):
    """Identity for the managed cluster.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of the system assigned identity which is used by master
     components.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id of the system assigned identity which is used by master
     components.
    :vartype tenant_id: str
    :ivar type: The type of identity used for the managed cluster. Type 'SystemAssigned' will use
     an implicitly created identity in master components and an auto-created user assigned identity
     in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed cluster,
     service principal will be used instead. Known values are: "SystemAssigned" and "None".
    :vartype type: str or ~azure.mgmt.containerservice.v2020_04_01.models.ResourceIdentityType
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, type: Optional[Union[str, "_models.ResourceIdentityType"]] = None, **kwargs: Any) -> None:
        """
        :keyword type: The type of identity used for the managed cluster. Type 'SystemAssigned' will
         use an implicitly created identity in master components and an auto-created user assigned
         identity in MC_ resource group in agent nodes. Type 'None' will not use MSI for the managed
         cluster, service principal will be used instead. Known values are: "SystemAssigned" and "None".
        :paramtype type: str or ~azure.mgmt.containerservice.v2020_04_01.models.ResourceIdentityType
        """
        super().__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class ManagedClusterListResult(_serialization.Model):
    """The response from the List Managed Clusters operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of managed clusters.
    :vartype value: list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedCluster]
    :ivar next_link: The URL to get the next set of managed cluster results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ManagedCluster]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ManagedCluster"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: The list of managed clusters.
        :paramtype value: list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedCluster]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ManagedClusterLoadBalancerProfile(_serialization.Model):
    """Profile of the managed cluster load balancer.

    :ivar managed_outbound_i_ps: Desired managed outbound IPs for the cluster load balancer.
    :vartype managed_outbound_i_ps:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
    :ivar outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load balancer.
    :vartype outbound_ip_prefixes:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
    :ivar outbound_i_ps: Desired outbound IP resources for the cluster load balancer.
    :vartype outbound_i_ps:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
    :ivar effective_outbound_i_ps: The effective outbound IP resources of the cluster load
     balancer.
    :vartype effective_outbound_i_ps:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ResourceReference]
    :ivar allocated_outbound_ports: Desired number of allocated SNAT ports per VM. Allowed values
     must be in the range of 0 to 64000 (inclusive). The default value is 0 which results in Azure
     dynamically allocating ports.
    :vartype allocated_outbound_ports: int
    :ivar idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
     must be in the range of 4 to 120 (inclusive). The default value is 30 minutes.
    :vartype idle_timeout_in_minutes: int
    """

    _validation = {
        "allocated_outbound_ports": {"maximum": 64000, "minimum": 0},
        "idle_timeout_in_minutes": {"maximum": 120, "minimum": 4},
    }

    _attribute_map = {
        "managed_outbound_i_ps": {
            "key": "managedOutboundIPs",
            "type": "ManagedClusterLoadBalancerProfileManagedOutboundIPs",
        },
        "outbound_ip_prefixes": {
            "key": "outboundIPPrefixes",
            "type": "ManagedClusterLoadBalancerProfileOutboundIPPrefixes",
        },
        "outbound_i_ps": {"key": "outboundIPs", "type": "ManagedClusterLoadBalancerProfileOutboundIPs"},
        "effective_outbound_i_ps": {"key": "effectiveOutboundIPs", "type": "[ResourceReference]"},
        "allocated_outbound_ports": {"key": "allocatedOutboundPorts", "type": "int"},
        "idle_timeout_in_minutes": {"key": "idleTimeoutInMinutes", "type": "int"},
    }

    def __init__(
        self,
        *,
        managed_outbound_i_ps: Optional["_models.ManagedClusterLoadBalancerProfileManagedOutboundIPs"] = None,
        outbound_ip_prefixes: Optional["_models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes"] = None,
        outbound_i_ps: Optional["_models.ManagedClusterLoadBalancerProfileOutboundIPs"] = None,
        effective_outbound_i_ps: Optional[List["_models.ResourceReference"]] = None,
        allocated_outbound_ports: int = 0,
        idle_timeout_in_minutes: int = 30,
        **kwargs: Any
    ) -> None:
        """
        :keyword managed_outbound_i_ps: Desired managed outbound IPs for the cluster load balancer.
        :paramtype managed_outbound_i_ps:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfileManagedOutboundIPs
        :keyword outbound_ip_prefixes: Desired outbound IP Prefix resources for the cluster load
         balancer.
        :paramtype outbound_ip_prefixes:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfileOutboundIPPrefixes
        :keyword outbound_i_ps: Desired outbound IP resources for the cluster load balancer.
        :paramtype outbound_i_ps:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterLoadBalancerProfileOutboundIPs
        :keyword effective_outbound_i_ps: The effective outbound IP resources of the cluster load
         balancer.
        :paramtype effective_outbound_i_ps:
         list[~azure.mgmt.containerservice.v2020_04_01.models.ResourceReference]
        :keyword allocated_outbound_ports: Desired number of allocated SNAT ports per VM. Allowed
         values must be in the range of 0 to 64000 (inclusive). The default value is 0 which results in
         Azure dynamically allocating ports.
        :paramtype allocated_outbound_ports: int
        :keyword idle_timeout_in_minutes: Desired outbound flow idle timeout in minutes. Allowed values
         must be in the range of 4 to 120 (inclusive). The default value is 30 minutes.
        :paramtype idle_timeout_in_minutes: int
        """
        super().__init__(**kwargs)
        self.managed_outbound_i_ps = managed_outbound_i_ps
        self.outbound_ip_prefixes = outbound_ip_prefixes
        self.outbound_i_ps = outbound_i_ps
        self.effective_outbound_i_ps = effective_outbound_i_ps
        self.allocated_outbound_ports = allocated_outbound_ports
        self.idle_timeout_in_minutes = idle_timeout_in_minutes


class ManagedClusterLoadBalancerProfileManagedOutboundIPs(_serialization.Model):  # pylint: disable=name-too-long
    """Desired managed outbound IPs for the cluster load balancer.

    :ivar count: Desired number of outbound IP created/managed by Azure for the cluster load
     balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
    :vartype count: int
    """

    _validation = {
        "count": {"maximum": 100, "minimum": 1},
    }

    _attribute_map = {
        "count": {"key": "count", "type": "int"},
    }

    def __init__(self, *, count: int = 1, **kwargs: Any) -> None:
        """
        :keyword count: Desired number of outbound IP created/managed by Azure for the cluster load
         balancer. Allowed values must be in the range of 1 to 100 (inclusive). The default value is 1.
        :paramtype count: int
        """
        super().__init__(**kwargs)
        self.count = count


class ManagedClusterLoadBalancerProfileOutboundIPPrefixes(_serialization.Model):  # pylint: disable=name-too-long
    """Desired outbound IP Prefix resources for the cluster load balancer.

    :ivar public_ip_prefixes: A list of public IP prefix resources.
    :vartype public_ip_prefixes:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ResourceReference]
    """

    _attribute_map = {
        "public_ip_prefixes": {"key": "publicIPPrefixes", "type": "[ResourceReference]"},
    }

    def __init__(
        self, *, public_ip_prefixes: Optional[List["_models.ResourceReference"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword public_ip_prefixes: A list of public IP prefix resources.
        :paramtype public_ip_prefixes:
         list[~azure.mgmt.containerservice.v2020_04_01.models.ResourceReference]
        """
        super().__init__(**kwargs)
        self.public_ip_prefixes = public_ip_prefixes


class ManagedClusterLoadBalancerProfileOutboundIPs(_serialization.Model):  # pylint: disable=name-too-long
    """Desired outbound IP resources for the cluster load balancer.

    :ivar public_i_ps: A list of public IP resources.
    :vartype public_i_ps: list[~azure.mgmt.containerservice.v2020_04_01.models.ResourceReference]
    """

    _attribute_map = {
        "public_i_ps": {"key": "publicIPs", "type": "[ResourceReference]"},
    }

    def __init__(self, *, public_i_ps: Optional[List["_models.ResourceReference"]] = None, **kwargs: Any) -> None:
        """
        :keyword public_i_ps: A list of public IP resources.
        :paramtype public_i_ps: list[~azure.mgmt.containerservice.v2020_04_01.models.ResourceReference]
        """
        super().__init__(**kwargs)
        self.public_i_ps = public_i_ps


class ManagedClusterPoolUpgradeProfile(_serialization.Model):
    """The list of available upgrade versions.

    All required parameters must be populated in order to send to server.

    :ivar kubernetes_version: Kubernetes version (major, minor, patch). Required.
    :vartype kubernetes_version: str
    :ivar name: Pool name.
    :vartype name: str
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Known values are: "Linux" and "Windows".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
    :ivar upgrades: List of orchestrator types and versions available for upgrade.
    :vartype upgrades:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
    """

    _validation = {
        "kubernetes_version": {"required": True},
        "os_type": {"required": True},
    }

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "os_type": {"key": "osType", "type": "str"},
        "upgrades": {"key": "upgrades", "type": "[ManagedClusterPoolUpgradeProfileUpgradesItem]"},
    }

    def __init__(
        self,
        *,
        kubernetes_version: str,
        os_type: Union[str, "_models.OSType"] = "Linux",
        name: Optional[str] = None,
        upgrades: Optional[List["_models.ManagedClusterPoolUpgradeProfileUpgradesItem"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: Kubernetes version (major, minor, patch). Required.
        :paramtype kubernetes_version: str
        :keyword name: Pool name.
        :paramtype name: str
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Known values are: "Linux" and "Windows".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2020_04_01.models.OSType
        :keyword upgrades: List of orchestrator types and versions available for upgrade.
        :paramtype upgrades:
         list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPoolUpgradeProfileUpgradesItem]
        """
        super().__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.name = name
        self.os_type = os_type
        self.upgrades = upgrades


class ManagedClusterPoolUpgradeProfileUpgradesItem(_serialization.Model):  # pylint: disable=name-too-long
    """ManagedClusterPoolUpgradeProfileUpgradesItem.

    :ivar kubernetes_version: Kubernetes version (major, minor, patch).
    :vartype kubernetes_version: str
    :ivar is_preview: Whether Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _attribute_map = {
        "kubernetes_version": {"key": "kubernetesVersion", "type": "str"},
        "is_preview": {"key": "isPreview", "type": "bool"},
    }

    def __init__(
        self, *, kubernetes_version: Optional[str] = None, is_preview: Optional[bool] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kubernetes_version: Kubernetes version (major, minor, patch).
        :paramtype kubernetes_version: str
        :keyword is_preview: Whether Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super().__init__(**kwargs)
        self.kubernetes_version = kubernetes_version
        self.is_preview = is_preview


class ManagedClusterPropertiesAutoScalerProfile(_serialization.Model):  # pylint: disable=name-too-long
    """Parameters to be applied to the cluster-autoscaler when enabled.

    :ivar balance_similar_node_groups:
    :vartype balance_similar_node_groups: str
    :ivar scan_interval:
    :vartype scan_interval: str
    :ivar scale_down_delay_after_add:
    :vartype scale_down_delay_after_add: str
    :ivar scale_down_delay_after_delete:
    :vartype scale_down_delay_after_delete: str
    :ivar scale_down_delay_after_failure:
    :vartype scale_down_delay_after_failure: str
    :ivar scale_down_unneeded_time:
    :vartype scale_down_unneeded_time: str
    :ivar scale_down_unready_time:
    :vartype scale_down_unready_time: str
    :ivar scale_down_utilization_threshold:
    :vartype scale_down_utilization_threshold: str
    :ivar max_graceful_termination_sec:
    :vartype max_graceful_termination_sec: str
    """

    _attribute_map = {
        "balance_similar_node_groups": {"key": "balance-similar-node-groups", "type": "str"},
        "scan_interval": {"key": "scan-interval", "type": "str"},
        "scale_down_delay_after_add": {"key": "scale-down-delay-after-add", "type": "str"},
        "scale_down_delay_after_delete": {"key": "scale-down-delay-after-delete", "type": "str"},
        "scale_down_delay_after_failure": {"key": "scale-down-delay-after-failure", "type": "str"},
        "scale_down_unneeded_time": {"key": "scale-down-unneeded-time", "type": "str"},
        "scale_down_unready_time": {"key": "scale-down-unready-time", "type": "str"},
        "scale_down_utilization_threshold": {"key": "scale-down-utilization-threshold", "type": "str"},
        "max_graceful_termination_sec": {"key": "max-graceful-termination-sec", "type": "str"},
    }

    def __init__(
        self,
        *,
        balance_similar_node_groups: Optional[str] = None,
        scan_interval: Optional[str] = None,
        scale_down_delay_after_add: Optional[str] = None,
        scale_down_delay_after_delete: Optional[str] = None,
        scale_down_delay_after_failure: Optional[str] = None,
        scale_down_unneeded_time: Optional[str] = None,
        scale_down_unready_time: Optional[str] = None,
        scale_down_utilization_threshold: Optional[str] = None,
        max_graceful_termination_sec: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword balance_similar_node_groups:
        :paramtype balance_similar_node_groups: str
        :keyword scan_interval:
        :paramtype scan_interval: str
        :keyword scale_down_delay_after_add:
        :paramtype scale_down_delay_after_add: str
        :keyword scale_down_delay_after_delete:
        :paramtype scale_down_delay_after_delete: str
        :keyword scale_down_delay_after_failure:
        :paramtype scale_down_delay_after_failure: str
        :keyword scale_down_unneeded_time:
        :paramtype scale_down_unneeded_time: str
        :keyword scale_down_unready_time:
        :paramtype scale_down_unready_time: str
        :keyword scale_down_utilization_threshold:
        :paramtype scale_down_utilization_threshold: str
        :keyword max_graceful_termination_sec:
        :paramtype max_graceful_termination_sec: str
        """
        super().__init__(**kwargs)
        self.balance_similar_node_groups = balance_similar_node_groups
        self.scan_interval = scan_interval
        self.scale_down_delay_after_add = scale_down_delay_after_add
        self.scale_down_delay_after_delete = scale_down_delay_after_delete
        self.scale_down_delay_after_failure = scale_down_delay_after_failure
        self.scale_down_unneeded_time = scale_down_unneeded_time
        self.scale_down_unready_time = scale_down_unready_time
        self.scale_down_utilization_threshold = scale_down_utilization_threshold
        self.max_graceful_termination_sec = max_graceful_termination_sec


class ManagedClusterPropertiesIdentityProfileValue(UserAssignedIdentity):  # pylint: disable=name-too-long
    """ManagedClusterPropertiesIdentityProfileValue.

    :ivar resource_id: The resource id of the user assigned identity.
    :vartype resource_id: str
    :ivar client_id: The client id of the user assigned identity.
    :vartype client_id: str
    :ivar object_id: The object id of the user assigned identity.
    :vartype object_id: str
    """


class ManagedClusterServicePrincipalProfile(_serialization.Model):
    """Information about a service principal identity for the cluster to use for manipulating Azure
    APIs.

    All required parameters must be populated in order to send to server.

    :ivar client_id: The ID for the service principal. Required.
    :vartype client_id: str
    :ivar secret: The secret password associated with the service principal in plain text.
    :vartype secret: str
    """

    _validation = {
        "client_id": {"required": True},
    }

    _attribute_map = {
        "client_id": {"key": "clientId", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, client_id: str, secret: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword client_id: The ID for the service principal. Required.
        :paramtype client_id: str
        :keyword secret: The secret password associated with the service principal in plain text.
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.client_id = client_id
        self.secret = secret


class ManagedClusterSKU(_serialization.Model):
    """ManagedClusterSKU.

    :ivar name: Name of a managed cluster SKU. "Basic"
    :vartype name: str or ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterSKUName
    :ivar tier: Tier of a managed cluster SKU. Known values are: "Paid" and "Free".
    :vartype tier: str or ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterSKUTier
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.ManagedClusterSKUName"]] = None,
        tier: Optional[Union[str, "_models.ManagedClusterSKUTier"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of a managed cluster SKU. "Basic"
        :paramtype name: str or ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterSKUName
        :keyword tier: Tier of a managed cluster SKU. Known values are: "Paid" and "Free".
        :paramtype tier: str or ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterSKUTier
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier


class ManagedClusterUpgradeProfile(_serialization.Model):
    """The list of available upgrades for compute pools.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar id: Id of upgrade profile.
    :vartype id: str
    :ivar name: Name of upgrade profile.
    :vartype name: str
    :ivar type: Type of upgrade profile.
    :vartype type: str
    :ivar control_plane_profile: The list of available upgrade versions for the control plane.
     Required.
    :vartype control_plane_profile:
     ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPoolUpgradeProfile
    :ivar agent_pool_profiles: The list of available upgrade versions for agent pools. Required.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPoolUpgradeProfile]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "control_plane_profile": {"required": True},
        "agent_pool_profiles": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "control_plane_profile": {"key": "properties.controlPlaneProfile", "type": "ManagedClusterPoolUpgradeProfile"},
        "agent_pool_profiles": {"key": "properties.agentPoolProfiles", "type": "[ManagedClusterPoolUpgradeProfile]"},
    }

    def __init__(
        self,
        *,
        control_plane_profile: "_models.ManagedClusterPoolUpgradeProfile",
        agent_pool_profiles: List["_models.ManagedClusterPoolUpgradeProfile"],
        **kwargs: Any
    ) -> None:
        """
        :keyword control_plane_profile: The list of available upgrade versions for the control plane.
         Required.
        :paramtype control_plane_profile:
         ~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPoolUpgradeProfile
        :keyword agent_pool_profiles: The list of available upgrade versions for agent pools. Required.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.containerservice.v2020_04_01.models.ManagedClusterPoolUpgradeProfile]
        """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.control_plane_profile = control_plane_profile
        self.agent_pool_profiles = agent_pool_profiles


class ManagedClusterWindowsProfile(_serialization.Model):
    """Profile for Windows VMs in the container service cluster.

    All required parameters must be populated in order to send to server.

    :ivar admin_username: Specifies the name of the administrator account. :code:`<br>`:code:`<br>`
     **restriction:** Cannot end in "." :code:`<br>`:code:`<br>` **Disallowed values:**
     "administrator", "admin", "user", "user1", "test", "user2", "test1", "user3", "admin1", "1",
     "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console", "david", "guest",
     "john", "owner", "root", "server", "sql", "support", "support_388945a0", "sys", "test2",
     "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length:** 1 character
     :code:`<br>`:code:`<br>` **Max-length:** 20 characters. Required.
    :vartype admin_username: str
    :ivar admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length:** 8 characters :code:`<br>`:code:`<br>`
     **Max-length:** 123 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
     conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
     characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\\W_])
     :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
     "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
    :vartype admin_password: str
    """

    _validation = {
        "admin_username": {"required": True},
    }

    _attribute_map = {
        "admin_username": {"key": "adminUsername", "type": "str"},
        "admin_password": {"key": "adminPassword", "type": "str"},
    }

    def __init__(self, *, admin_username: str, admin_password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword admin_username: Specifies the name of the administrator account.
         :code:`<br>`:code:`<br>` **restriction:** Cannot end in "." :code:`<br>`:code:`<br>`
         **Disallowed values:** "administrator", "admin", "user", "user1", "test", "user2", "test1",
         "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2", "aspnet", "backup", "console",
         "david", "guest", "john", "owner", "root", "server", "sql", "support", "support_388945a0",
         "sys", "test2", "test3", "user4", "user5". :code:`<br>`:code:`<br>` **Minimum-length:** 1
         character :code:`<br>`:code:`<br>` **Max-length:** 20 characters. Required.
        :paramtype admin_username: str
        :keyword admin_password: Specifies the password of the administrator account.
         :code:`<br>`:code:`<br>` **Minimum-length:** 8 characters :code:`<br>`:code:`<br>`
         **Max-length:** 123 characters :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4
         conditions below need to be fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper
         characters :code:`<br>` Has a digit :code:`<br>` Has a special character (Regex match [\\W_])
         :code:`<br>`:code:`<br>` **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd",
         "P@ssword123", "Pa$$word", "pass@word1", "Password!", "Password1", "Password22", "iloveyou!".
        :paramtype admin_password: str
        """
        super().__init__(**kwargs)
        self.admin_username = admin_username
        self.admin_password = admin_password


class OperationListResult(_serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.containerservice.v2020_04_01.models.OperationValue]
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[OperationValue]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None


class OperationValue(_serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        "origin": {"readonly": True},
        "name": {"readonly": True},
        "operation": {"readonly": True},
        "resource": {"readonly": True},
        "description": {"readonly": True},
        "provider": {"readonly": True},
    }

    _attribute_map = {
        "origin": {"key": "origin", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "operation": {"key": "display.operation", "type": "str"},
        "resource": {"key": "display.resource", "type": "str"},
        "description": {"key": "display.description", "type": "str"},
        "provider": {"key": "display.provider", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class ResourceReference(_serialization.Model):
    """A reference to an Azure resource.

    :ivar id: The fully qualified Azure resource id.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: The fully qualified Azure resource id.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags
