; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=arm64-apple-ios | FileCheck %s
;
; <rdar://problem/13820218>

define signext i16 @extendedLeftShiftcharToshortBy4(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftcharToshortBy4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz w0, w8, #4, #8
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv1 = sext i8 %inc to i32
  %shl = shl nsw i32 %conv1, 4
  %conv2 = trunc i32 %shl to i16
  ret i16 %conv2
}

define signext i16 @extendedRightShiftcharToshortBy4(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftcharToshortBy4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfx w0, w8, #4, #4
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv1 = sext i8 %inc to i32
  %shr4 = lshr i32 %conv1, 4
  %conv2 = trunc i32 %shr4 to i16
  ret i16 %conv2
}

define signext i16 @extendedLeftShiftcharToshortBy8(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftcharToshortBy8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz w0, w8, #8, #8
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv1 = sext i8 %inc to i32
  %shl = shl nsw i32 %conv1, 8
  %conv2 = trunc i32 %shl to i16
  ret i16 %conv2
}

define signext i16 @extendedRightShiftcharToshortBy8(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftcharToshortBy8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sxtb w8, w8
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv1 = sext i8 %inc to i32
  %shr4 = lshr i32 %conv1, 8
  %conv2 = trunc i32 %shr4 to i16
  ret i16 %conv2
}

define i32 @extendedLeftShiftcharTointBy4(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftcharTointBy4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz w0, w8, #4, #8
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv = sext i8 %inc to i32
  %shl = shl nsw i32 %conv, 4
  ret i32 %shl
}

define i32 @extendedRightShiftcharTointBy4(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftcharTointBy4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfx w0, w8, #4, #4
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv = sext i8 %inc to i32
  %shr = ashr i32 %conv, 4
  ret i32 %shr
}

define i32 @extendedLeftShiftcharTointBy8(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftcharTointBy8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz w0, w8, #8, #8
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv = sext i8 %inc to i32
  %shl = shl nsw i32 %conv, 8
  ret i32 %shl
}

define i32 @extendedRightShiftcharTointBy8(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftcharTointBy8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sxtb w8, w8
; CHECK-NEXT:    asr w0, w8, #8
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv = sext i8 %inc to i32
  %shr = ashr i32 %conv, 8
  ret i32 %shr
}

define i64 @extendedLeftShiftcharToint64By4(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftcharToint64By4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz x0, x8, #4, #8
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv = sext i8 %inc to i64
  %shl = shl nsw i64 %conv, 4
  ret i64 %shl
}

define i64 @extendedRightShiftcharToint64By4(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftcharToint64By4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfx x0, x8, #4, #4
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv = sext i8 %inc to i64
  %shr = ashr i64 %conv, 4
  ret i64 %shr
}

define i64 @extendedLeftShiftcharToint64By8(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftcharToint64By8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz x0, x8, #8, #8
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv = sext i8 %inc to i64
  %shl = shl nsw i64 %conv, 8
  ret i64 %shl
}

define i64 @extendedRightShiftcharToint64By8(i8 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftcharToint64By8:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sxtb x8, w8
; CHECK-NEXT:    asr x0, x8, #8
; CHECK-NEXT:    ret
entry:
  %inc = add i8 %a, 1
  %conv = sext i8 %inc to i64
  %shr = ashr i64 %conv, 8
  ret i64 %shr
}

define i32 @extendedLeftShiftshortTointBy4(i16 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftshortTointBy4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz w0, w8, #4, #16
; CHECK-NEXT:    ret
entry:
  %inc = add i16 %a, 1
  %conv = sext i16 %inc to i32
  %shl = shl nsw i32 %conv, 4
  ret i32 %shl
}

define i32 @extendedRightShiftshortTointBy4(i16 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftshortTointBy4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfx w0, w8, #4, #12
; CHECK-NEXT:    ret
entry:
  %inc = add i16 %a, 1
  %conv = sext i16 %inc to i32
  %shr = ashr i32 %conv, 4
  ret i32 %shr
}

define i32 @extendedLeftShiftshortTointBy16(i16 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftshortTointBy16:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    lsl w8, w0, #16
; CHECK-NEXT:    add w0, w8, #16, lsl #12 ; =65536
; CHECK-NEXT:    ret
entry:
  %inc = add i16 %a, 1
  %conv2 = zext i16 %inc to i32
  %shl = shl nuw i32 %conv2, 16
  ret i32 %shl
}

define i32 @extendedRightShiftshortTointBy16(i16 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftshortTointBy16:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sxth w8, w8
; CHECK-NEXT:    asr w0, w8, #16
; CHECK-NEXT:    ret
entry:
  %inc = add i16 %a, 1
  %conv = sext i16 %inc to i32
  %shr = ashr i32 %conv, 16
  ret i32 %shr
}

define i64 @extendedLeftShiftshortToint64By4(i16 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftshortToint64By4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz x0, x8, #4, #16
; CHECK-NEXT:    ret
entry:
  %inc = add i16 %a, 1
  %conv = sext i16 %inc to i64
  %shl = shl nsw i64 %conv, 4
  ret i64 %shl
}

define i64 @extendedRightShiftshortToint64By4(i16 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftshortToint64By4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfx x0, x8, #4, #12
; CHECK-NEXT:    ret
entry:
  %inc = add i16 %a, 1
  %conv = sext i16 %inc to i64
  %shr = ashr i64 %conv, 4
  ret i64 %shr
}

define i64 @extendedLeftShiftshortToint64By16(i16 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftshortToint64By16:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz x0, x8, #16, #16
; CHECK-NEXT:    ret
entry:
  %inc = add i16 %a, 1
  %conv = sext i16 %inc to i64
  %shl = shl nsw i64 %conv, 16
  ret i64 %shl
}

define i64 @extendedRightShiftshortToint64By16(i16 signext %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftshortToint64By16:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sxth x8, w8
; CHECK-NEXT:    asr x0, x8, #16
; CHECK-NEXT:    ret
entry:
  %inc = add i16 %a, 1
  %conv = sext i16 %inc to i64
  %shr = ashr i64 %conv, 16
  ret i64 %shr
}

define i64 @extendedLeftShiftintToint64By4(i32 %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftintToint64By4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfiz x0, x8, #4, #32
; CHECK-NEXT:    ret
entry:
  %inc = add nsw i32 %a, 1
  %conv = sext i32 %inc to i64
  %shl = shl nsw i64 %conv, 4
  ret i64 %shl
}

define i64 @extendedRightShiftintToint64By4(i32 %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftintToint64By4:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sbfx x0, x8, #4, #28
; CHECK-NEXT:    ret
entry:
  %inc = add nsw i32 %a, 1
  %conv = sext i32 %inc to i64
  %shr = ashr i64 %conv, 4
  ret i64 %shr
}

define i64 @extendedLeftShiftintToint64By32(i32 %a) nounwind readnone ssp {
; CHECK-LABEL: extendedLeftShiftintToint64By32:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    lsl x0, x8, #32
; CHECK-NEXT:    ret
entry:
  %inc = add nsw i32 %a, 1
  %conv2 = zext i32 %inc to i64
  %shl = shl nuw i64 %conv2, 32
  ret i64 %shl
}

define i64 @extendedRightShiftintToint64By32(i32 %a) nounwind readnone ssp {
; CHECK-LABEL: extendedRightShiftintToint64By32:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add w8, w0, #1
; CHECK-NEXT:    sxtw x8, w8
; CHECK-NEXT:    asr x0, x8, #32
; CHECK-NEXT:    ret
entry:
  %inc = add nsw i32 %a, 1
  %conv = sext i32 %inc to i64
  %shr = ashr i64 %conv, 32
  ret i64 %shr
}

define i64 @sign_extend_inreg_isdef32(i64) {
; CHECK-LABEL: sign_extend_inreg_isdef32:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    sbfx x8, x0, #32, #16
; CHECK-NEXT:    mov w0, w8
; CHECK-NEXT:    ret
  %2 = lshr i64 %0, 32
  %3 = shl i64 %2, 16
  %4 = trunc i64 %3 to i32
  %5 = ashr exact i32 %4, 16
  %6 = zext i32 %5 to i64
  ret i64 %6
}
