# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import functools
from json import loads as _loads
from typing import Any, AsyncIterable, Callable, Dict, Generic, Optional, TypeVar
import warnings

from azure.core.async_paging import AsyncItemPaged, AsyncList
from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import AsyncHttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.tracing.decorator_async import distributed_trace_async

from ...operations._resource_set_rules_operations import build_create_or_update_resource_set_rule_request, build_delete_resource_set_rule_request, build_get_resource_set_rule_request, build_list_resource_set_rules_request

T = TypeVar('T')
ClsType = Optional[Callable[[PipelineResponse[HttpRequest, AsyncHttpResponse], T, Dict[str, Any]], Any]]

class ResourceSetRulesOperations:
    """ResourceSetRulesOperations async operations.

    You should not instantiate this class directly. Instead, you should create a Client instance that
    instantiates it for you and attaches it as an attribute.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    """

    def __init__(self, client, config, serializer, deserializer) -> None:
        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer
        self._config = config

    @distributed_trace_async
    async def get_resource_set_rule(
        self,
        **kwargs: Any
    ) -> Any:
        """Get a resource set config service model.

        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "advancedResourceSet": {
                        "modifiedAt": "datetime (optional)",
                        "resourceSetProcessing": "str (optional)"
                    },
                    "name": "str (optional)",
                    "pathPatternConfig": {
                        "acceptedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "complexReplacers": [
                            {
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool (optional)",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional)",
                                "name": "str (optional)",
                                "typeName": "str (optional)"
                            }
                        ],
                        "createdBy": "str",
                        "enableDefaultPatterns": "bool",
                        "lastUpdatedTimestamp": "long (optional)",
                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                        "normalizationRules": [
                            {
                                "description": "str (optional)",
                                "disabled": "bool (optional)",
                                "dynamicReplacement": "bool (optional)",
                                "entityTypes": [
                                    "str (optional)"
                                ],
                                "lastUpdatedTimestamp": "long (optional)",
                                "name": "str (optional)",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)",
                                "version": "float (optional)"
                            }
                        ],
                        "regexReplacers": [
                            {
                                "condition": "str (optional)",
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool",
                                "doNotReplaceRegex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)"
                            }
                        ],
                        "rejectedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "scopedRules": [
                            {
                                "bindingUrl": "str",
                                "rules": [
                                    {
                                        "displayName": "str (optional)",
                                        "isResourceSet": "bool (optional). Default value is True",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "name": "str (optional)",
                                        "qualifiedName": "str"
                                    }
                                ],
                                "storeType": "str"
                            }
                        ],
                        "version": "int (optional). Default value is 0"
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_get_resource_set_rule_request(
            template_url=self.get_resource_set_rule.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    get_resource_set_rule.metadata = {'url': '/resourceSetRuleConfigs/defaultResourceSetRuleConfig'}  # type: ignore


    @distributed_trace_async
    async def create_or_update_resource_set_rule(
        self,
        resource_set_rule_config: Any,
        **kwargs: Any
    ) -> Any:
        """Creates or updates an resource set config.

        :param resource_set_rule_config:
        :type resource_set_rule_config: Any
        :return: JSON object
        :rtype: Any
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                resource_set_rule_config = {
                    "advancedResourceSet": {
                        "modifiedAt": "datetime (optional)",
                        "resourceSetProcessing": "str (optional)"
                    },
                    "name": "str (optional)",
                    "pathPatternConfig": {
                        "acceptedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "complexReplacers": [
                            {
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool (optional)",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional)",
                                "name": "str (optional)",
                                "typeName": "str (optional)"
                            }
                        ],
                        "createdBy": "str",
                        "enableDefaultPatterns": "bool",
                        "lastUpdatedTimestamp": "long (optional)",
                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                        "normalizationRules": [
                            {
                                "description": "str (optional)",
                                "disabled": "bool (optional)",
                                "dynamicReplacement": "bool (optional)",
                                "entityTypes": [
                                    "str (optional)"
                                ],
                                "lastUpdatedTimestamp": "long (optional)",
                                "name": "str (optional)",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)",
                                "version": "float (optional)"
                            }
                        ],
                        "regexReplacers": [
                            {
                                "condition": "str (optional)",
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool",
                                "doNotReplaceRegex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)"
                            }
                        ],
                        "rejectedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "scopedRules": [
                            {
                                "bindingUrl": "str",
                                "rules": [
                                    {
                                        "displayName": "str (optional)",
                                        "isResourceSet": "bool (optional). Default value is True",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "name": "str (optional)",
                                        "qualifiedName": "str"
                                    }
                                ],
                                "storeType": "str"
                            }
                        ],
                        "version": "int (optional). Default value is 0"
                    }
                }

                # response body for status code(s): 200
                response.json() == {
                    "advancedResourceSet": {
                        "modifiedAt": "datetime (optional)",
                        "resourceSetProcessing": "str (optional)"
                    },
                    "name": "str (optional)",
                    "pathPatternConfig": {
                        "acceptedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "complexReplacers": [
                            {
                                "createdBy": "str (optional)",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool (optional)",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional)",
                                "name": "str (optional)",
                                "typeName": "str (optional)"
                            }
                        ],
                        "createdBy": "str",
                        "enableDefaultPatterns": "bool",
                        "lastUpdatedTimestamp": "long (optional)",
                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                        "normalizationRules": [
                            {
                                "description": "str (optional)",
                                "disabled": "bool (optional)",
                                "dynamicReplacement": "bool (optional)",
                                "entityTypes": [
                                    "str (optional)"
                                ],
                                "lastUpdatedTimestamp": "long (optional)",
                                "name": "str (optional)",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)",
                                "version": "float (optional)"
                            }
                        ],
                        "regexReplacers": [
                            {
                                "condition": "str (optional)",
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "description": "str (optional)",
                                "disableRecursiveReplacerApplication": "bool (optional)",
                                "disabled": "bool",
                                "doNotReplaceRegex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "regex": {
                                    "maxDigits": "int (optional)",
                                    "maxLetters": "int (optional)",
                                    "minDashes": "int (optional)",
                                    "minDigits": "int (optional)",
                                    "minDigitsOrLetters": "int (optional)",
                                    "minDots": "int (optional)",
                                    "minHex": "int (optional)",
                                    "minLetters": "int (optional)",
                                    "minUnderscores": "int (optional)",
                                    "options": "int (optional)",
                                    "regexStr": "str (optional)"
                                },
                                "replaceWith": "str (optional)"
                            }
                        ],
                        "rejectedPatterns": [
                            {
                                "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "filterType": "str (optional). Default value is \"Pattern\"",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "name": "str",
                                "path": "str"
                            }
                        ],
                        "scopedRules": [
                            {
                                "bindingUrl": "str",
                                "rules": [
                                    {
                                        "displayName": "str (optional)",
                                        "isResourceSet": "bool (optional). Default value is True",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "name": "str (optional)",
                                        "qualifiedName": "str"
                                    }
                                ],
                                "storeType": "str"
                            }
                        ],
                        "version": "int (optional). Default value is 0"
                    }
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        json = resource_set_rule_config

        request = build_create_or_update_resource_set_rule_request(
            content_type=content_type,
            json=json,
            template_url=self.create_or_update_resource_set_rule.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if response.content:
            deserialized = response.json()
        else:
            deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    create_or_update_resource_set_rule.metadata = {'url': '/resourceSetRuleConfigs/defaultResourceSetRuleConfig'}  # type: ignore


    @distributed_trace_async
    async def delete_resource_set_rule(
        self,
        **kwargs: Any
    ) -> None:
        """Deletes a ResourceSetRuleConfig resource.

        :return: None
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        
        request = build_delete_resource_set_rule_request(
            template_url=self.delete_resource_set_rule.metadata['url'],
        )
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = await self._client.send_request(request, stream=False, _return_pipeline_response=True, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200, 204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            raise HttpResponseError(response=response)

        if cls:
            return cls(pipeline_response, None, {})

    delete_resource_set_rule.metadata = {'url': '/resourceSetRuleConfigs/defaultResourceSetRuleConfig'}  # type: ignore


    @distributed_trace
    def list_resource_set_rules(
        self,
        *,
        skip_token: Optional[str] = None,
        **kwargs: Any
    ) -> AsyncIterable[Any]:
        """Get a resource set config service model.

        :keyword skip_token:
        :paramtype skip_token: str
        :return: An iterator like instance of JSON object
        :rtype: ~azure.core.async_paging.AsyncItemPaged[Any]
        :raises: ~azure.core.exceptions.HttpResponseError

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response.json() == {
                    "count": "long (optional)",
                    "nextLink": "str (optional)",
                    "value": [
                        {
                            "advancedResourceSet": {
                                "modifiedAt": "datetime (optional)",
                                "resourceSetProcessing": "str (optional)"
                            },
                            "name": "str (optional)",
                            "pathPatternConfig": {
                                "acceptedPatterns": [
                                    {
                                        "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "filterType": "str (optional). Default value is \"Pattern\"",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "name": "str",
                                        "path": "str"
                                    }
                                ],
                                "complexReplacers": [
                                    {
                                        "createdBy": "str (optional)",
                                        "description": "str (optional)",
                                        "disableRecursiveReplacerApplication": "bool (optional)",
                                        "disabled": "bool (optional)",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "modifiedBy": "str (optional)",
                                        "name": "str (optional)",
                                        "typeName": "str (optional)"
                                    }
                                ],
                                "createdBy": "str",
                                "enableDefaultPatterns": "bool",
                                "lastUpdatedTimestamp": "long (optional)",
                                "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                "normalizationRules": [
                                    {
                                        "description": "str (optional)",
                                        "disabled": "bool (optional)",
                                        "dynamicReplacement": "bool (optional)",
                                        "entityTypes": [
                                            "str (optional)"
                                        ],
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "name": "str (optional)",
                                        "regex": {
                                            "maxDigits": "int (optional)",
                                            "maxLetters": "int (optional)",
                                            "minDashes": "int (optional)",
                                            "minDigits": "int (optional)",
                                            "minDigitsOrLetters": "int (optional)",
                                            "minDots": "int (optional)",
                                            "minHex": "int (optional)",
                                            "minLetters": "int (optional)",
                                            "minUnderscores": "int (optional)",
                                            "options": "int (optional)",
                                            "regexStr": "str (optional)"
                                        },
                                        "replaceWith": "str (optional)",
                                        "version": "float (optional)"
                                    }
                                ],
                                "regexReplacers": [
                                    {
                                        "condition": "str (optional)",
                                        "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "description": "str (optional)",
                                        "disableRecursiveReplacerApplication": "bool (optional)",
                                        "disabled": "bool",
                                        "doNotReplaceRegex": {
                                            "maxDigits": "int (optional)",
                                            "maxLetters": "int (optional)",
                                            "minDashes": "int (optional)",
                                            "minDigits": "int (optional)",
                                            "minDigitsOrLetters": "int (optional)",
                                            "minDots": "int (optional)",
                                            "minHex": "int (optional)",
                                            "minLetters": "int (optional)",
                                            "minUnderscores": "int (optional)",
                                            "options": "int (optional)",
                                            "regexStr": "str (optional)"
                                        },
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "name": "str",
                                        "regex": {
                                            "maxDigits": "int (optional)",
                                            "maxLetters": "int (optional)",
                                            "minDashes": "int (optional)",
                                            "minDigits": "int (optional)",
                                            "minDigitsOrLetters": "int (optional)",
                                            "minDots": "int (optional)",
                                            "minHex": "int (optional)",
                                            "minLetters": "int (optional)",
                                            "minUnderscores": "int (optional)",
                                            "options": "int (optional)",
                                            "regexStr": "str (optional)"
                                        },
                                        "replaceWith": "str (optional)"
                                    }
                                ],
                                "rejectedPatterns": [
                                    {
                                        "createdBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "filterType": "str (optional). Default value is \"Pattern\"",
                                        "lastUpdatedTimestamp": "long (optional)",
                                        "modifiedBy": "str (optional). Default value is \"AzureDataCatalog\"",
                                        "name": "str",
                                        "path": "str"
                                    }
                                ],
                                "scopedRules": [
                                    {
                                        "bindingUrl": "str",
                                        "rules": [
                                            {
                                                "displayName": "str (optional)",
                                                "isResourceSet": "bool (optional). Default value is True",
                                                "lastUpdatedTimestamp": "long (optional)",
                                                "name": "str (optional)",
                                                "qualifiedName": "str"
                                            }
                                        ],
                                        "storeType": "str"
                                    }
                                ],
                                "version": "int (optional). Default value is 0"
                            }
                        }
                    ]
                }
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[Any]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))
        def prepare_request(next_link=None):
            if not next_link:
                
                request = build_list_resource_set_rules_request(
                    skip_token=skip_token,
                    template_url=self.list_resource_set_rules.metadata['url'],
                )._to_pipeline_transport_request()
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

            else:
                
                request = build_list_resource_set_rules_request(
                    skip_token=skip_token,
                    template_url=next_link,
                )._to_pipeline_transport_request()
                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.url = self._client.format_url(request.url, **path_format_arguments)

                path_format_arguments = {
                    "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
                }
                request.method = "GET"
            return request

        async def extract_data(pipeline_response):
            deserialized = _loads(pipeline_response.http_response.body())
            list_of_elem = deserialized["value"]
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.get("nextLink", None), AsyncList(list_of_elem)

        async def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = await self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response)

            return pipeline_response


        return AsyncItemPaged(
            get_next, extract_data
        )
    list_resource_set_rules.metadata = {'url': '/resourceSetRuleConfigs'}  # type: ignore
