/*
Copyright 2018 The CDI Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	"context"

	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
	v1beta1 "kubevirt.io/containerized-data-importer-api/pkg/apis/core/v1beta1"
)

// FakeVolumeCloneSources implements VolumeCloneSourceInterface
type FakeVolumeCloneSources struct {
	Fake *FakeCdiV1beta1
	ns   string
}

var volumeclonesourcesResource = schema.GroupVersionResource{Group: "cdi.kubevirt.io", Version: "v1beta1", Resource: "volumeclonesources"}

var volumeclonesourcesKind = schema.GroupVersionKind{Group: "cdi.kubevirt.io", Version: "v1beta1", Kind: "VolumeCloneSource"}

// Get takes name of the volumeCloneSource, and returns the corresponding volumeCloneSource object, and an error if there is any.
func (c *FakeVolumeCloneSources) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta1.VolumeCloneSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(volumeclonesourcesResource, c.ns, name), &v1beta1.VolumeCloneSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.VolumeCloneSource), err
}

// List takes label and field selectors, and returns the list of VolumeCloneSources that match those selectors.
func (c *FakeVolumeCloneSources) List(ctx context.Context, opts v1.ListOptions) (result *v1beta1.VolumeCloneSourceList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(volumeclonesourcesResource, volumeclonesourcesKind, c.ns, opts), &v1beta1.VolumeCloneSourceList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta1.VolumeCloneSourceList{ListMeta: obj.(*v1beta1.VolumeCloneSourceList).ListMeta}
	for _, item := range obj.(*v1beta1.VolumeCloneSourceList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested volumeCloneSources.
func (c *FakeVolumeCloneSources) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(volumeclonesourcesResource, c.ns, opts))

}

// Create takes the representation of a volumeCloneSource and creates it.  Returns the server's representation of the volumeCloneSource, and an error, if there is any.
func (c *FakeVolumeCloneSources) Create(ctx context.Context, volumeCloneSource *v1beta1.VolumeCloneSource, opts v1.CreateOptions) (result *v1beta1.VolumeCloneSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(volumeclonesourcesResource, c.ns, volumeCloneSource), &v1beta1.VolumeCloneSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.VolumeCloneSource), err
}

// Update takes the representation of a volumeCloneSource and updates it. Returns the server's representation of the volumeCloneSource, and an error, if there is any.
func (c *FakeVolumeCloneSources) Update(ctx context.Context, volumeCloneSource *v1beta1.VolumeCloneSource, opts v1.UpdateOptions) (result *v1beta1.VolumeCloneSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(volumeclonesourcesResource, c.ns, volumeCloneSource), &v1beta1.VolumeCloneSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.VolumeCloneSource), err
}

// Delete takes name of the volumeCloneSource and deletes it. Returns an error if one occurs.
func (c *FakeVolumeCloneSources) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteActionWithOptions(volumeclonesourcesResource, c.ns, name, opts), &v1beta1.VolumeCloneSource{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeVolumeCloneSources) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(volumeclonesourcesResource, c.ns, listOpts)

	_, err := c.Fake.Invokes(action, &v1beta1.VolumeCloneSourceList{})
	return err
}

// Patch applies the patch and returns the patched volumeCloneSource.
func (c *FakeVolumeCloneSources) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta1.VolumeCloneSource, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(volumeclonesourcesResource, c.ns, name, pt, data, subresources...), &v1beta1.VolumeCloneSource{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta1.VolumeCloneSource), err
}
