/*
 *  Braille Daemon - a simple braille-display server
 *  Author: Marco Skambraks <marco@skammel.de>
 *  SuSE Linux Products GmbH Nuernberg
 *
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation.  Please see the file COPYING for details.
*/

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <string.h>
#include <dlfcn.h>

#include "brld.h"
extern braille_driver *braille;

static void *library = NULL;    /* handle to driver */

#define BRL_SYMBOL "brl_driver"

void unload_braille_driver ()
{
  if (library)
    dlclose (library);
}

int load_braille_driver (char *libname)
{
  const char *error;

  if (libname == NULL)
    return 1;

  library = dlopen (libname, RTLD_LAZY);
  if (library == NULL)
   {
     fprintf (stderr, "%s\n", dlerror ());
     fprintf (stderr, "Cannot open braille driver library: %s\n", libname);
     return 2;
   }

  braille = (braille_driver *) dlsym (library, BRL_SYMBOL);     /* locate
                                                                   struct
                                                                   driver -
                                                                   filled
                                                                   with all
                                                                   the data */
  error = dlerror ();
  if (error)
   {
     unload_braille_driver ();
     fprintf (stderr, "%s\n", error);
     fprintf (stderr, "Braille driver symbol not found: %s\n", BRL_SYMBOL);
     return 3;
   }

  return 0;
}
