# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AclDeleteParameters(Model):
    """The parameters used to delete an access control list (ACL) entry.

    All required parameters must be populated in order to send to Azure.

    :param ace_type: Required. the access control list (ACL) entry type.
     UserObj and GroupObj denote the owning user and group, respectively.
     Possible values include: 'UserObj', 'GroupObj', 'Other', 'User', 'Group'
    :type ace_type: str or
     ~azure.mgmt.datalake.analytics.catalog.models.AclType
    :param principal_id: Required. the Azure AD object ID of the user or group
     being specified in the access control list (ACL) entry.
    :type principal_id: str
    """

    _validation = {
        'ace_type': {'required': True},
        'principal_id': {'required': True},
    }

    _attribute_map = {
        'ace_type': {'key': 'aceType', 'type': 'str'},
        'principal_id': {'key': 'principalId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AclDeleteParameters, self).__init__(**kwargs)
        self.ace_type = kwargs.get('ace_type', None)
        self.principal_id = kwargs.get('principal_id', None)
