/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.decoder.tiff.TiffNumberReader;
import com.sun.jimi.core.util.JimiUtil;

class Decompressor {
    public static final int boNormal = 1;
    public static final int boReversed = 2;
    private byte[] bitOrder;
    private TiffNumberReader reader;
    int bitspersample_;
    private static final byte[][] reverseBytes = new byte[2][256];
    protected boolean invertOut_ = false;

    static {
        int n = 0;
        while (n < 256) {
            Decompressor.reverseBytes[0][n] = (byte)n;
            Decompressor.reverseBytes[1][n] = (byte)((n & 1) << 7 | (n & 2) << 5 | (n & 4) << 3 | (n & 8) << 1 | (n & 0x10) >>> 1 | (n & 0x20) >>> 3 | (n & 0x40) >>> 5 | (n & 0x80) >>> 7);
            ++n;
        }
    }

    Decompressor(TiffNumberReader tiffNumberReader, int n) {
        this(tiffNumberReader, n, 1);
    }

    Decompressor(TiffNumberReader tiffNumberReader, int n, int n2) {
        this.bitOrder = reverseBytes[n - 1];
        this.reader = tiffNumberReader;
        this.bitspersample_ = n2;
    }

    public void begOfPage() {
    }

    public void begOfStrip() {
    }

    public void decodeLine(byte[] byArray, int n) throws JimiException {
        switch (this.bitspersample_) {
            case 1: {
                int n2 = n + 7 >> 3;
                byte[] byArray2 = byArray;
                if (this.invertOut_) {
                    int n3 = 0;
                    while (n3 < n2) {
                        byArray2[n3] = ~this.readByte();
                        ++n3;
                    }
                } else {
                    int n4 = 0;
                    while (n4 < n2) {
                        byArray2[n4] = this.readByte();
                        ++n4;
                    }
                }
                break;
            }
            case 4: {
                int n5 = n + 1 >> 1;
                byte[] byArray3 = new byte[n5];
                if (this.invertOut_) {
                    int n6 = 0;
                    while (n6 < n5) {
                        byArray3[n6] = ~this.readByte();
                        ++n6;
                    }
                } else {
                    int n7 = 0;
                    while (n7 < n5) {
                        byArray3[n7] = this.readByte();
                        ++n7;
                    }
                }
                JimiUtil.expandPixels(this.bitspersample_, byArray3, byArray, n);
                break;
            }
            case 8: {
                int n8 = n;
                byte[] byArray4 = byArray;
                if (this.invertOut_) {
                    int n9 = 0;
                    while (n9 < n8) {
                        byArray4[n9] = ~this.readByte();
                        ++n9;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < n8) {
                        byArray4[n10] = this.readByte();
                        ++n10;
                    }
                }
                break;
            }
        }
    }

    public byte readByte() {
        return this.bitOrder[this.reader.readByte() & 0xFF];
    }

    public void setInvert(boolean bl) {
        this.invertOut_ = bl;
    }

    public void setRowsPerStrip(int n) {
    }
}

