/*
 * Copyright 2010-2016 Amazon.com, Inc. or its affiliates. All Rights
 * Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 *  http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

package com.amazonaws.services.storagegateway.model;

import java.io.Serializable;

/**
 * 
 */
public class DescribeSnapshotScheduleResult implements Serializable, Cloneable {

    private String volumeARN;

    private Integer startAt;

    private Integer recurrenceInHours;

    private String description;

    private String timezone;

    /**
     * @param volumeARN
     */

    public void setVolumeARN(String volumeARN) {
        this.volumeARN = volumeARN;
    }

    /**
     * @return
     */

    public String getVolumeARN() {
        return this.volumeARN;
    }

    /**
     * @param volumeARN
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeSnapshotScheduleResult withVolumeARN(String volumeARN) {
        setVolumeARN(volumeARN);
        return this;
    }

    /**
     * @param startAt
     */

    public void setStartAt(Integer startAt) {
        this.startAt = startAt;
    }

    /**
     * @return
     */

    public Integer getStartAt() {
        return this.startAt;
    }

    /**
     * @param startAt
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeSnapshotScheduleResult withStartAt(Integer startAt) {
        setStartAt(startAt);
        return this;
    }

    /**
     * @param recurrenceInHours
     */

    public void setRecurrenceInHours(Integer recurrenceInHours) {
        this.recurrenceInHours = recurrenceInHours;
    }

    /**
     * @return
     */

    public Integer getRecurrenceInHours() {
        return this.recurrenceInHours;
    }

    /**
     * @param recurrenceInHours
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeSnapshotScheduleResult withRecurrenceInHours(
            Integer recurrenceInHours) {
        setRecurrenceInHours(recurrenceInHours);
        return this;
    }

    /**
     * @param description
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * @return
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * @param description
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeSnapshotScheduleResult withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * @param timezone
     */

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    /**
     * @return
     */

    public String getTimezone() {
        return this.timezone;
    }

    /**
     * @param timezone
     * @return Returns a reference to this object so that method calls can be
     *         chained together.
     */

    public DescribeSnapshotScheduleResult withTimezone(String timezone) {
        setTimezone(timezone);
        return this;
    }

    /**
     * Returns a string representation of this object; useful for testing and
     * debugging.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getVolumeARN() != null)
            sb.append("VolumeARN: " + getVolumeARN() + ",");
        if (getStartAt() != null)
            sb.append("StartAt: " + getStartAt() + ",");
        if (getRecurrenceInHours() != null)
            sb.append("RecurrenceInHours: " + getRecurrenceInHours() + ",");
        if (getDescription() != null)
            sb.append("Description: " + getDescription() + ",");
        if (getTimezone() != null)
            sb.append("Timezone: " + getTimezone());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeSnapshotScheduleResult == false)
            return false;
        DescribeSnapshotScheduleResult other = (DescribeSnapshotScheduleResult) obj;
        if (other.getVolumeARN() == null ^ this.getVolumeARN() == null)
            return false;
        if (other.getVolumeARN() != null
                && other.getVolumeARN().equals(this.getVolumeARN()) == false)
            return false;
        if (other.getStartAt() == null ^ this.getStartAt() == null)
            return false;
        if (other.getStartAt() != null
                && other.getStartAt().equals(this.getStartAt()) == false)
            return false;
        if (other.getRecurrenceInHours() == null
                ^ this.getRecurrenceInHours() == null)
            return false;
        if (other.getRecurrenceInHours() != null
                && other.getRecurrenceInHours().equals(
                        this.getRecurrenceInHours()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null
                && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getTimezone() == null ^ this.getTimezone() == null)
            return false;
        if (other.getTimezone() != null
                && other.getTimezone().equals(this.getTimezone()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode
                + ((getVolumeARN() == null) ? 0 : getVolumeARN().hashCode());
        hashCode = prime * hashCode
                + ((getStartAt() == null) ? 0 : getStartAt().hashCode());
        hashCode = prime
                * hashCode
                + ((getRecurrenceInHours() == null) ? 0
                        : getRecurrenceInHours().hashCode());
        hashCode = prime
                * hashCode
                + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode
                + ((getTimezone() == null) ? 0 : getTimezone().hashCode());
        return hashCode;
    }

    @Override
    public DescribeSnapshotScheduleResult clone() {
        try {
            return (DescribeSnapshotScheduleResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException(
                    "Got a CloneNotSupportedException from Object.clone() "
                            + "even though we're Cloneable!", e);
        }
    }
}
