# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._appliances_enums import *


class Resource(msrest.serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Appliance(TrackedResource):
    """Appliances definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives.
    :type location: str
    :param identity: Identity for the resource.
    :type identity: ~appliances.models.Identity
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~appliances.models.SystemData
    :param distro: Represents a supported Fabric/Infra. (AKSEdge etc...). Possible values include:
     "AKSEdge". Default value: "AKSEdge".
    :type distro: str or ~appliances.models.Distro
    :param infrastructure_config: Contains infrastructure information about the Appliance.
    :type infrastructure_config: ~appliances.models.AppliancePropertiesInfrastructureConfig
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :param public_key: Certificates pair used to download MSI certificate from HIS.
    :type public_key: str
    :ivar status: Appliance’s health and state of connection to on-prem. Possible values include:
     "WaitingForHeartbeat", "Validating", "Connected", "Running".
    :vartype status: str or ~appliances.models.Status
    :ivar version: Version of the Appliance.
    :vartype version: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'status': {'readonly': True},
        'version': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'distro': {'key': 'properties.distro', 'type': 'str'},
        'infrastructure_config': {'key': 'properties.infrastructureConfig', 'type': 'AppliancePropertiesInfrastructureConfig'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'public_key': {'key': 'properties.publicKey', 'type': 'str'},
        'status': {'key': 'properties.status', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["Identity"] = None,
        distro: Optional[Union[str, "Distro"]] = "AKSEdge",
        infrastructure_config: Optional["AppliancePropertiesInfrastructureConfig"] = None,
        public_key: Optional[str] = None,
        **kwargs
    ):
        super(Appliance, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.system_data = None
        self.distro = distro
        self.infrastructure_config = infrastructure_config
        self.provisioning_state = None
        self.public_key = public_key
        self.status = None
        self.version = None


class ApplianceCredentialKubeconfig(msrest.serialization.Model):
    """Cluster User Credential appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name which contains the role of the kubeconfig. Possible values include:
     "clusterUser".
    :vartype name: str or ~appliances.models.AccessProfileType
    :ivar value: Contains the kubeconfig value.
    :vartype value: str
    """

    _validation = {
        'name': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplianceCredentialKubeconfig, self).__init__(**kwargs)
        self.name = None
        self.value = None


class ApplianceListCredentialResults(msrest.serialization.Model):
    """The List Cluster User Credential appliance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar hybrid_connection_config: Contains the REP (rendezvous endpoint) and “Listener” access
     token from notification service (NS).
    :vartype hybrid_connection_config: ~appliances.models.HybridConnectionConfig
    :ivar kubeconfigs: The list of appliance kubeconfigs.
    :vartype kubeconfigs: list[~appliances.models.ApplianceCredentialKubeconfig]
    """

    _validation = {
        'hybrid_connection_config': {'readonly': True},
        'kubeconfigs': {'readonly': True},
    }

    _attribute_map = {
        'hybrid_connection_config': {'key': 'hybridConnectionConfig', 'type': 'HybridConnectionConfig'},
        'kubeconfigs': {'key': 'kubeconfigs', 'type': '[ApplianceCredentialKubeconfig]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplianceListCredentialResults, self).__init__(**kwargs)
        self.hybrid_connection_config = None
        self.kubeconfigs = None


class ApplianceListResult(msrest.serialization.Model):
    """The List Appliances operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar next_link: The URL to use for getting the next set of results.
    :vartype next_link: str
    :ivar value: The list of Appliances.
    :vartype value: list[~appliances.models.Appliance]
    """

    _validation = {
        'next_link': {'readonly': True},
        'value': {'readonly': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[Appliance]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplianceListResult, self).__init__(**kwargs)
        self.next_link = None
        self.value = None


class ApplianceOperation(msrest.serialization.Model):
    """Appliances operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_data_action: Is this Operation a data plane operation.
    :vartype is_data_action: bool
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    """

    _validation = {
        'is_data_action': {'readonly': True},
        'name': {'readonly': True},
        'origin': {'readonly': True},
        'description': {'readonly': True},
        'operation': {'readonly': True},
        'provider': {'readonly': True},
        'resource': {'readonly': True},
    }

    _attribute_map = {
        'is_data_action': {'key': 'isDataAction', 'type': 'bool'},
        'name': {'key': 'name', 'type': 'str'},
        'origin': {'key': 'origin', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ApplianceOperation, self).__init__(**kwargs)
        self.is_data_action = None
        self.name = None
        self.origin = None
        self.description = None
        self.operation = None
        self.provider = None
        self.resource = None


class ApplianceOperationsList(msrest.serialization.Model):
    """Lists of Appliances operations.

    All required parameters must be populated in order to send to Azure.

    :param next_link: Next page of operations.
    :type next_link: str
    :param value: Required. Array of applianceOperation.
    :type value: list[~appliances.models.ApplianceOperation]
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'next_link': {'key': 'nextLink', 'type': 'str'},
        'value': {'key': 'value', 'type': '[ApplianceOperation]'},
    }

    def __init__(
        self,
        *,
        value: List["ApplianceOperation"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ApplianceOperationsList, self).__init__(**kwargs)
        self.next_link = next_link
        self.value = value


class AppliancePropertiesInfrastructureConfig(msrest.serialization.Model):
    """Contains infrastructure information about the Appliance.

    :param provider: Information about the connected appliance. Possible values include: "VMWare",
     "HCI", "SCVMM".
    :type provider: str or ~appliances.models.Provider
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        provider: Optional[Union[str, "Provider"]] = None,
        **kwargs
    ):
        super(AppliancePropertiesInfrastructureConfig, self).__init__(**kwargs)
        self.provider = provider


class ErrorAdditionalInfo(msrest.serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(msrest.serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~appliances.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~appliances.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorDetail]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ErrorDetail, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(msrest.serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed operations. (This also follows the OData error response format.).

    :param error: The error object.
    :type error: ~appliances.models.ErrorDetail
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorDetail'},
    }

    def __init__(
        self,
        *,
        error: Optional["ErrorDetail"] = None,
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class HybridConnectionConfig(msrest.serialization.Model):
    """Contains the REP (rendezvous endpoint) and “Listener” access token from notification service (NS).

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar expiration_time: Timestamp when this token will be expired.
    :vartype expiration_time: long
    :ivar hybrid_connection_name: Name of the connection.
    :vartype hybrid_connection_name: str
    :ivar relay: Name of the notification service.
    :vartype relay: str
    :ivar token: Listener access token.
    :vartype token: str
    """

    _validation = {
        'expiration_time': {'readonly': True},
        'hybrid_connection_name': {'readonly': True},
        'relay': {'readonly': True},
        'token': {'readonly': True},
    }

    _attribute_map = {
        'expiration_time': {'key': 'expirationTime', 'type': 'long'},
        'hybrid_connection_name': {'key': 'hybridConnectionName', 'type': 'str'},
        'relay': {'key': 'relay', 'type': 'str'},
        'token': {'key': 'token', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(HybridConnectionConfig, self).__init__(**kwargs)
        self.expiration_time = None
        self.hybrid_connection_name = None
        self.relay = None
        self.token = None


class Identity(msrest.serialization.Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: The identity type. Possible values include: "SystemAssigned", "None".
    :type type: str or ~appliances.models.ResourceIdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        **kwargs
    ):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class PatchableAppliance(msrest.serialization.Model):
    """The Appliances patchable resource definition.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(PatchableAppliance, self).__init__(**kwargs)
        self.tags = tags


class SystemData(msrest.serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource. Possible values
     include: "User", "Application", "ManagedIdentity", "Key".
    :type created_by_type: str or ~appliances.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: ~datetime.datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the resource. Possible
     values include: "User", "Application", "ManagedIdentity", "Key".
    :type last_modified_by_type: str or ~appliances.models.CreatedByType
    :param last_modified_at: The timestamp of resource last modification (UTC).
    :type last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at
