# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
if sys.version_info >= (3, 8):
    from typing import Literal  # pylint: disable=no-name-in-module, ungrouped-imports
else:
    from typing_extensions import Literal  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class AccountCredentialDetails(_serialization.Model):
    """Credential details of the account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar account_name: Name of the account.
    :vartype account_name: str
    :ivar data_account_type: Type of the account. Known values are: "StorageAccount" and
     "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar account_connection_string: Connection string of the account endpoint to use the account
     as a storage endpoint on the device.
    :vartype account_connection_string: str
    :ivar share_credential_details: Per share level unencrypted access credentials.
    :vartype share_credential_details:
     list[~azure.mgmt.databox.v2022_02_01.models.ShareCredentialDetails]
    """

    _validation = {
        "account_name": {"readonly": True},
        "data_account_type": {"readonly": True},
        "account_connection_string": {"readonly": True},
        "share_credential_details": {"readonly": True},
    }

    _attribute_map = {
        "account_name": {"key": "accountName", "type": "str"},
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "account_connection_string": {"key": "accountConnectionString", "type": "str"},
        "share_credential_details": {"key": "shareCredentialDetails", "type": "[ShareCredentialDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.account_name = None
        self.data_account_type = None
        self.account_connection_string = None
        self.share_credential_details = None


class AdditionalErrorInfo(_serialization.Model):
    """This class represents additional info which Resource Providers pass when an error occurs.

    :ivar info: Additional information of the type of error.
    :vartype info: JSON
    :ivar type: Type of error (e.g. CustomerIntervention, PolicyViolation, SecurityViolation).
    :vartype type: str
    """

    _attribute_map = {
        "info": {"key": "info", "type": "object"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, *, info: Optional[JSON] = None, type: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword info: Additional information of the type of error.
        :paramtype info: JSON
        :keyword type: Type of error (e.g. CustomerIntervention, PolicyViolation, SecurityViolation).
        :paramtype type: str
        """
        super().__init__(**kwargs)
        self.info = info
        self.type = type


class AddressValidationOutput(_serialization.Model):
    """Output of the address validation api.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar validation_type: Identifies the type of validation response. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar validation_status: The address validation status. Known values are: "Valid", "Invalid",
     and "Ambiguous".
    :vartype validation_status: str or
     ~azure.mgmt.databox.v2022_02_01.models.AddressValidationStatus
    :ivar alternate_addresses: List of alternate addresses.
    :vartype alternate_addresses: list[~azure.mgmt.databox.v2022_02_01.models.ShippingAddress]
    """

    _validation = {
        "error": {"readonly": True},
        "validation_status": {"readonly": True},
        "alternate_addresses": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "properties.validationType", "type": "str"},
        "error": {"key": "properties.error", "type": "CloudError"},
        "validation_status": {"key": "properties.validationStatus", "type": "str"},
        "alternate_addresses": {"key": "properties.alternateAddresses", "type": "[ShippingAddress]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: Optional[str] = None
        self.error = None
        self.validation_status = None
        self.alternate_addresses = None


class ValidationInputResponse(_serialization.Model):
    """Minimum properties that should be present in each individual validation response.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AddressValidationProperties, CreateOrderLimitForSubscriptionValidationResponseProperties,
    DataTransferDetailsValidationResponseProperties, PreferencesValidationResponseProperties,
    SkuAvailabilityValidationResponseProperties,
    SubscriptionIsAllowedToCreateJobValidationResponseProperties

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "CloudError"},
    }

    _subtype_map = {
        "validation_type": {
            "ValidateAddress": "AddressValidationProperties",
            "ValidateCreateOrderLimit": "CreateOrderLimitForSubscriptionValidationResponseProperties",
            "ValidateDataTransferDetails": "DataTransferDetailsValidationResponseProperties",
            "ValidatePreferences": "PreferencesValidationResponseProperties",
            "ValidateSkuAvailability": "SkuAvailabilityValidationResponseProperties",
            "ValidateSubscriptionIsAllowedToCreateJob": "SubscriptionIsAllowedToCreateJobValidationResponseProperties",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: Optional[str] = None
        self.error = None


class AddressValidationProperties(ValidationInputResponse):
    """The address validation output.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar validation_status: The address validation status. Known values are: "Valid", "Invalid",
     and "Ambiguous".
    :vartype validation_status: str or
     ~azure.mgmt.databox.v2022_02_01.models.AddressValidationStatus
    :ivar alternate_addresses: List of alternate addresses.
    :vartype alternate_addresses: list[~azure.mgmt.databox.v2022_02_01.models.ShippingAddress]
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "validation_status": {"readonly": True},
        "alternate_addresses": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "CloudError"},
        "validation_status": {"key": "validationStatus", "type": "str"},
        "alternate_addresses": {"key": "alternateAddresses", "type": "[ShippingAddress]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateAddress"
        self.validation_status = None
        self.alternate_addresses = None


class ApiError(_serialization.Model):
    """ApiError.

    All required parameters must be populated in order to send to Azure.

    :ivar error: Required.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.ErrorDetail
    """

    _validation = {
        "error": {"required": True},
    }

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: "_models.ErrorDetail", **kwargs: Any) -> None:
        """
        :keyword error: Required.
        :paramtype error: ~azure.mgmt.databox.v2022_02_01.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class ApplianceNetworkConfiguration(_serialization.Model):
    """The Network Adapter configuration of a DataBox.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the network.
    :vartype name: str
    :ivar mac_address: Mac Address.
    :vartype mac_address: str
    """

    _validation = {
        "name": {"readonly": True},
        "mac_address": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.mac_address = None


class ArmBaseObject(_serialization.Model):
    """Base class for all objects under resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the object.
    :vartype name: str
    :ivar id: Id of the object.
    :vartype id: str
    :ivar type: Type of the object.
    :vartype type: str
    """

    _validation = {
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.name = None
        self.id = None
        self.type = None


class AvailableSkuRequest(_serialization.Model):
    """The filters for showing the available skus.

    All required parameters must be populated in order to send to Azure.

    :ivar transfer_type: Type of the transfer. Required. Known values are: "ImportToAzure" and
     "ExportFromAzure".
    :vartype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
    :ivar country: ISO country code. Country for hardware shipment. For codes check:
     https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. Required.
    :vartype country: str
    :ivar location: Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype location: str
    :ivar sku_names: Sku Names to filter for available skus.
    :vartype sku_names: list[str or ~azure.mgmt.databox.v2022_02_01.models.SkuName]
    """

    _validation = {
        "transfer_type": {"required": True},
        "country": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "transfer_type": {"key": "transferType", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "sku_names": {"key": "skuNames", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        transfer_type: Union[str, "_models.TransferType"],
        country: str,
        location: str,
        sku_names: Optional[List[Union[str, "_models.SkuName"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword transfer_type: Type of the transfer. Required. Known values are: "ImportToAzure" and
         "ExportFromAzure".
        :paramtype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
        :keyword country: ISO country code. Country for hardware shipment. For codes check:
         https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. Required.
        :paramtype country: str
        :keyword location: Location for data transfer. For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype location: str
        :keyword sku_names: Sku Names to filter for available skus.
        :paramtype sku_names: list[str or ~azure.mgmt.databox.v2022_02_01.models.SkuName]
        """
        super().__init__(**kwargs)
        self.transfer_type = transfer_type
        self.country = country
        self.location = location
        self.sku_names = sku_names


class AvailableSkusResult(_serialization.Model):
    """The available skus operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of available skus.
    :vartype value: list[~azure.mgmt.databox.v2022_02_01.models.SkuInformation]
    :ivar next_link: Link for the next set of skus.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SkuInformation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link for the next set of skus.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class AzureFileFilterDetails(_serialization.Model):
    """Filter details to transfer Azure files.

    :ivar file_prefix_list: Prefix list of the Azure files to be transferred.
    :vartype file_prefix_list: list[str]
    :ivar file_path_list: List of full path of the files to be transferred.
    :vartype file_path_list: list[str]
    :ivar file_share_list: List of file shares to be transferred.
    :vartype file_share_list: list[str]
    """

    _attribute_map = {
        "file_prefix_list": {"key": "filePrefixList", "type": "[str]"},
        "file_path_list": {"key": "filePathList", "type": "[str]"},
        "file_share_list": {"key": "fileShareList", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        file_prefix_list: Optional[List[str]] = None,
        file_path_list: Optional[List[str]] = None,
        file_share_list: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword file_prefix_list: Prefix list of the Azure files to be transferred.
        :paramtype file_prefix_list: list[str]
        :keyword file_path_list: List of full path of the files to be transferred.
        :paramtype file_path_list: list[str]
        :keyword file_share_list: List of file shares to be transferred.
        :paramtype file_share_list: list[str]
        """
        super().__init__(**kwargs)
        self.file_prefix_list = file_prefix_list
        self.file_path_list = file_path_list
        self.file_share_list = file_share_list


class BlobFilterDetails(_serialization.Model):
    """Filter details to transfer Azure Blobs.

    :ivar blob_prefix_list: Prefix list of the Azure blobs to be transferred.
    :vartype blob_prefix_list: list[str]
    :ivar blob_path_list: List of full path of the blobs to be transferred.
    :vartype blob_path_list: list[str]
    :ivar container_list: List of blob containers to be transferred.
    :vartype container_list: list[str]
    """

    _attribute_map = {
        "blob_prefix_list": {"key": "blobPrefixList", "type": "[str]"},
        "blob_path_list": {"key": "blobPathList", "type": "[str]"},
        "container_list": {"key": "containerList", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        blob_prefix_list: Optional[List[str]] = None,
        blob_path_list: Optional[List[str]] = None,
        container_list: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword blob_prefix_list: Prefix list of the Azure blobs to be transferred.
        :paramtype blob_prefix_list: list[str]
        :keyword blob_path_list: List of full path of the blobs to be transferred.
        :paramtype blob_path_list: list[str]
        :keyword container_list: List of blob containers to be transferred.
        :paramtype container_list: list[str]
        """
        super().__init__(**kwargs)
        self.blob_prefix_list = blob_prefix_list
        self.blob_path_list = blob_path_list
        self.container_list = container_list


class CancellationReason(_serialization.Model):
    """Reason for cancellation.

    All required parameters must be populated in order to send to Azure.

    :ivar reason: Reason for cancellation. Required.
    :vartype reason: str
    """

    _validation = {
        "reason": {"required": True},
    }

    _attribute_map = {
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, *, reason: str, **kwargs: Any) -> None:
        """
        :keyword reason: Reason for cancellation. Required.
        :paramtype reason: str
        """
        super().__init__(**kwargs)
        self.reason = reason


class CloudError(_serialization.Model):
    """Provides additional information about an http error response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar additional_info: Gets or sets additional error info.
    :vartype additional_info: list[~azure.mgmt.databox.v2022_02_01.models.AdditionalErrorInfo]
    :ivar code: Error code.
    :vartype code: str
    :ivar details: Gets or sets details for the error.
    :vartype details: list[~azure.mgmt.databox.v2022_02_01.models.CloudError]
    :ivar message: The error message parsed from the body of the http error response.
    :vartype message: str
    :ivar target: Gets or sets the target of the error.
    :vartype target: str
    """

    _validation = {
        "additional_info": {"readonly": True},
        "details": {"readonly": True},
    }

    _attribute_map = {
        "additional_info": {"key": "additionalInfo", "type": "[AdditionalErrorInfo]"},
        "code": {"key": "code", "type": "str"},
        "details": {"key": "details", "type": "[CloudError]"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, message: Optional[str] = None, target: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code: Error code.
        :paramtype code: str
        :keyword message: The error message parsed from the body of the http error response.
        :paramtype message: str
        :keyword target: Gets or sets the target of the error.
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.additional_info = None
        self.code = code
        self.details = None
        self.message = message
        self.target = target


class ContactDetails(_serialization.Model):
    """Contact Details.

    All required parameters must be populated in order to send to Azure.

    :ivar contact_name: Contact name of the person. Required.
    :vartype contact_name: str
    :ivar phone: Phone number of the contact person. Required.
    :vartype phone: str
    :ivar phone_extension: Phone extension number of the contact person.
    :vartype phone_extension: str
    :ivar mobile: Mobile number of the contact person.
    :vartype mobile: str
    :ivar email_list: List of Email-ids to be notified about job progress. Required.
    :vartype email_list: list[str]
    :ivar notification_preference: Notification preference for a job stage.
    :vartype notification_preference:
     list[~azure.mgmt.databox.v2022_02_01.models.NotificationPreference]
    """

    _validation = {
        "contact_name": {"required": True},
        "phone": {"required": True},
        "email_list": {"required": True},
    }

    _attribute_map = {
        "contact_name": {"key": "contactName", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "phone_extension": {"key": "phoneExtension", "type": "str"},
        "mobile": {"key": "mobile", "type": "str"},
        "email_list": {"key": "emailList", "type": "[str]"},
        "notification_preference": {"key": "notificationPreference", "type": "[NotificationPreference]"},
    }

    def __init__(
        self,
        *,
        contact_name: str,
        phone: str,
        email_list: List[str],
        phone_extension: Optional[str] = None,
        mobile: Optional[str] = None,
        notification_preference: Optional[List["_models.NotificationPreference"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_name: Contact name of the person. Required.
        :paramtype contact_name: str
        :keyword phone: Phone number of the contact person. Required.
        :paramtype phone: str
        :keyword phone_extension: Phone extension number of the contact person.
        :paramtype phone_extension: str
        :keyword mobile: Mobile number of the contact person.
        :paramtype mobile: str
        :keyword email_list: List of Email-ids to be notified about job progress. Required.
        :paramtype email_list: list[str]
        :keyword notification_preference: Notification preference for a job stage.
        :paramtype notification_preference:
         list[~azure.mgmt.databox.v2022_02_01.models.NotificationPreference]
        """
        super().__init__(**kwargs)
        self.contact_name = contact_name
        self.phone = phone
        self.phone_extension = phone_extension
        self.mobile = mobile
        self.email_list = email_list
        self.notification_preference = notification_preference


class CopyLogDetails(_serialization.Model):
    """Details for log generated during copy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataBoxAccountCopyLogDetails, DataBoxCustomerDiskCopyLogDetails, DataBoxDiskCopyLogDetails,
    DataBoxHeavyAccountCopyLogDetails

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    """

    _validation = {
        "copy_log_details_type": {"required": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
    }

    _subtype_map = {
        "copy_log_details_type": {
            "DataBox": "DataBoxAccountCopyLogDetails",
            "DataBoxCustomerDisk": "DataBoxCustomerDiskCopyLogDetails",
            "DataBoxDisk": "DataBoxDiskCopyLogDetails",
            "DataBoxHeavy": "DataBoxHeavyAccountCopyLogDetails",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: Optional[str] = None


class CopyProgress(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Copy progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_account_name: Name of the storage account. This will be empty for data account
     types other than storage account.
    :vartype storage_account_name: str
    :ivar transfer_type: Transfer type of data. Known values are: "ImportToAzure" and
     "ExportFromAzure".
    :vartype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
    :ivar data_account_type: Data Account Type. Known values are: "StorageAccount" and
     "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar account_id: Id of the account where the data needs to be uploaded.
    :vartype account_id: str
    :ivar bytes_processed: To indicate bytes transferred.
    :vartype bytes_processed: int
    :ivar total_bytes_to_process: Total amount of data to be processed by the job.
    :vartype total_bytes_to_process: int
    :ivar files_processed: Number of files processed.
    :vartype files_processed: int
    :ivar total_files_to_process: Total files to process.
    :vartype total_files_to_process: int
    :ivar invalid_files_processed: Number of files not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype invalid_files_processed: int
    :ivar invalid_file_bytes_uploaded: Total amount of data not adhering to azure naming
     conventions which were processed by automatic renaming.
    :vartype invalid_file_bytes_uploaded: int
    :ivar renamed_container_count: Number of folders not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype renamed_container_count: int
    :ivar files_errored_out: Number of files which could not be copied.
    :vartype files_errored_out: int
    :ivar directories_errored_out: To indicate directories errored out in the job.
    :vartype directories_errored_out: int
    :ivar invalid_directories_processed: To indicate directories renamed.
    :vartype invalid_directories_processed: int
    :ivar is_enumeration_in_progress: To indicate if enumeration of data is in progress.
     Until this is true, the TotalBytesToProcess may not be valid.
    :vartype is_enumeration_in_progress: bool
    """

    _validation = {
        "storage_account_name": {"readonly": True},
        "transfer_type": {"readonly": True},
        "data_account_type": {"readonly": True},
        "account_id": {"readonly": True},
        "bytes_processed": {"readonly": True},
        "total_bytes_to_process": {"readonly": True},
        "files_processed": {"readonly": True},
        "total_files_to_process": {"readonly": True},
        "invalid_files_processed": {"readonly": True},
        "invalid_file_bytes_uploaded": {"readonly": True},
        "renamed_container_count": {"readonly": True},
        "files_errored_out": {"readonly": True},
        "directories_errored_out": {"readonly": True},
        "invalid_directories_processed": {"readonly": True},
        "is_enumeration_in_progress": {"readonly": True},
    }

    _attribute_map = {
        "storage_account_name": {"key": "storageAccountName", "type": "str"},
        "transfer_type": {"key": "transferType", "type": "str"},
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "bytes_processed": {"key": "bytesProcessed", "type": "int"},
        "total_bytes_to_process": {"key": "totalBytesToProcess", "type": "int"},
        "files_processed": {"key": "filesProcessed", "type": "int"},
        "total_files_to_process": {"key": "totalFilesToProcess", "type": "int"},
        "invalid_files_processed": {"key": "invalidFilesProcessed", "type": "int"},
        "invalid_file_bytes_uploaded": {"key": "invalidFileBytesUploaded", "type": "int"},
        "renamed_container_count": {"key": "renamedContainerCount", "type": "int"},
        "files_errored_out": {"key": "filesErroredOut", "type": "int"},
        "directories_errored_out": {"key": "directoriesErroredOut", "type": "int"},
        "invalid_directories_processed": {"key": "invalidDirectoriesProcessed", "type": "int"},
        "is_enumeration_in_progress": {"key": "isEnumerationInProgress", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.storage_account_name = None
        self.transfer_type = None
        self.data_account_type = None
        self.account_id = None
        self.bytes_processed = None
        self.total_bytes_to_process = None
        self.files_processed = None
        self.total_files_to_process = None
        self.invalid_files_processed = None
        self.invalid_file_bytes_uploaded = None
        self.renamed_container_count = None
        self.files_errored_out = None
        self.directories_errored_out = None
        self.invalid_directories_processed = None
        self.is_enumeration_in_progress = None


class ValidationRequest(_serialization.Model):
    """Minimum request requirement of any validation category.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    CreateJobValidations

    All required parameters must be populated in order to send to Azure.

    :ivar validation_category: Identify the nature of validation. Required. Default value is
     "JobCreationValidation".
    :vartype validation_category: str
    :ivar individual_request_details: List of request details contain validationType and its
     request as key and value respectively. Required.
    :vartype individual_request_details:
     list[~azure.mgmt.databox.v2022_02_01.models.ValidationInputRequest]
    """

    _validation = {
        "validation_category": {"required": True},
        "individual_request_details": {"required": True},
    }

    _attribute_map = {
        "validation_category": {"key": "validationCategory", "type": "str"},
        "individual_request_details": {"key": "individualRequestDetails", "type": "[ValidationInputRequest]"},
    }

    _subtype_map = {"validation_category": {"JobCreationValidation": "CreateJobValidations"}}

    def __init__(self, *, individual_request_details: List["_models.ValidationInputRequest"], **kwargs: Any) -> None:
        """
        :keyword individual_request_details: List of request details contain validationType and its
         request as key and value respectively. Required.
        :paramtype individual_request_details:
         list[~azure.mgmt.databox.v2022_02_01.models.ValidationInputRequest]
        """
        super().__init__(**kwargs)
        self.validation_category: Optional[str] = None
        self.individual_request_details = individual_request_details


class CreateJobValidations(ValidationRequest):
    """It does all pre-job creation validations.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_category: Identify the nature of validation. Required. Default value is
     "JobCreationValidation".
    :vartype validation_category: str
    :ivar individual_request_details: List of request details contain validationType and its
     request as key and value respectively. Required.
    :vartype individual_request_details:
     list[~azure.mgmt.databox.v2022_02_01.models.ValidationInputRequest]
    """

    _validation = {
        "validation_category": {"required": True},
        "individual_request_details": {"required": True},
    }

    _attribute_map = {
        "validation_category": {"key": "validationCategory", "type": "str"},
        "individual_request_details": {"key": "individualRequestDetails", "type": "[ValidationInputRequest]"},
    }

    def __init__(self, *, individual_request_details: List["_models.ValidationInputRequest"], **kwargs: Any) -> None:
        """
        :keyword individual_request_details: List of request details contain validationType and its
         request as key and value respectively. Required.
        :paramtype individual_request_details:
         list[~azure.mgmt.databox.v2022_02_01.models.ValidationInputRequest]
        """
        super().__init__(individual_request_details=individual_request_details, **kwargs)
        self.validation_category: str = "JobCreationValidation"


class ValidationInputRequest(_serialization.Model):
    """Minimum fields that must be present in any type of validation request.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ValidateAddress, CreateOrderLimitForSubscriptionValidationRequest,
    DataTransferDetailsValidationRequest, PreferencesValidationRequest,
    SkuAvailabilityValidationRequest, SubscriptionIsAllowedToCreateJobValidationRequest

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    """

    _validation = {
        "validation_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
    }

    _subtype_map = {
        "validation_type": {
            "ValidateAddress": "ValidateAddress",
            "ValidateCreateOrderLimit": "CreateOrderLimitForSubscriptionValidationRequest",
            "ValidateDataTransferDetails": "DataTransferDetailsValidationRequest",
            "ValidatePreferences": "PreferencesValidationRequest",
            "ValidateSkuAvailability": "SkuAvailabilityValidationRequest",
            "ValidateSubscriptionIsAllowedToCreateJob": "SubscriptionIsAllowedToCreateJobValidationRequest",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: Optional[str] = None


class CreateOrderLimitForSubscriptionValidationRequest(ValidationInputRequest):
    """Request to validate create order limit for current subscription.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar device_type: Device type to be used for the job. Required. Known values are: "DataBox",
     "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    """

    _validation = {
        "validation_type": {"required": True},
        "device_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
    }

    def __init__(self, *, device_type: Union[str, "_models.SkuName"], **kwargs: Any) -> None:
        """
        :keyword device_type: Device type to be used for the job. Required. Known values are:
         "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
        :paramtype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateCreateOrderLimit"
        self.device_type = device_type


class CreateOrderLimitForSubscriptionValidationResponseProperties(ValidationInputResponse):
    """Properties of create order limit for subscription validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar status: Create order limit validation status. Known values are: "Valid", "Invalid", and
     "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2022_02_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "CloudError"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateCreateOrderLimit"
        self.status = None


class JobSecrets(_serialization.Model):
    """The base class for the secrets.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataboxJobSecrets, CustomerDiskJobSecrets, DataBoxDiskJobSecrets, DataBoxHeavyJobSecrets

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_secrets_type: Used to indicate what type of job secrets object. Required. Known
     values are: "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_secrets_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.v2022_02_01.models.DcAccessSecurityCode
    :ivar error: Error while fetching the secrets.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    """

    _validation = {
        "job_secrets_type": {"required": True},
        "dc_access_security_code": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "job_secrets_type": {"key": "jobSecretsType", "type": "str"},
        "dc_access_security_code": {"key": "dcAccessSecurityCode", "type": "DcAccessSecurityCode"},
        "error": {"key": "error", "type": "CloudError"},
    }

    _subtype_map = {
        "job_secrets_type": {
            "DataBox": "DataboxJobSecrets",
            "DataBoxCustomerDisk": "CustomerDiskJobSecrets",
            "DataBoxDisk": "DataBoxDiskJobSecrets",
            "DataBoxHeavy": "DataBoxHeavyJobSecrets",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.job_secrets_type: Optional[str] = None
        self.dc_access_security_code = None
        self.error = None


class CustomerDiskJobSecrets(JobSecrets):
    """The secrets related to customer disk job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_secrets_type: Used to indicate what type of job secrets object. Required. Known
     values are: "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_secrets_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.v2022_02_01.models.DcAccessSecurityCode
    :ivar error: Error while fetching the secrets.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar disk_secrets: Contains the list of secrets object for that device.
    :vartype disk_secrets: list[~azure.mgmt.databox.v2022_02_01.models.DiskSecret]
    :ivar carrier_account_number: Carrier Account Number of the customer.
    :vartype carrier_account_number: str
    """

    _validation = {
        "job_secrets_type": {"required": True},
        "dc_access_security_code": {"readonly": True},
        "error": {"readonly": True},
        "disk_secrets": {"readonly": True},
        "carrier_account_number": {"readonly": True},
    }

    _attribute_map = {
        "job_secrets_type": {"key": "jobSecretsType", "type": "str"},
        "dc_access_security_code": {"key": "dcAccessSecurityCode", "type": "DcAccessSecurityCode"},
        "error": {"key": "error", "type": "CloudError"},
        "disk_secrets": {"key": "diskSecrets", "type": "[DiskSecret]"},
        "carrier_account_number": {"key": "carrierAccountNumber", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.job_secrets_type: str = "DataBoxCustomerDisk"
        self.disk_secrets = None
        self.carrier_account_number = None


class DataAccountDetails(_serialization.Model):
    """Account details of the data to be transferred.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ManagedDiskDetails, StorageAccountDetails

    All required parameters must be populated in order to send to Azure.

    :ivar data_account_type: Account Type of the data to be transferred. Required. Known values
     are: "StorageAccount" and "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar share_password: Password for all the shares to be created on the device. Should not be
     passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
     password itself. This will not be returned in Get Call. Password Requirements :  Password must
     be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
     alphabet, one number and one special character. Password cannot have the following characters :
     IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :vartype share_password: str
    """

    _validation = {
        "data_account_type": {"required": True},
    }

    _attribute_map = {
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "share_password": {"key": "sharePassword", "type": "str"},
    }

    _subtype_map = {
        "data_account_type": {"ManagedDisk": "ManagedDiskDetails", "StorageAccount": "StorageAccountDetails"}
    }

    def __init__(self, *, share_password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword share_password: Password for all the shares to be created on the device. Should not be
         passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
         password itself. This will not be returned in Get Call. Password Requirements :  Password must
         be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
         alphabet, one number and one special character. Password cannot have the following characters :
         IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
        :paramtype share_password: str
        """
        super().__init__(**kwargs)
        self.data_account_type: Optional[str] = None
        self.share_password = share_password


class DataBoxAccountCopyLogDetails(CopyLogDetails):
    """Copy log details for a storage account of a DataBox job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar account_name: Account name.
    :vartype account_name: str
    :ivar copy_log_link: Link for copy logs.
    :vartype copy_log_link: str
    :ivar copy_verbose_log_link: Link for copy verbose logs. This will be set only when
     LogCollectionLevel is set to Verbose.
    :vartype copy_verbose_log_link: str
    """

    _validation = {
        "copy_log_details_type": {"required": True},
        "account_name": {"readonly": True},
        "copy_log_link": {"readonly": True},
        "copy_verbose_log_link": {"readonly": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "copy_log_link": {"key": "copyLogLink", "type": "str"},
        "copy_verbose_log_link": {"key": "copyVerboseLogLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: str = "DataBox"
        self.account_name = None
        self.copy_log_link = None
        self.copy_verbose_log_link = None


class DataBoxCustomerDiskCopyLogDetails(CopyLogDetails):
    """Copy Log Details for customer disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar serial_number: Disk Serial Number.
    :vartype serial_number: str
    :ivar error_log_link: Link for copy error logs.
    :vartype error_log_link: str
    :ivar verbose_log_link: Link for copy verbose logs.
    :vartype verbose_log_link: str
    """

    _validation = {
        "copy_log_details_type": {"required": True},
        "serial_number": {"readonly": True},
        "error_log_link": {"readonly": True},
        "verbose_log_link": {"readonly": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "error_log_link": {"key": "errorLogLink", "type": "str"},
        "verbose_log_link": {"key": "verboseLogLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: str = "DataBoxCustomerDisk"
        self.serial_number = None
        self.error_log_link = None
        self.verbose_log_link = None


class DataBoxCustomerDiskCopyProgress(CopyProgress):  # pylint: disable=too-many-instance-attributes
    """DataBox CustomerDisk Copy Progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_account_name: Name of the storage account. This will be empty for data account
     types other than storage account.
    :vartype storage_account_name: str
    :ivar transfer_type: Transfer type of data. Known values are: "ImportToAzure" and
     "ExportFromAzure".
    :vartype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
    :ivar data_account_type: Data Account Type. Known values are: "StorageAccount" and
     "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar account_id: Id of the account where the data needs to be uploaded.
    :vartype account_id: str
    :ivar bytes_processed: To indicate bytes transferred.
    :vartype bytes_processed: int
    :ivar total_bytes_to_process: Total amount of data to be processed by the job.
    :vartype total_bytes_to_process: int
    :ivar files_processed: Number of files processed.
    :vartype files_processed: int
    :ivar total_files_to_process: Total files to process.
    :vartype total_files_to_process: int
    :ivar invalid_files_processed: Number of files not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype invalid_files_processed: int
    :ivar invalid_file_bytes_uploaded: Total amount of data not adhering to azure naming
     conventions which were processed by automatic renaming.
    :vartype invalid_file_bytes_uploaded: int
    :ivar renamed_container_count: Number of folders not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype renamed_container_count: int
    :ivar files_errored_out: Number of files which could not be copied.
    :vartype files_errored_out: int
    :ivar directories_errored_out: To indicate directories errored out in the job.
    :vartype directories_errored_out: int
    :ivar invalid_directories_processed: To indicate directories renamed.
    :vartype invalid_directories_processed: int
    :ivar is_enumeration_in_progress: To indicate if enumeration of data is in progress.
     Until this is true, the TotalBytesToProcess may not be valid.
    :vartype is_enumeration_in_progress: bool
    :ivar serial_number: Disk Serial Number.
    :vartype serial_number: str
    :ivar copy_status: The Status of the copy. Known values are: "NotStarted", "InProgress",
     "Completed", "CompletedWithErrors", "Failed", "NotReturned", "HardwareError",
     "DeviceFormatted", "DeviceMetadataModified", "StorageAccountNotAccessible", "UnsupportedData",
     "DriveNotReceived", "UnsupportedDrive", "OtherServiceError", "OtherUserError",
     "DriveNotDetected", "DriveCorrupted", and "MetadataFilesModifiedOrRemoved".
    :vartype copy_status: str or ~azure.mgmt.databox.v2022_02_01.models.CopyStatus
    """

    _validation = {
        "storage_account_name": {"readonly": True},
        "transfer_type": {"readonly": True},
        "data_account_type": {"readonly": True},
        "account_id": {"readonly": True},
        "bytes_processed": {"readonly": True},
        "total_bytes_to_process": {"readonly": True},
        "files_processed": {"readonly": True},
        "total_files_to_process": {"readonly": True},
        "invalid_files_processed": {"readonly": True},
        "invalid_file_bytes_uploaded": {"readonly": True},
        "renamed_container_count": {"readonly": True},
        "files_errored_out": {"readonly": True},
        "directories_errored_out": {"readonly": True},
        "invalid_directories_processed": {"readonly": True},
        "is_enumeration_in_progress": {"readonly": True},
        "serial_number": {"readonly": True},
        "copy_status": {"readonly": True},
    }

    _attribute_map = {
        "storage_account_name": {"key": "storageAccountName", "type": "str"},
        "transfer_type": {"key": "transferType", "type": "str"},
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "bytes_processed": {"key": "bytesProcessed", "type": "int"},
        "total_bytes_to_process": {"key": "totalBytesToProcess", "type": "int"},
        "files_processed": {"key": "filesProcessed", "type": "int"},
        "total_files_to_process": {"key": "totalFilesToProcess", "type": "int"},
        "invalid_files_processed": {"key": "invalidFilesProcessed", "type": "int"},
        "invalid_file_bytes_uploaded": {"key": "invalidFileBytesUploaded", "type": "int"},
        "renamed_container_count": {"key": "renamedContainerCount", "type": "int"},
        "files_errored_out": {"key": "filesErroredOut", "type": "int"},
        "directories_errored_out": {"key": "directoriesErroredOut", "type": "int"},
        "invalid_directories_processed": {"key": "invalidDirectoriesProcessed", "type": "int"},
        "is_enumeration_in_progress": {"key": "isEnumerationInProgress", "type": "bool"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "copy_status": {"key": "copyStatus", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.serial_number = None
        self.copy_status = None


class JobDetails(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Job details.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataBoxJobDetails, DataBoxCustomerDiskJobDetails, DataBoxDiskJobDetails, DataBoxHeavyJobDetails

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.v2022_02_01.models.JobStages]
    :ivar contact_details: Contact details for notification and shipping. Required.
    :vartype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer.
    :vartype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar data_import_details: Details of the data to be imported into azure.
    :vartype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
    :ivar data_export_details: Details of the data to be exported from azure.
    :vartype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
    :ivar job_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_details_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar preferences: Preferences for the order.
    :vartype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.v2022_02_01.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar device_erasure_details: Holds device data erasure details.
    :vartype device_erasure_details: ~azure.mgmt.databox.v2022_02_01.models.DeviceErasureDetails
    :ivar key_encryption_key: Details about which key encryption type is being used.
    :vartype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :vartype expected_data_size_in_tera_bytes: int
    :ivar actions: Available actions on the job.
    :vartype actions: list[str or ~azure.mgmt.databox.v2022_02_01.models.CustomerResolutionCode]
    :ivar last_mitigation_action_on_job: Last mitigation action performed on the job.
    :vartype last_mitigation_action_on_job:
     ~azure.mgmt.databox.v2022_02_01.models.LastMitigationActionOnJob
    :ivar datacenter_address: Datacenter address to ship to, for the given sku and storage
     location.
    :vartype datacenter_address: ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressResponse
    :ivar data_center_code: DataCenter code. Known values are: "Invalid", "BY2", "BY1", "ORK70",
     "AM2", "AMS20", "BY21", "BY24", "MWH01", "AMS06", "SSE90", "SYD03", "SYD23", "CBR20", "YTO20",
     "CWL20", "LON24", "BOM01", "BL20", "BL7", "SEL20", "TYO01", "BN1", "SN5", "CYS04", "TYO22",
     "YTO21", "YQB20", "FRA22", "MAA01", "CPQ02", "CPQ20", "SIN20", "HKG20", "SG2", "MEL23",
     "SEL21", "OSA20", "SHA03", "BJB", "JNB22", "JNB21", "MNZ21", "SN8", "AUH20", "ZRH20", "PUS20",
     "AdHoc", "CH1", "DSM05", "DUB07", "PNQ01", "SVG20", "OSA02", "OSA22", "PAR22", "BN7", "SN6",
     and "BJS20".
    :vartype data_center_code: str or ~azure.mgmt.databox.v2022_02_01.models.DataCenterCode
    """

    _validation = {
        "job_stages": {"readonly": True},
        "contact_details": {"required": True},
        "delivery_package": {"readonly": True},
        "return_package": {"readonly": True},
        "job_details_type": {"required": True},
        "copy_log_details": {"readonly": True},
        "reverse_shipment_label_sas_key": {"readonly": True},
        "chain_of_custody_sas_key": {"readonly": True},
        "device_erasure_details": {"readonly": True},
        "actions": {"readonly": True},
        "last_mitigation_action_on_job": {"readonly": True},
        "datacenter_address": {"readonly": True},
        "data_center_code": {"readonly": True},
    }

    _attribute_map = {
        "job_stages": {"key": "jobStages", "type": "[JobStages]"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "delivery_package": {"key": "deliveryPackage", "type": "PackageShippingDetails"},
        "return_package": {"key": "returnPackage", "type": "PackageShippingDetails"},
        "data_import_details": {"key": "dataImportDetails", "type": "[DataImportDetails]"},
        "data_export_details": {"key": "dataExportDetails", "type": "[DataExportDetails]"},
        "job_details_type": {"key": "jobDetailsType", "type": "str"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "copy_log_details": {"key": "copyLogDetails", "type": "[CopyLogDetails]"},
        "reverse_shipment_label_sas_key": {"key": "reverseShipmentLabelSasKey", "type": "str"},
        "chain_of_custody_sas_key": {"key": "chainOfCustodySasKey", "type": "str"},
        "device_erasure_details": {"key": "deviceErasureDetails", "type": "DeviceErasureDetails"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyEncryptionKey"},
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
        "actions": {"key": "actions", "type": "[str]"},
        "last_mitigation_action_on_job": {"key": "lastMitigationActionOnJob", "type": "LastMitigationActionOnJob"},
        "datacenter_address": {"key": "datacenterAddress", "type": "DatacenterAddressResponse"},
        "data_center_code": {"key": "dataCenterCode", "type": "str"},
    }

    _subtype_map = {
        "job_details_type": {
            "DataBox": "DataBoxJobDetails",
            "DataBoxCustomerDisk": "DataBoxCustomerDiskJobDetails",
            "DataBoxDisk": "DataBoxDiskJobDetails",
            "DataBoxHeavy": "DataBoxHeavyJobDetails",
        }
    }

    def __init__(
        self,
        *,
        contact_details: "_models.ContactDetails",
        shipping_address: Optional["_models.ShippingAddress"] = None,
        data_import_details: Optional[List["_models.DataImportDetails"]] = None,
        data_export_details: Optional[List["_models.DataExportDetails"]] = None,
        preferences: Optional["_models.Preferences"] = None,
        key_encryption_key: Optional["_models.KeyEncryptionKey"] = None,
        expected_data_size_in_tera_bytes: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_details: Contact details for notification and shipping. Required.
        :paramtype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer.
        :paramtype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
        :keyword data_import_details: Details of the data to be imported into azure.
        :paramtype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
        :keyword data_export_details: Details of the data to be exported from azure.
        :paramtype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
        :keyword preferences: Preferences for the order.
        :paramtype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
        :keyword key_encryption_key: Details about which key encryption type is being used.
        :paramtype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes.
        :paramtype expected_data_size_in_tera_bytes: int
        """
        super().__init__(**kwargs)
        self.job_stages = None
        self.contact_details = contact_details
        self.shipping_address = shipping_address
        self.delivery_package = None
        self.return_package = None
        self.data_import_details = data_import_details
        self.data_export_details = data_export_details
        self.job_details_type: Optional[str] = None
        self.preferences = preferences
        self.copy_log_details = None
        self.reverse_shipment_label_sas_key = None
        self.chain_of_custody_sas_key = None
        self.device_erasure_details = None
        self.key_encryption_key = key_encryption_key
        self.expected_data_size_in_tera_bytes = expected_data_size_in_tera_bytes
        self.actions = None
        self.last_mitigation_action_on_job = None
        self.datacenter_address = None
        self.data_center_code = None


class DataBoxCustomerDiskJobDetails(JobDetails):  # pylint: disable=too-many-instance-attributes
    """Customer disk job details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.v2022_02_01.models.JobStages]
    :ivar contact_details: Contact details for notification and shipping. Required.
    :vartype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer.
    :vartype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar data_import_details: Details of the data to be imported into azure.
    :vartype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
    :ivar data_export_details: Details of the data to be exported from azure.
    :vartype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
    :ivar job_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_details_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar preferences: Preferences for the order.
    :vartype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.v2022_02_01.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar device_erasure_details: Holds device data erasure details.
    :vartype device_erasure_details: ~azure.mgmt.databox.v2022_02_01.models.DeviceErasureDetails
    :ivar key_encryption_key: Details about which key encryption type is being used.
    :vartype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :vartype expected_data_size_in_tera_bytes: int
    :ivar actions: Available actions on the job.
    :vartype actions: list[str or ~azure.mgmt.databox.v2022_02_01.models.CustomerResolutionCode]
    :ivar last_mitigation_action_on_job: Last mitigation action performed on the job.
    :vartype last_mitigation_action_on_job:
     ~azure.mgmt.databox.v2022_02_01.models.LastMitigationActionOnJob
    :ivar datacenter_address: Datacenter address to ship to, for the given sku and storage
     location.
    :vartype datacenter_address: ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressResponse
    :ivar data_center_code: DataCenter code. Known values are: "Invalid", "BY2", "BY1", "ORK70",
     "AM2", "AMS20", "BY21", "BY24", "MWH01", "AMS06", "SSE90", "SYD03", "SYD23", "CBR20", "YTO20",
     "CWL20", "LON24", "BOM01", "BL20", "BL7", "SEL20", "TYO01", "BN1", "SN5", "CYS04", "TYO22",
     "YTO21", "YQB20", "FRA22", "MAA01", "CPQ02", "CPQ20", "SIN20", "HKG20", "SG2", "MEL23",
     "SEL21", "OSA20", "SHA03", "BJB", "JNB22", "JNB21", "MNZ21", "SN8", "AUH20", "ZRH20", "PUS20",
     "AdHoc", "CH1", "DSM05", "DUB07", "PNQ01", "SVG20", "OSA02", "OSA22", "PAR22", "BN7", "SN6",
     and "BJS20".
    :vartype data_center_code: str or ~azure.mgmt.databox.v2022_02_01.models.DataCenterCode
    :ivar import_disk_details_collection: Contains the map of disk serial number to the disk
     details for import jobs.
    :vartype import_disk_details_collection: dict[str,
     ~azure.mgmt.databox.v2022_02_01.models.ImportDiskDetails]
    :ivar export_disk_details_collection: Contains the map of disk serial number to the disk
     details for export jobs.
    :vartype export_disk_details_collection: dict[str,
     ~azure.mgmt.databox.v2022_02_01.models.ExportDiskDetails]
    :ivar copy_progress: Copy progress per disk.
    :vartype copy_progress:
     list[~azure.mgmt.databox.v2022_02_01.models.DataBoxCustomerDiskCopyProgress]
    :ivar deliver_to_dc_package_details: Delivery package shipping details.
    :vartype deliver_to_dc_package_details:
     ~azure.mgmt.databox.v2022_02_01.models.PackageCarrierInfo
    :ivar return_to_customer_package_details: Return package shipping details. Required.
    :vartype return_to_customer_package_details:
     ~azure.mgmt.databox.v2022_02_01.models.PackageCarrierDetails
    :ivar enable_manifest_backup: Flag to indicate if disk manifest should be backed-up in the
     Storage Account.
    :vartype enable_manifest_backup: bool
    """

    _validation = {
        "job_stages": {"readonly": True},
        "contact_details": {"required": True},
        "delivery_package": {"readonly": True},
        "return_package": {"readonly": True},
        "job_details_type": {"required": True},
        "copy_log_details": {"readonly": True},
        "reverse_shipment_label_sas_key": {"readonly": True},
        "chain_of_custody_sas_key": {"readonly": True},
        "device_erasure_details": {"readonly": True},
        "actions": {"readonly": True},
        "last_mitigation_action_on_job": {"readonly": True},
        "datacenter_address": {"readonly": True},
        "data_center_code": {"readonly": True},
        "export_disk_details_collection": {"readonly": True},
        "copy_progress": {"readonly": True},
        "deliver_to_dc_package_details": {"readonly": True},
        "return_to_customer_package_details": {"required": True},
    }

    _attribute_map = {
        "job_stages": {"key": "jobStages", "type": "[JobStages]"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "delivery_package": {"key": "deliveryPackage", "type": "PackageShippingDetails"},
        "return_package": {"key": "returnPackage", "type": "PackageShippingDetails"},
        "data_import_details": {"key": "dataImportDetails", "type": "[DataImportDetails]"},
        "data_export_details": {"key": "dataExportDetails", "type": "[DataExportDetails]"},
        "job_details_type": {"key": "jobDetailsType", "type": "str"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "copy_log_details": {"key": "copyLogDetails", "type": "[CopyLogDetails]"},
        "reverse_shipment_label_sas_key": {"key": "reverseShipmentLabelSasKey", "type": "str"},
        "chain_of_custody_sas_key": {"key": "chainOfCustodySasKey", "type": "str"},
        "device_erasure_details": {"key": "deviceErasureDetails", "type": "DeviceErasureDetails"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyEncryptionKey"},
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
        "actions": {"key": "actions", "type": "[str]"},
        "last_mitigation_action_on_job": {"key": "lastMitigationActionOnJob", "type": "LastMitigationActionOnJob"},
        "datacenter_address": {"key": "datacenterAddress", "type": "DatacenterAddressResponse"},
        "data_center_code": {"key": "dataCenterCode", "type": "str"},
        "import_disk_details_collection": {"key": "importDiskDetailsCollection", "type": "{ImportDiskDetails}"},
        "export_disk_details_collection": {"key": "exportDiskDetailsCollection", "type": "{ExportDiskDetails}"},
        "copy_progress": {"key": "copyProgress", "type": "[DataBoxCustomerDiskCopyProgress]"},
        "deliver_to_dc_package_details": {"key": "deliverToDcPackageDetails", "type": "PackageCarrierInfo"},
        "return_to_customer_package_details": {
            "key": "returnToCustomerPackageDetails",
            "type": "PackageCarrierDetails",
        },
        "enable_manifest_backup": {"key": "enableManifestBackup", "type": "bool"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        contact_details: "_models.ContactDetails",
        return_to_customer_package_details: "_models.PackageCarrierDetails",
        shipping_address: Optional["_models.ShippingAddress"] = None,
        data_import_details: Optional[List["_models.DataImportDetails"]] = None,
        data_export_details: Optional[List["_models.DataExportDetails"]] = None,
        preferences: Optional["_models.Preferences"] = None,
        key_encryption_key: Optional["_models.KeyEncryptionKey"] = None,
        expected_data_size_in_tera_bytes: Optional[int] = None,
        import_disk_details_collection: Optional[Dict[str, "_models.ImportDiskDetails"]] = None,
        enable_manifest_backup: bool = False,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_details: Contact details for notification and shipping. Required.
        :paramtype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer.
        :paramtype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
        :keyword data_import_details: Details of the data to be imported into azure.
        :paramtype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
        :keyword data_export_details: Details of the data to be exported from azure.
        :paramtype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
        :keyword preferences: Preferences for the order.
        :paramtype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
        :keyword key_encryption_key: Details about which key encryption type is being used.
        :paramtype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes.
        :paramtype expected_data_size_in_tera_bytes: int
        :keyword import_disk_details_collection: Contains the map of disk serial number to the disk
         details for import jobs.
        :paramtype import_disk_details_collection: dict[str,
         ~azure.mgmt.databox.v2022_02_01.models.ImportDiskDetails]
        :keyword return_to_customer_package_details: Return package shipping details. Required.
        :paramtype return_to_customer_package_details:
         ~azure.mgmt.databox.v2022_02_01.models.PackageCarrierDetails
        :keyword enable_manifest_backup: Flag to indicate if disk manifest should be backed-up in the
         Storage Account.
        :paramtype enable_manifest_backup: bool
        """
        super().__init__(
            contact_details=contact_details,
            shipping_address=shipping_address,
            data_import_details=data_import_details,
            data_export_details=data_export_details,
            preferences=preferences,
            key_encryption_key=key_encryption_key,
            expected_data_size_in_tera_bytes=expected_data_size_in_tera_bytes,
            **kwargs
        )
        self.job_details_type: str = "DataBoxCustomerDisk"
        self.import_disk_details_collection = import_disk_details_collection
        self.export_disk_details_collection = None
        self.copy_progress = None
        self.deliver_to_dc_package_details = None
        self.return_to_customer_package_details = return_to_customer_package_details
        self.enable_manifest_backup = enable_manifest_backup


class DataBoxDiskCopyLogDetails(CopyLogDetails):
    """Copy Log Details for a disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar disk_serial_number: Disk Serial Number.
    :vartype disk_serial_number: str
    :ivar error_log_link: Link for copy error logs.
    :vartype error_log_link: str
    :ivar verbose_log_link: Link for copy verbose logs.
    :vartype verbose_log_link: str
    """

    _validation = {
        "copy_log_details_type": {"required": True},
        "disk_serial_number": {"readonly": True},
        "error_log_link": {"readonly": True},
        "verbose_log_link": {"readonly": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
        "disk_serial_number": {"key": "diskSerialNumber", "type": "str"},
        "error_log_link": {"key": "errorLogLink", "type": "str"},
        "verbose_log_link": {"key": "verboseLogLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: str = "DataBoxDisk"
        self.disk_serial_number = None
        self.error_log_link = None
        self.verbose_log_link = None


class DataBoxDiskCopyProgress(_serialization.Model):
    """DataBox Disk Copy Progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar serial_number: The serial number of the disk.
    :vartype serial_number: str
    :ivar bytes_copied: Bytes copied during the copy of disk.
    :vartype bytes_copied: int
    :ivar percent_complete: Indicates the percentage completed for the copy of the disk.
    :vartype percent_complete: int
    :ivar status: The Status of the copy. Known values are: "NotStarted", "InProgress",
     "Completed", "CompletedWithErrors", "Failed", "NotReturned", "HardwareError",
     "DeviceFormatted", "DeviceMetadataModified", "StorageAccountNotAccessible", "UnsupportedData",
     "DriveNotReceived", "UnsupportedDrive", "OtherServiceError", "OtherUserError",
     "DriveNotDetected", "DriveCorrupted", and "MetadataFilesModifiedOrRemoved".
    :vartype status: str or ~azure.mgmt.databox.v2022_02_01.models.CopyStatus
    """

    _validation = {
        "serial_number": {"readonly": True},
        "bytes_copied": {"readonly": True},
        "percent_complete": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "serial_number": {"key": "serialNumber", "type": "str"},
        "bytes_copied": {"key": "bytesCopied", "type": "int"},
        "percent_complete": {"key": "percentComplete", "type": "int"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.serial_number = None
        self.bytes_copied = None
        self.percent_complete = None
        self.status = None


class GranularCopyLogDetails(_serialization.Model):
    """Granular Details for log generated during copy.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataBoxDiskGranularCopyLogDetails

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    """

    _validation = {
        "copy_log_details_type": {"required": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
    }

    _subtype_map = {"copy_log_details_type": {"DataBoxCustomerDisk": "DataBoxDiskGranularCopyLogDetails"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: Optional[str] = None


class DataBoxDiskGranularCopyLogDetails(GranularCopyLogDetails):
    """Granular Copy Log Details for customer disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar serial_number: Disk Serial Number.
    :vartype serial_number: str
    :ivar account_id: Account id.
    :vartype account_id: str
    :ivar error_log_link: Link for copy error logs.
    :vartype error_log_link: str
    :ivar verbose_log_link: Link for copy verbose logs.
    :vartype verbose_log_link: str
    """

    _validation = {
        "copy_log_details_type": {"required": True},
        "serial_number": {"readonly": True},
        "account_id": {"readonly": True},
        "error_log_link": {"readonly": True},
        "verbose_log_link": {"readonly": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "error_log_link": {"key": "errorLogLink", "type": "str"},
        "verbose_log_link": {"key": "verboseLogLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: str = "DataBoxCustomerDisk"
        self.serial_number = None
        self.account_id = None
        self.error_log_link = None
        self.verbose_log_link = None


class GranularCopyProgress(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Granular Copy progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_account_name: Name of the storage account. This will be empty for data account
     types other than storage account.
    :vartype storage_account_name: str
    :ivar transfer_type: Transfer type of data. Known values are: "ImportToAzure" and
     "ExportFromAzure".
    :vartype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
    :ivar data_account_type: Data Account Type. Known values are: "StorageAccount" and
     "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar account_id: Id of the account where the data needs to be uploaded.
    :vartype account_id: str
    :ivar bytes_processed: To indicate bytes transferred.
    :vartype bytes_processed: int
    :ivar total_bytes_to_process: Total amount of data to be processed by the job.
    :vartype total_bytes_to_process: int
    :ivar files_processed: Number of files processed.
    :vartype files_processed: int
    :ivar total_files_to_process: Total files to process.
    :vartype total_files_to_process: int
    :ivar invalid_files_processed: Number of files not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype invalid_files_processed: int
    :ivar invalid_file_bytes_uploaded: Total amount of data not adhering to azure naming
     conventions which were processed by automatic renaming.
    :vartype invalid_file_bytes_uploaded: int
    :ivar renamed_container_count: Number of folders not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype renamed_container_count: int
    :ivar files_errored_out: Number of files which could not be copied.
    :vartype files_errored_out: int
    :ivar directories_errored_out: To indicate directories errored out in the job.
    :vartype directories_errored_out: int
    :ivar invalid_directories_processed: To indicate directories renamed.
    :vartype invalid_directories_processed: int
    :ivar is_enumeration_in_progress: To indicate if enumeration of data is in progress.
     Until this is true, the TotalBytesToProcess may not be valid.
    :vartype is_enumeration_in_progress: bool
    """

    _validation = {
        "storage_account_name": {"readonly": True},
        "transfer_type": {"readonly": True},
        "data_account_type": {"readonly": True},
        "account_id": {"readonly": True},
        "bytes_processed": {"readonly": True},
        "total_bytes_to_process": {"readonly": True},
        "files_processed": {"readonly": True},
        "total_files_to_process": {"readonly": True},
        "invalid_files_processed": {"readonly": True},
        "invalid_file_bytes_uploaded": {"readonly": True},
        "renamed_container_count": {"readonly": True},
        "files_errored_out": {"readonly": True},
        "directories_errored_out": {"readonly": True},
        "invalid_directories_processed": {"readonly": True},
        "is_enumeration_in_progress": {"readonly": True},
    }

    _attribute_map = {
        "storage_account_name": {"key": "storageAccountName", "type": "str"},
        "transfer_type": {"key": "transferType", "type": "str"},
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "bytes_processed": {"key": "bytesProcessed", "type": "int"},
        "total_bytes_to_process": {"key": "totalBytesToProcess", "type": "int"},
        "files_processed": {"key": "filesProcessed", "type": "int"},
        "total_files_to_process": {"key": "totalFilesToProcess", "type": "int"},
        "invalid_files_processed": {"key": "invalidFilesProcessed", "type": "int"},
        "invalid_file_bytes_uploaded": {"key": "invalidFileBytesUploaded", "type": "int"},
        "renamed_container_count": {"key": "renamedContainerCount", "type": "int"},
        "files_errored_out": {"key": "filesErroredOut", "type": "int"},
        "directories_errored_out": {"key": "directoriesErroredOut", "type": "int"},
        "invalid_directories_processed": {"key": "invalidDirectoriesProcessed", "type": "int"},
        "is_enumeration_in_progress": {"key": "isEnumerationInProgress", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.storage_account_name = None
        self.transfer_type = None
        self.data_account_type = None
        self.account_id = None
        self.bytes_processed = None
        self.total_bytes_to_process = None
        self.files_processed = None
        self.total_files_to_process = None
        self.invalid_files_processed = None
        self.invalid_file_bytes_uploaded = None
        self.renamed_container_count = None
        self.files_errored_out = None
        self.directories_errored_out = None
        self.invalid_directories_processed = None
        self.is_enumeration_in_progress = None


class DataBoxDiskGranularCopyProgress(GranularCopyProgress):  # pylint: disable=too-many-instance-attributes
    """DataBox Disk Granular Copy Progress.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar storage_account_name: Name of the storage account. This will be empty for data account
     types other than storage account.
    :vartype storage_account_name: str
    :ivar transfer_type: Transfer type of data. Known values are: "ImportToAzure" and
     "ExportFromAzure".
    :vartype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
    :ivar data_account_type: Data Account Type. Known values are: "StorageAccount" and
     "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar account_id: Id of the account where the data needs to be uploaded.
    :vartype account_id: str
    :ivar bytes_processed: To indicate bytes transferred.
    :vartype bytes_processed: int
    :ivar total_bytes_to_process: Total amount of data to be processed by the job.
    :vartype total_bytes_to_process: int
    :ivar files_processed: Number of files processed.
    :vartype files_processed: int
    :ivar total_files_to_process: Total files to process.
    :vartype total_files_to_process: int
    :ivar invalid_files_processed: Number of files not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype invalid_files_processed: int
    :ivar invalid_file_bytes_uploaded: Total amount of data not adhering to azure naming
     conventions which were processed by automatic renaming.
    :vartype invalid_file_bytes_uploaded: int
    :ivar renamed_container_count: Number of folders not adhering to azure naming conventions which
     were processed by automatic renaming.
    :vartype renamed_container_count: int
    :ivar files_errored_out: Number of files which could not be copied.
    :vartype files_errored_out: int
    :ivar directories_errored_out: To indicate directories errored out in the job.
    :vartype directories_errored_out: int
    :ivar invalid_directories_processed: To indicate directories renamed.
    :vartype invalid_directories_processed: int
    :ivar is_enumeration_in_progress: To indicate if enumeration of data is in progress.
     Until this is true, the TotalBytesToProcess may not be valid.
    :vartype is_enumeration_in_progress: bool
    :ivar serial_number: Disk Serial Number.
    :vartype serial_number: str
    :ivar copy_status: The Status of the copy. Known values are: "NotStarted", "InProgress",
     "Completed", "CompletedWithErrors", "Failed", "NotReturned", "HardwareError",
     "DeviceFormatted", "DeviceMetadataModified", "StorageAccountNotAccessible", "UnsupportedData",
     "DriveNotReceived", "UnsupportedDrive", "OtherServiceError", "OtherUserError",
     "DriveNotDetected", "DriveCorrupted", and "MetadataFilesModifiedOrRemoved".
    :vartype copy_status: str or ~azure.mgmt.databox.v2022_02_01.models.CopyStatus
    """

    _validation = {
        "storage_account_name": {"readonly": True},
        "transfer_type": {"readonly": True},
        "data_account_type": {"readonly": True},
        "account_id": {"readonly": True},
        "bytes_processed": {"readonly": True},
        "total_bytes_to_process": {"readonly": True},
        "files_processed": {"readonly": True},
        "total_files_to_process": {"readonly": True},
        "invalid_files_processed": {"readonly": True},
        "invalid_file_bytes_uploaded": {"readonly": True},
        "renamed_container_count": {"readonly": True},
        "files_errored_out": {"readonly": True},
        "directories_errored_out": {"readonly": True},
        "invalid_directories_processed": {"readonly": True},
        "is_enumeration_in_progress": {"readonly": True},
        "serial_number": {"readonly": True},
        "copy_status": {"readonly": True},
    }

    _attribute_map = {
        "storage_account_name": {"key": "storageAccountName", "type": "str"},
        "transfer_type": {"key": "transferType", "type": "str"},
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "account_id": {"key": "accountId", "type": "str"},
        "bytes_processed": {"key": "bytesProcessed", "type": "int"},
        "total_bytes_to_process": {"key": "totalBytesToProcess", "type": "int"},
        "files_processed": {"key": "filesProcessed", "type": "int"},
        "total_files_to_process": {"key": "totalFilesToProcess", "type": "int"},
        "invalid_files_processed": {"key": "invalidFilesProcessed", "type": "int"},
        "invalid_file_bytes_uploaded": {"key": "invalidFileBytesUploaded", "type": "int"},
        "renamed_container_count": {"key": "renamedContainerCount", "type": "int"},
        "files_errored_out": {"key": "filesErroredOut", "type": "int"},
        "directories_errored_out": {"key": "directoriesErroredOut", "type": "int"},
        "invalid_directories_processed": {"key": "invalidDirectoriesProcessed", "type": "int"},
        "is_enumeration_in_progress": {"key": "isEnumerationInProgress", "type": "bool"},
        "serial_number": {"key": "serialNumber", "type": "str"},
        "copy_status": {"key": "copyStatus", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.serial_number = None
        self.copy_status = None


class DataBoxDiskJobDetails(JobDetails):  # pylint: disable=too-many-instance-attributes
    """DataBox Disk Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.v2022_02_01.models.JobStages]
    :ivar contact_details: Contact details for notification and shipping. Required.
    :vartype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer.
    :vartype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar data_import_details: Details of the data to be imported into azure.
    :vartype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
    :ivar data_export_details: Details of the data to be exported from azure.
    :vartype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
    :ivar job_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_details_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar preferences: Preferences for the order.
    :vartype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.v2022_02_01.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar device_erasure_details: Holds device data erasure details.
    :vartype device_erasure_details: ~azure.mgmt.databox.v2022_02_01.models.DeviceErasureDetails
    :ivar key_encryption_key: Details about which key encryption type is being used.
    :vartype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :vartype expected_data_size_in_tera_bytes: int
    :ivar actions: Available actions on the job.
    :vartype actions: list[str or ~azure.mgmt.databox.v2022_02_01.models.CustomerResolutionCode]
    :ivar last_mitigation_action_on_job: Last mitigation action performed on the job.
    :vartype last_mitigation_action_on_job:
     ~azure.mgmt.databox.v2022_02_01.models.LastMitigationActionOnJob
    :ivar datacenter_address: Datacenter address to ship to, for the given sku and storage
     location.
    :vartype datacenter_address: ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressResponse
    :ivar data_center_code: DataCenter code. Known values are: "Invalid", "BY2", "BY1", "ORK70",
     "AM2", "AMS20", "BY21", "BY24", "MWH01", "AMS06", "SSE90", "SYD03", "SYD23", "CBR20", "YTO20",
     "CWL20", "LON24", "BOM01", "BL20", "BL7", "SEL20", "TYO01", "BN1", "SN5", "CYS04", "TYO22",
     "YTO21", "YQB20", "FRA22", "MAA01", "CPQ02", "CPQ20", "SIN20", "HKG20", "SG2", "MEL23",
     "SEL21", "OSA20", "SHA03", "BJB", "JNB22", "JNB21", "MNZ21", "SN8", "AUH20", "ZRH20", "PUS20",
     "AdHoc", "CH1", "DSM05", "DUB07", "PNQ01", "SVG20", "OSA02", "OSA22", "PAR22", "BN7", "SN6",
     and "BJS20".
    :vartype data_center_code: str or ~azure.mgmt.databox.v2022_02_01.models.DataCenterCode
    :ivar preferred_disks: User preference on what size disks are needed for the job. The map is
     from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but
     will be checked against an int.
    :vartype preferred_disks: dict[str, int]
    :ivar copy_progress: Copy progress per disk.
    :vartype copy_progress: list[~azure.mgmt.databox.v2022_02_01.models.DataBoxDiskCopyProgress]
    :ivar granular_copy_progress: Copy progress per disk.
    :vartype granular_copy_progress:
     list[~azure.mgmt.databox.v2022_02_01.models.DataBoxDiskGranularCopyProgress]
    :ivar granular_copy_log_details: Copy progress per disk.
    :vartype granular_copy_log_details:
     list[~azure.mgmt.databox.v2022_02_01.models.DataBoxDiskGranularCopyLogDetails]
    :ivar disks_and_size_details: Contains the map of disk serial number to the disk size being
     used for the job. Is returned only after the disks are shipped to the customer.
    :vartype disks_and_size_details: dict[str, int]
    :ivar passkey: User entered passkey for DataBox Disk job.
    :vartype passkey: str
    """

    _validation = {
        "job_stages": {"readonly": True},
        "contact_details": {"required": True},
        "delivery_package": {"readonly": True},
        "return_package": {"readonly": True},
        "job_details_type": {"required": True},
        "copy_log_details": {"readonly": True},
        "reverse_shipment_label_sas_key": {"readonly": True},
        "chain_of_custody_sas_key": {"readonly": True},
        "device_erasure_details": {"readonly": True},
        "actions": {"readonly": True},
        "last_mitigation_action_on_job": {"readonly": True},
        "datacenter_address": {"readonly": True},
        "data_center_code": {"readonly": True},
        "copy_progress": {"readonly": True},
        "granular_copy_progress": {"readonly": True},
        "granular_copy_log_details": {"readonly": True},
        "disks_and_size_details": {"readonly": True},
    }

    _attribute_map = {
        "job_stages": {"key": "jobStages", "type": "[JobStages]"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "delivery_package": {"key": "deliveryPackage", "type": "PackageShippingDetails"},
        "return_package": {"key": "returnPackage", "type": "PackageShippingDetails"},
        "data_import_details": {"key": "dataImportDetails", "type": "[DataImportDetails]"},
        "data_export_details": {"key": "dataExportDetails", "type": "[DataExportDetails]"},
        "job_details_type": {"key": "jobDetailsType", "type": "str"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "copy_log_details": {"key": "copyLogDetails", "type": "[CopyLogDetails]"},
        "reverse_shipment_label_sas_key": {"key": "reverseShipmentLabelSasKey", "type": "str"},
        "chain_of_custody_sas_key": {"key": "chainOfCustodySasKey", "type": "str"},
        "device_erasure_details": {"key": "deviceErasureDetails", "type": "DeviceErasureDetails"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyEncryptionKey"},
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
        "actions": {"key": "actions", "type": "[str]"},
        "last_mitigation_action_on_job": {"key": "lastMitigationActionOnJob", "type": "LastMitigationActionOnJob"},
        "datacenter_address": {"key": "datacenterAddress", "type": "DatacenterAddressResponse"},
        "data_center_code": {"key": "dataCenterCode", "type": "str"},
        "preferred_disks": {"key": "preferredDisks", "type": "{int}"},
        "copy_progress": {"key": "copyProgress", "type": "[DataBoxDiskCopyProgress]"},
        "granular_copy_progress": {"key": "granularCopyProgress", "type": "[DataBoxDiskGranularCopyProgress]"},
        "granular_copy_log_details": {"key": "granularCopyLogDetails", "type": "[DataBoxDiskGranularCopyLogDetails]"},
        "disks_and_size_details": {"key": "disksAndSizeDetails", "type": "{int}"},
        "passkey": {"key": "passkey", "type": "str"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        contact_details: "_models.ContactDetails",
        shipping_address: Optional["_models.ShippingAddress"] = None,
        data_import_details: Optional[List["_models.DataImportDetails"]] = None,
        data_export_details: Optional[List["_models.DataExportDetails"]] = None,
        preferences: Optional["_models.Preferences"] = None,
        key_encryption_key: Optional["_models.KeyEncryptionKey"] = None,
        expected_data_size_in_tera_bytes: Optional[int] = None,
        preferred_disks: Optional[Dict[str, int]] = None,
        passkey: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_details: Contact details for notification and shipping. Required.
        :paramtype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer.
        :paramtype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
        :keyword data_import_details: Details of the data to be imported into azure.
        :paramtype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
        :keyword data_export_details: Details of the data to be exported from azure.
        :paramtype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
        :keyword preferences: Preferences for the order.
        :paramtype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
        :keyword key_encryption_key: Details about which key encryption type is being used.
        :paramtype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes.
        :paramtype expected_data_size_in_tera_bytes: int
        :keyword preferred_disks: User preference on what size disks are needed for the job. The map is
         from the disk size in TB to the count. Eg. {2,5} means 5 disks of 2 TB size. Key is string but
         will be checked against an int.
        :paramtype preferred_disks: dict[str, int]
        :keyword passkey: User entered passkey for DataBox Disk job.
        :paramtype passkey: str
        """
        super().__init__(
            contact_details=contact_details,
            shipping_address=shipping_address,
            data_import_details=data_import_details,
            data_export_details=data_export_details,
            preferences=preferences,
            key_encryption_key=key_encryption_key,
            expected_data_size_in_tera_bytes=expected_data_size_in_tera_bytes,
            **kwargs
        )
        self.job_details_type: str = "DataBoxDisk"
        self.preferred_disks = preferred_disks
        self.copy_progress = None
        self.granular_copy_progress = None
        self.granular_copy_log_details = None
        self.disks_and_size_details = None
        self.passkey = passkey


class DataBoxDiskJobSecrets(JobSecrets):
    """The secrets related to disk job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_secrets_type: Used to indicate what type of job secrets object. Required. Known
     values are: "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_secrets_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.v2022_02_01.models.DcAccessSecurityCode
    :ivar error: Error while fetching the secrets.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar disk_secrets: Contains the list of secrets object for that device.
    :vartype disk_secrets: list[~azure.mgmt.databox.v2022_02_01.models.DiskSecret]
    :ivar pass_key: PassKey for the disk Job.
    :vartype pass_key: str
    :ivar is_passkey_user_defined: Whether passkey was provided by user.
    :vartype is_passkey_user_defined: bool
    """

    _validation = {
        "job_secrets_type": {"required": True},
        "dc_access_security_code": {"readonly": True},
        "error": {"readonly": True},
        "disk_secrets": {"readonly": True},
        "pass_key": {"readonly": True},
        "is_passkey_user_defined": {"readonly": True},
    }

    _attribute_map = {
        "job_secrets_type": {"key": "jobSecretsType", "type": "str"},
        "dc_access_security_code": {"key": "dcAccessSecurityCode", "type": "DcAccessSecurityCode"},
        "error": {"key": "error", "type": "CloudError"},
        "disk_secrets": {"key": "diskSecrets", "type": "[DiskSecret]"},
        "pass_key": {"key": "passKey", "type": "str"},
        "is_passkey_user_defined": {"key": "isPasskeyUserDefined", "type": "bool"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.job_secrets_type: str = "DataBoxDisk"
        self.disk_secrets = None
        self.pass_key = None
        self.is_passkey_user_defined = None


class DataBoxHeavyAccountCopyLogDetails(CopyLogDetails):
    """Copy log details for a storage account for Databox heavy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar copy_log_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype copy_log_details_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar account_name: Account name.
    :vartype account_name: str
    :ivar copy_log_link: Link for copy logs.
    :vartype copy_log_link: list[str]
    :ivar copy_verbose_log_link: Link for copy verbose logs. This will be set only when the
     LogCollectionLevel is set to verbose.
    :vartype copy_verbose_log_link: list[str]
    """

    _validation = {
        "copy_log_details_type": {"required": True},
        "account_name": {"readonly": True},
        "copy_log_link": {"readonly": True},
        "copy_verbose_log_link": {"readonly": True},
    }

    _attribute_map = {
        "copy_log_details_type": {"key": "copyLogDetailsType", "type": "str"},
        "account_name": {"key": "accountName", "type": "str"},
        "copy_log_link": {"key": "copyLogLink", "type": "[str]"},
        "copy_verbose_log_link": {"key": "copyVerboseLogLink", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.copy_log_details_type: str = "DataBoxHeavy"
        self.account_name = None
        self.copy_log_link = None
        self.copy_verbose_log_link = None


class DataBoxHeavyJobDetails(JobDetails):  # pylint: disable=too-many-instance-attributes
    """Databox Heavy Device Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.v2022_02_01.models.JobStages]
    :ivar contact_details: Contact details for notification and shipping. Required.
    :vartype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer.
    :vartype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar data_import_details: Details of the data to be imported into azure.
    :vartype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
    :ivar data_export_details: Details of the data to be exported from azure.
    :vartype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
    :ivar job_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_details_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar preferences: Preferences for the order.
    :vartype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.v2022_02_01.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar device_erasure_details: Holds device data erasure details.
    :vartype device_erasure_details: ~azure.mgmt.databox.v2022_02_01.models.DeviceErasureDetails
    :ivar key_encryption_key: Details about which key encryption type is being used.
    :vartype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :vartype expected_data_size_in_tera_bytes: int
    :ivar actions: Available actions on the job.
    :vartype actions: list[str or ~azure.mgmt.databox.v2022_02_01.models.CustomerResolutionCode]
    :ivar last_mitigation_action_on_job: Last mitigation action performed on the job.
    :vartype last_mitigation_action_on_job:
     ~azure.mgmt.databox.v2022_02_01.models.LastMitigationActionOnJob
    :ivar datacenter_address: Datacenter address to ship to, for the given sku and storage
     location.
    :vartype datacenter_address: ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressResponse
    :ivar data_center_code: DataCenter code. Known values are: "Invalid", "BY2", "BY1", "ORK70",
     "AM2", "AMS20", "BY21", "BY24", "MWH01", "AMS06", "SSE90", "SYD03", "SYD23", "CBR20", "YTO20",
     "CWL20", "LON24", "BOM01", "BL20", "BL7", "SEL20", "TYO01", "BN1", "SN5", "CYS04", "TYO22",
     "YTO21", "YQB20", "FRA22", "MAA01", "CPQ02", "CPQ20", "SIN20", "HKG20", "SG2", "MEL23",
     "SEL21", "OSA20", "SHA03", "BJB", "JNB22", "JNB21", "MNZ21", "SN8", "AUH20", "ZRH20", "PUS20",
     "AdHoc", "CH1", "DSM05", "DUB07", "PNQ01", "SVG20", "OSA02", "OSA22", "PAR22", "BN7", "SN6",
     and "BJS20".
    :vartype data_center_code: str or ~azure.mgmt.databox.v2022_02_01.models.DataCenterCode
    :ivar copy_progress: Copy progress per account.
    :vartype copy_progress: list[~azure.mgmt.databox.v2022_02_01.models.CopyProgress]
    :ivar device_password: Set Device password for unlocking Databox Heavy. Should not be passed
     for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
     password itself. This will not be returned in Get Call. Password Requirements :  Password must
     be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
     alphabet, one number and one special character. Password cannot have the following characters :
     IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :vartype device_password: str
    """

    _validation = {
        "job_stages": {"readonly": True},
        "contact_details": {"required": True},
        "delivery_package": {"readonly": True},
        "return_package": {"readonly": True},
        "job_details_type": {"required": True},
        "copy_log_details": {"readonly": True},
        "reverse_shipment_label_sas_key": {"readonly": True},
        "chain_of_custody_sas_key": {"readonly": True},
        "device_erasure_details": {"readonly": True},
        "actions": {"readonly": True},
        "last_mitigation_action_on_job": {"readonly": True},
        "datacenter_address": {"readonly": True},
        "data_center_code": {"readonly": True},
        "copy_progress": {"readonly": True},
    }

    _attribute_map = {
        "job_stages": {"key": "jobStages", "type": "[JobStages]"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "delivery_package": {"key": "deliveryPackage", "type": "PackageShippingDetails"},
        "return_package": {"key": "returnPackage", "type": "PackageShippingDetails"},
        "data_import_details": {"key": "dataImportDetails", "type": "[DataImportDetails]"},
        "data_export_details": {"key": "dataExportDetails", "type": "[DataExportDetails]"},
        "job_details_type": {"key": "jobDetailsType", "type": "str"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "copy_log_details": {"key": "copyLogDetails", "type": "[CopyLogDetails]"},
        "reverse_shipment_label_sas_key": {"key": "reverseShipmentLabelSasKey", "type": "str"},
        "chain_of_custody_sas_key": {"key": "chainOfCustodySasKey", "type": "str"},
        "device_erasure_details": {"key": "deviceErasureDetails", "type": "DeviceErasureDetails"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyEncryptionKey"},
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
        "actions": {"key": "actions", "type": "[str]"},
        "last_mitigation_action_on_job": {"key": "lastMitigationActionOnJob", "type": "LastMitigationActionOnJob"},
        "datacenter_address": {"key": "datacenterAddress", "type": "DatacenterAddressResponse"},
        "data_center_code": {"key": "dataCenterCode", "type": "str"},
        "copy_progress": {"key": "copyProgress", "type": "[CopyProgress]"},
        "device_password": {"key": "devicePassword", "type": "str"},
    }

    def __init__(
        self,
        *,
        contact_details: "_models.ContactDetails",
        shipping_address: Optional["_models.ShippingAddress"] = None,
        data_import_details: Optional[List["_models.DataImportDetails"]] = None,
        data_export_details: Optional[List["_models.DataExportDetails"]] = None,
        preferences: Optional["_models.Preferences"] = None,
        key_encryption_key: Optional["_models.KeyEncryptionKey"] = None,
        expected_data_size_in_tera_bytes: Optional[int] = None,
        device_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_details: Contact details for notification and shipping. Required.
        :paramtype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer.
        :paramtype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
        :keyword data_import_details: Details of the data to be imported into azure.
        :paramtype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
        :keyword data_export_details: Details of the data to be exported from azure.
        :paramtype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
        :keyword preferences: Preferences for the order.
        :paramtype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
        :keyword key_encryption_key: Details about which key encryption type is being used.
        :paramtype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes.
        :paramtype expected_data_size_in_tera_bytes: int
        :keyword device_password: Set Device password for unlocking Databox Heavy. Should not be passed
         for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
         password itself. This will not be returned in Get Call. Password Requirements :  Password must
         be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
         alphabet, one number and one special character. Password cannot have the following characters :
         IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
        :paramtype device_password: str
        """
        super().__init__(
            contact_details=contact_details,
            shipping_address=shipping_address,
            data_import_details=data_import_details,
            data_export_details=data_export_details,
            preferences=preferences,
            key_encryption_key=key_encryption_key,
            expected_data_size_in_tera_bytes=expected_data_size_in_tera_bytes,
            **kwargs
        )
        self.job_details_type: str = "DataBoxHeavy"
        self.copy_progress = None
        self.device_password = device_password


class DataBoxHeavyJobSecrets(JobSecrets):
    """The secrets related to a databox heavy job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_secrets_type: Used to indicate what type of job secrets object. Required. Known
     values are: "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_secrets_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.v2022_02_01.models.DcAccessSecurityCode
    :ivar error: Error while fetching the secrets.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar cabinet_pod_secrets: Contains the list of secret objects for a databox heavy job.
    :vartype cabinet_pod_secrets: list[~azure.mgmt.databox.v2022_02_01.models.DataBoxHeavySecret]
    """

    _validation = {
        "job_secrets_type": {"required": True},
        "dc_access_security_code": {"readonly": True},
        "error": {"readonly": True},
        "cabinet_pod_secrets": {"readonly": True},
    }

    _attribute_map = {
        "job_secrets_type": {"key": "jobSecretsType", "type": "str"},
        "dc_access_security_code": {"key": "dcAccessSecurityCode", "type": "DcAccessSecurityCode"},
        "error": {"key": "error", "type": "CloudError"},
        "cabinet_pod_secrets": {"key": "cabinetPodSecrets", "type": "[DataBoxHeavySecret]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.job_secrets_type: str = "DataBoxHeavy"
        self.cabinet_pod_secrets = None


class DataBoxHeavySecret(_serialization.Model):
    """The secrets related to a databox heavy.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_serial_number: Serial number of the assigned device.
    :vartype device_serial_number: str
    :ivar device_password: Password for out of the box experience on device.
    :vartype device_password: str
    :ivar network_configurations: Network configuration of the appliance.
    :vartype network_configurations:
     list[~azure.mgmt.databox.v2022_02_01.models.ApplianceNetworkConfiguration]
    :ivar encoded_validation_cert_pub_key: The base 64 encoded public key to authenticate with the
     device.
    :vartype encoded_validation_cert_pub_key: str
    :ivar account_credential_details: Per account level access credentials.
    :vartype account_credential_details:
     list[~azure.mgmt.databox.v2022_02_01.models.AccountCredentialDetails]
    """

    _validation = {
        "device_serial_number": {"readonly": True},
        "device_password": {"readonly": True},
        "network_configurations": {"readonly": True},
        "encoded_validation_cert_pub_key": {"readonly": True},
        "account_credential_details": {"readonly": True},
    }

    _attribute_map = {
        "device_serial_number": {"key": "deviceSerialNumber", "type": "str"},
        "device_password": {"key": "devicePassword", "type": "str"},
        "network_configurations": {"key": "networkConfigurations", "type": "[ApplianceNetworkConfiguration]"},
        "encoded_validation_cert_pub_key": {"key": "encodedValidationCertPubKey", "type": "str"},
        "account_credential_details": {"key": "accountCredentialDetails", "type": "[AccountCredentialDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.device_serial_number = None
        self.device_password = None
        self.network_configurations = None
        self.encoded_validation_cert_pub_key = None
        self.account_credential_details = None


class DataBoxJobDetails(JobDetails):  # pylint: disable=too-many-instance-attributes
    """Databox Job Details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_stages: List of stages that run in the job.
    :vartype job_stages: list[~azure.mgmt.databox.v2022_02_01.models.JobStages]
    :ivar contact_details: Contact details for notification and shipping. Required.
    :vartype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer.
    :vartype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
    :ivar delivery_package: Delivery package shipping details.
    :vartype delivery_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar return_package: Return package shipping details.
    :vartype return_package: ~azure.mgmt.databox.v2022_02_01.models.PackageShippingDetails
    :ivar data_import_details: Details of the data to be imported into azure.
    :vartype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
    :ivar data_export_details: Details of the data to be exported from azure.
    :vartype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
    :ivar job_details_type: Indicates the type of job details. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_details_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar preferences: Preferences for the order.
    :vartype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
    :ivar copy_log_details: List of copy log details.
    :vartype copy_log_details: list[~azure.mgmt.databox.v2022_02_01.models.CopyLogDetails]
    :ivar reverse_shipment_label_sas_key: Shared access key to download the return shipment label.
    :vartype reverse_shipment_label_sas_key: str
    :ivar chain_of_custody_sas_key: Shared access key to download the chain of custody logs.
    :vartype chain_of_custody_sas_key: str
    :ivar device_erasure_details: Holds device data erasure details.
    :vartype device_erasure_details: ~azure.mgmt.databox.v2022_02_01.models.DeviceErasureDetails
    :ivar key_encryption_key: Details about which key encryption type is being used.
    :vartype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes.
    :vartype expected_data_size_in_tera_bytes: int
    :ivar actions: Available actions on the job.
    :vartype actions: list[str or ~azure.mgmt.databox.v2022_02_01.models.CustomerResolutionCode]
    :ivar last_mitigation_action_on_job: Last mitigation action performed on the job.
    :vartype last_mitigation_action_on_job:
     ~azure.mgmt.databox.v2022_02_01.models.LastMitigationActionOnJob
    :ivar datacenter_address: Datacenter address to ship to, for the given sku and storage
     location.
    :vartype datacenter_address: ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressResponse
    :ivar data_center_code: DataCenter code. Known values are: "Invalid", "BY2", "BY1", "ORK70",
     "AM2", "AMS20", "BY21", "BY24", "MWH01", "AMS06", "SSE90", "SYD03", "SYD23", "CBR20", "YTO20",
     "CWL20", "LON24", "BOM01", "BL20", "BL7", "SEL20", "TYO01", "BN1", "SN5", "CYS04", "TYO22",
     "YTO21", "YQB20", "FRA22", "MAA01", "CPQ02", "CPQ20", "SIN20", "HKG20", "SG2", "MEL23",
     "SEL21", "OSA20", "SHA03", "BJB", "JNB22", "JNB21", "MNZ21", "SN8", "AUH20", "ZRH20", "PUS20",
     "AdHoc", "CH1", "DSM05", "DUB07", "PNQ01", "SVG20", "OSA02", "OSA22", "PAR22", "BN7", "SN6",
     and "BJS20".
    :vartype data_center_code: str or ~azure.mgmt.databox.v2022_02_01.models.DataCenterCode
    :ivar copy_progress: Copy progress per storage account.
    :vartype copy_progress: list[~azure.mgmt.databox.v2022_02_01.models.CopyProgress]
    :ivar device_password: Set Device password for unlocking Databox. Should not be passed for
     TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password
     itself. This will not be returned in Get Call. Password Requirements :  Password must be
     minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet,
     one number and one special character. Password cannot have the following characters : IilLoO0
     Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :vartype device_password: str
    """

    _validation = {
        "job_stages": {"readonly": True},
        "contact_details": {"required": True},
        "delivery_package": {"readonly": True},
        "return_package": {"readonly": True},
        "job_details_type": {"required": True},
        "copy_log_details": {"readonly": True},
        "reverse_shipment_label_sas_key": {"readonly": True},
        "chain_of_custody_sas_key": {"readonly": True},
        "device_erasure_details": {"readonly": True},
        "actions": {"readonly": True},
        "last_mitigation_action_on_job": {"readonly": True},
        "datacenter_address": {"readonly": True},
        "data_center_code": {"readonly": True},
        "copy_progress": {"readonly": True},
    }

    _attribute_map = {
        "job_stages": {"key": "jobStages", "type": "[JobStages]"},
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "delivery_package": {"key": "deliveryPackage", "type": "PackageShippingDetails"},
        "return_package": {"key": "returnPackage", "type": "PackageShippingDetails"},
        "data_import_details": {"key": "dataImportDetails", "type": "[DataImportDetails]"},
        "data_export_details": {"key": "dataExportDetails", "type": "[DataExportDetails]"},
        "job_details_type": {"key": "jobDetailsType", "type": "str"},
        "preferences": {"key": "preferences", "type": "Preferences"},
        "copy_log_details": {"key": "copyLogDetails", "type": "[CopyLogDetails]"},
        "reverse_shipment_label_sas_key": {"key": "reverseShipmentLabelSasKey", "type": "str"},
        "chain_of_custody_sas_key": {"key": "chainOfCustodySasKey", "type": "str"},
        "device_erasure_details": {"key": "deviceErasureDetails", "type": "DeviceErasureDetails"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyEncryptionKey"},
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
        "actions": {"key": "actions", "type": "[str]"},
        "last_mitigation_action_on_job": {"key": "lastMitigationActionOnJob", "type": "LastMitigationActionOnJob"},
        "datacenter_address": {"key": "datacenterAddress", "type": "DatacenterAddressResponse"},
        "data_center_code": {"key": "dataCenterCode", "type": "str"},
        "copy_progress": {"key": "copyProgress", "type": "[CopyProgress]"},
        "device_password": {"key": "devicePassword", "type": "str"},
    }

    def __init__(
        self,
        *,
        contact_details: "_models.ContactDetails",
        shipping_address: Optional["_models.ShippingAddress"] = None,
        data_import_details: Optional[List["_models.DataImportDetails"]] = None,
        data_export_details: Optional[List["_models.DataExportDetails"]] = None,
        preferences: Optional["_models.Preferences"] = None,
        key_encryption_key: Optional["_models.KeyEncryptionKey"] = None,
        expected_data_size_in_tera_bytes: Optional[int] = None,
        device_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_details: Contact details for notification and shipping. Required.
        :paramtype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer.
        :paramtype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
        :keyword data_import_details: Details of the data to be imported into azure.
        :paramtype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
        :keyword data_export_details: Details of the data to be exported from azure.
        :paramtype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
        :keyword preferences: Preferences for the order.
        :paramtype preferences: ~azure.mgmt.databox.v2022_02_01.models.Preferences
        :keyword key_encryption_key: Details about which key encryption type is being used.
        :paramtype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes.
        :paramtype expected_data_size_in_tera_bytes: int
        :keyword device_password: Set Device password for unlocking Databox. Should not be passed for
         TransferType:ExportFromAzure jobs. If this is not passed, the service will generate password
         itself. This will not be returned in Get Call. Password Requirements :  Password must be
         minimum of 12 and maximum of 64 characters. Password must have at least one uppercase alphabet,
         one number and one special character. Password cannot have the following characters : IilLoO0
         Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
        :paramtype device_password: str
        """
        super().__init__(
            contact_details=contact_details,
            shipping_address=shipping_address,
            data_import_details=data_import_details,
            data_export_details=data_export_details,
            preferences=preferences,
            key_encryption_key=key_encryption_key,
            expected_data_size_in_tera_bytes=expected_data_size_in_tera_bytes,
            **kwargs
        )
        self.job_details_type: str = "DataBox"
        self.copy_progress = None
        self.device_password = device_password


class DataboxJobSecrets(JobSecrets):
    """The secrets related to a databox job.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar job_secrets_type: Used to indicate what type of job secrets object. Required. Known
     values are: "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype job_secrets_type: str or ~azure.mgmt.databox.v2022_02_01.models.ClassDiscriminator
    :ivar dc_access_security_code: Dc Access Security Code for Customer Managed Shipping.
    :vartype dc_access_security_code: ~azure.mgmt.databox.v2022_02_01.models.DcAccessSecurityCode
    :ivar error: Error while fetching the secrets.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar pod_secrets: Contains the list of secret objects for a job.
    :vartype pod_secrets: list[~azure.mgmt.databox.v2022_02_01.models.DataBoxSecret]
    """

    _validation = {
        "job_secrets_type": {"required": True},
        "dc_access_security_code": {"readonly": True},
        "error": {"readonly": True},
    }

    _attribute_map = {
        "job_secrets_type": {"key": "jobSecretsType", "type": "str"},
        "dc_access_security_code": {"key": "dcAccessSecurityCode", "type": "DcAccessSecurityCode"},
        "error": {"key": "error", "type": "CloudError"},
        "pod_secrets": {"key": "podSecrets", "type": "[DataBoxSecret]"},
    }

    def __init__(self, *, pod_secrets: Optional[List["_models.DataBoxSecret"]] = None, **kwargs: Any) -> None:
        """
        :keyword pod_secrets: Contains the list of secret objects for a job.
        :paramtype pod_secrets: list[~azure.mgmt.databox.v2022_02_01.models.DataBoxSecret]
        """
        super().__init__(**kwargs)
        self.job_secrets_type: str = "DataBox"
        self.pod_secrets = pod_secrets


class ScheduleAvailabilityRequest(_serialization.Model):
    """Request body to get the availability for scheduling orders.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DataBoxScheduleAvailabilityRequest, DiskScheduleAvailabilityRequest,
    HeavyScheduleAvailabilityRequest

    All required parameters must be populated in order to send to Azure.

    :ivar storage_location: Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype storage_location: str
    :ivar sku_name: Sku Name for which the order is to be scheduled. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype sku_name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    :ivar country: Country in which storage location should be supported.
    :vartype country: str
    """

    _validation = {
        "storage_location": {"required": True},
        "sku_name": {"required": True},
    }

    _attribute_map = {
        "storage_location": {"key": "storageLocation", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
        "country": {"key": "country", "type": "str"},
    }

    _subtype_map = {
        "sku_name": {
            "DataBox": "DataBoxScheduleAvailabilityRequest",
            "DataBoxDisk": "DiskScheduleAvailabilityRequest",
            "DataBoxHeavy": "HeavyScheduleAvailabilityRequest",
        }
    }

    def __init__(self, *, storage_location: str, country: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword storage_location: Location for data transfer. For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype storage_location: str
        :keyword country: Country in which storage location should be supported.
        :paramtype country: str
        """
        super().__init__(**kwargs)
        self.storage_location = storage_location
        self.sku_name: Optional[str] = None
        self.country = country


class DataBoxScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling data box orders orders.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_location: Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype storage_location: str
    :ivar sku_name: Sku Name for which the order is to be scheduled. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype sku_name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    :ivar country: Country in which storage location should be supported.
    :vartype country: str
    """

    _validation = {
        "storage_location": {"required": True},
        "sku_name": {"required": True},
    }

    _attribute_map = {
        "storage_location": {"key": "storageLocation", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
        "country": {"key": "country", "type": "str"},
    }

    def __init__(self, *, storage_location: str, country: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword storage_location: Location for data transfer. For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype storage_location: str
        :keyword country: Country in which storage location should be supported.
        :paramtype country: str
        """
        super().__init__(storage_location=storage_location, country=country, **kwargs)
        self.sku_name: str = "DataBox"


class DataBoxSecret(_serialization.Model):
    """The secrets related to a DataBox.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_serial_number: Serial number of the assigned device.
    :vartype device_serial_number: str
    :ivar device_password: Password for out of the box experience on device.
    :vartype device_password: str
    :ivar network_configurations: Network configuration of the appliance.
    :vartype network_configurations:
     list[~azure.mgmt.databox.v2022_02_01.models.ApplianceNetworkConfiguration]
    :ivar encoded_validation_cert_pub_key: The base 64 encoded public key to authenticate with the
     device.
    :vartype encoded_validation_cert_pub_key: str
    :ivar account_credential_details: Per account level access credentials.
    :vartype account_credential_details:
     list[~azure.mgmt.databox.v2022_02_01.models.AccountCredentialDetails]
    """

    _validation = {
        "device_serial_number": {"readonly": True},
        "device_password": {"readonly": True},
        "network_configurations": {"readonly": True},
        "encoded_validation_cert_pub_key": {"readonly": True},
        "account_credential_details": {"readonly": True},
    }

    _attribute_map = {
        "device_serial_number": {"key": "deviceSerialNumber", "type": "str"},
        "device_password": {"key": "devicePassword", "type": "str"},
        "network_configurations": {"key": "networkConfigurations", "type": "[ApplianceNetworkConfiguration]"},
        "encoded_validation_cert_pub_key": {"key": "encodedValidationCertPubKey", "type": "str"},
        "account_credential_details": {"key": "accountCredentialDetails", "type": "[AccountCredentialDetails]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.device_serial_number = None
        self.device_password = None
        self.network_configurations = None
        self.encoded_validation_cert_pub_key = None
        self.account_credential_details = None


class DatacenterAddressResponse(_serialization.Model):
    """Datacenter address for given storage location.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    DatacenterAddressInstructionResponse, DatacenterAddressLocationResponse

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar datacenter_address_type: Data center address type. Required. Known values are:
     "DatacenterAddressLocation" and "DatacenterAddressInstruction".
    :vartype datacenter_address_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressType
    :ivar supported_carriers_for_return_shipment: List of supported carriers for return shipment.
    :vartype supported_carriers_for_return_shipment: list[str]
    :ivar data_center_azure_location: Azure Location where the Data Center serves primarily.
    :vartype data_center_azure_location: str
    """

    _validation = {
        "datacenter_address_type": {"required": True},
        "supported_carriers_for_return_shipment": {"readonly": True},
        "data_center_azure_location": {"readonly": True},
    }

    _attribute_map = {
        "datacenter_address_type": {"key": "datacenterAddressType", "type": "str"},
        "supported_carriers_for_return_shipment": {"key": "supportedCarriersForReturnShipment", "type": "[str]"},
        "data_center_azure_location": {"key": "dataCenterAzureLocation", "type": "str"},
    }

    _subtype_map = {
        "datacenter_address_type": {
            "DatacenterAddressInstruction": "DatacenterAddressInstructionResponse",
            "DatacenterAddressLocation": "DatacenterAddressLocationResponse",
        }
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.datacenter_address_type: Optional[str] = None
        self.supported_carriers_for_return_shipment = None
        self.data_center_azure_location = None


class DatacenterAddressInstructionResponse(DatacenterAddressResponse):
    """Datacenter instruction for given storage location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar datacenter_address_type: Data center address type. Required. Known values are:
     "DatacenterAddressLocation" and "DatacenterAddressInstruction".
    :vartype datacenter_address_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressType
    :ivar supported_carriers_for_return_shipment: List of supported carriers for return shipment.
    :vartype supported_carriers_for_return_shipment: list[str]
    :ivar data_center_azure_location: Azure Location where the Data Center serves primarily.
    :vartype data_center_azure_location: str
    :ivar communication_instruction: Data center communication instruction.
    :vartype communication_instruction: str
    """

    _validation = {
        "datacenter_address_type": {"required": True},
        "supported_carriers_for_return_shipment": {"readonly": True},
        "data_center_azure_location": {"readonly": True},
        "communication_instruction": {"readonly": True},
    }

    _attribute_map = {
        "datacenter_address_type": {"key": "datacenterAddressType", "type": "str"},
        "supported_carriers_for_return_shipment": {"key": "supportedCarriersForReturnShipment", "type": "[str]"},
        "data_center_azure_location": {"key": "dataCenterAzureLocation", "type": "str"},
        "communication_instruction": {"key": "communicationInstruction", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.datacenter_address_type: str = "DatacenterAddressInstruction"
        self.communication_instruction = None


class DatacenterAddressLocationResponse(DatacenterAddressResponse):  # pylint: disable=too-many-instance-attributes
    """Datacenter address for given storage location.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar datacenter_address_type: Data center address type. Required. Known values are:
     "DatacenterAddressLocation" and "DatacenterAddressInstruction".
    :vartype datacenter_address_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressType
    :ivar supported_carriers_for_return_shipment: List of supported carriers for return shipment.
    :vartype supported_carriers_for_return_shipment: list[str]
    :ivar data_center_azure_location: Azure Location where the Data Center serves primarily.
    :vartype data_center_azure_location: str
    :ivar contact_person_name: Contact person name.
    :vartype contact_person_name: str
    :ivar company: Company name.
    :vartype company: str
    :ivar street1: Street address line 1.
    :vartype street1: str
    :ivar street2: Street address line 2.
    :vartype street2: str
    :ivar street3: Street address line 3.
    :vartype street3: str
    :ivar city: City name.
    :vartype city: str
    :ivar state: name of the state.
    :vartype state: str
    :ivar zip: Zip code.
    :vartype zip: str
    :ivar country: name of the country.
    :vartype country: str
    :ivar phone: Phone number.
    :vartype phone: str
    :ivar phone_extension: Phone extension.
    :vartype phone_extension: str
    :ivar address_type: Address type.
    :vartype address_type: str
    :ivar additional_shipping_information: Special instruction for shipping.
    :vartype additional_shipping_information: str
    """

    _validation = {
        "datacenter_address_type": {"required": True},
        "supported_carriers_for_return_shipment": {"readonly": True},
        "data_center_azure_location": {"readonly": True},
        "contact_person_name": {"readonly": True},
        "company": {"readonly": True},
        "street1": {"readonly": True},
        "street2": {"readonly": True},
        "street3": {"readonly": True},
        "city": {"readonly": True},
        "state": {"readonly": True},
        "zip": {"readonly": True},
        "country": {"readonly": True},
        "phone": {"readonly": True},
        "phone_extension": {"readonly": True},
        "address_type": {"readonly": True},
        "additional_shipping_information": {"readonly": True},
    }

    _attribute_map = {
        "datacenter_address_type": {"key": "datacenterAddressType", "type": "str"},
        "supported_carriers_for_return_shipment": {"key": "supportedCarriersForReturnShipment", "type": "[str]"},
        "data_center_azure_location": {"key": "dataCenterAzureLocation", "type": "str"},
        "contact_person_name": {"key": "contactPersonName", "type": "str"},
        "company": {"key": "company", "type": "str"},
        "street1": {"key": "street1", "type": "str"},
        "street2": {"key": "street2", "type": "str"},
        "street3": {"key": "street3", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "zip": {"key": "zip", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "phone": {"key": "phone", "type": "str"},
        "phone_extension": {"key": "phoneExtension", "type": "str"},
        "address_type": {"key": "addressType", "type": "str"},
        "additional_shipping_information": {"key": "additionalShippingInformation", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.datacenter_address_type: str = "DatacenterAddressLocation"
        self.contact_person_name = None
        self.company = None
        self.street1 = None
        self.street2 = None
        self.street3 = None
        self.city = None
        self.state = None
        self.zip = None
        self.country = None
        self.phone = None
        self.phone_extension = None
        self.address_type = None
        self.additional_shipping_information = None


class DatacenterAddressRequest(_serialization.Model):
    """Request body to get the datacenter address.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_location: Storage location. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype storage_location: str
    :ivar sku_name: Sku Name for which the data center address requested. Required. Known values
     are: "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype sku_name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    """

    _validation = {
        "storage_location": {"required": True},
        "sku_name": {"required": True},
    }

    _attribute_map = {
        "storage_location": {"key": "storageLocation", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
    }

    def __init__(self, *, storage_location: str, sku_name: Union[str, "_models.SkuName"], **kwargs: Any) -> None:
        """
        :keyword storage_location: Storage location. For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype storage_location: str
        :keyword sku_name: Sku Name for which the data center address requested. Required. Known values
         are: "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
        :paramtype sku_name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.storage_location = storage_location
        self.sku_name = sku_name


class DataExportDetails(_serialization.Model):
    """Details of the data to be used for exporting data from azure.

    All required parameters must be populated in order to send to Azure.

    :ivar transfer_configuration: Configuration for the data transfer. Required.
    :vartype transfer_configuration: ~azure.mgmt.databox.v2022_02_01.models.TransferConfiguration
    :ivar log_collection_level: Level of the logs to be collected. Known values are: "Error" and
     "Verbose".
    :vartype log_collection_level: str or ~azure.mgmt.databox.v2022_02_01.models.LogCollectionLevel
    :ivar account_details: Account details of the data to be transferred. Required.
    :vartype account_details: ~azure.mgmt.databox.v2022_02_01.models.DataAccountDetails
    """

    _validation = {
        "transfer_configuration": {"required": True},
        "account_details": {"required": True},
    }

    _attribute_map = {
        "transfer_configuration": {"key": "transferConfiguration", "type": "TransferConfiguration"},
        "log_collection_level": {"key": "logCollectionLevel", "type": "str"},
        "account_details": {"key": "accountDetails", "type": "DataAccountDetails"},
    }

    def __init__(
        self,
        *,
        transfer_configuration: "_models.TransferConfiguration",
        account_details: "_models.DataAccountDetails",
        log_collection_level: Optional[Union[str, "_models.LogCollectionLevel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword transfer_configuration: Configuration for the data transfer. Required.
        :paramtype transfer_configuration: ~azure.mgmt.databox.v2022_02_01.models.TransferConfiguration
        :keyword log_collection_level: Level of the logs to be collected. Known values are: "Error" and
         "Verbose".
        :paramtype log_collection_level: str or
         ~azure.mgmt.databox.v2022_02_01.models.LogCollectionLevel
        :keyword account_details: Account details of the data to be transferred. Required.
        :paramtype account_details: ~azure.mgmt.databox.v2022_02_01.models.DataAccountDetails
        """
        super().__init__(**kwargs)
        self.transfer_configuration = transfer_configuration
        self.log_collection_level = log_collection_level
        self.account_details = account_details


class DataImportDetails(_serialization.Model):
    """Details of the data to be used for importing data to azure.

    All required parameters must be populated in order to send to Azure.

    :ivar account_details: Account details of the data to be transferred. Required.
    :vartype account_details: ~azure.mgmt.databox.v2022_02_01.models.DataAccountDetails
    :ivar log_collection_level: Level of the logs to be collected. Known values are: "Error" and
     "Verbose".
    :vartype log_collection_level: str or ~azure.mgmt.databox.v2022_02_01.models.LogCollectionLevel
    """

    _validation = {
        "account_details": {"required": True},
    }

    _attribute_map = {
        "account_details": {"key": "accountDetails", "type": "DataAccountDetails"},
        "log_collection_level": {"key": "logCollectionLevel", "type": "str"},
    }

    def __init__(
        self,
        *,
        account_details: "_models.DataAccountDetails",
        log_collection_level: Optional[Union[str, "_models.LogCollectionLevel"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword account_details: Account details of the data to be transferred. Required.
        :paramtype account_details: ~azure.mgmt.databox.v2022_02_01.models.DataAccountDetails
        :keyword log_collection_level: Level of the logs to be collected. Known values are: "Error" and
         "Verbose".
        :paramtype log_collection_level: str or
         ~azure.mgmt.databox.v2022_02_01.models.LogCollectionLevel
        """
        super().__init__(**kwargs)
        self.account_details = account_details
        self.log_collection_level = log_collection_level


class DataLocationToServiceLocationMap(_serialization.Model):
    """Map of data location to service location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar data_location: Location of the data.
    :vartype data_location: str
    :ivar service_location: Location of the service.
    :vartype service_location: str
    """

    _validation = {
        "data_location": {"readonly": True},
        "service_location": {"readonly": True},
    }

    _attribute_map = {
        "data_location": {"key": "dataLocation", "type": "str"},
        "service_location": {"key": "serviceLocation", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.data_location = None
        self.service_location = None


class DataTransferDetailsValidationRequest(ValidationInputRequest):
    """Request to validate export and import data details.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar data_export_details: List of DataTransfer details to be used to export data from azure.
    :vartype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
    :ivar data_import_details: List of DataTransfer details to be used to import data to azure.
    :vartype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
    :ivar device_type: Device type. Required. Known values are: "DataBox", "DataBoxDisk",
     "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    :ivar transfer_type: Type of the transfer. Required. Known values are: "ImportToAzure" and
     "ExportFromAzure".
    :vartype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
    """

    _validation = {
        "validation_type": {"required": True},
        "device_type": {"required": True},
        "transfer_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "data_export_details": {"key": "dataExportDetails", "type": "[DataExportDetails]"},
        "data_import_details": {"key": "dataImportDetails", "type": "[DataImportDetails]"},
        "device_type": {"key": "deviceType", "type": "str"},
        "transfer_type": {"key": "transferType", "type": "str"},
    }

    def __init__(
        self,
        *,
        device_type: Union[str, "_models.SkuName"],
        transfer_type: Union[str, "_models.TransferType"],
        data_export_details: Optional[List["_models.DataExportDetails"]] = None,
        data_import_details: Optional[List["_models.DataImportDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_export_details: List of DataTransfer details to be used to export data from
         azure.
        :paramtype data_export_details: list[~azure.mgmt.databox.v2022_02_01.models.DataExportDetails]
        :keyword data_import_details: List of DataTransfer details to be used to import data to azure.
        :paramtype data_import_details: list[~azure.mgmt.databox.v2022_02_01.models.DataImportDetails]
        :keyword device_type: Device type. Required. Known values are: "DataBox", "DataBoxDisk",
         "DataBoxHeavy", and "DataBoxCustomerDisk".
        :paramtype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
        :keyword transfer_type: Type of the transfer. Required. Known values are: "ImportToAzure" and
         "ExportFromAzure".
        :paramtype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateDataTransferDetails"
        self.data_export_details = data_export_details
        self.data_import_details = data_import_details
        self.device_type = device_type
        self.transfer_type = transfer_type


class DataTransferDetailsValidationResponseProperties(ValidationInputResponse):
    """Properties of data transfer details validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar status: Data transfer details validation status. Known values are: "Valid", "Invalid",
     and "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2022_02_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "CloudError"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateDataTransferDetails"
        self.status = None


class DcAccessSecurityCode(_serialization.Model):
    """Dc access security code.

    :ivar reverse_dc_access_code: Reverse Dc access security code.
    :vartype reverse_dc_access_code: str
    :ivar forward_dc_access_code: Forward Dc access security code.
    :vartype forward_dc_access_code: str
    """

    _attribute_map = {
        "reverse_dc_access_code": {"key": "reverseDCAccessCode", "type": "str"},
        "forward_dc_access_code": {"key": "forwardDCAccessCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        reverse_dc_access_code: Optional[str] = None,
        forward_dc_access_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword reverse_dc_access_code: Reverse Dc access security code.
        :paramtype reverse_dc_access_code: str
        :keyword forward_dc_access_code: Forward Dc access security code.
        :paramtype forward_dc_access_code: str
        """
        super().__init__(**kwargs)
        self.reverse_dc_access_code = reverse_dc_access_code
        self.forward_dc_access_code = forward_dc_access_code


class Details(_serialization.Model):
    """Details.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required.
    :vartype code: str
    :ivar message: Required.
    :vartype message: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: str, message: str, **kwargs: Any) -> None:
        """
        :keyword code: Required.
        :paramtype code: str
        :keyword message: Required.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message


class DeviceErasureDetails(_serialization.Model):
    """Device erasure details with erasure completion status and erasureordestructionlog sas key.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar device_erasure_status: Holds the device erasure completion status. Known values are:
     "None", "InProgress", "Succeeded", "Failed", "Cancelled", "Cancelling", "SucceededWithErrors",
     "WaitingForCustomerAction", "SucceededWithWarnings", "WaitingForCustomerActionForKek",
     "WaitingForCustomerActionForCleanUp", "CustomerActionPerformedForCleanUp", and
     "CustomerActionPerformed".
    :vartype device_erasure_status: str or ~azure.mgmt.databox.v2022_02_01.models.StageStatus
    :ivar erasure_or_destruction_certificate_sas_key: Shared access key to download cleanup or
     destruction certificate for device.
    :vartype erasure_or_destruction_certificate_sas_key: str
    """

    _validation = {
        "device_erasure_status": {"readonly": True},
        "erasure_or_destruction_certificate_sas_key": {"readonly": True},
    }

    _attribute_map = {
        "device_erasure_status": {"key": "deviceErasureStatus", "type": "str"},
        "erasure_or_destruction_certificate_sas_key": {"key": "erasureOrDestructionCertificateSasKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.device_erasure_status = None
        self.erasure_or_destruction_certificate_sas_key = None


class DiskScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling disk orders.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_location: Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype storage_location: str
    :ivar sku_name: Sku Name for which the order is to be scheduled. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype sku_name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    :ivar country: Country in which storage location should be supported.
    :vartype country: str
    :ivar expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
     transferred in this job, in terabytes. Required.
    :vartype expected_data_size_in_tera_bytes: int
    """

    _validation = {
        "storage_location": {"required": True},
        "sku_name": {"required": True},
        "expected_data_size_in_tera_bytes": {"required": True},
    }

    _attribute_map = {
        "storage_location": {"key": "storageLocation", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "expected_data_size_in_tera_bytes": {"key": "expectedDataSizeInTeraBytes", "type": "int"},
    }

    def __init__(
        self,
        *,
        storage_location: str,
        expected_data_size_in_tera_bytes: int,
        country: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword storage_location: Location for data transfer. For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype storage_location: str
        :keyword country: Country in which storage location should be supported.
        :paramtype country: str
        :keyword expected_data_size_in_tera_bytes: The expected size of the data, which needs to be
         transferred in this job, in terabytes. Required.
        :paramtype expected_data_size_in_tera_bytes: int
        """
        super().__init__(storage_location=storage_location, country=country, **kwargs)
        self.sku_name: str = "DataBoxDisk"
        self.expected_data_size_in_tera_bytes = expected_data_size_in_tera_bytes


class DiskSecret(_serialization.Model):
    """Contains all the secrets of a Disk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar disk_serial_number: Serial number of the assigned disk.
    :vartype disk_serial_number: str
    :ivar bit_locker_key: Bit Locker key of the disk which can be used to unlock the disk to copy
     data.
    :vartype bit_locker_key: str
    """

    _validation = {
        "disk_serial_number": {"readonly": True},
        "bit_locker_key": {"readonly": True},
    }

    _attribute_map = {
        "disk_serial_number": {"key": "diskSerialNumber", "type": "str"},
        "bit_locker_key": {"key": "bitLockerKey", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.disk_serial_number = None
        self.bit_locker_key = None


class EncryptionPreferences(_serialization.Model):
    """Preferences related to the Encryption.

    :ivar double_encryption: Defines secondary layer of software-based encryption enablement. Known
     values are: "Enabled" and "Disabled".
    :vartype double_encryption: str or ~azure.mgmt.databox.v2022_02_01.models.DoubleEncryption
    """

    _attribute_map = {
        "double_encryption": {"key": "doubleEncryption", "type": "str"},
    }

    def __init__(
        self, *, double_encryption: Union[str, "_models.DoubleEncryption"] = "Disabled", **kwargs: Any
    ) -> None:
        """
        :keyword double_encryption: Defines secondary layer of software-based encryption enablement.
         Known values are: "Enabled" and "Disabled".
        :paramtype double_encryption: str or ~azure.mgmt.databox.v2022_02_01.models.DoubleEncryption
        """
        super().__init__(**kwargs)
        self.double_encryption = double_encryption


class ErrorDetail(_serialization.Model):
    """ErrorDetail.

    All required parameters must be populated in order to send to Azure.

    :ivar code: Required.
    :vartype code: str
    :ivar message: Required.
    :vartype message: str
    :ivar details:
    :vartype details: list[~azure.mgmt.databox.v2022_02_01.models.Details]
    :ivar target:
    :vartype target: str
    """

    _validation = {
        "code": {"required": True},
        "message": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "details": {"key": "details", "type": "[Details]"},
        "target": {"key": "target", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        details: Optional[List["_models.Details"]] = None,
        target: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Required.
        :paramtype code: str
        :keyword message: Required.
        :paramtype message: str
        :keyword details:
        :paramtype details: list[~azure.mgmt.databox.v2022_02_01.models.Details]
        :keyword target:
        :paramtype target: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = details
        self.target = target


class ExportDiskDetails(_serialization.Model):
    """Export disk details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar manifest_file: The relative path of the manifest file on the disk.
    :vartype manifest_file: str
    :ivar manifest_hash: The Base16-encoded MD5 hash of the manifest file on the disk.
    :vartype manifest_hash: str
    :ivar backup_manifest_cloud_path: Path to backed up manifest, only returned if
     enableManifestBackup is true.
    :vartype backup_manifest_cloud_path: str
    """

    _validation = {
        "manifest_file": {"readonly": True},
        "manifest_hash": {"readonly": True},
        "backup_manifest_cloud_path": {"readonly": True},
    }

    _attribute_map = {
        "manifest_file": {"key": "manifestFile", "type": "str"},
        "manifest_hash": {"key": "manifestHash", "type": "str"},
        "backup_manifest_cloud_path": {"key": "backupManifestCloudPath", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.manifest_file = None
        self.manifest_hash = None
        self.backup_manifest_cloud_path = None


class FilterFileDetails(_serialization.Model):
    """Details of the filter files to be used for data transfer.

    All required parameters must be populated in order to send to Azure.

    :ivar filter_file_type: Type of the filter file. Required. Known values are: "AzureBlob" and
     "AzureFile".
    :vartype filter_file_type: str or ~azure.mgmt.databox.v2022_02_01.models.FilterFileType
    :ivar filter_file_path: Path of the file that contains the details of all items to transfer.
     Required.
    :vartype filter_file_path: str
    """

    _validation = {
        "filter_file_type": {"required": True},
        "filter_file_path": {"required": True},
    }

    _attribute_map = {
        "filter_file_type": {"key": "filterFileType", "type": "str"},
        "filter_file_path": {"key": "filterFilePath", "type": "str"},
    }

    def __init__(
        self, *, filter_file_type: Union[str, "_models.FilterFileType"], filter_file_path: str, **kwargs: Any
    ) -> None:
        """
        :keyword filter_file_type: Type of the filter file. Required. Known values are: "AzureBlob" and
         "AzureFile".
        :paramtype filter_file_type: str or ~azure.mgmt.databox.v2022_02_01.models.FilterFileType
        :keyword filter_file_path: Path of the file that contains the details of all items to transfer.
         Required.
        :paramtype filter_file_path: str
        """
        super().__init__(**kwargs)
        self.filter_file_type = filter_file_type
        self.filter_file_path = filter_file_path


class HeavyScheduleAvailabilityRequest(ScheduleAvailabilityRequest):
    """Request body to get the availability for scheduling heavy orders.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_location: Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype storage_location: str
    :ivar sku_name: Sku Name for which the order is to be scheduled. Required. Known values are:
     "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype sku_name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    :ivar country: Country in which storage location should be supported.
    :vartype country: str
    """

    _validation = {
        "storage_location": {"required": True},
        "sku_name": {"required": True},
    }

    _attribute_map = {
        "storage_location": {"key": "storageLocation", "type": "str"},
        "sku_name": {"key": "skuName", "type": "str"},
        "country": {"key": "country", "type": "str"},
    }

    def __init__(self, *, storage_location: str, country: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword storage_location: Location for data transfer. For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype storage_location: str
        :keyword country: Country in which storage location should be supported.
        :paramtype country: str
        """
        super().__init__(storage_location=storage_location, country=country, **kwargs)
        self.sku_name: str = "DataBoxHeavy"


class IdentityProperties(_serialization.Model):
    """Managed identity properties.

    :ivar type: Managed service identity type.
    :vartype type: str
    :ivar user_assigned: User assigned identity properties.
    :vartype user_assigned: ~azure.mgmt.databox.v2022_02_01.models.UserAssignedProperties
    """

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned": {"key": "userAssigned", "type": "UserAssignedProperties"},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        user_assigned: Optional["_models.UserAssignedProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Managed service identity type.
        :paramtype type: str
        :keyword user_assigned: User assigned identity properties.
        :paramtype user_assigned: ~azure.mgmt.databox.v2022_02_01.models.UserAssignedProperties
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned = user_assigned


class ImportDiskDetails(_serialization.Model):
    """Import disk details.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar manifest_file: The relative path of the manifest file on the disk. Required.
    :vartype manifest_file: str
    :ivar manifest_hash: The Base16-encoded MD5 hash of the manifest file on the disk. Required.
    :vartype manifest_hash: str
    :ivar bit_locker_key: BitLocker key used to encrypt the disk. Required.
    :vartype bit_locker_key: str
    :ivar backup_manifest_cloud_path: Path to backed up manifest, only returned if
     enableManifestBackup is true.
    :vartype backup_manifest_cloud_path: str
    """

    _validation = {
        "manifest_file": {"required": True},
        "manifest_hash": {"required": True},
        "bit_locker_key": {"required": True},
        "backup_manifest_cloud_path": {"readonly": True},
    }

    _attribute_map = {
        "manifest_file": {"key": "manifestFile", "type": "str"},
        "manifest_hash": {"key": "manifestHash", "type": "str"},
        "bit_locker_key": {"key": "bitLockerKey", "type": "str"},
        "backup_manifest_cloud_path": {"key": "backupManifestCloudPath", "type": "str"},
    }

    def __init__(self, *, manifest_file: str, manifest_hash: str, bit_locker_key: str, **kwargs: Any) -> None:
        """
        :keyword manifest_file: The relative path of the manifest file on the disk. Required.
        :paramtype manifest_file: str
        :keyword manifest_hash: The Base16-encoded MD5 hash of the manifest file on the disk. Required.
        :paramtype manifest_hash: str
        :keyword bit_locker_key: BitLocker key used to encrypt the disk. Required.
        :paramtype bit_locker_key: str
        """
        super().__init__(**kwargs)
        self.manifest_file = manifest_file
        self.manifest_hash = manifest_hash
        self.bit_locker_key = bit_locker_key
        self.backup_manifest_cloud_path = None


class JobDeliveryInfo(_serialization.Model):
    """Additional delivery info.

    :ivar scheduled_date_time: Scheduled date time.
    :vartype scheduled_date_time: ~datetime.datetime
    """

    _attribute_map = {
        "scheduled_date_time": {"key": "scheduledDateTime", "type": "iso-8601"},
    }

    def __init__(self, *, scheduled_date_time: Optional[datetime.datetime] = None, **kwargs: Any) -> None:
        """
        :keyword scheduled_date_time: Scheduled date time.
        :paramtype scheduled_date_time: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.scheduled_date_time = scheduled_date_time


class Resource(_serialization.Model):
    """Model of the Resource.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The location of the resource. This will be one of the supported and registered
     Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be
     changed once it is created, but if an identical region is specified on update the request will
     succeed. Required.
    :vartype location: str
    :ivar tags: The list of key value pairs that describe the resource. These tags can be used in
     viewing and grouping this resource (across resource groups).
    :vartype tags: dict[str, str]
    :ivar sku: The sku type. Required.
    :vartype sku: ~azure.mgmt.databox.v2022_02_01.models.Sku
    :ivar identity: Msi identity of the resource.
    :vartype identity: ~azure.mgmt.databox.v2022_02_01.models.ResourceIdentity
    """

    _validation = {
        "location": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This will be one of the supported and
         registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a
         resource cannot be changed once it is created, but if an identical region is specified on
         update the request will succeed. Required.
        :paramtype location: str
        :keyword tags: The list of key value pairs that describe the resource. These tags can be used
         in viewing and grouping this resource (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword sku: The sku type. Required.
        :paramtype sku: ~azure.mgmt.databox.v2022_02_01.models.Sku
        :keyword identity: Msi identity of the resource.
        :paramtype identity: ~azure.mgmt.databox.v2022_02_01.models.ResourceIdentity
        """
        super().__init__(**kwargs)
        self.location = location
        self.tags = tags
        self.sku = sku
        self.identity = identity


class JobResource(Resource):  # pylint: disable=too-many-instance-attributes
    """Job Resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar location: The location of the resource. This will be one of the supported and registered
     Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a resource cannot be
     changed once it is created, but if an identical region is specified on update the request will
     succeed. Required.
    :vartype location: str
    :ivar tags: The list of key value pairs that describe the resource. These tags can be used in
     viewing and grouping this resource (across resource groups).
    :vartype tags: dict[str, str]
    :ivar sku: The sku type. Required.
    :vartype sku: ~azure.mgmt.databox.v2022_02_01.models.Sku
    :ivar identity: Msi identity of the resource.
    :vartype identity: ~azure.mgmt.databox.v2022_02_01.models.ResourceIdentity
    :ivar name: Name of the object.
    :vartype name: str
    :ivar id: Id of the object.
    :vartype id: str
    :ivar type: Type of the object.
    :vartype type: str
    :ivar system_data: Metadata pertaining to creation and last modification of the resource.
    :vartype system_data: ~azure.mgmt.databox.v2022_02_01.models.SystemData
    :ivar transfer_type: Type of the data transfer. Required. Known values are: "ImportToAzure" and
     "ExportFromAzure".
    :vartype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
    :ivar is_cancellable: Describes whether the job is cancellable or not.
    :vartype is_cancellable: bool
    :ivar is_deletable: Describes whether the job is deletable or not.
    :vartype is_deletable: bool
    :ivar is_shipping_address_editable: Describes whether the shipping address is editable or not.
    :vartype is_shipping_address_editable: bool
    :ivar is_prepare_to_ship_enabled: Is Prepare To Ship Enabled on this job.
    :vartype is_prepare_to_ship_enabled: bool
    :ivar status: Name of the stage which is in progress. Known values are: "DeviceOrdered",
     "DevicePrepared", "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Completed",
     "CompletedWithErrors", "Cancelled", "Failed_IssueReportedAtCustomer",
     "Failed_IssueDetectedAtAzureDC", "Aborted", "CompletedWithWarnings",
     "ReadyToDispatchFromAzureDC", "ReadyToReceiveAtAzureDC", "Created", "ShippedToAzureDC",
     "AwaitingShipmentDetails", "PreparingToShipFromAzureDC", and "ShippedToCustomer".
    :vartype status: str or ~azure.mgmt.databox.v2022_02_01.models.StageName
    :ivar start_time: Time at which the job was started in UTC ISO 8601 format.
    :vartype start_time: ~datetime.datetime
    :ivar error: Top level error for the job.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar details: Details of a job run. This field will only be sent for expand details filter.
    :vartype details: ~azure.mgmt.databox.v2022_02_01.models.JobDetails
    :ivar cancellation_reason: Reason for cancellation.
    :vartype cancellation_reason: str
    :ivar delivery_type: Delivery type of Job. Known values are: "NonScheduled" and "Scheduled".
    :vartype delivery_type: str or ~azure.mgmt.databox.v2022_02_01.models.JobDeliveryType
    :ivar delivery_info: Delivery Info of Job.
    :vartype delivery_info: ~azure.mgmt.databox.v2022_02_01.models.JobDeliveryInfo
    :ivar is_cancellable_without_fee: Flag to indicate cancellation of scheduled job.
    :vartype is_cancellable_without_fee: bool
    """

    _validation = {
        "location": {"required": True},
        "sku": {"required": True},
        "name": {"readonly": True},
        "id": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "transfer_type": {"required": True},
        "is_cancellable": {"readonly": True},
        "is_deletable": {"readonly": True},
        "is_shipping_address_editable": {"readonly": True},
        "is_prepare_to_ship_enabled": {"readonly": True},
        "status": {"readonly": True},
        "start_time": {"readonly": True},
        "error": {"readonly": True},
        "cancellation_reason": {"readonly": True},
        "is_cancellable_without_fee": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "Sku"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "name": {"key": "name", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "transfer_type": {"key": "properties.transferType", "type": "str"},
        "is_cancellable": {"key": "properties.isCancellable", "type": "bool"},
        "is_deletable": {"key": "properties.isDeletable", "type": "bool"},
        "is_shipping_address_editable": {"key": "properties.isShippingAddressEditable", "type": "bool"},
        "is_prepare_to_ship_enabled": {"key": "properties.isPrepareToShipEnabled", "type": "bool"},
        "status": {"key": "properties.status", "type": "str"},
        "start_time": {"key": "properties.startTime", "type": "iso-8601"},
        "error": {"key": "properties.error", "type": "CloudError"},
        "details": {"key": "properties.details", "type": "JobDetails"},
        "cancellation_reason": {"key": "properties.cancellationReason", "type": "str"},
        "delivery_type": {"key": "properties.deliveryType", "type": "str"},
        "delivery_info": {"key": "properties.deliveryInfo", "type": "JobDeliveryInfo"},
        "is_cancellable_without_fee": {"key": "properties.isCancellableWithoutFee", "type": "bool"},
    }

    def __init__(
        self,
        *,
        location: str,
        sku: "_models.Sku",
        transfer_type: Union[str, "_models.TransferType"],
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        details: Optional["_models.JobDetails"] = None,
        delivery_type: Union[str, "_models.JobDeliveryType"] = "NonScheduled",
        delivery_info: Optional["_models.JobDeliveryInfo"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword location: The location of the resource. This will be one of the supported and
         registered Azure Regions (e.g. West US, East US, Southeast Asia, etc.). The region of a
         resource cannot be changed once it is created, but if an identical region is specified on
         update the request will succeed. Required.
        :paramtype location: str
        :keyword tags: The list of key value pairs that describe the resource. These tags can be used
         in viewing and grouping this resource (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword sku: The sku type. Required.
        :paramtype sku: ~azure.mgmt.databox.v2022_02_01.models.Sku
        :keyword identity: Msi identity of the resource.
        :paramtype identity: ~azure.mgmt.databox.v2022_02_01.models.ResourceIdentity
        :keyword transfer_type: Type of the data transfer. Required. Known values are: "ImportToAzure"
         and "ExportFromAzure".
        :paramtype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
        :keyword details: Details of a job run. This field will only be sent for expand details filter.
        :paramtype details: ~azure.mgmt.databox.v2022_02_01.models.JobDetails
        :keyword delivery_type: Delivery type of Job. Known values are: "NonScheduled" and "Scheduled".
        :paramtype delivery_type: str or ~azure.mgmt.databox.v2022_02_01.models.JobDeliveryType
        :keyword delivery_info: Delivery Info of Job.
        :paramtype delivery_info: ~azure.mgmt.databox.v2022_02_01.models.JobDeliveryInfo
        """
        super().__init__(location=location, tags=tags, sku=sku, identity=identity, **kwargs)
        self.name = None
        self.id = None
        self.type = None
        self.system_data = None
        self.transfer_type = transfer_type
        self.is_cancellable = None
        self.is_deletable = None
        self.is_shipping_address_editable = None
        self.is_prepare_to_ship_enabled = None
        self.status = None
        self.start_time = None
        self.error = None
        self.details = details
        self.cancellation_reason = None
        self.delivery_type = delivery_type
        self.delivery_info = delivery_info
        self.is_cancellable_without_fee = None


class JobResourceList(_serialization.Model):
    """Job Resource Collection.

    :ivar value: List of job resources.
    :vartype value: list[~azure.mgmt.databox.v2022_02_01.models.JobResource]
    :ivar next_link: Link for the next set of job resources.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[JobResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.JobResource"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: List of job resources.
        :paramtype value: list[~azure.mgmt.databox.v2022_02_01.models.JobResource]
        :keyword next_link: Link for the next set of job resources.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class JobResourceUpdateParameter(_serialization.Model):
    """The JobResourceUpdateParameter.

    :ivar tags: The list of key value pairs that describe the resource. These tags can be used in
     viewing and grouping this resource (across resource groups).
    :vartype tags: dict[str, str]
    :ivar identity: Msi identity of the resource.
    :vartype identity: ~azure.mgmt.databox.v2022_02_01.models.ResourceIdentity
    :ivar details: Details of a job to be updated.
    :vartype details: ~azure.mgmt.databox.v2022_02_01.models.UpdateJobDetails
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
        "identity": {"key": "identity", "type": "ResourceIdentity"},
        "details": {"key": "properties.details", "type": "UpdateJobDetails"},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ResourceIdentity"] = None,
        details: Optional["_models.UpdateJobDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: The list of key value pairs that describe the resource. These tags can be used
         in viewing and grouping this resource (across resource groups).
        :paramtype tags: dict[str, str]
        :keyword identity: Msi identity of the resource.
        :paramtype identity: ~azure.mgmt.databox.v2022_02_01.models.ResourceIdentity
        :keyword details: Details of a job to be updated.
        :paramtype details: ~azure.mgmt.databox.v2022_02_01.models.UpdateJobDetails
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.identity = identity
        self.details = details


class JobStages(_serialization.Model):
    """Job stages.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar stage_name: Name of the job stage. Known values are: "DeviceOrdered", "DevicePrepared",
     "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Completed",
     "CompletedWithErrors", "Cancelled", "Failed_IssueReportedAtCustomer",
     "Failed_IssueDetectedAtAzureDC", "Aborted", "CompletedWithWarnings",
     "ReadyToDispatchFromAzureDC", "ReadyToReceiveAtAzureDC", "Created", "ShippedToAzureDC",
     "AwaitingShipmentDetails", "PreparingToShipFromAzureDC", and "ShippedToCustomer".
    :vartype stage_name: str or ~azure.mgmt.databox.v2022_02_01.models.StageName
    :ivar display_name: Display name of the job stage.
    :vartype display_name: str
    :ivar stage_status: Status of the job stage. Known values are: "None", "InProgress",
     "Succeeded", "Failed", "Cancelled", "Cancelling", "SucceededWithErrors",
     "WaitingForCustomerAction", "SucceededWithWarnings", "WaitingForCustomerActionForKek",
     "WaitingForCustomerActionForCleanUp", "CustomerActionPerformedForCleanUp", and
     "CustomerActionPerformed".
    :vartype stage_status: str or ~azure.mgmt.databox.v2022_02_01.models.StageStatus
    :ivar stage_time: Time for the job stage in UTC ISO 8601 format.
    :vartype stage_time: ~datetime.datetime
    :ivar job_stage_details: Job Stage Details.
    :vartype job_stage_details: JSON
    """

    _validation = {
        "stage_name": {"readonly": True},
        "display_name": {"readonly": True},
        "stage_status": {"readonly": True},
        "stage_time": {"readonly": True},
        "job_stage_details": {"readonly": True},
    }

    _attribute_map = {
        "stage_name": {"key": "stageName", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "stage_status": {"key": "stageStatus", "type": "str"},
        "stage_time": {"key": "stageTime", "type": "iso-8601"},
        "job_stage_details": {"key": "jobStageDetails", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.stage_name = None
        self.display_name = None
        self.stage_status = None
        self.stage_time = None
        self.job_stage_details = None


class KeyEncryptionKey(_serialization.Model):
    """Encryption key containing details about key to encrypt different keys.

    All required parameters must be populated in order to send to Azure.

    :ivar kek_type: Type of encryption key used for key encryption. Known values are:
     "MicrosoftManaged" and "CustomerManaged".
    :vartype kek_type: str or ~azure.mgmt.databox.v2022_02_01.models.KekType
    :ivar identity_properties: Managed identity properties used for key encryption.
    :vartype identity_properties: ~azure.mgmt.databox.v2022_02_01.models.IdentityProperties
    :ivar kek_url: Key encryption key. It is required in case of Customer managed KekType.
    :vartype kek_url: str
    :ivar kek_vault_resource_id: Kek vault resource id. It is required in case of Customer managed
     KekType.
    :vartype kek_vault_resource_id: str
    """

    _validation = {
        "kek_type": {"required": True},
    }

    _attribute_map = {
        "kek_type": {"key": "kekType", "type": "str"},
        "identity_properties": {"key": "identityProperties", "type": "IdentityProperties"},
        "kek_url": {"key": "kekUrl", "type": "str"},
        "kek_vault_resource_id": {"key": "kekVaultResourceID", "type": "str"},
    }

    def __init__(
        self,
        *,
        kek_type: Union[str, "_models.KekType"] = "MicrosoftManaged",
        identity_properties: Optional["_models.IdentityProperties"] = None,
        kek_url: Optional[str] = None,
        kek_vault_resource_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kek_type: Type of encryption key used for key encryption. Known values are:
         "MicrosoftManaged" and "CustomerManaged".
        :paramtype kek_type: str or ~azure.mgmt.databox.v2022_02_01.models.KekType
        :keyword identity_properties: Managed identity properties used for key encryption.
        :paramtype identity_properties: ~azure.mgmt.databox.v2022_02_01.models.IdentityProperties
        :keyword kek_url: Key encryption key. It is required in case of Customer managed KekType.
        :paramtype kek_url: str
        :keyword kek_vault_resource_id: Kek vault resource id. It is required in case of Customer
         managed KekType.
        :paramtype kek_vault_resource_id: str
        """
        super().__init__(**kwargs)
        self.kek_type = kek_type
        self.identity_properties = identity_properties
        self.kek_url = kek_url
        self.kek_vault_resource_id = kek_vault_resource_id


class LastMitigationActionOnJob(_serialization.Model):
    """Last Mitigation Action Performed On Job.

    :ivar action_date_time_in_utc: Action performed date time.
    :vartype action_date_time_in_utc: ~datetime.datetime
    :ivar is_performed_by_customer: Action performed by customer,
     possibility is that mitigation might happen by customer or service or by ops.
    :vartype is_performed_by_customer: bool
    :ivar customer_resolution: Resolution code provided by customer. Known values are: "None",
     "MoveToCleanUpDevice", "Resume", "Restart", and "ReachOutToOperation".
    :vartype customer_resolution: str or
     ~azure.mgmt.databox.v2022_02_01.models.CustomerResolutionCode
    """

    _attribute_map = {
        "action_date_time_in_utc": {"key": "actionDateTimeInUtc", "type": "iso-8601"},
        "is_performed_by_customer": {"key": "isPerformedByCustomer", "type": "bool"},
        "customer_resolution": {"key": "customerResolution", "type": "str"},
    }

    def __init__(
        self,
        *,
        action_date_time_in_utc: Optional[datetime.datetime] = None,
        is_performed_by_customer: Optional[bool] = None,
        customer_resolution: Optional[Union[str, "_models.CustomerResolutionCode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword action_date_time_in_utc: Action performed date time.
        :paramtype action_date_time_in_utc: ~datetime.datetime
        :keyword is_performed_by_customer: Action performed by customer,
         possibility is that mitigation might happen by customer or service or by ops.
        :paramtype is_performed_by_customer: bool
        :keyword customer_resolution: Resolution code provided by customer. Known values are: "None",
         "MoveToCleanUpDevice", "Resume", "Restart", and "ReachOutToOperation".
        :paramtype customer_resolution: str or
         ~azure.mgmt.databox.v2022_02_01.models.CustomerResolutionCode
        """
        super().__init__(**kwargs)
        self.action_date_time_in_utc = action_date_time_in_utc
        self.is_performed_by_customer = is_performed_by_customer
        self.customer_resolution = customer_resolution


class ManagedDiskDetails(DataAccountDetails):
    """Details of the managed disks.

    All required parameters must be populated in order to send to Azure.

    :ivar data_account_type: Account Type of the data to be transferred. Required. Known values
     are: "StorageAccount" and "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar share_password: Password for all the shares to be created on the device. Should not be
     passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
     password itself. This will not be returned in Get Call. Password Requirements :  Password must
     be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
     alphabet, one number and one special character. Password cannot have the following characters :
     IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :vartype share_password: str
    :ivar resource_group_id: Resource Group Id of the compute disks. Required.
    :vartype resource_group_id: str
    :ivar staging_storage_account_id: Resource Id of the storage account that can be used to copy
     the vhd for staging. Required.
    :vartype staging_storage_account_id: str
    """

    _validation = {
        "data_account_type": {"required": True},
        "resource_group_id": {"required": True},
        "staging_storage_account_id": {"required": True},
    }

    _attribute_map = {
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "share_password": {"key": "sharePassword", "type": "str"},
        "resource_group_id": {"key": "resourceGroupId", "type": "str"},
        "staging_storage_account_id": {"key": "stagingStorageAccountId", "type": "str"},
    }

    def __init__(
        self,
        *,
        resource_group_id: str,
        staging_storage_account_id: str,
        share_password: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword share_password: Password for all the shares to be created on the device. Should not be
         passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
         password itself. This will not be returned in Get Call. Password Requirements :  Password must
         be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
         alphabet, one number and one special character. Password cannot have the following characters :
         IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
        :paramtype share_password: str
        :keyword resource_group_id: Resource Group Id of the compute disks. Required.
        :paramtype resource_group_id: str
        :keyword staging_storage_account_id: Resource Id of the storage account that can be used to
         copy the vhd for staging. Required.
        :paramtype staging_storage_account_id: str
        """
        super().__init__(share_password=share_password, **kwargs)
        self.data_account_type: str = "ManagedDisk"
        self.resource_group_id = resource_group_id
        self.staging_storage_account_id = staging_storage_account_id


class MarkDevicesShippedRequest(_serialization.Model):
    """The request body to provide the delivery package details of job.

    All required parameters must be populated in order to send to Azure.

    :ivar deliver_to_dc_package_details: Delivery package details. Required.
    :vartype deliver_to_dc_package_details:
     ~azure.mgmt.databox.v2022_02_01.models.PackageCarrierInfo
    """

    _validation = {
        "deliver_to_dc_package_details": {"required": True},
    }

    _attribute_map = {
        "deliver_to_dc_package_details": {"key": "deliverToDcPackageDetails", "type": "PackageCarrierInfo"},
    }

    def __init__(self, *, deliver_to_dc_package_details: "_models.PackageCarrierInfo", **kwargs: Any) -> None:
        """
        :keyword deliver_to_dc_package_details: Delivery package details. Required.
        :paramtype deliver_to_dc_package_details:
         ~azure.mgmt.databox.v2022_02_01.models.PackageCarrierInfo
        """
        super().__init__(**kwargs)
        self.deliver_to_dc_package_details = deliver_to_dc_package_details


class MitigateJobRequest(_serialization.Model):
    """The Mitigate Job captured from request body for Mitigate API.

    All required parameters must be populated in order to send to Azure.

    :ivar customer_resolution_code: Resolution code for the job. Required. Known values are:
     "None", "MoveToCleanUpDevice", "Resume", "Restart", and "ReachOutToOperation".
    :vartype customer_resolution_code: str or
     ~azure.mgmt.databox.v2022_02_01.models.CustomerResolutionCode
    """

    _validation = {
        "customer_resolution_code": {"required": True},
    }

    _attribute_map = {
        "customer_resolution_code": {"key": "customerResolutionCode", "type": "str"},
    }

    def __init__(
        self, *, customer_resolution_code: Union[str, "_models.CustomerResolutionCode"], **kwargs: Any
    ) -> None:
        """
        :keyword customer_resolution_code: Resolution code for the job. Required. Known values are:
         "None", "MoveToCleanUpDevice", "Resume", "Restart", and "ReachOutToOperation".
        :paramtype customer_resolution_code: str or
         ~azure.mgmt.databox.v2022_02_01.models.CustomerResolutionCode
        """
        super().__init__(**kwargs)
        self.customer_resolution_code = customer_resolution_code


class NotificationPreference(_serialization.Model):
    """Notification preference for a job stage.

    All required parameters must be populated in order to send to Azure.

    :ivar stage_name: Name of the stage. Required. Known values are: "DevicePrepared",
     "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Created", and
     "ShippedToCustomer".
    :vartype stage_name: str or ~azure.mgmt.databox.v2022_02_01.models.NotificationStageName
    :ivar send_notification: Notification is required or not.
    :vartype send_notification: bool
    """

    _validation = {
        "stage_name": {"required": True},
        "send_notification": {"required": True},
    }

    _attribute_map = {
        "stage_name": {"key": "stageName", "type": "str"},
        "send_notification": {"key": "sendNotification", "type": "bool"},
    }

    def __init__(
        self, *, stage_name: Union[str, "_models.NotificationStageName"], send_notification: bool = True, **kwargs: Any
    ) -> None:
        """
        :keyword stage_name: Name of the stage. Required. Known values are: "DevicePrepared",
         "Dispatched", "Delivered", "PickedUp", "AtAzureDC", "DataCopy", "Created", and
         "ShippedToCustomer".
        :paramtype stage_name: str or ~azure.mgmt.databox.v2022_02_01.models.NotificationStageName
        :keyword send_notification: Notification is required or not.
        :paramtype send_notification: bool
        """
        super().__init__(**kwargs)
        self.stage_name = stage_name
        self.send_notification = send_notification


class Operation(_serialization.Model):
    """Operation entity.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: Name of the operation. Format:
     {resourceProviderNamespace}/{resourceType}/{read|write|delete|action}.
    :vartype name: str
    :ivar display: Operation display values.
    :vartype display: ~azure.mgmt.databox.v2022_02_01.models.OperationDisplay
    :ivar properties: Operation properties.
    :vartype properties: JSON
    :ivar origin: Origin of the operation. Can be : user|system|user,system.
    :vartype origin: str
    :ivar is_data_action: Indicates whether the operation is a data action.
    :vartype is_data_action: bool
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
        "properties": {"readonly": True},
        "origin": {"readonly": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
        "properties": {"key": "properties", "type": "object"},
        "origin": {"key": "origin", "type": "str"},
        "is_data_action": {"key": "isDataAction", "type": "bool"},
    }

    def __init__(self, *, is_data_action: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_data_action: Indicates whether the operation is a data action.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.name = None
        self.display = None
        self.properties = None
        self.origin = None
        self.is_data_action = is_data_action


class OperationDisplay(_serialization.Model):
    """Operation display.

    :ivar provider: Provider name.
    :vartype provider: str
    :ivar resource: Resource name.
    :vartype resource: str
    :ivar operation: Localized name of the operation for display purpose.
    :vartype operation: str
    :ivar description: Localized description of the operation for display purpose.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Provider name.
        :paramtype provider: str
        :keyword resource: Resource name.
        :paramtype resource: str
        :keyword operation: Localized name of the operation for display purpose.
        :paramtype operation: str
        :keyword description: Localized description of the operation for display purpose.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(_serialization.Model):
    """Operation Collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of operations.
    :vartype value: list[~azure.mgmt.databox.v2022_02_01.models.Operation]
    :ivar next_link: Link for the next set of operations.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, next_link: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword next_link: Link for the next set of operations.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = next_link


class PackageCarrierDetails(_serialization.Model):
    """Package carrier details.

    :ivar carrier_account_number: Carrier Account Number of customer for customer disk.
    :vartype carrier_account_number: str
    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar tracking_id: Tracking Id of shipment.
    :vartype tracking_id: str
    """

    _attribute_map = {
        "carrier_account_number": {"key": "carrierAccountNumber", "type": "str"},
        "carrier_name": {"key": "carrierName", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
    }

    def __init__(
        self,
        *,
        carrier_account_number: Optional[str] = None,
        carrier_name: Optional[str] = None,
        tracking_id: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword carrier_account_number: Carrier Account Number of customer for customer disk.
        :paramtype carrier_account_number: str
        :keyword carrier_name: Name of the carrier.
        :paramtype carrier_name: str
        :keyword tracking_id: Tracking Id of shipment.
        :paramtype tracking_id: str
        """
        super().__init__(**kwargs)
        self.carrier_account_number = carrier_account_number
        self.carrier_name = carrier_name
        self.tracking_id = tracking_id


class PackageCarrierInfo(_serialization.Model):
    """package carrier info.

    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar tracking_id: Tracking Id of shipment.
    :vartype tracking_id: str
    """

    _attribute_map = {
        "carrier_name": {"key": "carrierName", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
    }

    def __init__(self, *, carrier_name: Optional[str] = None, tracking_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword carrier_name: Name of the carrier.
        :paramtype carrier_name: str
        :keyword tracking_id: Tracking Id of shipment.
        :paramtype tracking_id: str
        """
        super().__init__(**kwargs)
        self.carrier_name = carrier_name
        self.tracking_id = tracking_id


class PackageShippingDetails(_serialization.Model):
    """package shipping details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar tracking_url: Url where shipment can be tracked.
    :vartype tracking_url: str
    :ivar carrier_name: Name of the carrier.
    :vartype carrier_name: str
    :ivar tracking_id: Tracking Id of shipment.
    :vartype tracking_id: str
    """

    _validation = {
        "tracking_url": {"readonly": True},
        "carrier_name": {"readonly": True},
        "tracking_id": {"readonly": True},
    }

    _attribute_map = {
        "tracking_url": {"key": "trackingUrl", "type": "str"},
        "carrier_name": {"key": "carrierName", "type": "str"},
        "tracking_id": {"key": "trackingId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.tracking_url = None
        self.carrier_name = None
        self.tracking_id = None


class Preferences(_serialization.Model):
    """Preferences related to the order.

    :ivar preferred_data_center_region: Preferred data center region.
    :vartype preferred_data_center_region: list[str]
    :ivar transport_preferences: Preferences related to the shipment logistics of the sku.
    :vartype transport_preferences: ~azure.mgmt.databox.v2022_02_01.models.TransportPreferences
    :ivar encryption_preferences: Preferences related to the Encryption.
    :vartype encryption_preferences: ~azure.mgmt.databox.v2022_02_01.models.EncryptionPreferences
    :ivar storage_account_access_tier_preferences: Preferences related to the Access Tier of
     storage accounts.
    :vartype storage_account_access_tier_preferences: list[str]
    """

    _attribute_map = {
        "preferred_data_center_region": {"key": "preferredDataCenterRegion", "type": "[str]"},
        "transport_preferences": {"key": "transportPreferences", "type": "TransportPreferences"},
        "encryption_preferences": {"key": "encryptionPreferences", "type": "EncryptionPreferences"},
        "storage_account_access_tier_preferences": {"key": "storageAccountAccessTierPreferences", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        preferred_data_center_region: Optional[List[str]] = None,
        transport_preferences: Optional["_models.TransportPreferences"] = None,
        encryption_preferences: Optional["_models.EncryptionPreferences"] = None,
        storage_account_access_tier_preferences: Optional[List[Literal["Archive"]]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword preferred_data_center_region: Preferred data center region.
        :paramtype preferred_data_center_region: list[str]
        :keyword transport_preferences: Preferences related to the shipment logistics of the sku.
        :paramtype transport_preferences: ~azure.mgmt.databox.v2022_02_01.models.TransportPreferences
        :keyword encryption_preferences: Preferences related to the Encryption.
        :paramtype encryption_preferences: ~azure.mgmt.databox.v2022_02_01.models.EncryptionPreferences
        :keyword storage_account_access_tier_preferences: Preferences related to the Access Tier of
         storage accounts.
        :paramtype storage_account_access_tier_preferences: list[str]
        """
        super().__init__(**kwargs)
        self.preferred_data_center_region = preferred_data_center_region
        self.transport_preferences = transport_preferences
        self.encryption_preferences = encryption_preferences
        self.storage_account_access_tier_preferences = storage_account_access_tier_preferences


class PreferencesValidationRequest(ValidationInputRequest):
    """Request to validate preference of transport and data center.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar preference: Preference of transport and data center.
    :vartype preference: ~azure.mgmt.databox.v2022_02_01.models.Preferences
    :ivar device_type: Device type to be used for the job. Required. Known values are: "DataBox",
     "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    """

    _validation = {
        "validation_type": {"required": True},
        "device_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "preference": {"key": "preference", "type": "Preferences"},
        "device_type": {"key": "deviceType", "type": "str"},
    }

    def __init__(
        self,
        *,
        device_type: Union[str, "_models.SkuName"],
        preference: Optional["_models.Preferences"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword preference: Preference of transport and data center.
        :paramtype preference: ~azure.mgmt.databox.v2022_02_01.models.Preferences
        :keyword device_type: Device type to be used for the job. Required. Known values are:
         "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
        :paramtype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidatePreferences"
        self.preference = preference
        self.device_type = device_type


class PreferencesValidationResponseProperties(ValidationInputResponse):
    """Properties of data center and transport preference validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar status: Validation status of requested data center and transport. Known values are:
     "Valid", "Invalid", and "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2022_02_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "CloudError"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidatePreferences"
        self.status = None


class RegionConfigurationRequest(_serialization.Model):
    """Request body to get the configuration for the region.

    :ivar schedule_availability_request: Request body to get the availability for scheduling
     orders.
    :vartype schedule_availability_request:
     ~azure.mgmt.databox.v2022_02_01.models.ScheduleAvailabilityRequest
    :ivar transport_availability_request: Request body to get the transport availability for given
     sku.
    :vartype transport_availability_request:
     ~azure.mgmt.databox.v2022_02_01.models.TransportAvailabilityRequest
    :ivar datacenter_address_request: Request body to get the datacenter address for given sku.
    :vartype datacenter_address_request:
     ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressRequest
    """

    _attribute_map = {
        "schedule_availability_request": {"key": "scheduleAvailabilityRequest", "type": "ScheduleAvailabilityRequest"},
        "transport_availability_request": {
            "key": "transportAvailabilityRequest",
            "type": "TransportAvailabilityRequest",
        },
        "datacenter_address_request": {"key": "datacenterAddressRequest", "type": "DatacenterAddressRequest"},
    }

    def __init__(
        self,
        *,
        schedule_availability_request: Optional["_models.ScheduleAvailabilityRequest"] = None,
        transport_availability_request: Optional["_models.TransportAvailabilityRequest"] = None,
        datacenter_address_request: Optional["_models.DatacenterAddressRequest"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword schedule_availability_request: Request body to get the availability for scheduling
         orders.
        :paramtype schedule_availability_request:
         ~azure.mgmt.databox.v2022_02_01.models.ScheduleAvailabilityRequest
        :keyword transport_availability_request: Request body to get the transport availability for
         given sku.
        :paramtype transport_availability_request:
         ~azure.mgmt.databox.v2022_02_01.models.TransportAvailabilityRequest
        :keyword datacenter_address_request: Request body to get the datacenter address for given sku.
        :paramtype datacenter_address_request:
         ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressRequest
        """
        super().__init__(**kwargs)
        self.schedule_availability_request = schedule_availability_request
        self.transport_availability_request = transport_availability_request
        self.datacenter_address_request = datacenter_address_request


class RegionConfigurationResponse(_serialization.Model):
    """Configuration response specific to a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar schedule_availability_response: Schedule availability for given sku in a region.
    :vartype schedule_availability_response:
     ~azure.mgmt.databox.v2022_02_01.models.ScheduleAvailabilityResponse
    :ivar transport_availability_response: Transport options available for given sku in a region.
    :vartype transport_availability_response:
     ~azure.mgmt.databox.v2022_02_01.models.TransportAvailabilityResponse
    :ivar datacenter_address_response: Datacenter address for given sku in a region.
    :vartype datacenter_address_response:
     ~azure.mgmt.databox.v2022_02_01.models.DatacenterAddressResponse
    """

    _validation = {
        "schedule_availability_response": {"readonly": True},
        "transport_availability_response": {"readonly": True},
        "datacenter_address_response": {"readonly": True},
    }

    _attribute_map = {
        "schedule_availability_response": {
            "key": "scheduleAvailabilityResponse",
            "type": "ScheduleAvailabilityResponse",
        },
        "transport_availability_response": {
            "key": "transportAvailabilityResponse",
            "type": "TransportAvailabilityResponse",
        },
        "datacenter_address_response": {"key": "datacenterAddressResponse", "type": "DatacenterAddressResponse"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.schedule_availability_response = None
        self.transport_availability_response = None
        self.datacenter_address_response = None


class ResourceIdentity(_serialization.Model):
    """Msi identity details of the resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: Identity type.
    :vartype type: str
    :ivar principal_id: Service Principal Id backing the Msi.
    :vartype principal_id: str
    :ivar tenant_id: Home Tenant Id.
    :vartype tenant_id: str
    :ivar user_assigned_identities: User Assigned Identities.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.databox.v2022_02_01.models.UserAssignedIdentity]
    """

    _validation = {
        "principal_id": {"readonly": True},
        "tenant_id": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "principal_id": {"key": "principalId", "type": "str"},
        "tenant_id": {"key": "tenantId", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: str = "None",
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Identity type.
        :paramtype type: str
        :keyword user_assigned_identities: User Assigned Identities.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.databox.v2022_02_01.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.principal_id = None
        self.tenant_id = None
        self.user_assigned_identities = user_assigned_identities


class ScheduleAvailabilityResponse(_serialization.Model):
    """Schedule availability for given sku in a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar available_dates: List of dates available to schedule.
    :vartype available_dates: list[~datetime.datetime]
    """

    _validation = {
        "available_dates": {"readonly": True},
    }

    _attribute_map = {
        "available_dates": {"key": "availableDates", "type": "[iso-8601]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.available_dates = None


class ShareCredentialDetails(_serialization.Model):
    """Credential details of the shares in account.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar share_name: Name of the share.
    :vartype share_name: str
    :ivar share_type: Type of the share. Known values are: "UnknownType", "HCS", "BlockBlob",
     "PageBlob", "AzureFile", and "ManagedDisk".
    :vartype share_type: str or ~azure.mgmt.databox.v2022_02_01.models.ShareDestinationFormatType
    :ivar user_name: User name for the share.
    :vartype user_name: str
    :ivar password: Password for the share.
    :vartype password: str
    :ivar supported_access_protocols: Access protocols supported on the device.
    :vartype supported_access_protocols: list[str or
     ~azure.mgmt.databox.v2022_02_01.models.AccessProtocol]
    """

    _validation = {
        "share_name": {"readonly": True},
        "share_type": {"readonly": True},
        "user_name": {"readonly": True},
        "password": {"readonly": True},
        "supported_access_protocols": {"readonly": True},
    }

    _attribute_map = {
        "share_name": {"key": "shareName", "type": "str"},
        "share_type": {"key": "shareType", "type": "str"},
        "user_name": {"key": "userName", "type": "str"},
        "password": {"key": "password", "type": "str"},
        "supported_access_protocols": {"key": "supportedAccessProtocols", "type": "[str]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.share_name = None
        self.share_type = None
        self.user_name = None
        self.password = None
        self.supported_access_protocols = None


class ShipmentPickUpRequest(_serialization.Model):
    """Shipment pick up request details.

    All required parameters must be populated in order to send to Azure.

    :ivar start_time: Minimum date after which the pick up should commence, this must be in local
     time of pick up area. Required.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: Maximum date before which the pick up should commence, this must be in local
     time of pick up area. Required.
    :vartype end_time: ~datetime.datetime
    :ivar shipment_location: Shipment Location in the pickup place. Eg.front desk. Required.
    :vartype shipment_location: str
    """

    _validation = {
        "start_time": {"required": True},
        "end_time": {"required": True},
        "shipment_location": {"required": True},
    }

    _attribute_map = {
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "shipment_location": {"key": "shipmentLocation", "type": "str"},
    }

    def __init__(
        self, *, start_time: datetime.datetime, end_time: datetime.datetime, shipment_location: str, **kwargs: Any
    ) -> None:
        """
        :keyword start_time: Minimum date after which the pick up should commence, this must be in
         local time of pick up area. Required.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: Maximum date before which the pick up should commence, this must be in local
         time of pick up area. Required.
        :paramtype end_time: ~datetime.datetime
        :keyword shipment_location: Shipment Location in the pickup place. Eg.front desk. Required.
        :paramtype shipment_location: str
        """
        super().__init__(**kwargs)
        self.start_time = start_time
        self.end_time = end_time
        self.shipment_location = shipment_location


class ShipmentPickUpResponse(_serialization.Model):
    """Shipment pick up response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar confirmation_number: Confirmation number for the pick up request.
    :vartype confirmation_number: str
    :ivar ready_by_time: Time by which shipment should be ready for pick up, this is in local time
     of pick up area.
    :vartype ready_by_time: ~datetime.datetime
    """

    _validation = {
        "confirmation_number": {"readonly": True},
        "ready_by_time": {"readonly": True},
    }

    _attribute_map = {
        "confirmation_number": {"key": "confirmationNumber", "type": "str"},
        "ready_by_time": {"key": "readyByTime", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.confirmation_number = None
        self.ready_by_time = None


class ShippingAddress(_serialization.Model):
    """Shipping address where customer wishes to receive the device.

    All required parameters must be populated in order to send to Azure.

    :ivar street_address1: Street Address line 1. Required.
    :vartype street_address1: str
    :ivar street_address2: Street Address line 2.
    :vartype street_address2: str
    :ivar street_address3: Street Address line 3.
    :vartype street_address3: str
    :ivar city: Name of the City.
    :vartype city: str
    :ivar state_or_province: Name of the State or Province.
    :vartype state_or_province: str
    :ivar country: Name of the Country. Required.
    :vartype country: str
    :ivar postal_code: Postal code.
    :vartype postal_code: str
    :ivar zip_extended_code: Extended Zip Code.
    :vartype zip_extended_code: str
    :ivar company_name: Name of the company.
    :vartype company_name: str
    :ivar address_type: Type of address. Known values are: "None", "Residential", and "Commercial".
    :vartype address_type: str or ~azure.mgmt.databox.v2022_02_01.models.AddressType
    """

    _validation = {
        "street_address1": {"required": True},
        "country": {"required": True},
    }

    _attribute_map = {
        "street_address1": {"key": "streetAddress1", "type": "str"},
        "street_address2": {"key": "streetAddress2", "type": "str"},
        "street_address3": {"key": "streetAddress3", "type": "str"},
        "city": {"key": "city", "type": "str"},
        "state_or_province": {"key": "stateOrProvince", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "postal_code": {"key": "postalCode", "type": "str"},
        "zip_extended_code": {"key": "zipExtendedCode", "type": "str"},
        "company_name": {"key": "companyName", "type": "str"},
        "address_type": {"key": "addressType", "type": "str"},
    }

    def __init__(
        self,
        *,
        street_address1: str,
        country: str,
        street_address2: Optional[str] = None,
        street_address3: Optional[str] = None,
        city: Optional[str] = None,
        state_or_province: Optional[str] = None,
        postal_code: Optional[str] = None,
        zip_extended_code: Optional[str] = None,
        company_name: Optional[str] = None,
        address_type: Union[str, "_models.AddressType"] = "None",
        **kwargs: Any
    ) -> None:
        """
        :keyword street_address1: Street Address line 1. Required.
        :paramtype street_address1: str
        :keyword street_address2: Street Address line 2.
        :paramtype street_address2: str
        :keyword street_address3: Street Address line 3.
        :paramtype street_address3: str
        :keyword city: Name of the City.
        :paramtype city: str
        :keyword state_or_province: Name of the State or Province.
        :paramtype state_or_province: str
        :keyword country: Name of the Country. Required.
        :paramtype country: str
        :keyword postal_code: Postal code.
        :paramtype postal_code: str
        :keyword zip_extended_code: Extended Zip Code.
        :paramtype zip_extended_code: str
        :keyword company_name: Name of the company.
        :paramtype company_name: str
        :keyword address_type: Type of address. Known values are: "None", "Residential", and
         "Commercial".
        :paramtype address_type: str or ~azure.mgmt.databox.v2022_02_01.models.AddressType
        """
        super().__init__(**kwargs)
        self.street_address1 = street_address1
        self.street_address2 = street_address2
        self.street_address3 = street_address3
        self.city = city
        self.state_or_province = state_or_province
        self.country = country
        self.postal_code = postal_code
        self.zip_extended_code = zip_extended_code
        self.company_name = company_name
        self.address_type = address_type


class Sku(_serialization.Model):
    """The Sku.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The sku name. Required. Known values are: "DataBox", "DataBoxDisk", "DataBoxHeavy",
     and "DataBoxCustomerDisk".
    :vartype name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    :ivar display_name: The display name of the sku.
    :vartype display_name: str
    :ivar family: The sku family.
    :vartype family: str
    """

    _validation = {
        "name": {"required": True},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "display_name": {"key": "displayName", "type": "str"},
        "family": {"key": "family", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Union[str, "_models.SkuName"],
        display_name: Optional[str] = None,
        family: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The sku name. Required. Known values are: "DataBox", "DataBoxDisk",
         "DataBoxHeavy", and "DataBoxCustomerDisk".
        :paramtype name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
        :keyword display_name: The display name of the sku.
        :paramtype display_name: str
        :keyword family: The sku family.
        :paramtype family: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.family = family


class SkuAvailabilityValidationRequest(ValidationInputRequest):
    """Request to validate sku availability.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar device_type: Device type to be used for the job. Required. Known values are: "DataBox",
     "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    :ivar transfer_type: Type of the transfer. Required. Known values are: "ImportToAzure" and
     "ExportFromAzure".
    :vartype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
    :ivar country: ISO country code. Country for hardware shipment. For codes check:
     https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. Required.
    :vartype country: str
    :ivar location: Location for data transfer. For locations check:
     https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
     Required.
    :vartype location: str
    """

    _validation = {
        "validation_type": {"required": True},
        "device_type": {"required": True},
        "transfer_type": {"required": True},
        "country": {"required": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "transfer_type": {"key": "transferType", "type": "str"},
        "country": {"key": "country", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(
        self,
        *,
        device_type: Union[str, "_models.SkuName"],
        transfer_type: Union[str, "_models.TransferType"],
        country: str,
        location: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword device_type: Device type to be used for the job. Required. Known values are:
         "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
        :paramtype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
        :keyword transfer_type: Type of the transfer. Required. Known values are: "ImportToAzure" and
         "ExportFromAzure".
        :paramtype transfer_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransferType
        :keyword country: ISO country code. Country for hardware shipment. For codes check:
         https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2#Officially_assigned_code_elements. Required.
        :paramtype country: str
        :keyword location: Location for data transfer. For locations check:
         https://management.azure.com/subscriptions/SUBSCRIPTIONID/locations?api-version=2018-01-01.
         Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateSkuAvailability"
        self.device_type = device_type
        self.transfer_type = transfer_type
        self.country = country
        self.location = location


class SkuAvailabilityValidationResponseProperties(ValidationInputResponse):
    """Properties of sku availability validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar status: Sku availability validation status. Known values are: "Valid", "Invalid", and
     "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2022_02_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "CloudError"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateSkuAvailability"
        self.status = None


class SkuCapacity(_serialization.Model):
    """Capacity of the sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar usable: Usable capacity in TB.
    :vartype usable: str
    :ivar maximum: Maximum capacity in TB.
    :vartype maximum: str
    """

    _validation = {
        "usable": {"readonly": True},
        "maximum": {"readonly": True},
    }

    _attribute_map = {
        "usable": {"key": "usable", "type": "str"},
        "maximum": {"key": "maximum", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.usable = None
        self.maximum = None


class SkuCost(_serialization.Model):
    """Describes metadata for retrieving price info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar meter_id: Meter id of the Sku.
    :vartype meter_id: str
    :ivar meter_type: The type of the meter.
    :vartype meter_type: str
    :ivar multiplier: Multiplier specifies the region specific value to be multiplied with 1$ guid.
     Eg: Our new regions will be using 1$ shipping guid with appropriate multiplier specific to
     region.
    :vartype multiplier: float
    """

    _validation = {
        "meter_id": {"readonly": True},
        "meter_type": {"readonly": True},
        "multiplier": {"readonly": True},
    }

    _attribute_map = {
        "meter_id": {"key": "meterId", "type": "str"},
        "meter_type": {"key": "meterType", "type": "str"},
        "multiplier": {"key": "multiplier", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.meter_id = None
        self.meter_type = None
        self.multiplier = None


class SkuInformation(_serialization.Model):
    """Information of the sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.databox.v2022_02_01.models.Sku
    :ivar enabled: The sku is enabled or not.
    :vartype enabled: bool
    :ivar data_location_to_service_location_map: The map of data location to service location.
    :vartype data_location_to_service_location_map:
     list[~azure.mgmt.databox.v2022_02_01.models.DataLocationToServiceLocationMap]
    :ivar capacity: Capacity of the Sku.
    :vartype capacity: ~azure.mgmt.databox.v2022_02_01.models.SkuCapacity
    :ivar costs: Cost of the Sku.
    :vartype costs: list[~azure.mgmt.databox.v2022_02_01.models.SkuCost]
    :ivar api_versions: Api versions that support this Sku.
    :vartype api_versions: list[str]
    :ivar disabled_reason: Reason why the Sku is disabled. Known values are: "None", "Country",
     "Region", "Feature", "OfferType", and "NoSubscriptionInfo".
    :vartype disabled_reason: str or ~azure.mgmt.databox.v2022_02_01.models.SkuDisabledReason
    :ivar disabled_reason_message: Message for why the Sku is disabled.
    :vartype disabled_reason_message: str
    :ivar required_feature: Required feature to access the sku.
    :vartype required_feature: str
    """

    _validation = {
        "sku": {"readonly": True},
        "enabled": {"readonly": True},
        "data_location_to_service_location_map": {"readonly": True},
        "capacity": {"readonly": True},
        "costs": {"readonly": True},
        "api_versions": {"readonly": True},
        "disabled_reason": {"readonly": True},
        "disabled_reason_message": {"readonly": True},
        "required_feature": {"readonly": True},
    }

    _attribute_map = {
        "sku": {"key": "sku", "type": "Sku"},
        "enabled": {"key": "enabled", "type": "bool"},
        "data_location_to_service_location_map": {
            "key": "properties.dataLocationToServiceLocationMap",
            "type": "[DataLocationToServiceLocationMap]",
        },
        "capacity": {"key": "properties.capacity", "type": "SkuCapacity"},
        "costs": {"key": "properties.costs", "type": "[SkuCost]"},
        "api_versions": {"key": "properties.apiVersions", "type": "[str]"},
        "disabled_reason": {"key": "properties.disabledReason", "type": "str"},
        "disabled_reason_message": {"key": "properties.disabledReasonMessage", "type": "str"},
        "required_feature": {"key": "properties.requiredFeature", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.sku = None
        self.enabled = None
        self.data_location_to_service_location_map = None
        self.capacity = None
        self.costs = None
        self.api_versions = None
        self.disabled_reason = None
        self.disabled_reason_message = None
        self.required_feature = None


class StorageAccountDetails(DataAccountDetails):
    """Details for the storage account.

    All required parameters must be populated in order to send to Azure.

    :ivar data_account_type: Account Type of the data to be transferred. Required. Known values
     are: "StorageAccount" and "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar share_password: Password for all the shares to be created on the device. Should not be
     passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
     password itself. This will not be returned in Get Call. Password Requirements :  Password must
     be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
     alphabet, one number and one special character. Password cannot have the following characters :
     IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
    :vartype share_password: str
    :ivar storage_account_id: Storage Account Resource Id. Required.
    :vartype storage_account_id: str
    """

    _validation = {
        "data_account_type": {"required": True},
        "storage_account_id": {"required": True},
    }

    _attribute_map = {
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "share_password": {"key": "sharePassword", "type": "str"},
        "storage_account_id": {"key": "storageAccountId", "type": "str"},
    }

    def __init__(self, *, storage_account_id: str, share_password: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword share_password: Password for all the shares to be created on the device. Should not be
         passed for TransferType:ExportFromAzure jobs. If this is not passed, the service will generate
         password itself. This will not be returned in Get Call. Password Requirements :  Password must
         be minimum of 12 and maximum of 64 characters. Password must have at least one uppercase
         alphabet, one number and one special character. Password cannot have the following characters :
         IilLoO0 Password can have only alphabets, numbers and these characters : @#-$%^!+=;:_()]+.
        :paramtype share_password: str
        :keyword storage_account_id: Storage Account Resource Id. Required.
        :paramtype storage_account_id: str
        """
        super().__init__(share_password=share_password, **kwargs)
        self.data_account_type: str = "StorageAccount"
        self.storage_account_id = storage_account_id


class SubscriptionIsAllowedToCreateJobValidationRequest(ValidationInputRequest):
    """Request to validate subscription permission to create jobs.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    """

    _validation = {
        "validation_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateSubscriptionIsAllowedToCreateJob"


class SubscriptionIsAllowedToCreateJobValidationResponseProperties(ValidationInputResponse):
    """Properties of subscription permission to create job validation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation response. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar error: Error code and message of validation response.
    :vartype error: ~azure.mgmt.databox.v2022_02_01.models.CloudError
    :ivar status: Validation status of subscription permission to create job. Known values are:
     "Valid", "Invalid", and "Skipped".
    :vartype status: str or ~azure.mgmt.databox.v2022_02_01.models.ValidationStatus
    """

    _validation = {
        "validation_type": {"required": True},
        "error": {"readonly": True},
        "status": {"readonly": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "error": {"key": "error", "type": "CloudError"},
        "status": {"key": "status", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateSubscriptionIsAllowedToCreateJob"
        self.status = None


class SystemData(_serialization.Model):
    """Provides details about resource creation and update time.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar created_by: A string identifier for the identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource: user, application,
     managedIdentity.
    :vartype created_by_type: str
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: A string identifier for the identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource: user,
     application, managedIdentity.
    :vartype last_modified_by_type: str
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _validation = {
        "created_by": {"readonly": True},
        "created_by_type": {"readonly": True},
        "created_at": {"readonly": True},
        "last_modified_by": {"readonly": True},
        "last_modified_by_type": {"readonly": True},
        "last_modified_at": {"readonly": True},
    }

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.created_by = None
        self.created_by_type = None
        self.created_at = None
        self.last_modified_by = None
        self.last_modified_by_type = None
        self.last_modified_at = None


class TransferAllDetails(_serialization.Model):
    """Details to transfer all data.

    All required parameters must be populated in order to send to Azure.

    :ivar data_account_type: Type of the account of data. Required. Known values are:
     "StorageAccount" and "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar transfer_all_blobs: To indicate if all Azure blobs have to be transferred.
    :vartype transfer_all_blobs: bool
    :ivar transfer_all_files: To indicate if all Azure Files have to be transferred.
    :vartype transfer_all_files: bool
    """

    _validation = {
        "data_account_type": {"required": True},
    }

    _attribute_map = {
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "transfer_all_blobs": {"key": "transferAllBlobs", "type": "bool"},
        "transfer_all_files": {"key": "transferAllFiles", "type": "bool"},
    }

    def __init__(
        self,
        *,
        data_account_type: Union[str, "_models.DataAccountType"],
        transfer_all_blobs: Optional[bool] = None,
        transfer_all_files: Optional[bool] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_account_type: Type of the account of data. Required. Known values are:
         "StorageAccount" and "ManagedDisk".
        :paramtype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
        :keyword transfer_all_blobs: To indicate if all Azure blobs have to be transferred.
        :paramtype transfer_all_blobs: bool
        :keyword transfer_all_files: To indicate if all Azure Files have to be transferred.
        :paramtype transfer_all_files: bool
        """
        super().__init__(**kwargs)
        self.data_account_type = data_account_type
        self.transfer_all_blobs = transfer_all_blobs
        self.transfer_all_files = transfer_all_files


class TransferConfiguration(_serialization.Model):
    """Configuration for defining the transfer of data.

    All required parameters must be populated in order to send to Azure.

    :ivar transfer_configuration_type: Type of the configuration for transfer. Required. Known
     values are: "TransferAll" and "TransferUsingFilter".
    :vartype transfer_configuration_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.TransferConfigurationType
    :ivar transfer_filter_details: Map of filter type and the details to filter. This field is
     required only if the TransferConfigurationType is given as TransferUsingFilter.
    :vartype transfer_filter_details:
     ~azure.mgmt.databox.v2022_02_01.models.TransferConfigurationTransferFilterDetails
    :ivar transfer_all_details: Map of filter type and the details to transfer all data. This field
     is required only if the TransferConfigurationType is given as TransferAll.
    :vartype transfer_all_details:
     ~azure.mgmt.databox.v2022_02_01.models.TransferConfigurationTransferAllDetails
    """

    _validation = {
        "transfer_configuration_type": {"required": True},
    }

    _attribute_map = {
        "transfer_configuration_type": {"key": "transferConfigurationType", "type": "str"},
        "transfer_filter_details": {
            "key": "transferFilterDetails",
            "type": "TransferConfigurationTransferFilterDetails",
        },
        "transfer_all_details": {"key": "transferAllDetails", "type": "TransferConfigurationTransferAllDetails"},
    }

    def __init__(
        self,
        *,
        transfer_configuration_type: Union[str, "_models.TransferConfigurationType"],
        transfer_filter_details: Optional["_models.TransferConfigurationTransferFilterDetails"] = None,
        transfer_all_details: Optional["_models.TransferConfigurationTransferAllDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword transfer_configuration_type: Type of the configuration for transfer. Required. Known
         values are: "TransferAll" and "TransferUsingFilter".
        :paramtype transfer_configuration_type: str or
         ~azure.mgmt.databox.v2022_02_01.models.TransferConfigurationType
        :keyword transfer_filter_details: Map of filter type and the details to filter. This field is
         required only if the TransferConfigurationType is given as TransferUsingFilter.
        :paramtype transfer_filter_details:
         ~azure.mgmt.databox.v2022_02_01.models.TransferConfigurationTransferFilterDetails
        :keyword transfer_all_details: Map of filter type and the details to transfer all data. This
         field is required only if the TransferConfigurationType is given as TransferAll.
        :paramtype transfer_all_details:
         ~azure.mgmt.databox.v2022_02_01.models.TransferConfigurationTransferAllDetails
        """
        super().__init__(**kwargs)
        self.transfer_configuration_type = transfer_configuration_type
        self.transfer_filter_details = transfer_filter_details
        self.transfer_all_details = transfer_all_details


class TransferConfigurationTransferAllDetails(_serialization.Model):
    """Map of filter type and the details to transfer all data. This field is required only if the
    TransferConfigurationType is given as TransferAll.

    :ivar include: Details to transfer all data.
    :vartype include: ~azure.mgmt.databox.v2022_02_01.models.TransferAllDetails
    """

    _attribute_map = {
        "include": {"key": "include", "type": "TransferAllDetails"},
    }

    def __init__(self, *, include: Optional["_models.TransferAllDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword include: Details to transfer all data.
        :paramtype include: ~azure.mgmt.databox.v2022_02_01.models.TransferAllDetails
        """
        super().__init__(**kwargs)
        self.include = include


class TransferConfigurationTransferFilterDetails(_serialization.Model):
    """Map of filter type and the details to filter. This field is required only if the
    TransferConfigurationType is given as TransferUsingFilter.

    :ivar include: Details of the filtering the transfer of data.
    :vartype include: ~azure.mgmt.databox.v2022_02_01.models.TransferFilterDetails
    """

    _attribute_map = {
        "include": {"key": "include", "type": "TransferFilterDetails"},
    }

    def __init__(self, *, include: Optional["_models.TransferFilterDetails"] = None, **kwargs: Any) -> None:
        """
        :keyword include: Details of the filtering the transfer of data.
        :paramtype include: ~azure.mgmt.databox.v2022_02_01.models.TransferFilterDetails
        """
        super().__init__(**kwargs)
        self.include = include


class TransferFilterDetails(_serialization.Model):
    """Details of the filtering the transfer of data.

    All required parameters must be populated in order to send to Azure.

    :ivar data_account_type: Type of the account of data. Required. Known values are:
     "StorageAccount" and "ManagedDisk".
    :vartype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
    :ivar blob_filter_details: Filter details to transfer blobs.
    :vartype blob_filter_details: ~azure.mgmt.databox.v2022_02_01.models.BlobFilterDetails
    :ivar azure_file_filter_details: Filter details to transfer Azure files.
    :vartype azure_file_filter_details:
     ~azure.mgmt.databox.v2022_02_01.models.AzureFileFilterDetails
    :ivar filter_file_details: Details of the filter files to be used for data transfer.
    :vartype filter_file_details: list[~azure.mgmt.databox.v2022_02_01.models.FilterFileDetails]
    """

    _validation = {
        "data_account_type": {"required": True},
    }

    _attribute_map = {
        "data_account_type": {"key": "dataAccountType", "type": "str"},
        "blob_filter_details": {"key": "blobFilterDetails", "type": "BlobFilterDetails"},
        "azure_file_filter_details": {"key": "azureFileFilterDetails", "type": "AzureFileFilterDetails"},
        "filter_file_details": {"key": "filterFileDetails", "type": "[FilterFileDetails]"},
    }

    def __init__(
        self,
        *,
        data_account_type: Union[str, "_models.DataAccountType"],
        blob_filter_details: Optional["_models.BlobFilterDetails"] = None,
        azure_file_filter_details: Optional["_models.AzureFileFilterDetails"] = None,
        filter_file_details: Optional[List["_models.FilterFileDetails"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_account_type: Type of the account of data. Required. Known values are:
         "StorageAccount" and "ManagedDisk".
        :paramtype data_account_type: str or ~azure.mgmt.databox.v2022_02_01.models.DataAccountType
        :keyword blob_filter_details: Filter details to transfer blobs.
        :paramtype blob_filter_details: ~azure.mgmt.databox.v2022_02_01.models.BlobFilterDetails
        :keyword azure_file_filter_details: Filter details to transfer Azure files.
        :paramtype azure_file_filter_details:
         ~azure.mgmt.databox.v2022_02_01.models.AzureFileFilterDetails
        :keyword filter_file_details: Details of the filter files to be used for data transfer.
        :paramtype filter_file_details: list[~azure.mgmt.databox.v2022_02_01.models.FilterFileDetails]
        """
        super().__init__(**kwargs)
        self.data_account_type = data_account_type
        self.blob_filter_details = blob_filter_details
        self.azure_file_filter_details = azure_file_filter_details
        self.filter_file_details = filter_file_details


class TransportAvailabilityDetails(_serialization.Model):
    """Transport options availability details for given region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar shipment_type: Transport Shipment Type supported for given region. Known values are:
     "CustomerManaged" and "MicrosoftManaged".
    :vartype shipment_type: str or ~azure.mgmt.databox.v2022_02_01.models.TransportShipmentTypes
    """

    _validation = {
        "shipment_type": {"readonly": True},
    }

    _attribute_map = {
        "shipment_type": {"key": "shipmentType", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.shipment_type = None


class TransportAvailabilityRequest(_serialization.Model):
    """Request body to get the transport availability for given sku.

    :ivar sku_name: Type of the device. Known values are: "DataBox", "DataBoxDisk", "DataBoxHeavy",
     and "DataBoxCustomerDisk".
    :vartype sku_name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    """

    _attribute_map = {
        "sku_name": {"key": "skuName", "type": "str"},
    }

    def __init__(self, *, sku_name: Optional[Union[str, "_models.SkuName"]] = None, **kwargs: Any) -> None:
        """
        :keyword sku_name: Type of the device. Known values are: "DataBox", "DataBoxDisk",
         "DataBoxHeavy", and "DataBoxCustomerDisk".
        :paramtype sku_name: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
        """
        super().__init__(**kwargs)
        self.sku_name = sku_name


class TransportAvailabilityResponse(_serialization.Model):
    """Transport options available for given sku in a region.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar transport_availability_details: List of transport availability details for given region.
    :vartype transport_availability_details:
     list[~azure.mgmt.databox.v2022_02_01.models.TransportAvailabilityDetails]
    """

    _validation = {
        "transport_availability_details": {"readonly": True},
    }

    _attribute_map = {
        "transport_availability_details": {
            "key": "transportAvailabilityDetails",
            "type": "[TransportAvailabilityDetails]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.transport_availability_details = None


class TransportPreferences(_serialization.Model):
    """Preferences related to the shipment logistics of the sku.

    All required parameters must be populated in order to send to Azure.

    :ivar preferred_shipment_type: Indicates Shipment Logistics type that the customer preferred.
     Required. Known values are: "CustomerManaged" and "MicrosoftManaged".
    :vartype preferred_shipment_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.TransportShipmentTypes
    """

    _validation = {
        "preferred_shipment_type": {"required": True},
    }

    _attribute_map = {
        "preferred_shipment_type": {"key": "preferredShipmentType", "type": "str"},
    }

    def __init__(self, *, preferred_shipment_type: Union[str, "_models.TransportShipmentTypes"], **kwargs: Any) -> None:
        """
        :keyword preferred_shipment_type: Indicates Shipment Logistics type that the customer
         preferred. Required. Known values are: "CustomerManaged" and "MicrosoftManaged".
        :paramtype preferred_shipment_type: str or
         ~azure.mgmt.databox.v2022_02_01.models.TransportShipmentTypes
        """
        super().__init__(**kwargs)
        self.preferred_shipment_type = preferred_shipment_type


class UnencryptedCredentials(_serialization.Model):
    """Unencrypted credentials for accessing device.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar job_name: Name of the job.
    :vartype job_name: str
    :ivar job_secrets: Secrets related to this job.
    :vartype job_secrets: ~azure.mgmt.databox.v2022_02_01.models.JobSecrets
    """

    _validation = {
        "job_name": {"readonly": True},
        "job_secrets": {"readonly": True},
    }

    _attribute_map = {
        "job_name": {"key": "jobName", "type": "str"},
        "job_secrets": {"key": "jobSecrets", "type": "JobSecrets"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.job_name = None
        self.job_secrets = None


class UnencryptedCredentialsList(_serialization.Model):
    """List of unencrypted credentials for accessing device.

    :ivar value: List of unencrypted credentials.
    :vartype value: list[~azure.mgmt.databox.v2022_02_01.models.UnencryptedCredentials]
    :ivar next_link: Link for the next set of unencrypted credentials.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[UnencryptedCredentials]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.UnencryptedCredentials"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of unencrypted credentials.
        :paramtype value: list[~azure.mgmt.databox.v2022_02_01.models.UnencryptedCredentials]
        :keyword next_link: Link for the next set of unencrypted credentials.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateJobDetails(_serialization.Model):
    """Job details for update.

    :ivar contact_details: Contact details for notification and shipping.
    :vartype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
    :ivar shipping_address: Shipping address of the customer.
    :vartype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
    :ivar key_encryption_key: Key encryption key for the job.
    :vartype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
    :ivar return_to_customer_package_details: Return package details of job.
    :vartype return_to_customer_package_details:
     ~azure.mgmt.databox.v2022_02_01.models.PackageCarrierDetails
    """

    _attribute_map = {
        "contact_details": {"key": "contactDetails", "type": "ContactDetails"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "key_encryption_key": {"key": "keyEncryptionKey", "type": "KeyEncryptionKey"},
        "return_to_customer_package_details": {
            "key": "returnToCustomerPackageDetails",
            "type": "PackageCarrierDetails",
        },
    }

    def __init__(
        self,
        *,
        contact_details: Optional["_models.ContactDetails"] = None,
        shipping_address: Optional["_models.ShippingAddress"] = None,
        key_encryption_key: Optional["_models.KeyEncryptionKey"] = None,
        return_to_customer_package_details: Optional["_models.PackageCarrierDetails"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword contact_details: Contact details for notification and shipping.
        :paramtype contact_details: ~azure.mgmt.databox.v2022_02_01.models.ContactDetails
        :keyword shipping_address: Shipping address of the customer.
        :paramtype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
        :keyword key_encryption_key: Key encryption key for the job.
        :paramtype key_encryption_key: ~azure.mgmt.databox.v2022_02_01.models.KeyEncryptionKey
        :keyword return_to_customer_package_details: Return package details of job.
        :paramtype return_to_customer_package_details:
         ~azure.mgmt.databox.v2022_02_01.models.PackageCarrierDetails
        """
        super().__init__(**kwargs)
        self.contact_details = contact_details
        self.shipping_address = shipping_address
        self.key_encryption_key = key_encryption_key
        self.return_to_customer_package_details = return_to_customer_package_details


class UserAssignedIdentity(_serialization.Model):
    """Class defining User assigned identity details.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of user assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client id of user assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class UserAssignedProperties(_serialization.Model):
    """User assigned identity properties.

    :ivar resource_id: Arm resource id for user assigned identity to be used to fetch MSI token.
    :vartype resource_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword resource_id: Arm resource id for user assigned identity to be used to fetch MSI token.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id


class ValidateAddress(ValidationInputRequest):
    """The requirements to validate customer address where the device needs to be shipped.

    All required parameters must be populated in order to send to Azure.

    :ivar validation_type: Identifies the type of validation request. Required. Known values are:
     "ValidateAddress", "ValidateSubscriptionIsAllowedToCreateJob", "ValidatePreferences",
     "ValidateCreateOrderLimit", "ValidateSkuAvailability", and "ValidateDataTransferDetails".
    :vartype validation_type: str or
     ~azure.mgmt.databox.v2022_02_01.models.ValidationInputDiscriminator
    :ivar shipping_address: Shipping address of the customer. Required.
    :vartype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
    :ivar device_type: Device type to be used for the job. Required. Known values are: "DataBox",
     "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
    :vartype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
    :ivar transport_preferences: Preferences related to the shipment logistics of the sku.
    :vartype transport_preferences: ~azure.mgmt.databox.v2022_02_01.models.TransportPreferences
    """

    _validation = {
        "validation_type": {"required": True},
        "shipping_address": {"required": True},
        "device_type": {"required": True},
    }

    _attribute_map = {
        "validation_type": {"key": "validationType", "type": "str"},
        "shipping_address": {"key": "shippingAddress", "type": "ShippingAddress"},
        "device_type": {"key": "deviceType", "type": "str"},
        "transport_preferences": {"key": "transportPreferences", "type": "TransportPreferences"},
    }

    def __init__(
        self,
        *,
        shipping_address: "_models.ShippingAddress",
        device_type: Union[str, "_models.SkuName"],
        transport_preferences: Optional["_models.TransportPreferences"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword shipping_address: Shipping address of the customer. Required.
        :paramtype shipping_address: ~azure.mgmt.databox.v2022_02_01.models.ShippingAddress
        :keyword device_type: Device type to be used for the job. Required. Known values are:
         "DataBox", "DataBoxDisk", "DataBoxHeavy", and "DataBoxCustomerDisk".
        :paramtype device_type: str or ~azure.mgmt.databox.v2022_02_01.models.SkuName
        :keyword transport_preferences: Preferences related to the shipment logistics of the sku.
        :paramtype transport_preferences: ~azure.mgmt.databox.v2022_02_01.models.TransportPreferences
        """
        super().__init__(**kwargs)
        self.validation_type: str = "ValidateAddress"
        self.shipping_address = shipping_address
        self.device_type = device_type
        self.transport_preferences = transport_preferences


class ValidationResponse(_serialization.Model):
    """Response of pre job creation validations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: Overall validation status. Known values are: "AllValidToProceed",
     "InputsRevisitRequired", and "CertainInputValidationsSkipped".
    :vartype status: str or ~azure.mgmt.databox.v2022_02_01.models.OverallValidationStatus
    :ivar individual_response_details: List of response details contain validationType and its
     response as key and value respectively.
    :vartype individual_response_details:
     list[~azure.mgmt.databox.v2022_02_01.models.ValidationInputResponse]
    """

    _validation = {
        "status": {"readonly": True},
        "individual_response_details": {"readonly": True},
    }

    _attribute_map = {
        "status": {"key": "properties.status", "type": "str"},
        "individual_response_details": {
            "key": "properties.individualResponseDetails",
            "type": "[ValidationInputResponse]",
        },
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.status = None
        self.individual_response_details = None
