// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package redshiftserverless

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opConvertRecoveryPointToSnapshot = "ConvertRecoveryPointToSnapshot"

// ConvertRecoveryPointToSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the ConvertRecoveryPointToSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ConvertRecoveryPointToSnapshot for more information on using the ConvertRecoveryPointToSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ConvertRecoveryPointToSnapshotRequest method.
//	req, resp := client.ConvertRecoveryPointToSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot
func (c *RedshiftServerless) ConvertRecoveryPointToSnapshotRequest(input *ConvertRecoveryPointToSnapshotInput) (req *request.Request, output *ConvertRecoveryPointToSnapshotOutput) {
	op := &request.Operation{
		Name:       opConvertRecoveryPointToSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ConvertRecoveryPointToSnapshotInput{}
	}

	output = &ConvertRecoveryPointToSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ConvertRecoveryPointToSnapshot API operation for Redshift Serverless.
//
// Converts a recovery point to a snapshot. For more information about recovery
// points and snapshots, see Working with snapshots and recovery points (https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ConvertRecoveryPointToSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - TooManyTagsException
//     The request exceeded the number of tags allowed for a resource.
//
//   - ServiceQuotaExceededException
//     The service limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ConvertRecoveryPointToSnapshot
func (c *RedshiftServerless) ConvertRecoveryPointToSnapshot(input *ConvertRecoveryPointToSnapshotInput) (*ConvertRecoveryPointToSnapshotOutput, error) {
	req, out := c.ConvertRecoveryPointToSnapshotRequest(input)
	return out, req.Send()
}

// ConvertRecoveryPointToSnapshotWithContext is the same as ConvertRecoveryPointToSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See ConvertRecoveryPointToSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ConvertRecoveryPointToSnapshotWithContext(ctx aws.Context, input *ConvertRecoveryPointToSnapshotInput, opts ...request.Option) (*ConvertRecoveryPointToSnapshotOutput, error) {
	req, out := c.ConvertRecoveryPointToSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateCustomDomainAssociation = "CreateCustomDomainAssociation"

// CreateCustomDomainAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateCustomDomainAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateCustomDomainAssociation for more information on using the CreateCustomDomainAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateCustomDomainAssociationRequest method.
//	req, resp := client.CreateCustomDomainAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateCustomDomainAssociation
func (c *RedshiftServerless) CreateCustomDomainAssociationRequest(input *CreateCustomDomainAssociationInput) (req *request.Request, output *CreateCustomDomainAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateCustomDomainAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCustomDomainAssociationInput{}
	}

	output = &CreateCustomDomainAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateCustomDomainAssociation API operation for Redshift Serverless.
//
// Creates a custom domain association for Amazon Redshift Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation CreateCustomDomainAssociation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateCustomDomainAssociation
func (c *RedshiftServerless) CreateCustomDomainAssociation(input *CreateCustomDomainAssociationInput) (*CreateCustomDomainAssociationOutput, error) {
	req, out := c.CreateCustomDomainAssociationRequest(input)
	return out, req.Send()
}

// CreateCustomDomainAssociationWithContext is the same as CreateCustomDomainAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateCustomDomainAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) CreateCustomDomainAssociationWithContext(ctx aws.Context, input *CreateCustomDomainAssociationInput, opts ...request.Option) (*CreateCustomDomainAssociationOutput, error) {
	req, out := c.CreateCustomDomainAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEndpointAccess = "CreateEndpointAccess"

// CreateEndpointAccessRequest generates a "aws/request.Request" representing the
// client's request for the CreateEndpointAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEndpointAccess for more information on using the CreateEndpointAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEndpointAccessRequest method.
//	req, resp := client.CreateEndpointAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess
func (c *RedshiftServerless) CreateEndpointAccessRequest(input *CreateEndpointAccessInput) (req *request.Request, output *CreateEndpointAccessOutput) {
	op := &request.Operation{
		Name:       opCreateEndpointAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEndpointAccessInput{}
	}

	output = &CreateEndpointAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEndpointAccess API operation for Redshift Serverless.
//
// Creates an Amazon Redshift Serverless managed VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation CreateEndpointAccess for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ServiceQuotaExceededException
//     The service limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateEndpointAccess
func (c *RedshiftServerless) CreateEndpointAccess(input *CreateEndpointAccessInput) (*CreateEndpointAccessOutput, error) {
	req, out := c.CreateEndpointAccessRequest(input)
	return out, req.Send()
}

// CreateEndpointAccessWithContext is the same as CreateEndpointAccess with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEndpointAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) CreateEndpointAccessWithContext(ctx aws.Context, input *CreateEndpointAccessInput, opts ...request.Option) (*CreateEndpointAccessOutput, error) {
	req, out := c.CreateEndpointAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNamespace = "CreateNamespace"

// CreateNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateNamespace for more information on using the CreateNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateNamespaceRequest method.
//	req, resp := client.CreateNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace
func (c *RedshiftServerless) CreateNamespaceRequest(input *CreateNamespaceInput) (req *request.Request, output *CreateNamespaceOutput) {
	op := &request.Operation{
		Name:       opCreateNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNamespaceInput{}
	}

	output = &CreateNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateNamespace API operation for Redshift Serverless.
//
// Creates a namespace in Amazon Redshift Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation CreateNamespace for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - TooManyTagsException
//     The request exceeded the number of tags allowed for a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateNamespace
func (c *RedshiftServerless) CreateNamespace(input *CreateNamespaceInput) (*CreateNamespaceOutput, error) {
	req, out := c.CreateNamespaceRequest(input)
	return out, req.Send()
}

// CreateNamespaceWithContext is the same as CreateNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) CreateNamespaceWithContext(ctx aws.Context, input *CreateNamespaceInput, opts ...request.Option) (*CreateNamespaceOutput, error) {
	req, out := c.CreateNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateScheduledAction = "CreateScheduledAction"

// CreateScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the CreateScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateScheduledAction for more information on using the CreateScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateScheduledActionRequest method.
//	req, resp := client.CreateScheduledActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateScheduledAction
func (c *RedshiftServerless) CreateScheduledActionRequest(input *CreateScheduledActionInput) (req *request.Request, output *CreateScheduledActionOutput) {
	op := &request.Operation{
		Name:       opCreateScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateScheduledActionInput{}
	}

	output = &CreateScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateScheduledAction API operation for Redshift Serverless.
//
// Creates a scheduled action. A scheduled action contains a schedule and an
// Amazon Redshift API action. For example, you can create a schedule of when
// to run the CreateSnapshot API operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation CreateScheduledAction for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateScheduledAction
func (c *RedshiftServerless) CreateScheduledAction(input *CreateScheduledActionInput) (*CreateScheduledActionOutput, error) {
	req, out := c.CreateScheduledActionRequest(input)
	return out, req.Send()
}

// CreateScheduledActionWithContext is the same as CreateScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See CreateScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) CreateScheduledActionWithContext(ctx aws.Context, input *CreateScheduledActionInput, opts ...request.Option) (*CreateScheduledActionOutput, error) {
	req, out := c.CreateScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshot = "CreateSnapshot"

// CreateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshot for more information on using the CreateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSnapshotRequest method.
//	req, resp := client.CreateSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot
func (c *RedshiftServerless) CreateSnapshotRequest(input *CreateSnapshotInput) (req *request.Request, output *CreateSnapshotOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotInput{}
	}

	output = &CreateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshot API operation for Redshift Serverless.
//
// Creates a snapshot of all databases in a namespace. For more information
// about snapshots, see Working with snapshots and recovery points (https://docs.aws.amazon.com/redshift/latest/mgmt/serverless-snapshots-recovery.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation CreateSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - TooManyTagsException
//     The request exceeded the number of tags allowed for a resource.
//
//   - ServiceQuotaExceededException
//     The service limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshot
func (c *RedshiftServerless) CreateSnapshot(input *CreateSnapshotInput) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	return out, req.Send()
}

// CreateSnapshotWithContext is the same as CreateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) CreateSnapshotWithContext(ctx aws.Context, input *CreateSnapshotInput, opts ...request.Option) (*CreateSnapshotOutput, error) {
	req, out := c.CreateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSnapshotCopyConfiguration = "CreateSnapshotCopyConfiguration"

// CreateSnapshotCopyConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the CreateSnapshotCopyConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSnapshotCopyConfiguration for more information on using the CreateSnapshotCopyConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSnapshotCopyConfigurationRequest method.
//	req, resp := client.CreateSnapshotCopyConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshotCopyConfiguration
func (c *RedshiftServerless) CreateSnapshotCopyConfigurationRequest(input *CreateSnapshotCopyConfigurationInput) (req *request.Request, output *CreateSnapshotCopyConfigurationOutput) {
	op := &request.Operation{
		Name:       opCreateSnapshotCopyConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSnapshotCopyConfigurationInput{}
	}

	output = &CreateSnapshotCopyConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSnapshotCopyConfiguration API operation for Redshift Serverless.
//
// Creates a snapshot copy configuration that lets you copy snapshots to another
// Amazon Web Services Region.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation CreateSnapshotCopyConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ServiceQuotaExceededException
//     The service limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateSnapshotCopyConfiguration
func (c *RedshiftServerless) CreateSnapshotCopyConfiguration(input *CreateSnapshotCopyConfigurationInput) (*CreateSnapshotCopyConfigurationOutput, error) {
	req, out := c.CreateSnapshotCopyConfigurationRequest(input)
	return out, req.Send()
}

// CreateSnapshotCopyConfigurationWithContext is the same as CreateSnapshotCopyConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSnapshotCopyConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) CreateSnapshotCopyConfigurationWithContext(ctx aws.Context, input *CreateSnapshotCopyConfigurationInput, opts ...request.Option) (*CreateSnapshotCopyConfigurationOutput, error) {
	req, out := c.CreateSnapshotCopyConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUsageLimit = "CreateUsageLimit"

// CreateUsageLimitRequest generates a "aws/request.Request" representing the
// client's request for the CreateUsageLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUsageLimit for more information on using the CreateUsageLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUsageLimitRequest method.
//	req, resp := client.CreateUsageLimitRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit
func (c *RedshiftServerless) CreateUsageLimitRequest(input *CreateUsageLimitInput) (req *request.Request, output *CreateUsageLimitOutput) {
	op := &request.Operation{
		Name:       opCreateUsageLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUsageLimitInput{}
	}

	output = &CreateUsageLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUsageLimit API operation for Redshift Serverless.
//
// Creates a usage limit for a specified Amazon Redshift Serverless usage type.
// The usage limit is identified by the returned usage limit identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation CreateUsageLimit for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - ServiceQuotaExceededException
//     The service limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateUsageLimit
func (c *RedshiftServerless) CreateUsageLimit(input *CreateUsageLimitInput) (*CreateUsageLimitOutput, error) {
	req, out := c.CreateUsageLimitRequest(input)
	return out, req.Send()
}

// CreateUsageLimitWithContext is the same as CreateUsageLimit with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUsageLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) CreateUsageLimitWithContext(ctx aws.Context, input *CreateUsageLimitInput, opts ...request.Option) (*CreateUsageLimitOutput, error) {
	req, out := c.CreateUsageLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkgroup = "CreateWorkgroup"

// CreateWorkgroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkgroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkgroup for more information on using the CreateWorkgroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateWorkgroupRequest method.
//	req, resp := client.CreateWorkgroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup
func (c *RedshiftServerless) CreateWorkgroupRequest(input *CreateWorkgroupInput) (req *request.Request, output *CreateWorkgroupOutput) {
	op := &request.Operation{
		Name:       opCreateWorkgroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkgroupInput{}
	}

	output = &CreateWorkgroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkgroup API operation for Redshift Serverless.
//
// Creates an workgroup in Amazon Redshift Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation CreateWorkgroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - InsufficientCapacityException
//     There is an insufficient capacity to perform the action.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - TooManyTagsException
//     The request exceeded the number of tags allowed for a resource.
//
//   - Ipv6CidrBlockNotFoundException
//     There are no subnets in your VPC with associated IPv6 CIDR blocks. To use
//     dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/CreateWorkgroup
func (c *RedshiftServerless) CreateWorkgroup(input *CreateWorkgroupInput) (*CreateWorkgroupOutput, error) {
	req, out := c.CreateWorkgroupRequest(input)
	return out, req.Send()
}

// CreateWorkgroupWithContext is the same as CreateWorkgroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkgroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) CreateWorkgroupWithContext(ctx aws.Context, input *CreateWorkgroupInput, opts ...request.Option) (*CreateWorkgroupOutput, error) {
	req, out := c.CreateWorkgroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteCustomDomainAssociation = "DeleteCustomDomainAssociation"

// DeleteCustomDomainAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteCustomDomainAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteCustomDomainAssociation for more information on using the DeleteCustomDomainAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteCustomDomainAssociationRequest method.
//	req, resp := client.DeleteCustomDomainAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteCustomDomainAssociation
func (c *RedshiftServerless) DeleteCustomDomainAssociationRequest(input *DeleteCustomDomainAssociationInput) (req *request.Request, output *DeleteCustomDomainAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteCustomDomainAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteCustomDomainAssociationInput{}
	}

	output = &DeleteCustomDomainAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteCustomDomainAssociation API operation for Redshift Serverless.
//
// Deletes a custom domain association for Amazon Redshift Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation DeleteCustomDomainAssociation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteCustomDomainAssociation
func (c *RedshiftServerless) DeleteCustomDomainAssociation(input *DeleteCustomDomainAssociationInput) (*DeleteCustomDomainAssociationOutput, error) {
	req, out := c.DeleteCustomDomainAssociationRequest(input)
	return out, req.Send()
}

// DeleteCustomDomainAssociationWithContext is the same as DeleteCustomDomainAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteCustomDomainAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) DeleteCustomDomainAssociationWithContext(ctx aws.Context, input *DeleteCustomDomainAssociationInput, opts ...request.Option) (*DeleteCustomDomainAssociationOutput, error) {
	req, out := c.DeleteCustomDomainAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEndpointAccess = "DeleteEndpointAccess"

// DeleteEndpointAccessRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEndpointAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEndpointAccess for more information on using the DeleteEndpointAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEndpointAccessRequest method.
//	req, resp := client.DeleteEndpointAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess
func (c *RedshiftServerless) DeleteEndpointAccessRequest(input *DeleteEndpointAccessInput) (req *request.Request, output *DeleteEndpointAccessOutput) {
	op := &request.Operation{
		Name:       opDeleteEndpointAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteEndpointAccessInput{}
	}

	output = &DeleteEndpointAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteEndpointAccess API operation for Redshift Serverless.
//
// Deletes an Amazon Redshift Serverless managed VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation DeleteEndpointAccess for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteEndpointAccess
func (c *RedshiftServerless) DeleteEndpointAccess(input *DeleteEndpointAccessInput) (*DeleteEndpointAccessOutput, error) {
	req, out := c.DeleteEndpointAccessRequest(input)
	return out, req.Send()
}

// DeleteEndpointAccessWithContext is the same as DeleteEndpointAccess with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEndpointAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) DeleteEndpointAccessWithContext(ctx aws.Context, input *DeleteEndpointAccessInput, opts ...request.Option) (*DeleteEndpointAccessOutput, error) {
	req, out := c.DeleteEndpointAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteNamespace = "DeleteNamespace"

// DeleteNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteNamespace for more information on using the DeleteNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteNamespaceRequest method.
//	req, resp := client.DeleteNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace
func (c *RedshiftServerless) DeleteNamespaceRequest(input *DeleteNamespaceInput) (req *request.Request, output *DeleteNamespaceOutput) {
	op := &request.Operation{
		Name:       opDeleteNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteNamespaceInput{}
	}

	output = &DeleteNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteNamespace API operation for Redshift Serverless.
//
// Deletes a namespace from Amazon Redshift Serverless. Before you delete the
// namespace, you can create a final snapshot that has all of the data within
// the namespace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation DeleteNamespace for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteNamespace
func (c *RedshiftServerless) DeleteNamespace(input *DeleteNamespaceInput) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	return out, req.Send()
}

// DeleteNamespaceWithContext is the same as DeleteNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) DeleteNamespaceWithContext(ctx aws.Context, input *DeleteNamespaceInput, opts ...request.Option) (*DeleteNamespaceOutput, error) {
	req, out := c.DeleteNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteResourcePolicy = "DeleteResourcePolicy"

// DeleteResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteResourcePolicy for more information on using the DeleteResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteResourcePolicyRequest method.
//	req, resp := client.DeleteResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy
func (c *RedshiftServerless) DeleteResourcePolicyRequest(input *DeleteResourcePolicyInput) (req *request.Request, output *DeleteResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opDeleteResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteResourcePolicyInput{}
	}

	output = &DeleteResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteResourcePolicy API operation for Redshift Serverless.
//
// Deletes the specified resource policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation DeleteResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteResourcePolicy
func (c *RedshiftServerless) DeleteResourcePolicy(input *DeleteResourcePolicyInput) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	return out, req.Send()
}

// DeleteResourcePolicyWithContext is the same as DeleteResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) DeleteResourcePolicyWithContext(ctx aws.Context, input *DeleteResourcePolicyInput, opts ...request.Option) (*DeleteResourcePolicyOutput, error) {
	req, out := c.DeleteResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteScheduledAction = "DeleteScheduledAction"

// DeleteScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the DeleteScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteScheduledAction for more information on using the DeleteScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteScheduledActionRequest method.
//	req, resp := client.DeleteScheduledActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteScheduledAction
func (c *RedshiftServerless) DeleteScheduledActionRequest(input *DeleteScheduledActionInput) (req *request.Request, output *DeleteScheduledActionOutput) {
	op := &request.Operation{
		Name:       opDeleteScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteScheduledActionInput{}
	}

	output = &DeleteScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteScheduledAction API operation for Redshift Serverless.
//
// Deletes a scheduled action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation DeleteScheduledAction for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteScheduledAction
func (c *RedshiftServerless) DeleteScheduledAction(input *DeleteScheduledActionInput) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	return out, req.Send()
}

// DeleteScheduledActionWithContext is the same as DeleteScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) DeleteScheduledActionWithContext(ctx aws.Context, input *DeleteScheduledActionInput, opts ...request.Option) (*DeleteScheduledActionOutput, error) {
	req, out := c.DeleteScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshot = "DeleteSnapshot"

// DeleteSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshot for more information on using the DeleteSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSnapshotRequest method.
//	req, resp := client.DeleteSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot
func (c *RedshiftServerless) DeleteSnapshotRequest(input *DeleteSnapshotInput) (req *request.Request, output *DeleteSnapshotOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotInput{}
	}

	output = &DeleteSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSnapshot API operation for Redshift Serverless.
//
// Deletes a snapshot from Amazon Redshift Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation DeleteSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshot
func (c *RedshiftServerless) DeleteSnapshot(input *DeleteSnapshotInput) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	return out, req.Send()
}

// DeleteSnapshotWithContext is the same as DeleteSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) DeleteSnapshotWithContext(ctx aws.Context, input *DeleteSnapshotInput, opts ...request.Option) (*DeleteSnapshotOutput, error) {
	req, out := c.DeleteSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSnapshotCopyConfiguration = "DeleteSnapshotCopyConfiguration"

// DeleteSnapshotCopyConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSnapshotCopyConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSnapshotCopyConfiguration for more information on using the DeleteSnapshotCopyConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSnapshotCopyConfigurationRequest method.
//	req, resp := client.DeleteSnapshotCopyConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshotCopyConfiguration
func (c *RedshiftServerless) DeleteSnapshotCopyConfigurationRequest(input *DeleteSnapshotCopyConfigurationInput) (req *request.Request, output *DeleteSnapshotCopyConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteSnapshotCopyConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSnapshotCopyConfigurationInput{}
	}

	output = &DeleteSnapshotCopyConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSnapshotCopyConfiguration API operation for Redshift Serverless.
//
// # Deletes a snapshot copy configuration
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation DeleteSnapshotCopyConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteSnapshotCopyConfiguration
func (c *RedshiftServerless) DeleteSnapshotCopyConfiguration(input *DeleteSnapshotCopyConfigurationInput) (*DeleteSnapshotCopyConfigurationOutput, error) {
	req, out := c.DeleteSnapshotCopyConfigurationRequest(input)
	return out, req.Send()
}

// DeleteSnapshotCopyConfigurationWithContext is the same as DeleteSnapshotCopyConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSnapshotCopyConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) DeleteSnapshotCopyConfigurationWithContext(ctx aws.Context, input *DeleteSnapshotCopyConfigurationInput, opts ...request.Option) (*DeleteSnapshotCopyConfigurationOutput, error) {
	req, out := c.DeleteSnapshotCopyConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUsageLimit = "DeleteUsageLimit"

// DeleteUsageLimitRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUsageLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUsageLimit for more information on using the DeleteUsageLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUsageLimitRequest method.
//	req, resp := client.DeleteUsageLimitRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit
func (c *RedshiftServerless) DeleteUsageLimitRequest(input *DeleteUsageLimitInput) (req *request.Request, output *DeleteUsageLimitOutput) {
	op := &request.Operation{
		Name:       opDeleteUsageLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteUsageLimitInput{}
	}

	output = &DeleteUsageLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteUsageLimit API operation for Redshift Serverless.
//
// Deletes a usage limit from Amazon Redshift Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation DeleteUsageLimit for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteUsageLimit
func (c *RedshiftServerless) DeleteUsageLimit(input *DeleteUsageLimitInput) (*DeleteUsageLimitOutput, error) {
	req, out := c.DeleteUsageLimitRequest(input)
	return out, req.Send()
}

// DeleteUsageLimitWithContext is the same as DeleteUsageLimit with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUsageLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) DeleteUsageLimitWithContext(ctx aws.Context, input *DeleteUsageLimitInput, opts ...request.Option) (*DeleteUsageLimitOutput, error) {
	req, out := c.DeleteUsageLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkgroup = "DeleteWorkgroup"

// DeleteWorkgroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkgroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkgroup for more information on using the DeleteWorkgroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteWorkgroupRequest method.
//	req, resp := client.DeleteWorkgroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup
func (c *RedshiftServerless) DeleteWorkgroupRequest(input *DeleteWorkgroupInput) (req *request.Request, output *DeleteWorkgroupOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkgroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkgroupInput{}
	}

	output = &DeleteWorkgroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWorkgroup API operation for Redshift Serverless.
//
// Deletes a workgroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation DeleteWorkgroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/DeleteWorkgroup
func (c *RedshiftServerless) DeleteWorkgroup(input *DeleteWorkgroupInput) (*DeleteWorkgroupOutput, error) {
	req, out := c.DeleteWorkgroupRequest(input)
	return out, req.Send()
}

// DeleteWorkgroupWithContext is the same as DeleteWorkgroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkgroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) DeleteWorkgroupWithContext(ctx aws.Context, input *DeleteWorkgroupInput, opts ...request.Option) (*DeleteWorkgroupOutput, error) {
	req, out := c.DeleteWorkgroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCredentials = "GetCredentials"

// GetCredentialsRequest generates a "aws/request.Request" representing the
// client's request for the GetCredentials operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCredentials for more information on using the GetCredentials
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCredentialsRequest method.
//	req, resp := client.GetCredentialsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials
func (c *RedshiftServerless) GetCredentialsRequest(input *GetCredentialsInput) (req *request.Request, output *GetCredentialsOutput) {
	op := &request.Operation{
		Name:       opGetCredentials,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCredentialsInput{}
	}

	output = &GetCredentialsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCredentials API operation for Redshift Serverless.
//
// Returns a database user name and temporary password with temporary authorization
// to log in to Amazon Redshift Serverless.
//
// By default, the temporary credentials expire in 900 seconds. You can optionally
// specify a duration between 900 seconds (15 minutes) and 3600 seconds (60
// minutes).
//
//	<p>The Identity and Access Management (IAM) user or role that runs GetCredentials
//	must have an IAM policy attached that allows access to all necessary actions
//	and resources.</p> <p>If the <code>DbName</code> parameter is specified,
//	the IAM policy must allow access to the resource dbname for the specified
//	database name.</p>
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetCredentials for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCredentials
func (c *RedshiftServerless) GetCredentials(input *GetCredentialsInput) (*GetCredentialsOutput, error) {
	req, out := c.GetCredentialsRequest(input)
	return out, req.Send()
}

// GetCredentialsWithContext is the same as GetCredentials with the addition of
// the ability to pass a context and additional request options.
//
// See GetCredentials for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetCredentialsWithContext(ctx aws.Context, input *GetCredentialsInput, opts ...request.Option) (*GetCredentialsOutput, error) {
	req, out := c.GetCredentialsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCustomDomainAssociation = "GetCustomDomainAssociation"

// GetCustomDomainAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetCustomDomainAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCustomDomainAssociation for more information on using the GetCustomDomainAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCustomDomainAssociationRequest method.
//	req, resp := client.GetCustomDomainAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCustomDomainAssociation
func (c *RedshiftServerless) GetCustomDomainAssociationRequest(input *GetCustomDomainAssociationInput) (req *request.Request, output *GetCustomDomainAssociationOutput) {
	op := &request.Operation{
		Name:       opGetCustomDomainAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetCustomDomainAssociationInput{}
	}

	output = &GetCustomDomainAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCustomDomainAssociation API operation for Redshift Serverless.
//
// Gets information about a specific custom domain association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetCustomDomainAssociation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetCustomDomainAssociation
func (c *RedshiftServerless) GetCustomDomainAssociation(input *GetCustomDomainAssociationInput) (*GetCustomDomainAssociationOutput, error) {
	req, out := c.GetCustomDomainAssociationRequest(input)
	return out, req.Send()
}

// GetCustomDomainAssociationWithContext is the same as GetCustomDomainAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetCustomDomainAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetCustomDomainAssociationWithContext(ctx aws.Context, input *GetCustomDomainAssociationInput, opts ...request.Option) (*GetCustomDomainAssociationOutput, error) {
	req, out := c.GetCustomDomainAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEndpointAccess = "GetEndpointAccess"

// GetEndpointAccessRequest generates a "aws/request.Request" representing the
// client's request for the GetEndpointAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEndpointAccess for more information on using the GetEndpointAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetEndpointAccessRequest method.
//	req, resp := client.GetEndpointAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess
func (c *RedshiftServerless) GetEndpointAccessRequest(input *GetEndpointAccessInput) (req *request.Request, output *GetEndpointAccessOutput) {
	op := &request.Operation{
		Name:       opGetEndpointAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEndpointAccessInput{}
	}

	output = &GetEndpointAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEndpointAccess API operation for Redshift Serverless.
//
// Returns information, such as the name, about a VPC endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetEndpointAccess for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetEndpointAccess
func (c *RedshiftServerless) GetEndpointAccess(input *GetEndpointAccessInput) (*GetEndpointAccessOutput, error) {
	req, out := c.GetEndpointAccessRequest(input)
	return out, req.Send()
}

// GetEndpointAccessWithContext is the same as GetEndpointAccess with the addition of
// the ability to pass a context and additional request options.
//
// See GetEndpointAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetEndpointAccessWithContext(ctx aws.Context, input *GetEndpointAccessInput, opts ...request.Option) (*GetEndpointAccessOutput, error) {
	req, out := c.GetEndpointAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetNamespace = "GetNamespace"

// GetNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the GetNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetNamespace for more information on using the GetNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetNamespaceRequest method.
//	req, resp := client.GetNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace
func (c *RedshiftServerless) GetNamespaceRequest(input *GetNamespaceInput) (req *request.Request, output *GetNamespaceOutput) {
	op := &request.Operation{
		Name:       opGetNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetNamespaceInput{}
	}

	output = &GetNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetNamespace API operation for Redshift Serverless.
//
// Returns information about a namespace in Amazon Redshift Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetNamespace for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetNamespace
func (c *RedshiftServerless) GetNamespace(input *GetNamespaceInput) (*GetNamespaceOutput, error) {
	req, out := c.GetNamespaceRequest(input)
	return out, req.Send()
}

// GetNamespaceWithContext is the same as GetNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See GetNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetNamespaceWithContext(ctx aws.Context, input *GetNamespaceInput, opts ...request.Option) (*GetNamespaceOutput, error) {
	req, out := c.GetNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRecoveryPoint = "GetRecoveryPoint"

// GetRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the GetRecoveryPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRecoveryPoint for more information on using the GetRecoveryPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetRecoveryPointRequest method.
//	req, resp := client.GetRecoveryPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint
func (c *RedshiftServerless) GetRecoveryPointRequest(input *GetRecoveryPointInput) (req *request.Request, output *GetRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opGetRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRecoveryPointInput{}
	}

	output = &GetRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRecoveryPoint API operation for Redshift Serverless.
//
// Returns information about a recovery point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetRecoveryPoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetRecoveryPoint
func (c *RedshiftServerless) GetRecoveryPoint(input *GetRecoveryPointInput) (*GetRecoveryPointOutput, error) {
	req, out := c.GetRecoveryPointRequest(input)
	return out, req.Send()
}

// GetRecoveryPointWithContext is the same as GetRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See GetRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetRecoveryPointWithContext(ctx aws.Context, input *GetRecoveryPointInput, opts ...request.Option) (*GetRecoveryPointOutput, error) {
	req, out := c.GetRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourcePolicy = "GetResourcePolicy"

// GetResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetResourcePolicy for more information on using the GetResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetResourcePolicyRequest method.
//	req, resp := client.GetResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy
func (c *RedshiftServerless) GetResourcePolicyRequest(input *GetResourcePolicyInput) (req *request.Request, output *GetResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opGetResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourcePolicyInput{}
	}

	output = &GetResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetResourcePolicy API operation for Redshift Serverless.
//
// Returns a resource policy.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetResourcePolicy
func (c *RedshiftServerless) GetResourcePolicy(input *GetResourcePolicyInput) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	return out, req.Send()
}

// GetResourcePolicyWithContext is the same as GetResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetResourcePolicyWithContext(ctx aws.Context, input *GetResourcePolicyInput, opts ...request.Option) (*GetResourcePolicyOutput, error) {
	req, out := c.GetResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetScheduledAction = "GetScheduledAction"

// GetScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the GetScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetScheduledAction for more information on using the GetScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetScheduledActionRequest method.
//	req, resp := client.GetScheduledActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetScheduledAction
func (c *RedshiftServerless) GetScheduledActionRequest(input *GetScheduledActionInput) (req *request.Request, output *GetScheduledActionOutput) {
	op := &request.Operation{
		Name:       opGetScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetScheduledActionInput{}
	}

	output = &GetScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetScheduledAction API operation for Redshift Serverless.
//
// Returns information about a scheduled action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetScheduledAction for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetScheduledAction
func (c *RedshiftServerless) GetScheduledAction(input *GetScheduledActionInput) (*GetScheduledActionOutput, error) {
	req, out := c.GetScheduledActionRequest(input)
	return out, req.Send()
}

// GetScheduledActionWithContext is the same as GetScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See GetScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetScheduledActionWithContext(ctx aws.Context, input *GetScheduledActionInput, opts ...request.Option) (*GetScheduledActionOutput, error) {
	req, out := c.GetScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSnapshot = "GetSnapshot"

// GetSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the GetSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSnapshot for more information on using the GetSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetSnapshotRequest method.
//	req, resp := client.GetSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot
func (c *RedshiftServerless) GetSnapshotRequest(input *GetSnapshotInput) (req *request.Request, output *GetSnapshotOutput) {
	op := &request.Operation{
		Name:       opGetSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSnapshotInput{}
	}

	output = &GetSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSnapshot API operation for Redshift Serverless.
//
// Returns information about a specific snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetSnapshot
func (c *RedshiftServerless) GetSnapshot(input *GetSnapshotInput) (*GetSnapshotOutput, error) {
	req, out := c.GetSnapshotRequest(input)
	return out, req.Send()
}

// GetSnapshotWithContext is the same as GetSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See GetSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetSnapshotWithContext(ctx aws.Context, input *GetSnapshotInput, opts ...request.Option) (*GetSnapshotOutput, error) {
	req, out := c.GetSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTableRestoreStatus = "GetTableRestoreStatus"

// GetTableRestoreStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetTableRestoreStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTableRestoreStatus for more information on using the GetTableRestoreStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTableRestoreStatusRequest method.
//	req, resp := client.GetTableRestoreStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus
func (c *RedshiftServerless) GetTableRestoreStatusRequest(input *GetTableRestoreStatusInput) (req *request.Request, output *GetTableRestoreStatusOutput) {
	op := &request.Operation{
		Name:       opGetTableRestoreStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetTableRestoreStatusInput{}
	}

	output = &GetTableRestoreStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTableRestoreStatus API operation for Redshift Serverless.
//
// Returns information about a TableRestoreStatus object.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetTableRestoreStatus for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetTableRestoreStatus
func (c *RedshiftServerless) GetTableRestoreStatus(input *GetTableRestoreStatusInput) (*GetTableRestoreStatusOutput, error) {
	req, out := c.GetTableRestoreStatusRequest(input)
	return out, req.Send()
}

// GetTableRestoreStatusWithContext is the same as GetTableRestoreStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetTableRestoreStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetTableRestoreStatusWithContext(ctx aws.Context, input *GetTableRestoreStatusInput, opts ...request.Option) (*GetTableRestoreStatusOutput, error) {
	req, out := c.GetTableRestoreStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetUsageLimit = "GetUsageLimit"

// GetUsageLimitRequest generates a "aws/request.Request" representing the
// client's request for the GetUsageLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetUsageLimit for more information on using the GetUsageLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetUsageLimitRequest method.
//	req, resp := client.GetUsageLimitRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit
func (c *RedshiftServerless) GetUsageLimitRequest(input *GetUsageLimitInput) (req *request.Request, output *GetUsageLimitOutput) {
	op := &request.Operation{
		Name:       opGetUsageLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetUsageLimitInput{}
	}

	output = &GetUsageLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetUsageLimit API operation for Redshift Serverless.
//
// Returns information about a usage limit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetUsageLimit for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetUsageLimit
func (c *RedshiftServerless) GetUsageLimit(input *GetUsageLimitInput) (*GetUsageLimitOutput, error) {
	req, out := c.GetUsageLimitRequest(input)
	return out, req.Send()
}

// GetUsageLimitWithContext is the same as GetUsageLimit with the addition of
// the ability to pass a context and additional request options.
//
// See GetUsageLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetUsageLimitWithContext(ctx aws.Context, input *GetUsageLimitInput, opts ...request.Option) (*GetUsageLimitOutput, error) {
	req, out := c.GetUsageLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWorkgroup = "GetWorkgroup"

// GetWorkgroupRequest generates a "aws/request.Request" representing the
// client's request for the GetWorkgroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWorkgroup for more information on using the GetWorkgroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetWorkgroupRequest method.
//	req, resp := client.GetWorkgroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup
func (c *RedshiftServerless) GetWorkgroupRequest(input *GetWorkgroupInput) (req *request.Request, output *GetWorkgroupOutput) {
	op := &request.Operation{
		Name:       opGetWorkgroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWorkgroupInput{}
	}

	output = &GetWorkgroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWorkgroup API operation for Redshift Serverless.
//
// Returns information about a specific workgroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation GetWorkgroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/GetWorkgroup
func (c *RedshiftServerless) GetWorkgroup(input *GetWorkgroupInput) (*GetWorkgroupOutput, error) {
	req, out := c.GetWorkgroupRequest(input)
	return out, req.Send()
}

// GetWorkgroupWithContext is the same as GetWorkgroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetWorkgroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) GetWorkgroupWithContext(ctx aws.Context, input *GetWorkgroupInput, opts ...request.Option) (*GetWorkgroupOutput, error) {
	req, out := c.GetWorkgroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListCustomDomainAssociations = "ListCustomDomainAssociations"

// ListCustomDomainAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListCustomDomainAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListCustomDomainAssociations for more information on using the ListCustomDomainAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListCustomDomainAssociationsRequest method.
//	req, resp := client.ListCustomDomainAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations
func (c *RedshiftServerless) ListCustomDomainAssociationsRequest(input *ListCustomDomainAssociationsInput) (req *request.Request, output *ListCustomDomainAssociationsOutput) {
	op := &request.Operation{
		Name:       opListCustomDomainAssociations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListCustomDomainAssociationsInput{}
	}

	output = &ListCustomDomainAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListCustomDomainAssociations API operation for Redshift Serverless.
//
// Lists custom domain associations for Amazon Redshift Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListCustomDomainAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - InvalidPaginationException
//     The provided pagination token is invalid.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListCustomDomainAssociations
func (c *RedshiftServerless) ListCustomDomainAssociations(input *ListCustomDomainAssociationsInput) (*ListCustomDomainAssociationsOutput, error) {
	req, out := c.ListCustomDomainAssociationsRequest(input)
	return out, req.Send()
}

// ListCustomDomainAssociationsWithContext is the same as ListCustomDomainAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListCustomDomainAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListCustomDomainAssociationsWithContext(ctx aws.Context, input *ListCustomDomainAssociationsInput, opts ...request.Option) (*ListCustomDomainAssociationsOutput, error) {
	req, out := c.ListCustomDomainAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListCustomDomainAssociationsPages iterates over the pages of a ListCustomDomainAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListCustomDomainAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListCustomDomainAssociations operation.
//	pageNum := 0
//	err := client.ListCustomDomainAssociationsPages(params,
//	    func(page *redshiftserverless.ListCustomDomainAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListCustomDomainAssociationsPages(input *ListCustomDomainAssociationsInput, fn func(*ListCustomDomainAssociationsOutput, bool) bool) error {
	return c.ListCustomDomainAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListCustomDomainAssociationsPagesWithContext same as ListCustomDomainAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListCustomDomainAssociationsPagesWithContext(ctx aws.Context, input *ListCustomDomainAssociationsInput, fn func(*ListCustomDomainAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListCustomDomainAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListCustomDomainAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListCustomDomainAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEndpointAccess = "ListEndpointAccess"

// ListEndpointAccessRequest generates a "aws/request.Request" representing the
// client's request for the ListEndpointAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEndpointAccess for more information on using the ListEndpointAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEndpointAccessRequest method.
//	req, resp := client.ListEndpointAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess
func (c *RedshiftServerless) ListEndpointAccessRequest(input *ListEndpointAccessInput) (req *request.Request, output *ListEndpointAccessOutput) {
	op := &request.Operation{
		Name:       opListEndpointAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEndpointAccessInput{}
	}

	output = &ListEndpointAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEndpointAccess API operation for Redshift Serverless.
//
// Returns an array of EndpointAccess objects and relevant information.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListEndpointAccess for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListEndpointAccess
func (c *RedshiftServerless) ListEndpointAccess(input *ListEndpointAccessInput) (*ListEndpointAccessOutput, error) {
	req, out := c.ListEndpointAccessRequest(input)
	return out, req.Send()
}

// ListEndpointAccessWithContext is the same as ListEndpointAccess with the addition of
// the ability to pass a context and additional request options.
//
// See ListEndpointAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListEndpointAccessWithContext(ctx aws.Context, input *ListEndpointAccessInput, opts ...request.Option) (*ListEndpointAccessOutput, error) {
	req, out := c.ListEndpointAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEndpointAccessPages iterates over the pages of a ListEndpointAccess operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEndpointAccess method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEndpointAccess operation.
//	pageNum := 0
//	err := client.ListEndpointAccessPages(params,
//	    func(page *redshiftserverless.ListEndpointAccessOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListEndpointAccessPages(input *ListEndpointAccessInput, fn func(*ListEndpointAccessOutput, bool) bool) error {
	return c.ListEndpointAccessPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEndpointAccessPagesWithContext same as ListEndpointAccessPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListEndpointAccessPagesWithContext(ctx aws.Context, input *ListEndpointAccessInput, fn func(*ListEndpointAccessOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEndpointAccessInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEndpointAccessRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEndpointAccessOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListNamespaces = "ListNamespaces"

// ListNamespacesRequest generates a "aws/request.Request" representing the
// client's request for the ListNamespaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListNamespaces for more information on using the ListNamespaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListNamespacesRequest method.
//	req, resp := client.ListNamespacesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces
func (c *RedshiftServerless) ListNamespacesRequest(input *ListNamespacesInput) (req *request.Request, output *ListNamespacesOutput) {
	op := &request.Operation{
		Name:       opListNamespaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListNamespacesInput{}
	}

	output = &ListNamespacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListNamespaces API operation for Redshift Serverless.
//
// Returns information about a list of specified namespaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListNamespaces for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListNamespaces
func (c *RedshiftServerless) ListNamespaces(input *ListNamespacesInput) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	return out, req.Send()
}

// ListNamespacesWithContext is the same as ListNamespaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListNamespaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListNamespacesWithContext(ctx aws.Context, input *ListNamespacesInput, opts ...request.Option) (*ListNamespacesOutput, error) {
	req, out := c.ListNamespacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListNamespacesPages iterates over the pages of a ListNamespaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListNamespaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListNamespaces operation.
//	pageNum := 0
//	err := client.ListNamespacesPages(params,
//	    func(page *redshiftserverless.ListNamespacesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListNamespacesPages(input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool) error {
	return c.ListNamespacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListNamespacesPagesWithContext same as ListNamespacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListNamespacesPagesWithContext(ctx aws.Context, input *ListNamespacesInput, fn func(*ListNamespacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListNamespacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListNamespacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListNamespacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRecoveryPoints = "ListRecoveryPoints"

// ListRecoveryPointsRequest generates a "aws/request.Request" representing the
// client's request for the ListRecoveryPoints operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRecoveryPoints for more information on using the ListRecoveryPoints
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRecoveryPointsRequest method.
//	req, resp := client.ListRecoveryPointsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints
func (c *RedshiftServerless) ListRecoveryPointsRequest(input *ListRecoveryPointsInput) (req *request.Request, output *ListRecoveryPointsOutput) {
	op := &request.Operation{
		Name:       opListRecoveryPoints,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRecoveryPointsInput{}
	}

	output = &ListRecoveryPointsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRecoveryPoints API operation for Redshift Serverless.
//
// Returns an array of recovery points.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListRecoveryPoints for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListRecoveryPoints
func (c *RedshiftServerless) ListRecoveryPoints(input *ListRecoveryPointsInput) (*ListRecoveryPointsOutput, error) {
	req, out := c.ListRecoveryPointsRequest(input)
	return out, req.Send()
}

// ListRecoveryPointsWithContext is the same as ListRecoveryPoints with the addition of
// the ability to pass a context and additional request options.
//
// See ListRecoveryPoints for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListRecoveryPointsWithContext(ctx aws.Context, input *ListRecoveryPointsInput, opts ...request.Option) (*ListRecoveryPointsOutput, error) {
	req, out := c.ListRecoveryPointsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRecoveryPointsPages iterates over the pages of a ListRecoveryPoints operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRecoveryPoints method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRecoveryPoints operation.
//	pageNum := 0
//	err := client.ListRecoveryPointsPages(params,
//	    func(page *redshiftserverless.ListRecoveryPointsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListRecoveryPointsPages(input *ListRecoveryPointsInput, fn func(*ListRecoveryPointsOutput, bool) bool) error {
	return c.ListRecoveryPointsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRecoveryPointsPagesWithContext same as ListRecoveryPointsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListRecoveryPointsPagesWithContext(ctx aws.Context, input *ListRecoveryPointsInput, fn func(*ListRecoveryPointsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRecoveryPointsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRecoveryPointsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRecoveryPointsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListScheduledActions = "ListScheduledActions"

// ListScheduledActionsRequest generates a "aws/request.Request" representing the
// client's request for the ListScheduledActions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListScheduledActions for more information on using the ListScheduledActions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListScheduledActionsRequest method.
//	req, resp := client.ListScheduledActionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListScheduledActions
func (c *RedshiftServerless) ListScheduledActionsRequest(input *ListScheduledActionsInput) (req *request.Request, output *ListScheduledActionsOutput) {
	op := &request.Operation{
		Name:       opListScheduledActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListScheduledActionsInput{}
	}

	output = &ListScheduledActionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListScheduledActions API operation for Redshift Serverless.
//
// Returns a list of scheduled actions. You can use the flags to filter the
// list of returned scheduled actions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListScheduledActions for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - InvalidPaginationException
//     The provided pagination token is invalid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListScheduledActions
func (c *RedshiftServerless) ListScheduledActions(input *ListScheduledActionsInput) (*ListScheduledActionsOutput, error) {
	req, out := c.ListScheduledActionsRequest(input)
	return out, req.Send()
}

// ListScheduledActionsWithContext is the same as ListScheduledActions with the addition of
// the ability to pass a context and additional request options.
//
// See ListScheduledActions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListScheduledActionsWithContext(ctx aws.Context, input *ListScheduledActionsInput, opts ...request.Option) (*ListScheduledActionsOutput, error) {
	req, out := c.ListScheduledActionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListScheduledActionsPages iterates over the pages of a ListScheduledActions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListScheduledActions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListScheduledActions operation.
//	pageNum := 0
//	err := client.ListScheduledActionsPages(params,
//	    func(page *redshiftserverless.ListScheduledActionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListScheduledActionsPages(input *ListScheduledActionsInput, fn func(*ListScheduledActionsOutput, bool) bool) error {
	return c.ListScheduledActionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListScheduledActionsPagesWithContext same as ListScheduledActionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListScheduledActionsPagesWithContext(ctx aws.Context, input *ListScheduledActionsInput, fn func(*ListScheduledActionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListScheduledActionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListScheduledActionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListScheduledActionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSnapshotCopyConfigurations = "ListSnapshotCopyConfigurations"

// ListSnapshotCopyConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListSnapshotCopyConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSnapshotCopyConfigurations for more information on using the ListSnapshotCopyConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSnapshotCopyConfigurationsRequest method.
//	req, resp := client.ListSnapshotCopyConfigurationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshotCopyConfigurations
func (c *RedshiftServerless) ListSnapshotCopyConfigurationsRequest(input *ListSnapshotCopyConfigurationsInput) (req *request.Request, output *ListSnapshotCopyConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListSnapshotCopyConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSnapshotCopyConfigurationsInput{}
	}

	output = &ListSnapshotCopyConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSnapshotCopyConfigurations API operation for Redshift Serverless.
//
// Returns a list of snapshot copy configurations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListSnapshotCopyConfigurations for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - InvalidPaginationException
//     The provided pagination token is invalid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshotCopyConfigurations
func (c *RedshiftServerless) ListSnapshotCopyConfigurations(input *ListSnapshotCopyConfigurationsInput) (*ListSnapshotCopyConfigurationsOutput, error) {
	req, out := c.ListSnapshotCopyConfigurationsRequest(input)
	return out, req.Send()
}

// ListSnapshotCopyConfigurationsWithContext is the same as ListSnapshotCopyConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListSnapshotCopyConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListSnapshotCopyConfigurationsWithContext(ctx aws.Context, input *ListSnapshotCopyConfigurationsInput, opts ...request.Option) (*ListSnapshotCopyConfigurationsOutput, error) {
	req, out := c.ListSnapshotCopyConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSnapshotCopyConfigurationsPages iterates over the pages of a ListSnapshotCopyConfigurations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSnapshotCopyConfigurations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSnapshotCopyConfigurations operation.
//	pageNum := 0
//	err := client.ListSnapshotCopyConfigurationsPages(params,
//	    func(page *redshiftserverless.ListSnapshotCopyConfigurationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListSnapshotCopyConfigurationsPages(input *ListSnapshotCopyConfigurationsInput, fn func(*ListSnapshotCopyConfigurationsOutput, bool) bool) error {
	return c.ListSnapshotCopyConfigurationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSnapshotCopyConfigurationsPagesWithContext same as ListSnapshotCopyConfigurationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListSnapshotCopyConfigurationsPagesWithContext(ctx aws.Context, input *ListSnapshotCopyConfigurationsInput, fn func(*ListSnapshotCopyConfigurationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSnapshotCopyConfigurationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSnapshotCopyConfigurationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSnapshotCopyConfigurationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSnapshots = "ListSnapshots"

// ListSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the ListSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSnapshots for more information on using the ListSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSnapshotsRequest method.
//	req, resp := client.ListSnapshotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots
func (c *RedshiftServerless) ListSnapshotsRequest(input *ListSnapshotsInput) (req *request.Request, output *ListSnapshotsOutput) {
	op := &request.Operation{
		Name:       opListSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSnapshotsInput{}
	}

	output = &ListSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSnapshots API operation for Redshift Serverless.
//
// Returns a list of snapshots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListSnapshots for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListSnapshots
func (c *RedshiftServerless) ListSnapshots(input *ListSnapshotsInput) (*ListSnapshotsOutput, error) {
	req, out := c.ListSnapshotsRequest(input)
	return out, req.Send()
}

// ListSnapshotsWithContext is the same as ListSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See ListSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListSnapshotsWithContext(ctx aws.Context, input *ListSnapshotsInput, opts ...request.Option) (*ListSnapshotsOutput, error) {
	req, out := c.ListSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSnapshotsPages iterates over the pages of a ListSnapshots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSnapshots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSnapshots operation.
//	pageNum := 0
//	err := client.ListSnapshotsPages(params,
//	    func(page *redshiftserverless.ListSnapshotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListSnapshotsPages(input *ListSnapshotsInput, fn func(*ListSnapshotsOutput, bool) bool) error {
	return c.ListSnapshotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSnapshotsPagesWithContext same as ListSnapshotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListSnapshotsPagesWithContext(ctx aws.Context, input *ListSnapshotsInput, fn func(*ListSnapshotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSnapshotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSnapshotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSnapshotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTableRestoreStatus = "ListTableRestoreStatus"

// ListTableRestoreStatusRequest generates a "aws/request.Request" representing the
// client's request for the ListTableRestoreStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTableRestoreStatus for more information on using the ListTableRestoreStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTableRestoreStatusRequest method.
//	req, resp := client.ListTableRestoreStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus
func (c *RedshiftServerless) ListTableRestoreStatusRequest(input *ListTableRestoreStatusInput) (req *request.Request, output *ListTableRestoreStatusOutput) {
	op := &request.Operation{
		Name:       opListTableRestoreStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTableRestoreStatusInput{}
	}

	output = &ListTableRestoreStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTableRestoreStatus API operation for Redshift Serverless.
//
// Returns information about an array of TableRestoreStatus objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListTableRestoreStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidPaginationException
//     The provided pagination token is invalid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTableRestoreStatus
func (c *RedshiftServerless) ListTableRestoreStatus(input *ListTableRestoreStatusInput) (*ListTableRestoreStatusOutput, error) {
	req, out := c.ListTableRestoreStatusRequest(input)
	return out, req.Send()
}

// ListTableRestoreStatusWithContext is the same as ListTableRestoreStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ListTableRestoreStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListTableRestoreStatusWithContext(ctx aws.Context, input *ListTableRestoreStatusInput, opts ...request.Option) (*ListTableRestoreStatusOutput, error) {
	req, out := c.ListTableRestoreStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTableRestoreStatusPages iterates over the pages of a ListTableRestoreStatus operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTableRestoreStatus method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTableRestoreStatus operation.
//	pageNum := 0
//	err := client.ListTableRestoreStatusPages(params,
//	    func(page *redshiftserverless.ListTableRestoreStatusOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListTableRestoreStatusPages(input *ListTableRestoreStatusInput, fn func(*ListTableRestoreStatusOutput, bool) bool) error {
	return c.ListTableRestoreStatusPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTableRestoreStatusPagesWithContext same as ListTableRestoreStatusPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListTableRestoreStatusPagesWithContext(ctx aws.Context, input *ListTableRestoreStatusInput, fn func(*ListTableRestoreStatusOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTableRestoreStatusInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTableRestoreStatusRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTableRestoreStatusOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource
func (c *RedshiftServerless) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Redshift Serverless.
//
// Lists the tags assigned to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListTagsForResource
func (c *RedshiftServerless) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListUsageLimits = "ListUsageLimits"

// ListUsageLimitsRequest generates a "aws/request.Request" representing the
// client's request for the ListUsageLimits operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsageLimits for more information on using the ListUsageLimits
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUsageLimitsRequest method.
//	req, resp := client.ListUsageLimitsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits
func (c *RedshiftServerless) ListUsageLimitsRequest(input *ListUsageLimitsInput) (req *request.Request, output *ListUsageLimitsOutput) {
	op := &request.Operation{
		Name:       opListUsageLimits,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsageLimitsInput{}
	}

	output = &ListUsageLimitsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsageLimits API operation for Redshift Serverless.
//
// Lists all usage limits within Amazon Redshift Serverless.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListUsageLimits for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - InvalidPaginationException
//     The provided pagination token is invalid.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListUsageLimits
func (c *RedshiftServerless) ListUsageLimits(input *ListUsageLimitsInput) (*ListUsageLimitsOutput, error) {
	req, out := c.ListUsageLimitsRequest(input)
	return out, req.Send()
}

// ListUsageLimitsWithContext is the same as ListUsageLimits with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsageLimits for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListUsageLimitsWithContext(ctx aws.Context, input *ListUsageLimitsInput, opts ...request.Option) (*ListUsageLimitsOutput, error) {
	req, out := c.ListUsageLimitsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsageLimitsPages iterates over the pages of a ListUsageLimits operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsageLimits method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUsageLimits operation.
//	pageNum := 0
//	err := client.ListUsageLimitsPages(params,
//	    func(page *redshiftserverless.ListUsageLimitsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListUsageLimitsPages(input *ListUsageLimitsInput, fn func(*ListUsageLimitsOutput, bool) bool) error {
	return c.ListUsageLimitsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsageLimitsPagesWithContext same as ListUsageLimitsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListUsageLimitsPagesWithContext(ctx aws.Context, input *ListUsageLimitsInput, fn func(*ListUsageLimitsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsageLimitsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsageLimitsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsageLimitsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListWorkgroups = "ListWorkgroups"

// ListWorkgroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkgroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkgroups for more information on using the ListWorkgroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListWorkgroupsRequest method.
//	req, resp := client.ListWorkgroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups
func (c *RedshiftServerless) ListWorkgroupsRequest(input *ListWorkgroupsInput) (req *request.Request, output *ListWorkgroupsOutput) {
	op := &request.Operation{
		Name:       opListWorkgroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkgroupsInput{}
	}

	output = &ListWorkgroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkgroups API operation for Redshift Serverless.
//
// Returns information about a list of specified workgroups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation ListWorkgroups for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/ListWorkgroups
func (c *RedshiftServerless) ListWorkgroups(input *ListWorkgroupsInput) (*ListWorkgroupsOutput, error) {
	req, out := c.ListWorkgroupsRequest(input)
	return out, req.Send()
}

// ListWorkgroupsWithContext is the same as ListWorkgroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkgroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListWorkgroupsWithContext(ctx aws.Context, input *ListWorkgroupsInput, opts ...request.Option) (*ListWorkgroupsOutput, error) {
	req, out := c.ListWorkgroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkgroupsPages iterates over the pages of a ListWorkgroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkgroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListWorkgroups operation.
//	pageNum := 0
//	err := client.ListWorkgroupsPages(params,
//	    func(page *redshiftserverless.ListWorkgroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *RedshiftServerless) ListWorkgroupsPages(input *ListWorkgroupsInput, fn func(*ListWorkgroupsOutput, bool) bool) error {
	return c.ListWorkgroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkgroupsPagesWithContext same as ListWorkgroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) ListWorkgroupsPagesWithContext(ctx aws.Context, input *ListWorkgroupsInput, fn func(*ListWorkgroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkgroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkgroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkgroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opPutResourcePolicy = "PutResourcePolicy"

// PutResourcePolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutResourcePolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutResourcePolicy for more information on using the PutResourcePolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutResourcePolicyRequest method.
//	req, resp := client.PutResourcePolicyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy
func (c *RedshiftServerless) PutResourcePolicyRequest(input *PutResourcePolicyInput) (req *request.Request, output *PutResourcePolicyOutput) {
	op := &request.Operation{
		Name:       opPutResourcePolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutResourcePolicyInput{}
	}

	output = &PutResourcePolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutResourcePolicy API operation for Redshift Serverless.
//
// Creates or updates a resource policy. Currently, you can use policies to
// share snapshots across Amazon Web Services accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation PutResourcePolicy for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - ServiceQuotaExceededException
//     The service limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/PutResourcePolicy
func (c *RedshiftServerless) PutResourcePolicy(input *PutResourcePolicyInput) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	return out, req.Send()
}

// PutResourcePolicyWithContext is the same as PutResourcePolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutResourcePolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) PutResourcePolicyWithContext(ctx aws.Context, input *PutResourcePolicyInput, opts ...request.Option) (*PutResourcePolicyOutput, error) {
	req, out := c.PutResourcePolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreFromRecoveryPoint = "RestoreFromRecoveryPoint"

// RestoreFromRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the RestoreFromRecoveryPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreFromRecoveryPoint for more information on using the RestoreFromRecoveryPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreFromRecoveryPointRequest method.
//	req, resp := client.RestoreFromRecoveryPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint
func (c *RedshiftServerless) RestoreFromRecoveryPointRequest(input *RestoreFromRecoveryPointInput) (req *request.Request, output *RestoreFromRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opRestoreFromRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreFromRecoveryPointInput{}
	}

	output = &RestoreFromRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreFromRecoveryPoint API operation for Redshift Serverless.
//
// Restore the data from a recovery point.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation RestoreFromRecoveryPoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromRecoveryPoint
func (c *RedshiftServerless) RestoreFromRecoveryPoint(input *RestoreFromRecoveryPointInput) (*RestoreFromRecoveryPointOutput, error) {
	req, out := c.RestoreFromRecoveryPointRequest(input)
	return out, req.Send()
}

// RestoreFromRecoveryPointWithContext is the same as RestoreFromRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreFromRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) RestoreFromRecoveryPointWithContext(ctx aws.Context, input *RestoreFromRecoveryPointInput, opts ...request.Option) (*RestoreFromRecoveryPointOutput, error) {
	req, out := c.RestoreFromRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreFromSnapshot = "RestoreFromSnapshot"

// RestoreFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreFromSnapshot for more information on using the RestoreFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreFromSnapshotRequest method.
//	req, resp := client.RestoreFromSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot
func (c *RedshiftServerless) RestoreFromSnapshotRequest(input *RestoreFromSnapshotInput) (req *request.Request, output *RestoreFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreFromSnapshotInput{}
	}

	output = &RestoreFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreFromSnapshot API operation for Redshift Serverless.
//
// Restores a namespace from a snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation RestoreFromSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - ServiceQuotaExceededException
//     The service limit was exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreFromSnapshot
func (c *RedshiftServerless) RestoreFromSnapshot(input *RestoreFromSnapshotInput) (*RestoreFromSnapshotOutput, error) {
	req, out := c.RestoreFromSnapshotRequest(input)
	return out, req.Send()
}

// RestoreFromSnapshotWithContext is the same as RestoreFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) RestoreFromSnapshotWithContext(ctx aws.Context, input *RestoreFromSnapshotInput, opts ...request.Option) (*RestoreFromSnapshotOutput, error) {
	req, out := c.RestoreFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreTableFromRecoveryPoint = "RestoreTableFromRecoveryPoint"

// RestoreTableFromRecoveryPointRequest generates a "aws/request.Request" representing the
// client's request for the RestoreTableFromRecoveryPoint operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreTableFromRecoveryPoint for more information on using the RestoreTableFromRecoveryPoint
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreTableFromRecoveryPointRequest method.
//	req, resp := client.RestoreTableFromRecoveryPointRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromRecoveryPoint
func (c *RedshiftServerless) RestoreTableFromRecoveryPointRequest(input *RestoreTableFromRecoveryPointInput) (req *request.Request, output *RestoreTableFromRecoveryPointOutput) {
	op := &request.Operation{
		Name:       opRestoreTableFromRecoveryPoint,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableFromRecoveryPointInput{}
	}

	output = &RestoreTableFromRecoveryPointOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreTableFromRecoveryPoint API operation for Redshift Serverless.
//
// Restores a table from a recovery point to your Amazon Redshift Serverless
// instance. You can't use this operation to restore tables with interleaved
// sort keys.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation RestoreTableFromRecoveryPoint for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromRecoveryPoint
func (c *RedshiftServerless) RestoreTableFromRecoveryPoint(input *RestoreTableFromRecoveryPointInput) (*RestoreTableFromRecoveryPointOutput, error) {
	req, out := c.RestoreTableFromRecoveryPointRequest(input)
	return out, req.Send()
}

// RestoreTableFromRecoveryPointWithContext is the same as RestoreTableFromRecoveryPoint with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreTableFromRecoveryPoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) RestoreTableFromRecoveryPointWithContext(ctx aws.Context, input *RestoreTableFromRecoveryPointInput, opts ...request.Option) (*RestoreTableFromRecoveryPointOutput, error) {
	req, out := c.RestoreTableFromRecoveryPointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreTableFromSnapshot = "RestoreTableFromSnapshot"

// RestoreTableFromSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the RestoreTableFromSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreTableFromSnapshot for more information on using the RestoreTableFromSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the RestoreTableFromSnapshotRequest method.
//	req, resp := client.RestoreTableFromSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot
func (c *RedshiftServerless) RestoreTableFromSnapshotRequest(input *RestoreTableFromSnapshotInput) (req *request.Request, output *RestoreTableFromSnapshotOutput) {
	op := &request.Operation{
		Name:       opRestoreTableFromSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreTableFromSnapshotInput{}
	}

	output = &RestoreTableFromSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RestoreTableFromSnapshot API operation for Redshift Serverless.
//
// Restores a table from a snapshot to your Amazon Redshift Serverless instance.
// You can't use this operation to restore tables with interleaved sort keys
// (https://docs.aws.amazon.com/redshift/latest/dg/t_Sorting_data.html#t_Sorting_data-interleaved).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation RestoreTableFromSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/RestoreTableFromSnapshot
func (c *RedshiftServerless) RestoreTableFromSnapshot(input *RestoreTableFromSnapshotInput) (*RestoreTableFromSnapshotOutput, error) {
	req, out := c.RestoreTableFromSnapshotRequest(input)
	return out, req.Send()
}

// RestoreTableFromSnapshotWithContext is the same as RestoreTableFromSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreTableFromSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) RestoreTableFromSnapshotWithContext(ctx aws.Context, input *RestoreTableFromSnapshotInput, opts ...request.Option) (*RestoreTableFromSnapshotOutput, error) {
	req, out := c.RestoreTableFromSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource
func (c *RedshiftServerless) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Redshift Serverless.
//
// Assigns one or more tags to a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - TooManyTagsException
//     The request exceeded the number of tags allowed for a resource.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/TagResource
func (c *RedshiftServerless) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource
func (c *RedshiftServerless) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Redshift Serverless.
//
// Removes a tag or set of tags from a resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UntagResource
func (c *RedshiftServerless) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateCustomDomainAssociation = "UpdateCustomDomainAssociation"

// UpdateCustomDomainAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateCustomDomainAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateCustomDomainAssociation for more information on using the UpdateCustomDomainAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateCustomDomainAssociationRequest method.
//	req, resp := client.UpdateCustomDomainAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateCustomDomainAssociation
func (c *RedshiftServerless) UpdateCustomDomainAssociationRequest(input *UpdateCustomDomainAssociationInput) (req *request.Request, output *UpdateCustomDomainAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateCustomDomainAssociation,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCustomDomainAssociationInput{}
	}

	output = &UpdateCustomDomainAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateCustomDomainAssociation API operation for Redshift Serverless.
//
// Updates an Amazon Redshift Serverless certificate associated with a custom
// domain.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation UpdateCustomDomainAssociation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
//   - ThrottlingException
//     The request was denied due to request throttling.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateCustomDomainAssociation
func (c *RedshiftServerless) UpdateCustomDomainAssociation(input *UpdateCustomDomainAssociationInput) (*UpdateCustomDomainAssociationOutput, error) {
	req, out := c.UpdateCustomDomainAssociationRequest(input)
	return out, req.Send()
}

// UpdateCustomDomainAssociationWithContext is the same as UpdateCustomDomainAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateCustomDomainAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) UpdateCustomDomainAssociationWithContext(ctx aws.Context, input *UpdateCustomDomainAssociationInput, opts ...request.Option) (*UpdateCustomDomainAssociationOutput, error) {
	req, out := c.UpdateCustomDomainAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEndpointAccess = "UpdateEndpointAccess"

// UpdateEndpointAccessRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEndpointAccess operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEndpointAccess for more information on using the UpdateEndpointAccess
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEndpointAccessRequest method.
//	req, resp := client.UpdateEndpointAccessRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess
func (c *RedshiftServerless) UpdateEndpointAccessRequest(input *UpdateEndpointAccessInput) (req *request.Request, output *UpdateEndpointAccessOutput) {
	op := &request.Operation{
		Name:       opUpdateEndpointAccess,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateEndpointAccessInput{}
	}

	output = &UpdateEndpointAccessOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEndpointAccess API operation for Redshift Serverless.
//
// Updates an Amazon Redshift Serverless managed endpoint.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation UpdateEndpointAccess for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateEndpointAccess
func (c *RedshiftServerless) UpdateEndpointAccess(input *UpdateEndpointAccessInput) (*UpdateEndpointAccessOutput, error) {
	req, out := c.UpdateEndpointAccessRequest(input)
	return out, req.Send()
}

// UpdateEndpointAccessWithContext is the same as UpdateEndpointAccess with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEndpointAccess for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) UpdateEndpointAccessWithContext(ctx aws.Context, input *UpdateEndpointAccessInput, opts ...request.Option) (*UpdateEndpointAccessOutput, error) {
	req, out := c.UpdateEndpointAccessRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNamespace = "UpdateNamespace"

// UpdateNamespaceRequest generates a "aws/request.Request" representing the
// client's request for the UpdateNamespace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateNamespace for more information on using the UpdateNamespace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateNamespaceRequest method.
//	req, resp := client.UpdateNamespaceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace
func (c *RedshiftServerless) UpdateNamespaceRequest(input *UpdateNamespaceInput) (req *request.Request, output *UpdateNamespaceOutput) {
	op := &request.Operation{
		Name:       opUpdateNamespace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNamespaceInput{}
	}

	output = &UpdateNamespaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateNamespace API operation for Redshift Serverless.
//
// Updates a namespace with the specified settings. Unless required, you can't
// update multiple parameters in one request. For example, you must specify
// both adminUsername and adminUserPassword to update either field, but you
// can't update both kmsKeyId and logExports in a single request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation UpdateNamespace for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateNamespace
func (c *RedshiftServerless) UpdateNamespace(input *UpdateNamespaceInput) (*UpdateNamespaceOutput, error) {
	req, out := c.UpdateNamespaceRequest(input)
	return out, req.Send()
}

// UpdateNamespaceWithContext is the same as UpdateNamespace with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNamespace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) UpdateNamespaceWithContext(ctx aws.Context, input *UpdateNamespaceInput, opts ...request.Option) (*UpdateNamespaceOutput, error) {
	req, out := c.UpdateNamespaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateScheduledAction = "UpdateScheduledAction"

// UpdateScheduledActionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateScheduledAction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateScheduledAction for more information on using the UpdateScheduledAction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateScheduledActionRequest method.
//	req, resp := client.UpdateScheduledActionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateScheduledAction
func (c *RedshiftServerless) UpdateScheduledActionRequest(input *UpdateScheduledActionInput) (req *request.Request, output *UpdateScheduledActionOutput) {
	op := &request.Operation{
		Name:       opUpdateScheduledAction,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateScheduledActionInput{}
	}

	output = &UpdateScheduledActionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateScheduledAction API operation for Redshift Serverless.
//
// Updates a scheduled action.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation UpdateScheduledAction for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateScheduledAction
func (c *RedshiftServerless) UpdateScheduledAction(input *UpdateScheduledActionInput) (*UpdateScheduledActionOutput, error) {
	req, out := c.UpdateScheduledActionRequest(input)
	return out, req.Send()
}

// UpdateScheduledActionWithContext is the same as UpdateScheduledAction with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateScheduledAction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) UpdateScheduledActionWithContext(ctx aws.Context, input *UpdateScheduledActionInput, opts ...request.Option) (*UpdateScheduledActionOutput, error) {
	req, out := c.UpdateScheduledActionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSnapshot = "UpdateSnapshot"

// UpdateSnapshotRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSnapshot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSnapshot for more information on using the UpdateSnapshot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSnapshotRequest method.
//	req, resp := client.UpdateSnapshotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot
func (c *RedshiftServerless) UpdateSnapshotRequest(input *UpdateSnapshotInput) (req *request.Request, output *UpdateSnapshotOutput) {
	op := &request.Operation{
		Name:       opUpdateSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSnapshotInput{}
	}

	output = &UpdateSnapshotOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSnapshot API operation for Redshift Serverless.
//
// Updates a snapshot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation UpdateSnapshot for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshot
func (c *RedshiftServerless) UpdateSnapshot(input *UpdateSnapshotInput) (*UpdateSnapshotOutput, error) {
	req, out := c.UpdateSnapshotRequest(input)
	return out, req.Send()
}

// UpdateSnapshotWithContext is the same as UpdateSnapshot with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSnapshot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) UpdateSnapshotWithContext(ctx aws.Context, input *UpdateSnapshotInput, opts ...request.Option) (*UpdateSnapshotOutput, error) {
	req, out := c.UpdateSnapshotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSnapshotCopyConfiguration = "UpdateSnapshotCopyConfiguration"

// UpdateSnapshotCopyConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSnapshotCopyConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSnapshotCopyConfiguration for more information on using the UpdateSnapshotCopyConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSnapshotCopyConfigurationRequest method.
//	req, resp := client.UpdateSnapshotCopyConfigurationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshotCopyConfiguration
func (c *RedshiftServerless) UpdateSnapshotCopyConfigurationRequest(input *UpdateSnapshotCopyConfigurationInput) (req *request.Request, output *UpdateSnapshotCopyConfigurationOutput) {
	op := &request.Operation{
		Name:       opUpdateSnapshotCopyConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSnapshotCopyConfigurationInput{}
	}

	output = &UpdateSnapshotCopyConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSnapshotCopyConfiguration API operation for Redshift Serverless.
//
// Updates a snapshot copy configuration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation UpdateSnapshotCopyConfiguration for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - AccessDeniedException
//     You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateSnapshotCopyConfiguration
func (c *RedshiftServerless) UpdateSnapshotCopyConfiguration(input *UpdateSnapshotCopyConfigurationInput) (*UpdateSnapshotCopyConfigurationOutput, error) {
	req, out := c.UpdateSnapshotCopyConfigurationRequest(input)
	return out, req.Send()
}

// UpdateSnapshotCopyConfigurationWithContext is the same as UpdateSnapshotCopyConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSnapshotCopyConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) UpdateSnapshotCopyConfigurationWithContext(ctx aws.Context, input *UpdateSnapshotCopyConfigurationInput, opts ...request.Option) (*UpdateSnapshotCopyConfigurationOutput, error) {
	req, out := c.UpdateSnapshotCopyConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUsageLimit = "UpdateUsageLimit"

// UpdateUsageLimitRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUsageLimit operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUsageLimit for more information on using the UpdateUsageLimit
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUsageLimitRequest method.
//	req, resp := client.UpdateUsageLimitRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit
func (c *RedshiftServerless) UpdateUsageLimitRequest(input *UpdateUsageLimitInput) (req *request.Request, output *UpdateUsageLimitOutput) {
	op := &request.Operation{
		Name:       opUpdateUsageLimit,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateUsageLimitInput{}
	}

	output = &UpdateUsageLimitOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateUsageLimit API operation for Redshift Serverless.
//
// Update a usage limit in Amazon Redshift Serverless. You can't update the
// usage type or period of a usage limit.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation UpdateUsageLimit for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateUsageLimit
func (c *RedshiftServerless) UpdateUsageLimit(input *UpdateUsageLimitInput) (*UpdateUsageLimitOutput, error) {
	req, out := c.UpdateUsageLimitRequest(input)
	return out, req.Send()
}

// UpdateUsageLimitWithContext is the same as UpdateUsageLimit with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUsageLimit for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) UpdateUsageLimitWithContext(ctx aws.Context, input *UpdateUsageLimitInput, opts ...request.Option) (*UpdateUsageLimitOutput, error) {
	req, out := c.UpdateUsageLimitRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkgroup = "UpdateWorkgroup"

// UpdateWorkgroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkgroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkgroup for more information on using the UpdateWorkgroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateWorkgroupRequest method.
//	req, resp := client.UpdateWorkgroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup
func (c *RedshiftServerless) UpdateWorkgroupRequest(input *UpdateWorkgroupInput) (req *request.Request, output *UpdateWorkgroupOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkgroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkgroupInput{}
	}

	output = &UpdateWorkgroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWorkgroup API operation for Redshift Serverless.
//
// Updates a workgroup with the specified configuration settings. You can't
// update multiple parameters in one request. For example, you can update baseCapacity
// or port in a single request, but you can't update both in the same request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Redshift Serverless's
// API operation UpdateWorkgroup for usage and error information.
//
// Returned Error Types:
//
//   - InternalServerException
//     The request processing has failed because of an unknown error, exception
//     or failure.
//
//   - InsufficientCapacityException
//     There is an insufficient capacity to perform the action.
//
//   - ResourceNotFoundException
//     The resource could not be found.
//
//   - ConflictException
//     The submitted action has conflicts.
//
//   - ValidationException
//     The input failed to satisfy the constraints specified by an AWS service.
//
//   - Ipv6CidrBlockNotFoundException
//     There are no subnets in your VPC with associated IPv6 CIDR blocks. To use
//     dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/UpdateWorkgroup
func (c *RedshiftServerless) UpdateWorkgroup(input *UpdateWorkgroupInput) (*UpdateWorkgroupOutput, error) {
	req, out := c.UpdateWorkgroupRequest(input)
	return out, req.Send()
}

// UpdateWorkgroupWithContext is the same as UpdateWorkgroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkgroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *RedshiftServerless) UpdateWorkgroupWithContext(ctx aws.Context, input *UpdateWorkgroupInput, opts ...request.Option) (*UpdateWorkgroupOutput, error) {
	req, out := c.UpdateWorkgroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that represents the custom domain name association.
type Association struct {
	_ struct{} `type:"structure"`

	// The custom domain name’s certificate Amazon resource name (ARN).
	CustomDomainCertificateArn *string `locationName:"customDomainCertificateArn" min:"20" type:"string"`

	// The expiration time for the certificate.
	CustomDomainCertificateExpiryTime *time.Time `locationName:"customDomainCertificateExpiryTime" type:"timestamp" timestampFormat:"iso8601"`

	// The custom domain name associated with the workgroup.
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string"`

	// The name of the workgroup associated with the database.
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Association) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Association) GoString() string {
	return s.String()
}

// SetCustomDomainCertificateArn sets the CustomDomainCertificateArn field's value.
func (s *Association) SetCustomDomainCertificateArn(v string) *Association {
	s.CustomDomainCertificateArn = &v
	return s
}

// SetCustomDomainCertificateExpiryTime sets the CustomDomainCertificateExpiryTime field's value.
func (s *Association) SetCustomDomainCertificateExpiryTime(v time.Time) *Association {
	s.CustomDomainCertificateExpiryTime = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *Association) SetCustomDomainName(v string) *Association {
	s.CustomDomainName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *Association) SetWorkgroupName(v string) *Association {
	s.WorkgroupName = &v
	return s
}

// An array of key-value pairs to set for advanced control over Amazon Redshift
// Serverless.
type ConfigParameter struct {
	_ struct{} `type:"structure"`

	// The key of the parameter. The options are auto_mv, datestyle, enable_case_sensitive_identifier,
	// enable_user_activity_logging, query_group, search_path, require_ssl, use_fips_ssl,
	// and query monitoring metrics that let you define performance boundaries.
	// For more information about query monitoring rules and available metrics,
	// see Query monitoring metrics for Amazon Redshift Serverless (https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless).
	ParameterKey *string `locationName:"parameterKey" type:"string"`

	// The value of the parameter to set.
	ParameterValue *string `locationName:"parameterValue" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigParameter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConfigParameter) GoString() string {
	return s.String()
}

// SetParameterKey sets the ParameterKey field's value.
func (s *ConfigParameter) SetParameterKey(v string) *ConfigParameter {
	s.ParameterKey = &v
	return s
}

// SetParameterValue sets the ParameterValue field's value.
func (s *ConfigParameter) SetParameterValue(v string) *ConfigParameter {
	s.ParameterValue = &v
	return s
}

// The submitted action has conflicts.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ConvertRecoveryPointToSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the recovery point.
	//
	// RecoveryPointId is a required field
	RecoveryPointId *string `locationName:"recoveryPointId" type:"string" required:"true"`

	// How long to retain the snapshot.
	RetentionPeriod *int64 `locationName:"retentionPeriod" type:"integer"`

	// The name of the snapshot.
	//
	// SnapshotName is a required field
	SnapshotName *string `locationName:"snapshotName" type:"string" required:"true"`

	// An array of Tag objects (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html)
	// to associate with the created snapshot.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConvertRecoveryPointToSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConvertRecoveryPointToSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConvertRecoveryPointToSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConvertRecoveryPointToSnapshotInput"}
	if s.RecoveryPointId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointId"))
	}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryPointId sets the RecoveryPointId field's value.
func (s *ConvertRecoveryPointToSnapshotInput) SetRecoveryPointId(v string) *ConvertRecoveryPointToSnapshotInput {
	s.RecoveryPointId = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *ConvertRecoveryPointToSnapshotInput) SetRetentionPeriod(v int64) *ConvertRecoveryPointToSnapshotInput {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *ConvertRecoveryPointToSnapshotInput) SetSnapshotName(v string) *ConvertRecoveryPointToSnapshotInput {
	s.SnapshotName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ConvertRecoveryPointToSnapshotInput) SetTags(v []*Tag) *ConvertRecoveryPointToSnapshotInput {
	s.Tags = v
	return s
}

type ConvertRecoveryPointToSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot converted from the recovery point.
	Snapshot *Snapshot `locationName:"snapshot" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConvertRecoveryPointToSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConvertRecoveryPointToSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *ConvertRecoveryPointToSnapshotOutput) SetSnapshot(v *Snapshot) *ConvertRecoveryPointToSnapshotOutput {
	s.Snapshot = v
	return s
}

type CreateCustomDomainAssociationInput struct {
	_ struct{} `type:"structure"`

	// The custom domain name’s certificate Amazon resource name (ARN).
	//
	// CustomDomainCertificateArn is a required field
	CustomDomainCertificateArn *string `locationName:"customDomainCertificateArn" min:"20" type:"string" required:"true"`

	// The custom domain name to associate with the workgroup.
	//
	// CustomDomainName is a required field
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string" required:"true"`

	// The name of the workgroup associated with the database.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomDomainAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomDomainAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCustomDomainAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateCustomDomainAssociationInput"}
	if s.CustomDomainCertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomDomainCertificateArn"))
	}
	if s.CustomDomainCertificateArn != nil && len(*s.CustomDomainCertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainCertificateArn", 20))
	}
	if s.CustomDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomDomainName"))
	}
	if s.CustomDomainName != nil && len(*s.CustomDomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainName", 1))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomDomainCertificateArn sets the CustomDomainCertificateArn field's value.
func (s *CreateCustomDomainAssociationInput) SetCustomDomainCertificateArn(v string) *CreateCustomDomainAssociationInput {
	s.CustomDomainCertificateArn = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *CreateCustomDomainAssociationInput) SetCustomDomainName(v string) *CreateCustomDomainAssociationInput {
	s.CustomDomainName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *CreateCustomDomainAssociationInput) SetWorkgroupName(v string) *CreateCustomDomainAssociationInput {
	s.WorkgroupName = &v
	return s
}

type CreateCustomDomainAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The custom domain name’s certificate Amazon resource name (ARN).
	CustomDomainCertificateArn *string `locationName:"customDomainCertificateArn" min:"20" type:"string"`

	// The expiration time for the certificate.
	CustomDomainCertificateExpiryTime *time.Time `locationName:"customDomainCertificateExpiryTime" type:"timestamp" timestampFormat:"iso8601"`

	// The custom domain name to associate with the workgroup.
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string"`

	// The name of the workgroup associated with the database.
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomDomainAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateCustomDomainAssociationOutput) GoString() string {
	return s.String()
}

// SetCustomDomainCertificateArn sets the CustomDomainCertificateArn field's value.
func (s *CreateCustomDomainAssociationOutput) SetCustomDomainCertificateArn(v string) *CreateCustomDomainAssociationOutput {
	s.CustomDomainCertificateArn = &v
	return s
}

// SetCustomDomainCertificateExpiryTime sets the CustomDomainCertificateExpiryTime field's value.
func (s *CreateCustomDomainAssociationOutput) SetCustomDomainCertificateExpiryTime(v time.Time) *CreateCustomDomainAssociationOutput {
	s.CustomDomainCertificateExpiryTime = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *CreateCustomDomainAssociationOutput) SetCustomDomainName(v string) *CreateCustomDomainAssociationOutput {
	s.CustomDomainName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *CreateCustomDomainAssociationOutput) SetWorkgroupName(v string) *CreateCustomDomainAssociationOutput {
	s.WorkgroupName = &v
	return s
}

type CreateEndpointAccessInput struct {
	_ struct{} `type:"structure"`

	// The name of the VPC endpoint. An endpoint name must contain 1-30 characters.
	// Valid characters are A-Z, a-z, 0-9, and hyphen(-). The first character must
	// be a letter. The name can't contain two consecutive hyphens or end with a
	// hyphen.
	//
	// EndpointName is a required field
	EndpointName *string `locationName:"endpointName" type:"string" required:"true"`

	// The owner Amazon Web Services account for the Amazon Redshift Serverless
	// workgroup.
	OwnerAccount *string `locationName:"ownerAccount" min:"1" type:"string"`

	// The unique identifers of subnets from which Amazon Redshift Serverless chooses
	// one to deploy a VPC endpoint.
	//
	// SubnetIds is a required field
	SubnetIds []*string `locationName:"subnetIds" type:"list" required:"true"`

	// The unique identifiers of the security group that defines the ports, protocols,
	// and sources for inbound traffic that you are authorizing into your endpoint.
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" type:"list"`

	// The name of the workgroup to associate with the VPC endpoint.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEndpointAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEndpointAccessInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}
	if s.OwnerAccount != nil && len(*s.OwnerAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerAccount", 1))
	}
	if s.SubnetIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetIds"))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *CreateEndpointAccessInput) SetEndpointName(v string) *CreateEndpointAccessInput {
	s.EndpointName = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *CreateEndpointAccessInput) SetOwnerAccount(v string) *CreateEndpointAccessInput {
	s.OwnerAccount = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateEndpointAccessInput) SetSubnetIds(v []*string) *CreateEndpointAccessInput {
	s.SubnetIds = v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *CreateEndpointAccessInput) SetVpcSecurityGroupIds(v []*string) *CreateEndpointAccessInput {
	s.VpcSecurityGroupIds = v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *CreateEndpointAccessInput) SetWorkgroupName(v string) *CreateEndpointAccessInput {
	s.WorkgroupName = &v
	return s
}

type CreateEndpointAccessOutput struct {
	_ struct{} `type:"structure"`

	// The created VPC endpoint.
	Endpoint *EndpointAccess `locationName:"endpoint" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEndpointAccessOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *CreateEndpointAccessOutput) SetEndpoint(v *EndpointAccess) *CreateEndpointAccessOutput {
	s.Endpoint = v
	return s
}

type CreateNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Key Management Service (KMS) key used to encrypt and store
	// the namespace's admin credentials secret. You can only use this parameter
	// if manageAdminPassword is true.
	AdminPasswordSecretKmsKeyId *string `locationName:"adminPasswordSecretKmsKeyId" type:"string"`

	// The password of the administrator for the first database created in the namespace.
	//
	// You can't use adminUserPassword if manageAdminPassword is true.
	//
	// AdminUserPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateNamespaceInput's
	// String and GoString methods.
	AdminUserPassword *string `locationName:"adminUserPassword" type:"string" sensitive:"true"`

	// The username of the administrator for the first database created in the namespace.
	//
	// AdminUsername is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateNamespaceInput's
	// String and GoString methods.
	AdminUsername *string `locationName:"adminUsername" type:"string" sensitive:"true"`

	// The name of the first database created in the namespace.
	DbName *string `locationName:"dbName" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role to set as a default in the
	// namespace.
	DefaultIamRoleArn *string `locationName:"defaultIamRoleArn" type:"string"`

	// A list of IAM roles to associate with the namespace.
	IamRoles []*string `locationName:"iamRoles" type:"list"`

	// The ID of the Amazon Web Services Key Management Service key used to encrypt
	// your data.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The types of logs the namespace can export. Available export types are userlog,
	// connectionlog, and useractivitylog.
	LogExports []*string `locationName:"logExports" type:"list" enum:"LogExport"`

	// If true, Amazon Redshift uses Secrets Manager to manage the namespace's admin
	// credentials. You can't use adminUserPassword if manageAdminPassword is true.
	// If manageAdminPassword is false or not set, Amazon Redshift uses adminUserPassword
	// for the admin user account's password.
	ManageAdminPassword *bool `locationName:"manageAdminPassword" type:"boolean"`

	// The name of the namespace.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`

	// The ARN for the Redshift application that integrates with IAM Identity Center.
	RedshiftIdcApplicationArn *string `locationName:"redshiftIdcApplicationArn" min:"1" type:"string"`

	// A list of tag instances.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNamespaceInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}
	if s.RedshiftIdcApplicationArn != nil && len(*s.RedshiftIdcApplicationArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RedshiftIdcApplicationArn", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminPasswordSecretKmsKeyId sets the AdminPasswordSecretKmsKeyId field's value.
func (s *CreateNamespaceInput) SetAdminPasswordSecretKmsKeyId(v string) *CreateNamespaceInput {
	s.AdminPasswordSecretKmsKeyId = &v
	return s
}

// SetAdminUserPassword sets the AdminUserPassword field's value.
func (s *CreateNamespaceInput) SetAdminUserPassword(v string) *CreateNamespaceInput {
	s.AdminUserPassword = &v
	return s
}

// SetAdminUsername sets the AdminUsername field's value.
func (s *CreateNamespaceInput) SetAdminUsername(v string) *CreateNamespaceInput {
	s.AdminUsername = &v
	return s
}

// SetDbName sets the DbName field's value.
func (s *CreateNamespaceInput) SetDbName(v string) *CreateNamespaceInput {
	s.DbName = &v
	return s
}

// SetDefaultIamRoleArn sets the DefaultIamRoleArn field's value.
func (s *CreateNamespaceInput) SetDefaultIamRoleArn(v string) *CreateNamespaceInput {
	s.DefaultIamRoleArn = &v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *CreateNamespaceInput) SetIamRoles(v []*string) *CreateNamespaceInput {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *CreateNamespaceInput) SetKmsKeyId(v string) *CreateNamespaceInput {
	s.KmsKeyId = &v
	return s
}

// SetLogExports sets the LogExports field's value.
func (s *CreateNamespaceInput) SetLogExports(v []*string) *CreateNamespaceInput {
	s.LogExports = v
	return s
}

// SetManageAdminPassword sets the ManageAdminPassword field's value.
func (s *CreateNamespaceInput) SetManageAdminPassword(v bool) *CreateNamespaceInput {
	s.ManageAdminPassword = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *CreateNamespaceInput) SetNamespaceName(v string) *CreateNamespaceInput {
	s.NamespaceName = &v
	return s
}

// SetRedshiftIdcApplicationArn sets the RedshiftIdcApplicationArn field's value.
func (s *CreateNamespaceInput) SetRedshiftIdcApplicationArn(v string) *CreateNamespaceInput {
	s.RedshiftIdcApplicationArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateNamespaceInput) SetTags(v []*Tag) *CreateNamespaceInput {
	s.Tags = v
	return s
}

type CreateNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The created namespace object.
	Namespace *Namespace `locationName:"namespace" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateNamespaceOutput) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *CreateNamespaceOutput) SetNamespace(v *Namespace) *CreateNamespaceOutput {
	s.Namespace = v
	return s
}

type CreateScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether the schedule is enabled. If false, the scheduled action
	// does not trigger. For more information about state of the scheduled action,
	// see ScheduledAction (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_ScheduledAction.html).
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The end time in UTC when the schedule is no longer active. After this time,
	// the scheduled action does not trigger.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The name of the namespace for which to create a scheduled action.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`

	// The ARN of the IAM role to assume to run the scheduled action. This IAM role
	// must have permission to run the Amazon Redshift Serverless API operation
	// in the scheduled action. This IAM role must allow the Amazon Redshift scheduler
	// to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com)
	// to assume permissions on your behalf. For more information about the IAM
	// role to use with the Amazon Redshift scheduler, see Using Identity-Based
	// Policies for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Management Guide
	//
	// RoleArn is a required field
	RoleArn *string `locationName:"roleArn" type:"string" required:"true"`

	// The schedule for a one-time (at timestamp format) or recurring (cron format)
	// scheduled action. Schedule invocations must be separated by at least one
	// hour. Times are in UTC.
	//
	//    * Format of at timestamp is yyyy-mm-ddThh:mm:ss. For example, 2016-03-04T17:27:00.
	//
	//    * Format of cron expression is (Minutes Hours Day-of-month Month Day-of-week
	//    Year). For example, "(0 10 ? * MON *)". For more information, see Cron
	//    Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	//    in the Amazon CloudWatch Events User Guide.
	//
	// Schedule is a required field
	Schedule *Schedule `locationName:"schedule" type:"structure" required:"true"`

	// The description of the scheduled action.
	ScheduledActionDescription *string `locationName:"scheduledActionDescription" type:"string"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `locationName:"scheduledActionName" min:"3" type:"string" required:"true"`

	// The start time in UTC when the schedule is active. Before this time, the
	// scheduled action does not trigger.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// A JSON format string of the Amazon Redshift Serverless API operation with
	// input parameters. The following is an example of a target action.
	//
	// "{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot",
	// "retentionPeriod": "1"}}"
	//
	// TargetAction is a required field
	TargetAction *TargetAction `locationName:"targetAction" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateScheduledActionInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.Schedule == nil {
		invalidParams.Add(request.NewErrParamRequired("Schedule"))
	}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 3))
	}
	if s.TargetAction == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetAction"))
	}
	if s.TargetAction != nil {
		if err := s.TargetAction.Validate(); err != nil {
			invalidParams.AddNested("TargetAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *CreateScheduledActionInput) SetEnabled(v bool) *CreateScheduledActionInput {
	s.Enabled = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *CreateScheduledActionInput) SetEndTime(v time.Time) *CreateScheduledActionInput {
	s.EndTime = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *CreateScheduledActionInput) SetNamespaceName(v string) *CreateScheduledActionInput {
	s.NamespaceName = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *CreateScheduledActionInput) SetRoleArn(v string) *CreateScheduledActionInput {
	s.RoleArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CreateScheduledActionInput) SetSchedule(v *Schedule) *CreateScheduledActionInput {
	s.Schedule = v
	return s
}

// SetScheduledActionDescription sets the ScheduledActionDescription field's value.
func (s *CreateScheduledActionInput) SetScheduledActionDescription(v string) *CreateScheduledActionInput {
	s.ScheduledActionDescription = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *CreateScheduledActionInput) SetScheduledActionName(v string) *CreateScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *CreateScheduledActionInput) SetStartTime(v time.Time) *CreateScheduledActionInput {
	s.StartTime = &v
	return s
}

// SetTargetAction sets the TargetAction field's value.
func (s *CreateScheduledActionInput) SetTargetAction(v *TargetAction) *CreateScheduledActionInput {
	s.TargetAction = v
	return s
}

type CreateScheduledActionOutput struct {
	_ struct{} `type:"structure"`

	// The returned ScheduledAction object that describes the properties of a scheduled
	// action.
	ScheduledAction *ScheduledActionResponse `locationName:"scheduledAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateScheduledActionOutput) GoString() string {
	return s.String()
}

// SetScheduledAction sets the ScheduledAction field's value.
func (s *CreateScheduledActionOutput) SetScheduledAction(v *ScheduledActionResponse) *CreateScheduledActionOutput {
	s.ScheduledAction = v
	return s
}

type CreateSnapshotCopyConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The KMS key to use to encrypt your snapshots in the destination Amazon Web
	// Services Region.
	DestinationKmsKeyId *string `locationName:"destinationKmsKeyId" type:"string"`

	// The destination Amazon Web Services Region that you want to copy snapshots
	// to.
	//
	// DestinationRegion is a required field
	DestinationRegion *string `locationName:"destinationRegion" type:"string" required:"true"`

	// The name of the namespace to copy snapshots from.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`

	// The retention period of the snapshots that you copy to the destination Amazon
	// Web Services Region.
	SnapshotRetentionPeriod *int64 `locationName:"snapshotRetentionPeriod" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotCopyConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotCopyConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotCopyConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotCopyConfigurationInput"}
	if s.DestinationRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("DestinationRegion"))
	}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDestinationKmsKeyId sets the DestinationKmsKeyId field's value.
func (s *CreateSnapshotCopyConfigurationInput) SetDestinationKmsKeyId(v string) *CreateSnapshotCopyConfigurationInput {
	s.DestinationKmsKeyId = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CreateSnapshotCopyConfigurationInput) SetDestinationRegion(v string) *CreateSnapshotCopyConfigurationInput {
	s.DestinationRegion = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *CreateSnapshotCopyConfigurationInput) SetNamespaceName(v string) *CreateSnapshotCopyConfigurationInput {
	s.NamespaceName = &v
	return s
}

// SetSnapshotRetentionPeriod sets the SnapshotRetentionPeriod field's value.
func (s *CreateSnapshotCopyConfigurationInput) SetSnapshotRetentionPeriod(v int64) *CreateSnapshotCopyConfigurationInput {
	s.SnapshotRetentionPeriod = &v
	return s
}

type CreateSnapshotCopyConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The snapshot copy configuration object that is returned.
	//
	// SnapshotCopyConfiguration is a required field
	SnapshotCopyConfiguration *SnapshotCopyConfiguration `locationName:"snapshotCopyConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotCopyConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotCopyConfigurationOutput) GoString() string {
	return s.String()
}

// SetSnapshotCopyConfiguration sets the SnapshotCopyConfiguration field's value.
func (s *CreateSnapshotCopyConfigurationOutput) SetSnapshotCopyConfiguration(v *SnapshotCopyConfiguration) *CreateSnapshotCopyConfigurationOutput {
	s.SnapshotCopyConfiguration = v
	return s
}

type CreateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The namespace to create a snapshot for.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" type:"string" required:"true"`

	// How long to retain the created snapshot.
	RetentionPeriod *int64 `locationName:"retentionPeriod" type:"integer"`

	// The name of the snapshot.
	//
	// SnapshotName is a required field
	SnapshotName *string `locationName:"snapshotName" type:"string" required:"true"`

	// An array of Tag objects (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html)
	// to associate with the snapshot.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *CreateSnapshotInput) SetNamespaceName(v string) *CreateSnapshotInput {
	s.NamespaceName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateSnapshotInput) SetRetentionPeriod(v int64) *CreateSnapshotInput {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *CreateSnapshotInput) SetSnapshotName(v string) *CreateSnapshotInput {
	s.SnapshotName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSnapshotInput) SetTags(v []*Tag) *CreateSnapshotInput {
	s.Tags = v
	return s
}

type CreateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The created snapshot object.
	Snapshot *Snapshot `locationName:"snapshot" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *CreateSnapshotOutput) SetSnapshot(v *Snapshot) *CreateSnapshotOutput {
	s.Snapshot = v
	return s
}

// The parameters that you can use to configure a scheduled action (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html)
// to create a snapshot. For more information about creating a scheduled action,
// see CreateScheduledAction (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html).
type CreateSnapshotScheduleActionParameters struct {
	_ struct{} `type:"structure"`

	// The name of the namespace for which you want to configure a scheduled action
	// to create a snapshot.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`

	// The retention period of the snapshot created by the scheduled action.
	RetentionPeriod *int64 `locationName:"retentionPeriod" type:"integer"`

	// A string prefix that is attached to the name of the snapshot created by the
	// scheduled action. The final name of the snapshot is the string prefix appended
	// by the date and time of when the snapshot was created.
	//
	// SnapshotNamePrefix is a required field
	SnapshotNamePrefix *string `locationName:"snapshotNamePrefix" min:"1" type:"string" required:"true"`

	// An array of Tag objects (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_Tag.html)
	// to associate with the snapshot.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotScheduleActionParameters) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSnapshotScheduleActionParameters) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSnapshotScheduleActionParameters) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSnapshotScheduleActionParameters"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}
	if s.SnapshotNamePrefix == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotNamePrefix"))
	}
	if s.SnapshotNamePrefix != nil && len(*s.SnapshotNamePrefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SnapshotNamePrefix", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *CreateSnapshotScheduleActionParameters) SetNamespaceName(v string) *CreateSnapshotScheduleActionParameters {
	s.NamespaceName = &v
	return s
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *CreateSnapshotScheduleActionParameters) SetRetentionPeriod(v int64) *CreateSnapshotScheduleActionParameters {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotNamePrefix sets the SnapshotNamePrefix field's value.
func (s *CreateSnapshotScheduleActionParameters) SetSnapshotNamePrefix(v string) *CreateSnapshotScheduleActionParameters {
	s.SnapshotNamePrefix = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSnapshotScheduleActionParameters) SetTags(v []*Tag) *CreateSnapshotScheduleActionParameters {
	s.Tags = v
	return s
}

type CreateUsageLimitInput struct {
	_ struct{} `type:"structure"`

	// The limit amount. If time-based, this amount is in Redshift Processing Units
	// (RPU) consumed per hour. If data-based, this amount is in terabytes (TB)
	// of data transferred between Regions in cross-account sharing. The value must
	// be a positive number.
	//
	// Amount is a required field
	Amount *int64 `locationName:"amount" type:"long" required:"true"`

	// The action that Amazon Redshift Serverless takes when the limit is reached.
	// The default is log.
	BreachAction *string `locationName:"breachAction" type:"string" enum:"UsageLimitBreachAction"`

	// The time period that the amount applies to. A weekly period begins on Sunday.
	// The default is monthly.
	Period *string `locationName:"period" type:"string" enum:"UsageLimitPeriod"`

	// The Amazon Resource Name (ARN) of the Amazon Redshift Serverless resource
	// to create the usage limit for.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`

	// The type of Amazon Redshift Serverless usage to create a usage limit for.
	//
	// UsageType is a required field
	UsageType *string `locationName:"usageType" type:"string" required:"true" enum:"UsageLimitUsageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUsageLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUsageLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUsageLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUsageLimitInput"}
	if s.Amount == nil {
		invalidParams.Add(request.NewErrParamRequired("Amount"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.UsageType == nil {
		invalidParams.Add(request.NewErrParamRequired("UsageType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmount sets the Amount field's value.
func (s *CreateUsageLimitInput) SetAmount(v int64) *CreateUsageLimitInput {
	s.Amount = &v
	return s
}

// SetBreachAction sets the BreachAction field's value.
func (s *CreateUsageLimitInput) SetBreachAction(v string) *CreateUsageLimitInput {
	s.BreachAction = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CreateUsageLimitInput) SetPeriod(v string) *CreateUsageLimitInput {
	s.Period = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *CreateUsageLimitInput) SetResourceArn(v string) *CreateUsageLimitInput {
	s.ResourceArn = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *CreateUsageLimitInput) SetUsageType(v string) *CreateUsageLimitInput {
	s.UsageType = &v
	return s
}

type CreateUsageLimitOutput struct {
	_ struct{} `type:"structure"`

	// The returned usage limit object.
	UsageLimit *UsageLimit `locationName:"usageLimit" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUsageLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUsageLimitOutput) GoString() string {
	return s.String()
}

// SetUsageLimit sets the UsageLimit field's value.
func (s *CreateUsageLimitOutput) SetUsageLimit(v *UsageLimit) *CreateUsageLimitOutput {
	s.UsageLimit = v
	return s
}

type CreateWorkgroupInput struct {
	_ struct{} `type:"structure"`

	// The base data warehouse capacity of the workgroup in Redshift Processing
	// Units (RPUs).
	BaseCapacity *int64 `locationName:"baseCapacity" type:"integer"`

	// An array of parameters to set for advanced control over a database. The options
	// are auto_mv, datestyle, enable_case_sensitive_identifier, enable_user_activity_logging,
	// query_group, search_path, require_ssl, use_fips_ssl, and query monitoring
	// metrics that let you define performance boundaries. For more information
	// about query monitoring rules and available metrics, see Query monitoring
	// metrics for Amazon Redshift Serverless (https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless).
	ConfigParameters []*ConfigParameter `locationName:"configParameters" type:"list"`

	// The value that specifies whether to turn on enhanced virtual private cloud
	// (VPC) routing, which forces Amazon Redshift Serverless to route traffic through
	// your VPC instead of over the internet.
	EnhancedVpcRouting *bool `locationName:"enhancedVpcRouting" type:"boolean"`

	// The IP address type that the workgroup supports. Possible values are ipv4
	// and dualstack.
	IpAddressType *string `locationName:"ipAddressType" type:"string"`

	// The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve
	// queries. The max capacity is specified in RPUs.
	MaxCapacity *int64 `locationName:"maxCapacity" type:"integer"`

	// The name of the namespace to associate with the workgroup.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`

	// The custom port to use when connecting to a workgroup. Valid port ranges
	// are 5431-5455 and 8191-8215. The default is 5439.
	Port *int64 `locationName:"port" type:"integer"`

	// A value that specifies whether the workgroup can be accessed from a public
	// network.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// An array of security group IDs to associate with the workgroup.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// An array of VPC subnet IDs to associate with the workgroup.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// A array of tag instances.
	Tags []*Tag `locationName:"tags" type:"list"`

	// The name of the created workgroup.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkgroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkgroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkgroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkgroupInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseCapacity sets the BaseCapacity field's value.
func (s *CreateWorkgroupInput) SetBaseCapacity(v int64) *CreateWorkgroupInput {
	s.BaseCapacity = &v
	return s
}

// SetConfigParameters sets the ConfigParameters field's value.
func (s *CreateWorkgroupInput) SetConfigParameters(v []*ConfigParameter) *CreateWorkgroupInput {
	s.ConfigParameters = v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *CreateWorkgroupInput) SetEnhancedVpcRouting(v bool) *CreateWorkgroupInput {
	s.EnhancedVpcRouting = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *CreateWorkgroupInput) SetIpAddressType(v string) *CreateWorkgroupInput {
	s.IpAddressType = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *CreateWorkgroupInput) SetMaxCapacity(v int64) *CreateWorkgroupInput {
	s.MaxCapacity = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *CreateWorkgroupInput) SetNamespaceName(v string) *CreateWorkgroupInput {
	s.NamespaceName = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CreateWorkgroupInput) SetPort(v int64) *CreateWorkgroupInput {
	s.Port = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *CreateWorkgroupInput) SetPubliclyAccessible(v bool) *CreateWorkgroupInput {
	s.PubliclyAccessible = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateWorkgroupInput) SetSecurityGroupIds(v []*string) *CreateWorkgroupInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateWorkgroupInput) SetSubnetIds(v []*string) *CreateWorkgroupInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkgroupInput) SetTags(v []*Tag) *CreateWorkgroupInput {
	s.Tags = v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *CreateWorkgroupInput) SetWorkgroupName(v string) *CreateWorkgroupInput {
	s.WorkgroupName = &v
	return s
}

type CreateWorkgroupOutput struct {
	_ struct{} `type:"structure"`

	// The created workgroup object.
	Workgroup *Workgroup `locationName:"workgroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkgroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkgroupOutput) GoString() string {
	return s.String()
}

// SetWorkgroup sets the Workgroup field's value.
func (s *CreateWorkgroupOutput) SetWorkgroup(v *Workgroup) *CreateWorkgroupOutput {
	s.Workgroup = v
	return s
}

type DeleteCustomDomainAssociationInput struct {
	_ struct{} `type:"structure"`

	// The custom domain name associated with the workgroup.
	//
	// CustomDomainName is a required field
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string" required:"true"`

	// The name of the workgroup associated with the database.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomDomainAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomDomainAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCustomDomainAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteCustomDomainAssociationInput"}
	if s.CustomDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomDomainName"))
	}
	if s.CustomDomainName != nil && len(*s.CustomDomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainName", 1))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *DeleteCustomDomainAssociationInput) SetCustomDomainName(v string) *DeleteCustomDomainAssociationInput {
	s.CustomDomainName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *DeleteCustomDomainAssociationInput) SetWorkgroupName(v string) *DeleteCustomDomainAssociationInput {
	s.WorkgroupName = &v
	return s
}

type DeleteCustomDomainAssociationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomDomainAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteCustomDomainAssociationOutput) GoString() string {
	return s.String()
}

type DeleteEndpointAccessInput struct {
	_ struct{} `type:"structure"`

	// The name of the VPC endpoint to delete.
	//
	// EndpointName is a required field
	EndpointName *string `locationName:"endpointName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEndpointAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEndpointAccessInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *DeleteEndpointAccessInput) SetEndpointName(v string) *DeleteEndpointAccessInput {
	s.EndpointName = &v
	return s
}

type DeleteEndpointAccessOutput struct {
	_ struct{} `type:"structure"`

	// The deleted VPC endpoint.
	Endpoint *EndpointAccess `locationName:"endpoint" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEndpointAccessOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *DeleteEndpointAccessOutput) SetEndpoint(v *EndpointAccess) *DeleteEndpointAccessOutput {
	s.Endpoint = v
	return s
}

type DeleteNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot to be created before the namespace is deleted.
	FinalSnapshotName *string `locationName:"finalSnapshotName" type:"string"`

	// How long to retain the final snapshot.
	FinalSnapshotRetentionPeriod *int64 `locationName:"finalSnapshotRetentionPeriod" type:"integer"`

	// The name of the namespace to delete.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteNamespaceInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFinalSnapshotName sets the FinalSnapshotName field's value.
func (s *DeleteNamespaceInput) SetFinalSnapshotName(v string) *DeleteNamespaceInput {
	s.FinalSnapshotName = &v
	return s
}

// SetFinalSnapshotRetentionPeriod sets the FinalSnapshotRetentionPeriod field's value.
func (s *DeleteNamespaceInput) SetFinalSnapshotRetentionPeriod(v int64) *DeleteNamespaceInput {
	s.FinalSnapshotRetentionPeriod = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *DeleteNamespaceInput) SetNamespaceName(v string) *DeleteNamespaceInput {
	s.NamespaceName = &v
	return s
}

type DeleteNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The deleted namespace object.
	//
	// Namespace is a required field
	Namespace *Namespace `locationName:"namespace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteNamespaceOutput) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *DeleteNamespaceOutput) SetNamespace(v *Namespace) *DeleteNamespaceOutput {
	s.Namespace = v
	return s
}

type DeleteResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the policy to delete.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteResourcePolicyInput) SetResourceArn(v string) *DeleteResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type DeleteResourcePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteResourcePolicyOutput) GoString() string {
	return s.String()
}

type DeleteScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the scheduled action to delete.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `locationName:"scheduledActionName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteScheduledActionInput"}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *DeleteScheduledActionInput) SetScheduledActionName(v string) *DeleteScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

type DeleteScheduledActionOutput struct {
	_ struct{} `type:"structure"`

	// The deleted scheduled action object.
	ScheduledAction *ScheduledActionResponse `locationName:"scheduledAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteScheduledActionOutput) GoString() string {
	return s.String()
}

// SetScheduledAction sets the ScheduledAction field's value.
func (s *DeleteScheduledActionOutput) SetScheduledAction(v *ScheduledActionResponse) *DeleteScheduledActionOutput {
	s.ScheduledAction = v
	return s
}

type DeleteSnapshotCopyConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the snapshot copy configuration to delete.
	//
	// SnapshotCopyConfigurationId is a required field
	SnapshotCopyConfigurationId *string `locationName:"snapshotCopyConfigurationId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotCopyConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotCopyConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotCopyConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotCopyConfigurationInput"}
	if s.SnapshotCopyConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotCopyConfigurationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotCopyConfigurationId sets the SnapshotCopyConfigurationId field's value.
func (s *DeleteSnapshotCopyConfigurationInput) SetSnapshotCopyConfigurationId(v string) *DeleteSnapshotCopyConfigurationInput {
	s.SnapshotCopyConfigurationId = &v
	return s
}

type DeleteSnapshotCopyConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The deleted snapshot copy configuration object.
	//
	// SnapshotCopyConfiguration is a required field
	SnapshotCopyConfiguration *SnapshotCopyConfiguration `locationName:"snapshotCopyConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotCopyConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotCopyConfigurationOutput) GoString() string {
	return s.String()
}

// SetSnapshotCopyConfiguration sets the SnapshotCopyConfiguration field's value.
func (s *DeleteSnapshotCopyConfigurationOutput) SetSnapshotCopyConfiguration(v *SnapshotCopyConfiguration) *DeleteSnapshotCopyConfigurationOutput {
	s.SnapshotCopyConfiguration = v
	return s
}

type DeleteSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The name of the snapshot to be deleted.
	//
	// SnapshotName is a required field
	SnapshotName *string `locationName:"snapshotName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSnapshotInput"}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *DeleteSnapshotInput) SetSnapshotName(v string) *DeleteSnapshotInput {
	s.SnapshotName = &v
	return s
}

type DeleteSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The deleted snapshot object.
	Snapshot *Snapshot `locationName:"snapshot" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *DeleteSnapshotOutput) SetSnapshot(v *Snapshot) *DeleteSnapshotOutput {
	s.Snapshot = v
	return s
}

type DeleteUsageLimitInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the usage limit to delete.
	//
	// UsageLimitId is a required field
	UsageLimitId *string `locationName:"usageLimitId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsageLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsageLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteUsageLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteUsageLimitInput"}
	if s.UsageLimitId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsageLimitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUsageLimitId sets the UsageLimitId field's value.
func (s *DeleteUsageLimitInput) SetUsageLimitId(v string) *DeleteUsageLimitInput {
	s.UsageLimitId = &v
	return s
}

type DeleteUsageLimitOutput struct {
	_ struct{} `type:"structure"`

	// The deleted usage limit object.
	UsageLimit *UsageLimit `locationName:"usageLimit" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsageLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteUsageLimitOutput) GoString() string {
	return s.String()
}

// SetUsageLimit sets the UsageLimit field's value.
func (s *DeleteUsageLimitOutput) SetUsageLimit(v *UsageLimit) *DeleteUsageLimitOutput {
	s.UsageLimit = v
	return s
}

type DeleteWorkgroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the workgroup to be deleted.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkgroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkgroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkgroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkgroupInput"}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *DeleteWorkgroupInput) SetWorkgroupName(v string) *DeleteWorkgroupInput {
	s.WorkgroupName = &v
	return s
}

type DeleteWorkgroupOutput struct {
	_ struct{} `type:"structure"`

	// The deleted workgroup object.
	//
	// Workgroup is a required field
	Workgroup *Workgroup `locationName:"workgroup" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkgroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkgroupOutput) GoString() string {
	return s.String()
}

// SetWorkgroup sets the Workgroup field's value.
func (s *DeleteWorkgroupOutput) SetWorkgroup(v *Workgroup) *DeleteWorkgroupOutput {
	s.Workgroup = v
	return s
}

// The VPC endpoint object.
type Endpoint struct {
	_ struct{} `type:"structure"`

	// The DNS address of the VPC endpoint.
	Address *string `locationName:"address" type:"string"`

	// The port that Amazon Redshift Serverless listens on.
	Port *int64 `locationName:"port" type:"integer"`

	// An array of VpcEndpoint objects.
	VpcEndpoints []*VpcEndpoint `locationName:"vpcEndpoints" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Endpoint) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *Endpoint) SetAddress(v string) *Endpoint {
	s.Address = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Endpoint) SetPort(v int64) *Endpoint {
	s.Port = &v
	return s
}

// SetVpcEndpoints sets the VpcEndpoints field's value.
func (s *Endpoint) SetVpcEndpoints(v []*VpcEndpoint) *Endpoint {
	s.VpcEndpoints = v
	return s
}

// Information about an Amazon Redshift Serverless VPC endpoint.
type EndpointAccess struct {
	_ struct{} `type:"structure"`

	// The DNS address of the endpoint.
	Address *string `locationName:"address" type:"string"`

	// The Amazon Resource Name (ARN) of the VPC endpoint.
	EndpointArn *string `locationName:"endpointArn" type:"string"`

	// The time that the endpoint was created.
	EndpointCreateTime *time.Time `locationName:"endpointCreateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the VPC endpoint.
	EndpointName *string `locationName:"endpointName" type:"string"`

	// The status of the VPC endpoint.
	EndpointStatus *string `locationName:"endpointStatus" type:"string"`

	// The port number on which Amazon Redshift Serverless accepts incoming connections.
	Port *int64 `locationName:"port" type:"integer"`

	// The unique identifier of subnets where Amazon Redshift Serverless choose
	// to deploy the VPC endpoint.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The connection endpoint for connecting to Amazon Redshift Serverless.
	VpcEndpoint *VpcEndpoint `locationName:"vpcEndpoint" type:"structure"`

	// The security groups associated with the endpoint.
	VpcSecurityGroups []*VpcSecurityGroupMembership `locationName:"vpcSecurityGroups" type:"list"`

	// The name of the workgroup associated with the endpoint.
	WorkgroupName *string `locationName:"workgroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointAccess) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EndpointAccess) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *EndpointAccess) SetAddress(v string) *EndpointAccess {
	s.Address = &v
	return s
}

// SetEndpointArn sets the EndpointArn field's value.
func (s *EndpointAccess) SetEndpointArn(v string) *EndpointAccess {
	s.EndpointArn = &v
	return s
}

// SetEndpointCreateTime sets the EndpointCreateTime field's value.
func (s *EndpointAccess) SetEndpointCreateTime(v time.Time) *EndpointAccess {
	s.EndpointCreateTime = &v
	return s
}

// SetEndpointName sets the EndpointName field's value.
func (s *EndpointAccess) SetEndpointName(v string) *EndpointAccess {
	s.EndpointName = &v
	return s
}

// SetEndpointStatus sets the EndpointStatus field's value.
func (s *EndpointAccess) SetEndpointStatus(v string) *EndpointAccess {
	s.EndpointStatus = &v
	return s
}

// SetPort sets the Port field's value.
func (s *EndpointAccess) SetPort(v int64) *EndpointAccess {
	s.Port = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *EndpointAccess) SetSubnetIds(v []*string) *EndpointAccess {
	s.SubnetIds = v
	return s
}

// SetVpcEndpoint sets the VpcEndpoint field's value.
func (s *EndpointAccess) SetVpcEndpoint(v *VpcEndpoint) *EndpointAccess {
	s.VpcEndpoint = v
	return s
}

// SetVpcSecurityGroups sets the VpcSecurityGroups field's value.
func (s *EndpointAccess) SetVpcSecurityGroups(v []*VpcSecurityGroupMembership) *EndpointAccess {
	s.VpcSecurityGroups = v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *EndpointAccess) SetWorkgroupName(v string) *EndpointAccess {
	s.WorkgroupName = &v
	return s
}

type GetCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The custom domain name associated with the workgroup. The custom domain name
	// or the workgroup name must be included in the request.
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string"`

	// The name of the database to get temporary authorization to log on to.
	//
	// Constraints:
	//
	//    * Must be 1 to 64 alphanumeric characters or hyphens.
	//
	//    * Must contain only uppercase or lowercase letters, numbers, underscore,
	//    plus sign, period (dot), at symbol (@), or hyphen.
	//
	//    * The first character must be a letter.
	//
	//    * Must not contain a colon ( : ) or slash ( / ).
	//
	//    * Cannot be a reserved word. A list of reserved words can be found in
	//    Reserved Words (https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	//    in the Amazon Redshift Database Developer Guide
	DbName *string `locationName:"dbName" type:"string"`

	// The number of seconds until the returned temporary password expires. The
	// minimum is 900 seconds, and the maximum is 3600 seconds.
	DurationSeconds *int64 `locationName:"durationSeconds" type:"integer"`

	// The name of the workgroup associated with the database.
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCredentialsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCredentialsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCredentialsInput"}
	if s.CustomDomainName != nil && len(*s.CustomDomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainName", 1))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *GetCredentialsInput) SetCustomDomainName(v string) *GetCredentialsInput {
	s.CustomDomainName = &v
	return s
}

// SetDbName sets the DbName field's value.
func (s *GetCredentialsInput) SetDbName(v string) *GetCredentialsInput {
	s.DbName = &v
	return s
}

// SetDurationSeconds sets the DurationSeconds field's value.
func (s *GetCredentialsInput) SetDurationSeconds(v int64) *GetCredentialsInput {
	s.DurationSeconds = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *GetCredentialsInput) SetWorkgroupName(v string) *GetCredentialsInput {
	s.WorkgroupName = &v
	return s
}

type GetCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// A temporary password that authorizes the user name returned by DbUser to
	// log on to the database DbName.
	//
	// DbPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetCredentialsOutput's
	// String and GoString methods.
	DbPassword *string `locationName:"dbPassword" type:"string" sensitive:"true"`

	// A database user name that is authorized to log on to the database DbName
	// using the password DbPassword. If the specified DbUser exists in the database,
	// the new user name has the same database privileges as the the user named
	// in DbUser. By default, the user is added to PUBLIC.
	//
	// DbUser is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by GetCredentialsOutput's
	// String and GoString methods.
	DbUser *string `locationName:"dbUser" type:"string" sensitive:"true"`

	// The date and time the password in DbPassword expires.
	Expiration *time.Time `locationName:"expiration" type:"timestamp"`

	// The date and time of when the DbUser and DbPassword authorization refreshes.
	NextRefreshTime *time.Time `locationName:"nextRefreshTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCredentialsOutput) GoString() string {
	return s.String()
}

// SetDbPassword sets the DbPassword field's value.
func (s *GetCredentialsOutput) SetDbPassword(v string) *GetCredentialsOutput {
	s.DbPassword = &v
	return s
}

// SetDbUser sets the DbUser field's value.
func (s *GetCredentialsOutput) SetDbUser(v string) *GetCredentialsOutput {
	s.DbUser = &v
	return s
}

// SetExpiration sets the Expiration field's value.
func (s *GetCredentialsOutput) SetExpiration(v time.Time) *GetCredentialsOutput {
	s.Expiration = &v
	return s
}

// SetNextRefreshTime sets the NextRefreshTime field's value.
func (s *GetCredentialsOutput) SetNextRefreshTime(v time.Time) *GetCredentialsOutput {
	s.NextRefreshTime = &v
	return s
}

type GetCustomDomainAssociationInput struct {
	_ struct{} `type:"structure"`

	// The custom domain name associated with the workgroup.
	//
	// CustomDomainName is a required field
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string" required:"true"`

	// The name of the workgroup associated with the database.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomDomainAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomDomainAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCustomDomainAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetCustomDomainAssociationInput"}
	if s.CustomDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomDomainName"))
	}
	if s.CustomDomainName != nil && len(*s.CustomDomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainName", 1))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *GetCustomDomainAssociationInput) SetCustomDomainName(v string) *GetCustomDomainAssociationInput {
	s.CustomDomainName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *GetCustomDomainAssociationInput) SetWorkgroupName(v string) *GetCustomDomainAssociationInput {
	s.WorkgroupName = &v
	return s
}

type GetCustomDomainAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The custom domain name’s certificate Amazon resource name (ARN).
	CustomDomainCertificateArn *string `locationName:"customDomainCertificateArn" min:"20" type:"string"`

	// The expiration time for the certificate.
	CustomDomainCertificateExpiryTime *time.Time `locationName:"customDomainCertificateExpiryTime" type:"timestamp" timestampFormat:"iso8601"`

	// The custom domain name associated with the workgroup.
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string"`

	// The name of the workgroup associated with the database.
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomDomainAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetCustomDomainAssociationOutput) GoString() string {
	return s.String()
}

// SetCustomDomainCertificateArn sets the CustomDomainCertificateArn field's value.
func (s *GetCustomDomainAssociationOutput) SetCustomDomainCertificateArn(v string) *GetCustomDomainAssociationOutput {
	s.CustomDomainCertificateArn = &v
	return s
}

// SetCustomDomainCertificateExpiryTime sets the CustomDomainCertificateExpiryTime field's value.
func (s *GetCustomDomainAssociationOutput) SetCustomDomainCertificateExpiryTime(v time.Time) *GetCustomDomainAssociationOutput {
	s.CustomDomainCertificateExpiryTime = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *GetCustomDomainAssociationOutput) SetCustomDomainName(v string) *GetCustomDomainAssociationOutput {
	s.CustomDomainName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *GetCustomDomainAssociationOutput) SetWorkgroupName(v string) *GetCustomDomainAssociationOutput {
	s.WorkgroupName = &v
	return s
}

type GetEndpointAccessInput struct {
	_ struct{} `type:"structure"`

	// The name of the VPC endpoint to return information for.
	//
	// EndpointName is a required field
	EndpointName *string `locationName:"endpointName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEndpointAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEndpointAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEndpointAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEndpointAccessInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *GetEndpointAccessInput) SetEndpointName(v string) *GetEndpointAccessInput {
	s.EndpointName = &v
	return s
}

type GetEndpointAccessOutput struct {
	_ struct{} `type:"structure"`

	// The returned VPC endpoint.
	Endpoint *EndpointAccess `locationName:"endpoint" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEndpointAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEndpointAccessOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *GetEndpointAccessOutput) SetEndpoint(v *EndpointAccess) *GetEndpointAccessOutput {
	s.Endpoint = v
	return s
}

type GetNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The name of the namespace to retrieve information for.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetNamespaceInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *GetNamespaceInput) SetNamespaceName(v string) *GetNamespaceInput {
	s.NamespaceName = &v
	return s
}

type GetNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// The returned namespace object.
	//
	// Namespace is a required field
	Namespace *Namespace `locationName:"namespace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetNamespaceOutput) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *GetNamespaceOutput) SetNamespace(v *Namespace) *GetNamespaceOutput {
	s.Namespace = v
	return s
}

type GetRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the recovery point to return information for.
	//
	// RecoveryPointId is a required field
	RecoveryPointId *string `locationName:"recoveryPointId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRecoveryPointInput"}
	if s.RecoveryPointId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRecoveryPointId sets the RecoveryPointId field's value.
func (s *GetRecoveryPointInput) SetRecoveryPointId(v string) *GetRecoveryPointInput {
	s.RecoveryPointId = &v
	return s
}

type GetRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// The returned recovery point object.
	RecoveryPoint *RecoveryPoint `locationName:"recoveryPoint" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetRecoveryPointOutput) GoString() string {
	return s.String()
}

// SetRecoveryPoint sets the RecoveryPoint field's value.
func (s *GetRecoveryPointOutput) SetRecoveryPoint(v *RecoveryPoint) *GetRecoveryPointOutput {
	s.RecoveryPoint = v
	return s
}

type GetResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to return.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourcePolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetResourcePolicyInput) SetResourceArn(v string) *GetResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type GetResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The returned resource policy.
	ResourcePolicy *ResourcePolicy `locationName:"resourcePolicy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *GetResourcePolicyOutput) SetResourcePolicy(v *ResourcePolicy) *GetResourcePolicyOutput {
	s.ResourcePolicy = v
	return s
}

type GetScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// The name of the scheduled action.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `locationName:"scheduledActionName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetScheduledActionInput"}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *GetScheduledActionInput) SetScheduledActionName(v string) *GetScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

type GetScheduledActionOutput struct {
	_ struct{} `type:"structure"`

	// The returned scheduled action object.
	ScheduledAction *ScheduledActionResponse `locationName:"scheduledAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetScheduledActionOutput) GoString() string {
	return s.String()
}

// SetScheduledAction sets the ScheduledAction field's value.
func (s *GetScheduledActionOutput) SetScheduledAction(v *ScheduledActionResponse) *GetScheduledActionOutput {
	s.ScheduledAction = v
	return s
}

type GetSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The owner Amazon Web Services account of a snapshot shared with another user.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The Amazon Resource Name (ARN) of the snapshot to return.
	SnapshotArn *string `locationName:"snapshotArn" type:"string"`

	// The name of the snapshot to return.
	SnapshotName *string `locationName:"snapshotName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotInput) GoString() string {
	return s.String()
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *GetSnapshotInput) SetOwnerAccount(v string) *GetSnapshotInput {
	s.OwnerAccount = &v
	return s
}

// SetSnapshotArn sets the SnapshotArn field's value.
func (s *GetSnapshotInput) SetSnapshotArn(v string) *GetSnapshotInput {
	s.SnapshotArn = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *GetSnapshotInput) SetSnapshotName(v string) *GetSnapshotInput {
	s.SnapshotName = &v
	return s
}

type GetSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The returned snapshot object.
	Snapshot *Snapshot `locationName:"snapshot" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *GetSnapshotOutput) SetSnapshot(v *Snapshot) *GetSnapshotOutput {
	s.Snapshot = v
	return s
}

type GetTableRestoreStatusInput struct {
	_ struct{} `type:"structure"`

	// The ID of the RestoreTableFromSnapshot request to return status for.
	//
	// TableRestoreRequestId is a required field
	TableRestoreRequestId *string `locationName:"tableRestoreRequestId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableRestoreStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableRestoreStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetTableRestoreStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetTableRestoreStatusInput"}
	if s.TableRestoreRequestId == nil {
		invalidParams.Add(request.NewErrParamRequired("TableRestoreRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTableRestoreRequestId sets the TableRestoreRequestId field's value.
func (s *GetTableRestoreStatusInput) SetTableRestoreRequestId(v string) *GetTableRestoreStatusInput {
	s.TableRestoreRequestId = &v
	return s
}

type GetTableRestoreStatusOutput struct {
	_ struct{} `type:"structure"`

	// The returned TableRestoreStatus object that contains information about the
	// status of your RestoreTableFromSnapshot request.
	TableRestoreStatus *TableRestoreStatus `locationName:"tableRestoreStatus" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableRestoreStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetTableRestoreStatusOutput) GoString() string {
	return s.String()
}

// SetTableRestoreStatus sets the TableRestoreStatus field's value.
func (s *GetTableRestoreStatusOutput) SetTableRestoreStatus(v *TableRestoreStatus) *GetTableRestoreStatusOutput {
	s.TableRestoreStatus = v
	return s
}

type GetUsageLimitInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier of the usage limit to return information for.
	//
	// UsageLimitId is a required field
	UsageLimitId *string `locationName:"usageLimitId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetUsageLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetUsageLimitInput"}
	if s.UsageLimitId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsageLimitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetUsageLimitId sets the UsageLimitId field's value.
func (s *GetUsageLimitInput) SetUsageLimitId(v string) *GetUsageLimitInput {
	s.UsageLimitId = &v
	return s
}

type GetUsageLimitOutput struct {
	_ struct{} `type:"structure"`

	// The returned usage limit object.
	UsageLimit *UsageLimit `locationName:"usageLimit" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetUsageLimitOutput) GoString() string {
	return s.String()
}

// SetUsageLimit sets the UsageLimit field's value.
func (s *GetUsageLimitOutput) SetUsageLimit(v *UsageLimit) *GetUsageLimitOutput {
	s.UsageLimit = v
	return s
}

type GetWorkgroupInput struct {
	_ struct{} `type:"structure"`

	// The name of the workgroup to return information for.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkgroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkgroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWorkgroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWorkgroupInput"}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *GetWorkgroupInput) SetWorkgroupName(v string) *GetWorkgroupInput {
	s.WorkgroupName = &v
	return s
}

type GetWorkgroupOutput struct {
	_ struct{} `type:"structure"`

	// The returned workgroup object.
	//
	// Workgroup is a required field
	Workgroup *Workgroup `locationName:"workgroup" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkgroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetWorkgroupOutput) GoString() string {
	return s.String()
}

// SetWorkgroup sets the Workgroup field's value.
func (s *GetWorkgroupOutput) SetWorkgroup(v *Workgroup) *GetWorkgroupOutput {
	s.Workgroup = v
	return s
}

// There is an insufficient capacity to perform the action.
type InsufficientCapacityException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientCapacityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InsufficientCapacityException) GoString() string {
	return s.String()
}

func newErrorInsufficientCapacityException(v protocol.ResponseMetadata) error {
	return &InsufficientCapacityException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InsufficientCapacityException) Code() string {
	return "InsufficientCapacityException"
}

// Message returns the exception's message.
func (s *InsufficientCapacityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InsufficientCapacityException) OrigErr() error {
	return nil
}

func (s *InsufficientCapacityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InsufficientCapacityException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InsufficientCapacityException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request processing has failed because of an unknown error, exception
// or failure.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The provided pagination token is invalid.
type InvalidPaginationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidPaginationException) GoString() string {
	return s.String()
}

func newErrorInvalidPaginationException(v protocol.ResponseMetadata) error {
	return &InvalidPaginationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidPaginationException) Code() string {
	return "InvalidPaginationException"
}

// Message returns the exception's message.
func (s *InvalidPaginationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidPaginationException) OrigErr() error {
	return nil
}

func (s *InvalidPaginationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidPaginationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidPaginationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// There are no subnets in your VPC with associated IPv6 CIDR blocks. To use
// dual-stack mode, associate an IPv6 CIDR block with each subnet in your VPC.
type Ipv6CidrBlockNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ipv6CidrBlockNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Ipv6CidrBlockNotFoundException) GoString() string {
	return s.String()
}

func newErrorIpv6CidrBlockNotFoundException(v protocol.ResponseMetadata) error {
	return &Ipv6CidrBlockNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *Ipv6CidrBlockNotFoundException) Code() string {
	return "Ipv6CidrBlockNotFoundException"
}

// Message returns the exception's message.
func (s *Ipv6CidrBlockNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *Ipv6CidrBlockNotFoundException) OrigErr() error {
	return nil
}

func (s *Ipv6CidrBlockNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *Ipv6CidrBlockNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *Ipv6CidrBlockNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListCustomDomainAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The custom domain name’s certificate Amazon resource name (ARN).
	CustomDomainCertificateArn *string `locationName:"customDomainCertificateArn" min:"20" type:"string"`

	// The custom domain name associated with the workgroup.
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomDomainAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomDomainAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListCustomDomainAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListCustomDomainAssociationsInput"}
	if s.CustomDomainCertificateArn != nil && len(*s.CustomDomainCertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainCertificateArn", 20))
	}
	if s.CustomDomainName != nil && len(*s.CustomDomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomDomainCertificateArn sets the CustomDomainCertificateArn field's value.
func (s *ListCustomDomainAssociationsInput) SetCustomDomainCertificateArn(v string) *ListCustomDomainAssociationsInput {
	s.CustomDomainCertificateArn = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *ListCustomDomainAssociationsInput) SetCustomDomainName(v string) *ListCustomDomainAssociationsInput {
	s.CustomDomainName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListCustomDomainAssociationsInput) SetMaxResults(v int64) *ListCustomDomainAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomDomainAssociationsInput) SetNextToken(v string) *ListCustomDomainAssociationsInput {
	s.NextToken = &v
	return s
}

type ListCustomDomainAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// A list of Association objects.
	Associations []*Association `locationName:"associations" type:"list"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomDomainAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListCustomDomainAssociationsOutput) GoString() string {
	return s.String()
}

// SetAssociations sets the Associations field's value.
func (s *ListCustomDomainAssociationsOutput) SetAssociations(v []*Association) *ListCustomDomainAssociationsOutput {
	s.Associations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListCustomDomainAssociationsOutput) SetNextToken(v string) *ListCustomDomainAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListEndpointAccessInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListEndpointAccess operation returns a nextToken, you can
	// include the returned nextToken in following ListEndpointAccess operations,
	// which returns results in the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The owner Amazon Web Services account for the Amazon Redshift Serverless
	// workgroup.
	OwnerAccount *string `locationName:"ownerAccount" min:"1" type:"string"`

	// The unique identifier of the virtual private cloud with access to Amazon
	// Redshift Serverless.
	VpcId *string `locationName:"vpcId" type:"string"`

	// The name of the workgroup associated with the VPC endpoint to return.
	WorkgroupName *string `locationName:"workgroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEndpointAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEndpointAccessInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.OwnerAccount != nil && len(*s.OwnerAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerAccount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEndpointAccessInput) SetMaxResults(v int64) *ListEndpointAccessInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointAccessInput) SetNextToken(v string) *ListEndpointAccessInput {
	s.NextToken = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *ListEndpointAccessInput) SetOwnerAccount(v string) *ListEndpointAccessInput {
	s.OwnerAccount = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *ListEndpointAccessInput) SetVpcId(v string) *ListEndpointAccessInput {
	s.VpcId = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *ListEndpointAccessInput) SetWorkgroupName(v string) *ListEndpointAccessInput {
	s.WorkgroupName = &v
	return s
}

type ListEndpointAccessOutput struct {
	_ struct{} `type:"structure"`

	// The returned VPC endpoints.
	//
	// Endpoints is a required field
	Endpoints []*EndpointAccess `locationName:"endpoints" type:"list" required:"true"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEndpointAccessOutput) GoString() string {
	return s.String()
}

// SetEndpoints sets the Endpoints field's value.
func (s *ListEndpointAccessOutput) SetEndpoints(v []*EndpointAccess) *ListEndpointAccessOutput {
	s.Endpoints = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEndpointAccessOutput) SetNextToken(v string) *ListEndpointAccessOutput {
	s.NextToken = &v
	return s
}

type ListNamespacesInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListNamespaces operation returns a nextToken, you can include
	// the returned nextToken in following ListNamespaces operations, which returns
	// results in the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNamespacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNamespacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListNamespacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListNamespacesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListNamespacesInput) SetMaxResults(v int64) *ListNamespacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamespacesInput) SetNextToken(v string) *ListNamespacesInput {
	s.NextToken = &v
	return s
}

type ListNamespacesOutput struct {
	_ struct{} `type:"structure"`

	// The list of returned namespaces.
	//
	// Namespaces is a required field
	Namespaces []*Namespace `locationName:"namespaces" type:"list" required:"true"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNamespacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListNamespacesOutput) GoString() string {
	return s.String()
}

// SetNamespaces sets the Namespaces field's value.
func (s *ListNamespacesOutput) SetNamespaces(v []*Namespace) *ListNamespacesOutput {
	s.Namespaces = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListNamespacesOutput) SetNextToken(v string) *ListNamespacesOutput {
	s.NextToken = &v
	return s
}

type ListRecoveryPointsInput struct {
	_ struct{} `type:"structure"`

	// The time when creation of the recovery point finished.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the namespace from which to list recovery
	// points.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The name of the namespace to list recovery points for.
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string"`

	// If your initial ListRecoveryPoints operation returns a nextToken, you can
	// include the returned nextToken in following ListRecoveryPoints operations,
	// which returns results in the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The time when the recovery point's creation was initiated.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRecoveryPointsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRecoveryPointsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListRecoveryPointsInput) SetEndTime(v time.Time) *ListRecoveryPointsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListRecoveryPointsInput) SetMaxResults(v int64) *ListRecoveryPointsInput {
	s.MaxResults = &v
	return s
}

// SetNamespaceArn sets the NamespaceArn field's value.
func (s *ListRecoveryPointsInput) SetNamespaceArn(v string) *ListRecoveryPointsInput {
	s.NamespaceArn = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *ListRecoveryPointsInput) SetNamespaceName(v string) *ListRecoveryPointsInput {
	s.NamespaceName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryPointsInput) SetNextToken(v string) *ListRecoveryPointsInput {
	s.NextToken = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListRecoveryPointsInput) SetStartTime(v time.Time) *ListRecoveryPointsInput {
	s.StartTime = &v
	return s
}

type ListRecoveryPointsOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The returned recovery point objects.
	RecoveryPoints []*RecoveryPoint `locationName:"recoveryPoints" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListRecoveryPointsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListRecoveryPointsOutput) SetNextToken(v string) *ListRecoveryPointsOutput {
	s.NextToken = &v
	return s
}

// SetRecoveryPoints sets the RecoveryPoints field's value.
func (s *ListRecoveryPointsOutput) SetRecoveryPoints(v []*RecoveryPoint) *ListRecoveryPointsOutput {
	s.RecoveryPoints = v
	return s
}

type ListScheduledActionsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// Use nextToken to display the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The name of namespace associated with the scheduled action to retrieve.
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledActionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledActionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListScheduledActionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListScheduledActionsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}
	if s.NextToken != nil && len(*s.NextToken) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListScheduledActionsInput) SetMaxResults(v int64) *ListScheduledActionsInput {
	s.MaxResults = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *ListScheduledActionsInput) SetNamespaceName(v string) *ListScheduledActionsInput {
	s.NamespaceName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduledActionsInput) SetNextToken(v string) *ListScheduledActionsInput {
	s.NextToken = &v
	return s
}

type ListScheduledActionsOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`

	// All of the returned scheduled action association objects.
	ScheduledActions []*ScheduledActionAssociation `locationName:"scheduledActions" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledActionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListScheduledActionsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListScheduledActionsOutput) SetNextToken(v string) *ListScheduledActionsOutput {
	s.NextToken = &v
	return s
}

// SetScheduledActions sets the ScheduledActions field's value.
func (s *ListScheduledActionsOutput) SetScheduledActions(v []*ScheduledActionAssociation) *ListScheduledActionsOutput {
	s.ScheduledActions = v
	return s
}

type ListSnapshotCopyConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The namespace from which to list all snapshot copy configurations.
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotCopyConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotCopyConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSnapshotCopyConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSnapshotCopyConfigurationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}
	if s.NextToken != nil && len(*s.NextToken) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSnapshotCopyConfigurationsInput) SetMaxResults(v int64) *ListSnapshotCopyConfigurationsInput {
	s.MaxResults = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *ListSnapshotCopyConfigurationsInput) SetNamespaceName(v string) *ListSnapshotCopyConfigurationsInput {
	s.NamespaceName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSnapshotCopyConfigurationsInput) SetNextToken(v string) *ListSnapshotCopyConfigurationsInput {
	s.NextToken = &v
	return s
}

type ListSnapshotCopyConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`

	// All of the returned snapshot copy configurations.
	//
	// SnapshotCopyConfigurations is a required field
	SnapshotCopyConfigurations []*SnapshotCopyConfiguration `locationName:"snapshotCopyConfigurations" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotCopyConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotCopyConfigurationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSnapshotCopyConfigurationsOutput) SetNextToken(v string) *ListSnapshotCopyConfigurationsOutput {
	s.NextToken = &v
	return s
}

// SetSnapshotCopyConfigurations sets the SnapshotCopyConfigurations field's value.
func (s *ListSnapshotCopyConfigurationsOutput) SetSnapshotCopyConfigurations(v []*SnapshotCopyConfiguration) *ListSnapshotCopyConfigurationsOutput {
	s.SnapshotCopyConfigurations = v
	return s
}

type ListSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The timestamp showing when the snapshot creation finished.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The Amazon Resource Name (ARN) of the namespace from which to list all snapshots.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The namespace from which to list all snapshots.
	NamespaceName *string `locationName:"namespaceName" type:"string"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The owner Amazon Web Services account of the snapshot.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The time when the creation of the snapshot was initiated.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSnapshotsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *ListSnapshotsInput) SetEndTime(v time.Time) *ListSnapshotsInput {
	s.EndTime = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSnapshotsInput) SetMaxResults(v int64) *ListSnapshotsInput {
	s.MaxResults = &v
	return s
}

// SetNamespaceArn sets the NamespaceArn field's value.
func (s *ListSnapshotsInput) SetNamespaceArn(v string) *ListSnapshotsInput {
	s.NamespaceArn = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *ListSnapshotsInput) SetNamespaceName(v string) *ListSnapshotsInput {
	s.NamespaceName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSnapshotsInput) SetNextToken(v string) *ListSnapshotsInput {
	s.NextToken = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *ListSnapshotsInput) SetOwnerAccount(v string) *ListSnapshotsInput {
	s.OwnerAccount = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ListSnapshotsInput) SetStartTime(v time.Time) *ListSnapshotsInput {
	s.StartTime = &v
	return s
}

type ListSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// All of the returned snapshot objects.
	Snapshots []*Snapshot `locationName:"snapshots" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListSnapshotsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSnapshotsOutput) SetNextToken(v string) *ListSnapshotsOutput {
	s.NextToken = &v
	return s
}

// SetSnapshots sets the Snapshots field's value.
func (s *ListSnapshotsOutput) SetSnapshots(v []*Snapshot) *ListSnapshotsOutput {
	s.Snapshots = v
	return s
}

type ListTableRestoreStatusInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// The namespace from which to list all of the statuses of RestoreTableFromSnapshot
	// operations .
	NamespaceName *string `locationName:"namespaceName" type:"string"`

	// If your initial ListTableRestoreStatus operation returns a nextToken, you
	// can include the returned nextToken in following ListTableRestoreStatus operations.
	// This will return results on the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`

	// The workgroup from which to list all of the statuses of RestoreTableFromSnapshot
	// operations.
	WorkgroupName *string `locationName:"workgroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableRestoreStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableRestoreStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTableRestoreStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTableRestoreStatusInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListTableRestoreStatusInput) SetMaxResults(v int64) *ListTableRestoreStatusInput {
	s.MaxResults = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *ListTableRestoreStatusInput) SetNamespaceName(v string) *ListTableRestoreStatusInput {
	s.NamespaceName = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableRestoreStatusInput) SetNextToken(v string) *ListTableRestoreStatusInput {
	s.NextToken = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *ListTableRestoreStatusInput) SetWorkgroupName(v string) *ListTableRestoreStatusInput {
	s.WorkgroupName = &v
	return s
}

type ListTableRestoreStatusOutput struct {
	_ struct{} `type:"structure"`

	// If your initial ListTableRestoreStatus operation returns a nextToken, you
	// can include the returned nextToken in following ListTableRestoreStatus operations.
	// This will returns results on the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`

	// The array of returned TableRestoreStatus objects.
	TableRestoreStatuses []*TableRestoreStatus `locationName:"tableRestoreStatuses" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableRestoreStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTableRestoreStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListTableRestoreStatusOutput) SetNextToken(v string) *ListTableRestoreStatusOutput {
	s.NextToken = &v
	return s
}

// SetTableRestoreStatuses sets the TableRestoreStatuses field's value.
func (s *ListTableRestoreStatusOutput) SetTableRestoreStatuses(v []*TableRestoreStatus) *ListTableRestoreStatusOutput {
	s.TableRestoreStatuses = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to list tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// A map of the key-value pairs assigned to the resource.
	Tags []*Tag `locationName:"tags" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v []*Tag) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

type ListUsageLimitsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results. The default is 100.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListUsageLimits operation returns a nextToken, you can include
	// the returned nextToken in following ListUsageLimits operations, which returns
	// results in the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`

	// The Amazon Resource Name (ARN) associated with the resource whose usage limits
	// you want to list.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The Amazon Redshift Serverless feature whose limits you want to see.
	UsageType *string `locationName:"usageType" type:"string" enum:"UsageLimitUsageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsageLimitsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsageLimitsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUsageLimitsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListUsageLimitsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 8 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 8))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListUsageLimitsInput) SetMaxResults(v int64) *ListUsageLimitsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsageLimitsInput) SetNextToken(v string) *ListUsageLimitsInput {
	s.NextToken = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListUsageLimitsInput) SetResourceArn(v string) *ListUsageLimitsInput {
	s.ResourceArn = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *ListUsageLimitsInput) SetUsageType(v string) *ListUsageLimitsInput {
	s.UsageType = &v
	return s
}

type ListUsageLimitsOutput struct {
	_ struct{} `type:"structure"`

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again
	// using the returned token to retrieve the next page.
	NextToken *string `locationName:"nextToken" min:"8" type:"string"`

	// An array of returned usage limit objects.
	UsageLimits []*UsageLimit `locationName:"usageLimits" min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsageLimitsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListUsageLimitsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListUsageLimitsOutput) SetNextToken(v string) *ListUsageLimitsOutput {
	s.NextToken = &v
	return s
}

// SetUsageLimits sets the UsageLimits field's value.
func (s *ListUsageLimitsOutput) SetUsageLimits(v []*UsageLimit) *ListUsageLimitsOutput {
	s.UsageLimits = v
	return s
}

type ListWorkgroupsInput struct {
	_ struct{} `type:"structure"`

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to display the next page of results.
	MaxResults *int64 `locationName:"maxResults" min:"1" type:"integer"`

	// If your initial ListWorkgroups operation returns a nextToken, you can include
	// the returned nextToken in following ListNamespaces operations, which returns
	// results in the next page.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The owner Amazon Web Services account for the Amazon Redshift Serverless
	// workgroup.
	OwnerAccount *string `locationName:"ownerAccount" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkgroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkgroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkgroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkgroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.OwnerAccount != nil && len(*s.OwnerAccount) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OwnerAccount", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkgroupsInput) SetMaxResults(v int64) *ListWorkgroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkgroupsInput) SetNextToken(v string) *ListWorkgroupsInput {
	s.NextToken = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *ListWorkgroupsInput) SetOwnerAccount(v string) *ListWorkgroupsInput {
	s.OwnerAccount = &v
	return s
}

type ListWorkgroupsOutput struct {
	_ struct{} `type:"structure"`

	// If nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. To retrieve the next
	// page, make the call again using the returned token.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The returned array of workgroups.
	//
	// Workgroups is a required field
	Workgroups []*Workgroup `locationName:"workgroups" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkgroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkgroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkgroupsOutput) SetNextToken(v string) *ListWorkgroupsOutput {
	s.NextToken = &v
	return s
}

// SetWorkgroups sets the Workgroups field's value.
func (s *ListWorkgroupsOutput) SetWorkgroups(v []*Workgroup) *ListWorkgroupsOutput {
	s.Workgroups = v
	return s
}

// A collection of database objects and users.
type Namespace struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the namespace's admin user credentials
	// secret.
	AdminPasswordSecretArn *string `locationName:"adminPasswordSecretArn" type:"string"`

	// The ID of the Key Management Service (KMS) key used to encrypt and store
	// the namespace's admin credentials secret.
	AdminPasswordSecretKmsKeyId *string `locationName:"adminPasswordSecretKmsKeyId" type:"string"`

	// The username of the administrator for the first database created in the namespace.
	//
	// AdminUsername is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by Namespace's
	// String and GoString methods.
	AdminUsername *string `locationName:"adminUsername" type:"string" sensitive:"true"`

	// The date of when the namespace was created.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the first database created in the namespace.
	DbName *string `locationName:"dbName" type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role to set as a default in the
	// namespace.
	DefaultIamRoleArn *string `locationName:"defaultIamRoleArn" type:"string"`

	// A list of IAM roles to associate with the namespace.
	IamRoles []*string `locationName:"iamRoles" type:"list"`

	// The ID of the Amazon Web Services Key Management Service key used to encrypt
	// your data.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The types of logs the namespace can export. Available export types are User
	// log, Connection log, and User activity log.
	LogExports []*string `locationName:"logExports" type:"list" enum:"LogExport"`

	// The Amazon Resource Name (ARN) associated with a namespace.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The unique identifier of a namespace.
	NamespaceId *string `locationName:"namespaceId" type:"string"`

	// The name of the namespace. Must be between 3-64 alphanumeric characters in
	// lowercase, and it cannot be a reserved word. A list of reserved words can
	// be found in Reserved Words (https://docs.aws.amazon.com/redshift/latest/dg/r_pg_keywords.html)
	// in the Amazon Redshift Database Developer Guide.
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string"`

	// The status of the namespace.
	Status *string `locationName:"status" type:"string" enum:"NamespaceStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Namespace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Namespace) GoString() string {
	return s.String()
}

// SetAdminPasswordSecretArn sets the AdminPasswordSecretArn field's value.
func (s *Namespace) SetAdminPasswordSecretArn(v string) *Namespace {
	s.AdminPasswordSecretArn = &v
	return s
}

// SetAdminPasswordSecretKmsKeyId sets the AdminPasswordSecretKmsKeyId field's value.
func (s *Namespace) SetAdminPasswordSecretKmsKeyId(v string) *Namespace {
	s.AdminPasswordSecretKmsKeyId = &v
	return s
}

// SetAdminUsername sets the AdminUsername field's value.
func (s *Namespace) SetAdminUsername(v string) *Namespace {
	s.AdminUsername = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Namespace) SetCreationDate(v time.Time) *Namespace {
	s.CreationDate = &v
	return s
}

// SetDbName sets the DbName field's value.
func (s *Namespace) SetDbName(v string) *Namespace {
	s.DbName = &v
	return s
}

// SetDefaultIamRoleArn sets the DefaultIamRoleArn field's value.
func (s *Namespace) SetDefaultIamRoleArn(v string) *Namespace {
	s.DefaultIamRoleArn = &v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *Namespace) SetIamRoles(v []*string) *Namespace {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Namespace) SetKmsKeyId(v string) *Namespace {
	s.KmsKeyId = &v
	return s
}

// SetLogExports sets the LogExports field's value.
func (s *Namespace) SetLogExports(v []*string) *Namespace {
	s.LogExports = v
	return s
}

// SetNamespaceArn sets the NamespaceArn field's value.
func (s *Namespace) SetNamespaceArn(v string) *Namespace {
	s.NamespaceArn = &v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *Namespace) SetNamespaceId(v string) *Namespace {
	s.NamespaceId = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *Namespace) SetNamespaceName(v string) *Namespace {
	s.NamespaceName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Namespace) SetStatus(v string) *Namespace {
	s.Status = &v
	return s
}

// Contains information about a network interface in an Amazon Redshift Serverless
// managed VPC endpoint.
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// The availability Zone.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The IPv6 address of the network interface within the subnet.
	Ipv6Address *string `locationName:"ipv6Address" type:"string"`

	// The unique identifier of the network interface.
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// The IPv4 address of the network interface within the subnet.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// The unique identifier of the subnet.
	SubnetId *string `locationName:"subnetId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NetworkInterface) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *NetworkInterface) SetAvailabilityZone(v string) *NetworkInterface {
	s.AvailabilityZone = &v
	return s
}

// SetIpv6Address sets the Ipv6Address field's value.
func (s *NetworkInterface) SetIpv6Address(v string) *NetworkInterface {
	s.Ipv6Address = &v
	return s
}

// SetNetworkInterfaceId sets the NetworkInterfaceId field's value.
func (s *NetworkInterface) SetNetworkInterfaceId(v string) *NetworkInterface {
	s.NetworkInterfaceId = &v
	return s
}

// SetPrivateIpAddress sets the PrivateIpAddress field's value.
func (s *NetworkInterface) SetPrivateIpAddress(v string) *NetworkInterface {
	s.PrivateIpAddress = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *NetworkInterface) SetSubnetId(v string) *NetworkInterface {
	s.SubnetId = &v
	return s
}

type PutResourcePolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy to create or update. For example, the following policy grants
	// a user authorization to restore a snapshot.
	//
	// "{\"Version\": \"2012-10-17\", \"Statement\" : [{ \"Sid\": \"AllowUserRestoreFromSnapshot\",
	// \"Principal\":{\"AWS\": [\"739247239426\"]}, \"Action\": [\"redshift-serverless:RestoreFromSnapshot\"]
	// , \"Effect\": \"Allow\" }]}"
	//
	// Policy is a required field
	Policy *string `locationName:"policy" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the account to create or update a resource
	// policy for.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutResourcePolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutResourcePolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutResourcePolicyInput) SetPolicy(v string) *PutResourcePolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutResourcePolicyInput) SetResourceArn(v string) *PutResourcePolicyInput {
	s.ResourceArn = &v
	return s
}

type PutResourcePolicyOutput struct {
	_ struct{} `type:"structure"`

	// The policy that was created or updated.
	ResourcePolicy *ResourcePolicy `locationName:"resourcePolicy" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s PutResourcePolicyOutput) GoString() string {
	return s.String()
}

// SetResourcePolicy sets the ResourcePolicy field's value.
func (s *PutResourcePolicyOutput) SetResourcePolicy(v *ResourcePolicy) *PutResourcePolicyOutput {
	s.ResourcePolicy = v
	return s
}

// The automatically created recovery point of a namespace. Recovery points
// are created every 30 minutes and kept for 24 hours.
type RecoveryPoint struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the namespace the recovery point is associated
	// with.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The name of the namespace the recovery point is associated with.
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string"`

	// The time the recovery point is created.
	RecoveryPointCreateTime *time.Time `locationName:"recoveryPointCreateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The unique identifier of the recovery point.
	RecoveryPointId *string `locationName:"recoveryPointId" type:"string"`

	// The total size of the data in the recovery point in megabytes.
	TotalSizeInMegaBytes *float64 `locationName:"totalSizeInMegaBytes" type:"double"`

	// The name of the workgroup the recovery point is associated with.
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RecoveryPoint) GoString() string {
	return s.String()
}

// SetNamespaceArn sets the NamespaceArn field's value.
func (s *RecoveryPoint) SetNamespaceArn(v string) *RecoveryPoint {
	s.NamespaceArn = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *RecoveryPoint) SetNamespaceName(v string) *RecoveryPoint {
	s.NamespaceName = &v
	return s
}

// SetRecoveryPointCreateTime sets the RecoveryPointCreateTime field's value.
func (s *RecoveryPoint) SetRecoveryPointCreateTime(v time.Time) *RecoveryPoint {
	s.RecoveryPointCreateTime = &v
	return s
}

// SetRecoveryPointId sets the RecoveryPointId field's value.
func (s *RecoveryPoint) SetRecoveryPointId(v string) *RecoveryPoint {
	s.RecoveryPointId = &v
	return s
}

// SetTotalSizeInMegaBytes sets the TotalSizeInMegaBytes field's value.
func (s *RecoveryPoint) SetTotalSizeInMegaBytes(v float64) *RecoveryPoint {
	s.TotalSizeInMegaBytes = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *RecoveryPoint) SetWorkgroupName(v string) *RecoveryPoint {
	s.WorkgroupName = &v
	return s
}

// The resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the resource that could not be found.
	ResourceName *string `locationName:"resourceName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource policy object. Currently, you can use policies to share snapshots
// across Amazon Web Services accounts.
type ResourcePolicy struct {
	_ struct{} `type:"structure"`

	// The resource policy.
	Policy *string `locationName:"policy" type:"string"`

	// The Amazon Resource Name (ARN) of the policy.
	ResourceArn *string `locationName:"resourceArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePolicy) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourcePolicy) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *ResourcePolicy) SetPolicy(v string) *ResourcePolicy {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ResourcePolicy) SetResourceArn(v string) *ResourcePolicy {
	s.ResourceArn = &v
	return s
}

type RestoreFromRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// The name of the namespace to restore data into.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`

	// The unique identifier of the recovery point to restore from.
	//
	// RecoveryPointId is a required field
	RecoveryPointId *string `locationName:"recoveryPointId" type:"string" required:"true"`

	// The name of the workgroup used to restore data.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreFromRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreFromRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreFromRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreFromRecoveryPointInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}
	if s.RecoveryPointId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointId"))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *RestoreFromRecoveryPointInput) SetNamespaceName(v string) *RestoreFromRecoveryPointInput {
	s.NamespaceName = &v
	return s
}

// SetRecoveryPointId sets the RecoveryPointId field's value.
func (s *RestoreFromRecoveryPointInput) SetRecoveryPointId(v string) *RestoreFromRecoveryPointInput {
	s.RecoveryPointId = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *RestoreFromRecoveryPointInput) SetWorkgroupName(v string) *RestoreFromRecoveryPointInput {
	s.WorkgroupName = &v
	return s
}

type RestoreFromRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// The namespace that data was restored into.
	Namespace *Namespace `locationName:"namespace" type:"structure"`

	// The unique identifier of the recovery point used for the restore.
	RecoveryPointId *string `locationName:"recoveryPointId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreFromRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreFromRecoveryPointOutput) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *RestoreFromRecoveryPointOutput) SetNamespace(v *Namespace) *RestoreFromRecoveryPointOutput {
	s.Namespace = v
	return s
}

// SetRecoveryPointId sets the RecoveryPointId field's value.
func (s *RestoreFromRecoveryPointOutput) SetRecoveryPointId(v string) *RestoreFromRecoveryPointOutput {
	s.RecoveryPointId = &v
	return s
}

type RestoreFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Key Management Service (KMS) key used to encrypt and store
	// the namespace's admin credentials secret.
	AdminPasswordSecretKmsKeyId *string `locationName:"adminPasswordSecretKmsKeyId" type:"string"`

	// If true, Amazon Redshift uses Secrets Manager to manage the restored snapshot's
	// admin credentials. If MmanageAdminPassword is false or not set, Amazon Redshift
	// uses the admin credentials that the namespace or cluster had at the time
	// the snapshot was taken.
	ManageAdminPassword *bool `locationName:"manageAdminPassword" type:"boolean"`

	// The name of the namespace to restore the snapshot to.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`

	// The Amazon Web Services account that owns the snapshot.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The Amazon Resource Name (ARN) of the snapshot to restore from. Required
	// if restoring from Amazon Redshift Serverless to a provisioned cluster. Must
	// not be specified at the same time as snapshotName.
	//
	// The format of the ARN is arn:aws:redshift:<region>:<account_id>:snapshot:<cluster_identifier>/<snapshot_identifier>.
	SnapshotArn *string `locationName:"snapshotArn" type:"string"`

	// The name of the snapshot to restore from. Must not be specified at the same
	// time as snapshotArn.
	SnapshotName *string `locationName:"snapshotName" type:"string"`

	// The name of the workgroup used to restore the snapshot.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreFromSnapshotInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminPasswordSecretKmsKeyId sets the AdminPasswordSecretKmsKeyId field's value.
func (s *RestoreFromSnapshotInput) SetAdminPasswordSecretKmsKeyId(v string) *RestoreFromSnapshotInput {
	s.AdminPasswordSecretKmsKeyId = &v
	return s
}

// SetManageAdminPassword sets the ManageAdminPassword field's value.
func (s *RestoreFromSnapshotInput) SetManageAdminPassword(v bool) *RestoreFromSnapshotInput {
	s.ManageAdminPassword = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *RestoreFromSnapshotInput) SetNamespaceName(v string) *RestoreFromSnapshotInput {
	s.NamespaceName = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *RestoreFromSnapshotInput) SetOwnerAccount(v string) *RestoreFromSnapshotInput {
	s.OwnerAccount = &v
	return s
}

// SetSnapshotArn sets the SnapshotArn field's value.
func (s *RestoreFromSnapshotInput) SetSnapshotArn(v string) *RestoreFromSnapshotInput {
	s.SnapshotArn = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *RestoreFromSnapshotInput) SetSnapshotName(v string) *RestoreFromSnapshotInput {
	s.SnapshotName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *RestoreFromSnapshotInput) SetWorkgroupName(v string) *RestoreFromSnapshotInput {
	s.WorkgroupName = &v
	return s
}

type RestoreFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// A collection of database objects and users.
	Namespace *Namespace `locationName:"namespace" type:"structure"`

	// The owner Amazon Web Services; account of the snapshot that was restored.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The name of the snapshot used to restore the namespace.
	SnapshotName *string `locationName:"snapshotName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *RestoreFromSnapshotOutput) SetNamespace(v *Namespace) *RestoreFromSnapshotOutput {
	s.Namespace = v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *RestoreFromSnapshotOutput) SetOwnerAccount(v string) *RestoreFromSnapshotOutput {
	s.OwnerAccount = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *RestoreFromSnapshotOutput) SetSnapshotName(v string) *RestoreFromSnapshotOutput {
	s.SnapshotName = &v
	return s
}

type RestoreTableFromRecoveryPointInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether name identifiers for database, schema, and table are case
	// sensitive. If true, the names are case sensitive. If false, the names are
	// not case sensitive. The default is false.
	ActivateCaseSensitiveIdentifier *bool `locationName:"activateCaseSensitiveIdentifier" type:"boolean"`

	// Namespace of the recovery point to restore from.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" type:"string" required:"true"`

	// The name of the table to create from the restore operation.
	//
	// NewTableName is a required field
	NewTableName *string `locationName:"newTableName" type:"string" required:"true"`

	// The ID of the recovery point to restore the table from.
	//
	// RecoveryPointId is a required field
	RecoveryPointId *string `locationName:"recoveryPointId" type:"string" required:"true"`

	// The name of the source database that contains the table being restored.
	//
	// SourceDatabaseName is a required field
	SourceDatabaseName *string `locationName:"sourceDatabaseName" type:"string" required:"true"`

	// The name of the source schema that contains the table being restored.
	SourceSchemaName *string `locationName:"sourceSchemaName" type:"string"`

	// The name of the source table being restored.
	//
	// SourceTableName is a required field
	SourceTableName *string `locationName:"sourceTableName" type:"string" required:"true"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `locationName:"targetDatabaseName" type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `locationName:"targetSchemaName" type:"string"`

	// The workgroup to restore the table to.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableFromRecoveryPointInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableFromRecoveryPointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableFromRecoveryPointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTableFromRecoveryPointInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NewTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("NewTableName"))
	}
	if s.RecoveryPointId == nil {
		invalidParams.Add(request.NewErrParamRequired("RecoveryPointId"))
	}
	if s.SourceDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDatabaseName"))
	}
	if s.SourceTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceTableName"))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivateCaseSensitiveIdentifier sets the ActivateCaseSensitiveIdentifier field's value.
func (s *RestoreTableFromRecoveryPointInput) SetActivateCaseSensitiveIdentifier(v bool) *RestoreTableFromRecoveryPointInput {
	s.ActivateCaseSensitiveIdentifier = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *RestoreTableFromRecoveryPointInput) SetNamespaceName(v string) *RestoreTableFromRecoveryPointInput {
	s.NamespaceName = &v
	return s
}

// SetNewTableName sets the NewTableName field's value.
func (s *RestoreTableFromRecoveryPointInput) SetNewTableName(v string) *RestoreTableFromRecoveryPointInput {
	s.NewTableName = &v
	return s
}

// SetRecoveryPointId sets the RecoveryPointId field's value.
func (s *RestoreTableFromRecoveryPointInput) SetRecoveryPointId(v string) *RestoreTableFromRecoveryPointInput {
	s.RecoveryPointId = &v
	return s
}

// SetSourceDatabaseName sets the SourceDatabaseName field's value.
func (s *RestoreTableFromRecoveryPointInput) SetSourceDatabaseName(v string) *RestoreTableFromRecoveryPointInput {
	s.SourceDatabaseName = &v
	return s
}

// SetSourceSchemaName sets the SourceSchemaName field's value.
func (s *RestoreTableFromRecoveryPointInput) SetSourceSchemaName(v string) *RestoreTableFromRecoveryPointInput {
	s.SourceSchemaName = &v
	return s
}

// SetSourceTableName sets the SourceTableName field's value.
func (s *RestoreTableFromRecoveryPointInput) SetSourceTableName(v string) *RestoreTableFromRecoveryPointInput {
	s.SourceTableName = &v
	return s
}

// SetTargetDatabaseName sets the TargetDatabaseName field's value.
func (s *RestoreTableFromRecoveryPointInput) SetTargetDatabaseName(v string) *RestoreTableFromRecoveryPointInput {
	s.TargetDatabaseName = &v
	return s
}

// SetTargetSchemaName sets the TargetSchemaName field's value.
func (s *RestoreTableFromRecoveryPointInput) SetTargetSchemaName(v string) *RestoreTableFromRecoveryPointInput {
	s.TargetSchemaName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *RestoreTableFromRecoveryPointInput) SetWorkgroupName(v string) *RestoreTableFromRecoveryPointInput {
	s.WorkgroupName = &v
	return s
}

type RestoreTableFromRecoveryPointOutput struct {
	_ struct{} `type:"structure"`

	// Contains information about a table restore request.
	TableRestoreStatus *TableRestoreStatus `locationName:"tableRestoreStatus" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableFromRecoveryPointOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableFromRecoveryPointOutput) GoString() string {
	return s.String()
}

// SetTableRestoreStatus sets the TableRestoreStatus field's value.
func (s *RestoreTableFromRecoveryPointOutput) SetTableRestoreStatus(v *TableRestoreStatus) *RestoreTableFromRecoveryPointOutput {
	s.TableRestoreStatus = v
	return s
}

type RestoreTableFromSnapshotInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether name identifiers for database, schema, and table are case
	// sensitive. If true, the names are case sensitive. If false, the names are
	// not case sensitive. The default is false.
	ActivateCaseSensitiveIdentifier *bool `locationName:"activateCaseSensitiveIdentifier" type:"boolean"`

	// The namespace of the snapshot to restore from.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" type:"string" required:"true"`

	// The name of the table to create from the restore operation.
	//
	// NewTableName is a required field
	NewTableName *string `locationName:"newTableName" type:"string" required:"true"`

	// The name of the snapshot to restore the table from.
	//
	// SnapshotName is a required field
	SnapshotName *string `locationName:"snapshotName" type:"string" required:"true"`

	// The name of the source database that contains the table being restored.
	//
	// SourceDatabaseName is a required field
	SourceDatabaseName *string `locationName:"sourceDatabaseName" type:"string" required:"true"`

	// The name of the source schema that contains the table being restored.
	SourceSchemaName *string `locationName:"sourceSchemaName" type:"string"`

	// The name of the source table being restored.
	//
	// SourceTableName is a required field
	SourceTableName *string `locationName:"sourceTableName" type:"string" required:"true"`

	// The name of the database to restore the table to.
	TargetDatabaseName *string `locationName:"targetDatabaseName" type:"string"`

	// The name of the schema to restore the table to.
	TargetSchemaName *string `locationName:"targetSchemaName" type:"string"`

	// The workgroup to restore the table to.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableFromSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableFromSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreTableFromSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreTableFromSnapshotInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NewTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("NewTableName"))
	}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}
	if s.SourceDatabaseName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceDatabaseName"))
	}
	if s.SourceTableName == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceTableName"))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActivateCaseSensitiveIdentifier sets the ActivateCaseSensitiveIdentifier field's value.
func (s *RestoreTableFromSnapshotInput) SetActivateCaseSensitiveIdentifier(v bool) *RestoreTableFromSnapshotInput {
	s.ActivateCaseSensitiveIdentifier = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *RestoreTableFromSnapshotInput) SetNamespaceName(v string) *RestoreTableFromSnapshotInput {
	s.NamespaceName = &v
	return s
}

// SetNewTableName sets the NewTableName field's value.
func (s *RestoreTableFromSnapshotInput) SetNewTableName(v string) *RestoreTableFromSnapshotInput {
	s.NewTableName = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *RestoreTableFromSnapshotInput) SetSnapshotName(v string) *RestoreTableFromSnapshotInput {
	s.SnapshotName = &v
	return s
}

// SetSourceDatabaseName sets the SourceDatabaseName field's value.
func (s *RestoreTableFromSnapshotInput) SetSourceDatabaseName(v string) *RestoreTableFromSnapshotInput {
	s.SourceDatabaseName = &v
	return s
}

// SetSourceSchemaName sets the SourceSchemaName field's value.
func (s *RestoreTableFromSnapshotInput) SetSourceSchemaName(v string) *RestoreTableFromSnapshotInput {
	s.SourceSchemaName = &v
	return s
}

// SetSourceTableName sets the SourceTableName field's value.
func (s *RestoreTableFromSnapshotInput) SetSourceTableName(v string) *RestoreTableFromSnapshotInput {
	s.SourceTableName = &v
	return s
}

// SetTargetDatabaseName sets the TargetDatabaseName field's value.
func (s *RestoreTableFromSnapshotInput) SetTargetDatabaseName(v string) *RestoreTableFromSnapshotInput {
	s.TargetDatabaseName = &v
	return s
}

// SetTargetSchemaName sets the TargetSchemaName field's value.
func (s *RestoreTableFromSnapshotInput) SetTargetSchemaName(v string) *RestoreTableFromSnapshotInput {
	s.TargetSchemaName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *RestoreTableFromSnapshotInput) SetWorkgroupName(v string) *RestoreTableFromSnapshotInput {
	s.WorkgroupName = &v
	return s
}

type RestoreTableFromSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The TableRestoreStatus object that contains the status of the restore operation.
	TableRestoreStatus *TableRestoreStatus `locationName:"tableRestoreStatus" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableFromSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreTableFromSnapshotOutput) GoString() string {
	return s.String()
}

// SetTableRestoreStatus sets the TableRestoreStatus field's value.
func (s *RestoreTableFromSnapshotOutput) SetTableRestoreStatus(v *TableRestoreStatus) *RestoreTableFromSnapshotOutput {
	s.TableRestoreStatus = v
	return s
}

// The schedule of when Amazon Redshift Serverless should run the scheduled
// action.
type Schedule struct {
	_ struct{} `type:"structure"`

	// The timestamp of when Amazon Redshift Serverless should run the scheduled
	// action. Timestamp is in UTC. Format of at expression is yyyy-mm-ddThh:mm:ss.
	// For example, 2016-03-04T17:27:00.
	At *time.Time `locationName:"at" type:"timestamp"`

	// The cron expression to use to schedule a recurring scheduled action. Schedule
	// invocations must be separated by at least one hour. Times are in UTC.
	//
	// Format of cron expressions is (Minutes Hours Day-of-month Month Day-of-week
	// Year). For example, "(0 10 ? * MON *)". For more information, see Cron Expressions
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	// in the Amazon CloudWatch Events User Guide.
	Cron *string `locationName:"cron" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Schedule) GoString() string {
	return s.String()
}

// SetAt sets the At field's value.
func (s *Schedule) SetAt(v time.Time) *Schedule {
	s.At = &v
	return s
}

// SetCron sets the Cron field's value.
func (s *Schedule) SetCron(v string) *Schedule {
	s.Cron = &v
	return s
}

// Contains names of objects associated with a scheduled action.
type ScheduledActionAssociation struct {
	_ struct{} `type:"structure"`

	// Name of associated Amazon Redshift Serverless namespace.
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string"`

	// Name of associated scheduled action.
	ScheduledActionName *string `locationName:"scheduledActionName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledActionAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledActionAssociation) GoString() string {
	return s.String()
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *ScheduledActionAssociation) SetNamespaceName(v string) *ScheduledActionAssociation {
	s.NamespaceName = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *ScheduledActionAssociation) SetScheduledActionName(v string) *ScheduledActionAssociation {
	s.ScheduledActionName = &v
	return s
}

// The returned scheduled action object.
type ScheduledActionResponse struct {
	_ struct{} `type:"structure"`

	// The end time of
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The end time in UTC when the schedule is no longer active. After this time,
	// the scheduled action does not trigger.
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string"`

	// An array of timestamps of when the next scheduled actions will trigger.
	NextInvocations []*time.Time `locationName:"nextInvocations" type:"list"`

	// The ARN of the IAM role to assume to run the scheduled action. This IAM role
	// must have permission to run the Amazon Redshift Serverless API operation
	// in the scheduled action. This IAM role must allow the Amazon Redshift scheduler
	// to schedule creating snapshots. (Principal scheduler.redshift.amazonaws.com)
	// to assume permissions on your behalf. For more information about the IAM
	// role to use with the Amazon Redshift scheduler, see Using Identity-Based
	// Policies for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Management Guide
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The schedule for a one-time (at timestamp format) or recurring (cron format)
	// scheduled action. Schedule invocations must be separated by at least one
	// hour. Times are in UTC.
	//
	//    * Format of at timestamp is yyyy-mm-ddThh:mm:ss. For example, 2016-03-04T17:27:00.
	//
	//    * Format of cron expression is (Minutes Hours Day-of-month Month Day-of-week
	//    Year). For example, "(0 10 ? * MON *)". For more information, see Cron
	//    Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	//    in the Amazon CloudWatch Events User Guide.
	Schedule *Schedule `locationName:"schedule" type:"structure"`

	// The description of the scheduled action.
	ScheduledActionDescription *string `locationName:"scheduledActionDescription" type:"string"`

	// The name of the scheduled action.
	ScheduledActionName *string `locationName:"scheduledActionName" min:"3" type:"string"`

	// The uuid of the scheduled action.
	ScheduledActionUuid *string `locationName:"scheduledActionUuid" type:"string"`

	// The start time in UTC when the schedule is active. Before this time, the
	// scheduled action does not trigger.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// The state of the scheduled action.
	State *string `locationName:"state" type:"string" enum:"State"`

	// A JSON format string of the Amazon Redshift Serverless API operation with
	// input parameters. The following is an example of a target action.
	//
	// "{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot",
	// "retentionPeriod": "1"}}"
	TargetAction *TargetAction `locationName:"targetAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledActionResponse) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduledActionResponse) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *ScheduledActionResponse) SetEndTime(v time.Time) *ScheduledActionResponse {
	s.EndTime = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *ScheduledActionResponse) SetNamespaceName(v string) *ScheduledActionResponse {
	s.NamespaceName = &v
	return s
}

// SetNextInvocations sets the NextInvocations field's value.
func (s *ScheduledActionResponse) SetNextInvocations(v []*time.Time) *ScheduledActionResponse {
	s.NextInvocations = v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *ScheduledActionResponse) SetRoleArn(v string) *ScheduledActionResponse {
	s.RoleArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *ScheduledActionResponse) SetSchedule(v *Schedule) *ScheduledActionResponse {
	s.Schedule = v
	return s
}

// SetScheduledActionDescription sets the ScheduledActionDescription field's value.
func (s *ScheduledActionResponse) SetScheduledActionDescription(v string) *ScheduledActionResponse {
	s.ScheduledActionDescription = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *ScheduledActionResponse) SetScheduledActionName(v string) *ScheduledActionResponse {
	s.ScheduledActionName = &v
	return s
}

// SetScheduledActionUuid sets the ScheduledActionUuid field's value.
func (s *ScheduledActionResponse) SetScheduledActionUuid(v string) *ScheduledActionResponse {
	s.ScheduledActionUuid = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *ScheduledActionResponse) SetStartTime(v time.Time) *ScheduledActionResponse {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *ScheduledActionResponse) SetState(v string) *ScheduledActionResponse {
	s.State = &v
	return s
}

// SetTargetAction sets the TargetAction field's value.
func (s *ScheduledActionResponse) SetTargetAction(v *TargetAction) *ScheduledActionResponse {
	s.TargetAction = v
	return s
}

// The service limit was exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A snapshot object that contains databases.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// All of the Amazon Web Services accounts that have access to restore a snapshot
	// to a provisioned cluster.
	AccountsWithProvisionedRestoreAccess []*string `locationName:"accountsWithProvisionedRestoreAccess" type:"list"`

	// All of the Amazon Web Services accounts that have access to restore a snapshot
	// to a namespace.
	AccountsWithRestoreAccess []*string `locationName:"accountsWithRestoreAccess" type:"list"`

	// The size of the incremental backup in megabytes.
	ActualIncrementalBackupSizeInMegaBytes *float64 `locationName:"actualIncrementalBackupSizeInMegaBytes" type:"double"`

	// The Amazon Resource Name (ARN) for the namespace's admin user credentials
	// secret.
	AdminPasswordSecretArn *string `locationName:"adminPasswordSecretArn" type:"string"`

	// The ID of the Key Management Service (KMS) key used to encrypt and store
	// the namespace's admin credentials secret.
	AdminPasswordSecretKmsKeyId *string `locationName:"adminPasswordSecretKmsKeyId" type:"string"`

	// The username of the database within a snapshot.
	AdminUsername *string `locationName:"adminUsername" type:"string"`

	// The size in megabytes of the data that has been backed up to a snapshot.
	BackupProgressInMegaBytes *float64 `locationName:"backupProgressInMegaBytes" type:"double"`

	// The rate at which data is backed up into a snapshot in megabytes per second.
	CurrentBackupRateInMegaBytesPerSecond *float64 `locationName:"currentBackupRateInMegaBytesPerSecond" type:"double"`

	// The amount of time it took to back up data into a snapshot.
	ElapsedTimeInSeconds *int64 `locationName:"elapsedTimeInSeconds" type:"long"`

	// The estimated amount of seconds until the snapshot completes backup.
	EstimatedSecondsToCompletion *int64 `locationName:"estimatedSecondsToCompletion" type:"long"`

	// The unique identifier of the KMS key used to encrypt the snapshot.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The Amazon Resource Name (ARN) of the namespace the snapshot was created
	// from.
	NamespaceArn *string `locationName:"namespaceArn" type:"string"`

	// The name of the namepsace.
	NamespaceName *string `locationName:"namespaceName" type:"string"`

	// The owner Amazon Web Services; account of the snapshot.
	OwnerAccount *string `locationName:"ownerAccount" type:"string"`

	// The Amazon Resource Name (ARN) of the snapshot.
	SnapshotArn *string `locationName:"snapshotArn" type:"string"`

	// The timestamp of when the snapshot was created.
	SnapshotCreateTime *time.Time `locationName:"snapshotCreateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the snapshot.
	SnapshotName *string `locationName:"snapshotName" type:"string"`

	// The amount of days until the snapshot is deleted.
	SnapshotRemainingDays *int64 `locationName:"snapshotRemainingDays" type:"integer"`

	// The period of time, in days, of how long the snapshot is retained.
	SnapshotRetentionPeriod *int64 `locationName:"snapshotRetentionPeriod" type:"integer"`

	// The timestamp of when data within the snapshot started getting retained.
	SnapshotRetentionStartTime *time.Time `locationName:"snapshotRetentionStartTime" type:"timestamp" timestampFormat:"iso8601"`

	// The status of the snapshot.
	Status *string `locationName:"status" type:"string" enum:"SnapshotStatus"`

	// The total size, in megabytes, of how big the snapshot is.
	TotalBackupSizeInMegaBytes *float64 `locationName:"totalBackupSizeInMegaBytes" type:"double"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Snapshot) GoString() string {
	return s.String()
}

// SetAccountsWithProvisionedRestoreAccess sets the AccountsWithProvisionedRestoreAccess field's value.
func (s *Snapshot) SetAccountsWithProvisionedRestoreAccess(v []*string) *Snapshot {
	s.AccountsWithProvisionedRestoreAccess = v
	return s
}

// SetAccountsWithRestoreAccess sets the AccountsWithRestoreAccess field's value.
func (s *Snapshot) SetAccountsWithRestoreAccess(v []*string) *Snapshot {
	s.AccountsWithRestoreAccess = v
	return s
}

// SetActualIncrementalBackupSizeInMegaBytes sets the ActualIncrementalBackupSizeInMegaBytes field's value.
func (s *Snapshot) SetActualIncrementalBackupSizeInMegaBytes(v float64) *Snapshot {
	s.ActualIncrementalBackupSizeInMegaBytes = &v
	return s
}

// SetAdminPasswordSecretArn sets the AdminPasswordSecretArn field's value.
func (s *Snapshot) SetAdminPasswordSecretArn(v string) *Snapshot {
	s.AdminPasswordSecretArn = &v
	return s
}

// SetAdminPasswordSecretKmsKeyId sets the AdminPasswordSecretKmsKeyId field's value.
func (s *Snapshot) SetAdminPasswordSecretKmsKeyId(v string) *Snapshot {
	s.AdminPasswordSecretKmsKeyId = &v
	return s
}

// SetAdminUsername sets the AdminUsername field's value.
func (s *Snapshot) SetAdminUsername(v string) *Snapshot {
	s.AdminUsername = &v
	return s
}

// SetBackupProgressInMegaBytes sets the BackupProgressInMegaBytes field's value.
func (s *Snapshot) SetBackupProgressInMegaBytes(v float64) *Snapshot {
	s.BackupProgressInMegaBytes = &v
	return s
}

// SetCurrentBackupRateInMegaBytesPerSecond sets the CurrentBackupRateInMegaBytesPerSecond field's value.
func (s *Snapshot) SetCurrentBackupRateInMegaBytesPerSecond(v float64) *Snapshot {
	s.CurrentBackupRateInMegaBytesPerSecond = &v
	return s
}

// SetElapsedTimeInSeconds sets the ElapsedTimeInSeconds field's value.
func (s *Snapshot) SetElapsedTimeInSeconds(v int64) *Snapshot {
	s.ElapsedTimeInSeconds = &v
	return s
}

// SetEstimatedSecondsToCompletion sets the EstimatedSecondsToCompletion field's value.
func (s *Snapshot) SetEstimatedSecondsToCompletion(v int64) *Snapshot {
	s.EstimatedSecondsToCompletion = &v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *Snapshot) SetKmsKeyId(v string) *Snapshot {
	s.KmsKeyId = &v
	return s
}

// SetNamespaceArn sets the NamespaceArn field's value.
func (s *Snapshot) SetNamespaceArn(v string) *Snapshot {
	s.NamespaceArn = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *Snapshot) SetNamespaceName(v string) *Snapshot {
	s.NamespaceName = &v
	return s
}

// SetOwnerAccount sets the OwnerAccount field's value.
func (s *Snapshot) SetOwnerAccount(v string) *Snapshot {
	s.OwnerAccount = &v
	return s
}

// SetSnapshotArn sets the SnapshotArn field's value.
func (s *Snapshot) SetSnapshotArn(v string) *Snapshot {
	s.SnapshotArn = &v
	return s
}

// SetSnapshotCreateTime sets the SnapshotCreateTime field's value.
func (s *Snapshot) SetSnapshotCreateTime(v time.Time) *Snapshot {
	s.SnapshotCreateTime = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *Snapshot) SetSnapshotName(v string) *Snapshot {
	s.SnapshotName = &v
	return s
}

// SetSnapshotRemainingDays sets the SnapshotRemainingDays field's value.
func (s *Snapshot) SetSnapshotRemainingDays(v int64) *Snapshot {
	s.SnapshotRemainingDays = &v
	return s
}

// SetSnapshotRetentionPeriod sets the SnapshotRetentionPeriod field's value.
func (s *Snapshot) SetSnapshotRetentionPeriod(v int64) *Snapshot {
	s.SnapshotRetentionPeriod = &v
	return s
}

// SetSnapshotRetentionStartTime sets the SnapshotRetentionStartTime field's value.
func (s *Snapshot) SetSnapshotRetentionStartTime(v time.Time) *Snapshot {
	s.SnapshotRetentionStartTime = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Snapshot) SetStatus(v string) *Snapshot {
	s.Status = &v
	return s
}

// SetTotalBackupSizeInMegaBytes sets the TotalBackupSizeInMegaBytes field's value.
func (s *Snapshot) SetTotalBackupSizeInMegaBytes(v float64) *Snapshot {
	s.TotalBackupSizeInMegaBytes = &v
	return s
}

// The object that you configure to copy snapshots from one namespace to a namespace
// in another Amazon Web Services Region.
type SnapshotCopyConfiguration struct {
	_ struct{} `type:"structure"`

	// The ID of the KMS key to use to encrypt your snapshots in the destination
	// Amazon Web Services Region.
	DestinationKmsKeyId *string `locationName:"destinationKmsKeyId" type:"string"`

	// The destination Amazon Web Services Region to copy snapshots to.
	DestinationRegion *string `locationName:"destinationRegion" type:"string"`

	// The name of the namespace to copy snapshots from in the source Amazon Web
	// Services Region.
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string"`

	// The ARN of the snapshot copy configuration object.
	SnapshotCopyConfigurationArn *string `locationName:"snapshotCopyConfigurationArn" type:"string"`

	// The ID of the snapshot copy configuration object.
	SnapshotCopyConfigurationId *string `locationName:"snapshotCopyConfigurationId" type:"string"`

	// The retention period of snapshots that are copied to the destination Amazon
	// Web Services Region.
	SnapshotRetentionPeriod *int64 `locationName:"snapshotRetentionPeriod" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotCopyConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SnapshotCopyConfiguration) GoString() string {
	return s.String()
}

// SetDestinationKmsKeyId sets the DestinationKmsKeyId field's value.
func (s *SnapshotCopyConfiguration) SetDestinationKmsKeyId(v string) *SnapshotCopyConfiguration {
	s.DestinationKmsKeyId = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *SnapshotCopyConfiguration) SetDestinationRegion(v string) *SnapshotCopyConfiguration {
	s.DestinationRegion = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *SnapshotCopyConfiguration) SetNamespaceName(v string) *SnapshotCopyConfiguration {
	s.NamespaceName = &v
	return s
}

// SetSnapshotCopyConfigurationArn sets the SnapshotCopyConfigurationArn field's value.
func (s *SnapshotCopyConfiguration) SetSnapshotCopyConfigurationArn(v string) *SnapshotCopyConfiguration {
	s.SnapshotCopyConfigurationArn = &v
	return s
}

// SetSnapshotCopyConfigurationId sets the SnapshotCopyConfigurationId field's value.
func (s *SnapshotCopyConfiguration) SetSnapshotCopyConfigurationId(v string) *SnapshotCopyConfiguration {
	s.SnapshotCopyConfigurationId = &v
	return s
}

// SetSnapshotRetentionPeriod sets the SnapshotRetentionPeriod field's value.
func (s *SnapshotCopyConfiguration) SetSnapshotRetentionPeriod(v int64) *SnapshotCopyConfiguration {
	s.SnapshotRetentionPeriod = &v
	return s
}

// Contains information about a table restore request.
type TableRestoreStatus struct {
	_ struct{} `type:"structure"`

	// A message that explains the returned status. For example, if the status of
	// the operation is FAILED, the message explains why the operation failed.
	Message *string `locationName:"message" type:"string"`

	// The namespace of the table being restored from.
	NamespaceName *string `locationName:"namespaceName" type:"string"`

	// The name of the table to create from the restore operation.
	NewTableName *string `locationName:"newTableName" type:"string"`

	// The amount of data restored to the new table so far, in megabytes (MB).
	ProgressInMegaBytes *int64 `locationName:"progressInMegaBytes" type:"long"`

	// The ID of the recovery point being restored from.
	RecoveryPointId *string `locationName:"recoveryPointId" type:"string"`

	// The time that the table restore request was made, in Universal Coordinated
	// Time (UTC).
	RequestTime *time.Time `locationName:"requestTime" type:"timestamp"`

	// The name of the snapshot being restored from.
	SnapshotName *string `locationName:"snapshotName" type:"string"`

	// The name of the source database being restored from.
	SourceDatabaseName *string `locationName:"sourceDatabaseName" type:"string"`

	// The name of the source schema being restored from.
	SourceSchemaName *string `locationName:"sourceSchemaName" type:"string"`

	// The name of the source table being restored from.
	SourceTableName *string `locationName:"sourceTableName" type:"string"`

	// A value that describes the current state of the table restore request. Possible
	// values are SUCCEEDED, FAILED, CANCELED, PENDING, and IN_PROGRESS.
	Status *string `locationName:"status" type:"string"`

	// The ID of the RestoreTableFromSnapshot request.
	TableRestoreRequestId *string `locationName:"tableRestoreRequestId" type:"string"`

	// The name of the database to restore to.
	TargetDatabaseName *string `locationName:"targetDatabaseName" type:"string"`

	// The name of the schema to restore to.
	TargetSchemaName *string `locationName:"targetSchemaName" type:"string"`

	// The total amount of data to restore to the new table, in megabytes (MB).
	TotalDataInMegaBytes *int64 `locationName:"totalDataInMegaBytes" type:"long"`

	// The name of the workgroup being restored from.
	WorkgroupName *string `locationName:"workgroupName" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableRestoreStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TableRestoreStatus) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *TableRestoreStatus) SetMessage(v string) *TableRestoreStatus {
	s.Message = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *TableRestoreStatus) SetNamespaceName(v string) *TableRestoreStatus {
	s.NamespaceName = &v
	return s
}

// SetNewTableName sets the NewTableName field's value.
func (s *TableRestoreStatus) SetNewTableName(v string) *TableRestoreStatus {
	s.NewTableName = &v
	return s
}

// SetProgressInMegaBytes sets the ProgressInMegaBytes field's value.
func (s *TableRestoreStatus) SetProgressInMegaBytes(v int64) *TableRestoreStatus {
	s.ProgressInMegaBytes = &v
	return s
}

// SetRecoveryPointId sets the RecoveryPointId field's value.
func (s *TableRestoreStatus) SetRecoveryPointId(v string) *TableRestoreStatus {
	s.RecoveryPointId = &v
	return s
}

// SetRequestTime sets the RequestTime field's value.
func (s *TableRestoreStatus) SetRequestTime(v time.Time) *TableRestoreStatus {
	s.RequestTime = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *TableRestoreStatus) SetSnapshotName(v string) *TableRestoreStatus {
	s.SnapshotName = &v
	return s
}

// SetSourceDatabaseName sets the SourceDatabaseName field's value.
func (s *TableRestoreStatus) SetSourceDatabaseName(v string) *TableRestoreStatus {
	s.SourceDatabaseName = &v
	return s
}

// SetSourceSchemaName sets the SourceSchemaName field's value.
func (s *TableRestoreStatus) SetSourceSchemaName(v string) *TableRestoreStatus {
	s.SourceSchemaName = &v
	return s
}

// SetSourceTableName sets the SourceTableName field's value.
func (s *TableRestoreStatus) SetSourceTableName(v string) *TableRestoreStatus {
	s.SourceTableName = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *TableRestoreStatus) SetStatus(v string) *TableRestoreStatus {
	s.Status = &v
	return s
}

// SetTableRestoreRequestId sets the TableRestoreRequestId field's value.
func (s *TableRestoreStatus) SetTableRestoreRequestId(v string) *TableRestoreStatus {
	s.TableRestoreRequestId = &v
	return s
}

// SetTargetDatabaseName sets the TargetDatabaseName field's value.
func (s *TableRestoreStatus) SetTargetDatabaseName(v string) *TableRestoreStatus {
	s.TargetDatabaseName = &v
	return s
}

// SetTargetSchemaName sets the TargetSchemaName field's value.
func (s *TableRestoreStatus) SetTargetSchemaName(v string) *TableRestoreStatus {
	s.TargetSchemaName = &v
	return s
}

// SetTotalDataInMegaBytes sets the TotalDataInMegaBytes field's value.
func (s *TableRestoreStatus) SetTotalDataInMegaBytes(v int64) *TableRestoreStatus {
	s.TotalDataInMegaBytes = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *TableRestoreStatus) SetWorkgroupName(v string) *TableRestoreStatus {
	s.WorkgroupName = &v
	return s
}

// A map of key-value pairs.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key to use in the tag.
	//
	// Key is a required field
	Key *string `locationName:"key" min:"1" type:"string" required:"true"`

	// The value of the tag.
	//
	// Value is a required field
	Value *string `locationName:"value" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to tag.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The map of the key-value pairs used to tag the resource.
	//
	// Tags is a required field
	Tags []*Tag `locationName:"tags" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// A JSON format string of the Amazon Redshift Serverless API operation with
// input parameters. The following is an example of a target action.
//
// "{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot",
// "retentionPeriod": "1"}}"
type TargetAction struct {
	_ struct{} `type:"structure"`

	// The parameters that you can use to configure a scheduled action (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html)
	// to create a snapshot. For more information about creating a scheduled action,
	// see CreateScheduledAction (https://docs.aws.amazon.com/redshift-serverless/latest/APIReference/API_CreateScheduledAction.html).
	CreateSnapshot *CreateSnapshotScheduleActionParameters `locationName:"createSnapshot" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TargetAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TargetAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TargetAction"}
	if s.CreateSnapshot != nil {
		if err := s.CreateSnapshot.Validate(); err != nil {
			invalidParams.AddNested("CreateSnapshot", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateSnapshot sets the CreateSnapshot field's value.
func (s *TargetAction) SetCreateSnapshot(v *CreateSnapshotScheduleActionParameters) *TargetAction {
	s.CreateSnapshot = v
	return s
}

// The request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Code_ *string `locationName:"code" type:"string"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request exceeded the number of tags allowed for a resource.
type TooManyTagsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The name of the resource that exceeded the number of tags allowed for a resource.
	ResourceName *string `locationName:"resourceName" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TooManyTagsException) GoString() string {
	return s.String()
}

func newErrorTooManyTagsException(v protocol.ResponseMetadata) error {
	return &TooManyTagsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *TooManyTagsException) Code() string {
	return "TooManyTagsException"
}

// Message returns the exception's message.
func (s *TooManyTagsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *TooManyTagsException) OrigErr() error {
	return nil
}

func (s *TooManyTagsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *TooManyTagsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *TooManyTagsException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource to remove tags from.
	//
	// ResourceArn is a required field
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tag or set of tags to remove from the resource.
	//
	// TagKeys is a required field
	TagKeys []*string `locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateCustomDomainAssociationInput struct {
	_ struct{} `type:"structure"`

	// The custom domain name’s certificate Amazon resource name (ARN). This is
	// optional.
	//
	// CustomDomainCertificateArn is a required field
	CustomDomainCertificateArn *string `locationName:"customDomainCertificateArn" min:"20" type:"string" required:"true"`

	// The custom domain name associated with the workgroup.
	//
	// CustomDomainName is a required field
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string" required:"true"`

	// The name of the workgroup associated with the database.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomDomainAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomDomainAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomDomainAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateCustomDomainAssociationInput"}
	if s.CustomDomainCertificateArn == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomDomainCertificateArn"))
	}
	if s.CustomDomainCertificateArn != nil && len(*s.CustomDomainCertificateArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainCertificateArn", 20))
	}
	if s.CustomDomainName == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomDomainName"))
	}
	if s.CustomDomainName != nil && len(*s.CustomDomainName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("CustomDomainName", 1))
	}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomDomainCertificateArn sets the CustomDomainCertificateArn field's value.
func (s *UpdateCustomDomainAssociationInput) SetCustomDomainCertificateArn(v string) *UpdateCustomDomainAssociationInput {
	s.CustomDomainCertificateArn = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *UpdateCustomDomainAssociationInput) SetCustomDomainName(v string) *UpdateCustomDomainAssociationInput {
	s.CustomDomainName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *UpdateCustomDomainAssociationInput) SetWorkgroupName(v string) *UpdateCustomDomainAssociationInput {
	s.WorkgroupName = &v
	return s
}

type UpdateCustomDomainAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The custom domain name’s certificate Amazon resource name (ARN).
	CustomDomainCertificateArn *string `locationName:"customDomainCertificateArn" min:"20" type:"string"`

	// The expiration time for the certificate.
	CustomDomainCertificateExpiryTime *time.Time `locationName:"customDomainCertificateExpiryTime" type:"timestamp" timestampFormat:"iso8601"`

	// The custom domain name associated with the workgroup.
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string"`

	// The name of the workgroup associated with the database.
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomDomainAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateCustomDomainAssociationOutput) GoString() string {
	return s.String()
}

// SetCustomDomainCertificateArn sets the CustomDomainCertificateArn field's value.
func (s *UpdateCustomDomainAssociationOutput) SetCustomDomainCertificateArn(v string) *UpdateCustomDomainAssociationOutput {
	s.CustomDomainCertificateArn = &v
	return s
}

// SetCustomDomainCertificateExpiryTime sets the CustomDomainCertificateExpiryTime field's value.
func (s *UpdateCustomDomainAssociationOutput) SetCustomDomainCertificateExpiryTime(v time.Time) *UpdateCustomDomainAssociationOutput {
	s.CustomDomainCertificateExpiryTime = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *UpdateCustomDomainAssociationOutput) SetCustomDomainName(v string) *UpdateCustomDomainAssociationOutput {
	s.CustomDomainName = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *UpdateCustomDomainAssociationOutput) SetWorkgroupName(v string) *UpdateCustomDomainAssociationOutput {
	s.WorkgroupName = &v
	return s
}

type UpdateEndpointAccessInput struct {
	_ struct{} `type:"structure"`

	// The name of the VPC endpoint to update.
	//
	// EndpointName is a required field
	EndpointName *string `locationName:"endpointName" type:"string" required:"true"`

	// The list of VPC security groups associated with the endpoint after the endpoint
	// is modified.
	VpcSecurityGroupIds []*string `locationName:"vpcSecurityGroupIds" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointAccessInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointAccessInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEndpointAccessInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEndpointAccessInput"}
	if s.EndpointName == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointName sets the EndpointName field's value.
func (s *UpdateEndpointAccessInput) SetEndpointName(v string) *UpdateEndpointAccessInput {
	s.EndpointName = &v
	return s
}

// SetVpcSecurityGroupIds sets the VpcSecurityGroupIds field's value.
func (s *UpdateEndpointAccessInput) SetVpcSecurityGroupIds(v []*string) *UpdateEndpointAccessInput {
	s.VpcSecurityGroupIds = v
	return s
}

type UpdateEndpointAccessOutput struct {
	_ struct{} `type:"structure"`

	// The updated VPC endpoint.
	Endpoint *EndpointAccess `locationName:"endpoint" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointAccessOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEndpointAccessOutput) GoString() string {
	return s.String()
}

// SetEndpoint sets the Endpoint field's value.
func (s *UpdateEndpointAccessOutput) SetEndpoint(v *EndpointAccess) *UpdateEndpointAccessOutput {
	s.Endpoint = v
	return s
}

type UpdateNamespaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Key Management Service (KMS) key used to encrypt and store
	// the namespace's admin credentials secret. You can only use this parameter
	// if manageAdminPassword is true.
	AdminPasswordSecretKmsKeyId *string `locationName:"adminPasswordSecretKmsKeyId" type:"string"`

	// The password of the administrator for the first database created in the namespace.
	// This parameter must be updated together with adminUsername.
	//
	// You can't use adminUserPassword if manageAdminPassword is true.
	//
	// AdminUserPassword is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateNamespaceInput's
	// String and GoString methods.
	AdminUserPassword *string `locationName:"adminUserPassword" type:"string" sensitive:"true"`

	// The username of the administrator for the first database created in the namespace.
	// This parameter must be updated together with adminUserPassword.
	//
	// AdminUsername is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by UpdateNamespaceInput's
	// String and GoString methods.
	AdminUsername *string `locationName:"adminUsername" type:"string" sensitive:"true"`

	// The Amazon Resource Name (ARN) of the IAM role to set as a default in the
	// namespace. This parameter must be updated together with iamRoles.
	DefaultIamRoleArn *string `locationName:"defaultIamRoleArn" type:"string"`

	// A list of IAM roles to associate with the namespace. This parameter must
	// be updated together with defaultIamRoleArn.
	IamRoles []*string `locationName:"iamRoles" type:"list"`

	// The ID of the Amazon Web Services Key Management Service key used to encrypt
	// your data.
	KmsKeyId *string `locationName:"kmsKeyId" type:"string"`

	// The types of logs the namespace can export. The export types are userlog,
	// connectionlog, and useractivitylog.
	LogExports []*string `locationName:"logExports" type:"list" enum:"LogExport"`

	// If true, Amazon Redshift uses Secrets Manager to manage the namespace's admin
	// credentials. You can't use adminUserPassword if manageAdminPassword is true.
	// If manageAdminPassword is false or not set, Amazon Redshift uses adminUserPassword
	// for the admin user account's password.
	ManageAdminPassword *bool `locationName:"manageAdminPassword" type:"boolean"`

	// The name of the namespace to update. You can't update the name of a namespace
	// once it is created.
	//
	// NamespaceName is a required field
	NamespaceName *string `locationName:"namespaceName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNamespaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNamespaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNamespaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNamespaceInput"}
	if s.NamespaceName == nil {
		invalidParams.Add(request.NewErrParamRequired("NamespaceName"))
	}
	if s.NamespaceName != nil && len(*s.NamespaceName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("NamespaceName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAdminPasswordSecretKmsKeyId sets the AdminPasswordSecretKmsKeyId field's value.
func (s *UpdateNamespaceInput) SetAdminPasswordSecretKmsKeyId(v string) *UpdateNamespaceInput {
	s.AdminPasswordSecretKmsKeyId = &v
	return s
}

// SetAdminUserPassword sets the AdminUserPassword field's value.
func (s *UpdateNamespaceInput) SetAdminUserPassword(v string) *UpdateNamespaceInput {
	s.AdminUserPassword = &v
	return s
}

// SetAdminUsername sets the AdminUsername field's value.
func (s *UpdateNamespaceInput) SetAdminUsername(v string) *UpdateNamespaceInput {
	s.AdminUsername = &v
	return s
}

// SetDefaultIamRoleArn sets the DefaultIamRoleArn field's value.
func (s *UpdateNamespaceInput) SetDefaultIamRoleArn(v string) *UpdateNamespaceInput {
	s.DefaultIamRoleArn = &v
	return s
}

// SetIamRoles sets the IamRoles field's value.
func (s *UpdateNamespaceInput) SetIamRoles(v []*string) *UpdateNamespaceInput {
	s.IamRoles = v
	return s
}

// SetKmsKeyId sets the KmsKeyId field's value.
func (s *UpdateNamespaceInput) SetKmsKeyId(v string) *UpdateNamespaceInput {
	s.KmsKeyId = &v
	return s
}

// SetLogExports sets the LogExports field's value.
func (s *UpdateNamespaceInput) SetLogExports(v []*string) *UpdateNamespaceInput {
	s.LogExports = v
	return s
}

// SetManageAdminPassword sets the ManageAdminPassword field's value.
func (s *UpdateNamespaceInput) SetManageAdminPassword(v bool) *UpdateNamespaceInput {
	s.ManageAdminPassword = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *UpdateNamespaceInput) SetNamespaceName(v string) *UpdateNamespaceInput {
	s.NamespaceName = &v
	return s
}

type UpdateNamespaceOutput struct {
	_ struct{} `type:"structure"`

	// A list of tag instances.
	//
	// Namespace is a required field
	Namespace *Namespace `locationName:"namespace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNamespaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateNamespaceOutput) GoString() string {
	return s.String()
}

// SetNamespace sets the Namespace field's value.
func (s *UpdateNamespaceOutput) SetNamespace(v *Namespace) *UpdateNamespaceOutput {
	s.Namespace = v
	return s
}

type UpdateScheduledActionInput struct {
	_ struct{} `type:"structure"`

	// Specifies whether to enable the scheduled action.
	Enabled *bool `locationName:"enabled" type:"boolean"`

	// The end time in UTC of the scheduled action to update.
	EndTime *time.Time `locationName:"endTime" type:"timestamp"`

	// The ARN of the IAM role to assume to run the scheduled action. This IAM role
	// must have permission to run the Amazon Redshift Serverless API operation
	// in the scheduled action. This IAM role must allow the Amazon Redshift scheduler
	// to schedule creating snapshots (Principal scheduler.redshift.amazonaws.com)
	// to assume permissions on your behalf. For more information about the IAM
	// role to use with the Amazon Redshift scheduler, see Using Identity-Based
	// Policies for Amazon Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/redshift-iam-access-control-identity-based.html)
	// in the Amazon Redshift Management Guide
	RoleArn *string `locationName:"roleArn" type:"string"`

	// The schedule for a one-time (at timestamp format) or recurring (cron format)
	// scheduled action. Schedule invocations must be separated by at least one
	// hour. Times are in UTC.
	//
	//    * Format of at timestamp is yyyy-mm-ddThh:mm:ss. For example, 2016-03-04T17:27:00.
	//
	//    * Format of cron expression is (Minutes Hours Day-of-month Month Day-of-week
	//    Year). For example, "(0 10 ? * MON *)". For more information, see Cron
	//    Expressions (https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/ScheduledEvents.html#CronExpressions)
	//    in the Amazon CloudWatch Events User Guide.
	Schedule *Schedule `locationName:"schedule" type:"structure"`

	// The descripion of the scheduled action to update to.
	ScheduledActionDescription *string `locationName:"scheduledActionDescription" type:"string"`

	// The name of the scheduled action to update to.
	//
	// ScheduledActionName is a required field
	ScheduledActionName *string `locationName:"scheduledActionName" min:"3" type:"string" required:"true"`

	// The start time in UTC of the scheduled action to update to.
	StartTime *time.Time `locationName:"startTime" type:"timestamp"`

	// A JSON format string of the Amazon Redshift Serverless API operation with
	// input parameters. The following is an example of a target action.
	//
	// "{"CreateSnapshot": {"NamespaceName": "sampleNamespace","SnapshotName": "sampleSnapshot",
	// "retentionPeriod": "1"}}"
	TargetAction *TargetAction `locationName:"targetAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledActionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledActionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateScheduledActionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateScheduledActionInput"}
	if s.ScheduledActionName == nil {
		invalidParams.Add(request.NewErrParamRequired("ScheduledActionName"))
	}
	if s.ScheduledActionName != nil && len(*s.ScheduledActionName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduledActionName", 3))
	}
	if s.TargetAction != nil {
		if err := s.TargetAction.Validate(); err != nil {
			invalidParams.AddNested("TargetAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnabled sets the Enabled field's value.
func (s *UpdateScheduledActionInput) SetEnabled(v bool) *UpdateScheduledActionInput {
	s.Enabled = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *UpdateScheduledActionInput) SetEndTime(v time.Time) *UpdateScheduledActionInput {
	s.EndTime = &v
	return s
}

// SetRoleArn sets the RoleArn field's value.
func (s *UpdateScheduledActionInput) SetRoleArn(v string) *UpdateScheduledActionInput {
	s.RoleArn = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *UpdateScheduledActionInput) SetSchedule(v *Schedule) *UpdateScheduledActionInput {
	s.Schedule = v
	return s
}

// SetScheduledActionDescription sets the ScheduledActionDescription field's value.
func (s *UpdateScheduledActionInput) SetScheduledActionDescription(v string) *UpdateScheduledActionInput {
	s.ScheduledActionDescription = &v
	return s
}

// SetScheduledActionName sets the ScheduledActionName field's value.
func (s *UpdateScheduledActionInput) SetScheduledActionName(v string) *UpdateScheduledActionInput {
	s.ScheduledActionName = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *UpdateScheduledActionInput) SetStartTime(v time.Time) *UpdateScheduledActionInput {
	s.StartTime = &v
	return s
}

// SetTargetAction sets the TargetAction field's value.
func (s *UpdateScheduledActionInput) SetTargetAction(v *TargetAction) *UpdateScheduledActionInput {
	s.TargetAction = v
	return s
}

type UpdateScheduledActionOutput struct {
	_ struct{} `type:"structure"`

	// The ScheduledAction object that was updated.
	ScheduledAction *ScheduledActionResponse `locationName:"scheduledAction" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledActionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateScheduledActionOutput) GoString() string {
	return s.String()
}

// SetScheduledAction sets the ScheduledAction field's value.
func (s *UpdateScheduledActionOutput) SetScheduledAction(v *ScheduledActionResponse) *UpdateScheduledActionOutput {
	s.ScheduledAction = v
	return s
}

type UpdateSnapshotCopyConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The ID of the snapshot copy configuration to update.
	//
	// SnapshotCopyConfigurationId is a required field
	SnapshotCopyConfigurationId *string `locationName:"snapshotCopyConfigurationId" type:"string" required:"true"`

	// The new retention period of how long to keep a snapshot in the destination
	// Amazon Web Services Region.
	SnapshotRetentionPeriod *int64 `locationName:"snapshotRetentionPeriod" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotCopyConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotCopyConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSnapshotCopyConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSnapshotCopyConfigurationInput"}
	if s.SnapshotCopyConfigurationId == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotCopyConfigurationId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSnapshotCopyConfigurationId sets the SnapshotCopyConfigurationId field's value.
func (s *UpdateSnapshotCopyConfigurationInput) SetSnapshotCopyConfigurationId(v string) *UpdateSnapshotCopyConfigurationInput {
	s.SnapshotCopyConfigurationId = &v
	return s
}

// SetSnapshotRetentionPeriod sets the SnapshotRetentionPeriod field's value.
func (s *UpdateSnapshotCopyConfigurationInput) SetSnapshotRetentionPeriod(v int64) *UpdateSnapshotCopyConfigurationInput {
	s.SnapshotRetentionPeriod = &v
	return s
}

type UpdateSnapshotCopyConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The updated snapshot copy configuration object.
	//
	// SnapshotCopyConfiguration is a required field
	SnapshotCopyConfiguration *SnapshotCopyConfiguration `locationName:"snapshotCopyConfiguration" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotCopyConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotCopyConfigurationOutput) GoString() string {
	return s.String()
}

// SetSnapshotCopyConfiguration sets the SnapshotCopyConfiguration field's value.
func (s *UpdateSnapshotCopyConfigurationOutput) SetSnapshotCopyConfiguration(v *SnapshotCopyConfiguration) *UpdateSnapshotCopyConfigurationOutput {
	s.SnapshotCopyConfiguration = v
	return s
}

type UpdateSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The new retention period of the snapshot.
	RetentionPeriod *int64 `locationName:"retentionPeriod" type:"integer"`

	// The name of the snapshot.
	//
	// SnapshotName is a required field
	SnapshotName *string `locationName:"snapshotName" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSnapshotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSnapshotInput"}
	if s.SnapshotName == nil {
		invalidParams.Add(request.NewErrParamRequired("SnapshotName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRetentionPeriod sets the RetentionPeriod field's value.
func (s *UpdateSnapshotInput) SetRetentionPeriod(v int64) *UpdateSnapshotInput {
	s.RetentionPeriod = &v
	return s
}

// SetSnapshotName sets the SnapshotName field's value.
func (s *UpdateSnapshotInput) SetSnapshotName(v string) *UpdateSnapshotInput {
	s.SnapshotName = &v
	return s
}

type UpdateSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// The updated snapshot object.
	Snapshot *Snapshot `locationName:"snapshot" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateSnapshotOutput) GoString() string {
	return s.String()
}

// SetSnapshot sets the Snapshot field's value.
func (s *UpdateSnapshotOutput) SetSnapshot(v *Snapshot) *UpdateSnapshotOutput {
	s.Snapshot = v
	return s
}

type UpdateUsageLimitInput struct {
	_ struct{} `type:"structure"`

	// The new limit amount. If time-based, this amount is in Redshift Processing
	// Units (RPU) consumed per hour. If data-based, this amount is in terabytes
	// (TB) of data transferred between Regions in cross-account sharing. The value
	// must be a positive number.
	Amount *int64 `locationName:"amount" type:"long"`

	// The new action that Amazon Redshift Serverless takes when the limit is reached.
	BreachAction *string `locationName:"breachAction" type:"string" enum:"UsageLimitBreachAction"`

	// The identifier of the usage limit to update.
	//
	// UsageLimitId is a required field
	UsageLimitId *string `locationName:"usageLimitId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUsageLimitInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUsageLimitInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateUsageLimitInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateUsageLimitInput"}
	if s.UsageLimitId == nil {
		invalidParams.Add(request.NewErrParamRequired("UsageLimitId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAmount sets the Amount field's value.
func (s *UpdateUsageLimitInput) SetAmount(v int64) *UpdateUsageLimitInput {
	s.Amount = &v
	return s
}

// SetBreachAction sets the BreachAction field's value.
func (s *UpdateUsageLimitInput) SetBreachAction(v string) *UpdateUsageLimitInput {
	s.BreachAction = &v
	return s
}

// SetUsageLimitId sets the UsageLimitId field's value.
func (s *UpdateUsageLimitInput) SetUsageLimitId(v string) *UpdateUsageLimitInput {
	s.UsageLimitId = &v
	return s
}

type UpdateUsageLimitOutput struct {
	_ struct{} `type:"structure"`

	// The updated usage limit object.
	UsageLimit *UsageLimit `locationName:"usageLimit" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUsageLimitOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateUsageLimitOutput) GoString() string {
	return s.String()
}

// SetUsageLimit sets the UsageLimit field's value.
func (s *UpdateUsageLimitOutput) SetUsageLimit(v *UsageLimit) *UpdateUsageLimitOutput {
	s.UsageLimit = v
	return s
}

type UpdateWorkgroupInput struct {
	_ struct{} `type:"structure"`

	// The new base data warehouse capacity in Redshift Processing Units (RPUs).
	BaseCapacity *int64 `locationName:"baseCapacity" type:"integer"`

	// An array of parameters to set for advanced control over a database. The options
	// are auto_mv, datestyle, enable_case_sensitive_identifier, enable_user_activity_logging,
	// query_group, search_path, require_ssl, use_fips_ssl, and query monitoring
	// metrics that let you define performance boundaries. For more information
	// about query monitoring rules and available metrics, see Query monitoring
	// metrics for Amazon Redshift Serverless (https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless).
	ConfigParameters []*ConfigParameter `locationName:"configParameters" type:"list"`

	// The value that specifies whether to turn on enhanced virtual private cloud
	// (VPC) routing, which forces Amazon Redshift Serverless to route traffic through
	// your VPC.
	EnhancedVpcRouting *bool `locationName:"enhancedVpcRouting" type:"boolean"`

	// The IP address type that the workgroup supports. Possible values are ipv4
	// and dualstack.
	IpAddressType *string `locationName:"ipAddressType" type:"string"`

	// The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve
	// queries. The max capacity is specified in RPUs.
	MaxCapacity *int64 `locationName:"maxCapacity" type:"integer"`

	// The custom port to use when connecting to a workgroup. Valid port ranges
	// are 5431-5455 and 8191-8215. The default is 5439.
	Port *int64 `locationName:"port" type:"integer"`

	// A value that specifies whether the workgroup can be accessible from a public
	// network.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// An array of security group IDs to associate with the workgroup.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// An array of VPC subnet IDs to associate with the workgroup.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The name of the workgroup to update. You can't update the name of a workgroup
	// once it is created.
	//
	// WorkgroupName is a required field
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkgroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkgroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkgroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkgroupInput"}
	if s.WorkgroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkgroupName"))
	}
	if s.WorkgroupName != nil && len(*s.WorkgroupName) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("WorkgroupName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBaseCapacity sets the BaseCapacity field's value.
func (s *UpdateWorkgroupInput) SetBaseCapacity(v int64) *UpdateWorkgroupInput {
	s.BaseCapacity = &v
	return s
}

// SetConfigParameters sets the ConfigParameters field's value.
func (s *UpdateWorkgroupInput) SetConfigParameters(v []*ConfigParameter) *UpdateWorkgroupInput {
	s.ConfigParameters = v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *UpdateWorkgroupInput) SetEnhancedVpcRouting(v bool) *UpdateWorkgroupInput {
	s.EnhancedVpcRouting = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *UpdateWorkgroupInput) SetIpAddressType(v string) *UpdateWorkgroupInput {
	s.IpAddressType = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *UpdateWorkgroupInput) SetMaxCapacity(v int64) *UpdateWorkgroupInput {
	s.MaxCapacity = &v
	return s
}

// SetPort sets the Port field's value.
func (s *UpdateWorkgroupInput) SetPort(v int64) *UpdateWorkgroupInput {
	s.Port = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *UpdateWorkgroupInput) SetPubliclyAccessible(v bool) *UpdateWorkgroupInput {
	s.PubliclyAccessible = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *UpdateWorkgroupInput) SetSecurityGroupIds(v []*string) *UpdateWorkgroupInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *UpdateWorkgroupInput) SetSubnetIds(v []*string) *UpdateWorkgroupInput {
	s.SubnetIds = v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *UpdateWorkgroupInput) SetWorkgroupName(v string) *UpdateWorkgroupInput {
	s.WorkgroupName = &v
	return s
}

type UpdateWorkgroupOutput struct {
	_ struct{} `type:"structure"`

	// The updated workgroup object.
	//
	// Workgroup is a required field
	Workgroup *Workgroup `locationName:"workgroup" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkgroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkgroupOutput) GoString() string {
	return s.String()
}

// SetWorkgroup sets the Workgroup field's value.
func (s *UpdateWorkgroupOutput) SetWorkgroup(v *Workgroup) *UpdateWorkgroupOutput {
	s.Workgroup = v
	return s
}

// The usage limit object.
type UsageLimit struct {
	_ struct{} `type:"structure"`

	// The limit amount. If time-based, this amount is in RPUs consumed per hour.
	// If data-based, this amount is in terabytes (TB). The value must be a positive
	// number.
	Amount *int64 `locationName:"amount" type:"long"`

	// The action that Amazon Redshift Serverless takes when the limit is reached.
	BreachAction *string `locationName:"breachAction" type:"string" enum:"UsageLimitBreachAction"`

	// The time period that the amount applies to. A weekly period begins on Sunday.
	// The default is monthly.
	Period *string `locationName:"period" type:"string" enum:"UsageLimitPeriod"`

	// The Amazon Resource Name (ARN) that identifies the Amazon Redshift Serverless
	// resource.
	ResourceArn *string `locationName:"resourceArn" type:"string"`

	// The Amazon Resource Name (ARN) of the resource associated with the usage
	// limit.
	UsageLimitArn *string `locationName:"usageLimitArn" type:"string"`

	// The identifier of the usage limit.
	UsageLimitId *string `locationName:"usageLimitId" type:"string"`

	// The Amazon Redshift Serverless feature to limit.
	UsageType *string `locationName:"usageType" type:"string" enum:"UsageLimitUsageType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsageLimit) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UsageLimit) GoString() string {
	return s.String()
}

// SetAmount sets the Amount field's value.
func (s *UsageLimit) SetAmount(v int64) *UsageLimit {
	s.Amount = &v
	return s
}

// SetBreachAction sets the BreachAction field's value.
func (s *UsageLimit) SetBreachAction(v string) *UsageLimit {
	s.BreachAction = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *UsageLimit) SetPeriod(v string) *UsageLimit {
	s.Period = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UsageLimit) SetResourceArn(v string) *UsageLimit {
	s.ResourceArn = &v
	return s
}

// SetUsageLimitArn sets the UsageLimitArn field's value.
func (s *UsageLimit) SetUsageLimitArn(v string) *UsageLimit {
	s.UsageLimitArn = &v
	return s
}

// SetUsageLimitId sets the UsageLimitId field's value.
func (s *UsageLimit) SetUsageLimitId(v string) *UsageLimit {
	s.UsageLimitId = &v
	return s
}

// SetUsageType sets the UsageType field's value.
func (s *UsageLimit) SetUsageType(v string) *UsageLimit {
	s.UsageType = &v
	return s
}

// The input failed to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The connection endpoint for connecting to Amazon Redshift Serverless through
// the proxy.
type VpcEndpoint struct {
	_ struct{} `type:"structure"`

	// One or more network interfaces of the endpoint. Also known as an interface
	// endpoint.
	NetworkInterfaces []*NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// The connection endpoint ID for connecting to Amazon Redshift Serverless.
	VpcEndpointId *string `locationName:"vpcEndpointId" type:"string"`

	// The VPC identifier that the endpoint is associated with.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpoint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcEndpoint) GoString() string {
	return s.String()
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *VpcEndpoint) SetNetworkInterfaces(v []*NetworkInterface) *VpcEndpoint {
	s.NetworkInterfaces = v
	return s
}

// SetVpcEndpointId sets the VpcEndpointId field's value.
func (s *VpcEndpoint) SetVpcEndpointId(v string) *VpcEndpoint {
	s.VpcEndpointId = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *VpcEndpoint) SetVpcId(v string) *VpcEndpoint {
	s.VpcId = &v
	return s
}

// Describes the members of a VPC security group.
type VpcSecurityGroupMembership struct {
	_ struct{} `type:"structure"`

	// The status of the VPC security group.
	Status *string `locationName:"status" type:"string"`

	// The unique identifier of the VPC security group.
	VpcSecurityGroupId *string `locationName:"vpcSecurityGroupId" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcSecurityGroupMembership) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s VpcSecurityGroupMembership) GoString() string {
	return s.String()
}

// SetStatus sets the Status field's value.
func (s *VpcSecurityGroupMembership) SetStatus(v string) *VpcSecurityGroupMembership {
	s.Status = &v
	return s
}

// SetVpcSecurityGroupId sets the VpcSecurityGroupId field's value.
func (s *VpcSecurityGroupMembership) SetVpcSecurityGroupId(v string) *VpcSecurityGroupMembership {
	s.VpcSecurityGroupId = &v
	return s
}

// The collection of computing resources from which an endpoint is created.
type Workgroup struct {
	_ struct{} `type:"structure"`

	// The base data warehouse capacity of the workgroup in Redshift Processing
	// Units (RPUs).
	BaseCapacity *int64 `locationName:"baseCapacity" type:"integer"`

	// An array of parameters to set for advanced control over a database. The options
	// are auto_mv, datestyle, enable_case_sensitive_identifier, enable_user_activity_logging,
	// query_group, search_path, require_ssl, use_fips_ssl, and query monitoring
	// metrics that let you define performance boundaries. For more information
	// about query monitoring rules and available metrics, see Query monitoring
	// metrics for Amazon Redshift Serverless (https://docs.aws.amazon.com/redshift/latest/dg/cm-c-wlm-query-monitoring-rules.html#cm-c-wlm-query-monitoring-metrics-serverless).
	ConfigParameters []*ConfigParameter `locationName:"configParameters" type:"list"`

	// The creation date of the workgroup.
	CreationDate *time.Time `locationName:"creationDate" type:"timestamp" timestampFormat:"iso8601"`

	// A list of VPCs. Each entry is the unique identifier of a virtual private
	// cloud with access to Amazon Redshift Serverless. If all of the VPCs for the
	// grantee are allowed, it shows an asterisk.
	CrossAccountVpcs []*string `locationName:"crossAccountVpcs" type:"list"`

	// The custom domain name’s certificate Amazon resource name (ARN).
	CustomDomainCertificateArn *string `locationName:"customDomainCertificateArn" min:"20" type:"string"`

	// The expiration time for the certificate.
	CustomDomainCertificateExpiryTime *time.Time `locationName:"customDomainCertificateExpiryTime" type:"timestamp" timestampFormat:"iso8601"`

	// The custom domain name associated with the workgroup.
	CustomDomainName *string `locationName:"customDomainName" min:"1" type:"string"`

	// The endpoint that is created from the workgroup.
	Endpoint *Endpoint `locationName:"endpoint" type:"structure"`

	// The value that specifies whether to enable enhanced virtual private cloud
	// (VPC) routing, which forces Amazon Redshift Serverless to route traffic through
	// your VPC.
	EnhancedVpcRouting *bool `locationName:"enhancedVpcRouting" type:"boolean"`

	// The IP address type that the workgroup supports. Possible values are ipv4
	// and dualstack.
	IpAddressType *string `locationName:"ipAddressType" type:"string"`

	// The maximum data-warehouse capacity Amazon Redshift Serverless uses to serve
	// queries. The max capacity is specified in RPUs.
	MaxCapacity *int64 `locationName:"maxCapacity" type:"integer"`

	// The namespace the workgroup is associated with.
	NamespaceName *string `locationName:"namespaceName" type:"string"`

	// The patch version of your Amazon Redshift Serverless workgroup. For more
	// information about patch versions, see Cluster versions for Amazon Redshift
	// (https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html).
	PatchVersion *string `locationName:"patchVersion" type:"string"`

	// The custom port to use when connecting to a workgroup. Valid port ranges
	// are 5431-5455 and 8191-8215. The default is 5439.
	Port *int64 `locationName:"port" type:"integer"`

	// A value that specifies whether the workgroup can be accessible from a public
	// network.
	PubliclyAccessible *bool `locationName:"publiclyAccessible" type:"boolean"`

	// An array of security group IDs to associate with the workgroup.
	SecurityGroupIds []*string `locationName:"securityGroupIds" type:"list"`

	// The status of the workgroup.
	Status *string `locationName:"status" type:"string" enum:"WorkgroupStatus"`

	// An array of subnet IDs the workgroup is associated with.
	SubnetIds []*string `locationName:"subnetIds" type:"list"`

	// The Amazon Resource Name (ARN) that links to the workgroup.
	WorkgroupArn *string `locationName:"workgroupArn" type:"string"`

	// The unique identifier of the workgroup.
	WorkgroupId *string `locationName:"workgroupId" type:"string"`

	// The name of the workgroup.
	WorkgroupName *string `locationName:"workgroupName" min:"3" type:"string"`

	// The Amazon Redshift Serverless version of your workgroup. For more information
	// about Amazon Redshift Serverless versions, seeCluster versions for Amazon
	// Redshift (https://docs.aws.amazon.com/redshift/latest/mgmt/cluster-versions.html).
	WorkgroupVersion *string `locationName:"workgroupVersion" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workgroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workgroup) GoString() string {
	return s.String()
}

// SetBaseCapacity sets the BaseCapacity field's value.
func (s *Workgroup) SetBaseCapacity(v int64) *Workgroup {
	s.BaseCapacity = &v
	return s
}

// SetConfigParameters sets the ConfigParameters field's value.
func (s *Workgroup) SetConfigParameters(v []*ConfigParameter) *Workgroup {
	s.ConfigParameters = v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *Workgroup) SetCreationDate(v time.Time) *Workgroup {
	s.CreationDate = &v
	return s
}

// SetCrossAccountVpcs sets the CrossAccountVpcs field's value.
func (s *Workgroup) SetCrossAccountVpcs(v []*string) *Workgroup {
	s.CrossAccountVpcs = v
	return s
}

// SetCustomDomainCertificateArn sets the CustomDomainCertificateArn field's value.
func (s *Workgroup) SetCustomDomainCertificateArn(v string) *Workgroup {
	s.CustomDomainCertificateArn = &v
	return s
}

// SetCustomDomainCertificateExpiryTime sets the CustomDomainCertificateExpiryTime field's value.
func (s *Workgroup) SetCustomDomainCertificateExpiryTime(v time.Time) *Workgroup {
	s.CustomDomainCertificateExpiryTime = &v
	return s
}

// SetCustomDomainName sets the CustomDomainName field's value.
func (s *Workgroup) SetCustomDomainName(v string) *Workgroup {
	s.CustomDomainName = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Workgroup) SetEndpoint(v *Endpoint) *Workgroup {
	s.Endpoint = v
	return s
}

// SetEnhancedVpcRouting sets the EnhancedVpcRouting field's value.
func (s *Workgroup) SetEnhancedVpcRouting(v bool) *Workgroup {
	s.EnhancedVpcRouting = &v
	return s
}

// SetIpAddressType sets the IpAddressType field's value.
func (s *Workgroup) SetIpAddressType(v string) *Workgroup {
	s.IpAddressType = &v
	return s
}

// SetMaxCapacity sets the MaxCapacity field's value.
func (s *Workgroup) SetMaxCapacity(v int64) *Workgroup {
	s.MaxCapacity = &v
	return s
}

// SetNamespaceName sets the NamespaceName field's value.
func (s *Workgroup) SetNamespaceName(v string) *Workgroup {
	s.NamespaceName = &v
	return s
}

// SetPatchVersion sets the PatchVersion field's value.
func (s *Workgroup) SetPatchVersion(v string) *Workgroup {
	s.PatchVersion = &v
	return s
}

// SetPort sets the Port field's value.
func (s *Workgroup) SetPort(v int64) *Workgroup {
	s.Port = &v
	return s
}

// SetPubliclyAccessible sets the PubliclyAccessible field's value.
func (s *Workgroup) SetPubliclyAccessible(v bool) *Workgroup {
	s.PubliclyAccessible = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *Workgroup) SetSecurityGroupIds(v []*string) *Workgroup {
	s.SecurityGroupIds = v
	return s
}

// SetStatus sets the Status field's value.
func (s *Workgroup) SetStatus(v string) *Workgroup {
	s.Status = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *Workgroup) SetSubnetIds(v []*string) *Workgroup {
	s.SubnetIds = v
	return s
}

// SetWorkgroupArn sets the WorkgroupArn field's value.
func (s *Workgroup) SetWorkgroupArn(v string) *Workgroup {
	s.WorkgroupArn = &v
	return s
}

// SetWorkgroupId sets the WorkgroupId field's value.
func (s *Workgroup) SetWorkgroupId(v string) *Workgroup {
	s.WorkgroupId = &v
	return s
}

// SetWorkgroupName sets the WorkgroupName field's value.
func (s *Workgroup) SetWorkgroupName(v string) *Workgroup {
	s.WorkgroupName = &v
	return s
}

// SetWorkgroupVersion sets the WorkgroupVersion field's value.
func (s *Workgroup) SetWorkgroupVersion(v string) *Workgroup {
	s.WorkgroupVersion = &v
	return s
}

const (
	// LogExportUseractivitylog is a LogExport enum value
	LogExportUseractivitylog = "useractivitylog"

	// LogExportUserlog is a LogExport enum value
	LogExportUserlog = "userlog"

	// LogExportConnectionlog is a LogExport enum value
	LogExportConnectionlog = "connectionlog"
)

// LogExport_Values returns all elements of the LogExport enum
func LogExport_Values() []string {
	return []string{
		LogExportUseractivitylog,
		LogExportUserlog,
		LogExportConnectionlog,
	}
}

const (
	// NamespaceStatusAvailable is a NamespaceStatus enum value
	NamespaceStatusAvailable = "AVAILABLE"

	// NamespaceStatusModifying is a NamespaceStatus enum value
	NamespaceStatusModifying = "MODIFYING"

	// NamespaceStatusDeleting is a NamespaceStatus enum value
	NamespaceStatusDeleting = "DELETING"
)

// NamespaceStatus_Values returns all elements of the NamespaceStatus enum
func NamespaceStatus_Values() []string {
	return []string{
		NamespaceStatusAvailable,
		NamespaceStatusModifying,
		NamespaceStatusDeleting,
	}
}

const (
	// SnapshotStatusAvailable is a SnapshotStatus enum value
	SnapshotStatusAvailable = "AVAILABLE"

	// SnapshotStatusCreating is a SnapshotStatus enum value
	SnapshotStatusCreating = "CREATING"

	// SnapshotStatusDeleted is a SnapshotStatus enum value
	SnapshotStatusDeleted = "DELETED"

	// SnapshotStatusCancelled is a SnapshotStatus enum value
	SnapshotStatusCancelled = "CANCELLED"

	// SnapshotStatusFailed is a SnapshotStatus enum value
	SnapshotStatusFailed = "FAILED"

	// SnapshotStatusCopying is a SnapshotStatus enum value
	SnapshotStatusCopying = "COPYING"
)

// SnapshotStatus_Values returns all elements of the SnapshotStatus enum
func SnapshotStatus_Values() []string {
	return []string{
		SnapshotStatusAvailable,
		SnapshotStatusCreating,
		SnapshotStatusDeleted,
		SnapshotStatusCancelled,
		SnapshotStatusFailed,
		SnapshotStatusCopying,
	}
}

const (
	// StateActive is a State enum value
	StateActive = "ACTIVE"

	// StateDisabled is a State enum value
	StateDisabled = "DISABLED"
)

// State_Values returns all elements of the State enum
func State_Values() []string {
	return []string{
		StateActive,
		StateDisabled,
	}
}

const (
	// UsageLimitBreachActionLog is a UsageLimitBreachAction enum value
	UsageLimitBreachActionLog = "log"

	// UsageLimitBreachActionEmitMetric is a UsageLimitBreachAction enum value
	UsageLimitBreachActionEmitMetric = "emit-metric"

	// UsageLimitBreachActionDeactivate is a UsageLimitBreachAction enum value
	UsageLimitBreachActionDeactivate = "deactivate"
)

// UsageLimitBreachAction_Values returns all elements of the UsageLimitBreachAction enum
func UsageLimitBreachAction_Values() []string {
	return []string{
		UsageLimitBreachActionLog,
		UsageLimitBreachActionEmitMetric,
		UsageLimitBreachActionDeactivate,
	}
}

const (
	// UsageLimitPeriodDaily is a UsageLimitPeriod enum value
	UsageLimitPeriodDaily = "daily"

	// UsageLimitPeriodWeekly is a UsageLimitPeriod enum value
	UsageLimitPeriodWeekly = "weekly"

	// UsageLimitPeriodMonthly is a UsageLimitPeriod enum value
	UsageLimitPeriodMonthly = "monthly"
)

// UsageLimitPeriod_Values returns all elements of the UsageLimitPeriod enum
func UsageLimitPeriod_Values() []string {
	return []string{
		UsageLimitPeriodDaily,
		UsageLimitPeriodWeekly,
		UsageLimitPeriodMonthly,
	}
}

const (
	// UsageLimitUsageTypeServerlessCompute is a UsageLimitUsageType enum value
	UsageLimitUsageTypeServerlessCompute = "serverless-compute"

	// UsageLimitUsageTypeCrossRegionDatasharing is a UsageLimitUsageType enum value
	UsageLimitUsageTypeCrossRegionDatasharing = "cross-region-datasharing"
)

// UsageLimitUsageType_Values returns all elements of the UsageLimitUsageType enum
func UsageLimitUsageType_Values() []string {
	return []string{
		UsageLimitUsageTypeServerlessCompute,
		UsageLimitUsageTypeCrossRegionDatasharing,
	}
}

const (
	// WorkgroupStatusCreating is a WorkgroupStatus enum value
	WorkgroupStatusCreating = "CREATING"

	// WorkgroupStatusAvailable is a WorkgroupStatus enum value
	WorkgroupStatusAvailable = "AVAILABLE"

	// WorkgroupStatusModifying is a WorkgroupStatus enum value
	WorkgroupStatusModifying = "MODIFYING"

	// WorkgroupStatusDeleting is a WorkgroupStatus enum value
	WorkgroupStatusDeleting = "DELETING"
)

// WorkgroupStatus_Values returns all elements of the WorkgroupStatus enum
func WorkgroupStatus_Values() []string {
	return []string{
		WorkgroupStatusCreating,
		WorkgroupStatusAvailable,
		WorkgroupStatusModifying,
		WorkgroupStatusDeleting,
	}
}
