# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
import sys
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from .. import _serialization

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object


class Ambr(_serialization.Model):
    """Aggregate maximum bit rate.

    All required parameters must be populated in order to send to Azure.

    :ivar uplink: Uplink bit rate. Required.
    :vartype uplink: str
    :ivar downlink: Downlink bit rate. Required.
    :vartype downlink: str
    """

    _validation = {
        "uplink": {"required": True, "pattern": r"^\d+(\.\d+)? (bps|Kbps|Mbps|Gbps|Tbps)$"},
        "downlink": {"required": True, "pattern": r"^\d+(\.\d+)? (bps|Kbps|Mbps|Gbps|Tbps)$"},
    }

    _attribute_map = {
        "uplink": {"key": "uplink", "type": "str"},
        "downlink": {"key": "downlink", "type": "str"},
    }

    def __init__(self, *, uplink: str, downlink: str, **kwargs: Any) -> None:
        """
        :keyword uplink: Uplink bit rate. Required.
        :paramtype uplink: str
        :keyword downlink: Downlink bit rate. Required.
        :paramtype downlink: str
        """
        super().__init__(**kwargs)
        self.uplink = uplink
        self.downlink = downlink


class Arp(_serialization.Model):
    """Allocation and Retention Priority (ARP) parameters.

    All required parameters must be populated in order to send to Azure.

    :ivar priority_level: ARP priority level. Required.
    :vartype priority_level: int
    :ivar preempt_cap: ARP preemption capability. Required. Known values are: "NotPreempt" and
     "MayPreempt".
    :vartype preempt_cap: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
    :ivar preempt_vuln: ARP preemption vulnerability. Required. Known values are: "NotPreemptable"
     and "Preemptable".
    :vartype preempt_vuln: str or ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
    """

    _validation = {
        "priority_level": {"required": True, "maximum": 15, "minimum": 1},
        "preempt_cap": {"required": True},
        "preempt_vuln": {"required": True},
    }

    _attribute_map = {
        "priority_level": {"key": "priorityLevel", "type": "int"},
        "preempt_cap": {"key": "preemptCap", "type": "str"},
        "preempt_vuln": {"key": "preemptVuln", "type": "str"},
    }

    def __init__(
        self,
        *,
        priority_level: int,
        preempt_cap: Union[str, "_models.PreemptionCapability"],
        preempt_vuln: Union[str, "_models.PreemptionVulnerability"],
        **kwargs: Any
    ) -> None:
        """
        :keyword priority_level: ARP priority level. Required.
        :paramtype priority_level: int
        :keyword preempt_cap: ARP preemption capability. Required. Known values are: "NotPreempt" and
         "MayPreempt".
        :paramtype preempt_cap: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
        :keyword preempt_vuln: ARP preemption vulnerability. Required. Known values are:
         "NotPreemptable" and "Preemptable".
        :paramtype preempt_vuln: str or ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
        """
        super().__init__(**kwargs)
        self.priority_level = priority_level
        self.preempt_cap = preempt_cap
        self.preempt_vuln = preempt_vuln


class AsyncOperationId(_serialization.Model):
    """Reference to an Azure Async Operation ID.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure Async Operation ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[^/?#]+/[lL][oO][cC][aA][tT][iI][oO][nN][sS]/[^/?#]+/[oO][pP][eE][rR][aA][tT][iI][oO][nN][sS][tT][aA][tT][uU][sS][eE][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure Async Operation ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class AsyncOperationStatus(_serialization.Model):
    """The current status of an async operation.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified ID for the async operation.
    :vartype id: str
    :ivar name: Name of the async operation.
    :vartype name: str
    :ivar status: The operation status. Required.
    :vartype status: str
    :ivar resource_id: Fully qualified ID for the resource that this async operation status relates
     to.
    :vartype resource_id: str
    :ivar start_time: The start time of the operation.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: The end time of the operation.
    :vartype end_time: ~datetime.datetime
    :ivar percent_complete: Percentage of the operation that is complete.
    :vartype percent_complete: float
    :ivar properties: Properties returned by the resource provider on a successful operation.
    :vartype properties: JSON
    :ivar error: If present, details of the operation error.
    :vartype error: ~azure.mgmt.mobilenetwork.models.ErrorDetail
    """

    _validation = {
        "status": {"required": True},
        "percent_complete": {"maximum": 100, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "status": {"key": "status", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "start_time": {"key": "startTime", "type": "iso-8601"},
        "end_time": {"key": "endTime", "type": "iso-8601"},
        "percent_complete": {"key": "percentComplete", "type": "float"},
        "properties": {"key": "properties", "type": "object"},
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(
        self,
        *,
        status: str,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        resource_id: Optional[str] = None,
        start_time: Optional[datetime.datetime] = None,
        end_time: Optional[datetime.datetime] = None,
        percent_complete: Optional[float] = None,
        properties: Optional[JSON] = None,
        error: Optional["_models.ErrorDetail"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Fully qualified ID for the async operation.
        :paramtype id: str
        :keyword name: Name of the async operation.
        :paramtype name: str
        :keyword status: The operation status. Required.
        :paramtype status: str
        :keyword resource_id: Fully qualified ID for the resource that this async operation status
         relates to.
        :paramtype resource_id: str
        :keyword start_time: The start time of the operation.
        :paramtype start_time: ~datetime.datetime
        :keyword end_time: The end time of the operation.
        :paramtype end_time: ~datetime.datetime
        :keyword percent_complete: Percentage of the operation that is complete.
        :paramtype percent_complete: float
        :keyword properties: Properties returned by the resource provider on a successful operation.
        :paramtype properties: JSON
        :keyword error: If present, details of the operation error.
        :paramtype error: ~azure.mgmt.mobilenetwork.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = name
        self.status = status
        self.resource_id = resource_id
        self.start_time = start_time
        self.end_time = end_time
        self.percent_complete = percent_complete
        self.properties = properties
        self.error = error


class Resource(_serialization.Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.system_data = None


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(**kwargs)
        self.tags = tags
        self.location = location


class AttachedDataNetwork(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Attached data network resource. Must be created in the same location as its parent packet core
    data plane.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the attached data network resource. Known
     values are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar user_plane_data_interface: The user plane interface on the data network. For 5G networks,
     this is the N6 interface. For 4G networks, this is the SGi interface. Required.
    :vartype user_plane_data_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
    :ivar dns_addresses: The DNS servers to signal to UEs to use for this attached data network.
     This configuration is mandatory - if you don't want DNS servers, you must provide an empty
     array. Required.
    :vartype dns_addresses: list[str]
    :ivar napt_configuration: The network address and port translation (NAPT) configuration.
     If this is not specified, the attached data network will use a default NAPT configuration with
     NAPT enabled.
    :vartype napt_configuration: ~azure.mgmt.mobilenetwork.models.NaptConfiguration
    :ivar user_equipment_address_pool_prefix: The user equipment (UE) address pool prefixes for the
     attached data network from which the packet core instance will dynamically assign IP addresses
     to UEs.
     The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
      You must define at least one of userEquipmentAddressPoolPrefix and
     userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
    :vartype user_equipment_address_pool_prefix: list[str]
    :ivar user_equipment_static_address_pool_prefix: The user equipment (UE) address pool prefixes
     for the attached data network from which the packet core instance will assign static IP
     addresses to UEs.
     The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The
     static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM
     resource.
     At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must
     be defined. If both are defined, they must be of the same size.
    :vartype user_equipment_static_address_pool_prefix: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "user_plane_data_interface": {"required": True},
        "dns_addresses": {"required": True, "unique": True},
        "user_equipment_address_pool_prefix": {"min_items": 1, "unique": True},
        "user_equipment_static_address_pool_prefix": {"min_items": 1, "unique": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "user_plane_data_interface": {"key": "properties.userPlaneDataInterface", "type": "InterfaceProperties"},
        "dns_addresses": {"key": "properties.dnsAddresses", "type": "[str]"},
        "napt_configuration": {"key": "properties.naptConfiguration", "type": "NaptConfiguration"},
        "user_equipment_address_pool_prefix": {"key": "properties.userEquipmentAddressPoolPrefix", "type": "[str]"},
        "user_equipment_static_address_pool_prefix": {
            "key": "properties.userEquipmentStaticAddressPoolPrefix",
            "type": "[str]",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        user_plane_data_interface: "_models.InterfaceProperties",
        dns_addresses: List[str],
        tags: Optional[Dict[str, str]] = None,
        napt_configuration: Optional["_models.NaptConfiguration"] = None,
        user_equipment_address_pool_prefix: Optional[List[str]] = None,
        user_equipment_static_address_pool_prefix: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword user_plane_data_interface: The user plane interface on the data network. For 5G
         networks, this is the N6 interface. For 4G networks, this is the SGi interface. Required.
        :paramtype user_plane_data_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
        :keyword dns_addresses: The DNS servers to signal to UEs to use for this attached data network.
         This configuration is mandatory - if you don't want DNS servers, you must provide an empty
         array. Required.
        :paramtype dns_addresses: list[str]
        :keyword napt_configuration: The network address and port translation (NAPT) configuration.
         If this is not specified, the attached data network will use a default NAPT configuration with
         NAPT enabled.
        :paramtype napt_configuration: ~azure.mgmt.mobilenetwork.models.NaptConfiguration
        :keyword user_equipment_address_pool_prefix: The user equipment (UE) address pool prefixes for
         the attached data network from which the packet core instance will dynamically assign IP
         addresses to UEs.
         The packet core instance assigns an IP address to a UE when the UE sets up a PDU session.
          You must define at least one of userEquipmentAddressPoolPrefix and
         userEquipmentStaticAddressPoolPrefix. If you define both, they must be of the same size.
        :paramtype user_equipment_address_pool_prefix: list[str]
        :keyword user_equipment_static_address_pool_prefix: The user equipment (UE) address pool
         prefixes for the attached data network from which the packet core instance will assign static
         IP addresses to UEs.
         The packet core instance assigns an IP address to a UE when the UE sets up a PDU session. The
         static IP address for a specific UE is set in StaticIPConfiguration on the corresponding SIM
         resource.
         At least one of userEquipmentAddressPoolPrefix and userEquipmentStaticAddressPoolPrefix must
         be defined. If both are defined, they must be of the same size.
        :paramtype user_equipment_static_address_pool_prefix: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.user_plane_data_interface = user_plane_data_interface
        self.dns_addresses = dns_addresses
        self.napt_configuration = napt_configuration
        self.user_equipment_address_pool_prefix = user_equipment_address_pool_prefix
        self.user_equipment_static_address_pool_prefix = user_equipment_static_address_pool_prefix


class AttachedDataNetworkListResult(_serialization.Model):
    """Response for attached data network API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of data networks in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.AttachedDataNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AttachedDataNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.AttachedDataNetwork"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of data networks in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.AttachedDataNetwork]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class AttachedDataNetworkResourceId(_serialization.Model):
    """Reference to an attached data network resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Attached data network resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[pP][aA][cC][kK][eE][tT][cC][oO][rR][eE][cC][oO][nN][tT][rR][oO][lL][pP][lL][aA][nN][eE][sS]/[^/?#]+/[pP][aA][cC][kK][eE][tT][cC][oO][rR][eE][dD][aA][tT][aA][pP][lL][aA][nN][eE][sS]/[^/?#]+/[aA][tT][tT][aA][cC][hH][eE][dD][dD][aA][tT][aA][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Attached data network resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class AzureStackEdgeDeviceResourceId(_serialization.Model):
    """Reference to an Azure Stack Edge device resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure Stack Edge device resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[dD][aA][tT][aA][bB][oO][xX][eE][dD][gG][eE]/[dD][aA][tT][aA][bB][oO][xX][eE][dD][gG][eE][dD][eE][vV][iI][cC][eE][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure Stack Edge device resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class AzureStackHCIClusterResourceId(_serialization.Model):
    """Reference to an Azure Stack HCI cluster resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure Stack HCI cluster resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[aA][zZ][uU][rR][eE][sS][tT][aA][cC][kK][hH][cC][iI]/[cC][lL][uU][sS][tT][eE][rR][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure Stack HCI cluster resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class CertificateProvisioning(_serialization.Model):
    """Certificate provisioning state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar state: The certificate's provisioning state. Known values are: "NotProvisioned",
     "Provisioned", and "Failed".
    :vartype state: str or ~azure.mgmt.mobilenetwork.models.CertificateProvisioningState
    :ivar reason: Reason for certificate provisioning failure.
    :vartype reason: str
    """

    _validation = {
        "state": {"readonly": True},
        "reason": {"readonly": True},
    }

    _attribute_map = {
        "state": {"key": "state", "type": "str"},
        "reason": {"key": "reason", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.state = None
        self.reason = None


class CommonSimPropertiesFormat(_serialization.Model):
    """Common SIM properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The provisioning state of the SIM resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar sim_state: The state of the SIM resource. Known values are: "Disabled", "Enabled", and
     "Invalid".
    :vartype sim_state: str or ~azure.mgmt.mobilenetwork.models.SimState
    :ivar site_provisioning_state: A dictionary of sites to the provisioning state of this SIM on
     that site.
    :vartype site_provisioning_state: dict[str, str or
     ~azure.mgmt.mobilenetwork.models.SiteProvisioningState]
    :ivar international_mobile_subscriber_identity: The international mobile subscriber identity
     (IMSI) for the SIM. Required.
    :vartype international_mobile_subscriber_identity: str
    :ivar integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the SIM.
    :vartype integrated_circuit_card_identifier: str
    :ivar device_type: An optional free-form text field that can be used to record the device type
     this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be
     grouped and filtered based on this value.
    :vartype device_type: str
    :ivar sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same location
     as the SIM.
    :vartype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
    :ivar static_ip_configuration: A list of static IP addresses assigned to this SIM. Each address
     is assigned at a defined network scope, made up of {attached data network, slice}.
    :vartype static_ip_configuration: list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
    :ivar vendor_name: The name of the SIM vendor who provided this SIM, if any.
    :vartype vendor_name: str
    :ivar vendor_key_fingerprint: The public key fingerprint of the SIM vendor who provided this
     SIM, if any.
    :vartype vendor_key_fingerprint: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "sim_state": {"readonly": True},
        "site_provisioning_state": {"readonly": True},
        "international_mobile_subscriber_identity": {"required": True, "pattern": r"^[0-9]{5,15}$"},
        "integrated_circuit_card_identifier": {"pattern": r"^[0-9]{10,20}$"},
        "static_ip_configuration": {"min_items": 1, "unique": True},
        "vendor_name": {"readonly": True},
        "vendor_key_fingerprint": {"readonly": True},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "sim_state": {"key": "simState", "type": "str"},
        "site_provisioning_state": {"key": "siteProvisioningState", "type": "{str}"},
        "international_mobile_subscriber_identity": {"key": "internationalMobileSubscriberIdentity", "type": "str"},
        "integrated_circuit_card_identifier": {"key": "integratedCircuitCardIdentifier", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "sim_policy": {"key": "simPolicy", "type": "SimPolicyResourceId"},
        "static_ip_configuration": {"key": "staticIpConfiguration", "type": "[SimStaticIpProperties]"},
        "vendor_name": {"key": "vendorName", "type": "str"},
        "vendor_key_fingerprint": {"key": "vendorKeyFingerprint", "type": "str"},
    }

    def __init__(
        self,
        *,
        international_mobile_subscriber_identity: str,
        integrated_circuit_card_identifier: Optional[str] = None,
        device_type: Optional[str] = None,
        sim_policy: Optional["_models.SimPolicyResourceId"] = None,
        static_ip_configuration: Optional[List["_models.SimStaticIpProperties"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword international_mobile_subscriber_identity: The international mobile subscriber identity
         (IMSI) for the SIM. Required.
        :paramtype international_mobile_subscriber_identity: str
        :keyword integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the
         SIM.
        :paramtype integrated_circuit_card_identifier: str
        :keyword device_type: An optional free-form text field that can be used to record the device
         type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to
         be grouped and filtered based on this value.
        :paramtype device_type: str
        :keyword sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same
         location as the SIM.
        :paramtype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
        :keyword static_ip_configuration: A list of static IP addresses assigned to this SIM. Each
         address is assigned at a defined network scope, made up of {attached data network, slice}.
        :paramtype static_ip_configuration:
         list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.sim_state = None
        self.site_provisioning_state = None
        self.international_mobile_subscriber_identity = international_mobile_subscriber_identity
        self.integrated_circuit_card_identifier = integrated_circuit_card_identifier
        self.device_type = device_type
        self.sim_policy = sim_policy
        self.static_ip_configuration = static_ip_configuration
        self.vendor_name = None
        self.vendor_key_fingerprint = None


class ConnectedClusterResourceId(_serialization.Model):
    """Reference to an Azure Arc custom location resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure Arc connected cluster resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[kK][uU][bB][eE][rR][nN][eE][tT][eE][sS]/[cC][oO][nN][nN][eE][cC][tT][eE][dD][cC][lL][uU][sS][tT][eE][rR][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure Arc connected cluster resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class CustomLocationResourceId(_serialization.Model):
    """Reference to an Azure Arc custom location resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Azure Arc custom location resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[eE][xX][tT][eE][nN][dD][eE][dD][lL][oO][cC][aA][tT][iI][oO][nN]/[cC][uU][sS][tT][oO][mM][lL][oO][cC][aA][tT][iI][oO][nN][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure Arc custom location resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class DataNetwork(TrackedResource):
    """Data network resource. Must be created in the same location as its parent mobile network.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the data network resource. Known values
     are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar description: An optional description for this data network.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(
        self, *, location: str, tags: Optional[Dict[str, str]] = None, description: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword description: An optional description for this data network.
        :paramtype description: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.description = description


class DataNetworkConfiguration(_serialization.Model):
    """Settings controlling data network use.

    All required parameters must be populated in order to send to Azure.

    :ivar data_network: A reference to the data network that these settings apply to. The data
     network must be in the same location as the SIM policy. Required.
    :vartype data_network: ~azure.mgmt.mobilenetwork.models.DataNetworkResourceId
    :ivar session_ambr: Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU
     session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
     Required.
    :vartype session_ambr: ~azure.mgmt.mobilenetwork.models.Ambr
    :ivar five_qi: Default 5G QoS Flow Indicator value. The 5QI identifies a specific QoS
     forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full
     description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
    :vartype five_qi: int
    :ivar allocation_and_retention_priority_level: Default QoS Flow allocation and retention
     priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the
     settings of ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest
     level of priority. If this field is not specified then ``5qi`` is used to derive the ARP value.
     See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
    :vartype allocation_and_retention_priority_level: int
    :ivar preemption_capability: Default QoS Flow preemption capability. The preemption capability
     of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See
     3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Known values are:
     "NotPreempt" and "MayPreempt".
    :vartype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
    :ivar preemption_vulnerability: Default QoS Flow preemption vulnerability. The preemption
     vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher
     priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
     Known values are: "NotPreemptable" and "Preemptable".
    :vartype preemption_vulnerability: str or
     ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
    :ivar default_session_type: The default PDU session type, which is used if the UE does not
     request a specific session type. Known values are: "IPv4" and "IPv6".
    :vartype default_session_type: str or ~azure.mgmt.mobilenetwork.models.PduSessionType
    :ivar additional_allowed_session_types: Allowed session types in addition to the default
     session type. Must not duplicate the default session type.
    :vartype additional_allowed_session_types: list[str or
     ~azure.mgmt.mobilenetwork.models.PduSessionType]
    :ivar allowed_services: List of services that can be used as part of this SIM policy. The list
     must not contain duplicate items and must contain at least one item. The services must be in
     the same location as the SIM policy. Required.
    :vartype allowed_services: list[~azure.mgmt.mobilenetwork.models.ServiceResourceId]
    :ivar maximum_number_of_buffered_packets: The maximum number of downlink packets to buffer at
     the user plane for High Latency Communication - Extended Buffering. See 3GPP TS29.272 v15.10.0
     section 7.3.188 for a full description. This maximum is not guaranteed because there is a
     internal limit on buffered packets across all PDU sessions.
    :vartype maximum_number_of_buffered_packets: int
    """

    _validation = {
        "data_network": {"required": True},
        "session_ambr": {"required": True},
        "five_qi": {"maximum": 255, "minimum": 0},
        "allocation_and_retention_priority_level": {"maximum": 15, "minimum": 1},
        "additional_allowed_session_types": {"max_items": 1, "min_items": 0},
        "allowed_services": {"required": True, "min_items": 1, "unique": True},
        "maximum_number_of_buffered_packets": {"minimum": 0},
    }

    _attribute_map = {
        "data_network": {"key": "dataNetwork", "type": "DataNetworkResourceId"},
        "session_ambr": {"key": "sessionAmbr", "type": "Ambr"},
        "five_qi": {"key": "5qi", "type": "int"},
        "allocation_and_retention_priority_level": {"key": "allocationAndRetentionPriorityLevel", "type": "int"},
        "preemption_capability": {"key": "preemptionCapability", "type": "str"},
        "preemption_vulnerability": {"key": "preemptionVulnerability", "type": "str"},
        "default_session_type": {"key": "defaultSessionType", "type": "str"},
        "additional_allowed_session_types": {"key": "additionalAllowedSessionTypes", "type": "[str]"},
        "allowed_services": {"key": "allowedServices", "type": "[ServiceResourceId]"},
        "maximum_number_of_buffered_packets": {"key": "maximumNumberOfBufferedPackets", "type": "int"},
    }

    def __init__(
        self,
        *,
        data_network: "_models.DataNetworkResourceId",
        session_ambr: "_models.Ambr",
        allowed_services: List["_models.ServiceResourceId"],
        five_qi: Optional[int] = None,
        allocation_and_retention_priority_level: Optional[int] = None,
        preemption_capability: Optional[Union[str, "_models.PreemptionCapability"]] = None,
        preemption_vulnerability: Optional[Union[str, "_models.PreemptionVulnerability"]] = None,
        default_session_type: Optional[Union[str, "_models.PduSessionType"]] = None,
        additional_allowed_session_types: Optional[List[Union[str, "_models.PduSessionType"]]] = None,
        maximum_number_of_buffered_packets: int = 10,
        **kwargs: Any
    ) -> None:
        """
        :keyword data_network: A reference to the data network that these settings apply to. The data
         network must be in the same location as the SIM policy. Required.
        :paramtype data_network: ~azure.mgmt.mobilenetwork.models.DataNetworkResourceId
        :keyword session_ambr: Aggregate maximum bit rate across all non-GBR QoS flows of a given PDU
         session. See 3GPP TS23.501 section 5.7.2.6 for a full description of the Session-AMBR.
         Required.
        :paramtype session_ambr: ~azure.mgmt.mobilenetwork.models.Ambr
        :keyword five_qi: Default 5G QoS Flow Indicator value. The 5QI identifies a specific QoS
         forwarding treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full
         description of the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
        :paramtype five_qi: int
        :keyword allocation_and_retention_priority_level: Default QoS Flow allocation and retention
         priority (ARP) level. Flows with higher priority preempt flows with lower priority, if the
         settings of ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest
         level of priority. If this field is not specified then ``5qi`` is used to derive the ARP value.
         See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :paramtype allocation_and_retention_priority_level: int
        :keyword preemption_capability: Default QoS Flow preemption capability. The preemption
         capability of a QoS Flow controls whether it can preempt another QoS Flow with a lower priority
         level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Known
         values are: "NotPreempt" and "MayPreempt".
        :paramtype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
        :keyword preemption_vulnerability: Default QoS Flow preemption vulnerability. The preemption
         vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher
         priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
         Known values are: "NotPreemptable" and "Preemptable".
        :paramtype preemption_vulnerability: str or
         ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
        :keyword default_session_type: The default PDU session type, which is used if the UE does not
         request a specific session type. Known values are: "IPv4" and "IPv6".
        :paramtype default_session_type: str or ~azure.mgmt.mobilenetwork.models.PduSessionType
        :keyword additional_allowed_session_types: Allowed session types in addition to the default
         session type. Must not duplicate the default session type.
        :paramtype additional_allowed_session_types: list[str or
         ~azure.mgmt.mobilenetwork.models.PduSessionType]
        :keyword allowed_services: List of services that can be used as part of this SIM policy. The
         list must not contain duplicate items and must contain at least one item. The services must be
         in the same location as the SIM policy. Required.
        :paramtype allowed_services: list[~azure.mgmt.mobilenetwork.models.ServiceResourceId]
        :keyword maximum_number_of_buffered_packets: The maximum number of downlink packets to buffer
         at the user plane for High Latency Communication - Extended Buffering. See 3GPP TS29.272
         v15.10.0 section 7.3.188 for a full description. This maximum is not guaranteed because there
         is a internal limit on buffered packets across all PDU sessions.
        :paramtype maximum_number_of_buffered_packets: int
        """
        super().__init__(**kwargs)
        self.data_network = data_network
        self.session_ambr = session_ambr
        self.five_qi = five_qi
        self.allocation_and_retention_priority_level = allocation_and_retention_priority_level
        self.preemption_capability = preemption_capability
        self.preemption_vulnerability = preemption_vulnerability
        self.default_session_type = default_session_type
        self.additional_allowed_session_types = additional_allowed_session_types
        self.allowed_services = allowed_services
        self.maximum_number_of_buffered_packets = maximum_number_of_buffered_packets


class DataNetworkListResult(_serialization.Model):
    """Response for data network API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of data networks.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.DataNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DataNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DataNetwork"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of data networks.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.DataNetwork]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DataNetworkResourceId(_serialization.Model):
    """Reference to a data network resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Data network resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+/[dD][aA][tT][aA][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Data network resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)


class DiagnosticsPackage(ProxyResource):
    """Diagnostics package resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the diagnostics package resource. Known
     values are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar status: The status of the diagnostics package collection. Known values are: "NotStarted",
     "Collecting", "Collected", and "Error".
    :vartype status: str or ~azure.mgmt.mobilenetwork.models.DiagnosticsPackageStatus
    :ivar reason: The reason for the current state of the diagnostics package collection.
    :vartype reason: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "reason": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "reason": {"key": "properties.reason", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.status = None
        self.reason = None


class DiagnosticsPackageListResult(_serialization.Model):
    """Response for diagnostics package API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of diagnostics packages under a packet core control plane.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.DiagnosticsPackage]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiagnosticsPackage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DiagnosticsPackage"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of diagnostics packages under a packet core control plane.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.DiagnosticsPackage]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class DiagnosticsUploadConfiguration(_serialization.Model):
    """Configuration for uploading packet core diagnostics.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_account_container_url: The Storage Account Container URL to upload diagnostics
     to. Required.
    :vartype storage_account_container_url: str
    """

    _validation = {
        "storage_account_container_url": {"required": True},
    }

    _attribute_map = {
        "storage_account_container_url": {"key": "storageAccountContainerUrl", "type": "str"},
    }

    def __init__(self, *, storage_account_container_url: str, **kwargs: Any) -> None:
        """
        :keyword storage_account_container_url: The Storage Account Container URL to upload diagnostics
         to. Required.
        :paramtype storage_account_container_url: str
        """
        super().__init__(**kwargs)
        self.storage_account_container_url = storage_account_container_url


class EncryptedSimPropertiesFormat(CommonSimPropertiesFormat):  # pylint: disable=too-many-instance-attributes
    """Encrypted SIM properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The provisioning state of the SIM resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar sim_state: The state of the SIM resource. Known values are: "Disabled", "Enabled", and
     "Invalid".
    :vartype sim_state: str or ~azure.mgmt.mobilenetwork.models.SimState
    :ivar site_provisioning_state: A dictionary of sites to the provisioning state of this SIM on
     that site.
    :vartype site_provisioning_state: dict[str, str or
     ~azure.mgmt.mobilenetwork.models.SiteProvisioningState]
    :ivar international_mobile_subscriber_identity: The international mobile subscriber identity
     (IMSI) for the SIM. Required.
    :vartype international_mobile_subscriber_identity: str
    :ivar integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the SIM.
    :vartype integrated_circuit_card_identifier: str
    :ivar device_type: An optional free-form text field that can be used to record the device type
     this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be
     grouped and filtered based on this value.
    :vartype device_type: str
    :ivar sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same location
     as the SIM.
    :vartype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
    :ivar static_ip_configuration: A list of static IP addresses assigned to this SIM. Each address
     is assigned at a defined network scope, made up of {attached data network, slice}.
    :vartype static_ip_configuration: list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
    :ivar vendor_name: The name of the SIM vendor who provided this SIM, if any.
    :vartype vendor_name: str
    :ivar vendor_key_fingerprint: The public key fingerprint of the SIM vendor who provided this
     SIM, if any.
    :vartype vendor_key_fingerprint: str
    :ivar encrypted_credentials: The encrypted SIM credentials.
    :vartype encrypted_credentials: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "sim_state": {"readonly": True},
        "site_provisioning_state": {"readonly": True},
        "international_mobile_subscriber_identity": {"required": True, "pattern": r"^[0-9]{5,15}$"},
        "integrated_circuit_card_identifier": {"pattern": r"^[0-9]{10,20}$"},
        "static_ip_configuration": {"min_items": 1, "unique": True},
        "vendor_name": {"readonly": True},
        "vendor_key_fingerprint": {"readonly": True},
        "encrypted_credentials": {"pattern": r"^[0-9a-fA-F]+$"},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "sim_state": {"key": "simState", "type": "str"},
        "site_provisioning_state": {"key": "siteProvisioningState", "type": "{str}"},
        "international_mobile_subscriber_identity": {"key": "internationalMobileSubscriberIdentity", "type": "str"},
        "integrated_circuit_card_identifier": {"key": "integratedCircuitCardIdentifier", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "sim_policy": {"key": "simPolicy", "type": "SimPolicyResourceId"},
        "static_ip_configuration": {"key": "staticIpConfiguration", "type": "[SimStaticIpProperties]"},
        "vendor_name": {"key": "vendorName", "type": "str"},
        "vendor_key_fingerprint": {"key": "vendorKeyFingerprint", "type": "str"},
        "encrypted_credentials": {"key": "encryptedCredentials", "type": "str"},
    }

    def __init__(
        self,
        *,
        international_mobile_subscriber_identity: str,
        integrated_circuit_card_identifier: Optional[str] = None,
        device_type: Optional[str] = None,
        sim_policy: Optional["_models.SimPolicyResourceId"] = None,
        static_ip_configuration: Optional[List["_models.SimStaticIpProperties"]] = None,
        encrypted_credentials: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword international_mobile_subscriber_identity: The international mobile subscriber identity
         (IMSI) for the SIM. Required.
        :paramtype international_mobile_subscriber_identity: str
        :keyword integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the
         SIM.
        :paramtype integrated_circuit_card_identifier: str
        :keyword device_type: An optional free-form text field that can be used to record the device
         type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to
         be grouped and filtered based on this value.
        :paramtype device_type: str
        :keyword sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same
         location as the SIM.
        :paramtype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
        :keyword static_ip_configuration: A list of static IP addresses assigned to this SIM. Each
         address is assigned at a defined network scope, made up of {attached data network, slice}.
        :paramtype static_ip_configuration:
         list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
        :keyword encrypted_credentials: The encrypted SIM credentials.
        :paramtype encrypted_credentials: str
        """
        super().__init__(
            international_mobile_subscriber_identity=international_mobile_subscriber_identity,
            integrated_circuit_card_identifier=integrated_circuit_card_identifier,
            device_type=device_type,
            sim_policy=sim_policy,
            static_ip_configuration=static_ip_configuration,
            **kwargs
        )
        self.encrypted_credentials = encrypted_credentials


class EncryptedSimUploadList(_serialization.Model):
    """The SIMs to upload. The SIM credentials must be encrypted.

    All required parameters must be populated in order to send to Azure.

    :ivar version: The upload file format version. Required.
    :vartype version: int
    :ivar azure_key_identifier: An identifier for the Azure SIM onboarding public key used for
     encrypted upload. Required.
    :vartype azure_key_identifier: int
    :ivar vendor_key_fingerprint: The fingerprint of the SIM vendor public key. The private
     counterpart is used for signing the encrypted transport key. Required.
    :vartype vendor_key_fingerprint: str
    :ivar encrypted_transport_key: The transport key used for encrypting SIM credentials, encrypted
     using the SIM onboarding public key. Required.
    :vartype encrypted_transport_key: str
    :ivar signed_transport_key: The encrypted transport key, signed using the SIM vendor private
     key. Required.
    :vartype signed_transport_key: str
    :ivar sims: A list of SIMs to upload, with encrypted properties. Required.
    :vartype sims: list[~azure.mgmt.mobilenetwork.models.SimNameAndEncryptedProperties]
    """

    _validation = {
        "version": {"required": True, "minimum": 1},
        "azure_key_identifier": {"required": True, "minimum": 1},
        "vendor_key_fingerprint": {"required": True, "pattern": r"^[0-9a-fA-F]+$"},
        "encrypted_transport_key": {"required": True, "pattern": r"^[0-9a-fA-F]+$"},
        "signed_transport_key": {"required": True, "pattern": r"^[0-9a-fA-F]+$"},
        "sims": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "version": {"key": "version", "type": "int"},
        "azure_key_identifier": {"key": "azureKeyIdentifier", "type": "int"},
        "vendor_key_fingerprint": {"key": "vendorKeyFingerprint", "type": "str"},
        "encrypted_transport_key": {"key": "encryptedTransportKey", "type": "str"},
        "signed_transport_key": {"key": "signedTransportKey", "type": "str"},
        "sims": {"key": "sims", "type": "[SimNameAndEncryptedProperties]"},
    }

    def __init__(
        self,
        *,
        version: int,
        azure_key_identifier: int,
        vendor_key_fingerprint: str,
        encrypted_transport_key: str,
        signed_transport_key: str,
        sims: List["_models.SimNameAndEncryptedProperties"],
        **kwargs: Any
    ) -> None:
        """
        :keyword version: The upload file format version. Required.
        :paramtype version: int
        :keyword azure_key_identifier: An identifier for the Azure SIM onboarding public key used for
         encrypted upload. Required.
        :paramtype azure_key_identifier: int
        :keyword vendor_key_fingerprint: The fingerprint of the SIM vendor public key. The private
         counterpart is used for signing the encrypted transport key. Required.
        :paramtype vendor_key_fingerprint: str
        :keyword encrypted_transport_key: The transport key used for encrypting SIM credentials,
         encrypted using the SIM onboarding public key. Required.
        :paramtype encrypted_transport_key: str
        :keyword signed_transport_key: The encrypted transport key, signed using the SIM vendor private
         key. Required.
        :paramtype signed_transport_key: str
        :keyword sims: A list of SIMs to upload, with encrypted properties. Required.
        :paramtype sims: list[~azure.mgmt.mobilenetwork.models.SimNameAndEncryptedProperties]
        """
        super().__init__(**kwargs)
        self.version = version
        self.azure_key_identifier = azure_key_identifier
        self.vendor_key_fingerprint = vendor_key_fingerprint
        self.encrypted_transport_key = encrypted_transport_key
        self.signed_transport_key = signed_transport_key
        self.sims = sims


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorDetail(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.mobilenetwork.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.mobilenetwork.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetail]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ErrorResponse(_serialization.Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations. (This also follows the OData error response format.).

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.mobilenetwork.models.ErrorDetail
    """

    _attribute_map = {
        "error": {"key": "error", "type": "ErrorDetail"},
    }

    def __init__(self, *, error: Optional["_models.ErrorDetail"] = None, **kwargs: Any) -> None:
        """
        :keyword error: The error object.
        :paramtype error: ~azure.mgmt.mobilenetwork.models.ErrorDetail
        """
        super().__init__(**kwargs)
        self.error = error


class EventHubConfiguration(_serialization.Model):
    """Configuration for sending packet core events to Azure Event Hub.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID  of Azure Event Hub to send packet core events to. Required.
    :vartype id: str
    :ivar reporting_interval: The duration (in seconds) between UE usage reports.
    :vartype reporting_interval: int
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[eE][vV][eE][nN][tT][hH][uU][bB]/[nN][aA][mM][eE][sS][pP][aA][cC][eE][sS]/[^/?#]+/[eV][vV][eE][nN][tT][hH][uU][bB][sS]/[^/?#]+$",
        },
        "reporting_interval": {"maximum": 3600, "minimum": 30},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "reporting_interval": {"key": "reportingInterval", "type": "int"},
    }

    def __init__(
        self, *, id: str, reporting_interval: int = 1800, **kwargs: Any  # pylint: disable=redefined-builtin
    ) -> None:
        """
        :keyword id: Resource ID  of Azure Event Hub to send packet core events to. Required.
        :paramtype id: str
        :keyword reporting_interval: The duration (in seconds) between UE usage reports.
        :paramtype reporting_interval: int
        """
        super().__init__(**kwargs)
        self.id = id
        self.reporting_interval = reporting_interval


class HttpsServerCertificate(_serialization.Model):
    """HTTPS server certificate configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar certificate_url: The certificate URL, unversioned. For example:
     https://contosovault.vault.azure.net/certificates/ingress. Required.
    :vartype certificate_url: str
    :ivar provisioning: The provisioning state of the certificate.
    :vartype provisioning: ~azure.mgmt.mobilenetwork.models.CertificateProvisioning
    """

    _validation = {
        "certificate_url": {"required": True},
        "provisioning": {"readonly": True},
    }

    _attribute_map = {
        "certificate_url": {"key": "certificateUrl", "type": "str"},
        "provisioning": {"key": "provisioning", "type": "CertificateProvisioning"},
    }

    def __init__(self, *, certificate_url: str, **kwargs: Any) -> None:
        """
        :keyword certificate_url: The certificate URL, unversioned. For example:
         https://contosovault.vault.azure.net/certificates/ingress. Required.
        :paramtype certificate_url: str
        """
        super().__init__(**kwargs)
        self.certificate_url = certificate_url
        self.provisioning = None


class IdentityAndTagsObject(_serialization.Model):
    """Identity and Tags object for patch operations.

    :ivar identity: The managed service identity associated with this resource.
    :vartype identity: ~azure.mgmt.mobilenetwork.models.ManagedServiceIdentity
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword identity: The managed service identity associated with this resource.
        :paramtype identity: ~azure.mgmt.mobilenetwork.models.ManagedServiceIdentity
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.identity = identity
        self.tags = tags


class Installation(_serialization.Model):
    """The installation state of the packet core.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar desired_state: The desired installation state. Known values are: "Uninstalled" and
     "Installed".
    :vartype desired_state: str or ~azure.mgmt.mobilenetwork.models.DesiredInstallationState
    :ivar state: Installation state. Known values are: "Uninstalled", "Installing", "Installed",
     "Updating", "Upgrading", "Uninstalling", "Reinstalling", "RollingBack", and "Failed".
    :vartype state: str or ~azure.mgmt.mobilenetwork.models.InstallationState
    :ivar reinstall_required: Whether a reinstall of the packet core is required to pick up the
     latest configuration changes. Known values are: "Required" and "NotRequired".
    :vartype reinstall_required: str or ~azure.mgmt.mobilenetwork.models.ReinstallRequired
    :ivar reasons: Reason(s) for the current installation state of the packet core.
    :vartype reasons: list[str or ~azure.mgmt.mobilenetwork.models.InstallationReason]
    :ivar operation: A reference to an in-progress installation operation.
    :vartype operation: ~azure.mgmt.mobilenetwork.models.AsyncOperationId
    """

    _validation = {
        "state": {"readonly": True},
        "reinstall_required": {"readonly": True},
        "reasons": {"readonly": True, "unique": True},
        "operation": {"readonly": True},
    }

    _attribute_map = {
        "desired_state": {"key": "desiredState", "type": "str"},
        "state": {"key": "state", "type": "str"},
        "reinstall_required": {"key": "reinstallRequired", "type": "str"},
        "reasons": {"key": "reasons", "type": "[str]"},
        "operation": {"key": "operation", "type": "AsyncOperationId"},
    }

    def __init__(
        self, *, desired_state: Optional[Union[str, "_models.DesiredInstallationState"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword desired_state: The desired installation state. Known values are: "Uninstalled" and
         "Installed".
        :paramtype desired_state: str or ~azure.mgmt.mobilenetwork.models.DesiredInstallationState
        """
        super().__init__(**kwargs)
        self.desired_state = desired_state
        self.state = None
        self.reinstall_required = None
        self.reasons = None
        self.operation = None


class InterfaceProperties(_serialization.Model):
    """Interface properties.

    :ivar name: The logical name for this interface. This should match one of the interfaces
     configured on your Azure Stack Edge device.
    :vartype name: str
    :ivar ipv4_address: The IPv4 address.
    :vartype ipv4_address: str
    :ivar ipv4_subnet: The IPv4 subnet.
    :vartype ipv4_subnet: str
    :ivar ipv4_gateway: The default IPv4 gateway (router).
    :vartype ipv4_gateway: str
    """

    _validation = {
        "ipv4_address": {
            "pattern": r"^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$"
        },
        "ipv4_subnet": {
            "pattern": r"^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(\/([0-9]|[1-2][0-9]|3[0-2]))$"
        },
        "ipv4_gateway": {
            "pattern": r"^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$"
        },
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "ipv4_address": {"key": "ipv4Address", "type": "str"},
        "ipv4_subnet": {"key": "ipv4Subnet", "type": "str"},
        "ipv4_gateway": {"key": "ipv4Gateway", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        ipv4_address: Optional[str] = None,
        ipv4_subnet: Optional[str] = None,
        ipv4_gateway: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The logical name for this interface. This should match one of the interfaces
         configured on your Azure Stack Edge device.
        :paramtype name: str
        :keyword ipv4_address: The IPv4 address.
        :paramtype ipv4_address: str
        :keyword ipv4_subnet: The IPv4 subnet.
        :paramtype ipv4_subnet: str
        :keyword ipv4_gateway: The default IPv4 gateway (router).
        :paramtype ipv4_gateway: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.ipv4_address = ipv4_address
        self.ipv4_subnet = ipv4_subnet
        self.ipv4_gateway = ipv4_gateway


class KeyVaultKey(_serialization.Model):
    """An Azure key vault key.

    :ivar key_url: The key URL, unversioned. For example:
     https://contosovault.vault.azure.net/keys/azureKey.
    :vartype key_url: str
    """

    _attribute_map = {
        "key_url": {"key": "keyUrl", "type": "str"},
    }

    def __init__(self, *, key_url: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword key_url: The key URL, unversioned. For example:
         https://contosovault.vault.azure.net/keys/azureKey.
        :paramtype key_url: str
        """
        super().__init__(**kwargs)
        self.key_url = key_url


class LocalDiagnosticsAccessConfiguration(_serialization.Model):
    """The kubernetes ingress configuration to control access to packet core diagnostics over local
    APIs.

    All required parameters must be populated in order to send to Azure.

    :ivar authentication_type: How to authenticate users who access local diagnostics APIs.
     Required. Known values are: "AAD" and "Password".
    :vartype authentication_type: str or ~azure.mgmt.mobilenetwork.models.AuthenticationType
    :ivar https_server_certificate: The HTTPS server TLS certificate used to secure local access to
     diagnostics.
    :vartype https_server_certificate: ~azure.mgmt.mobilenetwork.models.HttpsServerCertificate
    """

    _validation = {
        "authentication_type": {"required": True},
    }

    _attribute_map = {
        "authentication_type": {"key": "authenticationType", "type": "str"},
        "https_server_certificate": {"key": "httpsServerCertificate", "type": "HttpsServerCertificate"},
    }

    def __init__(
        self,
        *,
        authentication_type: Union[str, "_models.AuthenticationType"],
        https_server_certificate: Optional["_models.HttpsServerCertificate"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword authentication_type: How to authenticate users who access local diagnostics APIs.
         Required. Known values are: "AAD" and "Password".
        :paramtype authentication_type: str or ~azure.mgmt.mobilenetwork.models.AuthenticationType
        :keyword https_server_certificate: The HTTPS server TLS certificate used to secure local access
         to diagnostics.
        :paramtype https_server_certificate: ~azure.mgmt.mobilenetwork.models.HttpsServerCertificate
        """
        super().__init__(**kwargs)
        self.authentication_type = authentication_type
        self.https_server_certificate = https_server_certificate


class ManagedServiceIdentity(_serialization.Model):
    """Managed service identity (User assigned identity).

    All required parameters must be populated in order to send to Azure.

    :ivar type: Type of managed service identity (currently only UserAssigned allowed). Required.
     Known values are: "None" and "UserAssigned".
    :vartype type: str or ~azure.mgmt.mobilenetwork.models.ManagedServiceIdentityType
    :ivar user_assigned_identities: The set of user assigned identities associated with the
     resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
     The dictionary values can be empty objects ({}) in requests.
    :vartype user_assigned_identities: dict[str,
     ~azure.mgmt.mobilenetwork.models.UserAssignedIdentity]
    """

    _validation = {
        "type": {"required": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "user_assigned_identities": {"key": "userAssignedIdentities", "type": "{UserAssignedIdentity}"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.ManagedServiceIdentityType"],
        user_assigned_identities: Optional[Dict[str, "_models.UserAssignedIdentity"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: Type of managed service identity (currently only UserAssigned allowed).
         Required. Known values are: "None" and "UserAssigned".
        :paramtype type: str or ~azure.mgmt.mobilenetwork.models.ManagedServiceIdentityType
        :keyword user_assigned_identities: The set of user assigned identities associated with the
         resource. The userAssignedIdentities dictionary keys will be ARM resource ids in the form:
         '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}.
         The dictionary values can be empty objects ({}) in requests.
        :paramtype user_assigned_identities: dict[str,
         ~azure.mgmt.mobilenetwork.models.UserAssignedIdentity]
        """
        super().__init__(**kwargs)
        self.type = type
        self.user_assigned_identities = user_assigned_identities


class MobileNetwork(TrackedResource):
    """Mobile network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the mobile network resource. Known values
     are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar public_land_mobile_network_identifier: The unique public land mobile network identifier
     for the network. This is made up of the mobile country code and mobile network code, as defined
     in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used for testing
     and the values 999-99 and 999-999 can be used on internal private networks. Required.
    :vartype public_land_mobile_network_identifier: ~azure.mgmt.mobilenetwork.models.PlmnId
    :ivar service_key: The mobile network resource identifier.
    :vartype service_key: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "public_land_mobile_network_identifier": {"required": True},
        "service_key": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "public_land_mobile_network_identifier": {
            "key": "properties.publicLandMobileNetworkIdentifier",
            "type": "PlmnId",
        },
        "service_key": {"key": "properties.serviceKey", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        public_land_mobile_network_identifier: "_models.PlmnId",
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword public_land_mobile_network_identifier: The unique public land mobile network
         identifier for the network. This is made up of the mobile country code and mobile network code,
         as defined in https://www.itu.int/rec/T-REC-E.212. The values 001-01 and 001-001 can be used
         for testing and the values 999-99 and 999-999 can be used on internal private networks.
         Required.
        :paramtype public_land_mobile_network_identifier: ~azure.mgmt.mobilenetwork.models.PlmnId
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.public_land_mobile_network_identifier = public_land_mobile_network_identifier
        self.service_key = None


class MobileNetworkListResult(_serialization.Model):
    """Response for mobile networks API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of mobile networks in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.MobileNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[MobileNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.MobileNetwork"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of mobile networks in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.MobileNetwork]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class MobileNetworkResourceId(_serialization.Model):
    """Reference to a mobile network resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Mobile network resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Mobile network resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class NaptConfiguration(_serialization.Model):
    """The network address and port translation settings to use for the attached data network.

    :ivar enabled: Whether NAPT is enabled for connections to this attached data network. Known
     values are: "Enabled" and "Disabled".
    :vartype enabled: str or ~azure.mgmt.mobilenetwork.models.NaptEnabled
    :ivar port_range: Range of port numbers to use as translated ports on each translated address.
     If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
     (Ports under 1,024 should not be used because these are special purpose ports reserved by
     IANA. Ports 50,000 and above are reserved for non-NAPT use.).
    :vartype port_range: ~azure.mgmt.mobilenetwork.models.PortRange
    :ivar port_reuse_hold_time: The minimum time (in seconds) that will pass before a port that was
     used by a closed pinhole can be recycled for use by another pinhole. All hold times must be at
     least 1 second.
    :vartype port_reuse_hold_time: ~azure.mgmt.mobilenetwork.models.PortReuseHoldTimes
    :ivar pinhole_limits: Maximum number of UDP and TCP pinholes that can be open simultaneously on
     the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the SGi
     interface.
    :vartype pinhole_limits: int
    :ivar pinhole_timeouts: Expiry times of inactive NAPT pinholes, in seconds. All timers must be
     at least 1 second.
    :vartype pinhole_timeouts: ~azure.mgmt.mobilenetwork.models.PinholeTimeouts
    """

    _validation = {
        "pinhole_limits": {"maximum": 65536, "minimum": 1},
    }

    _attribute_map = {
        "enabled": {"key": "enabled", "type": "str"},
        "port_range": {"key": "portRange", "type": "PortRange"},
        "port_reuse_hold_time": {"key": "portReuseHoldTime", "type": "PortReuseHoldTimes"},
        "pinhole_limits": {"key": "pinholeLimits", "type": "int"},
        "pinhole_timeouts": {"key": "pinholeTimeouts", "type": "PinholeTimeouts"},
    }

    def __init__(
        self,
        *,
        enabled: Union[str, "_models.NaptEnabled"] = "Enabled",
        port_range: Optional["_models.PortRange"] = None,
        port_reuse_hold_time: Optional["_models.PortReuseHoldTimes"] = None,
        pinhole_limits: int = 65536,
        pinhole_timeouts: Optional["_models.PinholeTimeouts"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enabled: Whether NAPT is enabled for connections to this attached data network. Known
         values are: "Enabled" and "Disabled".
        :paramtype enabled: str or ~azure.mgmt.mobilenetwork.models.NaptEnabled
        :keyword port_range: Range of port numbers to use as translated ports on each translated
         address.
         If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
         (Ports under 1,024 should not be used because these are special purpose ports reserved by
         IANA. Ports 50,000 and above are reserved for non-NAPT use.).
        :paramtype port_range: ~azure.mgmt.mobilenetwork.models.PortRange
        :keyword port_reuse_hold_time: The minimum time (in seconds) that will pass before a port that
         was used by a closed pinhole can be recycled for use by another pinhole. All hold times must be
         at least 1 second.
        :paramtype port_reuse_hold_time: ~azure.mgmt.mobilenetwork.models.PortReuseHoldTimes
        :keyword pinhole_limits: Maximum number of UDP and TCP pinholes that can be open simultaneously
         on the core interface. For 5G networks, this is the N6 interface. For 4G networks, this is the
         SGi interface.
        :paramtype pinhole_limits: int
        :keyword pinhole_timeouts: Expiry times of inactive NAPT pinholes, in seconds. All timers must
         be at least 1 second.
        :paramtype pinhole_timeouts: ~azure.mgmt.mobilenetwork.models.PinholeTimeouts
        """
        super().__init__(**kwargs)
        self.enabled = enabled
        self.port_range = port_range
        self.port_reuse_hold_time = port_reuse_hold_time
        self.pinhole_limits = pinhole_limits
        self.pinhole_timeouts = pinhole_timeouts


class NASRerouteConfiguration(_serialization.Model):
    """Configuration enabling NAS reroute.

    All required parameters must be populated in order to send to Azure.

    :ivar macro_mme_group_id: The macro network's MME group ID. This is where unknown UEs are sent
     to via NAS reroute. Required.
    :vartype macro_mme_group_id: int
    """

    _validation = {
        "macro_mme_group_id": {"required": True, "maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "macro_mme_group_id": {"key": "macroMmeGroupId", "type": "int"},
    }

    def __init__(self, *, macro_mme_group_id: int, **kwargs: Any) -> None:
        """
        :keyword macro_mme_group_id: The macro network's MME group ID. This is where unknown UEs are
         sent to via NAS reroute. Required.
        :paramtype macro_mme_group_id: int
        """
        super().__init__(**kwargs)
        self.macro_mme_group_id = macro_mme_group_id


class Operation(_serialization.Model):
    """Object that describes a single Microsoft.MobileNetwork operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar is_data_action: Indicates whether the operation applies to data-plane.
    :vartype is_data_action: bool
    :ivar name: Operation name: {provider}/{resource}/{operation}.
    :vartype name: str
    :ivar display: The object that represents the operation.
    :vartype display: ~azure.mgmt.mobilenetwork.models.OperationDisplay
    """

    _validation = {
        "name": {"readonly": True},
        "display": {"readonly": True},
    }

    _attribute_map = {
        "is_data_action": {"key": "isDataAction", "type": "bool"},
        "name": {"key": "name", "type": "str"},
        "display": {"key": "display", "type": "OperationDisplay"},
    }

    def __init__(self, *, is_data_action: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword is_data_action: Indicates whether the operation applies to data-plane.
        :paramtype is_data_action: bool
        """
        super().__init__(**kwargs)
        self.is_data_action = is_data_action
        self.name = None
        self.display = None


class OperationDisplay(_serialization.Model):
    """The object that represents the operation.

    :ivar provider: Service provider: Microsoft.MobileNetwork.
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Registration definition,
     registration assignment etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    :ivar description: Description of the operation.
    :vartype description: str
    """

    _attribute_map = {
        "provider": {"key": "provider", "type": "str"},
        "resource": {"key": "resource", "type": "str"},
        "operation": {"key": "operation", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        provider: Optional[str] = None,
        resource: Optional[str] = None,
        operation: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword provider: Service provider: Microsoft.MobileNetwork.
        :paramtype provider: str
        :keyword resource: Resource on which the operation is performed: Registration definition,
         registration assignment etc.
        :paramtype resource: str
        :keyword operation: Operation type: Read, write, delete, etc.
        :paramtype operation: str
        :keyword description: Description of the operation.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationList(_serialization.Model):
    """List of the operations.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: List of Microsoft.MobileNetwork operations.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Operation]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Operation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class PacketCapture(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """Packet capture session resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the packet capture session resource. Known
     values are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar status: The status of the packet capture session. Known values are: "NotStarted",
     "Running", "Stopped", and "Error".
    :vartype status: str or ~azure.mgmt.mobilenetwork.models.PacketCaptureStatus
    :ivar reason: The reason the current packet capture session state.
    :vartype reason: str
    :ivar capture_start_time: The start time of the packet capture session.
    :vartype capture_start_time: ~datetime.datetime
    :ivar network_interfaces: List of network interfaces to capture on.
    :vartype network_interfaces: list[str]
    :ivar bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes are
     truncated. The default "0" means the entire packet is captured.
    :vartype bytes_to_capture_per_packet: int
    :ivar total_bytes_per_session: Maximum size of the capture output.
    :vartype total_bytes_per_session: int
    :ivar time_limit_in_seconds: Maximum duration of the capture session in seconds.
    :vartype time_limit_in_seconds: int
    :ivar output_files: The list of output files of a packet capture session.
    :vartype output_files: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "status": {"readonly": True},
        "reason": {"readonly": True},
        "capture_start_time": {"readonly": True},
        "network_interfaces": {"min_items": 1, "unique": True},
        "bytes_to_capture_per_packet": {"maximum": 4294967295, "minimum": 0},
        "total_bytes_per_session": {"maximum": 4294967295, "minimum": 1000},
        "time_limit_in_seconds": {"maximum": 18000, "minimum": 5},
        "output_files": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "status": {"key": "properties.status", "type": "str"},
        "reason": {"key": "properties.reason", "type": "str"},
        "capture_start_time": {"key": "properties.captureStartTime", "type": "iso-8601"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[str]"},
        "bytes_to_capture_per_packet": {"key": "properties.bytesToCapturePerPacket", "type": "int"},
        "total_bytes_per_session": {"key": "properties.totalBytesPerSession", "type": "int"},
        "time_limit_in_seconds": {"key": "properties.timeLimitInSeconds", "type": "int"},
        "output_files": {"key": "properties.outputFiles", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        network_interfaces: Optional[List[str]] = None,
        bytes_to_capture_per_packet: int = 0,
        total_bytes_per_session: int = 67108864,
        time_limit_in_seconds: int = 18000,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interfaces: List of network interfaces to capture on.
        :paramtype network_interfaces: list[str]
        :keyword bytes_to_capture_per_packet: Number of bytes captured per packet, the remaining bytes
         are truncated. The default "0" means the entire packet is captured.
        :paramtype bytes_to_capture_per_packet: int
        :keyword total_bytes_per_session: Maximum size of the capture output.
        :paramtype total_bytes_per_session: int
        :keyword time_limit_in_seconds: Maximum duration of the capture session in seconds.
        :paramtype time_limit_in_seconds: int
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.status = None
        self.reason = None
        self.capture_start_time = None
        self.network_interfaces = network_interfaces
        self.bytes_to_capture_per_packet = bytes_to_capture_per_packet
        self.total_bytes_per_session = total_bytes_per_session
        self.time_limit_in_seconds = time_limit_in_seconds
        self.output_files = None


class PacketCaptureListResult(_serialization.Model):
    """Response for packet capture API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of packet capture sessions under a packet core control plane.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.PacketCapture]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PacketCapture]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PacketCapture"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of packet capture sessions under a packet core control plane.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.PacketCapture]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PacketCoreControlPlane(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """Packet core control plane resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The identity used to retrieve the ingress certificate from Azure key vault.
    :vartype identity: ~azure.mgmt.mobilenetwork.models.ManagedServiceIdentity
    :ivar provisioning_state: The provisioning state of the packet core control plane resource.
     Known values are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar installation: The installation state of the packet core control plane resource.
    :vartype installation: ~azure.mgmt.mobilenetwork.models.Installation
    :ivar sites: Site(s) under which this packet core control plane should be deployed. The sites
     must be in the same location as the packet core control plane. Required.
    :vartype sites: list[~azure.mgmt.mobilenetwork.models.SiteResourceId]
    :ivar platform: The platform where the packet core is deployed. Required.
    :vartype platform: ~azure.mgmt.mobilenetwork.models.PlatformConfiguration
    :ivar core_network_technology: The core network technology generation (5G core or EPC / 4G
     core). Known values are: "5GC", "EPC", and "EPC + 5GC".
    :vartype core_network_technology: str or ~azure.mgmt.mobilenetwork.models.CoreNetworkType
    :ivar version: The desired version of the packet core software.
    :vartype version: str
    :ivar installed_version: The currently installed version of the packet core software.
    :vartype installed_version: str
    :ivar rollback_version: The previous version of the packet core software that was deployed.
     Used when performing the rollback action.
    :vartype rollback_version: str
    :ivar control_plane_access_interface: The control plane interface on the access network. For 5G
     networks, this is the N2 interface. For 4G networks, this is the S1-MME interface. Required.
    :vartype control_plane_access_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
    :ivar control_plane_access_virtual_ipv4_addresses: The virtual IP address(es) for the control
     plane on the access network in a High Availability (HA) system. In an HA deployment the access
     network router should be configured to anycast traffic for this address to the control plane
     access interfaces on the active and standby nodes. In non-HA system this list should be omitted
     or empty.
    :vartype control_plane_access_virtual_ipv4_addresses: list[str]
    :ivar sku: The SKU defining the throughput and SIM allowances for this packet core control
     plane deployment. Required. Known values are: "G0", "G1", "G2", "G5", and "G10".
    :vartype sku: str or ~azure.mgmt.mobilenetwork.models.BillingSku
    :ivar ue_mtu: The MTU (in bytes) signaled to the UE. The same MTU is set on the user plane data
     links for all data networks. The MTU set on the user plane access link is calculated to be 60
     bytes greater than this value to allow for GTP encapsulation.
    :vartype ue_mtu: int
    :ivar local_diagnostics_access: The kubernetes ingress configuration to control access to
     packet core diagnostics over local APIs. Required.
    :vartype local_diagnostics_access:
     ~azure.mgmt.mobilenetwork.models.LocalDiagnosticsAccessConfiguration
    :ivar diagnostics_upload: Configuration for uploading packet core diagnostics.
    :vartype diagnostics_upload: ~azure.mgmt.mobilenetwork.models.DiagnosticsUploadConfiguration
    :ivar event_hub: Configuration for sending packet core events to an Azure Event Hub.
    :vartype event_hub: ~azure.mgmt.mobilenetwork.models.EventHubConfiguration
    :ivar signaling: Signaling configuration for the packet core.
    :vartype signaling: ~azure.mgmt.mobilenetwork.models.SignalingConfiguration
    :ivar interop_settings: Settings to allow interoperability with third party components e.g.
     RANs and UEs.
    :vartype interop_settings: JSON
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "sites": {"required": True, "min_items": 1, "unique": True},
        "platform": {"required": True},
        "installed_version": {"readonly": True},
        "rollback_version": {"readonly": True},
        "control_plane_access_interface": {"required": True},
        "control_plane_access_virtual_ipv4_addresses": {"unique": True},
        "sku": {"required": True},
        "ue_mtu": {"maximum": 1930, "minimum": 1280},
        "local_diagnostics_access": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "installation": {"key": "properties.installation", "type": "Installation"},
        "sites": {"key": "properties.sites", "type": "[SiteResourceId]"},
        "platform": {"key": "properties.platform", "type": "PlatformConfiguration"},
        "core_network_technology": {"key": "properties.coreNetworkTechnology", "type": "str"},
        "version": {"key": "properties.version", "type": "str"},
        "installed_version": {"key": "properties.installedVersion", "type": "str"},
        "rollback_version": {"key": "properties.rollbackVersion", "type": "str"},
        "control_plane_access_interface": {
            "key": "properties.controlPlaneAccessInterface",
            "type": "InterfaceProperties",
        },
        "control_plane_access_virtual_ipv4_addresses": {
            "key": "properties.controlPlaneAccessVirtualIpv4Addresses",
            "type": "[str]",
        },
        "sku": {"key": "properties.sku", "type": "str"},
        "ue_mtu": {"key": "properties.ueMtu", "type": "int"},
        "local_diagnostics_access": {
            "key": "properties.localDiagnosticsAccess",
            "type": "LocalDiagnosticsAccessConfiguration",
        },
        "diagnostics_upload": {"key": "properties.diagnosticsUpload", "type": "DiagnosticsUploadConfiguration"},
        "event_hub": {"key": "properties.eventHub", "type": "EventHubConfiguration"},
        "signaling": {"key": "properties.signaling", "type": "SignalingConfiguration"},
        "interop_settings": {"key": "properties.interopSettings", "type": "object"},
    }

    def __init__(  # pylint: disable=too-many-locals
        self,
        *,
        location: str,
        sites: List["_models.SiteResourceId"],
        platform: "_models.PlatformConfiguration",
        control_plane_access_interface: "_models.InterfaceProperties",
        sku: Union[str, "_models.BillingSku"],
        local_diagnostics_access: "_models.LocalDiagnosticsAccessConfiguration",
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        installation: Optional["_models.Installation"] = None,
        core_network_technology: Union[str, "_models.CoreNetworkType"] = "5GC",
        version: Optional[str] = None,
        control_plane_access_virtual_ipv4_addresses: Optional[List[str]] = None,
        ue_mtu: int = 1440,
        diagnostics_upload: Optional["_models.DiagnosticsUploadConfiguration"] = None,
        event_hub: Optional["_models.EventHubConfiguration"] = None,
        signaling: Optional["_models.SignalingConfiguration"] = None,
        interop_settings: Optional[JSON] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The identity used to retrieve the ingress certificate from Azure key vault.
        :paramtype identity: ~azure.mgmt.mobilenetwork.models.ManagedServiceIdentity
        :keyword installation: The installation state of the packet core control plane resource.
        :paramtype installation: ~azure.mgmt.mobilenetwork.models.Installation
        :keyword sites: Site(s) under which this packet core control plane should be deployed. The
         sites must be in the same location as the packet core control plane. Required.
        :paramtype sites: list[~azure.mgmt.mobilenetwork.models.SiteResourceId]
        :keyword platform: The platform where the packet core is deployed. Required.
        :paramtype platform: ~azure.mgmt.mobilenetwork.models.PlatformConfiguration
        :keyword core_network_technology: The core network technology generation (5G core or EPC / 4G
         core). Known values are: "5GC", "EPC", and "EPC + 5GC".
        :paramtype core_network_technology: str or ~azure.mgmt.mobilenetwork.models.CoreNetworkType
        :keyword version: The desired version of the packet core software.
        :paramtype version: str
        :keyword control_plane_access_interface: The control plane interface on the access network. For
         5G networks, this is the N2 interface. For 4G networks, this is the S1-MME interface. Required.
        :paramtype control_plane_access_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
        :keyword control_plane_access_virtual_ipv4_addresses: The virtual IP address(es) for the
         control plane on the access network in a High Availability (HA) system. In an HA deployment the
         access network router should be configured to anycast traffic for this address to the control
         plane access interfaces on the active and standby nodes. In non-HA system this list should be
         omitted or empty.
        :paramtype control_plane_access_virtual_ipv4_addresses: list[str]
        :keyword sku: The SKU defining the throughput and SIM allowances for this packet core control
         plane deployment. Required. Known values are: "G0", "G1", "G2", "G5", and "G10".
        :paramtype sku: str or ~azure.mgmt.mobilenetwork.models.BillingSku
        :keyword ue_mtu: The MTU (in bytes) signaled to the UE. The same MTU is set on the user plane
         data links for all data networks. The MTU set on the user plane access link is calculated to be
         60 bytes greater than this value to allow for GTP encapsulation.
        :paramtype ue_mtu: int
        :keyword local_diagnostics_access: The kubernetes ingress configuration to control access to
         packet core diagnostics over local APIs. Required.
        :paramtype local_diagnostics_access:
         ~azure.mgmt.mobilenetwork.models.LocalDiagnosticsAccessConfiguration
        :keyword diagnostics_upload: Configuration for uploading packet core diagnostics.
        :paramtype diagnostics_upload: ~azure.mgmt.mobilenetwork.models.DiagnosticsUploadConfiguration
        :keyword event_hub: Configuration for sending packet core events to an Azure Event Hub.
        :paramtype event_hub: ~azure.mgmt.mobilenetwork.models.EventHubConfiguration
        :keyword signaling: Signaling configuration for the packet core.
        :paramtype signaling: ~azure.mgmt.mobilenetwork.models.SignalingConfiguration
        :keyword interop_settings: Settings to allow interoperability with third party components e.g.
         RANs and UEs.
        :paramtype interop_settings: JSON
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.installation = installation
        self.sites = sites
        self.platform = platform
        self.core_network_technology = core_network_technology
        self.version = version
        self.installed_version = None
        self.rollback_version = None
        self.control_plane_access_interface = control_plane_access_interface
        self.control_plane_access_virtual_ipv4_addresses = control_plane_access_virtual_ipv4_addresses
        self.sku = sku
        self.ue_mtu = ue_mtu
        self.local_diagnostics_access = local_diagnostics_access
        self.diagnostics_upload = diagnostics_upload
        self.event_hub = event_hub
        self.signaling = signaling
        self.interop_settings = interop_settings


class PacketCoreControlPlaneCollectDiagnosticsPackage(_serialization.Model):
    """Packet core control plane collect diagnostics package options.

    All required parameters must be populated in order to send to Azure.

    :ivar storage_account_blob_url: The Storage Account Blob URL to upload the diagnostics package
     to. Required.
    :vartype storage_account_blob_url: str
    """

    _validation = {
        "storage_account_blob_url": {"required": True},
    }

    _attribute_map = {
        "storage_account_blob_url": {"key": "storageAccountBlobUrl", "type": "str"},
    }

    def __init__(self, *, storage_account_blob_url: str, **kwargs: Any) -> None:
        """
        :keyword storage_account_blob_url: The Storage Account Blob URL to upload the diagnostics
         package to. Required.
        :paramtype storage_account_blob_url: str
        """
        super().__init__(**kwargs)
        self.storage_account_blob_url = storage_account_blob_url


class PacketCoreControlPlaneListResult(_serialization.Model):
    """Response for packet core control planes API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of packet core control planes in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreControlPlane]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PacketCoreControlPlane]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PacketCoreControlPlane"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of packet core control planes in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreControlPlane]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PacketCoreControlPlaneResourceId(_serialization.Model):
    """Reference to an packet core control plane resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Packet core control plane resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[pP][aA][cC][kK][eE][tT][cC][oO][rR][eE][cC][oO][nN][tT][rR][oO][lL][pP][lL][aA][nN][eE][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Packet core control plane resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class PacketCoreControlPlaneVersion(ProxyResource):
    """Packet core control plane version resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the packet core control plane version
     resource. Known values are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed",
     "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar platforms: Platform specific packet core control plane version properties.
    :vartype platforms: list[~azure.mgmt.mobilenetwork.models.Platform]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "platforms": {"key": "properties.platforms", "type": "[Platform]"},
    }

    def __init__(self, *, platforms: Optional[List["_models.Platform"]] = None, **kwargs: Any) -> None:
        """
        :keyword platforms: Platform specific packet core control plane version properties.
        :paramtype platforms: list[~azure.mgmt.mobilenetwork.models.Platform]
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.platforms = platforms


class PacketCoreControlPlaneVersionListResult(_serialization.Model):
    """Response for packet core control plane version API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of supported packet core control plane versions.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreControlPlaneVersion]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PacketCoreControlPlaneVersion]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PacketCoreControlPlaneVersion"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of supported packet core control plane versions.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreControlPlaneVersion]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PacketCoreDataPlane(TrackedResource):
    """Packet core data plane resource. Must be created in the same location as its parent packet core
    control plane.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the packet core data plane resource. Known
     values are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and
     "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar user_plane_access_interface: The user plane interface on the access network. For 5G
     networks, this is the N3 interface. For 4G networks, this is the S1-U interface. Required.
    :vartype user_plane_access_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
    :ivar user_plane_access_virtual_ipv4_addresses: The virtual IP address(es) for the user plane
     on the access network in a High Availability (HA) system. In an HA deployment the access
     network router should be configured to forward traffic for this address to the control plane
     access interface on the active or standby node. In non-HA system this list should be omitted or
     empty.
    :vartype user_plane_access_virtual_ipv4_addresses: list[str]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "user_plane_access_interface": {"required": True},
        "user_plane_access_virtual_ipv4_addresses": {"unique": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "user_plane_access_interface": {"key": "properties.userPlaneAccessInterface", "type": "InterfaceProperties"},
        "user_plane_access_virtual_ipv4_addresses": {
            "key": "properties.userPlaneAccessVirtualIpv4Addresses",
            "type": "[str]",
        },
    }

    def __init__(
        self,
        *,
        location: str,
        user_plane_access_interface: "_models.InterfaceProperties",
        tags: Optional[Dict[str, str]] = None,
        user_plane_access_virtual_ipv4_addresses: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword user_plane_access_interface: The user plane interface on the access network. For 5G
         networks, this is the N3 interface. For 4G networks, this is the S1-U interface. Required.
        :paramtype user_plane_access_interface: ~azure.mgmt.mobilenetwork.models.InterfaceProperties
        :keyword user_plane_access_virtual_ipv4_addresses: The virtual IP address(es) for the user
         plane on the access network in a High Availability (HA) system. In an HA deployment the access
         network router should be configured to forward traffic for this address to the control plane
         access interface on the active or standby node. In non-HA system this list should be omitted or
         empty.
        :paramtype user_plane_access_virtual_ipv4_addresses: list[str]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.user_plane_access_interface = user_plane_access_interface
        self.user_plane_access_virtual_ipv4_addresses = user_plane_access_virtual_ipv4_addresses


class PacketCoreDataPlaneListResult(_serialization.Model):
    """Response for packet core data planes API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of packet core data planes in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreDataPlane]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[PacketCoreDataPlane]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.PacketCoreDataPlane"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of packet core data planes in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.PacketCoreDataPlane]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class PccRuleConfiguration(_serialization.Model):
    """Data flow policy rule configuration.

    All required parameters must be populated in order to send to Azure.

    :ivar rule_name: The name of the rule. This must be unique within the parent service. You must
     not use any of the following reserved strings - ``default``\ , ``requested`` or ``service``.
     Required.
    :vartype rule_name: str
    :ivar rule_precedence: A precedence value that is used to decide between data flow policy rules
     when identifying the QoS values to use for a particular SIM. A lower value means a higher
     priority. This value should be unique among all data flow policy rules configured in the mobile
     network. Required.
    :vartype rule_precedence: int
    :ivar rule_qos_policy: The QoS policy to use for packets matching this rule. If this field is
     null then the parent service will define the QoS settings.
    :vartype rule_qos_policy: ~azure.mgmt.mobilenetwork.models.PccRuleQosPolicy
    :ivar traffic_control: Determines whether flows that match this data flow policy rule are
     permitted. Known values are: "Enabled" and "Blocked".
    :vartype traffic_control: str or ~azure.mgmt.mobilenetwork.models.TrafficControlPermission
    :ivar service_data_flow_templates: The set of data flow templates to use for this data flow
     policy rule. Required.
    :vartype service_data_flow_templates:
     list[~azure.mgmt.mobilenetwork.models.ServiceDataFlowTemplate]
    """

    _validation = {
        "rule_name": {
            "required": True,
            "max_length": 64,
            "pattern": r"^(?!(default|requested|service)$)[a-zA-Z0-9][a-zA-Z0-9_-]*$",
        },
        "rule_precedence": {"required": True, "maximum": 255, "minimum": 0},
        "service_data_flow_templates": {"required": True, "max_items": 15, "min_items": 1, "unique": True},
    }

    _attribute_map = {
        "rule_name": {"key": "ruleName", "type": "str"},
        "rule_precedence": {"key": "rulePrecedence", "type": "int"},
        "rule_qos_policy": {"key": "ruleQosPolicy", "type": "PccRuleQosPolicy"},
        "traffic_control": {"key": "trafficControl", "type": "str"},
        "service_data_flow_templates": {"key": "serviceDataFlowTemplates", "type": "[ServiceDataFlowTemplate]"},
    }

    def __init__(
        self,
        *,
        rule_name: str,
        rule_precedence: int,
        service_data_flow_templates: List["_models.ServiceDataFlowTemplate"],
        rule_qos_policy: Optional["_models.PccRuleQosPolicy"] = None,
        traffic_control: Optional[Union[str, "_models.TrafficControlPermission"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rule_name: The name of the rule. This must be unique within the parent service. You
         must not use any of the following reserved strings - ``default``\ , ``requested`` or
         ``service``. Required.
        :paramtype rule_name: str
        :keyword rule_precedence: A precedence value that is used to decide between data flow policy
         rules when identifying the QoS values to use for a particular SIM. A lower value means a higher
         priority. This value should be unique among all data flow policy rules configured in the mobile
         network. Required.
        :paramtype rule_precedence: int
        :keyword rule_qos_policy: The QoS policy to use for packets matching this rule. If this field
         is null then the parent service will define the QoS settings.
        :paramtype rule_qos_policy: ~azure.mgmt.mobilenetwork.models.PccRuleQosPolicy
        :keyword traffic_control: Determines whether flows that match this data flow policy rule are
         permitted. Known values are: "Enabled" and "Blocked".
        :paramtype traffic_control: str or ~azure.mgmt.mobilenetwork.models.TrafficControlPermission
        :keyword service_data_flow_templates: The set of data flow templates to use for this data flow
         policy rule. Required.
        :paramtype service_data_flow_templates:
         list[~azure.mgmt.mobilenetwork.models.ServiceDataFlowTemplate]
        """
        super().__init__(**kwargs)
        self.rule_name = rule_name
        self.rule_precedence = rule_precedence
        self.rule_qos_policy = rule_qos_policy
        self.traffic_control = traffic_control
        self.service_data_flow_templates = service_data_flow_templates


class QosPolicy(_serialization.Model):
    """QoS policy.

    All required parameters must be populated in order to send to Azure.

    :ivar five_qi: 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding
     treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of
     the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
    :vartype five_qi: int
    :ivar allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP)
     level. Flows with higher priority preempt flows with lower priority, if the settings of
     ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest level of
     priority. If this field is not specified then ``5qi`` is used to derive the ARP value. See 3GPP
     TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
    :vartype allocation_and_retention_priority_level: int
    :ivar preemption_capability: QoS Flow preemption capability. The preemption capability of a QoS
     Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP
     TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Known values are:
     "NotPreempt" and "MayPreempt".
    :vartype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
    :ivar preemption_vulnerability: QoS Flow preemption vulnerability. The preemption vulnerability
     of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level.
     See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Known values
     are: "NotPreemptable" and "Preemptable".
    :vartype preemption_vulnerability: str or
     ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
    :ivar maximum_bit_rate: The maximum bit rate (MBR) for all service data flows that use this
     data flow policy rule or service. Required.
    :vartype maximum_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
    """

    _validation = {
        "five_qi": {"maximum": 127, "minimum": 1},
        "allocation_and_retention_priority_level": {"maximum": 15, "minimum": 1},
        "maximum_bit_rate": {"required": True},
    }

    _attribute_map = {
        "five_qi": {"key": "5qi", "type": "int"},
        "allocation_and_retention_priority_level": {"key": "allocationAndRetentionPriorityLevel", "type": "int"},
        "preemption_capability": {"key": "preemptionCapability", "type": "str"},
        "preemption_vulnerability": {"key": "preemptionVulnerability", "type": "str"},
        "maximum_bit_rate": {"key": "maximumBitRate", "type": "Ambr"},
    }

    def __init__(
        self,
        *,
        maximum_bit_rate: "_models.Ambr",
        five_qi: Optional[int] = None,
        allocation_and_retention_priority_level: Optional[int] = None,
        preemption_capability: Optional[Union[str, "_models.PreemptionCapability"]] = None,
        preemption_vulnerability: Optional[Union[str, "_models.PreemptionVulnerability"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword five_qi: 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding
         treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of
         the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
        :paramtype five_qi: int
        :keyword allocation_and_retention_priority_level: QoS Flow allocation and retention priority
         (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of
         ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest level of
         priority. If this field is not specified then ``5qi`` is used to derive the ARP value. See 3GPP
         TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :paramtype allocation_and_retention_priority_level: int
        :keyword preemption_capability: QoS Flow preemption capability. The preemption capability of a
         QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP
         TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Known values are:
         "NotPreempt" and "MayPreempt".
        :paramtype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
        :keyword preemption_vulnerability: QoS Flow preemption vulnerability. The preemption
         vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher
         priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
         Known values are: "NotPreemptable" and "Preemptable".
        :paramtype preemption_vulnerability: str or
         ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
        :keyword maximum_bit_rate: The maximum bit rate (MBR) for all service data flows that use this
         data flow policy rule or service. Required.
        :paramtype maximum_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
        """
        super().__init__(**kwargs)
        self.five_qi = five_qi
        self.allocation_and_retention_priority_level = allocation_and_retention_priority_level
        self.preemption_capability = preemption_capability
        self.preemption_vulnerability = preemption_vulnerability
        self.maximum_bit_rate = maximum_bit_rate


class PccRuleQosPolicy(QosPolicy):
    """Data flow policy rule QoS policy.

    All required parameters must be populated in order to send to Azure.

    :ivar five_qi: 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding
     treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of
     the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
    :vartype five_qi: int
    :ivar allocation_and_retention_priority_level: QoS Flow allocation and retention priority (ARP)
     level. Flows with higher priority preempt flows with lower priority, if the settings of
     ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest level of
     priority. If this field is not specified then ``5qi`` is used to derive the ARP value. See 3GPP
     TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
    :vartype allocation_and_retention_priority_level: int
    :ivar preemption_capability: QoS Flow preemption capability. The preemption capability of a QoS
     Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP
     TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Known values are:
     "NotPreempt" and "MayPreempt".
    :vartype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
    :ivar preemption_vulnerability: QoS Flow preemption vulnerability. The preemption vulnerability
     of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher priority level.
     See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Known values
     are: "NotPreemptable" and "Preemptable".
    :vartype preemption_vulnerability: str or
     ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
    :ivar maximum_bit_rate: The maximum bit rate (MBR) for all service data flows that use this
     data flow policy rule or service. Required.
    :vartype maximum_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
    :ivar guaranteed_bit_rate: The guaranteed bit rate (GBR) for all service data flows that use
     this data flow policy rule. This is an optional setting. If you do not provide a value, there
     will be no GBR set for the data flow policy rule that uses this QoS definition.
    :vartype guaranteed_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
    """

    _validation = {
        "five_qi": {"maximum": 127, "minimum": 1},
        "allocation_and_retention_priority_level": {"maximum": 15, "minimum": 1},
        "maximum_bit_rate": {"required": True},
    }

    _attribute_map = {
        "five_qi": {"key": "5qi", "type": "int"},
        "allocation_and_retention_priority_level": {"key": "allocationAndRetentionPriorityLevel", "type": "int"},
        "preemption_capability": {"key": "preemptionCapability", "type": "str"},
        "preemption_vulnerability": {"key": "preemptionVulnerability", "type": "str"},
        "maximum_bit_rate": {"key": "maximumBitRate", "type": "Ambr"},
        "guaranteed_bit_rate": {"key": "guaranteedBitRate", "type": "Ambr"},
    }

    def __init__(
        self,
        *,
        maximum_bit_rate: "_models.Ambr",
        five_qi: Optional[int] = None,
        allocation_and_retention_priority_level: Optional[int] = None,
        preemption_capability: Optional[Union[str, "_models.PreemptionCapability"]] = None,
        preemption_vulnerability: Optional[Union[str, "_models.PreemptionVulnerability"]] = None,
        guaranteed_bit_rate: Optional["_models.Ambr"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword five_qi: 5G QoS Flow Indicator value. The 5QI identifies a specific QoS forwarding
         treatment to be provided to a flow. See 3GPP TS23.501 section 5.7.2.1 for a full description of
         the 5QI parameter, and table 5.7.4-1 for the definition the 5QI values.
        :paramtype five_qi: int
        :keyword allocation_and_retention_priority_level: QoS Flow allocation and retention priority
         (ARP) level. Flows with higher priority preempt flows with lower priority, if the settings of
         ``preemptionCapability`` and ``preemptionVulnerability`` allow it. 1 is the highest level of
         priority. If this field is not specified then ``5qi`` is used to derive the ARP value. See 3GPP
         TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
        :paramtype allocation_and_retention_priority_level: int
        :keyword preemption_capability: QoS Flow preemption capability. The preemption capability of a
         QoS Flow controls whether it can preempt another QoS Flow with a lower priority level. See 3GPP
         TS23.501 section 5.7.2.2 for a full description of the ARP parameters. Known values are:
         "NotPreempt" and "MayPreempt".
        :paramtype preemption_capability: str or ~azure.mgmt.mobilenetwork.models.PreemptionCapability
        :keyword preemption_vulnerability: QoS Flow preemption vulnerability. The preemption
         vulnerability of a QoS Flow controls whether it can be preempted by a QoS Flow with a higher
         priority level. See 3GPP TS23.501 section 5.7.2.2 for a full description of the ARP parameters.
         Known values are: "NotPreemptable" and "Preemptable".
        :paramtype preemption_vulnerability: str or
         ~azure.mgmt.mobilenetwork.models.PreemptionVulnerability
        :keyword maximum_bit_rate: The maximum bit rate (MBR) for all service data flows that use this
         data flow policy rule or service. Required.
        :paramtype maximum_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
        :keyword guaranteed_bit_rate: The guaranteed bit rate (GBR) for all service data flows that use
         this data flow policy rule. This is an optional setting. If you do not provide a value, there
         will be no GBR set for the data flow policy rule that uses this QoS definition.
        :paramtype guaranteed_bit_rate: ~azure.mgmt.mobilenetwork.models.Ambr
        """
        super().__init__(
            five_qi=five_qi,
            allocation_and_retention_priority_level=allocation_and_retention_priority_level,
            preemption_capability=preemption_capability,
            preemption_vulnerability=preemption_vulnerability,
            maximum_bit_rate=maximum_bit_rate,
            **kwargs
        )
        self.guaranteed_bit_rate = guaranteed_bit_rate


class PinholeTimeouts(_serialization.Model):
    """Expiry times of inactive NAPT pinholes, in seconds. All timers must be at least 1 second.

    :ivar tcp: Pinhole timeout for TCP pinholes in seconds. Default for TCP is 3 minutes.
    :vartype tcp: int
    :ivar udp: Pinhole timeout for UDP pinholes in seconds. Default for UDP is 30 seconds.
    :vartype udp: int
    :ivar icmp: Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 30 seconds.
    :vartype icmp: int
    """

    _validation = {
        "tcp": {"minimum": 1},
        "udp": {"minimum": 1},
        "icmp": {"minimum": 1},
    }

    _attribute_map = {
        "tcp": {"key": "tcp", "type": "int"},
        "udp": {"key": "udp", "type": "int"},
        "icmp": {"key": "icmp", "type": "int"},
    }

    def __init__(self, *, tcp: int = 180, udp: int = 30, icmp: int = 30, **kwargs: Any) -> None:
        """
        :keyword tcp: Pinhole timeout for TCP pinholes in seconds. Default for TCP is 3 minutes.
        :paramtype tcp: int
        :keyword udp: Pinhole timeout for UDP pinholes in seconds. Default for UDP is 30 seconds.
        :paramtype udp: int
        :keyword icmp: Pinhole timeout for ICMP pinholes in seconds. Default for ICMP Echo is 30
         seconds.
        :paramtype icmp: int
        """
        super().__init__(**kwargs)
        self.tcp = tcp
        self.udp = udp
        self.icmp = icmp


class Platform(_serialization.Model):
    """Platform specific packet core control plane version properties.

    :ivar platform_type: The platform type where this version can be deployed. Known values are:
     "AKS-HCI" and "3P-AZURE-STACK-HCI".
    :vartype platform_type: str or ~azure.mgmt.mobilenetwork.models.PlatformType
    :ivar version_state: The state of this packet core control plane version on this platform.
     Known values are: "Unknown", "Preview", "Validating", "ValidationFailed", "Active", and
     "Deprecated".
    :vartype version_state: str or ~azure.mgmt.mobilenetwork.models.VersionState
    :ivar minimum_platform_software_version: The minimum software version of the platform where
     this packet core version can be deployed.
    :vartype minimum_platform_software_version: str
    :ivar maximum_platform_software_version: The maximum software version of the platform where
     this packet core version can be deployed.
    :vartype maximum_platform_software_version: str
    :ivar recommended_version: Indicates whether this is the recommended version for this platform.
     Known values are: "Recommended" and "NotRecommended".
    :vartype recommended_version: str or ~azure.mgmt.mobilenetwork.models.RecommendedVersion
    :ivar obsolete_version: Indicates whether this version is obsoleted for this platform. Known
     values are: "Obsolete" and "NotObsolete".
    :vartype obsolete_version: str or ~azure.mgmt.mobilenetwork.models.ObsoleteVersion
    """

    _attribute_map = {
        "platform_type": {"key": "platformType", "type": "str"},
        "version_state": {"key": "versionState", "type": "str"},
        "minimum_platform_software_version": {"key": "minimumPlatformSoftwareVersion", "type": "str"},
        "maximum_platform_software_version": {"key": "maximumPlatformSoftwareVersion", "type": "str"},
        "recommended_version": {"key": "recommendedVersion", "type": "str"},
        "obsolete_version": {"key": "obsoleteVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        platform_type: Optional[Union[str, "_models.PlatformType"]] = None,
        version_state: Optional[Union[str, "_models.VersionState"]] = None,
        minimum_platform_software_version: Optional[str] = None,
        maximum_platform_software_version: Optional[str] = None,
        recommended_version: Optional[Union[str, "_models.RecommendedVersion"]] = None,
        obsolete_version: Optional[Union[str, "_models.ObsoleteVersion"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword platform_type: The platform type where this version can be deployed. Known values are:
         "AKS-HCI" and "3P-AZURE-STACK-HCI".
        :paramtype platform_type: str or ~azure.mgmt.mobilenetwork.models.PlatformType
        :keyword version_state: The state of this packet core control plane version on this platform.
         Known values are: "Unknown", "Preview", "Validating", "ValidationFailed", "Active", and
         "Deprecated".
        :paramtype version_state: str or ~azure.mgmt.mobilenetwork.models.VersionState
        :keyword minimum_platform_software_version: The minimum software version of the platform where
         this packet core version can be deployed.
        :paramtype minimum_platform_software_version: str
        :keyword maximum_platform_software_version: The maximum software version of the platform where
         this packet core version can be deployed.
        :paramtype maximum_platform_software_version: str
        :keyword recommended_version: Indicates whether this is the recommended version for this
         platform. Known values are: "Recommended" and "NotRecommended".
        :paramtype recommended_version: str or ~azure.mgmt.mobilenetwork.models.RecommendedVersion
        :keyword obsolete_version: Indicates whether this version is obsoleted for this platform. Known
         values are: "Obsolete" and "NotObsolete".
        :paramtype obsolete_version: str or ~azure.mgmt.mobilenetwork.models.ObsoleteVersion
        """
        super().__init__(**kwargs)
        self.platform_type = platform_type
        self.version_state = version_state
        self.minimum_platform_software_version = minimum_platform_software_version
        self.maximum_platform_software_version = maximum_platform_software_version
        self.recommended_version = recommended_version
        self.obsolete_version = obsolete_version


class PlatformConfiguration(_serialization.Model):
    """The platform where the packet core is deployed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: The platform type where packet core is deployed. Required. Known values are:
     "AKS-HCI" and "3P-AZURE-STACK-HCI".
    :vartype type: str or ~azure.mgmt.mobilenetwork.models.PlatformType
    :ivar azure_stack_edge_device: The Azure Stack Edge device where the packet core is deployed.
     If the device is part of a fault tolerant pair, either device in the pair can be specified.
    :vartype azure_stack_edge_device:
     ~azure.mgmt.mobilenetwork.models.AzureStackEdgeDeviceResourceId
    :ivar azure_stack_edge_devices: The Azure Stack Edge devices where the packet core is deployed.
     If the packet core is deployed across multiple devices, all devices will appear in this list.
    :vartype azure_stack_edge_devices:
     list[~azure.mgmt.mobilenetwork.models.AzureStackEdgeDeviceResourceId]
    :ivar azure_stack_hci_cluster: The Azure Stack HCI cluster where the packet core is deployed.
    :vartype azure_stack_hci_cluster:
     ~azure.mgmt.mobilenetwork.models.AzureStackHCIClusterResourceId
    :ivar connected_cluster: Azure Arc connected cluster where the packet core is deployed.
    :vartype connected_cluster: ~azure.mgmt.mobilenetwork.models.ConnectedClusterResourceId
    :ivar custom_location: Azure Arc custom location where the packet core is deployed.
    :vartype custom_location: ~azure.mgmt.mobilenetwork.models.CustomLocationResourceId
    """

    _validation = {
        "type": {"required": True},
        "azure_stack_edge_devices": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "azure_stack_edge_device": {"key": "azureStackEdgeDevice", "type": "AzureStackEdgeDeviceResourceId"},
        "azure_stack_edge_devices": {"key": "azureStackEdgeDevices", "type": "[AzureStackEdgeDeviceResourceId]"},
        "azure_stack_hci_cluster": {"key": "azureStackHciCluster", "type": "AzureStackHCIClusterResourceId"},
        "connected_cluster": {"key": "connectedCluster", "type": "ConnectedClusterResourceId"},
        "custom_location": {"key": "customLocation", "type": "CustomLocationResourceId"},
    }

    def __init__(
        self,
        *,
        type: Union[str, "_models.PlatformType"],
        azure_stack_edge_device: Optional["_models.AzureStackEdgeDeviceResourceId"] = None,
        azure_stack_hci_cluster: Optional["_models.AzureStackHCIClusterResourceId"] = None,
        connected_cluster: Optional["_models.ConnectedClusterResourceId"] = None,
        custom_location: Optional["_models.CustomLocationResourceId"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword type: The platform type where packet core is deployed. Required. Known values are:
         "AKS-HCI" and "3P-AZURE-STACK-HCI".
        :paramtype type: str or ~azure.mgmt.mobilenetwork.models.PlatformType
        :keyword azure_stack_edge_device: The Azure Stack Edge device where the packet core is
         deployed. If the device is part of a fault tolerant pair, either device in the pair can be
         specified.
        :paramtype azure_stack_edge_device:
         ~azure.mgmt.mobilenetwork.models.AzureStackEdgeDeviceResourceId
        :keyword azure_stack_hci_cluster: The Azure Stack HCI cluster where the packet core is
         deployed.
        :paramtype azure_stack_hci_cluster:
         ~azure.mgmt.mobilenetwork.models.AzureStackHCIClusterResourceId
        :keyword connected_cluster: Azure Arc connected cluster where the packet core is deployed.
        :paramtype connected_cluster: ~azure.mgmt.mobilenetwork.models.ConnectedClusterResourceId
        :keyword custom_location: Azure Arc custom location where the packet core is deployed.
        :paramtype custom_location: ~azure.mgmt.mobilenetwork.models.CustomLocationResourceId
        """
        super().__init__(**kwargs)
        self.type = type
        self.azure_stack_edge_device = azure_stack_edge_device
        self.azure_stack_edge_devices = None
        self.azure_stack_hci_cluster = azure_stack_hci_cluster
        self.connected_cluster = connected_cluster
        self.custom_location = custom_location


class PlmnId(_serialization.Model):
    """Public land mobile network (PLMN) ID.

    All required parameters must be populated in order to send to Azure.

    :ivar mcc: Mobile country code (MCC). Required.
    :vartype mcc: str
    :ivar mnc: Mobile network code (MNC). Required.
    :vartype mnc: str
    """

    _validation = {
        "mcc": {"required": True, "pattern": r"^\d{3}$"},
        "mnc": {"required": True, "pattern": r"^\d{2,3}$"},
    }

    _attribute_map = {
        "mcc": {"key": "mcc", "type": "str"},
        "mnc": {"key": "mnc", "type": "str"},
    }

    def __init__(self, *, mcc: str, mnc: str, **kwargs: Any) -> None:
        """
        :keyword mcc: Mobile country code (MCC). Required.
        :paramtype mcc: str
        :keyword mnc: Mobile network code (MNC). Required.
        :paramtype mnc: str
        """
        super().__init__(**kwargs)
        self.mcc = mcc
        self.mnc = mnc


class PortRange(_serialization.Model):
    """Range of port numbers to use as translated ports on each translated address.
    If not specified and NAPT is enabled, this range defaults to 1,024 - 49,999.
    (Ports under 1,024 should not be used because these are special purpose ports reserved by IANA.
    Ports 50,000 and above are reserved for non-NAPT use.).

    :ivar min_port: The minimum port number.
    :vartype min_port: int
    :ivar max_port: The maximum port number.
    :vartype max_port: int
    """

    _validation = {
        "min_port": {"maximum": 65535, "minimum": 1024},
        "max_port": {"maximum": 65535, "minimum": 1024},
    }

    _attribute_map = {
        "min_port": {"key": "minPort", "type": "int"},
        "max_port": {"key": "maxPort", "type": "int"},
    }

    def __init__(self, *, min_port: int = 1024, max_port: int = 49999, **kwargs: Any) -> None:
        """
        :keyword min_port: The minimum port number.
        :paramtype min_port: int
        :keyword max_port: The maximum port number.
        :paramtype max_port: int
        """
        super().__init__(**kwargs)
        self.min_port = min_port
        self.max_port = max_port


class PortReuseHoldTimes(_serialization.Model):
    """The minimum time (in seconds) that will pass before a port that was used by a closed pinhole
    can be recycled for use by another pinhole. All hold times must be minimum 1 second.

    :ivar tcp: Minimum time in seconds that will pass before a TCP port that was used by a closed
     pinhole can be reused. Default for TCP is 2 minutes.
    :vartype tcp: int
    :ivar udp: Minimum time in seconds that will pass before a UDP port that was used by a closed
     pinhole can be reused. Default for UDP is 1 minute.
    :vartype udp: int
    """

    _validation = {
        "tcp": {"minimum": 1},
        "udp": {"minimum": 1},
    }

    _attribute_map = {
        "tcp": {"key": "tcp", "type": "int"},
        "udp": {"key": "udp", "type": "int"},
    }

    def __init__(self, *, tcp: int = 120, udp: int = 60, **kwargs: Any) -> None:
        """
        :keyword tcp: Minimum time in seconds that will pass before a TCP port that was used by a
         closed pinhole can be reused. Default for TCP is 2 minutes.
        :paramtype tcp: int
        :keyword udp: Minimum time in seconds that will pass before a UDP port that was used by a
         closed pinhole can be reused. Default for UDP is 1 minute.
        :paramtype udp: int
        """
        super().__init__(**kwargs)
        self.tcp = tcp
        self.udp = udp


class Service(TrackedResource):
    """Service resource. Must be created in the same location as its parent mobile network.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the service resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar service_precedence: A precedence value that is used to decide between services when
     identifying the QoS values to use for a particular SIM. A lower value means a higher priority.
     This value should be unique among all services configured in the mobile network. Required.
    :vartype service_precedence: int
    :ivar service_qos_policy: The QoS policy to use for packets matching this service. This can be
     overridden for particular flows using the ruleQosPolicy field in a PccRuleConfiguration. If
     this field is null then the UE's SIM policy will define the QoS settings.
    :vartype service_qos_policy: ~azure.mgmt.mobilenetwork.models.QosPolicy
    :ivar pcc_rules: The set of data flow policy rules that make up this service. Required.
    :vartype pcc_rules: list[~azure.mgmt.mobilenetwork.models.PccRuleConfiguration]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "service_precedence": {"required": True, "maximum": 255, "minimum": 0},
        "pcc_rules": {"required": True, "min_items": 1, "unique": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "service_precedence": {"key": "properties.servicePrecedence", "type": "int"},
        "service_qos_policy": {"key": "properties.serviceQosPolicy", "type": "QosPolicy"},
        "pcc_rules": {"key": "properties.pccRules", "type": "[PccRuleConfiguration]"},
    }

    def __init__(
        self,
        *,
        location: str,
        service_precedence: int,
        pcc_rules: List["_models.PccRuleConfiguration"],
        tags: Optional[Dict[str, str]] = None,
        service_qos_policy: Optional["_models.QosPolicy"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword service_precedence: A precedence value that is used to decide between services when
         identifying the QoS values to use for a particular SIM. A lower value means a higher priority.
         This value should be unique among all services configured in the mobile network. Required.
        :paramtype service_precedence: int
        :keyword service_qos_policy: The QoS policy to use for packets matching this service. This can
         be overridden for particular flows using the ruleQosPolicy field in a PccRuleConfiguration. If
         this field is null then the UE's SIM policy will define the QoS settings.
        :paramtype service_qos_policy: ~azure.mgmt.mobilenetwork.models.QosPolicy
        :keyword pcc_rules: The set of data flow policy rules that make up this service. Required.
        :paramtype pcc_rules: list[~azure.mgmt.mobilenetwork.models.PccRuleConfiguration]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.service_precedence = service_precedence
        self.service_qos_policy = service_qos_policy
        self.pcc_rules = pcc_rules


class ServiceDataFlowTemplate(_serialization.Model):
    """Data flow template.

    All required parameters must be populated in order to send to Azure.

    :ivar template_name: The name of the data flow template. This must be unique within the parent
     data flow policy rule. You must not use any of the following reserved strings - ``default``\ ,
     ``requested`` or ``service``. Required.
    :vartype template_name: str
    :ivar direction: The direction of this flow. Required. Known values are: "Uplink", "Downlink",
     and "Bidirectional".
    :vartype direction: str or ~azure.mgmt.mobilenetwork.models.SdfDirection
    :ivar protocol: A list of the allowed protocol(s) for this flow. If you want this flow to be
     able to use any protocol within the internet protocol suite, use the value ``ip``. If you only
     want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet
     Protocol Number for each protocol, as described in
     https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP,
     you must use 17. If you use the value ``ip`` then you must leave the field ``port``
     unspecified. Required.
    :vartype protocol: list[str]
    :ivar remote_ip_list: The remote IP address(es) to which UEs will connect for this flow. If you
     want to allow connections on any IP address, use the value ``any``. Otherwise, you must provide
     each of the remote IP addresses to which the packet core instance will connect for this flow.
     You must provide each IP address in CIDR notation, including the netmask (for example,
     192.0.2.54/24). Required.
    :vartype remote_ip_list: list[str]
    :ivar ports: The port(s) to which UEs will connect for this flow. You can specify zero or more
     ports or port ranges. If you specify one or more ports or port ranges then you must specify a
     value other than ``ip`` in the ``protocol`` field. This is an optional setting. If you do not
     specify it then connections will be allowed on all ports. Port ranges must be specified as
     :code:`<FirstPort>`-:code:`<LastPort>`. For example: [\ ``8080``\ , ``8082-8085``\ ].
    :vartype ports: list[str]
    """

    _validation = {
        "template_name": {
            "required": True,
            "max_length": 64,
            "pattern": r"^(?!(default|requested|service)$)[a-zA-Z0-9][a-zA-Z0-9_-]*$",
        },
        "direction": {"required": True},
        "protocol": {"required": True, "min_items": 1, "unique": True},
        "remote_ip_list": {"required": True, "min_items": 1, "unique": True},
        "ports": {"unique": True},
    }

    _attribute_map = {
        "template_name": {"key": "templateName", "type": "str"},
        "direction": {"key": "direction", "type": "str"},
        "protocol": {"key": "protocol", "type": "[str]"},
        "remote_ip_list": {"key": "remoteIpList", "type": "[str]"},
        "ports": {"key": "ports", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        template_name: str,
        direction: Union[str, "_models.SdfDirection"],
        protocol: List[str],
        remote_ip_list: List[str],
        ports: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword template_name: The name of the data flow template. This must be unique within the
         parent data flow policy rule. You must not use any of the following reserved strings -
         ``default``\ , ``requested`` or ``service``. Required.
        :paramtype template_name: str
        :keyword direction: The direction of this flow. Required. Known values are: "Uplink",
         "Downlink", and "Bidirectional".
        :paramtype direction: str or ~azure.mgmt.mobilenetwork.models.SdfDirection
        :keyword protocol: A list of the allowed protocol(s) for this flow. If you want this flow to be
         able to use any protocol within the internet protocol suite, use the value ``ip``. If you only
         want to allow a selection of protocols, you must use the corresponding IANA Assigned Internet
         Protocol Number for each protocol, as described in
         https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml. For example, for UDP,
         you must use 17. If you use the value ``ip`` then you must leave the field ``port``
         unspecified. Required.
        :paramtype protocol: list[str]
        :keyword remote_ip_list: The remote IP address(es) to which UEs will connect for this flow. If
         you want to allow connections on any IP address, use the value ``any``. Otherwise, you must
         provide each of the remote IP addresses to which the packet core instance will connect for this
         flow. You must provide each IP address in CIDR notation, including the netmask (for example,
         192.0.2.54/24). Required.
        :paramtype remote_ip_list: list[str]
        :keyword ports: The port(s) to which UEs will connect for this flow. You can specify zero or
         more ports or port ranges. If you specify one or more ports or port ranges then you must
         specify a value other than ``ip`` in the ``protocol`` field. This is an optional setting. If
         you do not specify it then connections will be allowed on all ports. Port ranges must be
         specified as :code:`<FirstPort>`-:code:`<LastPort>`. For example: [\ ``8080``\ , ``8082-8085``\
         ].
        :paramtype ports: list[str]
        """
        super().__init__(**kwargs)
        self.template_name = template_name
        self.direction = direction
        self.protocol = protocol
        self.remote_ip_list = remote_ip_list
        self.ports = ports


class ServiceListResult(_serialization.Model):
    """Response for services API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of services.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Service]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Service]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Service"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of services.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.Service]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class ServiceResourceId(_serialization.Model):
    """Reference to a service resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Service resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+/[sS][eE][rR][vV][iI][cC][eE][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Service resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SignalingConfiguration(_serialization.Model):
    """Signaling configuration for the packet core.

    :ivar nas_reroute: Configuration enabling 4G NAS reroute.
    :vartype nas_reroute: ~azure.mgmt.mobilenetwork.models.NASRerouteConfiguration
    """

    _attribute_map = {
        "nas_reroute": {"key": "nasReroute", "type": "NASRerouteConfiguration"},
    }

    def __init__(self, *, nas_reroute: Optional["_models.NASRerouteConfiguration"] = None, **kwargs: Any) -> None:
        """
        :keyword nas_reroute: Configuration enabling 4G NAS reroute.
        :paramtype nas_reroute: ~azure.mgmt.mobilenetwork.models.NASRerouteConfiguration
        """
        super().__init__(**kwargs)
        self.nas_reroute = nas_reroute


class Sim(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """SIM resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar provisioning_state: The provisioning state of the SIM resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar sim_state: The state of the SIM resource. Known values are: "Disabled", "Enabled", and
     "Invalid".
    :vartype sim_state: str or ~azure.mgmt.mobilenetwork.models.SimState
    :ivar site_provisioning_state: A dictionary of sites to the provisioning state of this SIM on
     that site.
    :vartype site_provisioning_state: dict[str, str or
     ~azure.mgmt.mobilenetwork.models.SiteProvisioningState]
    :ivar international_mobile_subscriber_identity: The international mobile subscriber identity
     (IMSI) for the SIM. Required.
    :vartype international_mobile_subscriber_identity: str
    :ivar integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the SIM.
    :vartype integrated_circuit_card_identifier: str
    :ivar device_type: An optional free-form text field that can be used to record the device type
     this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be
     grouped and filtered based on this value.
    :vartype device_type: str
    :ivar sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same location
     as the SIM.
    :vartype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
    :ivar static_ip_configuration: A list of static IP addresses assigned to this SIM. Each address
     is assigned at a defined network scope, made up of {attached data network, slice}.
    :vartype static_ip_configuration: list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
    :ivar vendor_name: The name of the SIM vendor who provided this SIM, if any.
    :vartype vendor_name: str
    :ivar vendor_key_fingerprint: The public key fingerprint of the SIM vendor who provided this
     SIM, if any.
    :vartype vendor_key_fingerprint: str
    :ivar authentication_key: The Ki value for the SIM.
    :vartype authentication_key: str
    :ivar operator_key_code: The Opc value for the SIM.
    :vartype operator_key_code: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "sim_state": {"readonly": True},
        "site_provisioning_state": {"readonly": True},
        "international_mobile_subscriber_identity": {"required": True, "pattern": r"^[0-9]{5,15}$"},
        "integrated_circuit_card_identifier": {"pattern": r"^[0-9]{10,20}$"},
        "static_ip_configuration": {"min_items": 1, "unique": True},
        "vendor_name": {"readonly": True},
        "vendor_key_fingerprint": {"readonly": True},
        "authentication_key": {"pattern": r"^[0-9a-fA-F]{32}$"},
        "operator_key_code": {"pattern": r"^[0-9a-fA-F]{32}$"},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sim_state": {"key": "properties.simState", "type": "str"},
        "site_provisioning_state": {"key": "properties.siteProvisioningState", "type": "{str}"},
        "international_mobile_subscriber_identity": {
            "key": "properties.internationalMobileSubscriberIdentity",
            "type": "str",
        },
        "integrated_circuit_card_identifier": {"key": "properties.integratedCircuitCardIdentifier", "type": "str"},
        "device_type": {"key": "properties.deviceType", "type": "str"},
        "sim_policy": {"key": "properties.simPolicy", "type": "SimPolicyResourceId"},
        "static_ip_configuration": {"key": "properties.staticIpConfiguration", "type": "[SimStaticIpProperties]"},
        "vendor_name": {"key": "properties.vendorName", "type": "str"},
        "vendor_key_fingerprint": {"key": "properties.vendorKeyFingerprint", "type": "str"},
        "authentication_key": {"key": "properties.authenticationKey", "type": "str"},
        "operator_key_code": {"key": "properties.operatorKeyCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        international_mobile_subscriber_identity: str,
        integrated_circuit_card_identifier: Optional[str] = None,
        device_type: Optional[str] = None,
        sim_policy: Optional["_models.SimPolicyResourceId"] = None,
        static_ip_configuration: Optional[List["_models.SimStaticIpProperties"]] = None,
        authentication_key: Optional[str] = None,
        operator_key_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword international_mobile_subscriber_identity: The international mobile subscriber identity
         (IMSI) for the SIM. Required.
        :paramtype international_mobile_subscriber_identity: str
        :keyword integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the
         SIM.
        :paramtype integrated_circuit_card_identifier: str
        :keyword device_type: An optional free-form text field that can be used to record the device
         type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to
         be grouped and filtered based on this value.
        :paramtype device_type: str
        :keyword sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same
         location as the SIM.
        :paramtype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
        :keyword static_ip_configuration: A list of static IP addresses assigned to this SIM. Each
         address is assigned at a defined network scope, made up of {attached data network, slice}.
        :paramtype static_ip_configuration:
         list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
        :keyword authentication_key: The Ki value for the SIM.
        :paramtype authentication_key: str
        :keyword operator_key_code: The Opc value for the SIM.
        :paramtype operator_key_code: str
        """
        super().__init__(**kwargs)
        self.provisioning_state = None
        self.sim_state = None
        self.site_provisioning_state = None
        self.international_mobile_subscriber_identity = international_mobile_subscriber_identity
        self.integrated_circuit_card_identifier = integrated_circuit_card_identifier
        self.device_type = device_type
        self.sim_policy = sim_policy
        self.static_ip_configuration = static_ip_configuration
        self.vendor_name = None
        self.vendor_key_fingerprint = None
        self.authentication_key = authentication_key
        self.operator_key_code = operator_key_code


class SimDeleteList(_serialization.Model):
    """The SIMs to delete.

    All required parameters must be populated in order to send to Azure.

    :ivar sims: A list of SIM resource names to delete. Required.
    :vartype sims: list[str]
    """

    _validation = {
        "sims": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "sims": {"key": "sims", "type": "[str]"},
    }

    def __init__(self, *, sims: List[str], **kwargs: Any) -> None:
        """
        :keyword sims: A list of SIM resource names to delete. Required.
        :paramtype sims: list[str]
        """
        super().__init__(**kwargs)
        self.sims = sims


class SimGroup(TrackedResource):
    """SIM group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar identity: The identity used to retrieve the encryption key from Azure key vault.
    :vartype identity: ~azure.mgmt.mobilenetwork.models.ManagedServiceIdentity
    :ivar provisioning_state: The provisioning state of the SIM group resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar encryption_key: A key to encrypt the SIM data that belongs to this SIM group.
    :vartype encryption_key: ~azure.mgmt.mobilenetwork.models.KeyVaultKey
    :ivar mobile_network: Mobile network that this SIM group belongs to. The mobile network must be
     in the same location as the SIM group.
    :vartype mobile_network: ~azure.mgmt.mobilenetwork.models.MobileNetworkResourceId
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "identity": {"key": "identity", "type": "ManagedServiceIdentity"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "encryption_key": {"key": "properties.encryptionKey", "type": "KeyVaultKey"},
        "mobile_network": {"key": "properties.mobileNetwork", "type": "MobileNetworkResourceId"},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        identity: Optional["_models.ManagedServiceIdentity"] = None,
        encryption_key: Optional["_models.KeyVaultKey"] = None,
        mobile_network: Optional["_models.MobileNetworkResourceId"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword identity: The identity used to retrieve the encryption key from Azure key vault.
        :paramtype identity: ~azure.mgmt.mobilenetwork.models.ManagedServiceIdentity
        :keyword encryption_key: A key to encrypt the SIM data that belongs to this SIM group.
        :paramtype encryption_key: ~azure.mgmt.mobilenetwork.models.KeyVaultKey
        :keyword mobile_network: Mobile network that this SIM group belongs to. The mobile network must
         be in the same location as the SIM group.
        :paramtype mobile_network: ~azure.mgmt.mobilenetwork.models.MobileNetworkResourceId
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.provisioning_state = None
        self.encryption_key = encryption_key
        self.mobile_network = mobile_network


class SimGroupListResult(_serialization.Model):
    """Response for list SIM groups API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of SIM groups in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.SimGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SimGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.SimGroup"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of SIM groups in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.SimGroup]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SimGroupResourceId(_serialization.Model):
    """Reference to a SIM group resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: SIM group resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[sS][iI][mM][gG][rR][oO][uU][pP][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: SIM group resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SimListResult(_serialization.Model):
    """Response for list SIMs API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of SIMs in a resource group.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Sim]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Sim]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Sim"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of SIMs in a resource group.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.Sim]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SimNameAndEncryptedProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """SIM name and encrypted properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SIM. Required.
    :vartype name: str
    :ivar provisioning_state: The provisioning state of the SIM resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar sim_state: The state of the SIM resource. Known values are: "Disabled", "Enabled", and
     "Invalid".
    :vartype sim_state: str or ~azure.mgmt.mobilenetwork.models.SimState
    :ivar site_provisioning_state: A dictionary of sites to the provisioning state of this SIM on
     that site.
    :vartype site_provisioning_state: dict[str, str or
     ~azure.mgmt.mobilenetwork.models.SiteProvisioningState]
    :ivar international_mobile_subscriber_identity: The international mobile subscriber identity
     (IMSI) for the SIM. Required.
    :vartype international_mobile_subscriber_identity: str
    :ivar integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the SIM.
    :vartype integrated_circuit_card_identifier: str
    :ivar device_type: An optional free-form text field that can be used to record the device type
     this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be
     grouped and filtered based on this value.
    :vartype device_type: str
    :ivar sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same location
     as the SIM.
    :vartype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
    :ivar static_ip_configuration: A list of static IP addresses assigned to this SIM. Each address
     is assigned at a defined network scope, made up of {attached data network, slice}.
    :vartype static_ip_configuration: list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
    :ivar vendor_name: The name of the SIM vendor who provided this SIM, if any.
    :vartype vendor_name: str
    :ivar vendor_key_fingerprint: The public key fingerprint of the SIM vendor who provided this
     SIM, if any.
    :vartype vendor_key_fingerprint: str
    :ivar encrypted_credentials: The encrypted SIM credentials.
    :vartype encrypted_credentials: str
    """

    _validation = {
        "name": {"required": True},
        "provisioning_state": {"readonly": True},
        "sim_state": {"readonly": True},
        "site_provisioning_state": {"readonly": True},
        "international_mobile_subscriber_identity": {"required": True, "pattern": r"^[0-9]{5,15}$"},
        "integrated_circuit_card_identifier": {"pattern": r"^[0-9]{10,20}$"},
        "static_ip_configuration": {"min_items": 1, "unique": True},
        "vendor_name": {"readonly": True},
        "vendor_key_fingerprint": {"readonly": True},
        "encrypted_credentials": {"pattern": r"^[0-9a-fA-F]+$"},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sim_state": {"key": "properties.simState", "type": "str"},
        "site_provisioning_state": {"key": "properties.siteProvisioningState", "type": "{str}"},
        "international_mobile_subscriber_identity": {
            "key": "properties.internationalMobileSubscriberIdentity",
            "type": "str",
        },
        "integrated_circuit_card_identifier": {"key": "properties.integratedCircuitCardIdentifier", "type": "str"},
        "device_type": {"key": "properties.deviceType", "type": "str"},
        "sim_policy": {"key": "properties.simPolicy", "type": "SimPolicyResourceId"},
        "static_ip_configuration": {"key": "properties.staticIpConfiguration", "type": "[SimStaticIpProperties]"},
        "vendor_name": {"key": "properties.vendorName", "type": "str"},
        "vendor_key_fingerprint": {"key": "properties.vendorKeyFingerprint", "type": "str"},
        "encrypted_credentials": {"key": "properties.encryptedCredentials", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        international_mobile_subscriber_identity: str,
        integrated_circuit_card_identifier: Optional[str] = None,
        device_type: Optional[str] = None,
        sim_policy: Optional["_models.SimPolicyResourceId"] = None,
        static_ip_configuration: Optional[List["_models.SimStaticIpProperties"]] = None,
        encrypted_credentials: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SIM. Required.
        :paramtype name: str
        :keyword international_mobile_subscriber_identity: The international mobile subscriber identity
         (IMSI) for the SIM. Required.
        :paramtype international_mobile_subscriber_identity: str
        :keyword integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the
         SIM.
        :paramtype integrated_circuit_card_identifier: str
        :keyword device_type: An optional free-form text field that can be used to record the device
         type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to
         be grouped and filtered based on this value.
        :paramtype device_type: str
        :keyword sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same
         location as the SIM.
        :paramtype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
        :keyword static_ip_configuration: A list of static IP addresses assigned to this SIM. Each
         address is assigned at a defined network scope, made up of {attached data network, slice}.
        :paramtype static_ip_configuration:
         list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
        :keyword encrypted_credentials: The encrypted SIM credentials.
        :paramtype encrypted_credentials: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.provisioning_state = None
        self.sim_state = None
        self.site_provisioning_state = None
        self.international_mobile_subscriber_identity = international_mobile_subscriber_identity
        self.integrated_circuit_card_identifier = integrated_circuit_card_identifier
        self.device_type = device_type
        self.sim_policy = sim_policy
        self.static_ip_configuration = static_ip_configuration
        self.vendor_name = None
        self.vendor_key_fingerprint = None
        self.encrypted_credentials = encrypted_credentials


class SimNameAndProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """SIM name and properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: The name of the SIM. Required.
    :vartype name: str
    :ivar provisioning_state: The provisioning state of the SIM resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar sim_state: The state of the SIM resource. Known values are: "Disabled", "Enabled", and
     "Invalid".
    :vartype sim_state: str or ~azure.mgmt.mobilenetwork.models.SimState
    :ivar site_provisioning_state: A dictionary of sites to the provisioning state of this SIM on
     that site.
    :vartype site_provisioning_state: dict[str, str or
     ~azure.mgmt.mobilenetwork.models.SiteProvisioningState]
    :ivar international_mobile_subscriber_identity: The international mobile subscriber identity
     (IMSI) for the SIM. Required.
    :vartype international_mobile_subscriber_identity: str
    :ivar integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the SIM.
    :vartype integrated_circuit_card_identifier: str
    :ivar device_type: An optional free-form text field that can be used to record the device type
     this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be
     grouped and filtered based on this value.
    :vartype device_type: str
    :ivar sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same location
     as the SIM.
    :vartype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
    :ivar static_ip_configuration: A list of static IP addresses assigned to this SIM. Each address
     is assigned at a defined network scope, made up of {attached data network, slice}.
    :vartype static_ip_configuration: list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
    :ivar vendor_name: The name of the SIM vendor who provided this SIM, if any.
    :vartype vendor_name: str
    :ivar vendor_key_fingerprint: The public key fingerprint of the SIM vendor who provided this
     SIM, if any.
    :vartype vendor_key_fingerprint: str
    :ivar authentication_key: The Ki value for the SIM.
    :vartype authentication_key: str
    :ivar operator_key_code: The Opc value for the SIM.
    :vartype operator_key_code: str
    """

    _validation = {
        "name": {"required": True},
        "provisioning_state": {"readonly": True},
        "sim_state": {"readonly": True},
        "site_provisioning_state": {"readonly": True},
        "international_mobile_subscriber_identity": {"required": True, "pattern": r"^[0-9]{5,15}$"},
        "integrated_circuit_card_identifier": {"pattern": r"^[0-9]{10,20}$"},
        "static_ip_configuration": {"min_items": 1, "unique": True},
        "vendor_name": {"readonly": True},
        "vendor_key_fingerprint": {"readonly": True},
        "authentication_key": {"pattern": r"^[0-9a-fA-F]{32}$"},
        "operator_key_code": {"pattern": r"^[0-9a-fA-F]{32}$"},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "sim_state": {"key": "properties.simState", "type": "str"},
        "site_provisioning_state": {"key": "properties.siteProvisioningState", "type": "{str}"},
        "international_mobile_subscriber_identity": {
            "key": "properties.internationalMobileSubscriberIdentity",
            "type": "str",
        },
        "integrated_circuit_card_identifier": {"key": "properties.integratedCircuitCardIdentifier", "type": "str"},
        "device_type": {"key": "properties.deviceType", "type": "str"},
        "sim_policy": {"key": "properties.simPolicy", "type": "SimPolicyResourceId"},
        "static_ip_configuration": {"key": "properties.staticIpConfiguration", "type": "[SimStaticIpProperties]"},
        "vendor_name": {"key": "properties.vendorName", "type": "str"},
        "vendor_key_fingerprint": {"key": "properties.vendorKeyFingerprint", "type": "str"},
        "authentication_key": {"key": "properties.authenticationKey", "type": "str"},
        "operator_key_code": {"key": "properties.operatorKeyCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: str,
        international_mobile_subscriber_identity: str,
        integrated_circuit_card_identifier: Optional[str] = None,
        device_type: Optional[str] = None,
        sim_policy: Optional["_models.SimPolicyResourceId"] = None,
        static_ip_configuration: Optional[List["_models.SimStaticIpProperties"]] = None,
        authentication_key: Optional[str] = None,
        operator_key_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SIM. Required.
        :paramtype name: str
        :keyword international_mobile_subscriber_identity: The international mobile subscriber identity
         (IMSI) for the SIM. Required.
        :paramtype international_mobile_subscriber_identity: str
        :keyword integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the
         SIM.
        :paramtype integrated_circuit_card_identifier: str
        :keyword device_type: An optional free-form text field that can be used to record the device
         type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to
         be grouped and filtered based on this value.
        :paramtype device_type: str
        :keyword sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same
         location as the SIM.
        :paramtype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
        :keyword static_ip_configuration: A list of static IP addresses assigned to this SIM. Each
         address is assigned at a defined network scope, made up of {attached data network, slice}.
        :paramtype static_ip_configuration:
         list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
        :keyword authentication_key: The Ki value for the SIM.
        :paramtype authentication_key: str
        :keyword operator_key_code: The Opc value for the SIM.
        :paramtype operator_key_code: str
        """
        super().__init__(**kwargs)
        self.name = name
        self.provisioning_state = None
        self.sim_state = None
        self.site_provisioning_state = None
        self.international_mobile_subscriber_identity = international_mobile_subscriber_identity
        self.integrated_circuit_card_identifier = integrated_circuit_card_identifier
        self.device_type = device_type
        self.sim_policy = sim_policy
        self.static_ip_configuration = static_ip_configuration
        self.vendor_name = None
        self.vendor_key_fingerprint = None
        self.authentication_key = authentication_key
        self.operator_key_code = operator_key_code


class SimPolicy(TrackedResource):  # pylint: disable=too-many-instance-attributes
    """SIM policy resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the SIM policy resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar site_provisioning_state: A dictionary of sites to the provisioning state of this SIM
     policy on that site.
    :vartype site_provisioning_state: dict[str, str or
     ~azure.mgmt.mobilenetwork.models.SiteProvisioningState]
    :ivar ue_ambr: Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions of a
     given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the UE-AMBR. Required.
    :vartype ue_ambr: ~azure.mgmt.mobilenetwork.models.Ambr
    :ivar default_slice: The default slice to use if the UE does not explicitly specify it. This
     slice must exist in the ``sliceConfigurations`` map. The slice must be in the same location as
     the SIM policy. Required.
    :vartype default_slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
    :ivar rfsp_index: RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413. This is an
     optional setting and by default is unspecified.
    :vartype rfsp_index: int
    :ivar registration_timer: UE periodic registration update timer (5G) or UE periodic tracking
     area update timer (4G), in seconds.
    :vartype registration_timer: int
    :ivar slice_configurations: The allowed slices and the settings to use for them. The list must
     not contain duplicate items and must contain at least one item. Required.
    :vartype slice_configurations: list[~azure.mgmt.mobilenetwork.models.SliceConfiguration]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "site_provisioning_state": {"readonly": True},
        "ue_ambr": {"required": True},
        "default_slice": {"required": True},
        "rfsp_index": {"maximum": 256, "minimum": 1},
        "registration_timer": {"minimum": 30},
        "slice_configurations": {"required": True, "min_items": 1, "unique": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "site_provisioning_state": {"key": "properties.siteProvisioningState", "type": "{str}"},
        "ue_ambr": {"key": "properties.ueAmbr", "type": "Ambr"},
        "default_slice": {"key": "properties.defaultSlice", "type": "SliceResourceId"},
        "rfsp_index": {"key": "properties.rfspIndex", "type": "int"},
        "registration_timer": {"key": "properties.registrationTimer", "type": "int"},
        "slice_configurations": {"key": "properties.sliceConfigurations", "type": "[SliceConfiguration]"},
    }

    def __init__(
        self,
        *,
        location: str,
        ue_ambr: "_models.Ambr",
        default_slice: "_models.SliceResourceId",
        slice_configurations: List["_models.SliceConfiguration"],
        tags: Optional[Dict[str, str]] = None,
        rfsp_index: Optional[int] = None,
        registration_timer: int = 3240,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword ue_ambr: Aggregate maximum bit rate across all non-GBR QoS flows of all PDU sessions
         of a given UE. See 3GPP TS23.501 section 5.7.2.6 for a full description of the UE-AMBR.
         Required.
        :paramtype ue_ambr: ~azure.mgmt.mobilenetwork.models.Ambr
        :keyword default_slice: The default slice to use if the UE does not explicitly specify it. This
         slice must exist in the ``sliceConfigurations`` map. The slice must be in the same location as
         the SIM policy. Required.
        :paramtype default_slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
        :keyword rfsp_index: RAT/Frequency Selection Priority Index, defined in 3GPP TS 36.413. This is
         an optional setting and by default is unspecified.
        :paramtype rfsp_index: int
        :keyword registration_timer: UE periodic registration update timer (5G) or UE periodic tracking
         area update timer (4G), in seconds.
        :paramtype registration_timer: int
        :keyword slice_configurations: The allowed slices and the settings to use for them. The list
         must not contain duplicate items and must contain at least one item. Required.
        :paramtype slice_configurations: list[~azure.mgmt.mobilenetwork.models.SliceConfiguration]
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.site_provisioning_state = None
        self.ue_ambr = ue_ambr
        self.default_slice = default_slice
        self.rfsp_index = rfsp_index
        self.registration_timer = registration_timer
        self.slice_configurations = slice_configurations


class SimPolicyListResult(_serialization.Model):
    """Response for SIM policies API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of SIM policies.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.SimPolicy]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SimPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.SimPolicy"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of SIM policies.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.SimPolicy]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SimPolicyResourceId(_serialization.Model):
    """Reference to a SIM policy resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: SIM policy resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+/[sS][iI][mM][pP][oO][lL][iI][cC][iI][eE][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: SIM policy resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SimPropertiesFormat(CommonSimPropertiesFormat):  # pylint: disable=too-many-instance-attributes
    """SIM properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar provisioning_state: The provisioning state of the SIM resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar sim_state: The state of the SIM resource. Known values are: "Disabled", "Enabled", and
     "Invalid".
    :vartype sim_state: str or ~azure.mgmt.mobilenetwork.models.SimState
    :ivar site_provisioning_state: A dictionary of sites to the provisioning state of this SIM on
     that site.
    :vartype site_provisioning_state: dict[str, str or
     ~azure.mgmt.mobilenetwork.models.SiteProvisioningState]
    :ivar international_mobile_subscriber_identity: The international mobile subscriber identity
     (IMSI) for the SIM. Required.
    :vartype international_mobile_subscriber_identity: str
    :ivar integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the SIM.
    :vartype integrated_circuit_card_identifier: str
    :ivar device_type: An optional free-form text field that can be used to record the device type
     this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to be
     grouped and filtered based on this value.
    :vartype device_type: str
    :ivar sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same location
     as the SIM.
    :vartype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
    :ivar static_ip_configuration: A list of static IP addresses assigned to this SIM. Each address
     is assigned at a defined network scope, made up of {attached data network, slice}.
    :vartype static_ip_configuration: list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
    :ivar vendor_name: The name of the SIM vendor who provided this SIM, if any.
    :vartype vendor_name: str
    :ivar vendor_key_fingerprint: The public key fingerprint of the SIM vendor who provided this
     SIM, if any.
    :vartype vendor_key_fingerprint: str
    :ivar authentication_key: The Ki value for the SIM.
    :vartype authentication_key: str
    :ivar operator_key_code: The Opc value for the SIM.
    :vartype operator_key_code: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
        "sim_state": {"readonly": True},
        "site_provisioning_state": {"readonly": True},
        "international_mobile_subscriber_identity": {"required": True, "pattern": r"^[0-9]{5,15}$"},
        "integrated_circuit_card_identifier": {"pattern": r"^[0-9]{10,20}$"},
        "static_ip_configuration": {"min_items": 1, "unique": True},
        "vendor_name": {"readonly": True},
        "vendor_key_fingerprint": {"readonly": True},
        "authentication_key": {"pattern": r"^[0-9a-fA-F]{32}$"},
        "operator_key_code": {"pattern": r"^[0-9a-fA-F]{32}$"},
    }

    _attribute_map = {
        "provisioning_state": {"key": "provisioningState", "type": "str"},
        "sim_state": {"key": "simState", "type": "str"},
        "site_provisioning_state": {"key": "siteProvisioningState", "type": "{str}"},
        "international_mobile_subscriber_identity": {"key": "internationalMobileSubscriberIdentity", "type": "str"},
        "integrated_circuit_card_identifier": {"key": "integratedCircuitCardIdentifier", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "sim_policy": {"key": "simPolicy", "type": "SimPolicyResourceId"},
        "static_ip_configuration": {"key": "staticIpConfiguration", "type": "[SimStaticIpProperties]"},
        "vendor_name": {"key": "vendorName", "type": "str"},
        "vendor_key_fingerprint": {"key": "vendorKeyFingerprint", "type": "str"},
        "authentication_key": {"key": "authenticationKey", "type": "str"},
        "operator_key_code": {"key": "operatorKeyCode", "type": "str"},
    }

    def __init__(
        self,
        *,
        international_mobile_subscriber_identity: str,
        integrated_circuit_card_identifier: Optional[str] = None,
        device_type: Optional[str] = None,
        sim_policy: Optional["_models.SimPolicyResourceId"] = None,
        static_ip_configuration: Optional[List["_models.SimStaticIpProperties"]] = None,
        authentication_key: Optional[str] = None,
        operator_key_code: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword international_mobile_subscriber_identity: The international mobile subscriber identity
         (IMSI) for the SIM. Required.
        :paramtype international_mobile_subscriber_identity: str
        :keyword integrated_circuit_card_identifier: The integrated circuit card ID (ICCID) for the
         SIM.
        :paramtype integrated_circuit_card_identifier: str
        :keyword device_type: An optional free-form text field that can be used to record the device
         type this SIM is associated with, for example 'Video camera'. The Azure portal allows SIMs to
         be grouped and filtered based on this value.
        :paramtype device_type: str
        :keyword sim_policy: The SIM policy used by this SIM. The SIM policy must be in the same
         location as the SIM.
        :paramtype sim_policy: ~azure.mgmt.mobilenetwork.models.SimPolicyResourceId
        :keyword static_ip_configuration: A list of static IP addresses assigned to this SIM. Each
         address is assigned at a defined network scope, made up of {attached data network, slice}.
        :paramtype static_ip_configuration:
         list[~azure.mgmt.mobilenetwork.models.SimStaticIpProperties]
        :keyword authentication_key: The Ki value for the SIM.
        :paramtype authentication_key: str
        :keyword operator_key_code: The Opc value for the SIM.
        :paramtype operator_key_code: str
        """
        super().__init__(
            international_mobile_subscriber_identity=international_mobile_subscriber_identity,
            integrated_circuit_card_identifier=integrated_circuit_card_identifier,
            device_type=device_type,
            sim_policy=sim_policy,
            static_ip_configuration=static_ip_configuration,
            **kwargs
        )
        self.authentication_key = authentication_key
        self.operator_key_code = operator_key_code


class SimStaticIpProperties(_serialization.Model):
    """Static IP configuration for a SIM, scoped to a particular attached data network and slice.

    :ivar attached_data_network: The attached data network on which the static IP address will be
     used. The combination of attached data network and slice defines the network scope of the IP
     address. The attached data network must be in the same location as the SIM.
    :vartype attached_data_network: ~azure.mgmt.mobilenetwork.models.AttachedDataNetworkResourceId
    :ivar slice: The network slice on which the static IP address will be used. The combination of
     attached data network and slice defines the network scope of the IP address. The slice must be
     in the same location as the SIM.
    :vartype slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
    :ivar static_ip: The static IP configuration for the SIM to use at the defined network scope.
    :vartype static_ip: ~azure.mgmt.mobilenetwork.models.SimStaticIpPropertiesStaticIp
    """

    _attribute_map = {
        "attached_data_network": {"key": "attachedDataNetwork", "type": "AttachedDataNetworkResourceId"},
        "slice": {"key": "slice", "type": "SliceResourceId"},
        "static_ip": {"key": "staticIp", "type": "SimStaticIpPropertiesStaticIp"},
    }

    def __init__(
        self,
        *,
        attached_data_network: Optional["_models.AttachedDataNetworkResourceId"] = None,
        slice: Optional["_models.SliceResourceId"] = None,
        static_ip: Optional["_models.SimStaticIpPropertiesStaticIp"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword attached_data_network: The attached data network on which the static IP address will
         be used. The combination of attached data network and slice defines the network scope of the IP
         address. The attached data network must be in the same location as the SIM.
        :paramtype attached_data_network:
         ~azure.mgmt.mobilenetwork.models.AttachedDataNetworkResourceId
        :keyword slice: The network slice on which the static IP address will be used. The combination
         of attached data network and slice defines the network scope of the IP address. The slice must
         be in the same location as the SIM.
        :paramtype slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
        :keyword static_ip: The static IP configuration for the SIM to use at the defined network
         scope.
        :paramtype static_ip: ~azure.mgmt.mobilenetwork.models.SimStaticIpPropertiesStaticIp
        """
        super().__init__(**kwargs)
        self.attached_data_network = attached_data_network
        self.slice = slice
        self.static_ip = static_ip


class SimStaticIpPropertiesStaticIp(_serialization.Model):
    """The static IP configuration for the SIM to use at the defined network scope.

    :ivar ipv4_address: The IPv4 address assigned to the SIM at this network scope. This address
     must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
    :vartype ipv4_address: str
    """

    _validation = {
        "ipv4_address": {
            "pattern": r"^(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])$"
        },
    }

    _attribute_map = {
        "ipv4_address": {"key": "ipv4Address", "type": "str"},
    }

    def __init__(self, *, ipv4_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ipv4_address: The IPv4 address assigned to the SIM at this network scope. This address
         must be in the userEquipmentStaticAddressPoolPrefix defined in the attached data network.
        :paramtype ipv4_address: str
        """
        super().__init__(**kwargs)
        self.ipv4_address = ipv4_address


class SimUploadList(_serialization.Model):
    """The SIMs to upload.

    All required parameters must be populated in order to send to Azure.

    :ivar sims: A list of SIMs to upload. Required.
    :vartype sims: list[~azure.mgmt.mobilenetwork.models.SimNameAndProperties]
    """

    _validation = {
        "sims": {"required": True, "min_items": 1},
    }

    _attribute_map = {
        "sims": {"key": "sims", "type": "[SimNameAndProperties]"},
    }

    def __init__(self, *, sims: List["_models.SimNameAndProperties"], **kwargs: Any) -> None:
        """
        :keyword sims: A list of SIMs to upload. Required.
        :paramtype sims: list[~azure.mgmt.mobilenetwork.models.SimNameAndProperties]
        """
        super().__init__(**kwargs)
        self.sims = sims


class Site(TrackedResource):
    """Site resource. Must be created in the same location as its parent mobile network.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the site resource. Known values are:
     "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar network_functions: An array of IDs of the network functions deployed in the site.
     Deleting the site will delete any network functions that are deployed in the site.
    :vartype network_functions: list[~azure.mgmt.mobilenetwork.models.SubResource]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "network_functions": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "network_functions": {"key": "properties.networkFunctions", "type": "[SubResource]"},
    }

    def __init__(self, *, location: str, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.network_functions = None


class SiteDeletePacketCore(_serialization.Model):
    """The packet core to delete under a site.

    :ivar packet_core: Reference to an packet core control plane resource.
    :vartype packet_core: ~azure.mgmt.mobilenetwork.models.PacketCoreControlPlaneResourceId
    """

    _attribute_map = {
        "packet_core": {"key": "packetCore", "type": "PacketCoreControlPlaneResourceId"},
    }

    def __init__(
        self, *, packet_core: Optional["_models.PacketCoreControlPlaneResourceId"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword packet_core: Reference to an packet core control plane resource.
        :paramtype packet_core: ~azure.mgmt.mobilenetwork.models.PacketCoreControlPlaneResourceId
        """
        super().__init__(**kwargs)
        self.packet_core = packet_core


class SiteListResult(_serialization.Model):
    """Response for sites API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of sites in a mobile network.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Site]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Site]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Site"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of sites in a mobile network.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.Site]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SiteResourceId(_serialization.Model):
    """Reference to a site resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Site resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+/[sS][iI][tT][eE][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Site resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class Slice(TrackedResource):
    """Network slice resource. Must be created in the same location as its parent mobile network.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource ID for the resource. E.g.
     "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}".
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.mobilenetwork.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar provisioning_state: The provisioning state of the network slice resource. Known values
     are: "Unknown", "Succeeded", "Accepted", "Deleting", "Failed", "Canceled", and "Deleted".
    :vartype provisioning_state: str or ~azure.mgmt.mobilenetwork.models.ProvisioningState
    :ivar snssai: Single-network slice selection assistance information (S-NSSAI). Unique at the
     scope of a mobile network. Required.
    :vartype snssai: ~azure.mgmt.mobilenetwork.models.Snssai
    :ivar description: An optional description for this network slice.
    :vartype description: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "system_data": {"readonly": True},
        "location": {"required": True},
        "provisioning_state": {"readonly": True},
        "snssai": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "tags": {"key": "tags", "type": "{str}"},
        "location": {"key": "location", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "snssai": {"key": "properties.snssai", "type": "Snssai"},
        "description": {"key": "properties.description", "type": "str"},
    }

    def __init__(
        self,
        *,
        location: str,
        snssai: "_models.Snssai",
        tags: Optional[Dict[str, str]] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword location: The geo-location where the resource lives. Required.
        :paramtype location: str
        :keyword snssai: Single-network slice selection assistance information (S-NSSAI). Unique at the
         scope of a mobile network. Required.
        :paramtype snssai: ~azure.mgmt.mobilenetwork.models.Snssai
        :keyword description: An optional description for this network slice.
        :paramtype description: str
        """
        super().__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = None
        self.snssai = snssai
        self.description = description


class SliceConfiguration(_serialization.Model):
    """Per-slice settings.

    All required parameters must be populated in order to send to Azure.

    :ivar slice: A reference to the slice that these settings apply to. The slice must be in the
     same location as the SIM policy. Required.
    :vartype slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
    :ivar default_data_network: The default data network to use if the UE does not explicitly
     specify it. Configuration for this object must exist in the ``dataNetworkConfigurations`` map.
     The data network must be in the same location as the SIM policy. Required.
    :vartype default_data_network: ~azure.mgmt.mobilenetwork.models.DataNetworkResourceId
    :ivar data_network_configurations: The allowed data networks and the settings to use for them.
     The list must not contain duplicate items and must contain at least one item. Required.
    :vartype data_network_configurations:
     list[~azure.mgmt.mobilenetwork.models.DataNetworkConfiguration]
    """

    _validation = {
        "slice": {"required": True},
        "default_data_network": {"required": True},
        "data_network_configurations": {"required": True, "min_items": 1, "unique": True},
    }

    _attribute_map = {
        "slice": {"key": "slice", "type": "SliceResourceId"},
        "default_data_network": {"key": "defaultDataNetwork", "type": "DataNetworkResourceId"},
        "data_network_configurations": {"key": "dataNetworkConfigurations", "type": "[DataNetworkConfiguration]"},
    }

    def __init__(
        self,
        *,
        slice: "_models.SliceResourceId",
        default_data_network: "_models.DataNetworkResourceId",
        data_network_configurations: List["_models.DataNetworkConfiguration"],
        **kwargs: Any
    ) -> None:
        """
        :keyword slice: A reference to the slice that these settings apply to. The slice must be in the
         same location as the SIM policy. Required.
        :paramtype slice: ~azure.mgmt.mobilenetwork.models.SliceResourceId
        :keyword default_data_network: The default data network to use if the UE does not explicitly
         specify it. Configuration for this object must exist in the ``dataNetworkConfigurations`` map.
         The data network must be in the same location as the SIM policy. Required.
        :paramtype default_data_network: ~azure.mgmt.mobilenetwork.models.DataNetworkResourceId
        :keyword data_network_configurations: The allowed data networks and the settings to use for
         them. The list must not contain duplicate items and must contain at least one item. Required.
        :paramtype data_network_configurations:
         list[~azure.mgmt.mobilenetwork.models.DataNetworkConfiguration]
        """
        super().__init__(**kwargs)
        self.slice = slice
        self.default_data_network = default_data_network
        self.data_network_configurations = data_network_configurations


class SliceListResult(_serialization.Model):
    """Response for network slice API service call.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: A list of network slices in a mobile network.
    :vartype value: list[~azure.mgmt.mobilenetwork.models.Slice]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[Slice]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.Slice"]] = None, **kwargs: Any) -> None:
        """
        :keyword value: A list of network slices in a mobile network.
        :paramtype value: list[~azure.mgmt.mobilenetwork.models.Slice]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SliceResourceId(_serialization.Model):
    """Reference to a slice resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Slice resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {
            "required": True,
            "pattern": r"^/[sS][uU][bB][sS][cC][rR][iI][pP][tT][iI][oO][nN][sS]/[^/?#]+/[rR][eE][sS][oO][uU][rR][cC][eE][gG][rR][oO][uU][pP][sS]/[^/?#]+/[pP][rR][oO][vV][iI][dD][eE][rR][sS]/[mM][iI][cC][rR][oO][sS][oO][fF][tT]\.[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK]/[mM][oO][bB][iI][lL][eE][nN][eE][tT][wW][oO][rR][kK][sS]/[^/?#]+/[sS][lL][iI][cC][eE][sS]/[^/?#]+$",
        },
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Slice resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class Snssai(_serialization.Model):
    """Single-network slice selection assistance information (S-NSSAI).

    All required parameters must be populated in order to send to Azure.

    :ivar sst: Slice/service type (SST). Required.
    :vartype sst: int
    :ivar sd: Slice differentiator (SD).
    :vartype sd: str
    """

    _validation = {
        "sst": {"required": True, "maximum": 255, "minimum": 0},
        "sd": {"pattern": r"^[A-Fa-f0-9]{6}$"},
    }

    _attribute_map = {
        "sst": {"key": "sst", "type": "int"},
        "sd": {"key": "sd", "type": "str"},
    }

    def __init__(self, *, sst: int, sd: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword sst: Slice/service type (SST). Required.
        :paramtype sst: int
        :keyword sd: Slice differentiator (SD).
        :paramtype sd: str
        """
        super().__init__(**kwargs)
        self.sst = sst
        self.sd = sd


class SubResource(_serialization.Model):
    """Reference to another sub resource.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID. Required.
    :vartype id: str
    """

    _validation = {
        "id": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: str, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID. Required.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.mobilenetwork.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.mobilenetwork.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.mobilenetwork.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or ~azure.mgmt.mobilenetwork.models.CreatedByType
        :keyword last_modified_at: The timestamp of resource last modification (UTC).
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs: Any) -> None:
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class UserAssignedIdentity(_serialization.Model):
    """User assigned identity properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal ID of the assigned identity.
    :vartype principal_id: str
    :ivar client_id: The client ID of the assigned identity.
    :vartype client_id: str
    """

    _validation = {
        "principal_id": {"readonly": True},
        "client_id": {"readonly": True},
    }

    _attribute_map = {
        "principal_id": {"key": "principalId", "type": "str"},
        "client_id": {"key": "clientId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.principal_id = None
        self.client_id = None
