/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.mozilla;

import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;
import org.exolab.castor.dsml.Producer;
import org.exolab.castor.util.MimeBase64Encoder;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class MozillaProducer
extends Producer {
    public MozillaProducer(DocumentHandler docHandler, boolean namespace) {
        super(docHandler, namespace);
    }

    public void produce(LDAPEntry entry) throws SAXException {
        this.leaveSchema();
        this.enterDirectory();
        AttributeListImpl attrList = new AttributeListImpl();
        attrList.addAttribute("dn", "CDATA", entry.getDN());
        this._docHandler.startElement(this.prefix("entry"), attrList);
        LDAPAttributeSet attrSet = entry.getAttributeSet();
        if (attrSet != null) {
            char[] chars;
            Enumeration values;
            LDAPAttribute attr = attrSet.getAttribute("objectclass");
            if (attr != null) {
                attrList = new AttributeListImpl();
                this._docHandler.startElement(this.prefix("objectclass"), attrList);
                values = attr.getStringValues();
                while (values.hasMoreElements()) {
                    chars = ((String)values.nextElement()).toCharArray();
                    attrList = new AttributeListImpl();
                    this._docHandler.startElement(this.prefix("oc-value"), attrList);
                    this._docHandler.characters(chars, 0, chars.length);
                    this._docHandler.endElement(this.prefix("oc-value"));
                }
                this._docHandler.endElement(this.prefix("objectclass"));
            }
            Enumeration enumeration = attrSet.getAttributes();
            while (enumeration.hasMoreElements()) {
                attr = (LDAPAttribute)enumeration.nextElement();
                if (attr.getName().equals("objectclass")) continue;
                attrList = new AttributeListImpl();
                attrList.addAttribute("name", "CDATA", attr.getName());
                this._docHandler.startElement(this.prefix("attr"), attrList);
                values = attr.getByteValues();
                while (values.hasMoreElements()) {
                    byte[] value = (byte[])values.nextElement();
                    attrList = new AttributeListImpl();
                    if (value == null) {
                        chars = new char[]{};
                    } else {
                        int i;
                        for (i = 0; i < value.length && value[i] >= 32 && value[i] != 127; ++i) {
                        }
                        if (i == value.length) {
                            chars = new char[value.length];
                            for (i = 0; i < value.length; ++i) {
                                chars[i] = (char)value[i];
                            }
                        } else {
                            MimeBase64Encoder encoder = new MimeBase64Encoder();
                            encoder.translate(value);
                            chars = encoder.getCharArray();
                            attrList.addAttribute("encoding", "NMTOKEN", "base64");
                        }
                    }
                    this._docHandler.startElement(this.prefix("value"), attrList);
                    this._docHandler.characters(chars, 0, chars.length);
                    this._docHandler.endElement(this.prefix("value"));
                }
                this._docHandler.endElement(this.prefix("attr"));
            }
        }
        this._docHandler.endElement(this.prefix("entry"));
    }

    public void produce(Enumeration entries) throws SAXException {
        while (entries.hasMoreElements()) {
            this.produce((LDAPEntry)entries.nextElement());
        }
    }

    public void produce(LDAPSearchResults entries) throws SAXException {
        while (entries.hasMoreElements()) {
            this.produce((LDAPEntry)entries.nextElement());
        }
    }

    public void produce(LDAPSchema schema) throws SAXException {
        Enumeration enumeration = schema.getObjectClasses();
        while (enumeration.hasMoreElements()) {
            this.produce((LDAPObjectClassSchema)enumeration.nextElement());
        }
        enumeration = schema.getAttributes();
        while (enumeration.hasMoreElements()) {
            this.produce((LDAPAttributeSchema)enumeration.nextElement());
        }
    }

    public void produce(LDAPObjectClassSchema schema) throws SAXException {
        int i;
        this.leaveDirectory();
        this.enterSchema();
        AttributeListImpl attrList = new AttributeListImpl();
        attrList.addAttribute("id", "ID", schema.getName());
        String[] superiors = schema.getSuperiors();
        String superior = null;
        for (i = 0; i < superiors.length; ++i) {
            superior = i == 0 ? superiors[i] : superior + "," + superiors[i];
        }
        if (i > 0) {
            attrList.addAttribute("superior", "CDATA", superior);
        }
        attrList.addAttribute("obsolete", null, schema.isObsolete() ? "true" : "false");
        switch (schema.getType()) {
            case 0: {
                attrList.addAttribute("type", null, "structural");
                break;
            }
            case 1: {
                attrList.addAttribute("type", null, "abstract");
                break;
            }
            case 2: {
                attrList.addAttribute("type", null, "auxiliary");
            }
        }
        this._docHandler.startElement(this.prefix("class"), attrList);
        if (schema.getName() != null) {
            attrList = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("name"), attrList);
            this._docHandler.characters(schema.getName().toCharArray(), 0, schema.getName().length());
            this._docHandler.endElement(this.prefix("name"));
        }
        if (schema.getDescription() != null) {
            attrList = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("description"), attrList);
            this._docHandler.characters(schema.getDescription().toCharArray(), 0, schema.getDescription().length());
            this._docHandler.endElement(this.prefix("description"));
        }
        if (schema.getID() != null) {
            attrList = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("object-identifier"), attrList);
            this._docHandler.characters(schema.getID().toCharArray(), 0, schema.getID().length());
            this._docHandler.endElement(this.prefix("object-identifier"));
        }
        Enumeration enumeration = schema.getOptionalAttributes();
        while (enumeration.hasMoreElements()) {
            attrList = new AttributeListImpl();
            attrList.addAttribute("ref", "CDATA", "#" + (String)enumeration.nextElement());
            attrList.addAttribute("required", null, "false");
            this._docHandler.startElement(this.prefix("attribute"), attrList);
            this._docHandler.endElement(this.prefix("attribute"));
        }
        enumeration = schema.getRequiredAttributes();
        while (enumeration.hasMoreElements()) {
            attrList = new AttributeListImpl();
            attrList.addAttribute("ref", "CDATA", "#" + (String)enumeration.nextElement());
            attrList.addAttribute("required", null, "true");
            this._docHandler.startElement(this.prefix("attribute"), attrList);
            this._docHandler.endElement(this.prefix("attribute"));
        }
        this._docHandler.endElement(this.prefix("class"));
    }

    public void produce(LDAPAttributeSchema schema) throws SAXException {
        this.leaveDirectory();
        this.enterSchema();
        AttributeListImpl attrList = new AttributeListImpl();
        attrList.addAttribute("id", "ID", schema.getName());
        if (schema.getSuperior() != null) {
            attrList.addAttribute("superior", "CDATA", "#" + schema.getSuperior());
        }
        attrList.addAttribute("obsolete", null, schema.isObsolete() ? "true" : "false");
        attrList.addAttribute("single-value", null, schema.isSingleValued() ? "true" : "false");
        this._docHandler.startElement(this.prefix("attribute-type"), attrList);
        if (schema.getName() != null) {
            attrList = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("name"), attrList);
            this._docHandler.characters(schema.getName().toCharArray(), 0, schema.getName().length());
            this._docHandler.endElement(this.prefix("name"));
        }
        if (schema.getDescription() != null) {
            attrList = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("description"), attrList);
            this._docHandler.characters(schema.getDescription().toCharArray(), 0, schema.getDescription().length());
            this._docHandler.endElement(this.prefix("description"));
        }
        if (schema.getID() != null) {
            attrList = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("object-identifier"), attrList);
            this._docHandler.characters(schema.getID().toCharArray(), 0, schema.getID().length());
            this._docHandler.endElement(this.prefix("object-identifier"));
        }
        if (schema.getSyntaxString() != null) {
            attrList = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("syntax"), attrList);
            this._docHandler.characters(schema.getSyntaxString().toCharArray(), 0, schema.getSyntaxString().length());
            this._docHandler.endElement(this.prefix("syntax"));
        }
        this._docHandler.endElement(this.prefix("attribute-type"));
    }
}

