# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

import msrest.serialization

from ._container_service_client_enums import *


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        """
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ContainerService(Resource):
    """Container service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Required. Resource location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The current deployment or provisioning state, which only appears in
     the response.
    :vartype provisioning_state: str
    :ivar orchestrator_profile: Profile for the container service orchestrator.
    :vartype orchestrator_profile:
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceOrchestratorProfile
    :ivar custom_profile: Properties to configure a custom container service cluster.
    :vartype custom_profile:
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceCustomProfile
    :ivar service_principal_profile: Information about a service principal identity for the cluster
     to use for manipulating Azure APIs. Exact one of secret or keyVaultSecretRef need to be
     specified.
    :vartype service_principal_profile:
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServicePrincipalProfile
    :ivar master_profile: Profile for the container service master.
    :vartype master_profile:
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceMasterProfile
    :ivar agent_pool_profiles: Properties of the agent pool.
    :vartype agent_pool_profiles:
     list[~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceAgentPoolProfile]
    :ivar windows_profile: Profile for Windows VMs in the container service cluster.
    :vartype windows_profile:
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceWindowsProfile
    :ivar linux_profile: Profile for Linux VMs in the container service cluster.
    :vartype linux_profile:
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceLinuxProfile
    :ivar diagnostics_profile: Profile for diagnostics in the container service cluster.
    :vartype diagnostics_profile:
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceDiagnosticsProfile
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'orchestrator_profile': {'key': 'properties.orchestratorProfile', 'type': 'ContainerServiceOrchestratorProfile'},
        'custom_profile': {'key': 'properties.customProfile', 'type': 'ContainerServiceCustomProfile'},
        'service_principal_profile': {'key': 'properties.servicePrincipalProfile', 'type': 'ContainerServicePrincipalProfile'},
        'master_profile': {'key': 'properties.masterProfile', 'type': 'ContainerServiceMasterProfile'},
        'agent_pool_profiles': {'key': 'properties.agentPoolProfiles', 'type': '[ContainerServiceAgentPoolProfile]'},
        'windows_profile': {'key': 'properties.windowsProfile', 'type': 'ContainerServiceWindowsProfile'},
        'linux_profile': {'key': 'properties.linuxProfile', 'type': 'ContainerServiceLinuxProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'ContainerServiceDiagnosticsProfile'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        orchestrator_profile: Optional["ContainerServiceOrchestratorProfile"] = None,
        custom_profile: Optional["ContainerServiceCustomProfile"] = None,
        service_principal_profile: Optional["ContainerServicePrincipalProfile"] = None,
        master_profile: Optional["ContainerServiceMasterProfile"] = None,
        agent_pool_profiles: Optional[List["ContainerServiceAgentPoolProfile"]] = None,
        windows_profile: Optional["ContainerServiceWindowsProfile"] = None,
        linux_profile: Optional["ContainerServiceLinuxProfile"] = None,
        diagnostics_profile: Optional["ContainerServiceDiagnosticsProfile"] = None,
        **kwargs
    ):
        """
        :keyword location: Required. Resource location.
        :paramtype location: str
        :keyword tags: A set of tags. Resource tags.
        :paramtype tags: dict[str, str]
        :keyword orchestrator_profile: Profile for the container service orchestrator.
        :paramtype orchestrator_profile:
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceOrchestratorProfile
        :keyword custom_profile: Properties to configure a custom container service cluster.
        :paramtype custom_profile:
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceCustomProfile
        :keyword service_principal_profile: Information about a service principal identity for the
         cluster to use for manipulating Azure APIs. Exact one of secret or keyVaultSecretRef need to be
         specified.
        :paramtype service_principal_profile:
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServicePrincipalProfile
        :keyword master_profile: Profile for the container service master.
        :paramtype master_profile:
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceMasterProfile
        :keyword agent_pool_profiles: Properties of the agent pool.
        :paramtype agent_pool_profiles:
         list[~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceAgentPoolProfile]
        :keyword windows_profile: Profile for Windows VMs in the container service cluster.
        :paramtype windows_profile:
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceWindowsProfile
        :keyword linux_profile: Profile for Linux VMs in the container service cluster.
        :paramtype linux_profile:
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceLinuxProfile
        :keyword diagnostics_profile: Profile for diagnostics in the container service cluster.
        :paramtype diagnostics_profile:
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceDiagnosticsProfile
        """
        super(ContainerService, self).__init__(location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.orchestrator_profile = orchestrator_profile
        self.custom_profile = custom_profile
        self.service_principal_profile = service_principal_profile
        self.master_profile = master_profile
        self.agent_pool_profiles = agent_pool_profiles
        self.windows_profile = windows_profile
        self.linux_profile = linux_profile
        self.diagnostics_profile = diagnostics_profile


class ContainerServiceAgentPoolProfile(msrest.serialization.Model):
    """Profile for the container service agent pool.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar name: Required. Unique name of the agent pool profile in the context of the subscription
     and resource group.
    :vartype name: str
    :ivar count: Number of agents (VMs) to host docker containers. Allowed values must be in the
     range of 1 to 100 (inclusive). The default value is 1.
    :vartype count: int
    :ivar vm_size: Required. Size of agent VMs. Possible values include: "Standard_A1",
     "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2",
     "Standard_A2m_v2", "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2",
     "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2",
     "Standard_A8m_v2", "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms",
     "Standard_B8ms", "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo",
     "Standard_D12", "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar dns_prefix: DNS prefix to be used to create the FQDN for the agent pool.
    :vartype dns_prefix: str
    :ivar fqdn: FQDN for the agent pool.
    :vartype fqdn: str
    :ivar ports: Ports number array used to expose on this agent pool. The default opened ports are
     different based on your choice of orchestrator.
    :vartype ports: list[int]
    :ivar storage_profile: Storage profile specifies what kind of storage used. Choose from
     StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
     orchestrator choice. Possible values include: "StorageAccount", "ManagedDisks".
    :vartype storage_profile: str or
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceStorageProfileTypes
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :vartype vnet_subnet_id: str
    :ivar os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default to
     Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
    :vartype os_type: str or ~azure.mgmt.containerservice.v2017_07_01.models.OSType
    """

    _validation = {
        'name': {'required': True},
        'count': {'maximum': 100, 'minimum': 1},
        'vm_size': {'required': True},
        'os_disk_size_gb': {'maximum': 1023, 'minimum': 0},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'dns_prefix': {'key': 'dnsPrefix', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
        'ports': {'key': 'ports', 'type': '[int]'},
        'storage_profile': {'key': 'storageProfile', 'type': 'str'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        vm_size: Union[str, "ContainerServiceVMSizeTypes"],
        count: Optional[int] = 1,
        os_disk_size_gb: Optional[int] = None,
        dns_prefix: Optional[str] = None,
        ports: Optional[List[int]] = None,
        storage_profile: Optional[Union[str, "ContainerServiceStorageProfileTypes"]] = None,
        vnet_subnet_id: Optional[str] = None,
        os_type: Optional[Union[str, "OSType"]] = "Linux",
        **kwargs
    ):
        """
        :keyword name: Required. Unique name of the agent pool profile in the context of the
         subscription and resource group.
        :paramtype name: str
        :keyword count: Number of agents (VMs) to host docker containers. Allowed values must be in the
         range of 1 to 100 (inclusive). The default value is 1.
        :paramtype count: int
        :keyword vm_size: Required. Size of agent VMs. Possible values include: "Standard_A1",
         "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2",
         "Standard_A2m_v2", "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2",
         "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2",
         "Standard_A8m_v2", "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms",
         "Standard_B8ms", "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo",
         "Standard_D12", "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword dns_prefix: DNS prefix to be used to create the FQDN for the agent pool.
        :paramtype dns_prefix: str
        :keyword ports: Ports number array used to expose on this agent pool. The default opened ports
         are different based on your choice of orchestrator.
        :paramtype ports: list[int]
        :keyword storage_profile: Storage profile specifies what kind of storage used. Choose from
         StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
         orchestrator choice. Possible values include: "StorageAccount", "ManagedDisks".
        :paramtype storage_profile: str or
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceStorageProfileTypes
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
        :paramtype vnet_subnet_id: str
        :keyword os_type: OsType to be used to specify os type. Choose from Linux and Windows. Default
         to Linux. Possible values include: "Linux", "Windows". Default value: "Linux".
        :paramtype os_type: str or ~azure.mgmt.containerservice.v2017_07_01.models.OSType
        """
        super(ContainerServiceAgentPoolProfile, self).__init__(**kwargs)
        self.name = name
        self.count = count
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.dns_prefix = dns_prefix
        self.fqdn = None
        self.ports = ports
        self.storage_profile = storage_profile
        self.vnet_subnet_id = vnet_subnet_id
        self.os_type = os_type


class ContainerServiceCustomProfile(msrest.serialization.Model):
    """Properties to configure a custom container service cluster.

    All required parameters must be populated in order to send to Azure.

    :ivar orchestrator: Required. The name of the custom orchestrator to use.
    :vartype orchestrator: str
    """

    _validation = {
        'orchestrator': {'required': True},
    }

    _attribute_map = {
        'orchestrator': {'key': 'orchestrator', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        orchestrator: str,
        **kwargs
    ):
        """
        :keyword orchestrator: Required. The name of the custom orchestrator to use.
        :paramtype orchestrator: str
        """
        super(ContainerServiceCustomProfile, self).__init__(**kwargs)
        self.orchestrator = orchestrator


class ContainerServiceDiagnosticsProfile(msrest.serialization.Model):
    """Profile for diagnostics on the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :ivar vm_diagnostics: Required. Profile for diagnostics on the container service VMs.
    :vartype vm_diagnostics:
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceVMDiagnostics
    """

    _validation = {
        'vm_diagnostics': {'required': True},
    }

    _attribute_map = {
        'vm_diagnostics': {'key': 'vmDiagnostics', 'type': 'ContainerServiceVMDiagnostics'},
    }

    def __init__(
        self,
        *,
        vm_diagnostics: "ContainerServiceVMDiagnostics",
        **kwargs
    ):
        """
        :keyword vm_diagnostics: Required. Profile for diagnostics on the container service VMs.
        :paramtype vm_diagnostics:
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceVMDiagnostics
        """
        super(ContainerServiceDiagnosticsProfile, self).__init__(**kwargs)
        self.vm_diagnostics = vm_diagnostics


class ContainerServiceLinuxProfile(msrest.serialization.Model):
    """Profile for Linux VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :ivar admin_username: Required. The administrator username to use for Linux VMs.
    :vartype admin_username: str
    :ivar ssh: Required. SSH configuration for Linux-based VMs running on Azure.
    :vartype ssh: ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceSshConfiguration
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[A-Za-z][-A-Za-z0-9_]*$'},
        'ssh': {'required': True},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'ssh': {'key': 'ssh', 'type': 'ContainerServiceSshConfiguration'},
    }

    def __init__(
        self,
        *,
        admin_username: str,
        ssh: "ContainerServiceSshConfiguration",
        **kwargs
    ):
        """
        :keyword admin_username: Required. The administrator username to use for Linux VMs.
        :paramtype admin_username: str
        :keyword ssh: Required. SSH configuration for Linux-based VMs running on Azure.
        :paramtype ssh:
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceSshConfiguration
        """
        super(ContainerServiceLinuxProfile, self).__init__(**kwargs)
        self.admin_username = admin_username
        self.ssh = ssh


class ContainerServiceListResult(msrest.serialization.Model):
    """The response from the List Container Services operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of container services.
    :vartype value: list[~azure.mgmt.containerservice.v2017_07_01.models.ContainerService]
    :ivar next_link: The URL to get the next set of container service results.
    :vartype next_link: str
    """

    _validation = {
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ContainerService]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["ContainerService"]] = None,
        **kwargs
    ):
        """
        :keyword value: The list of container services.
        :paramtype value: list[~azure.mgmt.containerservice.v2017_07_01.models.ContainerService]
        """
        super(ContainerServiceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = None


class ContainerServiceMasterProfile(msrest.serialization.Model):
    """Profile for the container service master.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar count: Number of masters (VMs) in the container service cluster. Allowed values are 1, 3,
     and 5. The default value is 1. Possible values include: 1, 3, 5. Default value: "1".
    :vartype count: int or ~azure.mgmt.containerservice.v2017_07_01.models.Count
    :ivar dns_prefix: Required. DNS prefix to be used to create the FQDN for the master pool.
    :vartype dns_prefix: str
    :ivar vm_size: Required. Size of agent VMs. Possible values include: "Standard_A1",
     "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2",
     "Standard_A2m_v2", "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2",
     "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2",
     "Standard_A8m_v2", "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms",
     "Standard_B8ms", "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo",
     "Standard_D12", "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
     "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
     "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
     "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
     "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
     "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
     "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
     "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
     "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
     "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
     "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
     "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
     "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
     "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
     "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
     "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
     "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
     "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
     "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
     "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
     "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
     "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
     "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
     "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
     "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
     "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
     "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
     "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
     "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
     "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
     "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
     "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
    :vartype vm_size: str or
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceVMSizeTypes
    :ivar os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every machine
     in this master/agent pool. If you specify 0, it will apply the default osDisk size according to
     the vmSize specified.
    :vartype os_disk_size_gb: int
    :ivar vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
    :vartype vnet_subnet_id: str
    :ivar first_consecutive_static_ip: FirstConsecutiveStaticIP used to specify the first static ip
     of masters.
    :vartype first_consecutive_static_ip: str
    :ivar storage_profile: Storage profile specifies what kind of storage used. Choose from
     StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
     orchestrator choice. Possible values include: "StorageAccount", "ManagedDisks".
    :vartype storage_profile: str or
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceStorageProfileTypes
    :ivar fqdn: FQDN for the master pool.
    :vartype fqdn: str
    """

    _validation = {
        'dns_prefix': {'required': True},
        'vm_size': {'required': True},
        'os_disk_size_gb': {'maximum': 1023, 'minimum': 0},
        'fqdn': {'readonly': True},
    }

    _attribute_map = {
        'count': {'key': 'count', 'type': 'int'},
        'dns_prefix': {'key': 'dnsPrefix', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'os_disk_size_gb': {'key': 'osDiskSizeGB', 'type': 'int'},
        'vnet_subnet_id': {'key': 'vnetSubnetID', 'type': 'str'},
        'first_consecutive_static_ip': {'key': 'firstConsecutiveStaticIP', 'type': 'str'},
        'storage_profile': {'key': 'storageProfile', 'type': 'str'},
        'fqdn': {'key': 'fqdn', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dns_prefix: str,
        vm_size: Union[str, "ContainerServiceVMSizeTypes"],
        count: Optional[Union[int, "Count"]] = 1,
        os_disk_size_gb: Optional[int] = None,
        vnet_subnet_id: Optional[str] = None,
        first_consecutive_static_ip: Optional[str] = "10.240.255.5",
        storage_profile: Optional[Union[str, "ContainerServiceStorageProfileTypes"]] = None,
        **kwargs
    ):
        """
        :keyword count: Number of masters (VMs) in the container service cluster. Allowed values are 1,
         3, and 5. The default value is 1. Possible values include: 1, 3, 5. Default value: "1".
        :paramtype count: int or ~azure.mgmt.containerservice.v2017_07_01.models.Count
        :keyword dns_prefix: Required. DNS prefix to be used to create the FQDN for the master pool.
        :paramtype dns_prefix: str
        :keyword vm_size: Required. Size of agent VMs. Possible values include: "Standard_A1",
         "Standard_A10", "Standard_A11", "Standard_A1_v2", "Standard_A2", "Standard_A2_v2",
         "Standard_A2m_v2", "Standard_A3", "Standard_A4", "Standard_A4_v2", "Standard_A4m_v2",
         "Standard_A5", "Standard_A6", "Standard_A7", "Standard_A8", "Standard_A8_v2",
         "Standard_A8m_v2", "Standard_A9", "Standard_B2ms", "Standard_B2s", "Standard_B4ms",
         "Standard_B8ms", "Standard_D1", "Standard_D11", "Standard_D11_v2", "Standard_D11_v2_Promo",
         "Standard_D12", "Standard_D12_v2", "Standard_D12_v2_Promo", "Standard_D13", "Standard_D13_v2",
         "Standard_D13_v2_Promo", "Standard_D14", "Standard_D14_v2", "Standard_D14_v2_Promo",
         "Standard_D15_v2", "Standard_D16_v3", "Standard_D16s_v3", "Standard_D1_v2", "Standard_D2",
         "Standard_D2_v2", "Standard_D2_v2_Promo", "Standard_D2_v3", "Standard_D2s_v3", "Standard_D3",
         "Standard_D32_v3", "Standard_D32s_v3", "Standard_D3_v2", "Standard_D3_v2_Promo", "Standard_D4",
         "Standard_D4_v2", "Standard_D4_v2_Promo", "Standard_D4_v3", "Standard_D4s_v3",
         "Standard_D5_v2", "Standard_D5_v2_Promo", "Standard_D64_v3", "Standard_D64s_v3",
         "Standard_D8_v3", "Standard_D8s_v3", "Standard_DS1", "Standard_DS11", "Standard_DS11_v2",
         "Standard_DS11_v2_Promo", "Standard_DS12", "Standard_DS12_v2", "Standard_DS12_v2_Promo",
         "Standard_DS13", "Standard_DS13-2_v2", "Standard_DS13-4_v2", "Standard_DS13_v2",
         "Standard_DS13_v2_Promo", "Standard_DS14", "Standard_DS14-4_v2", "Standard_DS14-8_v2",
         "Standard_DS14_v2", "Standard_DS14_v2_Promo", "Standard_DS15_v2", "Standard_DS1_v2",
         "Standard_DS2", "Standard_DS2_v2", "Standard_DS2_v2_Promo", "Standard_DS3", "Standard_DS3_v2",
         "Standard_DS3_v2_Promo", "Standard_DS4", "Standard_DS4_v2", "Standard_DS4_v2_Promo",
         "Standard_DS5_v2", "Standard_DS5_v2_Promo", "Standard_E16_v3", "Standard_E16s_v3",
         "Standard_E2_v3", "Standard_E2s_v3", "Standard_E32-16s_v3", "Standard_E32-8s_v3",
         "Standard_E32_v3", "Standard_E32s_v3", "Standard_E4_v3", "Standard_E4s_v3",
         "Standard_E64-16s_v3", "Standard_E64-32s_v3", "Standard_E64_v3", "Standard_E64s_v3",
         "Standard_E8_v3", "Standard_E8s_v3", "Standard_F1", "Standard_F16", "Standard_F16s",
         "Standard_F16s_v2", "Standard_F1s", "Standard_F2", "Standard_F2s", "Standard_F2s_v2",
         "Standard_F32s_v2", "Standard_F4", "Standard_F4s", "Standard_F4s_v2", "Standard_F64s_v2",
         "Standard_F72s_v2", "Standard_F8", "Standard_F8s", "Standard_F8s_v2", "Standard_G1",
         "Standard_G2", "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2",
         "Standard_GS3", "Standard_GS4", "Standard_GS4-4", "Standard_GS4-8", "Standard_GS5",
         "Standard_GS5-16", "Standard_GS5-8", "Standard_H16", "Standard_H16m", "Standard_H16mr",
         "Standard_H16r", "Standard_H8", "Standard_H8m", "Standard_L16s", "Standard_L32s",
         "Standard_L4s", "Standard_L8s", "Standard_M128-32ms", "Standard_M128-64ms", "Standard_M128ms",
         "Standard_M128s", "Standard_M64-16ms", "Standard_M64-32ms", "Standard_M64ms", "Standard_M64s",
         "Standard_NC12", "Standard_NC12s_v2", "Standard_NC12s_v3", "Standard_NC24", "Standard_NC24r",
         "Standard_NC24rs_v2", "Standard_NC24rs_v3", "Standard_NC24s_v2", "Standard_NC24s_v3",
         "Standard_NC6", "Standard_NC6s_v2", "Standard_NC6s_v3", "Standard_ND12s", "Standard_ND24rs",
         "Standard_ND24s", "Standard_ND6s", "Standard_NV12", "Standard_NV24", "Standard_NV6".
        :paramtype vm_size: str or
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceVMSizeTypes
        :keyword os_disk_size_gb: OS Disk Size in GB to be used to specify the disk size for every
         machine in this master/agent pool. If you specify 0, it will apply the default osDisk size
         according to the vmSize specified.
        :paramtype os_disk_size_gb: int
        :keyword vnet_subnet_id: VNet SubnetID specifies the VNet's subnet identifier.
        :paramtype vnet_subnet_id: str
        :keyword first_consecutive_static_ip: FirstConsecutiveStaticIP used to specify the first static
         ip of masters.
        :paramtype first_consecutive_static_ip: str
        :keyword storage_profile: Storage profile specifies what kind of storage used. Choose from
         StorageAccount and ManagedDisks. Leave it empty, we will choose for you based on the
         orchestrator choice. Possible values include: "StorageAccount", "ManagedDisks".
        :paramtype storage_profile: str or
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceStorageProfileTypes
        """
        super(ContainerServiceMasterProfile, self).__init__(**kwargs)
        self.count = count
        self.dns_prefix = dns_prefix
        self.vm_size = vm_size
        self.os_disk_size_gb = os_disk_size_gb
        self.vnet_subnet_id = vnet_subnet_id
        self.first_consecutive_static_ip = first_consecutive_static_ip
        self.storage_profile = storage_profile
        self.fqdn = None


class ContainerServiceOrchestratorProfile(msrest.serialization.Model):
    """Profile for the container service orchestrator.

    All required parameters must be populated in order to send to Azure.

    :ivar orchestrator_type: Required. The orchestrator to use to manage container service cluster
     resources. Valid values are Kubernetes, Swarm, DCOS, DockerCE and Custom. Possible values
     include: "Kubernetes", "Swarm", "DCOS", "DockerCE", "Custom".
    :vartype orchestrator_type: str or
     ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceOrchestratorTypes
    :ivar orchestrator_version: The version of the orchestrator to use. You can specify the
     major.minor.patch part of the actual version.For example, you can specify version as "1.6.11".
    :vartype orchestrator_version: str
    """

    _validation = {
        'orchestrator_type': {'required': True},
    }

    _attribute_map = {
        'orchestrator_type': {'key': 'orchestratorType', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        orchestrator_type: Union[str, "ContainerServiceOrchestratorTypes"],
        orchestrator_version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword orchestrator_type: Required. The orchestrator to use to manage container service
         cluster resources. Valid values are Kubernetes, Swarm, DCOS, DockerCE and Custom. Possible
         values include: "Kubernetes", "Swarm", "DCOS", "DockerCE", "Custom".
        :paramtype orchestrator_type: str or
         ~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceOrchestratorTypes
        :keyword orchestrator_version: The version of the orchestrator to use. You can specify the
         major.minor.patch part of the actual version.For example, you can specify version as "1.6.11".
        :paramtype orchestrator_version: str
        """
        super(ContainerServiceOrchestratorProfile, self).__init__(**kwargs)
        self.orchestrator_type = orchestrator_type
        self.orchestrator_version = orchestrator_version


class ContainerServicePrincipalProfile(msrest.serialization.Model):
    """Information about a service principal identity for the cluster to use for manipulating Azure APIs. Either secret or keyVaultSecretRef must be specified.

    All required parameters must be populated in order to send to Azure.

    :ivar client_id: Required. The ID for the service principal.
    :vartype client_id: str
    :ivar secret: The secret password associated with the service principal in plain text.
    :vartype secret: str
    :ivar key_vault_secret_ref: Reference to a secret stored in Azure Key Vault.
    :vartype key_vault_secret_ref:
     ~azure.mgmt.containerservice.v2017_07_01.models.KeyVaultSecretRef
    """

    _validation = {
        'client_id': {'required': True},
    }

    _attribute_map = {
        'client_id': {'key': 'clientId', 'type': 'str'},
        'secret': {'key': 'secret', 'type': 'str'},
        'key_vault_secret_ref': {'key': 'keyVaultSecretRef', 'type': 'KeyVaultSecretRef'},
    }

    def __init__(
        self,
        *,
        client_id: str,
        secret: Optional[str] = None,
        key_vault_secret_ref: Optional["KeyVaultSecretRef"] = None,
        **kwargs
    ):
        """
        :keyword client_id: Required. The ID for the service principal.
        :paramtype client_id: str
        :keyword secret: The secret password associated with the service principal in plain text.
        :paramtype secret: str
        :keyword key_vault_secret_ref: Reference to a secret stored in Azure Key Vault.
        :paramtype key_vault_secret_ref:
         ~azure.mgmt.containerservice.v2017_07_01.models.KeyVaultSecretRef
        """
        super(ContainerServicePrincipalProfile, self).__init__(**kwargs)
        self.client_id = client_id
        self.secret = secret
        self.key_vault_secret_ref = key_vault_secret_ref


class ContainerServiceSshConfiguration(msrest.serialization.Model):
    """SSH configuration for Linux-based VMs running on Azure.

    All required parameters must be populated in order to send to Azure.

    :ivar public_keys: Required. The list of SSH public keys used to authenticate with Linux-based
     VMs. Only expect one key specified.
    :vartype public_keys:
     list[~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceSshPublicKey]
    """

    _validation = {
        'public_keys': {'required': True},
    }

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[ContainerServiceSshPublicKey]'},
    }

    def __init__(
        self,
        *,
        public_keys: List["ContainerServiceSshPublicKey"],
        **kwargs
    ):
        """
        :keyword public_keys: Required. The list of SSH public keys used to authenticate with
         Linux-based VMs. Only expect one key specified.
        :paramtype public_keys:
         list[~azure.mgmt.containerservice.v2017_07_01.models.ContainerServiceSshPublicKey]
        """
        super(ContainerServiceSshConfiguration, self).__init__(**kwargs)
        self.public_keys = public_keys


class ContainerServiceSshPublicKey(msrest.serialization.Model):
    """Contains information about SSH certificate public key data.

    All required parameters must be populated in order to send to Azure.

    :ivar key_data: Required. Certificate public key used to authenticate with VMs through SSH. The
     certificate must be in PEM format with or without headers.
    :vartype key_data: str
    """

    _validation = {
        'key_data': {'required': True},
    }

    _attribute_map = {
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        key_data: str,
        **kwargs
    ):
        """
        :keyword key_data: Required. Certificate public key used to authenticate with VMs through SSH.
         The certificate must be in PEM format with or without headers.
        :paramtype key_data: str
        """
        super(ContainerServiceSshPublicKey, self).__init__(**kwargs)
        self.key_data = key_data


class ContainerServiceVMDiagnostics(msrest.serialization.Model):
    """Profile for diagnostics on the container service VMs.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar enabled: Required. Whether the VM diagnostic agent is provisioned on the VM.
    :vartype enabled: bool
    :ivar storage_uri: The URI of the storage account where diagnostics are stored.
    :vartype storage_uri: str
    """

    _validation = {
        'enabled': {'required': True},
        'storage_uri': {'readonly': True},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: bool,
        **kwargs
    ):
        """
        :keyword enabled: Required. Whether the VM diagnostic agent is provisioned on the VM.
        :paramtype enabled: bool
        """
        super(ContainerServiceVMDiagnostics, self).__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = None


class ContainerServiceWindowsProfile(msrest.serialization.Model):
    """Profile for Windows VMs in the container service cluster.

    All required parameters must be populated in order to send to Azure.

    :ivar admin_username: Required. The administrator username to use for Windows VMs.
    :vartype admin_username: str
    :ivar admin_password: Required. The administrator password to use for Windows VMs.
    :vartype admin_password: str
    """

    _validation = {
        'admin_username': {'required': True, 'pattern': r'^[a-zA-Z0-9]+([._]?[a-zA-Z0-9]+)*$'},
        'admin_password': {'required': True, 'pattern': r'^(?=.*[a-z])(?=.*[A-Z])(?=.*[!@#$%\^&\*\(\)])[a-zA-Z\d!@#$%\^&\*\(\)]{12,123}$'},
    }

    _attribute_map = {
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        admin_username: str,
        admin_password: str,
        **kwargs
    ):
        """
        :keyword admin_username: Required. The administrator username to use for Windows VMs.
        :paramtype admin_username: str
        :keyword admin_password: Required. The administrator password to use for Windows VMs.
        :paramtype admin_password: str
        """
        super(ContainerServiceWindowsProfile, self).__init__(**kwargs)
        self.admin_username = admin_username
        self.admin_password = admin_password


class KeyVaultSecretRef(msrest.serialization.Model):
    """Reference to a secret stored in Azure Key Vault.

    All required parameters must be populated in order to send to Azure.

    :ivar vault_id: Required. Key vault identifier.
    :vartype vault_id: str
    :ivar secret_name: Required. The secret name.
    :vartype secret_name: str
    :ivar version: The secret version.
    :vartype version: str
    """

    _validation = {
        'vault_id': {'required': True},
        'secret_name': {'required': True},
    }

    _attribute_map = {
        'vault_id': {'key': 'vaultID', 'type': 'str'},
        'secret_name': {'key': 'secretName', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vault_id: str,
        secret_name: str,
        version: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword vault_id: Required. Key vault identifier.
        :paramtype vault_id: str
        :keyword secret_name: Required. The secret name.
        :paramtype secret_name: str
        :keyword version: The secret version.
        :paramtype version: str
        """
        super(KeyVaultSecretRef, self).__init__(**kwargs)
        self.vault_id = vault_id
        self.secret_name = secret_name
        self.version = version


class OrchestratorProfile(msrest.serialization.Model):
    """Contains information about orchestrator.

    All required parameters must be populated in order to send to Azure.

    :ivar orchestrator_type: Orchestrator type.
    :vartype orchestrator_type: str
    :ivar orchestrator_version: Required. Orchestrator version (major, minor, patch).
    :vartype orchestrator_version: str
    :ivar is_preview: Whether Kubernetes version is currently in preview.
    :vartype is_preview: bool
    """

    _validation = {
        'orchestrator_version': {'required': True},
    }

    _attribute_map = {
        'orchestrator_type': {'key': 'orchestratorType', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        orchestrator_version: str,
        orchestrator_type: Optional[str] = None,
        is_preview: Optional[bool] = None,
        **kwargs
    ):
        """
        :keyword orchestrator_type: Orchestrator type.
        :paramtype orchestrator_type: str
        :keyword orchestrator_version: Required. Orchestrator version (major, minor, patch).
        :paramtype orchestrator_version: str
        :keyword is_preview: Whether Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        """
        super(OrchestratorProfile, self).__init__(**kwargs)
        self.orchestrator_type = orchestrator_type
        self.orchestrator_version = orchestrator_version
        self.is_preview = is_preview


class OrchestratorVersionProfile(msrest.serialization.Model):
    """The profile of an orchestrator and its available versions.

    All required parameters must be populated in order to send to Azure.

    :ivar orchestrator_type: Required. Orchestrator type.
    :vartype orchestrator_type: str
    :ivar orchestrator_version: Required. Orchestrator version (major, minor, patch).
    :vartype orchestrator_version: str
    :ivar default: Installed by default if version is not specified.
    :vartype default: bool
    :ivar is_preview: Whether Kubernetes version is currently in preview.
    :vartype is_preview: bool
    :ivar upgrades: The list of available upgrade versions.
    :vartype upgrades: list[~azure.mgmt.containerservice.v2017_07_01.models.OrchestratorProfile]
    """

    _validation = {
        'orchestrator_type': {'required': True},
        'orchestrator_version': {'required': True},
    }

    _attribute_map = {
        'orchestrator_type': {'key': 'orchestratorType', 'type': 'str'},
        'orchestrator_version': {'key': 'orchestratorVersion', 'type': 'str'},
        'default': {'key': 'default', 'type': 'bool'},
        'is_preview': {'key': 'isPreview', 'type': 'bool'},
        'upgrades': {'key': 'upgrades', 'type': '[OrchestratorProfile]'},
    }

    def __init__(
        self,
        *,
        orchestrator_type: str,
        orchestrator_version: str,
        default: Optional[bool] = None,
        is_preview: Optional[bool] = None,
        upgrades: Optional[List["OrchestratorProfile"]] = None,
        **kwargs
    ):
        """
        :keyword orchestrator_type: Required. Orchestrator type.
        :paramtype orchestrator_type: str
        :keyword orchestrator_version: Required. Orchestrator version (major, minor, patch).
        :paramtype orchestrator_version: str
        :keyword default: Installed by default if version is not specified.
        :paramtype default: bool
        :keyword is_preview: Whether Kubernetes version is currently in preview.
        :paramtype is_preview: bool
        :keyword upgrades: The list of available upgrade versions.
        :paramtype upgrades: list[~azure.mgmt.containerservice.v2017_07_01.models.OrchestratorProfile]
        """
        super(OrchestratorVersionProfile, self).__init__(**kwargs)
        self.orchestrator_type = orchestrator_type
        self.orchestrator_version = orchestrator_version
        self.default = default
        self.is_preview = is_preview
        self.upgrades = upgrades


class OrchestratorVersionProfileListResult(msrest.serialization.Model):
    """The list of versions for supported orchestrators.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Id of the orchestrator version profile list result.
    :vartype id: str
    :ivar name: Name of the orchestrator version profile list result.
    :vartype name: str
    :ivar type: Type of the orchestrator version profile list result.
    :vartype type: str
    :ivar orchestrators: Required. List of orchestrator version profiles.
    :vartype orchestrators:
     list[~azure.mgmt.containerservice.v2017_07_01.models.OrchestratorVersionProfile]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'orchestrators': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'orchestrators': {'key': 'properties.orchestrators', 'type': '[OrchestratorVersionProfile]'},
    }

    def __init__(
        self,
        *,
        orchestrators: List["OrchestratorVersionProfile"],
        **kwargs
    ):
        """
        :keyword orchestrators: Required. List of orchestrator version profiles.
        :paramtype orchestrators:
         list[~azure.mgmt.containerservice.v2017_07_01.models.OrchestratorVersionProfile]
        """
        super(OrchestratorVersionProfileListResult, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.orchestrators = orchestrators
